/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationStatement", profile="http://hl7.org/fhir/StructureDefinition/MedicationStatement")
public class MedicationStatement
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier", formalDefinition="Identifiers associated with this Medication Statement that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="partOf", type={Procedure.class, MedicationStatement.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular MedicationStatement is a component or step.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="recorded | entered-in-error | draft", formalDefinition="A code representing the status of recording the medication statement.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-statement-status")
    protected Enumeration<MedicationStatementStatusCodes> status;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type of medication statement", formalDefinition="Type of medication statement (for example, drug classification like ATC, where meds would be administered, legal category of the medication.).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationrequest-admin-location")
    protected List<CodeableConcept> category;
    @Child(name="medication", type={CodeableReference.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What medication was taken", formalDefinition="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected CodeableReference medication;
    @Child(name="subject", type={Patient.class, Group.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is/was taking  the medication", formalDefinition="The person, animal or group who is/was taking the medication.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter associated with MedicationStatement", formalDefinition="The encounter that establishes the context for this MedicationStatement.")
    protected Reference encounter;
    @Child(name="effective", type={DateTimeType.class, Period.class, Timing.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date/time or interval when the medication is/was/will be taken", formalDefinition="The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking, when the MedicationStatement.adherence element is Not Taking).")
    protected DataType effective;
    @Child(name="dateAsserted", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the usage was asserted?", formalDefinition="The date when the Medication Statement was asserted by the information source.")
    protected DateTimeType dateAsserted;
    @Child(name="informationSource", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Organization.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Person or organization that provided the information about the taking of this medication", formalDefinition="The person or organization that provided the information about the taking of this medication. Note: Use derivedFrom when a MedicationStatement is derived from other resources, e.g. Claim or MedicationRequest.")
    protected List<Reference> informationSource;
    @Child(name="derivedFrom", type={Reference.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Link to information used to derive the MedicationStatement", formalDefinition="Allows linking the MedicationStatement to the underlying MedicationRequest, or to other information that supports or is used to derive the MedicationStatement.")
    protected List<Reference> derivedFrom;
    @Child(name="reason", type={CodeableReference.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for why the medication is being/was taken", formalDefinition="A concept, Condition or observation that supports why the medication is being/was taken.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected List<CodeableReference> reason;
    @Child(name="note", type={Annotation.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Further information about the usage", formalDefinition="Provides extra information about the Medication Statement that is not conveyed by the other attributes.")
    protected List<Annotation> note;
    @Child(name="relatedClinicalInformation", type={Observation.class, Condition.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Link to information relevant to the usage of a medication", formalDefinition="Link to information that is relevant to a medication statement, for example, illicit drug use, gestational age, etc.")
    protected List<Reference> relatedClinicalInformation;
    @Child(name="renderedDosageInstruction", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Full representation of the dosage instructions", formalDefinition="The full representation of the dose of the medication included in all dosage instructions.  To be used when multiple dosage instructions are included to represent complex dosing such as increasing or tapering doses.")
    protected MarkdownType renderedDosageInstruction;
    @Child(name="dosage", type={Dosage.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details of how medication is/was taken or should be taken", formalDefinition="Indicates how the medication is/was or should be taken by the patient.")
    protected List<Dosage> dosage;
    @Child(name="adherence", type={}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Indicates whether the medication is or is not being consumed or administered", formalDefinition="Indicates whether the medication is or is not being consumed or administered.")
    protected MedicationStatementAdherenceComponent adherence;
    private static final long serialVersionUID = -1043616866L;
    @SearchParamDefinition(name="adherence", path="MedicationStatement.adherence.code", description="Returns statements based on adherence or compliance", type="token")
    public static final String SP_ADHERENCE = "adherence";
    public static final TokenClientParam ADHERENCE = new TokenClientParam("adherence");
    @SearchParamDefinition(name="category", path="MedicationStatement.category", description="Returns statements of this category of MedicationStatement", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="effective", path="MedicationStatement.effective.ofType(dateTime) | MedicationStatement.effective.ofType(Period)", description="Date when patient was taking (or not taking) the medication", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="source", path="MedicationStatement.informationSource", description="Who or where the information in the statement came from", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("MedicationStatement:source").toLocked();
    @SearchParamDefinition(name="subject", path="MedicationStatement.subject", description="The identity of a patient, animal or group to list statements for", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicationStatement:subject").toLocked();
    @SearchParamDefinition(name="code", path="AdverseEvent.code | AllergyIntolerance.code | AllergyIntolerance.reaction.substance | AuditEvent.code | Basic.code | ChargeItem.code | Condition.code | DetectedIssue.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | ImagingSelection.status | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationStatement.medication.concept | NutritionIntake.code | Observation.code | Procedure.code | RequestOrchestration.code | Task.code", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): Event or incident that occurred or was averted\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [AuditEvent](auditevent.html): More specific code for the event\r\n* [Basic](basic.html): Kind of Resource\r\n* [ChargeItem](chargeitem.html): A code that identifies the charge, like a billing code\r\n* [Condition](condition.html): Code for the condition\r\n* [DetectedIssue](detectedissue.html): Issue Type, e.g. drug-drug, duplicate therapy, etc.\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [ImagingSelection](imagingselection.html): The imaging selection status\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [NutritionIntake](nutritionintake.html): Returns statements of this code of NutritionIntake\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [RequestOrchestration](requestorchestration.html): The code of the request orchestration\r\n* [Task](task.html): Search by task code\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="encounter", path="AuditEvent.encounter | CarePlan.encounter | ChargeItem.encounter | Claim.item.encounter | ClinicalImpression.encounter | Communication.encounter | CommunicationRequest.encounter | Composition.encounter | Condition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | EncounterHistory.encounter | ExplanationOfBenefit.item.encounter | Flag.encounter | ImagingStudy.encounter | List.encounter | MedicationDispense.encounter | MedicationStatement.encounter | NutritionIntake.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | Provenance.encounter | QuestionnaireResponse.encounter | RequestOrchestration.encounter | RiskAssessment.encounter | ServiceRequest.encounter | Task.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [AuditEvent](auditevent.html): Encounter related to the activity recorded in the AuditEvent\r\n* [CarePlan](careplan.html): The Encounter during which this CarePlan was created\r\n* [ChargeItem](chargeitem.html): Encounter associated with event\r\n* [Claim](claim.html): Encounters associated with a billed line item\r\n* [ClinicalImpression](clinicalimpression.html): The Encounter during which this ClinicalImpression was created\r\n* [Communication](communication.html): The Encounter during which this Communication was created\r\n* [CommunicationRequest](communicationrequest.html): The Encounter during which this CommunicationRequest was created\r\n* [Composition](composition.html): Context of the Composition\r\n* [Condition](condition.html): The Encounter during which this Condition was created\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [EncounterHistory](encounterhistory.html): The Encounter associated with this set of history values\r\n* [ExplanationOfBenefit](explanationofbenefit.html): Encounters associated with a billed line item\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [ImagingStudy](imagingstudy.html): The context of the study\r\n* [List](list.html): Context in which list created\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with a specific encounter\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific encounter\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific encounter\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [Provenance](provenance.html): Encounter related to the Provenance\r\n* [QuestionnaireResponse](questionnaireresponse.html): Encounter associated with the questionnaire response\r\n* [RequestOrchestration](requestorchestration.html): The encounter the request orchestration applies to\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [Task](task.html): Search by encounter\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("MedicationStatement:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationStatement:patient").toLocked();
    @SearchParamDefinition(name="medication", path="MedicationAdministration.medication.reference | MedicationDispense.medication.reference | MedicationRequest.medication.reference | MedicationStatement.medication.reference", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication reference\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine resource\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions for this medication reference\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication reference\r\n", type="reference", target={Medication.class})
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationStatement:medication").toLocked();
    @SearchParamDefinition(name="status", path="MedicationAdministration.status | MedicationDispense.status | MedicationRequest.status | MedicationStatement.status", description="Multiple Resources: \r\n\r\n* [MedicationAdministration](medicationadministration.html): MedicationAdministration event status (for example one of active/paused/completed/nullified)\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with a specified dispense status\r\n* [MedicationRequest](medicationrequest.html): Status of the prescription\r\n* [MedicationStatement](medicationstatement.html): Return statements that match the given status\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public MedicationStatement() {
    }

    public MedicationStatement(MedicationStatementStatusCodes status, CodeableReference medication, Reference subject) {
        this.setStatus(status);
        this.setMedication(medication);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationStatement setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationStatement addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public MedicationStatement setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public MedicationStatement addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<MedicationStatementStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationStatementStatusCodes>(new MedicationStatementStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationStatement setStatusElement(Enumeration<MedicationStatementStatusCodes> value) {
        this.status = value;
        return this;
    }

    public MedicationStatementStatusCodes getStatus() {
        return this.status == null ? null : (MedicationStatementStatusCodes)((Object)this.status.getValue());
    }

    public MedicationStatement setStatus(MedicationStatementStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<MedicationStatementStatusCodes>(new MedicationStatementStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public MedicationStatement setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public MedicationStatement addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableReference getMedication() {
        if (this.medication == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.medication");
            }
            if (Configuration.doAutoCreate()) {
                this.medication = new CodeableReference();
            }
        }
        return this.medication;
    }

    public boolean hasMedication() {
        return this.medication != null && !this.medication.isEmpty();
    }

    public MedicationStatement setMedication(CodeableReference value) {
        this.medication = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public MedicationStatement setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public MedicationStatement setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (this.effective == null) {
            this.effective = new DateTimeType();
        }
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this != null && this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (this.effective == null) {
            this.effective = new Period();
        }
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this != null && this.effective instanceof Period;
    }

    public Timing getEffectiveTiming() throws FHIRException {
        if (this.effective == null) {
            this.effective = new Timing();
        }
        if (!(this.effective instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Timing)this.effective;
    }

    public boolean hasEffectiveTiming() {
        return this != null && this.effective instanceof Timing;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public MedicationStatement setEffective(DataType value) {
        if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Timing)) {
            throw new FHIRException("Not the right type for MedicationStatement.effective[x]: " + value.fhirType());
        }
        this.effective = value;
        return this;
    }

    public DateTimeType getDateAssertedElement() {
        if (this.dateAsserted == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.dateAsserted");
            }
            if (Configuration.doAutoCreate()) {
                this.dateAsserted = new DateTimeType();
            }
        }
        return this.dateAsserted;
    }

    public boolean hasDateAssertedElement() {
        return this.dateAsserted != null && !this.dateAsserted.isEmpty();
    }

    public boolean hasDateAsserted() {
        return this.dateAsserted != null && !this.dateAsserted.isEmpty();
    }

    public MedicationStatement setDateAssertedElement(DateTimeType value) {
        this.dateAsserted = value;
        return this;
    }

    public Date getDateAsserted() {
        return this.dateAsserted == null ? null : (Date)this.dateAsserted.getValue();
    }

    public MedicationStatement setDateAsserted(Date value) {
        if (value == null) {
            this.dateAsserted = null;
        } else {
            if (this.dateAsserted == null) {
                this.dateAsserted = new DateTimeType();
            }
            this.dateAsserted.setValue(value);
        }
        return this;
    }

    public List<Reference> getInformationSource() {
        if (this.informationSource == null) {
            this.informationSource = new ArrayList<Reference>();
        }
        return this.informationSource;
    }

    public MedicationStatement setInformationSource(List<Reference> theInformationSource) {
        this.informationSource = theInformationSource;
        return this;
    }

    public boolean hasInformationSource() {
        if (this.informationSource == null) {
            return false;
        }
        for (Reference item : this.informationSource) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addInformationSource() {
        Reference t = new Reference();
        if (this.informationSource == null) {
            this.informationSource = new ArrayList<Reference>();
        }
        this.informationSource.add(t);
        return t;
    }

    public MedicationStatement addInformationSource(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.informationSource == null) {
            this.informationSource = new ArrayList<Reference>();
        }
        this.informationSource.add(t);
        return this;
    }

    public Reference getInformationSourceFirstRep() {
        if (this.getInformationSource().isEmpty()) {
            this.addInformationSource();
        }
        return this.getInformationSource().get(0);
    }

    public List<Reference> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        return this.derivedFrom;
    }

    public MedicationStatement setDerivedFrom(List<Reference> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (Reference item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDerivedFrom() {
        Reference t = new Reference();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public MedicationStatement addDerivedFrom(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public Reference getDerivedFromFirstRep() {
        if (this.getDerivedFrom().isEmpty()) {
            this.addDerivedFrom();
        }
        return this.getDerivedFrom().get(0);
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public MedicationStatement setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public MedicationStatement addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public MedicationStatement setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public MedicationStatement addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getRelatedClinicalInformation() {
        if (this.relatedClinicalInformation == null) {
            this.relatedClinicalInformation = new ArrayList<Reference>();
        }
        return this.relatedClinicalInformation;
    }

    public MedicationStatement setRelatedClinicalInformation(List<Reference> theRelatedClinicalInformation) {
        this.relatedClinicalInformation = theRelatedClinicalInformation;
        return this;
    }

    public boolean hasRelatedClinicalInformation() {
        if (this.relatedClinicalInformation == null) {
            return false;
        }
        for (Reference item : this.relatedClinicalInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRelatedClinicalInformation() {
        Reference t = new Reference();
        if (this.relatedClinicalInformation == null) {
            this.relatedClinicalInformation = new ArrayList<Reference>();
        }
        this.relatedClinicalInformation.add(t);
        return t;
    }

    public MedicationStatement addRelatedClinicalInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.relatedClinicalInformation == null) {
            this.relatedClinicalInformation = new ArrayList<Reference>();
        }
        this.relatedClinicalInformation.add(t);
        return this;
    }

    public Reference getRelatedClinicalInformationFirstRep() {
        if (this.getRelatedClinicalInformation().isEmpty()) {
            this.addRelatedClinicalInformation();
        }
        return this.getRelatedClinicalInformation().get(0);
    }

    public MarkdownType getRenderedDosageInstructionElement() {
        if (this.renderedDosageInstruction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.renderedDosageInstruction");
            }
            if (Configuration.doAutoCreate()) {
                this.renderedDosageInstruction = new MarkdownType();
            }
        }
        return this.renderedDosageInstruction;
    }

    public boolean hasRenderedDosageInstructionElement() {
        return this.renderedDosageInstruction != null && !this.renderedDosageInstruction.isEmpty();
    }

    public boolean hasRenderedDosageInstruction() {
        return this.renderedDosageInstruction != null && !this.renderedDosageInstruction.isEmpty();
    }

    public MedicationStatement setRenderedDosageInstructionElement(MarkdownType value) {
        this.renderedDosageInstruction = value;
        return this;
    }

    public String getRenderedDosageInstruction() {
        return this.renderedDosageInstruction == null ? null : (String)this.renderedDosageInstruction.getValue();
    }

    public MedicationStatement setRenderedDosageInstruction(String value) {
        if (Utilities.noString((String)value)) {
            this.renderedDosageInstruction = null;
        } else {
            if (this.renderedDosageInstruction == null) {
                this.renderedDosageInstruction = new MarkdownType();
            }
            this.renderedDosageInstruction.setValue(value);
        }
        return this;
    }

    public List<Dosage> getDosage() {
        if (this.dosage == null) {
            this.dosage = new ArrayList<Dosage>();
        }
        return this.dosage;
    }

    public MedicationStatement setDosage(List<Dosage> theDosage) {
        this.dosage = theDosage;
        return this;
    }

    public boolean hasDosage() {
        if (this.dosage == null) {
            return false;
        }
        for (Dosage item : this.dosage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Dosage addDosage() {
        Dosage t = new Dosage();
        if (this.dosage == null) {
            this.dosage = new ArrayList<Dosage>();
        }
        this.dosage.add(t);
        return t;
    }

    public MedicationStatement addDosage(Dosage t) {
        if (t == null) {
            return this;
        }
        if (this.dosage == null) {
            this.dosage = new ArrayList<Dosage>();
        }
        this.dosage.add(t);
        return this;
    }

    public Dosage getDosageFirstRep() {
        if (this.getDosage().isEmpty()) {
            this.addDosage();
        }
        return this.getDosage().get(0);
    }

    public MedicationStatementAdherenceComponent getAdherence() {
        if (this.adherence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.adherence");
            }
            if (Configuration.doAutoCreate()) {
                this.adherence = new MedicationStatementAdherenceComponent();
            }
        }
        return this.adherence;
    }

    public boolean hasAdherence() {
        return this.adherence != null && !this.adherence.isEmpty();
    }

    public MedicationStatement setAdherence(MedicationStatementAdherenceComponent value) {
        this.adherence = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Medication Statement that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("partOf", "Reference(Procedure|MedicationStatement)", "A larger event of which this particular MedicationStatement is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, SP_CODE, "A code representing the status of recording the medication statement.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Type of medication statement (for example, drug classification like ATC, where meds would be administered, legal category of the medication.).", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_MEDICATION, "CodeableReference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person, animal or group who is/was taking the medication.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter that establishes the context for this MedicationStatement.", 0, 1, this.encounter));
        children.add(new Property("effective[x]", "dateTime|Period|Timing", "The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking, when the MedicationStatement.adherence element is Not Taking).", 0, 1, this.effective));
        children.add(new Property("dateAsserted", "dateTime", "The date when the Medication Statement was asserted by the information source.", 0, 1, this.dateAsserted));
        children.add(new Property("informationSource", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "The person or organization that provided the information about the taking of this medication. Note: Use derivedFrom when a MedicationStatement is derived from other resources, e.g. Claim or MedicationRequest.", 0, Integer.MAX_VALUE, this.informationSource));
        children.add(new Property("derivedFrom", "Reference(Any)", "Allows linking the MedicationStatement to the underlying MedicationRequest, or to other information that supports or is used to derive the MedicationStatement.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport)", "A concept, Condition or observation that supports why the medication is being/was taken.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("note", "Annotation", "Provides extra information about the Medication Statement that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("relatedClinicalInformation", "Reference(Observation|Condition)", "Link to information that is relevant to a medication statement, for example, illicit drug use, gestational age, etc.", 0, Integer.MAX_VALUE, this.relatedClinicalInformation));
        children.add(new Property("renderedDosageInstruction", "markdown", "The full representation of the dose of the medication included in all dosage instructions.  To be used when multiple dosage instructions are included to represent complex dosing such as increasing or tapering doses.", 0, 1, this.renderedDosageInstruction));
        children.add(new Property("dosage", "Dosage", "Indicates how the medication is/was or should be taken by the patient.", 0, Integer.MAX_VALUE, this.dosage));
        children.add(new Property(SP_ADHERENCE, "", "Indicates whether the medication is or is not being consumed or administered.", 0, 1, this.adherence));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Medication Statement that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Procedure|MedicationStatement)", "A larger event of which this particular MedicationStatement is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code representing the status of recording the medication statement.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Type of medication statement (for example, drug classification like ATC, where meds would be administered, legal category of the medication.).", 0, Integer.MAX_VALUE, this.category);
            }
            case 1998965455: {
                return new Property(SP_MEDICATION, "CodeableReference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, 1, this.medication);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The person, animal or group who is/was taking the medication.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter that establishes the context for this MedicationStatement.", 0, 1, this.encounter);
            }
            case 247104889: {
                return new Property("effective[x]", "dateTime|Period|Timing", "The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking, when the MedicationStatement.adherence element is Not Taking).", 0, 1, this.effective);
            }
            case -1468651097: {
                return new Property("effective[x]", "dateTime|Period|Timing", "The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking, when the MedicationStatement.adherence element is Not Taking).", 0, 1, this.effective);
            }
            case -275306910: {
                return new Property("effective[x]", "dateTime", "The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking, when the MedicationStatement.adherence element is Not Taking).", 0, 1, this.effective);
            }
            case -403934648: {
                return new Property("effective[x]", "Period", "The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking, when the MedicationStatement.adherence element is Not Taking).", 0, 1, this.effective);
            }
            case -285872943: {
                return new Property("effective[x]", "Timing", "The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking, when the MedicationStatement.adherence element is Not Taking).", 0, 1, this.effective);
            }
            case -1980855245: {
                return new Property("dateAsserted", "dateTime", "The date when the Medication Statement was asserted by the information source.", 0, 1, this.dateAsserted);
            }
            case -2123220889: {
                return new Property("informationSource", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "The person or organization that provided the information about the taking of this medication. Note: Use derivedFrom when a MedicationStatement is derived from other resources, e.g. Claim or MedicationRequest.", 0, Integer.MAX_VALUE, this.informationSource);
            }
            case 1077922663: {
                return new Property("derivedFrom", "Reference(Any)", "Allows linking the MedicationStatement to the underlying MedicationRequest, or to other information that supports or is used to derive the MedicationStatement.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport)", "A concept, Condition or observation that supports why the medication is being/was taken.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Provides extra information about the Medication Statement that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1040787950: {
                return new Property("relatedClinicalInformation", "Reference(Observation|Condition)", "Link to information that is relevant to a medication statement, for example, illicit drug use, gestational age, etc.", 0, Integer.MAX_VALUE, this.relatedClinicalInformation);
            }
            case 1718902050: {
                return new Property("renderedDosageInstruction", "markdown", "The full representation of the dose of the medication included in all dosage instructions.  To be used when multiple dosage instructions are included to represent complex dosing such as increasing or tapering doses.", 0, 1, this.renderedDosageInstruction);
            }
            case -1326018889: {
                return new Property("dosage", "Dosage", "Indicates how the medication is/was or should be taken by the patient.", 0, Integer.MAX_VALUE, this.dosage);
            }
            case -231003683: {
                return new Property(SP_ADHERENCE, "", "Indicates whether the medication is or is not being consumed or administered.", 0, 1, this.adherence);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 1998965455: {
                Base[] baseArray;
                if (this.medication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.medication;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.encounter;
                }
                return baseArray;
            }
            case -1468651097: {
                Base[] baseArray;
                if (this.effective == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.effective;
                }
                return baseArray;
            }
            case -1980855245: {
                Base[] baseArray;
                if (this.dateAsserted == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.dateAsserted;
                }
                return baseArray;
            }
            case -2123220889: {
                return this.informationSource == null ? new Base[]{} : this.informationSource.toArray(new Base[this.informationSource.size()]);
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1040787950: {
                return this.relatedClinicalInformation == null ? new Base[]{} : this.relatedClinicalInformation.toArray(new Base[this.relatedClinicalInformation.size()]);
            }
            case 1718902050: {
                Base[] baseArray;
                if (this.renderedDosageInstruction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.renderedDosageInstruction;
                }
                return baseArray;
            }
            case -1326018889: {
                return this.dosage == null ? new Base[]{} : this.dosage.toArray(new Base[this.dosage.size()]);
            }
            case -231003683: {
                Base[] baseArray;
                if (this.adherence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.adherence;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new MedicationStatementStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1998965455: {
                this.medication = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1468651097: {
                this.effective = TypeConvertor.castToType(value);
                return value;
            }
            case -1980855245: {
                this.dateAsserted = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -2123220889: {
                this.getInformationSource().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 1040787950: {
                this.getRelatedClinicalInformation().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1718902050: {
                this.renderedDosageInstruction = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1326018889: {
                this.getDosage().add(TypeConvertor.castToDosage(value));
                return value;
            }
            case -231003683: {
                this.adherence = (MedicationStatementAdherenceComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationStatementStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_MEDICATION)) {
            this.medication = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("effective[x]")) {
            this.effective = TypeConvertor.castToType(value);
        } else if (name.equals("dateAsserted")) {
            this.dateAsserted = TypeConvertor.castToDateTime(value);
        } else if (name.equals("informationSource")) {
            this.getInformationSource().add(TypeConvertor.castToReference(value));
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(TypeConvertor.castToReference(value));
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("relatedClinicalInformation")) {
            this.getRelatedClinicalInformation().add(TypeConvertor.castToReference(value));
        } else if (name.equals("renderedDosageInstruction")) {
            this.renderedDosageInstruction = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("dosage")) {
            this.getDosage().add(TypeConvertor.castToDosage(value));
        } else if (name.equals(SP_ADHERENCE)) {
            this.adherence = (MedicationStatementAdherenceComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("partOf")) {
            this.getPartOf().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationStatementStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().remove(value);
        } else if (name.equals(SP_MEDICATION)) {
            this.medication = null;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = null;
        } else if (name.equals("effective[x]")) {
            this.effective = null;
        } else if (name.equals("dateAsserted")) {
            this.dateAsserted = null;
        } else if (name.equals("informationSource")) {
            this.getInformationSource().remove(value);
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().remove(value);
        } else if (name.equals("reason")) {
            this.getReason().remove(value);
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else if (name.equals("relatedClinicalInformation")) {
            this.getRelatedClinicalInformation().remove(value);
        } else if (name.equals("renderedDosageInstruction")) {
            this.renderedDosageInstruction = null;
        } else if (name.equals("dosage")) {
            this.getDosage().remove(value);
        } else if (name.equals(SP_ADHERENCE)) {
            this.adherence = (MedicationStatementAdherenceComponent)((Object)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 1998965455: {
                return this.getMedication();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 247104889: {
                return this.getEffective();
            }
            case -1468651097: {
                return this.getEffective();
            }
            case -1980855245: {
                return this.getDateAssertedElement();
            }
            case -2123220889: {
                return this.addInformationSource();
            }
            case 1077922663: {
                return this.addDerivedFrom();
            }
            case -934964668: {
                return this.addReason();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1040787950: {
                return this.addRelatedClinicalInformation();
            }
            case 1718902050: {
                return this.getRenderedDosageInstructionElement();
            }
            case -1326018889: {
                return this.addDosage();
            }
            case -231003683: {
                return this.getAdherence();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 1998965455: {
                return new String[]{"CodeableReference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1468651097: {
                return new String[]{"dateTime", "Period", "Timing"};
            }
            case -1980855245: {
                return new String[]{"dateTime"};
            }
            case -2123220889: {
                return new String[]{"Reference"};
            }
            case 1077922663: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1040787950: {
                return new String[]{"Reference"};
            }
            case 1718902050: {
                return new String[]{"markdown"};
            }
            case -1326018889: {
                return new String[]{"Dosage"};
            }
            case -231003683: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationStatement.status");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_MEDICATION)) {
            this.medication = new CodeableReference();
            return this.medication;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals("effectiveTiming")) {
            this.effective = new Timing();
            return this.effective;
        }
        if (name.equals("dateAsserted")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationStatement.dateAsserted");
        }
        if (name.equals("informationSource")) {
            return this.addInformationSource();
        }
        if (name.equals("derivedFrom")) {
            return this.addDerivedFrom();
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("relatedClinicalInformation")) {
            return this.addRelatedClinicalInformation();
        }
        if (name.equals("renderedDosageInstruction")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationStatement.renderedDosageInstruction");
        }
        if (name.equals("dosage")) {
            return this.addDosage();
        }
        if (name.equals(SP_ADHERENCE)) {
            this.adherence = new MedicationStatementAdherenceComponent();
            return this.adherence;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationStatement";
    }

    @Override
    public MedicationStatement copy() {
        MedicationStatement dst = new MedicationStatement();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicationStatement dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        Enumeration<MedicationStatementStatusCodes> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.medication = this.medication == null ? null : this.medication.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        DateTimeType dateTimeType = dst.dateAsserted = this.dateAsserted == null ? null : this.dateAsserted.copy();
        if (this.informationSource != null) {
            dst.informationSource = new ArrayList<Reference>();
            for (Reference reference : this.informationSource) {
                dst.informationSource.add(reference.copy());
            }
        }
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<Reference>();
            for (Reference reference : this.derivedFrom) {
                dst.derivedFrom.add(reference.copy());
            }
        }
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.relatedClinicalInformation != null) {
            dst.relatedClinicalInformation = new ArrayList<Reference>();
            for (Reference reference : this.relatedClinicalInformation) {
                dst.relatedClinicalInformation.add(reference.copy());
            }
        }
        MarkdownType markdownType = dst.renderedDosageInstruction = this.renderedDosageInstruction == null ? null : this.renderedDosageInstruction.copy();
        if (this.dosage != null) {
            dst.dosage = new ArrayList<Dosage>();
            for (Dosage dosage : this.dosage) {
                dst.dosage.add(dosage.copy());
            }
        }
        dst.adherence = this.adherence == null ? null : this.adherence.copy();
    }

    protected MedicationStatement typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationStatement)) {
            return false;
        }
        MedicationStatement o = (MedicationStatement)other_;
        return MedicationStatement.compareDeep(this.identifier, o.identifier, true) && MedicationStatement.compareDeep(this.partOf, o.partOf, true) && MedicationStatement.compareDeep(this.status, o.status, true) && MedicationStatement.compareDeep(this.category, o.category, true) && MedicationStatement.compareDeep(this.medication, o.medication, true) && MedicationStatement.compareDeep(this.subject, o.subject, true) && MedicationStatement.compareDeep(this.encounter, o.encounter, true) && MedicationStatement.compareDeep(this.effective, o.effective, true) && MedicationStatement.compareDeep(this.dateAsserted, o.dateAsserted, true) && MedicationStatement.compareDeep(this.informationSource, o.informationSource, true) && MedicationStatement.compareDeep(this.derivedFrom, o.derivedFrom, true) && MedicationStatement.compareDeep(this.reason, o.reason, true) && MedicationStatement.compareDeep(this.note, o.note, true) && MedicationStatement.compareDeep(this.relatedClinicalInformation, o.relatedClinicalInformation, true) && MedicationStatement.compareDeep(this.renderedDosageInstruction, o.renderedDosageInstruction, true) && MedicationStatement.compareDeep(this.dosage, o.dosage, true) && MedicationStatement.compareDeep(this.adherence, o.adherence, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationStatement)) {
            return false;
        }
        MedicationStatement o = (MedicationStatement)other_;
        return MedicationStatement.compareValues(this.status, o.status, true) && MedicationStatement.compareValues(this.dateAsserted, o.dateAsserted, true) && MedicationStatement.compareValues(this.renderedDosageInstruction, o.renderedDosageInstruction, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.partOf, this.status, this.category, this.medication, this.subject, this.encounter, this.effective, this.dateAsserted, this.informationSource, this.derivedFrom, this.reason, this.note, this.relatedClinicalInformation, this.renderedDosageInstruction, this.dosage, this.adherence});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationStatement;
    }

    @Block
    public static class MedicationStatementAdherenceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of adherence", formalDefinition="Type of the adherence for the medication.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-statement-adherence")
        protected CodeableConcept code;
        @Child(name="reason", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Details of the reason for the current use of the medication", formalDefinition="Captures the reason for the current use or adherence of a medication.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/reason-medication-status-codes")
        protected CodeableConcept reason;
        private static final long serialVersionUID = -1479626679L;

        public MedicationStatementAdherenceComponent() {
        }

        public MedicationStatementAdherenceComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationStatementAdherenceComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MedicationStatementAdherenceComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationStatementAdherenceComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public MedicationStatementAdherenceComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(MedicationStatement.SP_CODE, "CodeableConcept", "Type of the adherence for the medication.", 0, 1, this.code));
            children.add(new Property("reason", "CodeableConcept", "Captures the reason for the current use or adherence of a medication.", 0, 1, this.reason));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(MedicationStatement.SP_CODE, "CodeableConcept", "Type of the adherence for the medication.", 0, 1, this.code);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "Captures the reason for the current use or adherence of a medication.", 0, 1, this.reason);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.reason = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MedicationStatement.SP_CODE)) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.reason = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(MedicationStatement.SP_CODE)) {
                this.code = null;
            } else if (name.equals("reason")) {
                this.reason = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -934964668: {
                    return this.getReason();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MedicationStatement.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationStatementAdherenceComponent copy() {
            MedicationStatementAdherenceComponent dst = new MedicationStatementAdherenceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationStatementAdherenceComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationStatementAdherenceComponent)) {
                return false;
            }
            MedicationStatementAdherenceComponent o = (MedicationStatementAdherenceComponent)other_;
            return MedicationStatementAdherenceComponent.compareDeep(this.code, o.code, true) && MedicationStatementAdherenceComponent.compareDeep(this.reason, o.reason, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationStatementAdherenceComponent)) {
                return false;
            }
            MedicationStatementAdherenceComponent o = (MedicationStatementAdherenceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.reason});
        }

        @Override
        public String fhirType() {
            return "MedicationStatement.adherence";
        }
    }

    public static class MedicationStatementStatusCodesEnumFactory
    implements EnumFactory<MedicationStatementStatusCodes> {
        @Override
        public MedicationStatementStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("recorded".equals(codeString)) {
                return MedicationStatementStatusCodes.RECORDED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationStatementStatusCodes.ENTEREDINERROR;
            }
            if ("draft".equals(codeString)) {
                return MedicationStatementStatusCodes.DRAFT;
            }
            throw new IllegalArgumentException("Unknown MedicationStatementStatusCodes code '" + codeString + "'");
        }

        public Enumeration<MedicationStatementStatusCodes> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationStatementStatusCodes>(this, MedicationStatementStatusCodes.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<MedicationStatementStatusCodes>(this, MedicationStatementStatusCodes.NULL, code);
            }
            if ("recorded".equals(codeString)) {
                return new Enumeration<MedicationStatementStatusCodes>(this, MedicationStatementStatusCodes.RECORDED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationStatementStatusCodes>(this, MedicationStatementStatusCodes.ENTEREDINERROR, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<MedicationStatementStatusCodes>(this, MedicationStatementStatusCodes.DRAFT, code);
            }
            throw new FHIRException("Unknown MedicationStatementStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationStatementStatusCodes code) {
            if (code == MedicationStatementStatusCodes.NULL) {
                return null;
            }
            if (code == MedicationStatementStatusCodes.RECORDED) {
                return "recorded";
            }
            if (code == MedicationStatementStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationStatementStatusCodes.DRAFT) {
                return "draft";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationStatementStatusCodes code) {
            return code.getSystem();
        }
    }

    public static enum MedicationStatementStatusCodes {
        RECORDED,
        ENTEREDINERROR,
        DRAFT,
        NULL;


        public static MedicationStatementStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("recorded".equals(codeString)) {
                return RECORDED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationStatementStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case RECORDED: {
                    return "recorded";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case DRAFT: {
                    return "draft";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case RECORDED: {
                    return "http://hl7.org/fhir/CodeSystem/medication-statement-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/CodeSystem/medication-statement-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/CodeSystem/medication-statement-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case RECORDED: {
                    return "The action of recording the medication statement is finished.";
                }
                case ENTEREDINERROR: {
                    return "Some of the actions that are implied by the medication usage may have occurred.  For example, the patient may have taken some of the medication.  Clinical decision support systems should take this status into account.";
                }
                case DRAFT: {
                    return "The medication usage is draft or preliminary.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case RECORDED: {
                    return "Recorded";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case DRAFT: {
                    return "Draft";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

