/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ImplementationGuideRenderer
extends ResourceRenderer {
    public ImplementationGuideRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        if (r.isDirect()) {
            this.renderResourceTechDetails(r, x);
            this.genSummaryTable(status, x, (ImplementationGuide)r.getBase());
            this.render(status, x, (ImplementationGuide)r.getBase());
        } else {
            x.para().tx("ImplementationGuideRenderer only renders native resources directly");
        }
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    public void render(Renderer.RenderingStatus status, XhtmlNode x, ImplementationGuide ig) throws FHIRFormatError, DefinitionException, IOException {
        x.h2().addText(ig.getName());
        x.para().tx(this.context.formatPhrase("IMP_GUIDE_URL", new Object[0]) + " ");
        x.pre().tx(ig.getUrl());
        this.addMarkdown(x, ig.getDescription());
    }

    public void describe(XhtmlNode x, ImplementationGuide ig) {
        x.tx(this.display(ig));
    }

    public String display(ImplementationGuide ig) {
        return ig.present();
    }
}

