/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ListRenderer
extends ResourceRenderer {
    public ListRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        ResourceWrapper c = r.child("code");
        String cd = c == null ? this.context.formatPhrase("LIST_UNSPECIFIED_CODE", new Object[0]) : this.displayCodeableConcept(c);
        ResourceWrapper s = r.child("subject");
        String sd = s == null ? this.context.formatPhrase("LIST_UNSPECIFIED_SUBJECT", new Object[0]) : this.displayReference(s);
        return this.context.formatPhrase("LIST_SUMMARY", new Object[]{cd, sd});
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper list) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        this.renderResourceTechDetails(list, x);
        if (list.has("title")) {
            x.h2().tx(list.primitiveValue("title"));
        }
        XhtmlNode t = x.table("clstu");
        XhtmlNode tr = t.tr();
        if (list.has("date")) {
            tr.td().tx(this.context.formatPhrase("LIST_REND_DATE", new Object[]{this.displayDateTime(list.child("date"))}) + " ");
        }
        if (list.has("mode")) {
            tr.td().tx(this.context.formatPhrase("LIST_REND_MODE", new Object[]{this.getTranslatedCode(list.child("mode"))}) + " ");
        }
        if (list.has("status")) {
            tr.td().tx(this.context.formatPhrase("LIST_REND_STAT", new Object[]{this.getTranslatedCode(list.child("status"))}) + " ");
        }
        if (list.has("code")) {
            tr.td().tx(this.context.formatPhrase("LIST_REND_CODE", new Object[]{this.displayDataType(list.child("code"))}) + " ");
        }
        tr = t.tr();
        XhtmlNode td = tr.td();
        if (list.has("subject")) {
            td.tx(this.context.formatPhrase("LIST_REND_SUB", new Object[0]) + " ");
            this.renderReference(status, td, list.child("subject"));
        }
        if (list.has("encounter")) {
            td.tx(this.context.formatPhrase("LIST_REND_ENC", new Object[0]) + " ");
            this.renderReference(status, td, list.child("encounter"));
        }
        if (list.has("source")) {
            td.tx(this.context.formatPhrase("GENERAL_SRC", new Object[0]) + " ");
            this.renderReference(status, td, list.child("encounter"));
        }
        if (list.has("orderedBy")) {
            td.tx(this.context.formatPhrase("LIST_REND_ORD", new Object[]{this.displayDataType(list.child("orderedBy"))}) + " ");
        }
        for (ResourceWrapper a : list.children("note")) {
            this.renderAnnotation(status, x, a);
        }
        boolean flag = false;
        boolean deleted = false;
        boolean date = false;
        for (ResourceWrapper e : list.children("entry")) {
            flag = flag || e.has("flag");
            deleted = deleted || e.has("deleted");
            date = date || e.has("date");
        }
        t = x.table("grid");
        tr = t.tr().style("backgound-color: #eeeeee");
        tr.td().b().tx(this.context.formatPhrase("LIST_REND_ITEM", new Object[0]));
        if (date) {
            tr.td().tx(this.context.formatPhrase("LIST_REND_DAT", new Object[0]));
        }
        if (flag) {
            tr.td().tx(this.context.formatPhrase("LIST_REND_FLAG", new Object[0]));
        }
        if (deleted) {
            tr.td().tx(this.context.formatPhrase("LIST_REND_DEL", new Object[0]));
        }
        for (ResourceWrapper e : list.children("entry")) {
            tr = t.tr();
            this.renderReference(status, tr.td(), e.child("item"));
            if (date) {
                tr.td().tx(e.has("date") ? this.displayDateTime(e.child("date")) : "");
            }
            if (flag) {
                tr.td().tx(e.has("flag") ? this.displayDataType(e.child("flag")) : "");
            }
            if (!deleted) continue;
            tr.td().tx(e.has("deleted") ? e.primitiveValue("deleted") : "");
        }
        if (list.has("contained") && this.context.isTechnicalMode()) {
            x.hr();
            x.para().b().tx(this.context.formatMessagePlural(list.children("contained").size(), "PAT_CONTAINED", new Object[0]));
            this.addContained(status, x, list.children("contained"));
        }
    }

    public void describe(XhtmlNode x, ListResource list) {
        x.tx(this.display(list));
    }

    public String display(ListResource list) {
        return list.getTitle();
    }
}

