/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.TerminologyUtilities;
import org.hl7.fhir.r5.utils.CanonicalResourceUtilities;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;

public class ValueSetUtilities
extends TerminologyUtilities {
    public static boolean isServerSide(String url) {
        return Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/sid/cvx"});
    }

    public static ValueSet makeShareable(ValueSet vs) {
        if (!vs.hasExperimental()) {
            vs.setExperimental(false);
        }
        if (!vs.hasMeta()) {
            vs.setMeta(new Meta());
        }
        for (UriType uriType : vs.getMeta().getProfile()) {
            if (!((String)uriType.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablevalueset")) continue;
            return vs;
        }
        vs.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareablevalueset"));
        return vs;
    }

    public static boolean makeVSShareable(ValueSet vs) {
        if (!vs.hasMeta()) {
            vs.setMeta(new Meta());
        }
        for (UriType uriType : vs.getMeta().getProfile()) {
            if (!((String)uriType.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablevalueset")) continue;
            return false;
        }
        vs.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareablevalueset"));
        return true;
    }

    public static void checkShareable(ValueSet vs) {
        if (!vs.hasMeta()) {
            throw new Error("ValueSet " + vs.getUrl() + " is not shareable");
        }
        for (UriType uriType : vs.getMeta().getProfile()) {
            if (!((String)uriType.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablevalueset")) continue;
            return;
        }
        throw new Error("ValueSet " + vs.getUrl() + " is not shareable");
    }

    public static boolean hasOID(ValueSet vs) {
        return ValueSetUtilities.getOID(vs) != null;
    }

    public static String getOID(ValueSet vs) {
        for (Identifier id : vs.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            return id.getValue().substring(8);
        }
        return null;
    }

    public static void setOID(ValueSet vs, String oid) {
        if (!((String)oid).startsWith("urn:oid:")) {
            oid = "urn:oid:" + (String)oid;
        }
        for (Identifier id : vs.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            id.setValue((String)oid);
            return;
        }
        vs.addIdentifier().setSystem("urn:ietf:rfc:3986").setValue((String)oid);
    }

    public static void markStatus(ValueSet vs, String wg, StandardsStatus status, String pckage, String fmm, IWorkerContext context, String normativeVersion) throws FHIRException {
        if (vs.hasUserData("External.Link")) {
            return;
        }
        if (wg != null && (!ToolingExtensions.hasExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg") || !Utilities.existsInList((String)ToolingExtensions.readStringExtension((DomainResource)vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"), (String[])new String[]{"fhir", "vocab"}) && Utilities.existsInList((String)wg, (String[])new String[]{"fhir", "vocab"}))) {
            CanonicalResourceUtilities.setHl7WG(vs, wg);
        }
        if (status != null) {
            StandardsStatus ss = ToolingExtensions.getStandardsStatus(vs);
            if (ss == null || ss.isLowerThan(status)) {
                ToolingExtensions.setStandardsStatus(vs, status, normativeVersion);
            }
            if (pckage != null) {
                if (!vs.hasUserData("ballot.package")) {
                    vs.setUserData("ballot.package", pckage);
                } else if (!pckage.equals(vs.getUserString("ballot.package")) && !"infrastructure".equals(vs.getUserString("ballot.package"))) {
                    System.out.println("Value Set " + vs.getUrl() + ": ownership clash " + pckage + " vs " + vs.getUserString("ballot.package"));
                }
            }
            if (status == StandardsStatus.NORMATIVE) {
                vs.setExperimental(false);
                vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            }
        }
        if (fmm != null) {
            String sfmm = ToolingExtensions.readStringExtension((DomainResource)vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm");
            if (Utilities.noString((String)sfmm) || Integer.parseInt(sfmm) < Integer.parseInt(fmm)) {
                ToolingExtensions.setIntegerExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm", Integer.parseInt(fmm));
            }
            if (Integer.parseInt(fmm) <= 1) {
                vs.setExperimental(true);
            }
        }
        if (vs.hasUserData("cs")) {
            CodeSystemUtilities.markStatus((CodeSystem)vs.getUserData("cs"), wg, status, pckage, fmm, normativeVersion);
        } else if (status == StandardsStatus.NORMATIVE && context != null) {
            for (ValueSet.ConceptSetComponent csc : vs.getCompose().getInclude()) {
                CodeSystem cs;
                if (!csc.hasSystem() || (cs = context.fetchCodeSystem(csc.getSystem())) == null) continue;
                CodeSystemUtilities.markStatus(cs, wg, status, pckage, fmm, normativeVersion);
            }
        }
    }

    private static int ssval(String status) {
        if ("Draft".equals("status")) {
            return 1;
        }
        if ("Informative".equals("status")) {
            return 2;
        }
        if ("External".equals("status")) {
            return 3;
        }
        if ("Trial Use".equals("status")) {
            return 3;
        }
        if ("Normative".equals("status")) {
            return 4;
        }
        return -1;
    }

    public static ValueSet generateImplicitValueSet(String uri) {
        if (uri.startsWith("http://snomed.info/sct")) {
            return ValueSetUtilities.generateImplicitSnomedValueSet(uri);
        }
        if (uri.startsWith("http://loinc.org/vs")) {
            return ValueSetUtilities.generateImplicitLoincValueSet(uri);
        }
        if (uri.equals("http://hl7.org/fhir/ValueSet/mimetypes")) {
            return ValueSetUtilities.generateImplicitMimetypesValueSet(uri);
        }
        return null;
    }

    private static ValueSet generateImplicitMimetypesValueSet(String theUri) {
        ValueSet valueSet = new ValueSet();
        valueSet.setStatus(Enumerations.PublicationStatus.ACTIVE);
        valueSet.setUrl(theUri);
        valueSet.setDescription("This value set includes all possible codes from BCP-13 (http://tools.ietf.org/html/bcp13)");
        valueSet.getCompose().addInclude().setSystem("urn:ietf:bcp:13");
        return valueSet;
    }

    private static ValueSet generateImplicitLoincValueSet(String uri) {
        if ("http://loinc.org/vs".equals(uri)) {
            return ValueSetUtilities.makeLoincValueSet();
        }
        if (uri.startsWith("http://loinc.org/vs/LL")) {
            return ValueSetUtilities.makeAnswerList(ValueSetUtilities.makeLoincValueSet(), uri);
        }
        return null;
    }

    private static ValueSet makeAnswerList(ValueSet vs, String uri) {
        vs.setUrl(uri);
        String c = uri.substring(20);
        vs.setName("LOINCAnswers" + c);
        vs.setTitle("LOINC Answer Codes for " + c);
        vs.getCompose().getIncludeFirstRep().addFilter().setProperty("LIST").setOp(Enumerations.FilterOperator.EQUAL).setValue(c);
        return vs;
    }

    private static ValueSet makeLoincValueSet() {
        ValueSet vs = new ValueSet();
        vs.setUrl("http://loinc.org/vs");
        vs.setName("LOINCCodes");
        vs.setTitle("All LOINC codes");
        vs.setCopyright("This content LOINC\u00ae is copyright \u00a9 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use");
        vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        vs.getCompose().addInclude().setSystem("http://loinc.org");
        return vs;
    }

    private static ValueSet generateImplicitSnomedValueSet(String uri) {
        if ("http://snomed.info/sct?fhir_vs".equals(uri)) {
            return ValueSetUtilities.makeImplicitSnomedValueSet(uri);
        }
        return null;
    }

    private static ValueSet makeImplicitSnomedValueSet(String uri) {
        ValueSet vs = new ValueSet();
        vs.setUrl(uri);
        vs.setName("SCTValueSet");
        vs.setTitle("SCT ValueSet");
        vs.setDescription("All SNOMED CT Concepts");
        vs.setCopyright("This value set includes content from SNOMED CT, which is copyright \u00a9 2002+ International Health Terminology Standards Development Organisation (SNOMED International), and distributed by agreement between SNOMED International and HL7. Implementer use of SNOMED CT is not covered by this agreement");
        vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        vs.getCompose().addInclude().setSystem("http://snomed.info/sct");
        return vs;
    }

    public static void setDeprecated(List<ValueSet.ValueSetExpansionPropertyComponent> vsProp, ValueSet.ValueSetExpansionContainsComponent n) {
        n.addProperty().setCode("status").setValue(new CodeType("deprecated"));
        for (ValueSet.ValueSetExpansionPropertyComponent o : vsProp) {
            if (!"status".equals(o.getCode())) continue;
            return;
        }
        vsProp.add(new ValueSet.ValueSetExpansionPropertyComponent().setCode("status").setUri("http://hl7.org/fhir/concept-properties#status"));
    }

    public static void sortInclude(ValueSet.ConceptSetComponent inc) {
        Collections.sort(inc.getConcept(), new ConceptReferenceComponentSorter());
    }

    public static String getAllCodesSystem(ValueSet vs) {
        ValueSet.ConceptSetComponent i;
        ValueSet.ValueSetComposeComponent c;
        if (vs.hasCompose() && (c = vs.getCompose()).getExclude().isEmpty() && c.getInclude().size() == 1 && (i = c.getIncludeFirstRep()).hasSystem() && !i.hasValueSet() && !i.hasConcept() && !i.hasFilter()) {
            return i.getSystem();
        }
        return null;
    }

    public static boolean isDeprecated(ValueSet vs, ValueSet.ValueSetExpansionContainsComponent c) {
        try {
            for (ValueSet.ConceptPropertyComponent p : c.getProperty()) {
                if ("status".equals(p.getCode()) && p.hasValue() && p.hasValueCodeType() && "deprecated".equals(p.getValueCodeType().getCode())) {
                    return true;
                }
                if ("deprecationDate".equals(p.getCode()) && p.hasValue() && p.getValue() instanceof DateTimeType) {
                    return ((DateTimeType)p.getValue()).before(new DateTimeType(Calendar.getInstance()));
                }
                if (!"deprecated".equals(p.getCode()) || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
                return (Boolean)((BooleanType)p.getValue()).getValue();
            }
            StandardsStatus ss = ToolingExtensions.getStandardsStatus(c);
            return ss == StandardsStatus.DEPRECATED;
        }
        catch (FHIRException e) {
            return false;
        }
    }

    public static boolean hasCodeInExpansion(ValueSet vs, Coding code) {
        return ValueSetUtilities.hasCodeInExpansion(vs.getExpansion().getContains(), code);
    }

    private static boolean hasCodeInExpansion(List<ValueSet.ValueSetExpansionContainsComponent> list, Coding code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            if (c.getSystem().equals(code.getSystem()) && c.getCode().equals(code.getCode())) {
                return true;
            }
            if (!ValueSetUtilities.hasCodeInExpansion(c.getContains(), code)) continue;
            return true;
        }
        return false;
    }

    public static ValueSet.ConceptPropertyComponent addProperty(ValueSet vs, ValueSet.ValueSetExpansionContainsComponent ctxt, String url, String code, String value) {
        if (value != null) {
            return ValueSetUtilities.addProperty(vs, ctxt, url, code, new StringType(value));
        }
        return null;
    }

    public static ValueSet.ConceptPropertyComponent addProperty(ValueSet vs, ValueSet.ValueSetExpansionContainsComponent ctxt, String url, String code, Integer value) {
        if (value != null) {
            return ValueSetUtilities.addProperty(vs, ctxt, url, code, new IntegerType(value));
        }
        return null;
    }

    public static ValueSet.ConceptPropertyComponent addProperty(ValueSet vs, ValueSet.ValueSetExpansionContainsComponent ctxt, String url, String code, DataType value) {
        code = ValueSetUtilities.defineProperty(vs, url, code);
        ValueSet.ConceptPropertyComponent p = ValueSetUtilities.getProperty(ctxt.getProperty(), code);
        if (p != null) {
            p.setValue(value);
        } else {
            p = ctxt.addProperty().setCode(code).setValue(value);
        }
        return p;
    }

    private static ValueSet.ConceptPropertyComponent getProperty(List<ValueSet.ConceptPropertyComponent> list, String code) {
        for (ValueSet.ConceptPropertyComponent t : list) {
            if (!code.equals(t.getCode())) continue;
            return t;
        }
        return null;
    }

    private static String defineProperty(ValueSet vs, String url, String code) {
        for (ValueSet.ValueSetExpansionPropertyComponent p : vs.getExpansion().getProperty()) {
            if (!p.hasUri() || !p.getUri().equals(url)) continue;
            return p.getCode();
        }
        for (ValueSet.ValueSetExpansionPropertyComponent p : vs.getExpansion().getProperty()) {
            if (!p.hasCode() || !p.getCode().equals(code)) continue;
            p.setUri(url);
            return code;
        }
        ValueSet.ValueSetExpansionPropertyComponent p = vs.getExpansion().addProperty();
        p.setUri(url);
        p.setCode(code);
        return code;
    }

    public static int countExpansion(ValueSet valueset) {
        int i = valueset.getExpansion().getContains().size();
        for (ValueSet.ValueSetExpansionContainsComponent t : valueset.getExpansion().getContains()) {
            i += ValueSetUtilities.countExpansion(t);
        }
        return i;
    }

    public static int countExpansion(List<ValueSet.ValueSetExpansionContainsComponent> list) {
        int i = list.size();
        for (ValueSet.ValueSetExpansionContainsComponent t : list) {
            i += ValueSetUtilities.countExpansion(t);
        }
        return i;
    }

    private static int countExpansion(ValueSet.ValueSetExpansionContainsComponent c) {
        int i = c.getContains().size();
        for (ValueSet.ValueSetExpansionContainsComponent t : c.getContains()) {
            i += ValueSetUtilities.countExpansion(t);
        }
        return i;
    }

    public static Set<String> listSystems(IWorkerContext ctxt, ValueSet vs) {
        HashSet<String> systems = new HashSet<String>();
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            for (CanonicalType ct : inc.getValueSet()) {
                ValueSet vsr = ctxt.findTxResource(ValueSet.class, ct.asStringValue(), vs);
                if (vsr == null) continue;
                systems.addAll(ValueSetUtilities.listSystems(ctxt, vsr));
            }
            if (!inc.hasSystem()) continue;
            systems.add(inc.getSystem());
        }
        return systems;
    }

    public static boolean isIncompleteExpansion(ValueSet valueSet) {
        ValueSet.ValueSetExpansionComponent exp;
        return valueSet.hasExpansion() && (exp = valueSet.getExpansion()).hasTotal() && exp.getTotal() != ValueSetUtilities.countExpansion(exp.getContains());
    }

    public static Set<String> codes(ValueSet vs, CodeSystem cs) {
        HashSet<String> res = new HashSet<String>();
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            if (!inc.getSystem().equals(cs.getUrl())) continue;
            ValueSetUtilities.addCodes(res, inc, cs.getConcept());
        }
        return res;
    }

    private static void addCodes(Set<String> res, ValueSet.ConceptSetComponent inc, List<CodeSystem.ConceptDefinitionComponent> list) {
        for (CodeSystem.ConceptDefinitionComponent cd : list) {
            if (cd.hasCode() && (!inc.hasConcept() || inc.hasConcept(cd.getCode()))) {
                res.add(cd.getCode());
            }
            if (!cd.hasConcept()) continue;
            ValueSetUtilities.addCodes(res, inc, cd.getConcept());
        }
    }

    public static class ConceptReferenceComponentSorter
    implements Comparator<ValueSet.ConceptReferenceComponent> {
        @Override
        public int compare(ValueSet.ConceptReferenceComponent o1, ValueSet.ConceptReferenceComponent o2) {
            return o1.getCode().compareToIgnoreCase(o2.getCode());
        }
    }

    public static class ValueSetSorter
    implements Comparator<ValueSet> {
        @Override
        public int compare(ValueSet o1, ValueSet o2) {
            String ver2;
            String ver1;
            String url2;
            String url1 = o1.getUrl();
            int c = this.compareString(url1, url2 = o2.getUrl());
            if (c == 0 && (c = VersionUtilities.compareVersions((String)(ver1 = o1.getVersion()), (String)(ver2 = o2.getVersion()))) == 0) {
                String d1 = o1.getDateElement().asStringValue();
                String d2 = o2.getDateElement().asStringValue();
                c = this.compareString(url1, url2);
            }
            return c;
        }

        private int compareString(String s1, String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : 1;
            }
            return s1.compareTo(s2);
        }
    }
}

