/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.utilities;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyOperationContext;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ValueSetProcessBase {
    protected IWorkerContext context;
    protected TerminologyOperationContext opContext;
    protected List<String> requiredSupplements = new ArrayList<String>();
    protected AlternateCodesProcessingRules altCodeParams = new AlternateCodesProcessingRules(false);
    protected AlternateCodesProcessingRules allAltCodes = new AlternateCodesProcessingRules(true);

    protected ValueSetProcessBase(IWorkerContext context, TerminologyOperationContext opContext) {
        this.context = context;
        this.opContext = opContext;
    }

    protected List<OperationOutcome.OperationOutcomeIssueComponent> makeIssue(ValidationMessage.IssueSeverity level, OperationOutcome.IssueType type, String location, String message, OpIssueCode code, String server) {
        OperationOutcome.OperationOutcomeIssueComponent result = new OperationOutcome.OperationOutcomeIssueComponent();
        switch (level) {
            case ERROR: {
                result.setSeverity(OperationOutcome.IssueSeverity.ERROR);
                break;
            }
            case FATAL: {
                result.setSeverity(OperationOutcome.IssueSeverity.FATAL);
                break;
            }
            case INFORMATION: {
                result.setSeverity(OperationOutcome.IssueSeverity.INFORMATION);
                break;
            }
            case WARNING: {
                result.setSeverity(OperationOutcome.IssueSeverity.WARNING);
            }
        }
        result.setCode(type);
        if (location != null) {
            result.addLocation(location);
            result.addExpression(location);
        }
        result.getDetails().setText(message);
        if (code != null) {
            result.getDetails().addCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", code.toCode(), null);
        }
        if (server != null) {
            result.addExtension("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-server", new UrlType(server));
        }
        ArrayList<OperationOutcome.OperationOutcomeIssueComponent> list = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
        list.add(result);
        return list;
    }

    public void checkCanonical(List<OperationOutcome.OperationOutcomeIssueComponent> issues, String path, CanonicalResource resource, CanonicalResource source) {
        if (resource != null) {
            StandardsStatus standardsStatus = ToolingExtensions.getStandardsStatus(resource);
            if (standardsStatus == StandardsStatus.DEPRECATED) {
                this.addToIssues(issues, this.makeStatusIssue(path, "deprecated", "MSG_DEPRECATED", resource));
            } else if (standardsStatus == StandardsStatus.WITHDRAWN) {
                this.addToIssues(issues, this.makeStatusIssue(path, "withdrawn", "MSG_WITHDRAWN", resource));
            } else if (resource.getStatus() == Enumerations.PublicationStatus.RETIRED) {
                this.addToIssues(issues, this.makeStatusIssue(path, "retired", "MSG_RETIRED", resource));
            } else if (source != null) {
                if (resource.getExperimental() && !source.getExperimental()) {
                    this.addToIssues(issues, this.makeStatusIssue(path, "experimental", "MSG_EXPERIMENTAL", resource));
                } else if ((resource.getStatus() == Enumerations.PublicationStatus.DRAFT || standardsStatus == StandardsStatus.DRAFT) && source.getStatus() != Enumerations.PublicationStatus.DRAFT && ToolingExtensions.getStandardsStatus(source) != StandardsStatus.DRAFT) {
                    this.addToIssues(issues, this.makeStatusIssue(path, "draft", "MSG_DRAFT", resource));
                }
            } else if (resource.getExperimental()) {
                this.addToIssues(issues, this.makeStatusIssue(path, "experimental", "MSG_EXPERIMENTAL", resource));
            } else if (resource.getStatus() == Enumerations.PublicationStatus.DRAFT || standardsStatus == StandardsStatus.DRAFT) {
                this.addToIssues(issues, this.makeStatusIssue(path, "draft", "MSG_DRAFT", resource));
            }
        }
    }

    private List<OperationOutcome.OperationOutcomeIssueComponent> makeStatusIssue(String path, String id, String msg, CanonicalResource resource) {
        List<OperationOutcome.OperationOutcomeIssueComponent> iss = this.makeIssue(ValidationMessage.IssueSeverity.INFORMATION, OperationOutcome.IssueType.BUSINESSRULE, null, this.context.formatMessage(msg, resource.getVersionedUrl(), null, resource.fhirType()), OpIssueCode.StatusCheck, null);
        iss.get(0).setUserData("status-msg-name", "warning-" + id);
        iss.get(0).setUserData("status-msg-value", new UriType(resource.getVersionedUrl()));
        ToolingExtensions.setStringExtension(iss.get(0), "http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id", msg);
        return iss;
    }

    private void addToIssues(List<OperationOutcome.OperationOutcomeIssueComponent> issues, List<OperationOutcome.OperationOutcomeIssueComponent> toAdd) {
        for (OperationOutcome.OperationOutcomeIssueComponent t : toAdd) {
            boolean found = false;
            for (OperationOutcome.OperationOutcomeIssueComponent i : issues) {
                if (i.getSeverity() != t.getSeverity() || i.getCode() != t.getCode() || !i.getDetails().getText().equals(t.getDetails().getText())) continue;
                found = true;
            }
            if (found) continue;
            issues.add(t);
        }
    }

    public void checkCanonical(ValueSet.ValueSetExpansionComponent params, CanonicalResource resource, ValueSet source) {
        if (resource != null) {
            StandardsStatus standardsStatus = ToolingExtensions.getStandardsStatus(resource);
            if (standardsStatus == StandardsStatus.DEPRECATED) {
                if (!params.hasParameterValue("warning-deprecated", resource.getVersionedUrl())) {
                    params.addParameter("warning-deprecated", new UriType(resource.getVersionedUrl()));
                }
            } else if (standardsStatus == StandardsStatus.WITHDRAWN) {
                if (!params.hasParameterValue("warning-withdrawn", resource.getVersionedUrl())) {
                    params.addParameter("warning-withdrawn", new UriType(resource.getVersionedUrl()));
                }
            } else if (resource.getStatus() == Enumerations.PublicationStatus.RETIRED) {
                if (!params.hasParameterValue("warning-retired", resource.getVersionedUrl())) {
                    params.addParameter("warning-retired", new UriType(resource.getVersionedUrl()));
                }
            } else if (resource.getExperimental() && !source.getExperimental()) {
                if (!params.hasParameterValue("warning-experimental", resource.getVersionedUrl())) {
                    params.addParameter("warning-experimental", new UriType(resource.getVersionedUrl()));
                }
            } else if (!(resource.getStatus() != Enumerations.PublicationStatus.DRAFT && standardsStatus != StandardsStatus.DRAFT || source.getStatus() == Enumerations.PublicationStatus.DRAFT || ToolingExtensions.getStandardsStatus(source) == StandardsStatus.DRAFT || params.hasParameterValue("warning-draft", resource.getVersionedUrl()))) {
                params.addParameter("warning-draft", new UriType(resource.getVersionedUrl()));
            }
        }
    }

    public TerminologyOperationContext getOpContext() {
        return this.opContext;
    }

    public static class AlternateCodesProcessingRules {
        private boolean all;
        private List<String> uses = new ArrayList<String>();

        public AlternateCodesProcessingRules(boolean b) {
            this.all = b;
        }

        private void seeParameter(DataType value) {
            if (value != null) {
                String s;
                if (value instanceof BooleanType) {
                    this.all = ((BooleanType)value).booleanValue();
                    this.uses.clear();
                } else if (value.isPrimitive() && !Utilities.noString((String)(s = value.primitiveValue()))) {
                    this.uses.add(s);
                }
            }
        }

        public void seeParameters(Parameters pp) {
            for (Parameters.ParametersParameterComponent p : pp.getParameter()) {
                String name = p.getName();
                if (!"includeAlternateCodes".equals(name)) continue;
                DataType value = p.getValue();
                this.seeParameter(value);
            }
        }

        public void seeValueSet(ValueSet vs) {
            if (vs != null) {
                for (Extension ext : vs.getCompose().getExtension()) {
                    if (!"http://hl7.org/fhir/tools/StructureDefinion/valueset-expansion-param".equals(ext.getUrl())) continue;
                    String name = ext.getExtensionString("name");
                    Extension value = ext.getExtensionByUrl("value");
                    if (!"includeAlternateCodes".equals(name) || value == null || !value.hasValue()) continue;
                    this.seeParameter(value.getValue());
                }
            }
        }

        public boolean passes(List<Extension> extensions) {
            if (this.all) {
                return true;
            }
            for (Extension ext : extensions) {
                if (!"http://hl7.org/fhir/StructureDefinition/alternate-code-use".equals(ext.getUrl()) || !ext.hasValueCoding() || !Utilities.existsInList((String)ext.getValueCoding().getCode(), this.uses)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum OpIssueCode {
        NotInVS,
        ThisNotInVS,
        InvalidCode,
        Display,
        DisplayComment,
        NotFound,
        CodeRule,
        VSProcessing,
        InferFailed,
        StatusCheck,
        InvalidData;


        public String toCode() {
            switch (this) {
                case CodeRule: {
                    return "code-rule";
                }
                case Display: {
                    return "invalid-display";
                }
                case DisplayComment: {
                    return "display-comment";
                }
                case InferFailed: {
                    return "cannot-infer";
                }
                case InvalidCode: {
                    return "invalid-code";
                }
                case NotFound: {
                    return "not-found";
                }
                case NotInVS: {
                    return "not-in-vs";
                }
                case InvalidData: {
                    return "invalid-data";
                }
                case StatusCheck: {
                    return "status-check";
                }
                case ThisNotInVS: {
                    return "this-code-not-in-vs";
                }
                case VSProcessing: {
                    return "vs-invalid";
                }
            }
            return "??";
        }
    }
}

