/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BaseDateTimeType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.sql.Cell;
import org.hl7.fhir.r5.utils.sql.Column;
import org.hl7.fhir.r5.utils.sql.Provider;
import org.hl7.fhir.r5.utils.sql.Storage;
import org.hl7.fhir.r5.utils.sql.Store;
import org.hl7.fhir.r5.utils.sql.Validator;
import org.hl7.fhir.r5.utils.sql.Value;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class Runner
implements FHIRPathEngine.IEvaluationContext {
    private IWorkerContext context;
    private Provider provider;
    private Storage storage;
    private IRunnerObserver observer;
    private List<String> prohibitedNames = new ArrayList<String>();
    private FHIRPathEngine fpe;
    private String resourceName;
    private List<ValidationMessage> issues;
    private int resCount;

    public IWorkerContext getContext() {
        return this.context;
    }

    public void setContext(IWorkerContext context) {
        this.context = context;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public List<String> getProhibitedNames() {
        return this.prohibitedNames;
    }

    public void execute(JsonObject viewDefinition) {
        this.execute("$", viewDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String path, JsonObject viewDefinition) {
        WorkContext wc = this.prepare(path, viewDefinition);
        try {
            this.evaluate(wc);
        }
        finally {
            this.finish(wc);
        }
    }

    private void evaluate(WorkContext wc) {
        List<Base> data = this.provider.fetch(this.resourceName);
        int i = 0;
        for (Base b : data) {
            if (this.observer != null) {
                this.observer.handleRow(b, data.size(), i);
            }
            this.processResource(wc.vd, wc.store, b);
            ++i;
        }
    }

    public WorkContext prepare(String path, JsonObject viewDefinition) {
        WorkContext wc = new WorkContext(viewDefinition);
        if (this.context == null) {
            throw new FHIRException("No context provided");
        }
        this.fpe = new FHIRPathEngine(this.context);
        this.fpe.setHostServices(this);
        this.fpe.setEmitSQLonFHIRWarning(true);
        if (viewDefinition == null) {
            throw new FHIRException("No viewDefinition provided");
        }
        if (this.provider == null) {
            throw new FHIRException("No provider provided");
        }
        if (this.storage == null) {
            throw new FHIRException("No storage provided");
        }
        Validator validator = new Validator(this.context, this.fpe, this.prohibitedNames, this.storage.supportsArrays(), this.storage.supportsComplexTypes(), this.storage.needsName());
        validator.checkViewDefinition(path, viewDefinition);
        this.issues = validator.getIssues();
        validator.dump();
        validator.check();
        this.resourceName = validator.getResourceName();
        wc.store = this.storage.createStore(wc.vd.asString("name"), (List)wc.vd.getUserData("columns"));
        return wc;
    }

    public void processResource(WorkContext wc, Base b) {
        if (this.observer != null) {
            this.observer.handleRow(b, -1, this.resCount);
        }
        this.processResource(wc.vd, wc.store, b);
        ++this.resCount;
        wc.store.flush();
    }

    private void processResource(JsonObject vd, Store store, Base b) {
        boolean ok = true;
        for (JsonObject w : vd.getJsonObjects("where")) {
            String string = w.asString("path");
            ExpressionNode node = this.fpe.parse(string);
            boolean pass = this.fpe.evaluateToBoolean((Object)vd, b, b, b, node);
            if (pass) continue;
            ok = false;
            break;
        }
        if (ok) {
            ArrayList<List<Cell>> rows = new ArrayList<List<Cell>>();
            rows.add(new ArrayList());
            for (JsonObject jsonObject : vd.getJsonObjects("select")) {
                this.executeSelect(vd, jsonObject, b, rows);
            }
            for (List list : rows) {
                this.storage.addRow(store, list);
            }
        }
    }

    public void finish(WorkContext wc) {
        this.storage.finish(wc.store);
    }

    private void executeSelect(JsonObject vd, JsonObject select, Base b, List<List<Cell>> rows) {
        ArrayList<Base> focus = new ArrayList<Base>();
        if (select.has("forEach")) {
            focus.addAll(this.executeForEach(vd, select, b));
        } else if (select.has("forEachOrNull")) {
            focus.addAll(this.executeForEachOrNull(vd, select, b));
            if (focus.isEmpty()) {
                List columns = (List)select.getUserData("columns");
                for (List<Cell> row : rows) {
                    for (Column c : columns) {
                        Cell cell = this.cell(row, c.getName());
                        if (cell != null) continue;
                        row.add(new Cell(c, null));
                    }
                }
                return;
            }
        } else {
            focus.add(b);
        }
        ArrayList<List<Cell>> tempRows = new ArrayList<List<Cell>>();
        tempRows.addAll(rows);
        rows.clear();
        for (Base f : focus) {
            List<List<Cell>> rowsToAdd = this.cloneRows(tempRows);
            for (JsonObject column : select.getJsonObjects("column")) {
                this.executeColumn(vd, column, f, rowsToAdd);
            }
            for (JsonObject sub : select.getJsonObjects("select")) {
                this.executeSelect(vd, sub, f, rowsToAdd);
            }
            this.executeUnionAll(vd, select.getJsonObjects("unionAll"), f, rowsToAdd);
            rows.addAll(rowsToAdd);
        }
    }

    private void executeUnionAll(JsonObject vd, List<JsonObject> unionList, Base b, List<List<Cell>> rows) {
        if (unionList.isEmpty()) {
            return;
        }
        ArrayList<List<Cell>> sourceRows = new ArrayList<List<Cell>>();
        sourceRows.addAll(rows);
        rows.clear();
        for (JsonObject union : unionList) {
            ArrayList<List<Cell>> tempRows = new ArrayList<List<Cell>>();
            tempRows.addAll(sourceRows);
            this.executeSelect(vd, union, b, tempRows);
            rows.addAll(tempRows);
        }
    }

    private List<List<Cell>> cloneRows(List<List<Cell>> rows) {
        ArrayList<List<Cell>> list = new ArrayList<List<Cell>>();
        for (List<Cell> row : rows) {
            list.add(this.cloneRow(row));
        }
        return list;
    }

    private List<Cell> cloneRow(List<Cell> cells) {
        ArrayList<Cell> list = new ArrayList<Cell>();
        for (Cell cell : cells) {
            list.add(cell.copy());
        }
        return list;
    }

    private List<Base> executeForEach(JsonObject vd, JsonObject focus, Base b) {
        ExpressionNode n = (ExpressionNode)focus.getUserData("forEach");
        ArrayList<Base> result = new ArrayList<Base>();
        result.addAll(this.fpe.evaluate(vd, b, n));
        return result;
    }

    private List<Base> executeForEachOrNull(JsonObject vd, JsonObject focus, Base b) {
        ExpressionNode n = (ExpressionNode)focus.getUserData("forEachOrNull");
        ArrayList<Base> result = new ArrayList<Base>();
        result.addAll(this.fpe.evaluate(vd, b, n));
        return result;
    }

    private void executeColumn(JsonObject vd, JsonObject column, Base b, List<List<Cell>> rows) {
        Column col;
        ExpressionNode n = (ExpressionNode)column.getUserData("path");
        ArrayList<Base> bl2 = new ArrayList<Base>();
        if (b != null) {
            bl2.addAll(this.fpe.evaluate(vd, b, n));
        }
        if ((col = (Column)column.getUserData("column")) == null) {
            System.out.println("Error");
        } else {
            for (List<Cell> row : rows) {
                Cell c = this.cell(row, col.getName());
                if (c == null) {
                    c = new Cell(col);
                    row.add(c);
                }
                if (bl2.isEmpty()) continue;
                if (bl2.size() + c.getValues().size() > 1 && !c.getColumn().isColl().booleanValue()) {
                    throw new FHIRException("The column " + c.getColumn().getName() + " is not allowed multiple values, but at least one row has multiple values");
                }
                for (Base b2 : bl2) {
                    c.getValues().add(this.genValue(c.getColumn(), b2));
                }
            }
        }
    }

    private Value genValue(Column column, Base b) {
        if (column.getKind() == null) {
            throw new FHIRException("Attempt to add a type " + b.fhirType() + " to an unknown column type (null) for column " + column.getName());
        }
        switch (column.getKind()) {
            case Binary: {
                if (b instanceof Base64BinaryType) {
                    Base64BinaryType bb = (Base64BinaryType)b;
                    return Value.makeBinary(bb.primitiveValue(), bb.getValue());
                }
                if (b.isBooleanPrimitive()) {
                    return Value.makeBinary(b.primitiveValue(), Base64.decodeBase64((String)b.primitiveValue()));
                }
                throw new FHIRException("Attempt to add a type " + b.fhirType() + " to a binary column for column " + column.getName());
            }
            case Boolean: {
                if (b instanceof BooleanType) {
                    BooleanType bb = (BooleanType)b;
                    return Value.makeBoolean(bb.primitiveValue(), bb.booleanValue());
                }
                if (b.isBooleanPrimitive()) {
                    return Value.makeBoolean(b.primitiveValue(), "true".equals(b.primitiveValue()));
                }
                throw new FHIRException("Attempt to add a type " + b.fhirType() + " to a boolean column for column " + column.getName());
            }
            case Complex: {
                if (b.isPrimitive()) {
                    throw new FHIRException("Attempt to add a primitive type " + b.fhirType() + " to a complex column for column " + column.getName());
                }
                return Value.makeComplex(b);
            }
            case DateTime: {
                if (b instanceof BaseDateTimeType) {
                    BaseDateTimeType d = (BaseDateTimeType)b;
                    return Value.makeDate(d.primitiveValue(), (Date)d.getValue());
                }
                if (b.isPrimitive() && b.isDateTime()) {
                    return Value.makeDate(b.primitiveValue(), (Date)b.dateTimeValue().getValue());
                }
                throw new FHIRException("Attempt to add a type " + b.fhirType() + " to an integer column for column " + column.getName());
            }
            case Decimal: {
                if (b instanceof DecimalType) {
                    DecimalType d = (DecimalType)b;
                    return Value.makeDecimal(d.primitiveValue(), (BigDecimal)d.getValue());
                }
                if (b.isPrimitive()) {
                    return Value.makeDecimal(b.primitiveValue(), new BigDecimal(b.primitiveValue()));
                }
                throw new FHIRException("Attempt to add a type " + b.fhirType() + " to an integer column for column " + column.getName());
            }
            case Integer: {
                if (b instanceof IntegerType) {
                    IntegerType i = (IntegerType)b;
                    return Value.makeInteger(i.primitiveValue(), (Integer)i.getValue());
                }
                if (b.isPrimitive()) {
                    return Value.makeInteger(b.primitiveValue(), Integer.valueOf(b.primitiveValue()));
                }
                throw new FHIRException("Attempt to add a type " + b.fhirType() + " to an integer column for column " + column.getName());
            }
            case String: {
                if (b.isPrimitive()) {
                    return Value.makeString(b.primitiveValue());
                }
                throw new FHIRException("Attempt to add a complex type " + b.fhirType() + " to a string column for column " + column.getName());
            }
            case Time: {
                if (b.fhirType().equals("time")) {
                    return Value.makeString(b.primitiveValue());
                }
                throw new FHIRException("Attempt to add a type " + b.fhirType() + " to a time column for column " + column.getName());
            }
        }
        throw new FHIRException("Attempt to add a type " + b.fhirType() + " to an unknown column type for column " + column.getName());
    }

    private Column column(String columnName, List<Column> columns) {
        for (Column t : columns) {
            if (!t.getName().equalsIgnoreCase(columnName)) continue;
            return t;
        }
        return null;
    }

    private Cell cell(List<Cell> cells, String columnName) {
        for (Cell t : cells) {
            if (!t.getColumn().getName().equalsIgnoreCase(columnName)) continue;
            return t;
        }
        return null;
    }

    @Override
    public List<Base> resolveConstant(FHIRPathEngine engine, Object appContext, String name, boolean beforeContext, boolean explicitConstant) throws PathEngineException {
        Base b;
        JsonObject vd;
        JsonObject constant;
        ArrayList<Base> list = new ArrayList<Base>();
        if (explicitConstant && (constant = this.findConstant(vd = (JsonObject)appContext, name)) != null && (b = (Base)constant.getUserData("value")) != null) {
            list.add(b);
        }
        return list;
    }

    @Override
    public TypeDetails resolveConstantType(FHIRPathEngine engine, Object appContext, String name, boolean explicitConstant) throws PathEngineException {
        if (explicitConstant) {
            Element v;
            Element vd;
            Element constant;
            if (appContext instanceof JsonObject) {
                Base b;
                JsonObject vd2 = (JsonObject)appContext;
                JsonObject constant2 = this.findConstant(vd2, name.substring(1));
                if (constant2 != null && (b = (Base)constant2.getUserData("value")) != null) {
                    return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, b.fhirType());
                }
            } else if (appContext instanceof Element && (constant = this.findConstant(vd = (Element)appContext, name.substring(1))) != null && (v = constant.getNamedChild("value")) != null) {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, v.fhirType());
            }
        }
        return null;
    }

    private JsonObject findConstant(JsonObject vd, String name) {
        for (JsonObject o : vd.getJsonObjects("constant")) {
            if (!name.equals(o.asString("name"))) continue;
            return o;
        }
        return null;
    }

    private Element findConstant(Element vd, String name) {
        for (Element o : vd.getChildren("constant")) {
            if (!name.equals(o.getNamedChildValue("name"))) continue;
            return o;
        }
        return null;
    }

    @Override
    public boolean log(String argument, List<Base> focus) {
        throw new Error("Not implemented yet: log");
    }

    @Override
    public FHIRPathUtilityClasses.FunctionDetails resolveFunction(FHIRPathEngine engine, String functionName) {
        switch (functionName) {
            case "getResourceKey": {
                return new FHIRPathUtilityClasses.FunctionDetails("Unique Key for resource", 0, 0);
            }
            case "getReferenceKey": {
                return new FHIRPathUtilityClasses.FunctionDetails("Unique Key for resource that is the target of the reference", 0, 1);
            }
        }
        return null;
    }

    @Override
    public TypeDetails checkFunction(FHIRPathEngine engine, Object appContext, String functionName, TypeDetails focus, List<TypeDetails> parameters) throws PathEngineException {
        switch (functionName) {
            case "getResourceKey": {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
            }
            case "getReferenceKey": {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
            }
        }
        throw new Error("Not known: " + functionName);
    }

    @Override
    public List<Base> executeFunction(FHIRPathEngine engine, Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
        switch (functionName) {
            case "getResourceKey": {
                return this.executeResourceKey(focus);
            }
            case "getReferenceKey": {
                return this.executeReferenceKey(null, focus, parameters);
            }
        }
        throw new Error("Not known: " + functionName);
    }

    private List<Base> executeResourceKey(List<Base> focus) {
        ArrayList<Base> base = new ArrayList<Base>();
        if (focus.size() == 1) {
            Base res = focus.get(0);
            if (!res.hasUserData("Storage.key")) {
                String key = this.storage.getKeyForSourceResource(res);
                if (key == null) {
                    throw new FHIRException("Unidentified resource: " + res.fhirType() + "/" + res.getIdBase());
                }
                res.setUserData("Storage.key", key);
            }
            base.add(new StringType(res.getUserString("Storage.key")));
        }
        return base;
    }

    private List<Base> executeReferenceKey(Base rootResource, List<Base> focus, List<List<Base>> parameters) {
        String rt = null;
        if (parameters.size() > 0 && (rt = parameters.get(0).get(0).primitiveValue()).startsWith("FHIR.")) {
            rt = rt.substring(5);
        }
        ArrayList<Base> base = new ArrayList<Base>();
        if (focus.size() == 1) {
            Base target;
            Base res = focus.get(0);
            String ref = null;
            if (res.fhirType().equals("Reference")) {
                ref = this.getRef(res);
            } else if (res.isPrimitive()) {
                ref = res.primitiveValue();
            } else {
                throw new FHIRException("Unable to generate a reference key based on a " + res.fhirType());
            }
            if (ref != null && (target = this.provider.resolveReference(rootResource, ref, rt)) != null) {
                if (!res.hasUserData("Storage.key")) {
                    String key = this.storage.getKeyForTargetResource(target);
                    if (key == null) {
                        throw new FHIRException("Unidentified resource: " + res.fhirType() + "/" + res.getIdBase());
                    }
                    res.setUserData("Storage.key", key);
                }
                base.add(new StringType(res.getUserString("Storage.key")));
            }
        }
        return base;
    }

    private String getRef(Base res) {
        Property prop = res.getChildByName("reference");
        if (prop != null && prop.getValues().size() == 1) {
            return prop.getValues().get(0).primitiveValue();
        }
        return null;
    }

    @Override
    public Base resolveReference(FHIRPathEngine engine, Object appContext, String url, Base refContext) throws FHIRException {
        throw new Error("Not implemented yet: resolveReference");
    }

    @Override
    public boolean conformsToProfile(FHIRPathEngine engine, Object appContext, Base item, String url) throws FHIRException {
        throw new Error("Not implemented yet: conformsToProfile");
    }

    @Override
    public ValueSet resolveValueSet(FHIRPathEngine engine, Object appContext, String url) {
        throw new Error("Not implemented yet: resolveValueSet");
    }

    @Override
    public boolean paramIsType(String name, int index) {
        return "getReferenceKey".equals(name);
    }

    public List<ValidationMessage> getIssues() {
        return this.issues;
    }

    public class WorkContext {
        private JsonObject vd;
        private Store store;

        protected WorkContext(JsonObject vd) {
            this.vd = vd;
        }
    }

    public static interface IRunnerObserver {
        public void handleRow(Base var1, int var2, int var3);
    }
}

