/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.comparison.CanonicalResourceComparer;
import org.hl7.fhir.r5.comparison.ComparisonSession;
import org.hl7.fhir.r5.comparison.ResourceComparer;
import org.hl7.fhir.r5.comparison.StructuralMatch;
import org.hl7.fhir.r5.comparison.StructureDefinitionComparer;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.RenderingI18nContext;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class CapabilityStatementComparer
extends CanonicalResourceComparer {
    public CapabilityStatementComparer(ComparisonSession session) {
        super(session);
    }

    public CapabilityStatementComparison compare(CapabilityStatement left, CapabilityStatement right) throws DefinitionException, FHIRFormatError, IOException {
        if (left == null) {
            throw new DefinitionException("No CapabilityStatement provided (left)");
        }
        if (right == null) {
            throw new DefinitionException("No CapabilityStatement provided (right)");
        }
        CapabilityStatementComparison res = new CapabilityStatementComparison(left, right);
        this.session.identify(res);
        CapabilityStatement cs = new CapabilityStatement();
        res.setUnion(cs);
        this.session.identify(cs);
        cs.setName("Union" + left.getName() + "And" + right.getName());
        cs.setTitle("Union of " + left.getTitle() + " And " + right.getTitle());
        cs.setStatus(left.getStatus());
        cs.setDate(new Date());
        CapabilityStatement cs1 = new CapabilityStatement();
        res.setIntersection(cs1);
        this.session.identify(cs1);
        cs1.setName("Intersection" + left.getName() + "And" + right.getName());
        cs1.setTitle("Intersection of " + left.getTitle() + " And " + right.getTitle());
        cs1.setStatus(left.getStatus());
        cs1.setDate(new Date());
        this.compareMetadata(left, right, res.getMetadata(), res, new ArrayList<String>(), right);
        this.comparePrimitives("kind", left.getKindElement(), right.getKindElement(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res);
        this.compareCanonicalList("instantiates", left.getInstantiates(), right.getInstantiates(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res, cs.getInstantiates(), cs1.getInstantiates());
        this.compareCanonicalList("imports", left.getImports(), right.getImports(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res, cs.getImports(), cs1.getImports());
        this.comparePrimitives("software.name", left.getSoftware().getNameElement(), right.getSoftware().getNameElement(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res);
        this.comparePrimitives("software.version", left.getSoftware().getVersionElement(), right.getSoftware().getVersionElement(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res);
        this.comparePrimitives("software.releaseDate", left.getSoftware().getReleaseDateElement(), right.getSoftware().getReleaseDateElement(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res);
        this.comparePrimitives("implementation.description", left.getImplementation().getDescriptionElement(), right.getImplementation().getDescriptionElement(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res);
        this.comparePrimitives("implementation.url", left.getImplementation().getUrlElement(), right.getImplementation().getUrlElement(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res);
        this.comparePrimitives("fhirVersion", left.getFhirVersionElement(), right.getFhirVersionElement(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res);
        this.compareCodeList("format", left.getFormat(), right.getFormat(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res, cs.getFormat(), cs1.getFormat());
        this.compareCodeList("patchFormat", left.getPatchFormat(), right.getPatchFormat(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res, cs.getPatchFormat(), cs1.getPatchFormat());
        this.compareCanonicalList("implementationGuide", left.getImplementationGuide(), right.getImplementationGuide(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res, cs.getImplementationGuide(), cs1.getImplementationGuide());
        this.compareRests(left.getRest(), right.getRest(), res.getCombined(), ((CapabilityStatement)res.getUnion()).getRest(), ((CapabilityStatement)res.getIntersection()).getRest(), (CapabilityStatement)res.getUnion(), (CapabilityStatement)res.getIntersection(), res, "CapabilityStatement.rest");
        return res;
    }

    private void compareRests(List<CapabilityStatement.CapabilityStatementRestComponent> left, List<CapabilityStatement.CapabilityStatementRestComponent> right, StructuralMatch<Element> combined, List<CapabilityStatement.CapabilityStatementRestComponent> union, List<CapabilityStatement.CapabilityStatementRestComponent> intersection, CapabilityStatement csU, CapabilityStatement csI, CapabilityStatementComparison res, String path) throws DefinitionException, FHIRFormatError, IOException {
        ArrayList<CapabilityStatement.CapabilityStatementRestComponent> matchR = new ArrayList<CapabilityStatement.CapabilityStatementRestComponent>();
        for (CapabilityStatement.CapabilityStatementRestComponent l : left) {
            CapabilityStatement.CapabilityStatementRestComponent r = this.findInList(right, l);
            if (r == null) {
                union.add(l);
                combined.getChildren().add(new StructuralMatch<CapabilityStatement.CapabilityStatementRestComponent>(l, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed this item", path)));
                continue;
            }
            matchR.add(r);
            CapabilityStatement.CapabilityStatementRestComponent cdM = this.merge(l, r, res);
            CapabilityStatement.CapabilityStatementRestComponent cdI = this.intersect(l, r, res);
            union.add(cdM);
            intersection.add(cdI);
            StructuralMatch<Element> sm = new StructuralMatch<Element>(l, r);
            this.compare(sm, l, r, path + ".where(mode='" + String.valueOf((Object)l.getMode()) + "')", res);
            combined.getChildren().add(sm);
            this.compareRestSecurity(l, r, sm, cdM.getSecurity(), cdI.getSecurity(), csU, csI, res, path + ".security");
            this.compareRestResources(l, r, sm, cdM, cdI, csU, csI, res, path + ".resource");
            this.compareSearchParams(combined, l.getSearchParam(), r.getSearchParam(), path, res, cdM.getSearchParam(), cdI.getSearchParam());
            this.compareOperations(combined, l.getOperation(), r.getOperation(), path, res, cdM.getOperation(), cdI.getOperation());
            this.compareItemPropertyList(sm, "compartment", l.getCompartment(), r.getCompartment(), path, res, cdM.getCompartment(), cdI.getCompartment(), ValidationMessage.IssueSeverity.ERROR);
        }
        for (CapabilityStatement.CapabilityStatementRestComponent r : right) {
            if (matchR.contains(r)) continue;
            union.add(r);
            combined.getChildren().add(new StructuralMatch<CapabilityStatement.CapabilityStatementRestComponent>(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added this concept", path), r));
        }
    }

    private CapabilityStatement.CapabilityStatementRestComponent findInList(List<CapabilityStatement.CapabilityStatementRestComponent> list, CapabilityStatement.CapabilityStatementRestComponent item) {
        for (CapabilityStatement.CapabilityStatementRestComponent t : list) {
            if (!t.getMode().equals((Object)item.getMode())) continue;
            return t;
        }
        return null;
    }

    private void compare(StructuralMatch<Element> sm, CapabilityStatement.CapabilityStatementRestComponent l, CapabilityStatement.CapabilityStatementRestComponent r, String path, CapabilityStatementComparison res) {
        this.compareStrings(path, sm.getMessages(), l.getDocumentation(), r.getDocumentation(), "documentation", ValidationMessage.IssueSeverity.WARNING, res);
    }

    private void compareRestSecurity(CapabilityStatement.CapabilityStatementRestComponent l, CapabilityStatement.CapabilityStatementRestComponent r, StructuralMatch<Element> smp, CapabilityStatement.CapabilityStatementRestSecurityComponent merge, CapabilityStatement.CapabilityStatementRestSecurityComponent intersect, CapabilityStatement csU, CapabilityStatement csI, CapabilityStatementComparison res, String path) {
        CapabilityStatement.CapabilityStatementRestSecurityComponent ls = l.hasSecurity() ? l.getSecurity() : null;
        CapabilityStatement.CapabilityStatementRestSecurityComponent rs = r.hasSecurity() ? r.getSecurity() : null;
        StructuralMatch<Element> sm = new StructuralMatch<Element>(ls, rs);
        smp.getChildren().add(sm);
        this.compareBooleans(path, sm.getMessages(), l.getSecurity().getCorsElement(), r.getSecurity().getCorsElement(), "security.cors", ValidationMessage.IssueSeverity.WARNING, res);
        this.compareStrings(path, sm.getMessages(), l.getSecurity().getDescription(), r.getSecurity().getDescription(), "security.description", ValidationMessage.IssueSeverity.INFORMATION, res);
        this.compareRestSecurityService(ls, rs, sm, merge, intersect, csU, csI, res, path + ".security");
    }

    private void compareRestSecurityService(CapabilityStatement.CapabilityStatementRestSecurityComponent left, CapabilityStatement.CapabilityStatementRestSecurityComponent right, StructuralMatch<Element> combined, CapabilityStatement.CapabilityStatementRestSecurityComponent union, CapabilityStatement.CapabilityStatementRestSecurityComponent intersection, CapabilityStatement csU, CapabilityStatement csI, CapabilityStatementComparison res, String path) {
        ArrayList<CodeableConcept> matchR = new ArrayList<CodeableConcept>();
        if (left != null) {
            for (CodeableConcept l : left.getService()) {
                CodeableConcept r = this.findInList(right.getService(), l);
                if (r == null) {
                    union.getService().add(l);
                    combined.getChildren().add(new StructuralMatch<CodeableConcept>(l, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed this item", path)));
                    continue;
                }
                matchR.add(r);
                CodeableConcept cdM = CodeableConcept.merge(l, r);
                CodeableConcept cdI = CodeableConcept.intersect(l, r);
                union.getService().add(cdM);
                intersection.getService().add(cdI);
                StructuralMatch<Element> sm = new StructuralMatch<Element>(l, r);
                this.compare(sm, l, r, path, res);
                combined.getChildren().add(sm);
            }
        }
        if (right != null) {
            for (CodeableConcept r : right.getService()) {
                if (matchR.contains(r)) continue;
                union.getService().add(r);
                combined.getChildren().add(new StructuralMatch<CodeableConcept>(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added this concept", path), r));
            }
        }
    }

    private void compare(StructuralMatch<Element> sm, CodeableConcept l, CodeableConcept r, String path, CapabilityStatementComparison res) {
        this.compareStrings(path, sm.getMessages(), l.getText(), r.getText(), "text", ValidationMessage.IssueSeverity.INFORMATION, res);
        ArrayList<Coding> matches = new ArrayList<Coding>();
        for (Coding lc : l.getCoding()) {
            boolean m = false;
            for (Coding rc : r.getCoding()) {
                if (!lc.matches(rc)) continue;
                matches.add(rc);
                m = true;
            }
            if (m) continue;
            sm.getMessages().add(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Value for " + this.gen(lc) + " removed", path));
        }
        for (Coding rc : r.getCoding()) {
            if (matches.contains(rc)) continue;
            sm.getMessages().add(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Value for " + this.gen(rc) + " added", path));
        }
    }

    private CodeableConcept findInList(List<CodeableConcept> list, CodeableConcept item) {
        for (CodeableConcept t : list) {
            if (!t.matches(item)) continue;
            return t;
        }
        return null;
    }

    private void compareStrings(String path, List<ValidationMessage> msgs, String left, String right, String name, ValidationMessage.IssueSeverity level, CapabilityStatementComparison res) {
        if (!Utilities.noString((String)right)) {
            if (Utilities.noString((String)left)) {
                msgs.add(this.vmI(level, "Value for " + name + " added", path));
            } else if (!left.equals(right)) {
                if (level != ValidationMessage.IssueSeverity.NULL) {
                    res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path + "." + name, "Changed value for " + name + ": '" + left + "' vs '" + right + "'", level));
                }
                msgs.add(this.vmI(level, name + " changed from left to right", path));
            }
        } else if (!Utilities.noString((String)left)) {
            msgs.add(this.vmI(level, "Value for " + name + " removed", path));
        }
    }

    private void compareExpectations(StructuralMatch<Element> combined, Element left, Element right, String path, CapabilityStatementComparison res, Element union, Element intersection) {
        List<Extension> l = left.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation");
        List<Extension> r = right.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation");
        if (l.size() == 1 || r.size() == 1) {
            if (l.size() == 0) {
                union.addExtension(r.get(0).copy());
                combined.getChildren().add(new StructuralMatch<Element>(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added this expectation", path), (Element)r.get(0)));
            } else if (r.size() == 0) {
                union.addExtension(l.get(0).copy());
                combined.getChildren().add(new StructuralMatch<Element>((Element)l.get(0), this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed this expectation", path)));
            } else if (l.size() == 1 && r.size() == 1) {
                StructuralMatch<Element> sm = new StructuralMatch<Element>((Element)l.get(0), (Element)r.get(0));
                combined.getChildren().add(sm);
                String ls = l.get(0).getValue().primitiveValue();
                String rs = r.get(0).getValue().primitiveValue();
                if (ls.equals(rs)) {
                    union.addExtension(l.get(0).copy());
                    intersection.addExtension(l.get(0).copy());
                } else {
                    sm.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path + ".extension('http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation')", "Changed value for expectation: '" + ls + "' vs '" + rs + "'", ValidationMessage.IssueSeverity.WARNING));
                    String lowest = this.lower(ls, rs) ? ls : rs;
                    String highest = this.lower(ls, rs) ? rs : ls;
                    union.addExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation", new CodeType(lowest));
                    intersection.addExtension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation", new CodeType(highest));
                }
            }
        }
    }

    private boolean lower(String ls, String rs) {
        if (ls.equals("MAY")) {
            return true;
        }
        if (ls.equals("SHALL")) {
            return false;
        }
        if (rs.equals("MAY")) {
            return false;
        }
        return rs.equals("SHALL");
    }

    private void compareBooleans(String path, List<ValidationMessage> msgs, BooleanType left, BooleanType right, String name, ValidationMessage.IssueSeverity level, CapabilityStatementComparison res) {
        if (!right.isEmpty()) {
            if (left.isEmpty()) {
                msgs.add(this.vmI(level, "Value for " + name + " added", path));
            } else if (left.getValue() != right.getValue()) {
                if (level != ValidationMessage.IssueSeverity.NULL) {
                    res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path + "." + name, "Changed value for " + name + ": '" + String.valueOf(left) + "' vs '" + String.valueOf(right) + "'", level));
                }
                msgs.add(this.vmI(level, name + " changed from left to right", path));
            }
        } else if (!left.isEmpty()) {
            msgs.add(this.vmI(level, "Value for " + name + " removed", path));
        }
    }

    private CapabilityStatement.CapabilityStatementRestComponent merge(CapabilityStatement.CapabilityStatementRestComponent l, CapabilityStatement.CapabilityStatementRestComponent r, CapabilityStatementComparison res) {
        CapabilityStatement.CapabilityStatementRestComponent cd = l.copy();
        if (!l.hasDocumentation() && r.hasDocumentation()) {
            cd.setDocumentation(r.getDocumentation());
        }
        if (r.hasSecurity()) {
            if (!l.getSecurity().hasCors() && r.getSecurity().hasCors()) {
                cd.getSecurity().setCors(r.getSecurity().getCors());
            }
            this.mergeCodeableConcepts(cd.getSecurity().getService(), r.getSecurity().getService());
            if (!l.getSecurity().hasDescription() && r.getSecurity().hasDescription()) {
                cd.getSecurity().setDescription(r.getSecurity().getDescription());
            }
        }
        return cd;
    }

    private void mergeCodeableConcepts(List<CodeableConcept> tgt, List<CodeableConcept> src) {
        for (CodeableConcept cd : src) {
            boolean add = true;
            for (CodeableConcept t : tgt) {
                if (!t.matches(cd)) continue;
                add = false;
            }
            if (!add) continue;
            tgt.add(cd.copy());
        }
    }

    private CapabilityStatement.CapabilityStatementRestComponent intersect(CapabilityStatement.CapabilityStatementRestComponent l, CapabilityStatement.CapabilityStatementRestComponent r, CapabilityStatementComparison res) {
        CapabilityStatement.CapabilityStatementRestComponent cd = l.copy();
        if (l.hasDocumentation() && !r.hasDocumentation()) {
            cd.setDocumentation(null);
        }
        if (!r.hasSecurity()) {
            cd.setSecurity(null);
        } else {
            if (!r.getSecurity().hasCors()) {
                cd.getSecurity().setCorsElement(null);
            }
            this.intersectCodeableConcepts(cd.getSecurity().getService(), r.getSecurity().getService());
            if (!r.getSecurity().hasDescription()) {
                cd.getSecurity().setDescription(null);
            }
        }
        return cd;
    }

    private void intersectCodeableConcepts(List<CodeableConcept> tgt, List<CodeableConcept> src) {
        ArrayList<CodeableConcept> toRemove = new ArrayList<CodeableConcept>();
        for (CodeableConcept cd : src) {
            boolean remove = false;
            for (CodeableConcept t : tgt) {
                if (!t.matches(cd)) continue;
                remove = true;
            }
            if (!remove) continue;
            toRemove.add(cd);
        }
        tgt.removeAll(toRemove);
    }

    private void compareRestResources(CapabilityStatement.CapabilityStatementRestComponent left, CapabilityStatement.CapabilityStatementRestComponent right, StructuralMatch<Element> combined, CapabilityStatement.CapabilityStatementRestComponent union, CapabilityStatement.CapabilityStatementRestComponent intersection, CapabilityStatement csU, CapabilityStatement csI, CapabilityStatementComparison res, String path) throws DefinitionException, FHIRFormatError, IOException {
        ArrayList<CapabilityStatement.CapabilityStatementRestResourceComponent> matchR = new ArrayList<CapabilityStatement.CapabilityStatementRestResourceComponent>();
        for (CapabilityStatement.CapabilityStatementRestResourceComponent l : left.getResource()) {
            CapabilityStatement.CapabilityStatementRestResourceComponent r = this.findInList(right.getResource(), l);
            if (r == null) {
                union.getResource().add(l);
                combined.getChildren().add(new StructuralMatch<CapabilityStatement.CapabilityStatementRestResourceComponent>(l, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed this item", path)));
                continue;
            }
            matchR.add(r);
            CapabilityStatement.CapabilityStatementRestResourceComponent cdM = this.mergeRestResource(l, r);
            CapabilityStatement.CapabilityStatementRestResourceComponent cdI = this.intersectRestResource(l, r);
            union.getResource().add(cdM);
            intersection.getResource().add(cdI);
            StructuralMatch<Element> sm = new StructuralMatch<Element>(l, r);
            this.compareRestResource(sm, l, r, path, res, cdM, cdI);
            combined.getChildren().add(sm);
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent r : right.getResource()) {
            if (matchR.contains(r)) continue;
            union.getResource().add(r);
            combined.getChildren().add(new StructuralMatch<CapabilityStatement.CapabilityStatementRestResourceComponent>(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added this concept", path), r));
        }
    }

    private void compareRestResource(StructuralMatch<Element> sm, CapabilityStatement.CapabilityStatementRestResourceComponent l, CapabilityStatement.CapabilityStatementRestResourceComponent r, String path, CapabilityStatementComparison res, CapabilityStatement.CapabilityStatementRestResourceComponent union, CapabilityStatement.CapabilityStatementRestResourceComponent intersection) throws DefinitionException, FHIRFormatError, IOException {
        this.compareProfiles(path, sm, l.getProfileElement(), r.getProfileElement(), res, union, intersection);
        this.compareStrings(path, sm.getMessages(), l.getDocumentation(), r.getDocumentation(), "documentation", ValidationMessage.IssueSeverity.INFORMATION, res);
        this.compareExpectations(sm, l, r, path, res, union, intersection);
        this.compareRestResourceInteractions(sm, l, r, path, res, union, intersection);
        this.compareItemProperty(sm, "versioning", l.getVersioningElement(), r.getVersioningElement(), path, res, union.getVersioningElement(), intersection.getVersioningElement(), ValidationMessage.IssueSeverity.WARNING);
        this.compareItemProperty(sm, "readHistory", l.getReadHistoryElement(), r.getReadHistoryElement(), path, res, union.getReadHistoryElement(), intersection.getReadHistoryElement(), ValidationMessage.IssueSeverity.INFORMATION);
        this.compareItemProperty(sm, "updateCreate", l.getUpdateCreateElement(), r.getUpdateCreateElement(), path, res, union.getUpdateCreateElement(), intersection.getUpdateCreateElement(), ValidationMessage.IssueSeverity.WARNING);
        this.compareItemProperty(sm, "conditionalCreate", l.getConditionalCreateElement(), r.getConditionalCreateElement(), path, res, union.getConditionalCreateElement(), intersection.getConditionalCreateElement(), ValidationMessage.IssueSeverity.WARNING);
        this.compareItemProperty(sm, "conditionalRead", l.getConditionalReadElement(), r.getConditionalReadElement(), path, res, union.getConditionalReadElement(), intersection.getConditionalReadElement(), ValidationMessage.IssueSeverity.WARNING);
        this.compareItemProperty(sm, "conditionalUpdate", l.getConditionalUpdateElement(), r.getConditionalUpdateElement(), path, res, union.getConditionalUpdateElement(), intersection.getConditionalUpdateElement(), ValidationMessage.IssueSeverity.WARNING);
        this.compareItemProperty(sm, "conditionalDelete", l.getConditionalDeleteElement(), r.getConditionalDeleteElement(), path, res, union.getConditionalDeleteElement(), intersection.getConditionalDeleteElement(), ValidationMessage.IssueSeverity.WARNING);
        this.compareItemPropertyList(sm, "referencePolicy", l.getReferencePolicy(), r.getReferencePolicy(), path, res, union.getReferencePolicy(), intersection.getReferencePolicy(), ValidationMessage.IssueSeverity.WARNING);
        this.compareItemPropertyList(sm, "searchInclude", l.getSearchInclude(), r.getSearchInclude(), path, res, union.getSearchInclude(), intersection.getSearchInclude(), ValidationMessage.IssueSeverity.WARNING);
        this.compareItemPropertyList(sm, "searchRevInclude", l.getSearchRevInclude(), r.getSearchRevInclude(), path, res, union.getSearchRevInclude(), intersection.getSearchRevInclude(), ValidationMessage.IssueSeverity.WARNING);
        this.compareSearchParams(sm, l.getSearchParam(), r.getSearchParam(), path, res, union.getSearchParam(), intersection.getSearchParam());
        this.compareOperations(sm, l.getOperation(), r.getOperation(), path, res, union.getOperation(), intersection.getOperation());
    }

    private void compareProfiles(String path, StructuralMatch<Element> combined, CanonicalType left, CanonicalType right, CapabilityStatementComparison res, CapabilityStatement.CapabilityStatementRestResourceComponent union, CapabilityStatement.CapabilityStatementRestResourceComponent intersection) throws DefinitionException, FHIRFormatError, IOException {
        if (left.hasValue() || right.hasValue()) {
            if (!left.hasValue()) {
                intersection.setProfileElement(right.copy());
                combined.getChildren().add(new StructuralMatch<CanonicalType>(this.vmI(ValidationMessage.IssueSeverity.WARNING, "Added this profile", path), right).setName("profile"));
            } else if (!right.hasValue()) {
                intersection.setProfileElement(left.copy());
                combined.getChildren().add(new StructuralMatch<CanonicalType>(left, this.vmI(ValidationMessage.IssueSeverity.WARNING, "Removed this profile", path)).setName("profile"));
            } else {
                StructureDefinition sdLeft = this.session.getContextLeft().fetchResource(StructureDefinition.class, (String)left.getValue());
                StructureDefinition sdRight = this.session.getContextRight().fetchResource(StructureDefinition.class, (String)right.getValue());
                if (sdLeft == null && sdRight == null) {
                    combined.getChildren().add(new StructuralMatch<CanonicalType>(left, right, this.vmI(ValidationMessage.IssueSeverity.ERROR, "Cannot compare profiles because neither is known", path)).setName("profile"));
                } else if (sdLeft == null) {
                    combined.getChildren().add(new StructuralMatch<CanonicalType>(left, right, this.vmI(ValidationMessage.IssueSeverity.ERROR, "Cannot compare profiles because '" + (String)left.getValue() + "' is not known", path)).setName("profile"));
                } else if (sdRight == null) {
                    combined.getChildren().add(new StructuralMatch<CanonicalType>(left, right, this.vmI(ValidationMessage.IssueSeverity.ERROR, "Cannot compare profiles because '" + (String)right.getValue() + "' is not known", path)).setName("profile"));
                } else if (sdLeft.getUrl().equals(sdRight.getUrl())) {
                    intersection.setProfileElement(left.copy());
                    union.setProfileElement(left.copy());
                    combined.getChildren().add(new StructuralMatch<CanonicalType>(left, right).setName("profile"));
                } else if (this.profileInherits(sdLeft, sdRight, this.session.getContextLeft())) {
                    intersection.setProfileElement(left.copy());
                    union.setProfileElement(right.copy());
                    combined.getChildren().add(new StructuralMatch<CanonicalType>(left, right, this.vmI(ValidationMessage.IssueSeverity.WARNING, "Changed this profile to a broader profile", path)).setName("profile"));
                } else if (this.profileInherits(sdRight, sdLeft, this.session.getContextRight())) {
                    intersection.setProfileElement(right.copy());
                    union.setProfileElement(left.copy());
                    combined.getChildren().add(new StructuralMatch<CanonicalType>(left, right, this.vmI(ValidationMessage.IssueSeverity.WARNING, "Changed this profile to a narrower one", path)).setName("profile"));
                } else {
                    combined.getChildren().add(new StructuralMatch<CanonicalType>(left, right, this.vmI(ValidationMessage.IssueSeverity.WARNING, "Different", path)).setName("profile"));
                    StructureDefinitionComparer.ProfileComparison pc = (StructureDefinitionComparer.ProfileComparison)this.session.compare(sdLeft, sdRight);
                    intersection.setProfile(((StructureDefinition)pc.getIntersection()).getUrl());
                    union.setProfile(((StructureDefinition)pc.getUnion()).getUrl());
                }
            }
        }
    }

    private boolean profileInherits(StructureDefinition sdFocus, StructureDefinition sdOther, IWorkerContext ctxt) {
        while (sdFocus != null) {
            if (sdFocus.getUrl().equals(sdOther.getUrl()) && sdFocus.getVersion().equals(sdOther.getVersion())) {
                return true;
            }
            sdFocus = ctxt.fetchResource(StructureDefinition.class, sdFocus.getBaseDefinition(), sdFocus);
        }
        return false;
    }

    private <T> void compareItemProperty(StructuralMatch<Element> combined, String name, PrimitiveType<T> left, PrimitiveType<T> right, String path, CapabilityStatementComparison res, PrimitiveType<T> union, PrimitiveType<T> intersection, ValidationMessage.IssueSeverity issueSeverity) {
        if (!left.isEmpty() || !right.isEmpty()) {
            if (left.isEmpty()) {
                union.copyValues(right);
                combined.getChildren().add(new StructuralMatch<PrimitiveType<T>>(this.vmI(issueSeverity, "Added this " + name, path), right).setName(name));
            } else if (right.isEmpty()) {
                union.copyValues(left);
                combined.getChildren().add(new StructuralMatch<PrimitiveType<T>>(left, this.vmI(issueSeverity, "Removed this expectation", path)).setName(name));
            } else {
                StructuralMatch<Element> sm = new StructuralMatch<PrimitiveType<T>>(left, right).setName(name);
                combined.getChildren().add(sm);
                String ls = left.primitiveValue();
                String rs = right.primitiveValue();
                if (ls.equals(rs)) {
                    union.copyValues(left);
                    intersection.copyValues(left);
                } else {
                    sm.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, path + "." + name, "Changed value for " + name + ": '" + ls + "' vs '" + rs + "'", issueSeverity));
                    union.copyValues(left);
                    intersection.copyValues(left);
                }
                this.compareExpectations(sm, left, right, path, res, union, intersection);
            }
        }
    }

    private <T extends Element> void compareItemPropertyList(StructuralMatch<Element> combined, String name, List<T> left, List<T> right, String path, CapabilityStatementComparison res, List<T> union, List<T> intersection, ValidationMessage.IssueSeverity issueSeverity) {
        ArrayList<Element> matchR = new ArrayList<Element>();
        for (Element l : left) {
            Element r = this.findInListT(right, l);
            if (r == null) {
                union.add(l);
                combined.getChildren().add(new StructuralMatch<Element>(l, this.vmI(issueSeverity, "Removed this " + name, path)).setName(name));
                continue;
            }
            matchR.add(r);
            union.add(l);
            intersection.add(l);
            StructuralMatch<Element> sm = new StructuralMatch<Element>(l, r).setName(name);
            combined.getChildren().add(sm);
        }
        for (Element r : right) {
            if (matchR.contains(r)) continue;
            union.add(r);
            combined.getChildren().add(new StructuralMatch<Element>(this.vmI(issueSeverity, "Added this " + name, path), r).setName(name));
        }
    }

    private <T extends Element> T findInListT(List<T> list, T item) {
        for (Element t : list) {
            if (!t.equalsDeep(item)) continue;
            return (T)t;
        }
        return null;
    }

    private CapabilityStatement.CapabilityStatementRestResourceComponent mergeRestResource(CapabilityStatement.CapabilityStatementRestResourceComponent l, CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        CapabilityStatement.CapabilityStatementRestResourceComponent res = l.copy();
        if (!l.hasProfile() && r.hasProfile()) {
            res.setProfile(r.getProfile());
        }
        if (!l.hasDocumentation() && r.hasDocumentation()) {
            res.setDocumentation(r.getDocumentation());
        }
        return res;
    }

    private CapabilityStatement.CapabilityStatementRestResourceComponent intersectRestResource(CapabilityStatement.CapabilityStatementRestResourceComponent l, CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        res.setType(l.getType());
        if (l.hasProfile() && l.getProfile().equals(r.getProfile())) {
            res.setProfile(l.getProfile());
        }
        if (l.hasDocumentation() && l.getDocumentation().equals(r.getDocumentation())) {
            res.setDocumentation(l.getDocumentation());
        }
        return res;
    }

    private CapabilityStatement.CapabilityStatementRestResourceComponent findInList(List<CapabilityStatement.CapabilityStatementRestResourceComponent> list, CapabilityStatement.CapabilityStatementRestResourceComponent item) {
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : list) {
            if (!t.hasType() || !t.getType().equals(item.getType())) continue;
            return t;
        }
        return null;
    }

    private void compareRestResourceInteractions(StructuralMatch<Element> combined, CapabilityStatement.CapabilityStatementRestResourceComponent left, CapabilityStatement.CapabilityStatementRestResourceComponent right, String path, CapabilityStatementComparison res, CapabilityStatement.CapabilityStatementRestResourceComponent union, CapabilityStatement.CapabilityStatementRestResourceComponent intersection) {
        ArrayList<CapabilityStatement.ResourceInteractionComponent> matchR = new ArrayList<CapabilityStatement.ResourceInteractionComponent>();
        for (CapabilityStatement.ResourceInteractionComponent l : left.getInteraction()) {
            CapabilityStatement.ResourceInteractionComponent r = this.findInList(right.getInteraction(), l);
            if (r == null) {
                union.getInteraction().add(l);
                combined.getChildren().add(new StructuralMatch<CapabilityStatement.ResourceInteractionComponent>(l, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed this item", path)));
                continue;
            }
            matchR.add(r);
            CapabilityStatement.ResourceInteractionComponent cdM = this.mergeRestResourceInteractions(l, r);
            CapabilityStatement.ResourceInteractionComponent cdI = this.intersectRestResourceInteractions(l, r);
            union.getInteraction().add(cdM);
            intersection.getInteraction().add(cdI);
            StructuralMatch<Element> sm = new StructuralMatch<Element>(l, r);
            this.compareStrings(path, sm.getMessages(), l.getDocumentation(), r.getDocumentation(), "documentation", ValidationMessage.IssueSeverity.INFORMATION, res);
            this.compareExpectations(sm, l, r, path, res, union, intersection);
            combined.getChildren().add(sm);
        }
        for (CapabilityStatement.ResourceInteractionComponent r : right.getInteraction()) {
            if (matchR.contains(r)) continue;
            union.getInteraction().add(r);
            combined.getChildren().add(new StructuralMatch<CapabilityStatement.ResourceInteractionComponent>(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added this concept", path), r));
        }
    }

    private CapabilityStatement.ResourceInteractionComponent mergeRestResourceInteractions(CapabilityStatement.ResourceInteractionComponent l, CapabilityStatement.ResourceInteractionComponent r) {
        CapabilityStatement.ResourceInteractionComponent res = l.copy();
        if (!res.hasDocumentation() && r.hasDocumentation()) {
            res.setDocumentation(r.getDocumentation());
        }
        return res;
    }

    private CapabilityStatement.ResourceInteractionComponent intersectRestResourceInteractions(CapabilityStatement.ResourceInteractionComponent l, CapabilityStatement.ResourceInteractionComponent r) {
        CapabilityStatement.ResourceInteractionComponent res = l.copy();
        if (res.hasDocumentation() && !r.hasDocumentation()) {
            res.setDocumentation(null);
        }
        return res;
    }

    private CapabilityStatement.ResourceInteractionComponent findInList(List<CapabilityStatement.ResourceInteractionComponent> list, CapabilityStatement.ResourceInteractionComponent item) {
        for (CapabilityStatement.ResourceInteractionComponent t : list) {
            if (!t.hasCode() || !t.getCode().equals((Object)item.getCode())) continue;
            return t;
        }
        return null;
    }

    private void compareSearchParams(StructuralMatch<Element> combined, List<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent> left, List<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent> right, String path, CapabilityStatementComparison res, List<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent> union, List<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent> intersection) {
        ArrayList<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent> matchR = new ArrayList<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent>();
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent l : left) {
            CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent r = this.findInList(right, l);
            if (r == null) {
                union.add(l);
                combined.getChildren().add(new StructuralMatch<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent>(l, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed this Search Parameter", path)));
                continue;
            }
            matchR.add(r);
            CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent cdM = this.mergeSearchParams(l, r);
            CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent cdI = this.intersectSearchParams(l, r);
            union.add(cdM);
            intersection.add(cdI);
            StructuralMatch<Element> sm = new StructuralMatch<Element>(l, r);
            this.compareStrings(path, sm.getMessages(), l.getDocumentation(), r.getDocumentation(), "documentation", ValidationMessage.IssueSeverity.INFORMATION, res);
            this.compareItemProperty(sm, "type", l.getTypeElement(), r.getTypeElement(), path, res, cdM.getTypeElement(), cdI.getTypeElement(), ValidationMessage.IssueSeverity.ERROR);
            this.compareItemProperty(sm, "definition", l.getDefinitionElement(), r.getDefinitionElement(), path, res, cdM.getDefinitionElement(), cdI.getDefinitionElement(), ValidationMessage.IssueSeverity.ERROR);
            this.compareExpectations(sm, l, r, path, res, cdM, cdI);
            combined.getChildren().add(sm);
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent r : right) {
            if (matchR.contains(r)) continue;
            union.add(r);
            combined.getChildren().add(new StructuralMatch<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent>(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added this Search Parameter", path), r));
        }
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent mergeSearchParams(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent l, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent r) {
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = l.copy();
        if (!res.hasDocumentation() && r.hasDocumentation()) {
            res.setDocumentation(r.getDocumentation());
        }
        return res;
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent intersectSearchParams(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent l, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent r) {
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        res.setName(l.getName());
        if (l.hasDocumentation() && r.hasDocumentation()) {
            res.setDocumentation(l.getDocumentation());
        }
        return res;
    }

    private CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent findInList(List<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent> list, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent item) {
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent t : list) {
            if (!t.hasName() || !t.getName().equals(item.getName())) continue;
            return t;
        }
        return null;
    }

    private void compareOperations(StructuralMatch<Element> combined, List<CapabilityStatement.CapabilityStatementRestResourceOperationComponent> left, List<CapabilityStatement.CapabilityStatementRestResourceOperationComponent> right, String path, CapabilityStatementComparison res, List<CapabilityStatement.CapabilityStatementRestResourceOperationComponent> union, List<CapabilityStatement.CapabilityStatementRestResourceOperationComponent> intersection) {
        ArrayList<CapabilityStatement.CapabilityStatementRestResourceOperationComponent> matchR = new ArrayList<CapabilityStatement.CapabilityStatementRestResourceOperationComponent>();
        for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent l : left) {
            CapabilityStatement.CapabilityStatementRestResourceOperationComponent r = this.findInList(right, l);
            if (r == null) {
                union.add(l);
                combined.getChildren().add(new StructuralMatch<CapabilityStatement.CapabilityStatementRestResourceOperationComponent>(l, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed this Search Parameter", path)));
                continue;
            }
            matchR.add(r);
            CapabilityStatement.CapabilityStatementRestResourceOperationComponent cdM = this.mergeOperations(l, r);
            CapabilityStatement.CapabilityStatementRestResourceOperationComponent cdI = this.intersectOperations(l, r);
            union.add(cdM);
            intersection.add(cdI);
            StructuralMatch<Element> sm = new StructuralMatch<Element>(l, r);
            this.compareStrings(path, sm.getMessages(), l.getDocumentation(), r.getDocumentation(), "documentation", ValidationMessage.IssueSeverity.INFORMATION, res);
            this.compareItemProperty(sm, "definition", l.getDefinitionElement(), r.getDefinitionElement(), path, res, cdM.getDefinitionElement(), cdI.getDefinitionElement(), ValidationMessage.IssueSeverity.ERROR);
            this.compareExpectations(sm, l, r, path, res, cdM, cdI);
            combined.getChildren().add(sm);
        }
        for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent r : right) {
            if (matchR.contains(r)) continue;
            union.add(r);
            combined.getChildren().add(new StructuralMatch<CapabilityStatement.CapabilityStatementRestResourceOperationComponent>(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added this Search Parameter", path), r));
        }
    }

    private CapabilityStatement.CapabilityStatementRestResourceOperationComponent mergeOperations(CapabilityStatement.CapabilityStatementRestResourceOperationComponent l, CapabilityStatement.CapabilityStatementRestResourceOperationComponent r) {
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent res = l.copy();
        if (!res.hasDocumentation() && r.hasDocumentation()) {
            res.setDocumentation(r.getDocumentation());
        }
        return res;
    }

    private CapabilityStatement.CapabilityStatementRestResourceOperationComponent intersectOperations(CapabilityStatement.CapabilityStatementRestResourceOperationComponent l, CapabilityStatement.CapabilityStatementRestResourceOperationComponent r) {
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent res = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
        res.setName(l.getName());
        if (l.hasDocumentation() && r.hasDocumentation()) {
            res.setDocumentation(l.getDocumentation());
        }
        return res;
    }

    private CapabilityStatement.CapabilityStatementRestResourceOperationComponent findInList(List<CapabilityStatement.CapabilityStatementRestResourceOperationComponent> list, CapabilityStatement.CapabilityStatementRestResourceOperationComponent item) {
        for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent t : list) {
            if (!t.hasName() || !t.getName().equals(item.getName())) continue;
            return t;
        }
        return null;
    }

    public XhtmlNode renderStatements(CapabilityStatementComparison comparison, String id, String prefix) throws FHIRException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(new RenderingI18nContext(), Utilities.path((String[])new String[]{"[tmp]", "compare"}), false, "c");
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, id, true);
        model.setAlternating(true);
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, null, "Type", "The type of item", null, 100));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, null, "Left Value", "The left value for the item", null, 200, 1));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, null, "Left Doco", "The left documentation for the item", null, 200, 1));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, null, "Right Value", "The right value for the item", null, 200, 1));
        List list5 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator6);
        list5.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator6, null, null, "Right Doco", "The right documentation for the item", null, 200, 1));
        List list6 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator7);
        list6.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator7, null, null, "Comments", "Additional information about the comparison", null, 200));
        for (StructuralMatch<Element> t : comparison.getCombined().getChildren()) {
            this.addRow(gen, model.getRows(), t, comparison);
        }
        return gen.generate(model, prefix, 0, null);
    }

    private void addRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t, CapabilityStatementComparison comparison) {
        HierarchicalTableGenerator.Row r = null;
        if (t.either() instanceof CapabilityStatement.CapabilityStatementRestComponent) {
            r = this.addRestRow(gen, rows, t, comparison);
        } else if (t.either() instanceof CapabilityStatement.CapabilityStatementRestSecurityComponent) {
            r = this.addRestSecurityRow(gen, rows, t, comparison);
        } else if (t.either() instanceof CapabilityStatement.CapabilityStatementRestResourceComponent) {
            r = this.addRestResourceRow(gen, rows, t, comparison);
        } else if (t.either() instanceof CapabilityStatement.ResourceInteractionComponent) {
            r = this.addRestResourceInteractionRow(gen, rows, t, comparison);
        } else if (t.either() instanceof CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent) {
            r = this.addRestSearchParamRow(gen, rows, t, comparison);
        } else if (t.either() instanceof CapabilityStatement.CapabilityStatementRestResourceOperationComponent) {
            r = this.addRestOperationRow(gen, rows, t, comparison);
        } else if (t.either() instanceof CodeableConcept) {
            r = this.addRestSecurityServiceRow(gen, rows, t, comparison);
        } else if (t.either() instanceof Extension) {
            r = this.addExtensionRow(gen, rows, t, comparison);
        } else if (t.either() instanceof PrimitiveType) {
            r = this.addPrimitiveTypeRow(gen, rows, t, comparison);
        } else {
            throw new Error("Not Done Yet: " + t.either().getClass().getName());
        }
        for (StructuralMatch<Element> c : t.getChildren()) {
            this.addRow(gen, r.getSubRows(), c, comparison);
        }
    }

    private HierarchicalTableGenerator.Row addRestRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t, CapabilityStatementComparison comparison) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "mode", null, null));
        CapabilityStatement.CapabilityStatementRestComponent left = t.hasLeft() ? (CapabilityStatement.CapabilityStatementRestComponent)t.getLeft() : null;
        CapabilityStatement.CapabilityStatementRestComponent right = t.hasRight() ? (CapabilityStatement.CapabilityStatementRestComponent)t.getRight() : null;
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, left != null ? left.getMode().toCode() : "", null, null), left != null ? left.getMode().toCode() : null, right != null ? right.getMode().toCode() : null, true));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, left != null ? left.getDocumentation() : "", null, null), left != null ? left.getDocumentation() : null, right != null ? right.getDocumentation() : null, true));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, right != null ? right.getMode().toCode() : "", null, null), left != null ? left.getMode().toCode() : null, right != null ? right.getMode().toCode() : null, false));
        List list5 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list5.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, right != null ? right.getDocumentation() : "", null, null), left != null ? left.getDocumentation() : null, right != null ? right.getDocumentation() : null, true));
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
        return r;
    }

    private HierarchicalTableGenerator.Row addRestSecurityRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t, CapabilityStatementComparison comparison) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "security", null, null));
        CapabilityStatement.CapabilityStatementRestSecurityComponent left = t.hasLeft() ? (CapabilityStatement.CapabilityStatementRestSecurityComponent)t.getLeft() : null;
        CapabilityStatement.CapabilityStatementRestSecurityComponent right = t.hasRight() ? (CapabilityStatement.CapabilityStatementRestSecurityComponent)t.getRight() : null;
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, left != null ? left.getCorsElement().primitiveValue() : "", null, null), left != null ? left.getCorsElement().primitiveValue() : null, right != null ? right.getCorsElement().primitiveValue() : null, true));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, left != null ? left.getDescription() : "", null, null), left != null ? left.getDescription() : null, right != null ? right.getDescription() : null, true));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, right != null ? right.getCorsElement().primitiveValue() : "", null, null), left != null ? left.getCorsElement().primitiveValue() : null, right != null ? right.getCorsElement().primitiveValue() : null, false));
        List list5 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list5.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, right != null ? right.getDescription() : "", null, null), left != null ? left.getDescription() : null, right != null ? right.getDescription() : null, true));
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
        return r;
    }

    private HierarchicalTableGenerator.Row addRestResourceRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t, CapabilityStatementComparison comparison) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "resource", null, null));
        CapabilityStatement.CapabilityStatementRestResourceComponent left = t.hasLeft() ? (CapabilityStatement.CapabilityStatementRestResourceComponent)t.getLeft() : null;
        CapabilityStatement.CapabilityStatementRestResourceComponent right = t.hasRight() ? (CapabilityStatement.CapabilityStatementRestResourceComponent)t.getRight() : null;
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, left != null ? left.getType() : "", null, null), left != null ? left.getType() : null, right != null ? right.getType() : null, true));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, left != null ? left.getDocumentation() : "", null, null), left != null ? left.getDocumentation() : null, right != null ? right.getDocumentation() : null, true));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, right != null ? right.getType() : "", null, null), left != null ? left.getType() : null, right != null ? right.getType() : null, false));
        List list5 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list5.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, right != null ? right.getDocumentation() : "", null, null), left != null ? left.getDocumentation() : null, right != null ? right.getDocumentation() : null, true));
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
        return r;
    }

    private HierarchicalTableGenerator.Row addRestSearchParamRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t, CapabilityStatementComparison comparison) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "searchParam", null, null));
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent left = t.hasLeft() ? (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)t.getLeft() : null;
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent right = t.hasRight() ? (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)t.getRight() : null;
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, left != null ? left.getName() : "", null, null), left != null ? left.getName() : null, right != null ? right.getName() : null, true));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, left != null ? left.getDocumentation() : "", null, null), left != null ? left.getDocumentation() : null, right != null ? right.getDocumentation() : null, true));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, right != null ? right.getName() : "", null, null), left != null ? left.getName() : null, right != null ? right.getName() : null, false));
        List list5 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list5.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, right != null ? right.getDocumentation() : "", null, null), left != null ? left.getDocumentation() : null, right != null ? right.getDocumentation() : null, true));
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
        return r;
    }

    private HierarchicalTableGenerator.Row addRestOperationRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t, CapabilityStatementComparison comparison) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "operation", null, null));
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent left = t.hasLeft() ? (CapabilityStatement.CapabilityStatementRestResourceOperationComponent)t.getLeft() : null;
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent right = t.hasRight() ? (CapabilityStatement.CapabilityStatementRestResourceOperationComponent)t.getRight() : null;
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, left != null ? left.getName() : "", null, null), left != null ? left.getName() : null, right != null ? right.getName() : null, true));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, left != null ? left.getDocumentation() : "", null, null), left != null ? left.getDocumentation() : null, right != null ? right.getDocumentation() : null, true));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, right != null ? right.getName() : "", null, null), left != null ? left.getName() : null, right != null ? right.getName() : null, false));
        List list5 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list5.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, right != null ? right.getDocumentation() : "", null, null), left != null ? left.getDocumentation() : null, right != null ? right.getDocumentation() : null, true));
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
        return r;
    }

    private HierarchicalTableGenerator.Row addRestSecurityServiceRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t, CapabilityStatementComparison comparison) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "service", null, null));
        CodeableConcept left = t.hasLeft() ? (CodeableConcept)t.getLeft() : null;
        CodeableConcept right = t.hasRight() ? (CodeableConcept)t.getRight() : null;
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, left != null ? this.gen(left) : "", null, null), left != null ? this.gen(left) : null, right != null ? this.gen(right) : null, true));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, left != null ? left.getText() : "", null, null), left != null ? left.getText() : null, right != null ? right.getText() : null, true));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, right != null ? this.gen(right) : "", null, null), left != null ? this.gen(left) : null, right != null ? this.gen(right) : null, false));
        List list5 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list5.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, right != null ? right.getText() : "", null, null), left != null ? left.getText() : null, right != null ? right.getText() : null, true));
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
        return r;
    }

    private HierarchicalTableGenerator.Row addRestResourceInteractionRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t, CapabilityStatementComparison comparison) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "interaction", null, null));
        CapabilityStatement.ResourceInteractionComponent left = t.hasLeft() ? (CapabilityStatement.ResourceInteractionComponent)t.getLeft() : null;
        CapabilityStatement.ResourceInteractionComponent right = t.hasRight() ? (CapabilityStatement.ResourceInteractionComponent)t.getRight() : null;
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, left != null ? left.getCode().getDisplay() : "", null, null), left != null ? left.getCode().getDisplay() : null, right != null ? right.getCode().getDisplay() : null, true));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, left != null ? left.getDocumentation() : "", null, null), left != null ? left.getDocumentation() : null, right != null ? right.getDocumentation() : null, true));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, right != null ? right.getCode().getDisplay() : "", null, null), left != null ? left.getCode().getDisplay() : null, right != null ? right.getCode().getDisplay() : null, false));
        List list5 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list5.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, right != null ? right.getDocumentation() : "", null, null), left != null ? left.getDocumentation() : null, right != null ? right.getDocumentation() : null, true));
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
        return r;
    }

    private HierarchicalTableGenerator.Row addExtensionRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t, CapabilityStatementComparison comparison) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "expectation", null, null));
        Extension left = t.hasLeft() ? (Extension)t.getLeft() : null;
        Extension right = t.hasRight() ? (Extension)t.getRight() : null;
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, left != null ? left.getValue().primitiveValue() : "", null, null), left != null ? left.getValue().primitiveValue() : null, right != null ? right.getValue().primitiveValue() : null, true));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "", null, null));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, right != null ? right.getValue().primitiveValue() : "", null, null), left != null ? left.getValue().primitiveValue() : null, right != null ? right.getValue().primitiveValue() : null, false));
        List list5 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, "", null, null));
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
        return r;
    }

    private HierarchicalTableGenerator.Row addPrimitiveTypeRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<Element> t, CapabilityStatementComparison comparison) {
        String refR;
        String refL;
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, t.getName(), null, null));
        PrimitiveType left = t.hasLeft() ? (PrimitiveType)t.getLeft() : null;
        PrimitiveType right = t.hasRight() ? (PrimitiveType)t.getRight() : null;
        CanonicalResource crL = left == null ? null : (CanonicalResource)this.session.getContextLeft().fetchResource(Resource.class, left.primitiveValue());
        CanonicalResource crR = right == null ? null : (CanonicalResource)this.session.getContextRight().fetchResource(Resource.class, right.primitiveValue());
        String string = refL = crL != null && crL.hasWebPath() ? crL.getWebPath() : null;
        String dispL = crL != null && refL != null ? crL.present() : (left == null ? "" : left.primitiveValue());
        String string2 = refR = crR != null && crR.hasWebPath() ? crR.getWebPath() : null;
        String dispR = crR != null && refR != null ? crR.present() : (right == null ? "" : right.primitiveValue());
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, refL, dispL, null, null), left != null ? left.primitiveValue() : null, right != null ? right.primitiveValue() : null, true));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "", null, null));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(this.style(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, refR, dispR, null, null), left != null ? left.primitiveValue() : null, right != null ? right.primitiveValue() : null, false));
        List list5 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, "", null, null));
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
        return r;
    }

    private HierarchicalTableGenerator.Cell style(HierarchicalTableGenerator.Cell cell, String left, String right, boolean isLeft) {
        if (left != null && right != null) {
            if (!left.equals(right)) {
                cell.setStyle("background-color: #f0b3ff");
            }
        } else if (left != null) {
            if (!isLeft) {
                cell.setStyle("background-color: #ffcc33");
            }
        } else if (right != null && isLeft) {
            cell.setStyle("background-color: #ffff4d");
        }
        return cell;
    }

    @Override
    protected String fhirType() {
        return "CapabilityStatement";
    }

    public class CapabilityStatementComparison
    extends CanonicalResourceComparer.CanonicalResourceComparison<CapabilityStatement> {
        private StructuralMatch<Element> combined;

        public CapabilityStatementComparison(CapabilityStatement left, CapabilityStatement right) {
            super((CanonicalResourceComparer)CapabilityStatementComparer.this, (CanonicalResource)left, (CanonicalResource)right);
            this.combined = new StructuralMatch();
        }

        public StructuralMatch<Element> getCombined() {
            return this.combined;
        }

        @Override
        protected String abbreviation() {
            return "cps";
        }

        @Override
        protected String summary() {
            return "CapabilityStatement: " + ((CapabilityStatement)this.left).present() + " vs " + ((CapabilityStatement)this.right).present();
        }

        @Override
        protected String fhirType() {
            return "CapabilityStatement";
        }

        @Override
        protected void countMessages(ResourceComparer.MessageCounts cnts) {
            super.countMessages(cnts);
            this.combined.countMessages(cnts);
        }
    }
}

