/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance.profile;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.DefinitionNavigator;
import org.hl7.fhir.r5.utils.TypesUtilities;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotGenerationPreProcessor {
    private static final Logger log = LoggerFactory.getLogger(SnapshotGenerationPreProcessor.class);
    private IWorkerContext context;
    private ProfileUtilities utils;
    Set<String> typeNames;
    private List<SliceInfo> slicings = new ArrayList<SliceInfo>();

    public SnapshotGenerationPreProcessor(ProfileUtilities utils) {
        this.utils = utils;
        this.context = utils.getContext();
    }

    public void process(StructureDefinition.StructureDefinitionDifferentialComponent diff, StructureDefinition srcOriginal) {
        StructureDefinition srcWrapper = this.shallowClone(srcOriginal, diff);
        this.processSlices(diff, srcWrapper);
        if (srcWrapper.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-additionalBase")) {
            this.insertMissingSparseElements(diff.getElement(), srcWrapper.getTypeName());
            for (Extension ext : srcWrapper.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-additionalBase")) {
                StructureDefinition ab = this.context.fetchResource(StructureDefinition.class, ext.getValue().primitiveValue());
                if (ab == null) {
                    throw new FHIRException("Unable to find additional base '" + ext.getValue().primitiveValue() + "'");
                }
                if (!srcWrapper.getType().equals(ab.getType())) {
                    throw new FHIRException("Type mismatch");
                }
                SnapshotGenerationPreProcessor abpp = new SnapshotGenerationPreProcessor(this.utils);
                abpp.process(ab.getDifferential(), ab);
                abpp.insertMissingSparseElements(ab.getDifferential().getElement(), srcWrapper.getTypeName());
                this.mergeElementsFromAdditionalBase(srcWrapper, ab);
            }
        }
    }

    private StructureDefinition shallowClone(StructureDefinition src, StructureDefinition.StructureDefinitionDifferentialComponent diff) {
        StructureDefinition sd = new StructureDefinition();
        sd.setUrl(src.getUrl());
        sd.setVersion(src.getVersion());
        sd.setType(src.getType());
        sd.setDerivation(src.getDerivation());
        sd.setBaseDefinition(src.getBaseDefinition());
        sd.setExtension(src.getExtension());
        sd.setDifferential(diff);
        return sd;
    }

    private void mergeElementsFromAdditionalBase(StructureDefinition sourceSD, StructureDefinition baseSD) {
        ArrayList<ElementDefinition> output = new ArrayList<ElementDefinition>();
        output.add(this.mergeElementDefinitions(baseSD.getDifferential().getElementFirstRep(), sourceSD.getDifferential().getElementFirstRep(), baseSD));
        DefinitionNavigator base = new DefinitionNavigator(this.context, baseSD, true, false);
        DefinitionNavigator source = new DefinitionNavigator(this.context, sourceSD, true, false);
        StructureDefinition sdt = this.context.fetchTypeDefinition(sourceSD.getType());
        ProfileUtilities.SourcedChildDefinitions children = this.utils.getChildMap(sdt, sdt.getSnapshot().getElementFirstRep(), false);
        this.mergeElements(output, base, source, children, baseSD);
        sourceSD.getDifferential().setElement(output);
    }

    private void mergeElements(List<ElementDefinition> output, DefinitionNavigator base, DefinitionNavigator source, ProfileUtilities.SourcedChildDefinitions children, StructureDefinition baseSD) {
        for (ElementDefinition child : children.getList()) {
            DefinitionNavigator sourceChild;
            DefinitionNavigator baseChild = base == null ? null : base.childByName(child.getName());
            DefinitionNavigator definitionNavigator = sourceChild = source == null ? null : source.childByName(child.getName());
            if (baseChild != null && sourceChild != null) {
                if (!baseChild.hasSlices() && !sourceChild.hasSlices()) {
                    output.add(this.mergeElementDefinitions(baseChild.current(), sourceChild.current(), baseSD));
                    if (!sourceChild.hasChildren() && !baseChild.hasChildren()) continue;
                    this.mergeElements(output, baseChild, sourceChild, this.getChildren(children, child, sourceChild, baseChild, baseSD), baseSD);
                    continue;
                }
                if (baseChild.hasSlices() && sourceChild.hasSlices()) {
                    if (!this.slicingIsConsistent(baseChild.getSlicing(), sourceChild.getSlicing())) {
                        throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_INCOMPATIBLE_VALUES", baseSD.getVersionedUrl(), child.getPath() + ".slicing", this.describeDiscriminators(baseChild.getSlicing()), this.describeDiscriminators(sourceChild.getSlicing())));
                    }
                    output.add(this.mergeElementDefinitions(baseChild.current(), sourceChild.current(), baseSD));
                    this.mergeElements(output, baseChild, sourceChild, this.getChildren(children, child, sourceChild, baseChild, baseSD), baseSD);
                    ArrayList<DefinitionNavigator> handled = new ArrayList<DefinitionNavigator>();
                    for (DefinitionNavigator slice : sourceChild.slices()) {
                        DefinitionNavigator match = this.getMatchingSlice(baseChild, slice, sourceChild.getSlicing());
                        if (match != null) {
                            handled.add(match);
                            output.add(this.mergeElementDefinitions(match.current(), slice.current(), baseSD));
                            this.mergeElements(output, match, slice, this.getChildren(children, child, match, slice, baseSD), baseSD);
                            continue;
                        }
                        output.add(slice.current().copy());
                        this.mergeElements(output, null, slice, this.getChildren(children, child, slice, null, baseSD), baseSD);
                    }
                    for (DefinitionNavigator slice : baseChild.slices()) {
                        if (handled.contains(slice)) continue;
                        output.add(slice.current().copy());
                        this.mergeElements(output, slice, null, this.getChildren(children, child, null, slice, baseSD), baseSD);
                    }
                    continue;
                }
                if (baseChild.hasSlices()) {
                    throw new FHIRException("Not done yet");
                }
                throw new FHIRException("Not done yet");
            }
            if (baseChild != null) {
                output.add(baseChild.current().copy());
                if (baseChild.hasChildren()) {
                    this.mergeElements(output, baseChild, sourceChild, this.getChildren(children, child, null, baseChild, baseSD), baseSD);
                }
                if (!baseChild.hasSlices()) continue;
                for (DefinitionNavigator slice : baseChild.slices()) {
                    this.mergeElements(output, slice, null, this.getChildren(children, child, null, slice, baseSD), baseSD);
                }
                continue;
            }
            if (sourceChild == null) continue;
            output.add(sourceChild.current().copy());
            if (sourceChild.hasSlices()) {
                for (DefinitionNavigator slice : sourceChild.slices()) {
                    this.mergeElements(output, null, slice, this.getChildren(children, child, slice, null, baseSD), baseSD);
                }
            }
            if (!sourceChild.hasChildren()) continue;
            this.mergeElements(output, baseChild, sourceChild, this.getChildren(children, child, sourceChild, null, baseSD), baseSD);
        }
    }

    private DefinitionNavigator getMatchingSlice(DefinitionNavigator base, DefinitionNavigator slice, ElementDefinition.ElementDefinitionSlicingComponent slicing) {
        ArrayList<DataType> values = new ArrayList<DataType>();
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : slicing.getDiscriminator()) {
            values.add(this.getDiscriminatorValue(slice, d));
        }
        DefinitionNavigator match = null;
        for (DefinitionNavigator t : base.slices()) {
            ArrayList<DataType> values2 = new ArrayList<DataType>();
            for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : slicing.getDiscriminator()) {
                values2.add(this.getDiscriminatorValue(t, d));
            }
            if (!this.valuesMatch(values, values2)) continue;
            if (match == null) {
                match = t;
                continue;
            }
            throw new Error("Duplicate slice");
        }
        return match;
    }

    private DataType getDiscriminatorValue(DefinitionNavigator slice, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d) {
        DefinitionNavigator dn = new DefinitionNavigator(slice, true);
        switch (d.getType()) {
            case EXISTS: {
                throw new Error("Not supported yet");
            }
            case NULL: {
                throw new Error("Not supported yet");
            }
            case PATTERN: {
                throw new Error("Not supported yet");
            }
            case POSITION: {
                throw new Error("Not supported yet");
            }
            case PROFILE: {
                throw new Error("Not supported yet");
            }
            case TYPE: {
                if ("$this".equals(d.getPath())) {
                    return new CodeType(dn.getManualType() != null ? dn.getManualType().getCode() : dn.current().typeSummary());
                }
                throw new Error("Not supported yet");
            }
            case VALUE: {
                DefinitionNavigator child = dn.childByName(d.getPath());
                if (child != null) {
                    ElementDefinition ed = child.current();
                    if (ed.hasFixed()) {
                        return ed.getFixed();
                    }
                    if (!ed.hasPattern()) break;
                    return ed.getPattern();
                }
                return null;
            }
        }
        throw new Error("Not supported yet");
    }

    private boolean valuesMatch(List<DataType> values1, List<DataType> values2) {
        for (int i = 0; i < values1.size(); ++i) {
            DataType v2;
            DataType v1 = values1.get(i);
            if (this.valuesMatch(v1, v2 = values2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean valuesMatch(DataType v1, DataType v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 != null && v2 != null) {
            return v1.equalsDeep(v2);
        }
        return false;
    }

    private boolean slicingIsConsistent(ElementDefinition.ElementDefinitionSlicingComponent src, ElementDefinition.ElementDefinitionSlicingComponent base) {
        if (src.getRules() != base.getRules()) {
            return false;
        }
        if (src.getDiscriminator().size() != base.getDiscriminator().size()) {
            return false;
        }
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d1 : src.getDiscriminator()) {
            boolean found = false;
            for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d2 : base.getDiscriminator()) {
                found = found || d1.getType() == d2.getType() && d1.getPath().equals(d2.getPath());
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private Object describeDiscriminators(ElementDefinition.ElementDefinitionSlicingComponent slicing) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : slicing.getDiscriminator()) {
            b.append(t.getType().toCode() + ":" + t.getPath());
        }
        return (String)(slicing.hasRules() ? slicing.getRules().toCode() + ":" : "") + b.toString() + (slicing.hasOrdered() ? " (ordered)" : "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ProfileUtilities.SourcedChildDefinitions getChildren(ProfileUtilities.SourcedChildDefinitions children, ElementDefinition child, DefinitionNavigator source, DefinitionNavigator base, StructureDefinition baseSD) {
        if (child.getType().size() <= 1) return this.utils.getChildMap(children.getSource(), child, true);
        String type = null;
        if (source != null && base != null) {
            String typeSource = this.statedOrImpliedType(source);
            String typeBase = this.statedOrImpliedType(base);
            if (typeSource != null && typeBase != null) {
                if (!typeSource.equals(typeBase)) throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_INCOMPATIBLE_VALUES", baseSD.getVersionedUrl(), child.getPath() + ".type", typeSource, typeBase));
                type = typeSource;
            } else if (typeSource != null) {
                type = typeSource;
            } else if (typeBase != null) {
                type = typeBase;
            }
        } else if (source != null) {
            type = this.statedOrImpliedType(source);
        } else if (base != null) {
            type = this.statedOrImpliedType(base);
        }
        if (type != null) return this.utils.getChildMap(children.getSource(), child, true, type);
        throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_INDETERMINATE_TYPE", baseSD.getVersionedUrl(), child.getPath() + ".type"));
    }

    private String statedOrImpliedType(DefinitionNavigator source) {
        if (source.getManualType() != null) {
            return source.getManualType().getCode();
        }
        if (source.current().getType().size() == 1) {
            return source.current().getTypeFirstRep().getCode();
        }
        return null;
    }

    private ElementDefinition mergeElementDefinitions(ElementDefinition base, ElementDefinition source, StructureDefinition baseSD) {
        ElementDefinition merged = new ElementDefinition();
        merged.setPath(source.getPath());
        if (source.hasSlicing()) {
            merged.setSlicing(source.getSlicing());
        }
        merged.setLabelElement(this.chooseProp(source.getLabelElement(), base.getLabelElement()));
        merged.setShortElement(this.chooseProp(source.getShortElement(), base.getShortElement()));
        merged.setDefinitionElement(this.chooseProp(source.getDefinitionElement(), base.getDefinitionElement()));
        merged.setCommentElement(this.chooseProp(source.getCommentElement(), base.getCommentElement()));
        merged.setRequirementsElement(this.chooseProp(source.getRequirementsElement(), base.getRequirementsElement()));
        merged.setMeaningWhenMissingElement(this.chooseProp(source.getMeaningWhenMissingElement(), base.getMeaningWhenMissingElement()));
        merged.setOrderMeaningElement(this.chooseProp(source.getOrderMeaningElement(), base.getOrderMeaningElement()));
        merged.setMaxLengthElement(this.chooseProp(source.getMaxLengthElement(), base.getMaxLengthElement()));
        merged.setMustHaveValueElement(this.chooseProp(source.getMustHaveValueElement(), base.getMustHaveValueElement()));
        merged.setMustSupportElement(this.chooseProp(source.getMustSupportElement(), base.getMustSupportElement()));
        merged.setIsModifierElement(this.chooseProp(source.getIsModifierElement(), base.getIsModifierElement()));
        merged.setIsModifierReasonElement(this.chooseProp(source.getIsModifierReasonElement(), base.getIsModifierReasonElement()));
        merged.setIsSummaryElement(this.chooseProp(source.getIsSummaryElement(), base.getIsSummaryElement()));
        if (source.hasMin() && base.hasMin()) {
            merged.setMinElement(source.getMin() < base.getMin() ? source.getMinElement().copy() : base.getMinElement().copy());
        } else {
            merged.setMinElement(this.chooseProp(source.getMinElement(), base.getMinElement().copy()));
        }
        if (source.hasMax() && base.hasMax()) {
            merged.setMaxElement(source.getMaxAsInt() < base.getMaxAsInt() ? source.getMaxElement().copy() : base.getMaxElement().copy());
        } else {
            merged.setMaxElement(this.chooseProp(source.getMaxElement(), base.getMaxElement()));
        }
        if (source.hasFixed() || base.hasFixed()) {
            if (source.hasFixed()) {
                if (base.hasFixed()) {
                    if (!source.getFixed().equalsDeep(base.getFixed())) {
                        throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_INCOMPATIBLE_VALUES", baseSD.getVersionedUrl(), source.getPath() + ".fixed", source.getFixed().toString(), base.getFixed().toString()));
                    }
                    merged.setFixed(source.getFixed().copy());
                } else if (base.hasPattern()) {
                    merged.setFixed(this.checkPatternValues(baseSD.getVersionedUrl(), source.getPath() + ".fixed", source.getFixed(), base.getPattern(), false));
                } else {
                    merged.setFixed(source.getFixed().copy());
                }
            } else if (source.hasPattern()) {
                merged.setFixed(this.checkPatternValues(baseSD.getVersionedUrl(), source.getPath() + ".pattern", base.getFixed(), source.getPattern(), false));
            } else {
                merged.setFixed(base.getFixed().copy());
            }
        } else if (source.hasPattern() && base.hasPattern()) {
            merged.setPattern(this.checkPatternValues(baseSD.getVersionedUrl(), source.getPath() + ".pattern", source.getFixed(), base.getFixed(), true));
        } else {
            merged.setPattern(this.chooseProp(source.getPattern(), base.getPattern()));
        }
        if (source.hasMinValue() && base.hasMinValue()) {
            merged.setMinValue(this.isLower(baseSD.getVersionedUrl(), source.getPath(), "minValue", source.getMinValue(), base.getMinValue()) ? base.getMinValue().copy() : source.getMinValue().copy());
        } else {
            merged.setMinValue(this.chooseProp(source.getMinValue(), base.getMinValue()));
        }
        if (source.hasMaxValue() && base.hasMaxValue()) {
            merged.setMaxValue(this.isLower(baseSD.getVersionedUrl(), source.getPath(), "maxValue", source.getMaxValue(), base.getMaxValue()) ? source.getMaxValue().copy() : base.getMaxValue().copy());
        } else {
            merged.setMaxValue(this.chooseProp(source.getMaxValue(), base.getMaxValue()));
        }
        if (source.hasMaxLength() && base.hasMaxLength()) {
            merged.setMaxLengthElement(base.getMaxLength() < source.getMaxLength() ? source.getMaxLengthElement().copy() : base.getMaxLengthElement().copy());
        } else {
            merged.setMaxLengthElement(this.chooseProp(source.getMaxLengthElement(), base.getMaxLengthElement().copy()));
        }
        this.union(merged.getAlias(), source.getAlias(), base.getAlias());
        this.union(merged.getCode(), source.getCode(), base.getCode());
        this.union(merged.getExample(), source.getExample(), base.getExample());
        this.union(merged.getConstraint(), source.getConstraint(), base.getConstraint());
        this.union(merged.getMapping(), source.getMapping(), base.getMapping());
        if (source.hasValueAlternatives() && base.hasValueAlternatives()) {
            for (CanonicalType canonicalType : source.getValueAlternatives()) {
                boolean exists = false;
                for (CanonicalType st2 : base.getValueAlternatives()) {
                    exists = exists || canonicalType.equals(st2);
                }
                if (!exists) continue;
                merged.getValueAlternatives().add(canonicalType.copy());
            }
        } else if (source.hasValueAlternatives()) {
            for (CanonicalType canonicalType : source.getValueAlternatives()) {
                merged.getValueAlternatives().add(canonicalType.copy());
            }
        } else if (base.hasValueAlternatives()) {
            for (CanonicalType canonicalType : base.getValueAlternatives()) {
                merged.getValueAlternatives().add(canonicalType.copy());
            }
        }
        if (source.hasType() && base.hasType()) {
            for (ElementDefinition.TypeRefComponent typeRefComponent : source.getType()) {
                for (ElementDefinition.TypeRefComponent t2 : base.getType()) {
                    if (!Utilities.stringsEqual((String)typeRefComponent.getWorkingCode(), (String)t2.getWorkingCode())) continue;
                    merged.getType().add(this.mergeTypes(baseSD.getVersionedUrl(), source.getPath(), typeRefComponent, t2));
                }
            }
            if (merged.getType().isEmpty()) {
                throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_INCOMPATIBLE_VALUES", baseSD.getVersionedUrl(), source.getPath() + ".type", source.typeSummary(), base.typeSummary()));
            }
        } else if (source.hasType()) {
            for (ElementDefinition.TypeRefComponent typeRefComponent : source.getType()) {
                merged.getType().add(typeRefComponent.copy());
            }
        } else if (base.hasType()) {
            for (ElementDefinition.TypeRefComponent typeRefComponent : base.getType()) {
                merged.getType().add(typeRefComponent.copy());
            }
        }
        if (source.hasBinding() && base.hasBinding()) {
            throw new Error("not done yet");
        }
        if (source.hasBinding()) {
            merged.setBinding(source.getBinding().copy());
        } else if (base.hasBinding()) {
            merged.setBinding(base.getBinding().copy());
        }
        return merged;
    }

    private <T extends DataType> T chooseProp(T source, T base) {
        if (source != null && !source.isEmpty()) {
            return (T)source.copy();
        }
        if (base != null && !base.isEmpty()) {
            return (T)base.copy();
        }
        return null;
    }

    private ElementDefinition.TypeRefComponent mergeTypes(String vurl, String path, ElementDefinition.TypeRefComponent t1, ElementDefinition.TypeRefComponent t2) {
        ElementDefinition.TypeRefComponent tr = t1.copy();
        if (t1.hasProfile() && t2.hasProfile()) {
            if (t1.getProfile().size() > 1 || t2.getProfile().size() > 1) {
                throw new FHIRException("Not handled yet: multiple profiles");
            }
            StructureDefinition sd1 = this.context.fetchResource(StructureDefinition.class, t1.getProfile().get(0).asStringValue());
            if (sd1 == null) {
                throw new FHIRException("Unknown type profile at '" + path + "': " + t1.getProfile().get(0).asStringValue());
            }
            StructureDefinition sd2 = this.context.fetchResource(StructureDefinition.class, t2.getProfile().get(0).asStringValue());
            if (sd2 == null) {
                throw new FHIRException("Unknown type profile at '" + path + "': " + t2.getProfile().get(0).asStringValue());
            }
            tr.getProfile().clear();
            if (this.specialises(sd1, sd2)) {
                tr.getProfile().add(t1.getProfile().get(0).copy());
            } else if (this.specialises(sd2, sd1)) {
                tr.getProfile().add(t2.getProfile().get(0).copy());
            } else {
                StructureDefinition sd3 = this.findJointProfile(sd1, sd2);
                if (sd3 == null) {
                    throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_NO_TYPE", vurl, path, sd1.getVersionedUrl(), sd2.getVersionedUrl()));
                }
                tr.getProfile().add(new CanonicalType(sd3.getUrl()));
            }
        } else if (t2.hasProfile()) {
            for (CanonicalType ct : t2.getProfile()) {
                tr.getProfile().add(ct.copy());
            }
        }
        if (!(t1.hasTargetProfile() && t2.hasTargetProfile() || !t2.hasTargetProfile())) {
            for (CanonicalType ct : t2.getTargetProfile()) {
                tr.getTargetProfile().add(ct.copy());
            }
        }
        if (t1.hasAggregation() && t2.hasAggregation() && !t1.getAggregation().equals(t2.getAggregation())) {
            throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_INCOMPATIBLE_VALUES", vurl, path + ".type[" + tr.getWorkingCode() + "].aggregation", t1.getAggregation(), t2.getAggregation()));
        }
        if (t1.hasVersioning() && t2.hasVersioning() && t1.getVersioning() != t2.getVersioning()) {
            throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_INCOMPATIBLE_VALUES", new Object[]{vurl, path + ".type[" + tr.getWorkingCode() + "].aggregation", t1.getVersioning(), t2.getVersioning()}));
        }
        return tr;
    }

    private StructureDefinition findJointProfile(StructureDefinition sd1, StructureDefinition sd2) {
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            boolean b2;
            boolean b1 = sd.getBaseDefinitions().contains(sd1.getUrl()) || sd.getBaseDefinitions().contains(sd1.getVersionedUrl());
            boolean bl = b2 = sd.getBaseDefinitions().contains(sd2.getUrl()) || sd.getBaseDefinitions().contains(sd2.getVersionedUrl());
            if (!b1 || !b2) continue;
            return sd;
        }
        return null;
    }

    private boolean specialises(StructureDefinition focus, StructureDefinition other) {
        for (String url : focus.getBaseDefinitions()) {
            StructureDefinition base = this.context.fetchResource(StructureDefinition.class, url);
            if (base == null || base != other && !this.specialises(base, other)) continue;
            return true;
        }
        return false;
    }

    private <T extends Base> void union(List<T> merged, List<T> source, List<T> base) {
        for (Base st : source) {
            merged.add(st.copy());
        }
        for (Base st : base) {
            boolean exists = false;
            for (Base st2 : merged) {
                exists = exists || st.equals(st2);
            }
            if (exists) continue;
            merged.add(st.copy());
        }
    }

    private boolean isLower(String vurl, String path, String property, DataType v1, DataType v2) {
        if (v1 instanceof Quantity && v2 instanceof Quantity) {
            Quantity q1 = (Quantity)v1;
            Quantity q2 = (Quantity)v2;
            if ((q1.hasUnit() || q2.hasUnit()) && Utilities.stringsEqual((String)q1.getUnit(), (String)q2.getUnit())) {
                throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_INCOMPATIBLE_VALUES", vurl, path + "." + property + ".unit", v1.fhirType(), v2.fhirType()));
            }
            return this.isLower(vurl, path, property + ".value", q1.getValueElement(), q2.getValueElement());
        }
        if (v1.isDateTime() && v2.isDateTime()) {
            DateTimeType d1 = (DateTimeType)v1;
            DateTimeType d2 = (DateTimeType)v2;
            return d1.before(d2);
        }
        if (Utilities.isDecimal((String)v1.primitiveValue(), (boolean)true) && Utilities.isDecimal((String)v2.primitiveValue(), (boolean)true)) {
            BigDecimal d2;
            BigDecimal d1 = new BigDecimal(v1.primitiveValue());
            return d1.compareTo(d2 = new BigDecimal(v2.primitiveValue())) < 0;
        }
        throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_INCOMPATIBLE_VALUES", vurl, path + "." + property, v1.fhirType(), v2.fhirType()));
    }

    private DataType checkPatternValues(String vurl, String path, DataType v1, DataType v2, boolean extras) {
        if (!v1.fhirType().equals(v2.fhirType())) {
            throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_INCOMPATIBLE_VALUES", vurl, path, v1.fhirType(), v2.fhirType()));
        }
        DataType merged = v1.copy();
        if (v1.isPrimitive() && !Utilities.stringsEqual((String)v1.primitiveValue(), (String)v2.primitiveValue())) {
            throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_INCOMPATIBLE_VALUES", vurl, path + ".value", v1.primitiveValue(), v2.primitiveValue()));
        }
        for (Property p1 : v1.children()) {
            Property p2 = v2.getChildByName(p1.getName());
            if (p1.hasValues() && p2.hasValues()) {
                if (p1.getValues().size() > 1 || p1.getValues().size() > 2) {
                    throw new Error("Not supported");
                }
                merged.setProperty(p1.getName(), this.checkPatternValues(vurl, path + "." + p1.getName(), (DataType)p1.getValues().get(0), (DataType)p2.getValues().get(0), extras));
                continue;
            }
            if (!p2.hasValues()) continue;
            if (!extras) {
                throw new FHIRException(this.context.formatMessage("SD_ADDITIONAL_BASE_INCOMPATIBLE_VALUES", vurl, path + "." + p1.getName(), "null", v2.primitiveValue()));
            }
            if (p2.getValues().size() > 1) {
                throw new Error("Not supported");
            }
            merged.setProperty(p1.getName(), p2.getValues().get(0).copy());
        }
        return merged;
    }

    private void processSlices(StructureDefinition.StructureDefinitionDifferentialComponent diff, StructureDefinition src) {
        for (int cursor = 0; cursor < diff.getElement().size(); ++cursor) {
            ElementDefinition ed = diff.getElement().get(cursor);
            SliceInfo si = this.getSlicing(ed);
            if (si == null) {
                if (!ed.hasSlicing() || this.isExtensionSlicing(ed)) continue;
                si = new SliceInfo(null, ed);
                this.slicings.add(si);
                continue;
            }
            if (ed.hasSliceName() && ed.getPath().equals(si.path)) {
                si.newSlice(ed);
                continue;
            }
            if (ed.hasSlicing() && !this.isExtensionSlicing(ed)) {
                si = new SliceInfo(si, ed);
                this.slicings.add(si);
                continue;
            }
            si.add(ed);
        }
        for (SliceInfo si : this.slicings) {
            if (si.sliceStuff.isEmpty() || si.slices == null) continue;
            for (ElementDefinition ed : si.sliceStuff) {
                if (!ed.hasSlicing() || this.isExtensionSlicing(ed)) continue;
                String message = this.context.formatMessage("UNSUPPORTED_SLICING_COMPLEXITY", si.slicer.getPath(), ed.getPath(), ed.getSlicing().summary());
                log.warn(message);
                return;
            }
        }
        for (int i = this.slicings.size() - 1; i >= 0; --i) {
            SliceInfo si;
            si = this.slicings.get(i);
            if (si.sliceStuff.isEmpty() || si.slices == null) continue;
            for (ElementDefinition slice : si.slices) {
                this.mergeElements(diff.getElement(), si.sliceStuff, slice, si.slicer);
            }
        }
        for (ElementDefinition ed : diff.getElement()) {
            ProfileUtilities.markExtensions(ed, false, src);
        }
    }

    private void mergeElements(List<ElementDefinition> elements, List<ElementDefinition> allSlices, ElementDefinition slice, ElementDefinition slicer) {
        int sliceIndex = elements.indexOf(slice);
        int startOfSlice = sliceIndex + 1;
        int endOfSlice = this.findEndOfSlice(elements, slice);
        HashSet<String> missing = new HashSet<String>();
        boolean allFound = true;
        for (int i = 0; i < allSlices.size(); ++i) {
            boolean found = false;
            for (int j = startOfSlice; j <= endOfSlice; ++j) {
                if (!this.elementsMatch(elements.get(j), allSlices.get(i))) continue;
                found = true;
                break;
            }
            if (found) continue;
            missing.add(allSlices.get(i).getPath());
            allFound = false;
        }
        if (allFound) {
            for (int j = startOfSlice; j <= endOfSlice; ++j) {
                for (int i = 0; i < allSlices.size(); ++i) {
                    if (!this.elementsMatch(elements.get(j), allSlices.get(i))) continue;
                    this.merge(elements.get(j), allSlices.get(i));
                }
            }
        } else {
            HashSet<ElementDefinition> handled = new HashSet<ElementDefinition>();
            for (int j = startOfSlice; j <= endOfSlice; ++j) {
                for (int i = 0; i < allSlices.size(); ++i) {
                    if (!this.elementsMatch(elements.get(j), allSlices.get(i))) continue;
                    handled.add(allSlices.get(i));
                    this.merge(elements.get(j), allSlices.get(i));
                }
            }
            for (ElementDefinition ed : allSlices) {
                if (handled.contains(ed)) continue;
                List<ElementAnalysis> edDef = this.analysePath(ed);
                String id = ed.getId().replace(slicer.getId(), slice.getId());
                int index = this.determineInsertionPoint(elements, startOfSlice, endOfSlice, id, ed.getPath(), edDef);
                ElementDefinition edc = ed.copy();
                edc.setUserData("SNAPSHOT_PREPROCESS_INJECTED", true);
                edc.setId(id);
                elements.add(index, edc);
                ++endOfSlice;
            }
        }
    }

    private boolean elementsMatch(ElementDefinition ed1, ElementDefinition ed2) {
        if (!this.pathsMatch(ed1.getPath(), ed2.getPath())) {
            return false;
        }
        if (ed1.getSliceName() != null && ed2.getSliceName() != null) {
            return ed1.getSliceName().equals(ed2.getSliceName());
        }
        return ed1.getSliceName() == null && ed2.getSliceName() == null;
    }

    private boolean pathsMatch(String path1, String path2) {
        if (path1.equals(path2)) {
            return true;
        }
        if (path1.endsWith("[x]") && path2.startsWith(path1 = path1.substring(0, path1.length() - 3)) && !path2.substring(path1.length()).contains(".")) {
            return true;
        }
        return path2.endsWith("[x]") && path1.startsWith(path2 = path2.substring(0, path2.length() - 3)) && !path1.substring(path2.length()).contains(".");
    }

    private int determineInsertionPoint(List<ElementDefinition> elements, int startOfSlice, int endOfSlice, String id, String path, List<ElementAnalysis> edDef) {
        String[] p = id.split("\\.");
        for (int i = p.length - 1; i >= 1; --i) {
            Object subId = p[0];
            for (int j = 1; j <= i; ++j) {
                subId = (String)subId + "." + p[j];
            }
            List<ElementDefinition> peers = this.findPeers(elements, startOfSlice, endOfSlice, (String)subId);
            if (peers.isEmpty()) continue;
            for (ElementDefinition ed : peers) {
                if (!this.comesAfterThis(id, path, edDef, ed)) continue;
                return elements.indexOf(ed);
            }
            return elements.indexOf(peers.get(peers.size() - 1)) + 1;
        }
        return endOfSlice + 1;
    }

    private List<ElementDefinition> findPeers(List<ElementDefinition> elements, int startOfSlice, int endOfSlice, String subId) {
        ArrayList<ElementDefinition> peers = new ArrayList<ElementDefinition>();
        for (int i = startOfSlice; i <= endOfSlice; ++i) {
            ElementDefinition ed = elements.get(i);
            if (!ed.getId().startsWith(subId)) continue;
            peers.add(ed);
        }
        return peers;
    }

    private String summary(List<ElementAnalysis> edDef) {
        ArrayList<String> s = new ArrayList<String>();
        for (ElementAnalysis ed : edDef) {
            s.add(ed.summary());
        }
        return CommaSeparatedStringBuilder.join((String)",", s);
    }

    private boolean comesAfterThis(String id, String path, List<ElementAnalysis> edDef, ElementDefinition ed) {
        String[] p1 = id.split("\\.");
        String[] p2 = ed.getId().split("\\.");
        for (int i = 0; i < Integer.min(p1.length, p2.length); ++i) {
            if (p1[i].equals(p2[i])) continue;
            ElementAnalysis sed = edDef.get(i - 1);
            int i1 = this.indexOfName(sed, p1[i]);
            int i2 = this.indexOfName(sed, p2[i]);
            if (i == Integer.min(p1.length, p2.length) - 1 && i1 == i2 && !p1[i].contains(":") && p2[i].contains(":")) {
                return true;
            }
            return i1 < i2;
        }
        return p1.length < p2.length;
    }

    private int indexOfName(ElementAnalysis sed, String name) {
        if (name.contains(":")) {
            name = name.substring(0, name.indexOf(":"));
        }
        for (int i = 0; i < sed.getChildren().getList().size(); ++i) {
            if (!name.equals(sed.getChildren().getList().get(i).getName())) continue;
            return i;
        }
        return -1;
    }

    private List<ElementAnalysis> analysePath(ElementDefinition ed) {
        ArrayList<ElementAnalysis> res = new ArrayList<ElementAnalysis>();
        for (String pn : ed.getPath().split("\\.")) {
            this.analysePathSegment(ed, res, pn);
        }
        return res;
    }

    private void analysePathSegment(ElementDefinition ed, List<ElementAnalysis> res, String pn) {
        if (res.isEmpty()) {
            StructureDefinition sd = this.context.fetchTypeDefinition(pn);
            if (sd == null) {
                String message = this.context.formatMessage("Unknown_type__at_", pn, ed.getId());
                throw new DefinitionException(message);
            }
            res.add(new ElementAnalysis(sd, sd.getSnapshot().getElementFirstRep(), null));
        } else {
            ElementAnalysis sed = res.get(res.size() - 1);
            sed.setChildren(this.utils.getChildMap(sed.getStructure(), sed.getElement(), true, sed.getType()));
            ElementDefinition t = null;
            String type = null;
            for (ElementDefinition child : sed.getChildren().getList()) {
                String rn;
                if (pn.equals(child.getName())) {
                    t = child;
                    break;
                }
                if (!child.getName().endsWith("[x]") || !pn.startsWith(rn = child.getName().substring(0, child.getName().length() - 3))) continue;
                t = child;
                String tn = pn.substring(rn.length());
                if (TypesUtilities.isPrimitive(Utilities.uncapitalize((String)tn))) {
                    type = Utilities.uncapitalize((String)tn);
                    break;
                }
                type = tn;
                break;
            }
            if (t == null) {
                String message = this.context.formatMessage("UNKNOWN_PROPERTY", pn, ed.getPath());
                throw new DefinitionException("Unknown path " + pn + " in path " + ed.getPath() + ": " + message);
            }
            res.add(new ElementAnalysis(sed.getChildren().getSource(), t, type));
        }
    }

    private int findEndOfSlice(List<ElementDefinition> elements, ElementDefinition slice) {
        for (int i = elements.indexOf(slice); i < elements.size(); ++i) {
            ElementDefinition e = elements.get(i);
            if (e.getPath().startsWith(slice.getPath() + ".") || e.getPath().equals(slice.getPath()) && slice.getSliceName().equals(e.getSliceName())) continue;
            return i - 1;
        }
        return elements.size() - 1;
    }

    private void merge(ElementDefinition focus, ElementDefinition base) {
        if (base.hasLabel() && !focus.hasLabel()) {
            focus.setLabelElement(base.getLabelElement());
        }
        if (base.hasCode() && !focus.hasCode()) {
            focus.getCode().addAll(base.getCode());
        }
        if (base.hasShort() && !focus.hasShort()) {
            focus.setShortElement(base.getShortElement());
        }
        if (base.hasDefinition() && !focus.hasDefinition()) {
            focus.setDefinitionElement(base.getDefinitionElement());
        }
        if (base.hasComment() && !focus.hasComment()) {
            focus.setCommentElement(base.getCommentElement());
        }
        if (base.hasRequirements() && !focus.hasRequirements()) {
            focus.setRequirementsElement(base.getRequirementsElement());
        }
        if (base.hasAlias() && !focus.hasAlias()) {
            focus.getAlias().addAll(base.getAlias());
        }
        if (base.hasMin() && !focus.hasMin()) {
            focus.setMinElement(base.getMinElement());
        }
        if (base.hasMax() && !focus.hasMax()) {
            focus.setMaxElement(base.getMaxElement());
        }
        if (base.hasType() && !focus.hasType()) {
            focus.getType().addAll(base.getType());
        }
        if (base.hasDefaultValue() && !focus.hasDefaultValue()) {
            focus.setDefaultValue(base.getDefaultValue());
        }
        if (base.hasMeaningWhenMissing() && !focus.hasMeaningWhenMissing()) {
            focus.setMeaningWhenMissingElement(base.getMeaningWhenMissingElement());
        }
        if (base.hasOrderMeaning() && !focus.hasOrderMeaning()) {
            focus.setOrderMeaningElement(base.getOrderMeaningElement());
        }
        if (base.hasFixed() && !focus.hasFixed()) {
            focus.setFixed(base.getFixed());
        }
        if (base.hasPattern() && !focus.hasPattern()) {
            focus.setPattern(base.getPattern());
        }
        if (base.hasExample() && !focus.hasExample()) {
            focus.getExample().addAll(base.getExample());
        }
        if (base.hasMinValue() && !focus.hasMinValue()) {
            focus.setMinValue(base.getMinValue());
        }
        if (base.hasMaxValue() && !focus.hasMaxValue()) {
            focus.setMaxValue(base.getMaxValue());
        }
        if (base.hasMaxLength() && !focus.hasMaxLength()) {
            focus.setMaxLengthElement(base.getMaxLengthElement());
        }
        if (base.hasConstraint() && !focus.hasConstraint()) {
            focus.getConstraint().addAll(base.getConstraint());
        }
        if (base.hasMustHaveValue() && !focus.hasMustHaveValue()) {
            focus.setMustHaveValueElement(base.getMustHaveValueElement());
        }
        if (base.hasValueAlternatives() && !focus.hasValueAlternatives()) {
            focus.getValueAlternatives().addAll(base.getValueAlternatives());
        }
        if (base.hasMustSupport() && !focus.hasMustSupport()) {
            focus.setMustSupportElement(base.getMustSupportElement());
        }
        if (base.hasIsModifier() && !focus.hasIsModifier()) {
            focus.setIsModifierElement(base.getIsModifierElement());
        }
        if (base.hasIsModifierReason() && !focus.hasIsModifierReason()) {
            focus.setIsModifierReasonElement(base.getIsModifierReasonElement());
        }
        if (base.hasIsSummary() && !focus.hasIsSummary()) {
            focus.setIsSummaryElement(base.getIsSummaryElement());
        }
        if (base.hasBinding() && !focus.hasBinding()) {
            focus.setBinding(base.getBinding());
        }
    }

    private boolean isExtensionSlicing(ElementDefinition ed) {
        if (!Utilities.existsInList((String)ed.getName(), (String[])new String[]{"extension", "modiferExtension"})) {
            return false;
        }
        if (ed.getSlicing().getRules() != ElementDefinition.SlicingRules.OPEN || !ed.getSlicing().hasOrdered() || ed.getSlicing().getOrdered() || ed.getSlicing().getDiscriminator().size() != 1) {
            return false;
        }
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d = ed.getSlicing().getDiscriminatorFirstRep();
        return d.getType() == ElementDefinition.DiscriminatorType.VALUE && "url".equals(d.getPath());
    }

    private SliceInfo getSlicing(ElementDefinition ed) {
        for (int i = this.slicings.size() - 1; i >= 0; --i) {
            SliceInfo si = this.slicings.get(i);
            if (si.closed) continue;
            if (si.path.length() > ed.getPath().length()) {
                si.closed = true;
                continue;
            }
            if (!ed.getPath().startsWith(si.path)) continue;
            return si;
        }
        return null;
    }

    public List<ElementDefinition> supplementMissingDiffElements(StructureDefinition profile) {
        ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
        list.addAll(profile.getDifferential().getElement());
        if (list.isEmpty()) {
            ElementDefinition root = new ElementDefinition().setPath(profile.getTypeName());
            root.setId(profile.getTypeName());
            list.add(root);
        } else if (((ElementDefinition)list.get(0)).getPath().contains(".")) {
            ElementDefinition root = new ElementDefinition().setPath(profile.getTypeName());
            root.setId(profile.getTypeName());
            list.add(0, root);
        }
        this.insertMissingSparseElements(list, profile.getTypeName());
        return list;
    }

    private void insertMissingSparseElements(List<ElementDefinition> list, String typeName) {
        if (list.isEmpty() || list.get(0).getPath().contains(".")) {
            ElementDefinition ed = new ElementDefinition();
            ed.setPath(typeName);
            list.add(0, ed);
        }
        for (int i = 1; i < list.size(); ++i) {
            int firstDiff;
            String[] pathCurrent = list.get(i).getPath().split("\\.");
            String[] pathLast = list.get(i - 1).getPath().split("\\.");
            for (firstDiff = 0; firstDiff < pathCurrent.length && firstDiff < pathLast.length && pathCurrent[firstDiff].equals(pathLast[firstDiff]); ++firstDiff) {
            }
            if (this.isSibling(pathCurrent, pathLast, firstDiff) || this.isChild(pathCurrent, pathLast, firstDiff)) continue;
            ElementDefinition parent = this.findParent(list, i, list.get(i).getPath());
            int parentDepth = Utilities.charCount((String)parent.getPath(), (char)'.') + 1;
            int childDepth = Utilities.charCount((String)list.get(i).getPath(), (char)'.') + 1;
            if (childDepth <= parentDepth + 1) continue;
            String basePath = parent.getPath();
            String baseId = parent.getId();
            for (int index = parentDepth; index >= firstDiff; --index) {
                String mtail = this.makeTail(pathCurrent, parentDepth, index);
                ElementDefinition root = new ElementDefinition().setPath(basePath + "." + mtail);
                root.setId(baseId + "." + mtail);
                list.add(i, root);
            }
        }
    }

    private ElementDefinition findParent(List<ElementDefinition> list, int i, String path) {
        while (i > 0 && !path.startsWith(list.get(i).getPath() + ".")) {
            --i;
        }
        return list.get(i);
    }

    private boolean isSibling(String[] pathCurrent, String[] pathLast, int firstDiff) {
        return pathCurrent.length == pathLast.length && firstDiff == pathCurrent.length - 1;
    }

    private boolean isChild(String[] pathCurrent, String[] pathLast, int firstDiff) {
        return pathCurrent.length == pathLast.length + 1 && firstDiff == pathLast.length;
    }

    private String makeTail(String[] pathCurrent, int start, int index) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(".");
        for (int i = start; i <= index; ++i) {
            b.append(pathCurrent[i]);
        }
        return b.toString();
    }

    public StructureDefinition trimSnapshot(StructureDefinition profile) {
        Stack<ElementDefinition> stack = new Stack<ElementDefinition>();
        ElementDefinition edRoot = profile.getSnapshot().getElementFirstRep();
        if (!edRoot.hasUserData("SNAPSHOT_FROM_DIFF")) {
            stack.push(edRoot);
            for (int i = 1; i < profile.getSnapshot().getElement().size(); ++i) {
                ElementDefinition ed = profile.getSnapshot().getElement().get(i);
                String cpath = ed.getPath();
                boolean fromDiff = ed.hasUserData("profileutilities.snapshot.diffsource");
                String spath = ((ElementDefinition)stack.peek()).getPath();
                while (!cpath.equals(spath) && !cpath.startsWith(spath + ".")) {
                    stack.pop();
                    spath = ((ElementDefinition)stack.peek()).getPath();
                }
                stack.push(ed);
                if (!fromDiff) continue;
                for (int j = stack.size() - 1; j >= 0 && !((ElementDefinition)stack.get(j)).hasUserData("SNAPSHOT_FROM_DIFF"); --j) {
                    ((ElementDefinition)stack.get(j)).setUserData("SNAPSHOT_FROM_DIFF", true);
                }
            }
        }
        edRoot.setUserData("SNAPSHOT_FROM_DIFF", true);
        StructureDefinition res = new StructureDefinition();
        res.setUrl(profile.getUrl());
        res.setVersion(profile.getVersion());
        res.setName(profile.getName());
        res.setBaseDefinition(profile.getBaseDefinition());
        for (ElementDefinition ed : profile.getSnapshot().getElement()) {
            if (!ed.hasUserData("SNAPSHOT_FROM_DIFF")) continue;
            res.getSnapshot().getElement().add(ed);
        }
        res.setWebPath(profile.getWebPath());
        return res;
    }

    public class SliceInfo {
        SliceInfo parent;
        String path;
        boolean closed;
        ElementDefinition slicer;
        List<ElementDefinition> sliceStuff;
        List<ElementDefinition> slices;

        public SliceInfo(SliceInfo parent, ElementDefinition ed) {
            this.parent = parent;
            this.path = ed.getPath();
            this.slicer = ed;
            this.sliceStuff = new ArrayList<ElementDefinition>();
            if (parent != null) {
                parent.add(ed);
            }
        }

        public void newSlice(ElementDefinition ed) {
            if (this.slices == null) {
                this.slices = new ArrayList<ElementDefinition>();
            }
            this.slices.add(ed);
            if (this.parent != null) {
                this.parent.add(ed);
            }
        }

        public void add(ElementDefinition ed) {
            if (this.slices == null) {
                this.sliceStuff.add(ed);
            }
            if (this.parent != null) {
                this.parent.add(ed);
            }
        }
    }

    public class ElementAnalysis {
        private StructureDefinition structure;
        private ElementDefinition element;
        private String type;
        public ProfileUtilities.SourcedChildDefinitions children;

        protected ElementAnalysis(StructureDefinition structure, ElementDefinition element, String type) {
            this.structure = structure;
            this.element = element;
            this.type = type;
        }

        public StructureDefinition getStructure() {
            return this.structure;
        }

        public ElementDefinition getElement() {
            return this.element;
        }

        public ProfileUtilities.SourcedChildDefinitions getChildren() {
            return this.children;
        }

        public void setChildren(ProfileUtilities.SourcedChildDefinitions children) {
            this.children = children;
        }

        public String getType() {
            return this.type;
        }

        public String summary() {
            return this.element.getName() + ":" + this.type;
        }
    }
}

