/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.FmlParser;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.elementmodel.NDJsonParser;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.elementmodel.SHCParser;
import org.hl7.fhir.r5.elementmodel.SHLParser;
import org.hl7.fhir.r5.elementmodel.TurtleParser;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.r5.elementmodel.VerticalBarParser;
import org.hl7.fhir.r5.elementmodel.XmlParser;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class Manager {
    public static List<ValidatedFragment> parse(IWorkerContext context, InputStream source, FhirFormat inputFormat) throws FHIRFormatError, DefinitionException, IOException, FHIRException {
        return Manager.makeParser(context, inputFormat).parse(source);
    }

    public static Element parseSingle(IWorkerContext context, InputStream source, FhirFormat inputFormat) throws FHIRFormatError, DefinitionException, IOException, FHIRException {
        return Manager.makeParser(context, inputFormat).parseSingle(source, null);
    }

    public static void compose(IWorkerContext context, Element e, OutputStream destination, FhirFormat outputFormat, IParser.OutputStyle style, String base) throws FHIRException, IOException {
        Manager.makeParser(context, outputFormat).compose(e, destination, style, base);
    }

    public static ParserBase makeParser(IWorkerContext context, FhirFormat format) {
        if (format == null) {
            throw new Error("Programming logic error: no format known");
        }
        switch (format) {
            case JSON: {
                return new JsonParser(context);
            }
            case NDJSON: {
                return new NDJsonParser(context);
            }
            case XML: {
                return new XmlParser(context);
            }
            case TURTLE: {
                return new TurtleParser(context);
            }
            case VBAR: {
                return new VerticalBarParser(context);
            }
            case SHC: {
                return new SHCParser(context);
            }
            case SHL: {
                return new SHLParser(context);
            }
            case FML: {
                return new FmlParser(context);
            }
            case TEXT: {
                throw new Error("Programming logic error: do not call makeParser for a text resource");
            }
        }
        return null;
    }

    public static Element build(IWorkerContext context, StructureDefinition sd) {
        return Manager.build(context, sd, new ProfileUtilities(context, null, null));
    }

    public static Element build(IWorkerContext context, StructureDefinition sd, ProfileUtilities profileUtilities) {
        Property p = new Property(context, sd.getSnapshot().getElementFirstRep(), sd, profileUtilities, new ContextUtilities(context));
        Element e = new Element(p.getName(), p);
        e.setPath(sd.getType());
        return e;
    }

    public static enum FhirFormat {
        XML,
        JSON,
        TURTLE,
        TEXT,
        VBAR,
        SHC,
        SHL,
        FML,
        NDJSON;


        public String getExtension() {
            switch (this) {
                case JSON: {
                    return "json";
                }
                case TURTLE: {
                    return "ttl";
                }
                case XML: {
                    return "xml";
                }
                case TEXT: {
                    return "txt";
                }
                case VBAR: {
                    return "hl7";
                }
                case SHC: {
                    return "shc";
                }
                case SHL: {
                    return "shl";
                }
                case FML: {
                    return "fml";
                }
                case NDJSON: {
                    return "ndjson";
                }
            }
            return null;
        }

        public static FhirFormat getFhirFormat(String code) {
            switch (code) {
                case "json": {
                    return JSON;
                }
                case "ttl": {
                    return TURTLE;
                }
                case "xml": {
                    return XML;
                }
                case "txt": {
                    return TEXT;
                }
                case "hl7": {
                    return VBAR;
                }
                case "shc": {
                    return SHC;
                }
                case "shl": {
                    return SHL;
                }
                case "fml": {
                    return FML;
                }
                case "ndjson": {
                    return NDJSON;
                }
            }
            return null;
        }

        public static FhirFormat readFromMimeType(String mt) {
            if (mt == null) {
                return null;
            }
            if (mt.contains("/xml") || mt.contains("+xml")) {
                return XML;
            }
            if (mt.contains("/json") || mt.contains("+json")) {
                return JSON;
            }
            return null;
        }

        public static FhirFormat fromCode(String code) {
            FhirFormat fmt = FhirFormat.getFhirFormat(code);
            if (fmt == null) {
                fmt = FhirFormat.readFromMimeType(code);
            }
            return fmt;
        }

        public String toMimeType() {
            switch (this) {
                case FML: {
                    return "text/fhir+fml";
                }
                case JSON: {
                    return "application/fhir+json";
                }
                case NDJSON: {
                    return "application/fhir+ndjson";
                }
                case SHC: {
                    return "application/shc";
                }
                case SHL: {
                    return "application/shl";
                }
                case TEXT: {
                    return "text/plain";
                }
                case TURTLE: {
                    return "application/fhir+turtle";
                }
                case VBAR: {
                    return "application/x-hl7-v2";
                }
                case XML: {
                    return "application/fhir+xml";
                }
            }
            return "??";
        }
    }
}

