/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

@MarkedToMoveToAdjunctPackage
public class NDJsonParser
extends ParserBase {
    public NDJsonParser(IWorkerContext context, ProfileUtilities utilities) {
        super(context, utilities);
    }

    public NDJsonParser(IWorkerContext context) {
        super(context);
    }

    private ValidatedFragment processLine(int lineCount, String line) throws FHIRException, IOException {
        List<ValidatedFragment> list = new JsonParser(this.context).parse(new ByteArrayInputStream(line.getBytes(StandardCharsets.UTF_8)), lineCount);
        return list.get(0);
    }

    @Override
    public List<ValidatedFragment> parse(InputStream inStream) throws IOException, FHIRException {
        int start;
        String source = FileUtilities.streamToString((InputStream)inStream);
        int length = source.length();
        int lineCount = 0;
        ArrayList<ValidatedFragment> res = new ArrayList<ValidatedFragment>();
        for (int cursor = start = 0; cursor < length; ++cursor) {
            ValidatedFragment vf;
            String line;
            while (cursor < length && source.charAt(cursor) != '\n') {
                ++cursor;
            }
            if (cursor < length) {
                line = source.substring(start, cursor);
                if (line.endsWith("\r")) {
                    line = line.substring(0, line.length() - 1);
                }
                if (Utilities.noString((String)line.trim())) {
                    vf = new ValidatedFragment("item", null, null, false);
                    this.logError(vf.getErrors(), "2024-06-30", lineCount + 1, 1, null, ValidationMessage.IssueType.INFORMATIONAL, this.context.formatMessage("NDJSON_EMPTY_LINE_WARNING", new Object[0]), ValidationMessage.IssueSeverity.WARNING);
                    res.add(vf);
                } else {
                    res.add(this.processLine(lineCount, line));
                }
                start = cursor + 1;
            } else if (cursor > start) {
                line = source.substring(start, cursor);
                if (line.endsWith("\r")) {
                    line = line.substring(0, line.length() - 1);
                }
                if (Utilities.noString((String)line.trim())) {
                    vf = new ValidatedFragment("item", null, null, false);
                    this.logError(vf.getErrors(), "2024-06-30", lineCount + 1, 1, null, ValidationMessage.IssueType.INFORMATIONAL, this.context.formatMessage("NDJSON_EMPTY_LINE_WARNING", new Object[0]), ValidationMessage.IssueSeverity.WARNING);
                    res.add(vf);
                } else {
                    res.add(this.processLine(lineCount, line));
                }
                start = cursor + 1;
            }
            ++lineCount;
        }
        return res;
    }

    @Override
    public void compose(Element e, OutputStream stream, IParser.OutputStyle style, String identity) throws FHIRException, IOException {
        throw new Error("Not done yet");
    }
}

