/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.formats;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Iterator;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.JsonParserBase;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.Availability;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BiologicallyDerivedProductDispense;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Contributor;
import org.hl7.fhir.r5.model.Count;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceAssociation;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.Distance;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EncounterHistory;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.ExtendedContactDetail;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.ExtensionHelper;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryItem;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.MonetaryComponent;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.ProductShelfLife;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.RatioRange;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestPlan;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VirtualServiceDetail;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonTrackingParser;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class JsonParser
extends JsonParserBase {
    public JsonParser() {
    }

    public JsonParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    public JsonParser(boolean allowUnknownContent, boolean allowComments) {
        this.setAllowUnknownContent(allowUnknownContent);
        this.setAllowComments(allowComments);
    }

    protected void parseBaseProperties(JsonObject json, Base res) throws IOException, FHIRFormatError {
    }

    protected <E extends Enum<E>> Enumeration<E> parseEnumeration(String s, E item, EnumFactory e) throws IOException, FHIRFormatError {
        Enumeration res = new Enumeration(e);
        if (s != null) {
            res.setValue(e.fromCode(s));
        }
        return res;
    }

    protected DateType parseDate(String v) throws IOException, FHIRFormatError {
        DateType res = new DateType(v);
        return res;
    }

    protected DateTimeType parseDateTime(String v) throws IOException, FHIRFormatError {
        DateTimeType res = new DateTimeType(v);
        return res;
    }

    protected CodeType parseCode(String v) throws IOException, FHIRFormatError {
        CodeType res = new CodeType(v);
        return res;
    }

    protected StringType parseString(String v) throws IOException, FHIRFormatError {
        StringType res = new StringType(v);
        return res;
    }

    protected IntegerType parseInteger(Long v) throws IOException, FHIRFormatError {
        IntegerType res = new IntegerType(v);
        return res;
    }

    protected Integer64Type parseInteger64(Long v) throws IOException, FHIRFormatError {
        Integer64Type res = new Integer64Type(v);
        return res;
    }

    protected OidType parseOid(String v) throws IOException, FHIRFormatError {
        OidType res = new OidType(v);
        return res;
    }

    protected CanonicalType parseCanonical(String v) throws IOException, FHIRFormatError {
        CanonicalType res = new CanonicalType(v);
        return res;
    }

    protected UriType parseUri(String v) throws IOException, FHIRFormatError {
        UriType res = new UriType(v);
        return res;
    }

    protected UuidType parseUuid(String v) throws IOException, FHIRFormatError {
        UuidType res = new UuidType(v);
        return res;
    }

    protected UrlType parseUrl(String v) throws IOException, FHIRFormatError {
        UrlType res = new UrlType(v);
        return res;
    }

    protected InstantType parseInstant(String v) throws IOException, FHIRFormatError {
        InstantType res = new InstantType(v);
        return res;
    }

    protected BooleanType parseBoolean(Boolean v) throws IOException, FHIRFormatError {
        BooleanType res = new BooleanType(v);
        return res;
    }

    protected Base64BinaryType parseBase64Binary(String v) throws IOException, FHIRFormatError {
        Base64BinaryType res = new Base64BinaryType(v);
        return res;
    }

    protected UnsignedIntType parseUnsignedInt(String v) throws IOException, FHIRFormatError {
        UnsignedIntType res = new UnsignedIntType(v);
        return res;
    }

    protected MarkdownType parseMarkdown(String v) throws IOException, FHIRFormatError {
        MarkdownType res = new MarkdownType(v);
        return res;
    }

    protected TimeType parseTime(String v) throws IOException, FHIRFormatError {
        TimeType res = new TimeType(v);
        return res;
    }

    protected IdType parseId(String v) throws IOException, FHIRFormatError {
        IdType res = new IdType(v);
        return res;
    }

    protected PositiveIntType parsePositiveInt(String v) throws IOException, FHIRFormatError {
        PositiveIntType res = new PositiveIntType(v);
        return res;
    }

    protected DecimalType parseDecimal(BigDecimal v) throws IOException, FHIRFormatError {
        DecimalType res = new DecimalType(v);
        if (v instanceof JsonTrackingParser.PresentedBigDecimal) {
            res.setRepresentation(((JsonTrackingParser.PresentedBigDecimal)v).getPresentation());
        }
        return res;
    }

    protected void parseBackboneElementProperties(JsonObject json, BackboneElement res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("modifierExtension")) {
            JsonArray array = this.getJArray(json, "modifierExtension");
            for (int i = 0; i < array.size(); ++i) {
                res.getModifierExtension().add(this.parseExtension(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected void parseBackboneTypeProperties(JsonObject json, BackboneType res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("modifierExtension")) {
            JsonArray array = this.getJArray(json, "modifierExtension");
            for (int i = 0; i < array.size(); ++i) {
                res.getModifierExtension().add(this.parseExtension(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected void parseDataTypeProperties(JsonObject json, DataType res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
    }

    @Override
    protected void parseElementProperties(JsonObject json, Element res) throws IOException, FHIRFormatError {
        if (json.has("id")) {
            res.setIdElement(this.parseString(json.get("id").getAsString()));
        }
        if (json.has("_id")) {
            this.parseElementProperties(this.getJObject(json, "_id"), res.getIdElement());
        }
        if (json.has("extension")) {
            JsonArray array = this.getJArray(json, "extension");
            for (int i = 0; i < array.size(); ++i) {
                res.getExtension().add(this.parseExtension(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Address parseAddress(JsonObject json) throws IOException, FHIRFormatError {
        Address res = new Address();
        this.parseAddressProperties(json, res);
        return res;
    }

    protected void parseAddressProperties(JsonObject json, Address res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDataTypeProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("line")) {
            array = this.getJArray(json, "line");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getLine().add(new StringType());
                    continue;
                }
                res.getLine().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_line")) {
            array = this.getJArray(json, "_line");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLine().size()) {
                    res.getLine().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getLine().get(i));
            }
        }
        if (json.has("city")) {
            res.setCityElement(this.parseString(json.get("city").getAsString()));
        }
        if (json.has("_city")) {
            this.parseElementProperties(this.getJObject(json, "_city"), res.getCityElement());
        }
        if (json.has("district")) {
            res.setDistrictElement(this.parseString(json.get("district").getAsString()));
        }
        if (json.has("_district")) {
            this.parseElementProperties(this.getJObject(json, "_district"), res.getDistrictElement());
        }
        if (json.has("state")) {
            res.setStateElement(this.parseString(json.get("state").getAsString()));
        }
        if (json.has("_state")) {
            this.parseElementProperties(this.getJObject(json, "_state"), res.getStateElement());
        }
        if (json.has("postalCode")) {
            res.setPostalCodeElement(this.parseString(json.get("postalCode").getAsString()));
        }
        if (json.has("_postalCode")) {
            this.parseElementProperties(this.getJObject(json, "_postalCode"), res.getPostalCodeElement());
        }
        if (json.has("country")) {
            res.setCountryElement(this.parseString(json.get("country").getAsString()));
        }
        if (json.has("_country")) {
            this.parseElementProperties(this.getJObject(json, "_country"), res.getCountryElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Age parseAge(JsonObject json) throws IOException, FHIRFormatError {
        Age res = new Age();
        this.parseAgeProperties(json, res);
        return res;
    }

    protected void parseAgeProperties(JsonObject json, Age res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected Annotation parseAnnotation(JsonObject json) throws IOException, FHIRFormatError {
        Annotation res = new Annotation();
        this.parseAnnotationProperties(json, res);
        return res;
    }

    protected void parseAnnotationProperties(JsonObject json, Annotation res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        DataType author = this.parseType("author", json);
        if (author != null) {
            res.setAuthor(author);
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(this.getJObject(json, "_time"), res.getTimeElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseMarkdown(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
    }

    protected Attachment parseAttachment(JsonObject json) throws IOException, FHIRFormatError {
        Attachment res = new Attachment();
        this.parseAttachmentProperties(json, res);
        return res;
    }

    protected void parseAttachmentProperties(JsonObject json, Attachment res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(this.getJObject(json, "_contentType"), res.getContentTypeElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(this.getJObject(json, "_language"), res.getLanguageElement());
        }
        if (json.has("data")) {
            res.setDataElement(this.parseBase64Binary(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(this.getJObject(json, "_data"), res.getDataElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUrl(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("size")) {
            res.setSizeElement(this.parseInteger64(json.get("size").getAsLong()));
        }
        if (json.has("_size")) {
            this.parseElementProperties(this.getJObject(json, "_size"), res.getSizeElement());
        }
        if (json.has("hash")) {
            res.setHashElement(this.parseBase64Binary(json.get("hash").getAsString()));
        }
        if (json.has("_hash")) {
            this.parseElementProperties(this.getJObject(json, "_hash"), res.getHashElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("creation")) {
            res.setCreationElement(this.parseDateTime(json.get("creation").getAsString()));
        }
        if (json.has("_creation")) {
            this.parseElementProperties(this.getJObject(json, "_creation"), res.getCreationElement());
        }
        if (json.has("height")) {
            res.setHeightElement(this.parsePositiveInt(json.get("height").getAsString()));
        }
        if (json.has("_height")) {
            this.parseElementProperties(this.getJObject(json, "_height"), res.getHeightElement());
        }
        if (json.has("width")) {
            res.setWidthElement(this.parsePositiveInt(json.get("width").getAsString()));
        }
        if (json.has("_width")) {
            this.parseElementProperties(this.getJObject(json, "_width"), res.getWidthElement());
        }
        if (json.has("frames")) {
            res.setFramesElement(this.parsePositiveInt(json.get("frames").getAsString()));
        }
        if (json.has("_frames")) {
            this.parseElementProperties(this.getJObject(json, "_frames"), res.getFramesElement());
        }
        if (json.has("duration")) {
            res.setDurationElement(this.parseDecimal(json.get("duration").getAsBigDecimal()));
        }
        if (json.has("_duration")) {
            this.parseElementProperties(this.getJObject(json, "_duration"), res.getDurationElement());
        }
        if (json.has("pages")) {
            res.setPagesElement(this.parsePositiveInt(json.get("pages").getAsString()));
        }
        if (json.has("_pages")) {
            this.parseElementProperties(this.getJObject(json, "_pages"), res.getPagesElement());
        }
    }

    protected Availability parseAvailability(JsonObject json) throws IOException, FHIRFormatError {
        Availability res = new Availability();
        this.parseAvailabilityProperties(json, res);
        return res;
    }

    protected void parseAvailabilityProperties(JsonObject json, Availability res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDataTypeProperties(json, res);
        if (json.has("availableTime")) {
            array = this.getJArray(json, "availableTime");
            for (i = 0; i < array.size(); ++i) {
                res.getAvailableTime().add(this.parseAvailabilityAvailableTimeComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("notAvailableTime")) {
            array = this.getJArray(json, "notAvailableTime");
            for (i = 0; i < array.size(); ++i) {
                res.getNotAvailableTime().add(this.parseAvailabilityNotAvailableTimeComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Availability.AvailabilityAvailableTimeComponent parseAvailabilityAvailableTimeComponent(JsonObject json) throws IOException, FHIRFormatError {
        Availability.AvailabilityAvailableTimeComponent res = new Availability.AvailabilityAvailableTimeComponent();
        this.parseAvailabilityAvailableTimeComponentProperties(json, res);
        return res;
    }

    protected void parseAvailabilityAvailableTimeComponentProperties(JsonObject json, Availability.AvailabilityAvailableTimeComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseElementProperties(json, res);
        if (json.has("daysOfWeek")) {
            array = this.getJArray(json, "daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getDaysOfWeek().add(new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory(), Enumerations.DaysOfWeek.NULL));
                    continue;
                }
                res.getDaysOfWeek().add(this.parseEnumeration(array.get(i).getAsString(), Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
            }
        }
        if (json.has("_daysOfWeek")) {
            array = this.getJArray(json, "_daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDaysOfWeek().size()) {
                    res.getDaysOfWeek().add(this.parseEnumeration(null, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getDaysOfWeek().get(i));
            }
        }
        if (json.has("allDay")) {
            res.setAllDayElement(this.parseBoolean(json.get("allDay").getAsBoolean()));
        }
        if (json.has("_allDay")) {
            this.parseElementProperties(this.getJObject(json, "_allDay"), res.getAllDayElement());
        }
        if (json.has("availableStartTime")) {
            res.setAvailableStartTimeElement(this.parseTime(json.get("availableStartTime").getAsString()));
        }
        if (json.has("_availableStartTime")) {
            this.parseElementProperties(this.getJObject(json, "_availableStartTime"), res.getAvailableStartTimeElement());
        }
        if (json.has("availableEndTime")) {
            res.setAvailableEndTimeElement(this.parseTime(json.get("availableEndTime").getAsString()));
        }
        if (json.has("_availableEndTime")) {
            this.parseElementProperties(this.getJObject(json, "_availableEndTime"), res.getAvailableEndTimeElement());
        }
    }

    protected Availability.AvailabilityNotAvailableTimeComponent parseAvailabilityNotAvailableTimeComponent(JsonObject json) throws IOException, FHIRFormatError {
        Availability.AvailabilityNotAvailableTimeComponent res = new Availability.AvailabilityNotAvailableTimeComponent();
        this.parseAvailabilityNotAvailableTimeComponentProperties(json, res);
        return res;
    }

    protected void parseAvailabilityNotAvailableTimeComponentProperties(JsonObject json, Availability.AvailabilityNotAvailableTimeComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("during")) {
            res.setDuring(this.parsePeriod(this.getJObject(json, "during")));
        }
    }

    protected CodeableConcept parseCodeableConcept(JsonObject json) throws IOException, FHIRFormatError {
        CodeableConcept res = new CodeableConcept();
        this.parseCodeableConceptProperties(json, res);
        return res;
    }

    protected void parseCodeableConceptProperties(JsonObject json, CodeableConcept res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("coding")) {
            JsonArray array = this.getJArray(json, "coding");
            for (int i = 0; i < array.size(); ++i) {
                res.getCoding().add(this.parseCoding(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
    }

    protected CodeableReference parseCodeableReference(JsonObject json) throws IOException, FHIRFormatError {
        CodeableReference res = new CodeableReference();
        this.parseCodeableReferenceProperties(json, res);
        return res;
    }

    protected void parseCodeableReferenceProperties(JsonObject json, CodeableReference res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("concept")) {
            res.setConcept(this.parseCodeableConcept(this.getJObject(json, "concept")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
    }

    protected Coding parseCoding(JsonObject json) throws IOException, FHIRFormatError {
        Coding res = new Coding();
        this.parseCodingProperties(json, res);
        return res;
    }

    protected void parseCodingProperties(JsonObject json, Coding res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(this.getJObject(json, "_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("userSelected")) {
            res.setUserSelectedElement(this.parseBoolean(json.get("userSelected").getAsBoolean()));
        }
        if (json.has("_userSelected")) {
            this.parseElementProperties(this.getJObject(json, "_userSelected"), res.getUserSelectedElement());
        }
    }

    protected ContactDetail parseContactDetail(JsonObject json) throws IOException, FHIRFormatError {
        ContactDetail res = new ContactDetail();
        this.parseContactDetailProperties(json, res);
        return res;
    }

    protected void parseContactDetailProperties(JsonObject json, ContactDetail res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = this.getJArray(json, "telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ContactPoint parseContactPoint(JsonObject json) throws IOException, FHIRFormatError {
        ContactPoint res = new ContactPoint();
        this.parseContactPointProperties(json, res);
        return res;
    }

    protected void parseContactPointProperties(JsonObject json, ContactPoint res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseEnumeration(json.get("system").getAsString(), ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(this.getJObject(json, "_system"), res.getSystemElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("rank")) {
            res.setRankElement(this.parsePositiveInt(json.get("rank").getAsString()));
        }
        if (json.has("_rank")) {
            this.parseElementProperties(this.getJObject(json, "_rank"), res.getRankElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Contributor parseContributor(JsonObject json) throws IOException, FHIRFormatError {
        Contributor res = new Contributor();
        this.parseContributorProperties(json, res);
        return res;
    }

    protected void parseContributorProperties(JsonObject json, Contributor res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("contact")) {
            JsonArray array = this.getJArray(json, "contact");
            for (int i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Count parseCount(JsonObject json) throws IOException, FHIRFormatError {
        Count res = new Count();
        this.parseCountProperties(json, res);
        return res;
    }

    protected void parseCountProperties(JsonObject json, Count res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected DataRequirement parseDataRequirement(JsonObject json) throws IOException, FHIRFormatError {
        DataRequirement res = new DataRequirement();
        this.parseDataRequirementProperties(json, res);
        return res;
    }

    protected void parseDataRequirementProperties(JsonObject json, DataRequirement res) throws IOException, FHIRFormatError {
        int i;
        DataType subject;
        int i2;
        JsonArray array;
        this.parseDataTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.FHIRTypes.NULL, new Enumerations.FHIRTypesEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            array = this.getJArray(json, "profile");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getProfile().add(new CanonicalType());
                    continue;
                }
                res.getProfile().add(this.parseCanonical(array.get(i2).getAsString()));
            }
        }
        if (json.has("_profile")) {
            array = this.getJArray(json, "_profile");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getProfile().size()) {
                    res.getProfile().add(this.parseCanonical(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i2), res.getProfile().get(i2));
            }
        }
        if ((subject = this.parseType("subject", json)) != null) {
            res.setSubject(subject);
        }
        if (json.has("mustSupport")) {
            JsonArray array2 = this.getJArray(json, "mustSupport");
            for (i = 0; i < array2.size(); ++i) {
                if (array2.get(i).isJsonNull()) {
                    res.getMustSupport().add(new StringType());
                    continue;
                }
                res.getMustSupport().add(this.parseString(array2.get(i).getAsString()));
            }
        }
        if (json.has("_mustSupport")) {
            JsonArray array3 = this.getJArray(json, "_mustSupport");
            for (i = 0; i < array3.size(); ++i) {
                if (i == res.getMustSupport().size()) {
                    res.getMustSupport().add(this.parseString(null));
                }
                if (!(array3.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array3, i), res.getMustSupport().get(i));
            }
        }
        if (json.has("codeFilter")) {
            JsonArray array4 = this.getJArray(json, "codeFilter");
            for (i = 0; i < array4.size(); ++i) {
                res.getCodeFilter().add(this.parseDataRequirementCodeFilterComponent(this.getJsonObjectFromArray(array4, i)));
            }
        }
        if (json.has("dateFilter")) {
            JsonArray array5 = this.getJArray(json, "dateFilter");
            for (i = 0; i < array5.size(); ++i) {
                res.getDateFilter().add(this.parseDataRequirementDateFilterComponent(this.getJsonObjectFromArray(array5, i)));
            }
        }
        if (json.has("valueFilter")) {
            JsonArray array6 = this.getJArray(json, "valueFilter");
            for (i = 0; i < array6.size(); ++i) {
                res.getValueFilter().add(this.parseDataRequirementValueFilterComponent(this.getJsonObjectFromArray(array6, i)));
            }
        }
        if (json.has("limit")) {
            res.setLimitElement(this.parsePositiveInt(json.get("limit").getAsString()));
        }
        if (json.has("_limit")) {
            this.parseElementProperties(this.getJObject(json, "_limit"), res.getLimitElement());
        }
        if (json.has("sort")) {
            JsonArray array7 = this.getJArray(json, "sort");
            for (i = 0; i < array7.size(); ++i) {
                res.getSort().add(this.parseDataRequirementSortComponent(this.getJsonObjectFromArray(array7, i)));
            }
        }
    }

    protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementCodeFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
        DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
        this.parseDataRequirementCodeFilterComponentProperties(json, res);
        return res;
    }

    protected void parseDataRequirementCodeFilterComponentProperties(JsonObject json, DataRequirement.DataRequirementCodeFilterComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("searchParam")) {
            res.setSearchParamElement(this.parseString(json.get("searchParam").getAsString()));
        }
        if (json.has("_searchParam")) {
            this.parseElementProperties(this.getJObject(json, "_searchParam"), res.getSearchParamElement());
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseCanonical(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(this.getJObject(json, "_valueSet"), res.getValueSetElement());
        }
        if (json.has("code")) {
            JsonArray array = this.getJArray(json, "code");
            for (int i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCoding(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDateFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
        DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
        this.parseDataRequirementDateFilterComponentProperties(json, res);
        return res;
    }

    protected void parseDataRequirementDateFilterComponentProperties(JsonObject json, DataRequirement.DataRequirementDateFilterComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("searchParam")) {
            res.setSearchParamElement(this.parseString(json.get("searchParam").getAsString()));
        }
        if (json.has("_searchParam")) {
            this.parseElementProperties(this.getJObject(json, "_searchParam"), res.getSearchParamElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected DataRequirement.DataRequirementValueFilterComponent parseDataRequirementValueFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
        DataRequirement.DataRequirementValueFilterComponent res = new DataRequirement.DataRequirementValueFilterComponent();
        this.parseDataRequirementValueFilterComponentProperties(json, res);
        return res;
    }

    protected void parseDataRequirementValueFilterComponentProperties(JsonObject json, DataRequirement.DataRequirementValueFilterComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("searchParam")) {
            res.setSearchParamElement(this.parseString(json.get("searchParam").getAsString()));
        }
        if (json.has("_searchParam")) {
            this.parseElementProperties(this.getJObject(json, "_searchParam"), res.getSearchParamElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), DataRequirement.ValueFilterComparator.NULL, new DataRequirement.ValueFilterComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(this.getJObject(json, "_comparator"), res.getComparatorElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected DataRequirement.DataRequirementSortComponent parseDataRequirementSortComponent(JsonObject json) throws IOException, FHIRFormatError {
        DataRequirement.DataRequirementSortComponent res = new DataRequirement.DataRequirementSortComponent();
        this.parseDataRequirementSortComponentProperties(json, res);
        return res;
    }

    protected void parseDataRequirementSortComponentProperties(JsonObject json, DataRequirement.DataRequirementSortComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("direction")) {
            res.setDirectionElement(this.parseEnumeration(json.get("direction").getAsString(), DataRequirement.SortDirection.NULL, new DataRequirement.SortDirectionEnumFactory()));
        }
        if (json.has("_direction")) {
            this.parseElementProperties(this.getJObject(json, "_direction"), res.getDirectionElement());
        }
    }

    protected Distance parseDistance(JsonObject json) throws IOException, FHIRFormatError {
        Distance res = new Distance();
        this.parseDistanceProperties(json, res);
        return res;
    }

    protected void parseDistanceProperties(JsonObject json, Distance res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected Dosage parseDosage(JsonObject json) throws IOException, FHIRFormatError {
        Dosage res = new Dosage();
        this.parseDosageProperties(json, res);
        return res;
    }

    protected void parseDosageProperties(JsonObject json, Dosage res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneTypeProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parseInteger(json.get("sequence").getAsLong()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("additionalInstruction")) {
            array = this.getJArray(json, "additionalInstruction");
            for (i = 0; i < array.size(); ++i) {
                res.getAdditionalInstruction().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("patientInstruction")) {
            res.setPatientInstructionElement(this.parseString(json.get("patientInstruction").getAsString()));
        }
        if (json.has("_patientInstruction")) {
            this.parseElementProperties(this.getJObject(json, "_patientInstruction"), res.getPatientInstructionElement());
        }
        if (json.has("timing")) {
            res.setTiming(this.parseTiming(this.getJObject(json, "timing")));
        }
        if (json.has("asNeeded")) {
            res.setAsNeededElement(this.parseBoolean(json.get("asNeeded").getAsBoolean()));
        }
        if (json.has("_asNeeded")) {
            this.parseElementProperties(this.getJObject(json, "_asNeeded"), res.getAsNeededElement());
        }
        if (json.has("asNeededFor")) {
            array = this.getJArray(json, "asNeededFor");
            for (i = 0; i < array.size(); ++i) {
                res.getAsNeededFor().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("site")) {
            res.setSite(this.parseCodeableConcept(this.getJObject(json, "site")));
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(this.getJObject(json, "route")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(this.getJObject(json, "method")));
        }
        if (json.has("doseAndRate")) {
            array = this.getJArray(json, "doseAndRate");
            for (i = 0; i < array.size(); ++i) {
                res.getDoseAndRate().add(this.parseDosageDoseAndRateComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("maxDosePerPeriod")) {
            array = this.getJArray(json, "maxDosePerPeriod");
            for (i = 0; i < array.size(); ++i) {
                res.getMaxDosePerPeriod().add(this.parseRatio(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("maxDosePerAdministration")) {
            res.setMaxDosePerAdministration(this.parseQuantity(this.getJObject(json, "maxDosePerAdministration")));
        }
        if (json.has("maxDosePerLifetime")) {
            res.setMaxDosePerLifetime(this.parseQuantity(this.getJObject(json, "maxDosePerLifetime")));
        }
    }

    protected Dosage.DosageDoseAndRateComponent parseDosageDoseAndRateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Dosage.DosageDoseAndRateComponent res = new Dosage.DosageDoseAndRateComponent();
        this.parseDosageDoseAndRateComponentProperties(json, res);
        return res;
    }

    protected void parseDosageDoseAndRateComponentProperties(JsonObject json, Dosage.DosageDoseAndRateComponent res) throws IOException, FHIRFormatError {
        DataType rate;
        DataType dose;
        this.parseElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((dose = this.parseType("dose", json)) != null) {
            res.setDose(dose);
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
    }

    protected Duration parseDuration(JsonObject json) throws IOException, FHIRFormatError {
        Duration res = new Duration();
        this.parseDurationProperties(json, res);
        return res;
    }

    protected void parseDurationProperties(JsonObject json, Duration res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected ElementDefinition parseElementDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition res = new ElementDefinition();
        this.parseElementDefinitionProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionProperties(JsonObject json, ElementDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType maxValue;
        DataType minValue;
        DataType pattern;
        DataType fixed;
        DataType defaultValue;
        int i2;
        JsonArray array2;
        this.parseBackboneTypeProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("representation")) {
            array2 = this.getJArray(json, "representation");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getRepresentation().add(new Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory(), ElementDefinition.PropertyRepresentation.NULL));
                    continue;
                }
                res.getRepresentation().add(this.parseEnumeration(array2.get(i2).getAsString(), ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
            }
        }
        if (json.has("_representation")) {
            array2 = this.getJArray(json, "_representation");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getRepresentation().size()) {
                    res.getRepresentation().add(this.parseEnumeration(null, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getRepresentation().get(i2));
            }
        }
        if (json.has("sliceName")) {
            res.setSliceNameElement(this.parseString(json.get("sliceName").getAsString()));
        }
        if (json.has("_sliceName")) {
            this.parseElementProperties(this.getJObject(json, "_sliceName"), res.getSliceNameElement());
        }
        if (json.has("sliceIsConstraining")) {
            res.setSliceIsConstrainingElement(this.parseBoolean(json.get("sliceIsConstraining").getAsBoolean()));
        }
        if (json.has("_sliceIsConstraining")) {
            this.parseElementProperties(this.getJObject(json, "_sliceIsConstraining"), res.getSliceIsConstrainingElement());
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(this.getJObject(json, "_label"), res.getLabelElement());
        }
        if (json.has("code")) {
            array2 = this.getJArray(json, "code");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getCode().add(this.parseCoding(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("slicing")) {
            res.setSlicing(this.parseElementDefinitionSlicingComponent(this.getJObject(json, "slicing")));
        }
        if (json.has("short")) {
            res.setShortElement(this.parseString(json.get("short").getAsString()));
        }
        if (json.has("_short")) {
            this.parseElementProperties(this.getJObject(json, "_short"), res.getShortElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseMarkdown(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(this.getJObject(json, "_definition"), res.getDefinitionElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseMarkdown(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseMarkdown(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(this.getJObject(json, "_requirements"), res.getRequirementsElement());
        }
        if (json.has("alias")) {
            array2 = this.getJArray(json, "alias");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getAlias().add(new StringType());
                    continue;
                }
                res.getAlias().add(this.parseString(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_alias")) {
            array2 = this.getJArray(json, "_alias");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getAlias().size()) {
                    res.getAlias().add(this.parseString(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getAlias().get(i2));
            }
        }
        if (json.has("min")) {
            res.setMinElement(this.parseUnsignedInt(json.get("min").getAsString()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(this.getJObject(json, "_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(this.getJObject(json, "_max"), res.getMaxElement());
        }
        if (json.has("base")) {
            res.setBase(this.parseElementDefinitionBaseComponent(this.getJObject(json, "base")));
        }
        if (json.has("contentReference")) {
            res.setContentReferenceElement(this.parseUri(json.get("contentReference").getAsString()));
        }
        if (json.has("_contentReference")) {
            this.parseElementProperties(this.getJObject(json, "_contentReference"), res.getContentReferenceElement());
        }
        if (json.has("type")) {
            array2 = this.getJArray(json, "type");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getType().add(this.parseElementDefinitionTypeRefComponent(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if ((defaultValue = this.parseType("defaultValue", json)) != null) {
            res.setDefaultValue(defaultValue);
        }
        if (json.has("meaningWhenMissing")) {
            res.setMeaningWhenMissingElement(this.parseMarkdown(json.get("meaningWhenMissing").getAsString()));
        }
        if (json.has("_meaningWhenMissing")) {
            this.parseElementProperties(this.getJObject(json, "_meaningWhenMissing"), res.getMeaningWhenMissingElement());
        }
        if (json.has("orderMeaning")) {
            res.setOrderMeaningElement(this.parseString(json.get("orderMeaning").getAsString()));
        }
        if (json.has("_orderMeaning")) {
            this.parseElementProperties(this.getJObject(json, "_orderMeaning"), res.getOrderMeaningElement());
        }
        if ((fixed = this.parseType("fixed", json)) != null) {
            res.setFixed(fixed);
        }
        if ((pattern = this.parseType("pattern", json)) != null) {
            res.setPattern(pattern);
        }
        if (json.has("example")) {
            JsonArray array3 = this.getJArray(json, "example");
            for (int i3 = 0; i3 < array3.size(); ++i3) {
                res.getExample().add(this.parseElementDefinitionExampleComponent(this.getJsonObjectFromArray(array3, i3)));
            }
        }
        if ((minValue = this.parseType("minValue", json)) != null) {
            res.setMinValue(minValue);
        }
        if ((maxValue = this.parseType("maxValue", json)) != null) {
            res.setMaxValue(maxValue);
        }
        if (json.has("maxLength")) {
            res.setMaxLengthElement(this.parseInteger(json.get("maxLength").getAsLong()));
        }
        if (json.has("_maxLength")) {
            this.parseElementProperties(this.getJObject(json, "_maxLength"), res.getMaxLengthElement());
        }
        if (json.has("condition")) {
            array = this.getJArray(json, "condition");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getCondition().add(new IdType());
                    continue;
                }
                res.getCondition().add(this.parseId(array.get(i).getAsString()));
            }
        }
        if (json.has("_condition")) {
            array = this.getJArray(json, "_condition");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCondition().size()) {
                    res.getCondition().add(this.parseId(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getCondition().get(i));
            }
        }
        if (json.has("constraint")) {
            array = this.getJArray(json, "constraint");
            for (i = 0; i < array.size(); ++i) {
                res.getConstraint().add(this.parseElementDefinitionConstraintComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("mustHaveValue")) {
            res.setMustHaveValueElement(this.parseBoolean(json.get("mustHaveValue").getAsBoolean()));
        }
        if (json.has("_mustHaveValue")) {
            this.parseElementProperties(this.getJObject(json, "_mustHaveValue"), res.getMustHaveValueElement());
        }
        if (json.has("valueAlternatives")) {
            array = this.getJArray(json, "valueAlternatives");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getValueAlternatives().add(new CanonicalType());
                    continue;
                }
                res.getValueAlternatives().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_valueAlternatives")) {
            array = this.getJArray(json, "_valueAlternatives");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getValueAlternatives().size()) {
                    res.getValueAlternatives().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getValueAlternatives().get(i));
            }
        }
        if (json.has("mustSupport")) {
            res.setMustSupportElement(this.parseBoolean(json.get("mustSupport").getAsBoolean()));
        }
        if (json.has("_mustSupport")) {
            this.parseElementProperties(this.getJObject(json, "_mustSupport"), res.getMustSupportElement());
        }
        if (json.has("isModifier")) {
            res.setIsModifierElement(this.parseBoolean(json.get("isModifier").getAsBoolean()));
        }
        if (json.has("_isModifier")) {
            this.parseElementProperties(this.getJObject(json, "_isModifier"), res.getIsModifierElement());
        }
        if (json.has("isModifierReason")) {
            res.setIsModifierReasonElement(this.parseString(json.get("isModifierReason").getAsString()));
        }
        if (json.has("_isModifierReason")) {
            this.parseElementProperties(this.getJObject(json, "_isModifierReason"), res.getIsModifierReasonElement());
        }
        if (json.has("isSummary")) {
            res.setIsSummaryElement(this.parseBoolean(json.get("isSummary").getAsBoolean()));
        }
        if (json.has("_isSummary")) {
            this.parseElementProperties(this.getJObject(json, "_isSummary"), res.getIsSummaryElement());
        }
        if (json.has("binding")) {
            res.setBinding(this.parseElementDefinitionBindingComponent(this.getJObject(json, "binding")));
        }
        if (json.has("mapping")) {
            array = this.getJArray(json, "mapping");
            for (i = 0; i < array.size(); ++i) {
                res.getMapping().add(this.parseElementDefinitionMappingComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionSlicingComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
        this.parseElementDefinitionSlicingComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionSlicingComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionSlicingComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("discriminator")) {
            JsonArray array = this.getJArray(json, "discriminator");
            for (int i = 0; i < array.size(); ++i) {
                res.getDiscriminator().add(this.parseElementDefinitionSlicingDiscriminatorComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("ordered")) {
            res.setOrderedElement(this.parseBoolean(json.get("ordered").getAsBoolean()));
        }
        if (json.has("_ordered")) {
            this.parseElementProperties(this.getJObject(json, "_ordered"), res.getOrderedElement());
        }
        if (json.has("rules")) {
            res.setRulesElement(this.parseEnumeration(json.get("rules").getAsString(), ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
        }
        if (json.has("_rules")) {
            this.parseElementProperties(this.getJObject(json, "_rules"), res.getRulesElement());
        }
    }

    protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionSlicingDiscriminatorComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        this.parseElementDefinitionSlicingDiscriminatorComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionSlicingDiscriminatorComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
    }

    protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionBaseComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
        this.parseElementDefinitionBaseComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionBaseComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionBaseComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseUnsignedInt(json.get("min").getAsString()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(this.getJObject(json, "_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(this.getJObject(json, "_max"), res.getMaxElement());
        }
    }

    protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
        this.parseElementDefinitionTypeRefComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionTypeRefComponentProperties(JsonObject json, ElementDefinition.TypeRefComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseUri(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("profile")) {
            array = this.getJArray(json, "profile");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getProfile().add(new CanonicalType());
                    continue;
                }
                res.getProfile().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_profile")) {
            array = this.getJArray(json, "_profile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProfile().size()) {
                    res.getProfile().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getProfile().get(i));
            }
        }
        if (json.has("targetProfile")) {
            array = this.getJArray(json, "targetProfile");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getTargetProfile().add(new CanonicalType());
                    continue;
                }
                res.getTargetProfile().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_targetProfile")) {
            array = this.getJArray(json, "_targetProfile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getTargetProfile().size()) {
                    res.getTargetProfile().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getTargetProfile().get(i));
            }
        }
        if (json.has("aggregation")) {
            array = this.getJArray(json, "aggregation");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getAggregation().add(new Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory(), ElementDefinition.AggregationMode.NULL));
                    continue;
                }
                res.getAggregation().add(this.parseEnumeration(array.get(i).getAsString(), ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
            }
        }
        if (json.has("_aggregation")) {
            array = this.getJArray(json, "_aggregation");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getAggregation().size()) {
                    res.getAggregation().add(this.parseEnumeration(null, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getAggregation().get(i));
            }
        }
        if (json.has("versioning")) {
            res.setVersioningElement(this.parseEnumeration(json.get("versioning").getAsString(), ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
        }
        if (json.has("_versioning")) {
            this.parseElementProperties(this.getJObject(json, "_versioning"), res.getVersioningElement());
        }
    }

    protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionExampleComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
        this.parseElementDefinitionExampleComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionExampleComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionExampleComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseElementProperties(json, res);
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(this.getJObject(json, "_label"), res.getLabelElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionConstraintComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
        this.parseElementDefinitionConstraintComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionConstraintComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionConstraintComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("key")) {
            res.setKeyElement(this.parseId(json.get("key").getAsString()));
        }
        if (json.has("_key")) {
            this.parseElementProperties(this.getJObject(json, "_key"), res.getKeyElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseMarkdown(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(this.getJObject(json, "_requirements"), res.getRequirementsElement());
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(this.getJObject(json, "_severity"), res.getSeverityElement());
        }
        if (json.has("suppress")) {
            res.setSuppressElement(this.parseBoolean(json.get("suppress").getAsBoolean()));
        }
        if (json.has("_suppress")) {
            this.parseElementProperties(this.getJObject(json, "_suppress"), res.getSuppressElement());
        }
        if (json.has("human")) {
            res.setHumanElement(this.parseString(json.get("human").getAsString()));
        }
        if (json.has("_human")) {
            this.parseElementProperties(this.getJObject(json, "_human"), res.getHumanElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(this.getJObject(json, "_expression"), res.getExpressionElement());
        }
        if (json.has("source")) {
            res.setSourceElement(this.parseCanonical(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(this.getJObject(json, "_source"), res.getSourceElement());
        }
    }

    protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionBindingComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
        this.parseElementDefinitionBindingComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionBindingComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionBindingComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("strength")) {
            res.setStrengthElement(this.parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
        }
        if (json.has("_strength")) {
            this.parseElementProperties(this.getJObject(json, "_strength"), res.getStrengthElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseCanonical(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(this.getJObject(json, "_valueSet"), res.getValueSetElement());
        }
        if (json.has("additional")) {
            JsonArray array = this.getJArray(json, "additional");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdditional().add(this.parseElementDefinitionBindingAdditionalComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ElementDefinition.ElementDefinitionBindingAdditionalComponent parseElementDefinitionBindingAdditionalComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBindingAdditionalComponent res = new ElementDefinition.ElementDefinitionBindingAdditionalComponent();
        this.parseElementDefinitionBindingAdditionalComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionBindingAdditionalComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionBindingAdditionalComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseEnumeration(json.get("purpose").getAsString(), ElementDefinition.AdditionalBindingPurposeVS.NULL, new ElementDefinition.AdditionalBindingPurposeVSEnumFactory()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseCanonical(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(this.getJObject(json, "_valueSet"), res.getValueSetElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("shortDoco")) {
            res.setShortDocoElement(this.parseString(json.get("shortDoco").getAsString()));
        }
        if (json.has("_shortDoco")) {
            this.parseElementProperties(this.getJObject(json, "_shortDoco"), res.getShortDocoElement());
        }
        if (json.has("usage")) {
            JsonArray array = this.getJArray(json, "usage");
            for (int i = 0; i < array.size(); ++i) {
                res.getUsage().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("any")) {
            res.setAnyElement(this.parseBoolean(json.get("any").getAsBoolean()));
        }
        if (json.has("_any")) {
            this.parseElementProperties(this.getJObject(json, "_any"), res.getAnyElement());
        }
    }

    protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionMappingComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
        this.parseElementDefinitionMappingComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionMappingComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionMappingComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("identity")) {
            res.setIdentityElement(this.parseId(json.get("identity").getAsString()));
        }
        if (json.has("_identity")) {
            this.parseElementProperties(this.getJObject(json, "_identity"), res.getIdentityElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(this.getJObject(json, "_language"), res.getLanguageElement());
        }
        if (json.has("map")) {
            res.setMapElement(this.parseString(json.get("map").getAsString()));
        }
        if (json.has("_map")) {
            this.parseElementProperties(this.getJObject(json, "_map"), res.getMapElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseMarkdown(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
    }

    protected Expression parseExpression(JsonObject json) throws IOException, FHIRFormatError {
        Expression res = new Expression();
        this.parseExpressionProperties(json, res);
        return res;
    }

    protected void parseExpressionProperties(JsonObject json, Expression res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseCode(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(this.getJObject(json, "_language"), res.getLanguageElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(this.getJObject(json, "_expression"), res.getExpressionElement());
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseUri(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(this.getJObject(json, "_reference"), res.getReferenceElement());
        }
    }

    protected ExtendedContactDetail parseExtendedContactDetail(JsonObject json) throws IOException, FHIRFormatError {
        ExtendedContactDetail res = new ExtendedContactDetail();
        this.parseExtendedContactDetailProperties(json, res);
        return res;
    }

    protected void parseExtendedContactDetailProperties(JsonObject json, ExtendedContactDetail res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDataTypeProperties(json, res);
        if (json.has("purpose")) {
            res.setPurpose(this.parseCodeableConcept(this.getJObject(json, "purpose")));
        }
        if (json.has("name")) {
            array = this.getJArray(json, "name");
            for (i = 0; i < array.size(); ++i) {
                res.getName().add(this.parseHumanName(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("telecom")) {
            array = this.getJArray(json, "telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("address")) {
            res.setAddress(this.parseAddress(this.getJObject(json, "address")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(this.getJObject(json, "organization")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Extension parseExtension(JsonObject json) throws IOException, FHIRFormatError {
        Extension res = new Extension();
        this.parseExtensionProperties(json, res);
        return res;
    }

    protected void parseExtensionProperties(JsonObject json, Extension res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseDataTypeProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected HumanName parseHumanName(JsonObject json) throws IOException, FHIRFormatError {
        HumanName res = new HumanName();
        this.parseHumanNameProperties(json, res);
        return res;
    }

    protected void parseHumanNameProperties(JsonObject json, HumanName res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDataTypeProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("family")) {
            res.setFamilyElement(this.parseString(json.get("family").getAsString()));
        }
        if (json.has("_family")) {
            this.parseElementProperties(this.getJObject(json, "_family"), res.getFamilyElement());
        }
        if (json.has("given")) {
            array = this.getJArray(json, "given");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getGiven().add(new StringType());
                    continue;
                }
                res.getGiven().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_given")) {
            array = this.getJArray(json, "_given");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getGiven().size()) {
                    res.getGiven().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getGiven().get(i));
            }
        }
        if (json.has("prefix")) {
            array = this.getJArray(json, "prefix");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPrefix().add(new StringType());
                    continue;
                }
                res.getPrefix().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_prefix")) {
            array = this.getJArray(json, "_prefix");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPrefix().size()) {
                    res.getPrefix().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getPrefix().get(i));
            }
        }
        if (json.has("suffix")) {
            array = this.getJArray(json, "suffix");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSuffix().add(new StringType());
                    continue;
                }
                res.getSuffix().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_suffix")) {
            array = this.getJArray(json, "_suffix");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSuffix().size()) {
                    res.getSuffix().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getSuffix().get(i));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Identifier parseIdentifier(JsonObject json) throws IOException, FHIRFormatError {
        Identifier res = new Identifier();
        this.parseIdentifierProperties(json, res);
        return res;
    }

    protected void parseIdentifierProperties(JsonObject json, Identifier res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(this.getJObject(json, "_system"), res.getSystemElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("assigner")) {
            res.setAssigner(this.parseReference(this.getJObject(json, "assigner")));
        }
    }

    protected MarketingStatus parseMarketingStatus(JsonObject json) throws IOException, FHIRFormatError {
        MarketingStatus res = new MarketingStatus();
        this.parseMarketingStatusProperties(json, res);
        return res;
    }

    protected void parseMarketingStatusProperties(JsonObject json, MarketingStatus res) throws IOException, FHIRFormatError {
        this.parseBackboneTypeProperties(json, res);
        if (json.has("country")) {
            res.setCountry(this.parseCodeableConcept(this.getJObject(json, "country")));
        }
        if (json.has("jurisdiction")) {
            res.setJurisdiction(this.parseCodeableConcept(this.getJObject(json, "jurisdiction")));
        }
        if (json.has("status")) {
            res.setStatus(this.parseCodeableConcept(this.getJObject(json, "status")));
        }
        if (json.has("dateRange")) {
            res.setDateRange(this.parsePeriod(this.getJObject(json, "dateRange")));
        }
        if (json.has("restoreDate")) {
            res.setRestoreDateElement(this.parseDateTime(json.get("restoreDate").getAsString()));
        }
        if (json.has("_restoreDate")) {
            this.parseElementProperties(this.getJObject(json, "_restoreDate"), res.getRestoreDateElement());
        }
    }

    protected Meta parseMeta(JsonObject json) throws IOException, FHIRFormatError {
        Meta res = new Meta();
        this.parseMetaProperties(json, res);
        return res;
    }

    protected void parseMetaProperties(JsonObject json, Meta res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDataTypeProperties(json, res);
        if (json.has("versionId")) {
            res.setVersionIdElement(this.parseId(json.get("versionId").getAsString()));
        }
        if (json.has("_versionId")) {
            this.parseElementProperties(this.getJObject(json, "_versionId"), res.getVersionIdElement());
        }
        if (json.has("lastUpdated")) {
            res.setLastUpdatedElement(this.parseInstant(json.get("lastUpdated").getAsString()));
        }
        if (json.has("_lastUpdated")) {
            this.parseElementProperties(this.getJObject(json, "_lastUpdated"), res.getLastUpdatedElement());
        }
        if (json.has("source")) {
            res.setSourceElement(this.parseUri(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(this.getJObject(json, "_source"), res.getSourceElement());
        }
        if (json.has("profile")) {
            array = this.getJArray(json, "profile");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getProfile().add(new CanonicalType());
                    continue;
                }
                res.getProfile().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_profile")) {
            array = this.getJArray(json, "_profile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProfile().size()) {
                    res.getProfile().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getProfile().get(i));
            }
        }
        if (json.has("security")) {
            array = this.getJArray(json, "security");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurity().add(this.parseCoding(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("tag")) {
            array = this.getJArray(json, "tag");
            for (i = 0; i < array.size(); ++i) {
                res.getTag().add(this.parseCoding(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected MonetaryComponent parseMonetaryComponent(JsonObject json) throws IOException, FHIRFormatError {
        MonetaryComponent res = new MonetaryComponent();
        this.parseMonetaryComponentProperties(json, res);
        return res;
    }

    protected void parseMonetaryComponentProperties(JsonObject json, MonetaryComponent res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), MonetaryComponent.PriceComponentType.NULL, new MonetaryComponent.PriceComponentTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
    }

    protected Money parseMoney(JsonObject json) throws IOException, FHIRFormatError {
        Money res = new Money();
        this.parseMoneyProperties(json, res);
        return res;
    }

    protected void parseMoneyProperties(JsonObject json, Money res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("currency")) {
            res.setCurrencyElement(this.parseCode(json.get("currency").getAsString()));
        }
        if (json.has("_currency")) {
            this.parseElementProperties(this.getJObject(json, "_currency"), res.getCurrencyElement());
        }
    }

    protected Narrative parseNarrative(JsonObject json) throws IOException, FHIRFormatError {
        Narrative res = new Narrative();
        this.parseNarrativeProperties(json, res);
        return res;
    }

    protected void parseNarrativeProperties(JsonObject json, Narrative res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("div")) {
            res.setDiv(this.parseXhtml(json.get("div").getAsString()));
        }
    }

    protected ParameterDefinition parseParameterDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ParameterDefinition res = new ParameterDefinition();
        this.parseParameterDefinitionProperties(json, res);
        return res;
    }

    protected void parseParameterDefinitionProperties(JsonObject json, ParameterDefinition res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseCode(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Enumerations.OperationParameterUse.NULL, new Enumerations.OperationParameterUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(this.getJObject(json, "_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(this.getJObject(json, "_max"), res.getMaxElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.FHIRTypes.NULL, new Enumerations.FHIRTypesEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseCanonical(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(this.getJObject(json, "_profile"), res.getProfileElement());
        }
    }

    protected Period parsePeriod(JsonObject json) throws IOException, FHIRFormatError {
        Period res = new Period();
        this.parsePeriodProperties(json, res);
        return res;
    }

    protected void parsePeriodProperties(JsonObject json, Period res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("start")) {
            res.setStartElement(this.parseDateTime(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(this.getJObject(json, "_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseDateTime(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(this.getJObject(json, "_end"), res.getEndElement());
        }
    }

    protected ProductShelfLife parseProductShelfLife(JsonObject json) throws IOException, FHIRFormatError {
        ProductShelfLife res = new ProductShelfLife();
        this.parseProductShelfLifeProperties(json, res);
        return res;
    }

    protected void parseProductShelfLifeProperties(JsonObject json, ProductShelfLife res) throws IOException, FHIRFormatError {
        DataType period;
        this.parseBackboneTypeProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((period = this.parseType("period", json)) != null) {
            res.setPeriod(period);
        }
        if (json.has("specialPrecautionsForStorage")) {
            JsonArray array = this.getJArray(json, "specialPrecautionsForStorage");
            for (int i = 0; i < array.size(); ++i) {
                res.getSpecialPrecautionsForStorage().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Quantity parseQuantity(JsonObject json) throws IOException, FHIRFormatError {
        Quantity res = new Quantity();
        this.parseQuantityProperties(json, res);
        return res;
    }

    protected void parseQuantityProperties(JsonObject json, Quantity res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Enumerations.QuantityComparator.NULL, new Enumerations.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(this.getJObject(json, "_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(this.getJObject(json, "_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(this.getJObject(json, "_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
    }

    protected Range parseRange(JsonObject json) throws IOException, FHIRFormatError {
        Range res = new Range();
        this.parseRangeProperties(json, res);
        return res;
    }

    protected void parseRangeProperties(JsonObject json, Range res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("low")) {
            res.setLow(this.parseQuantity(this.getJObject(json, "low")));
        }
        if (json.has("high")) {
            res.setHigh(this.parseQuantity(this.getJObject(json, "high")));
        }
    }

    protected Ratio parseRatio(JsonObject json) throws IOException, FHIRFormatError {
        Ratio res = new Ratio();
        this.parseRatioProperties(json, res);
        return res;
    }

    protected void parseRatioProperties(JsonObject json, Ratio res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("numerator")) {
            res.setNumerator(this.parseQuantity(this.getJObject(json, "numerator")));
        }
        if (json.has("denominator")) {
            res.setDenominator(this.parseQuantity(this.getJObject(json, "denominator")));
        }
    }

    protected RatioRange parseRatioRange(JsonObject json) throws IOException, FHIRFormatError {
        RatioRange res = new RatioRange();
        this.parseRatioRangeProperties(json, res);
        return res;
    }

    protected void parseRatioRangeProperties(JsonObject json, RatioRange res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("lowNumerator")) {
            res.setLowNumerator(this.parseQuantity(this.getJObject(json, "lowNumerator")));
        }
        if (json.has("highNumerator")) {
            res.setHighNumerator(this.parseQuantity(this.getJObject(json, "highNumerator")));
        }
        if (json.has("denominator")) {
            res.setDenominator(this.parseQuantity(this.getJObject(json, "denominator")));
        }
    }

    protected Reference parseReference(JsonObject json) throws IOException, FHIRFormatError {
        Reference res = new Reference();
        this.parseReferenceProperties(json, res);
        return res;
    }

    protected void parseReferenceProperties(JsonObject json, Reference res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("reference")) {
            res.setReferenceElement(this.parseString(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(this.getJObject(json, "_reference"), res.getReferenceElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseUri(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
    }

    protected RelatedArtifact parseRelatedArtifact(JsonObject json) throws IOException, FHIRFormatError {
        RelatedArtifact res = new RelatedArtifact();
        this.parseRelatedArtifactProperties(json, res);
        return res;
    }

    protected void parseRelatedArtifactProperties(JsonObject json, RelatedArtifact res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("classifier")) {
            JsonArray array = this.getJArray(json, "classifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getClassifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(this.getJObject(json, "_label"), res.getLabelElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("citation")) {
            res.setCitationElement(this.parseMarkdown(json.get("citation").getAsString()));
        }
        if (json.has("_citation")) {
            this.parseElementProperties(this.getJObject(json, "_citation"), res.getCitationElement());
        }
        if (json.has("document")) {
            res.setDocument(this.parseAttachment(this.getJObject(json, "document")));
        }
        if (json.has("resource")) {
            res.setResourceElement(this.parseCanonical(json.get("resource").getAsString()));
        }
        if (json.has("_resource")) {
            this.parseElementProperties(this.getJObject(json, "_resource"), res.getResourceElement());
        }
        if (json.has("resourceReference")) {
            res.setResourceReference(this.parseReference(this.getJObject(json, "resourceReference")));
        }
        if (json.has("publicationStatus")) {
            res.setPublicationStatusElement(this.parseEnumeration(json.get("publicationStatus").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_publicationStatus")) {
            this.parseElementProperties(this.getJObject(json, "_publicationStatus"), res.getPublicationStatusElement());
        }
        if (json.has("publicationDate")) {
            res.setPublicationDateElement(this.parseDate(json.get("publicationDate").getAsString()));
        }
        if (json.has("_publicationDate")) {
            this.parseElementProperties(this.getJObject(json, "_publicationDate"), res.getPublicationDateElement());
        }
    }

    protected SampledData parseSampledData(JsonObject json) throws IOException, FHIRFormatError {
        SampledData res = new SampledData();
        this.parseSampledDataProperties(json, res);
        return res;
    }

    protected void parseSampledDataProperties(JsonObject json, SampledData res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("origin")) {
            res.setOrigin(this.parseQuantity(this.getJObject(json, "origin")));
        }
        if (json.has("interval")) {
            res.setIntervalElement(this.parseDecimal(json.get("interval").getAsBigDecimal()));
        }
        if (json.has("_interval")) {
            this.parseElementProperties(this.getJObject(json, "_interval"), res.getIntervalElement());
        }
        if (json.has("intervalUnit")) {
            res.setIntervalUnitElement(this.parseCode(json.get("intervalUnit").getAsString()));
        }
        if (json.has("_intervalUnit")) {
            this.parseElementProperties(this.getJObject(json, "_intervalUnit"), res.getIntervalUnitElement());
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("lowerLimit")) {
            res.setLowerLimitElement(this.parseDecimal(json.get("lowerLimit").getAsBigDecimal()));
        }
        if (json.has("_lowerLimit")) {
            this.parseElementProperties(this.getJObject(json, "_lowerLimit"), res.getLowerLimitElement());
        }
        if (json.has("upperLimit")) {
            res.setUpperLimitElement(this.parseDecimal(json.get("upperLimit").getAsBigDecimal()));
        }
        if (json.has("_upperLimit")) {
            this.parseElementProperties(this.getJObject(json, "_upperLimit"), res.getUpperLimitElement());
        }
        if (json.has("dimensions")) {
            res.setDimensionsElement(this.parsePositiveInt(json.get("dimensions").getAsString()));
        }
        if (json.has("_dimensions")) {
            this.parseElementProperties(this.getJObject(json, "_dimensions"), res.getDimensionsElement());
        }
        if (json.has("codeMap")) {
            res.setCodeMapElement(this.parseCanonical(json.get("codeMap").getAsString()));
        }
        if (json.has("_codeMap")) {
            this.parseElementProperties(this.getJObject(json, "_codeMap"), res.getCodeMapElement());
        }
        if (json.has("offsets")) {
            res.setOffsetsElement(this.parseString(json.get("offsets").getAsString()));
        }
        if (json.has("_offsets")) {
            this.parseElementProperties(this.getJObject(json, "_offsets"), res.getOffsetsElement());
        }
        if (json.has("data")) {
            res.setDataElement(this.parseString(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(this.getJObject(json, "_data"), res.getDataElement());
        }
    }

    protected Signature parseSignature(JsonObject json) throws IOException, FHIRFormatError {
        Signature res = new Signature();
        this.parseSignatureProperties(json, res);
        return res;
    }

    protected void parseSignatureProperties(JsonObject json, Signature res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("type")) {
            JsonArray array = this.getJArray(json, "type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCoding(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("when")) {
            res.setWhenElement(this.parseInstant(json.get("when").getAsString()));
        }
        if (json.has("_when")) {
            this.parseElementProperties(this.getJObject(json, "_when"), res.getWhenElement());
        }
        if (json.has("who")) {
            res.setWho(this.parseReference(this.getJObject(json, "who")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(this.getJObject(json, "onBehalfOf")));
        }
        if (json.has("targetFormat")) {
            res.setTargetFormatElement(this.parseCode(json.get("targetFormat").getAsString()));
        }
        if (json.has("_targetFormat")) {
            this.parseElementProperties(this.getJObject(json, "_targetFormat"), res.getTargetFormatElement());
        }
        if (json.has("sigFormat")) {
            res.setSigFormatElement(this.parseCode(json.get("sigFormat").getAsString()));
        }
        if (json.has("_sigFormat")) {
            this.parseElementProperties(this.getJObject(json, "_sigFormat"), res.getSigFormatElement());
        }
        if (json.has("data")) {
            res.setDataElement(this.parseBase64Binary(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(this.getJObject(json, "_data"), res.getDataElement());
        }
    }

    protected Timing parseTiming(JsonObject json) throws IOException, FHIRFormatError {
        Timing res = new Timing();
        this.parseTimingProperties(json, res);
        return res;
    }

    protected void parseTimingProperties(JsonObject json, Timing res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneTypeProperties(json, res);
        if (json.has("event")) {
            array = this.getJArray(json, "event");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getEvent().add(new DateTimeType());
                    continue;
                }
                res.getEvent().add(this.parseDateTime(array.get(i).getAsString()));
            }
        }
        if (json.has("_event")) {
            array = this.getJArray(json, "_event");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getEvent().size()) {
                    res.getEvent().add(this.parseDateTime(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getEvent().get(i));
            }
        }
        if (json.has("repeat")) {
            res.setRepeat(this.parseTimingRepeatComponent(this.getJObject(json, "repeat")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
    }

    protected Timing.TimingRepeatComponent parseTimingRepeatComponent(JsonObject json) throws IOException, FHIRFormatError {
        Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
        this.parseTimingRepeatComponentProperties(json, res);
        return res;
    }

    protected void parseTimingRepeatComponentProperties(JsonObject json, Timing.TimingRepeatComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseElementProperties(json, res);
        DataType bounds = this.parseType("bounds", json);
        if (bounds != null) {
            res.setBounds(bounds);
        }
        if (json.has("count")) {
            res.setCountElement(this.parsePositiveInt(json.get("count").getAsString()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(this.getJObject(json, "_count"), res.getCountElement());
        }
        if (json.has("countMax")) {
            res.setCountMaxElement(this.parsePositiveInt(json.get("countMax").getAsString()));
        }
        if (json.has("_countMax")) {
            this.parseElementProperties(this.getJObject(json, "_countMax"), res.getCountMaxElement());
        }
        if (json.has("duration")) {
            res.setDurationElement(this.parseDecimal(json.get("duration").getAsBigDecimal()));
        }
        if (json.has("_duration")) {
            this.parseElementProperties(this.getJObject(json, "_duration"), res.getDurationElement());
        }
        if (json.has("durationMax")) {
            res.setDurationMaxElement(this.parseDecimal(json.get("durationMax").getAsBigDecimal()));
        }
        if (json.has("_durationMax")) {
            this.parseElementProperties(this.getJObject(json, "_durationMax"), res.getDurationMaxElement());
        }
        if (json.has("durationUnit")) {
            res.setDurationUnitElement(this.parseEnumeration(json.get("durationUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        }
        if (json.has("_durationUnit")) {
            this.parseElementProperties(this.getJObject(json, "_durationUnit"), res.getDurationUnitElement());
        }
        if (json.has("frequency")) {
            res.setFrequencyElement(this.parsePositiveInt(json.get("frequency").getAsString()));
        }
        if (json.has("_frequency")) {
            this.parseElementProperties(this.getJObject(json, "_frequency"), res.getFrequencyElement());
        }
        if (json.has("frequencyMax")) {
            res.setFrequencyMaxElement(this.parsePositiveInt(json.get("frequencyMax").getAsString()));
        }
        if (json.has("_frequencyMax")) {
            this.parseElementProperties(this.getJObject(json, "_frequencyMax"), res.getFrequencyMaxElement());
        }
        if (json.has("period")) {
            res.setPeriodElement(this.parseDecimal(json.get("period").getAsBigDecimal()));
        }
        if (json.has("_period")) {
            this.parseElementProperties(this.getJObject(json, "_period"), res.getPeriodElement());
        }
        if (json.has("periodMax")) {
            res.setPeriodMaxElement(this.parseDecimal(json.get("periodMax").getAsBigDecimal()));
        }
        if (json.has("_periodMax")) {
            this.parseElementProperties(this.getJObject(json, "_periodMax"), res.getPeriodMaxElement());
        }
        if (json.has("periodUnit")) {
            res.setPeriodUnitElement(this.parseEnumeration(json.get("periodUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        }
        if (json.has("_periodUnit")) {
            this.parseElementProperties(this.getJObject(json, "_periodUnit"), res.getPeriodUnitElement());
        }
        if (json.has("dayOfWeek")) {
            array = this.getJArray(json, "dayOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getDayOfWeek().add(new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory(), Enumerations.DaysOfWeek.NULL));
                    continue;
                }
                res.getDayOfWeek().add(this.parseEnumeration(array.get(i).getAsString(), Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
            }
        }
        if (json.has("_dayOfWeek")) {
            array = this.getJArray(json, "_dayOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDayOfWeek().size()) {
                    res.getDayOfWeek().add(this.parseEnumeration(null, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getDayOfWeek().get(i));
            }
        }
        if (json.has("timeOfDay")) {
            array = this.getJArray(json, "timeOfDay");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getTimeOfDay().add(new TimeType());
                    continue;
                }
                res.getTimeOfDay().add(this.parseTime(array.get(i).getAsString()));
            }
        }
        if (json.has("_timeOfDay")) {
            array = this.getJArray(json, "_timeOfDay");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getTimeOfDay().size()) {
                    res.getTimeOfDay().add(this.parseTime(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getTimeOfDay().get(i));
            }
        }
        if (json.has("when")) {
            array = this.getJArray(json, "when");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getWhen().add(new Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory(), Timing.EventTiming.NULL));
                    continue;
                }
                res.getWhen().add(this.parseEnumeration(array.get(i).getAsString(), Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
            }
        }
        if (json.has("_when")) {
            array = this.getJArray(json, "_when");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getWhen().size()) {
                    res.getWhen().add(this.parseEnumeration(null, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getWhen().get(i));
            }
        }
        if (json.has("offset")) {
            res.setOffsetElement(this.parseUnsignedInt(json.get("offset").getAsString()));
        }
        if (json.has("_offset")) {
            this.parseElementProperties(this.getJObject(json, "_offset"), res.getOffsetElement());
        }
    }

    protected TriggerDefinition parseTriggerDefinition(JsonObject json) throws IOException, FHIRFormatError {
        TriggerDefinition res = new TriggerDefinition();
        this.parseTriggerDefinitionProperties(json, res);
        return res;
    }

    protected void parseTriggerDefinitionProperties(JsonObject json, TriggerDefinition res) throws IOException, FHIRFormatError {
        DataType timing;
        this.parseDataTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("subscriptionTopic")) {
            res.setSubscriptionTopicElement(this.parseCanonical(json.get("subscriptionTopic").getAsString()));
        }
        if (json.has("_subscriptionTopic")) {
            this.parseElementProperties(this.getJObject(json, "_subscriptionTopic"), res.getSubscriptionTopicElement());
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if (json.has("data")) {
            JsonArray array = this.getJArray(json, "data");
            for (int i = 0; i < array.size(); ++i) {
                res.getData().add(this.parseDataRequirement(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("condition")) {
            res.setCondition(this.parseExpression(this.getJObject(json, "condition")));
        }
    }

    protected UsageContext parseUsageContext(JsonObject json) throws IOException, FHIRFormatError {
        UsageContext res = new UsageContext();
        this.parseUsageContextProperties(json, res);
        return res;
    }

    protected void parseUsageContextProperties(JsonObject json, UsageContext res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseDataTypeProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(this.getJObject(json, "code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected VirtualServiceDetail parseVirtualServiceDetail(JsonObject json) throws IOException, FHIRFormatError {
        VirtualServiceDetail res = new VirtualServiceDetail();
        this.parseVirtualServiceDetailProperties(json, res);
        return res;
    }

    protected void parseVirtualServiceDetailProperties(JsonObject json, VirtualServiceDetail res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType address;
        this.parseDataTypeProperties(json, res);
        if (json.has("channelType")) {
            res.setChannelType(this.parseCoding(this.getJObject(json, "channelType")));
        }
        if ((address = this.parseType("address", json)) != null) {
            res.setAddress(address);
        }
        if (json.has("additionalInfo")) {
            array = this.getJArray(json, "additionalInfo");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getAdditionalInfo().add(new UrlType());
                    continue;
                }
                res.getAdditionalInfo().add(this.parseUrl(array.get(i).getAsString()));
            }
        }
        if (json.has("_additionalInfo")) {
            array = this.getJArray(json, "_additionalInfo");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getAdditionalInfo().size()) {
                    res.getAdditionalInfo().add(this.parseUrl(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getAdditionalInfo().get(i));
            }
        }
        if (json.has("maxParticipants")) {
            res.setMaxParticipantsElement(this.parsePositiveInt(json.get("maxParticipants").getAsString()));
        }
        if (json.has("_maxParticipants")) {
            this.parseElementProperties(this.getJObject(json, "_maxParticipants"), res.getMaxParticipantsElement());
        }
        if (json.has("sessionKey")) {
            res.setSessionKeyElement(this.parseString(json.get("sessionKey").getAsString()));
        }
        if (json.has("_sessionKey")) {
            this.parseElementProperties(this.getJObject(json, "_sessionKey"), res.getSessionKeyElement());
        }
    }

    protected void parseCanonicalResourceProperties(JsonObject json, CanonicalResource res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
    }

    protected void parseDomainResourceProperties(JsonObject json, DomainResource res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseResourceProperties(json, res);
        if (json.has("text")) {
            res.setText(this.parseNarrative(this.getJObject(json, "text")));
        }
        if (json.has("contained")) {
            array = this.getJArray(json, "contained");
            for (i = 0; i < array.size(); ++i) {
                res.getContained().add(this.parseResource(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("extension")) {
            array = this.getJArray(json, "extension");
            for (i = 0; i < array.size(); ++i) {
                res.getExtension().add(this.parseExtension(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("modifierExtension")) {
            array = this.getJArray(json, "modifierExtension");
            for (i = 0; i < array.size(); ++i) {
                res.getModifierExtension().add(this.parseExtension(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected void parseMetadataResourceProperties(JsonObject json, MetadataResource res) throws IOException, FHIRFormatError {
        this.parseCanonicalResourceProperties(json, res);
    }

    protected void parseResourceProperties(JsonObject json, Resource res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("id")) {
            res.setIdElement(this.parseId(json.get("id").getAsString()));
        }
        if (json.has("_id")) {
            this.parseElementProperties(this.getJObject(json, "_id"), res.getIdElement());
        }
        if (json.has("meta")) {
            res.setMeta(this.parseMeta(this.getJObject(json, "meta")));
        }
        if (json.has("implicitRules")) {
            res.setImplicitRulesElement(this.parseUri(json.get("implicitRules").getAsString()));
        }
        if (json.has("_implicitRules")) {
            this.parseElementProperties(this.getJObject(json, "_implicitRules"), res.getImplicitRulesElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(this.getJObject(json, "_language"), res.getLanguageElement());
        }
    }

    protected Account parseAccount(JsonObject json) throws IOException, FHIRFormatError {
        Account res = new Account();
        this.parseAccountProperties(json, res);
        return res;
    }

    protected void parseAccountProperties(JsonObject json, Account res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("billingStatus")) {
            res.setBillingStatus(this.parseCodeableConcept(this.getJObject(json, "billingStatus")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("subject")) {
            array = this.getJArray(json, "subject");
            for (i = 0; i < array.size(); ++i) {
                res.getSubject().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("servicePeriod")) {
            res.setServicePeriod(this.parsePeriod(this.getJObject(json, "servicePeriod")));
        }
        if (json.has("coverage")) {
            array = this.getJArray(json, "coverage");
            for (i = 0; i < array.size(); ++i) {
                res.getCoverage().add(this.parseAccountCoverageComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(this.getJObject(json, "owner")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("guarantor")) {
            array = this.getJArray(json, "guarantor");
            for (i = 0; i < array.size(); ++i) {
                res.getGuarantor().add(this.parseAccountGuarantorComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("diagnosis")) {
            array = this.getJArray(json, "diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseAccountDiagnosisComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("procedure")) {
            array = this.getJArray(json, "procedure");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedure().add(this.parseAccountProcedureComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("relatedAccount")) {
            array = this.getJArray(json, "relatedAccount");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedAccount().add(this.parseAccountRelatedAccountComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("currency")) {
            res.setCurrency(this.parseCodeableConcept(this.getJObject(json, "currency")));
        }
        if (json.has("balance")) {
            array = this.getJArray(json, "balance");
            for (i = 0; i < array.size(); ++i) {
                res.getBalance().add(this.parseAccountBalanceComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("calculatedAt")) {
            res.setCalculatedAtElement(this.parseInstant(json.get("calculatedAt").getAsString()));
        }
        if (json.has("_calculatedAt")) {
            this.parseElementProperties(this.getJObject(json, "_calculatedAt"), res.getCalculatedAtElement());
        }
    }

    protected Account.CoverageComponent parseAccountCoverageComponent(JsonObject json) throws IOException, FHIRFormatError {
        Account.CoverageComponent res = new Account.CoverageComponent();
        this.parseAccountCoverageComponentProperties(json, res);
        return res;
    }

    protected void parseAccountCoverageComponentProperties(JsonObject json, Account.CoverageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parsePositiveInt(json.get("priority").getAsString()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(this.getJObject(json, "_priority"), res.getPriorityElement());
        }
    }

    protected Account.GuarantorComponent parseAccountGuarantorComponent(JsonObject json) throws IOException, FHIRFormatError {
        Account.GuarantorComponent res = new Account.GuarantorComponent();
        this.parseAccountGuarantorComponentProperties(json, res);
        return res;
    }

    protected void parseAccountGuarantorComponentProperties(JsonObject json, Account.GuarantorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
        if (json.has("onHold")) {
            res.setOnHoldElement(this.parseBoolean(json.get("onHold").getAsBoolean()));
        }
        if (json.has("_onHold")) {
            this.parseElementProperties(this.getJObject(json, "_onHold"), res.getOnHoldElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Account.AccountDiagnosisComponent parseAccountDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
        Account.AccountDiagnosisComponent res = new Account.AccountDiagnosisComponent();
        this.parseAccountDiagnosisComponentProperties(json, res);
        return res;
    }

    protected void parseAccountDiagnosisComponentProperties(JsonObject json, Account.AccountDiagnosisComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("condition")) {
            res.setCondition(this.parseCodeableReference(this.getJObject(json, "condition")));
        }
        if (json.has("dateOfDiagnosis")) {
            res.setDateOfDiagnosisElement(this.parseDateTime(json.get("dateOfDiagnosis").getAsString()));
        }
        if (json.has("_dateOfDiagnosis")) {
            this.parseElementProperties(this.getJObject(json, "_dateOfDiagnosis"), res.getDateOfDiagnosisElement());
        }
        if (json.has("type")) {
            array = this.getJArray(json, "type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("onAdmission")) {
            res.setOnAdmissionElement(this.parseBoolean(json.get("onAdmission").getAsBoolean()));
        }
        if (json.has("_onAdmission")) {
            this.parseElementProperties(this.getJObject(json, "_onAdmission"), res.getOnAdmissionElement());
        }
        if (json.has("packageCode")) {
            array = this.getJArray(json, "packageCode");
            for (i = 0; i < array.size(); ++i) {
                res.getPackageCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Account.AccountProcedureComponent parseAccountProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
        Account.AccountProcedureComponent res = new Account.AccountProcedureComponent();
        this.parseAccountProcedureComponentProperties(json, res);
        return res;
    }

    protected void parseAccountProcedureComponentProperties(JsonObject json, Account.AccountProcedureComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableReference(this.getJObject(json, "code")));
        }
        if (json.has("dateOfService")) {
            res.setDateOfServiceElement(this.parseDateTime(json.get("dateOfService").getAsString()));
        }
        if (json.has("_dateOfService")) {
            this.parseElementProperties(this.getJObject(json, "_dateOfService"), res.getDateOfServiceElement());
        }
        if (json.has("type")) {
            array = this.getJArray(json, "type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("packageCode")) {
            array = this.getJArray(json, "packageCode");
            for (i = 0; i < array.size(); ++i) {
                res.getPackageCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("device")) {
            array = this.getJArray(json, "device");
            for (i = 0; i < array.size(); ++i) {
                res.getDevice().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Account.AccountRelatedAccountComponent parseAccountRelatedAccountComponent(JsonObject json) throws IOException, FHIRFormatError {
        Account.AccountRelatedAccountComponent res = new Account.AccountRelatedAccountComponent();
        this.parseAccountRelatedAccountComponentProperties(json, res);
        return res;
    }

    protected void parseAccountRelatedAccountComponentProperties(JsonObject json, Account.AccountRelatedAccountComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(this.getJObject(json, "relationship")));
        }
        if (json.has("account")) {
            res.setAccount(this.parseReference(this.getJObject(json, "account")));
        }
    }

    protected Account.AccountBalanceComponent parseAccountBalanceComponent(JsonObject json) throws IOException, FHIRFormatError {
        Account.AccountBalanceComponent res = new Account.AccountBalanceComponent();
        this.parseAccountBalanceComponentProperties(json, res);
        return res;
    }

    protected void parseAccountBalanceComponentProperties(JsonObject json, Account.AccountBalanceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("aggregate")) {
            res.setAggregate(this.parseCodeableConcept(this.getJObject(json, "aggregate")));
        }
        if (json.has("term")) {
            res.setTerm(this.parseCodeableConcept(this.getJObject(json, "term")));
        }
        if (json.has("estimate")) {
            res.setEstimateElement(this.parseBoolean(json.get("estimate").getAsBoolean()));
        }
        if (json.has("_estimate")) {
            this.parseElementProperties(this.getJObject(json, "_estimate"), res.getEstimateElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
    }

    protected ActivityDefinition parseActivityDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ActivityDefinition res = new ActivityDefinition();
        this.parseActivityDefinitionProperties(json, res);
        return res;
    }

    protected void parseActivityDefinitionProperties(JsonObject json, ActivityDefinition res) throws IOException, FHIRFormatError {
        int i;
        DataType product;
        DataType asNeeded;
        DataType timing;
        int i2;
        JsonArray array;
        DataType subject;
        DataType versionAlgorithm;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array2 = this.getJArray(json, "identifier");
            for (int i3 = 0; i3 < array2.size(); ++i3) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array2, i3)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("subtitle")) {
            res.setSubtitleElement(this.parseString(json.get("subtitle").getAsString()));
        }
        if (json.has("_subtitle")) {
            this.parseElementProperties(this.getJObject(json, "_subtitle"), res.getSubtitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if ((subject = this.parseType("subject", json)) != null) {
            res.setSubject(subject);
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = this.getJArray(json, "contact");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = this.getJArray(json, "useContext");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("jurisdiction")) {
            array = this.getJArray(json, "jurisdiction");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getJurisdiction().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("usage")) {
            res.setUsageElement(this.parseMarkdown(json.get("usage").getAsString()));
        }
        if (json.has("_usage")) {
            this.parseElementProperties(this.getJObject(json, "_usage"), res.getUsageElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(json.get("copyrightLabel").getAsString()));
        }
        if (json.has("_copyrightLabel")) {
            this.parseElementProperties(this.getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(this.getJObject(json, "effectivePeriod")));
        }
        if (json.has("topic")) {
            array = this.getJArray(json, "topic");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTopic().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("author")) {
            array = this.getJArray(json, "author");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAuthor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("editor")) {
            array = this.getJArray(json, "editor");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getEditor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("reviewer")) {
            array = this.getJArray(json, "reviewer");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getReviewer().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("endorser")) {
            array = this.getJArray(json, "endorser");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getEndorser().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("relatedArtifact")) {
            array = this.getJArray(json, "relatedArtifact");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("library")) {
            array = this.getJArray(json, "library");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getLibrary().add(new CanonicalType());
                    continue;
                }
                res.getLibrary().add(this.parseCanonical(array.get(i2).getAsString()));
            }
        }
        if (json.has("_library")) {
            array = this.getJArray(json, "_library");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getLibrary().size()) {
                    res.getLibrary().add(this.parseCanonical(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i2), res.getLibrary().get(i2));
            }
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), ActivityDefinition.RequestResourceTypes.NULL, new ActivityDefinition.RequestResourceTypesEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(this.getJObject(json, "_kind"), res.getKindElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseCanonical(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(this.getJObject(json, "_profile"), res.getProfileElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("intent")) {
            res.setIntentElement(this.parseEnumeration(json.get("intent").getAsString(), Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
        }
        if (json.has("_intent")) {
            this.parseElementProperties(this.getJObject(json, "_intent"), res.getIntentElement());
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(this.getJObject(json, "_priority"), res.getPriorityElement());
        }
        if (json.has("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(json.get("doNotPerform").getAsBoolean()));
        }
        if (json.has("_doNotPerform")) {
            this.parseElementProperties(this.getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if ((asNeeded = this.parseType("asNeeded", json)) != null) {
            res.setAsNeeded(asNeeded);
        }
        if (json.has("location")) {
            res.setLocation(this.parseCodeableReference(this.getJObject(json, "location")));
        }
        if (json.has("participant")) {
            JsonArray array3 = this.getJArray(json, "participant");
            for (int i4 = 0; i4 < array3.size(); ++i4) {
                res.getParticipant().add(this.parseActivityDefinitionParticipantComponent(this.getJsonObjectFromArray(array3, i4)));
            }
        }
        if ((product = this.parseType("product", json)) != null) {
            res.setProduct(product);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("dosage")) {
            JsonArray array4 = this.getJArray(json, "dosage");
            for (i = 0; i < array4.size(); ++i) {
                res.getDosage().add(this.parseDosage(this.getJsonObjectFromArray(array4, i)));
            }
        }
        if (json.has("bodySite")) {
            JsonArray array5 = this.getJArray(json, "bodySite");
            for (i = 0; i < array5.size(); ++i) {
                res.getBodySite().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array5, i)));
            }
        }
        if (json.has("specimenRequirement")) {
            JsonArray array6 = this.getJArray(json, "specimenRequirement");
            for (i = 0; i < array6.size(); ++i) {
                if (array6.get(i).isJsonNull()) {
                    res.getSpecimenRequirement().add(new CanonicalType());
                    continue;
                }
                res.getSpecimenRequirement().add(this.parseCanonical(array6.get(i).getAsString()));
            }
        }
        if (json.has("_specimenRequirement")) {
            JsonArray array7 = this.getJArray(json, "_specimenRequirement");
            for (i = 0; i < array7.size(); ++i) {
                if (i == res.getSpecimenRequirement().size()) {
                    res.getSpecimenRequirement().add(this.parseCanonical(null));
                }
                if (!(array7.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array7, i), res.getSpecimenRequirement().get(i));
            }
        }
        if (json.has("observationRequirement")) {
            JsonArray array8 = this.getJArray(json, "observationRequirement");
            for (i = 0; i < array8.size(); ++i) {
                if (array8.get(i).isJsonNull()) {
                    res.getObservationRequirement().add(new CanonicalType());
                    continue;
                }
                res.getObservationRequirement().add(this.parseCanonical(array8.get(i).getAsString()));
            }
        }
        if (json.has("_observationRequirement")) {
            JsonArray array9 = this.getJArray(json, "_observationRequirement");
            for (i = 0; i < array9.size(); ++i) {
                if (i == res.getObservationRequirement().size()) {
                    res.getObservationRequirement().add(this.parseCanonical(null));
                }
                if (!(array9.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array9, i), res.getObservationRequirement().get(i));
            }
        }
        if (json.has("observationResultRequirement")) {
            JsonArray array10 = this.getJArray(json, "observationResultRequirement");
            for (i = 0; i < array10.size(); ++i) {
                if (array10.get(i).isJsonNull()) {
                    res.getObservationResultRequirement().add(new CanonicalType());
                    continue;
                }
                res.getObservationResultRequirement().add(this.parseCanonical(array10.get(i).getAsString()));
            }
        }
        if (json.has("_observationResultRequirement")) {
            JsonArray array11 = this.getJArray(json, "_observationResultRequirement");
            for (i = 0; i < array11.size(); ++i) {
                if (i == res.getObservationResultRequirement().size()) {
                    res.getObservationResultRequirement().add(this.parseCanonical(null));
                }
                if (!(array11.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array11, i), res.getObservationResultRequirement().get(i));
            }
        }
        if (json.has("transform")) {
            res.setTransformElement(this.parseCanonical(json.get("transform").getAsString()));
        }
        if (json.has("_transform")) {
            this.parseElementProperties(this.getJObject(json, "_transform"), res.getTransformElement());
        }
        if (json.has("dynamicValue")) {
            JsonArray array12 = this.getJArray(json, "dynamicValue");
            for (i = 0; i < array12.size(); ++i) {
                res.getDynamicValue().add(this.parseActivityDefinitionDynamicValueComponent(this.getJsonObjectFromArray(array12, i)));
            }
        }
    }

    protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
        ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
        this.parseActivityDefinitionParticipantComponentProperties(json, res);
        return res;
    }

    protected void parseActivityDefinitionParticipantComponentProperties(JsonObject json, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.ActionParticipantType.NULL, new Enumerations.ActionParticipantTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("typeCanonical")) {
            res.setTypeCanonicalElement(this.parseCanonical(json.get("typeCanonical").getAsString()));
        }
        if (json.has("_typeCanonical")) {
            this.parseElementProperties(this.getJObject(json, "_typeCanonical"), res.getTypeCanonicalElement());
        }
        if (json.has("typeReference")) {
            res.setTypeReference(this.parseReference(this.getJObject(json, "typeReference")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("function")) {
            res.setFunction(this.parseCodeableConcept(this.getJObject(json, "function")));
        }
    }

    protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionDynamicValueComponent(JsonObject json) throws IOException, FHIRFormatError {
        ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
        this.parseActivityDefinitionDynamicValueComponentProperties(json, res);
        return res;
    }

    protected void parseActivityDefinitionDynamicValueComponentProperties(JsonObject json, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("expression")) {
            res.setExpression(this.parseExpression(this.getJObject(json, "expression")));
        }
    }

    protected ActorDefinition parseActorDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ActorDefinition res = new ActorDefinition();
        this.parseActorDefinitionProperties(json, res);
        return res;
    }

    protected void parseActorDefinitionProperties(JsonObject json, ActorDefinition res) throws IOException, FHIRFormatError {
        int i;
        DataType versionAlgorithm;
        this.parseCanonicalResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            JsonArray array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("jurisdiction")) {
            JsonArray array = this.getJArray(json, "jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(json.get("copyrightLabel").getAsString()));
        }
        if (json.has("_copyrightLabel")) {
            this.parseElementProperties(this.getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.ExampleScenarioActorType.NULL, new Enumerations.ExampleScenarioActorTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("reference")) {
            JsonArray array = this.getJArray(json, "reference");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getReference().add(new UrlType());
                    continue;
                }
                res.getReference().add(this.parseUrl(array.get(i).getAsString()));
            }
        }
        if (json.has("_reference")) {
            JsonArray array = this.getJArray(json, "_reference");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getReference().size()) {
                    res.getReference().add(this.parseUrl(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getReference().get(i));
            }
        }
        if (json.has("capabilities")) {
            res.setCapabilitiesElement(this.parseCanonical(json.get("capabilities").getAsString()));
        }
        if (json.has("_capabilities")) {
            this.parseElementProperties(this.getJObject(json, "_capabilities"), res.getCapabilitiesElement());
        }
        if (json.has("derivedFrom")) {
            JsonArray array = this.getJArray(json, "derivedFrom");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getDerivedFrom().add(new CanonicalType());
                    continue;
                }
                res.getDerivedFrom().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_derivedFrom")) {
            JsonArray array = this.getJArray(json, "_derivedFrom");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDerivedFrom().size()) {
                    res.getDerivedFrom().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getDerivedFrom().get(i));
            }
        }
    }

    protected AdministrableProductDefinition parseAdministrableProductDefinition(JsonObject json) throws IOException, FHIRFormatError {
        AdministrableProductDefinition res = new AdministrableProductDefinition();
        this.parseAdministrableProductDefinitionProperties(json, res);
        return res;
    }

    protected void parseAdministrableProductDefinitionProperties(JsonObject json, AdministrableProductDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("formOf")) {
            array = this.getJArray(json, "formOf");
            for (i = 0; i < array.size(); ++i) {
                res.getFormOf().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("administrableDoseForm")) {
            res.setAdministrableDoseForm(this.parseCodeableConcept(this.getJObject(json, "administrableDoseForm")));
        }
        if (json.has("unitOfPresentation")) {
            res.setUnitOfPresentation(this.parseCodeableConcept(this.getJObject(json, "unitOfPresentation")));
        }
        if (json.has("producedFrom")) {
            array = this.getJArray(json, "producedFrom");
            for (i = 0; i < array.size(); ++i) {
                res.getProducedFrom().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("ingredient")) {
            array = this.getJArray(json, "ingredient");
            for (i = 0; i < array.size(); ++i) {
                res.getIngredient().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(this.getJObject(json, "device")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("property")) {
            array = this.getJArray(json, "property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseAdministrableProductDefinitionPropertyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("routeOfAdministration")) {
            array = this.getJArray(json, "routeOfAdministration");
            for (i = 0; i < array.size(); ++i) {
                res.getRouteOfAdministration().add(this.parseAdministrableProductDefinitionRouteOfAdministrationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent parseAdministrableProductDefinitionPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent();
        this.parseAdministrableProductDefinitionPropertyComponentProperties(json, res);
        return res;
    }

    protected void parseAdministrableProductDefinitionPropertyComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("status")) {
            res.setStatus(this.parseCodeableConcept(this.getJObject(json, "status")));
        }
    }

    protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent parseAdministrableProductDefinitionRouteOfAdministrationComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent();
        this.parseAdministrableProductDefinitionRouteOfAdministrationComponentProperties(json, res);
        return res;
    }

    protected void parseAdministrableProductDefinitionRouteOfAdministrationComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("firstDose")) {
            res.setFirstDose(this.parseQuantity(this.getJObject(json, "firstDose")));
        }
        if (json.has("maxSingleDose")) {
            res.setMaxSingleDose(this.parseQuantity(this.getJObject(json, "maxSingleDose")));
        }
        if (json.has("maxDosePerDay")) {
            res.setMaxDosePerDay(this.parseQuantity(this.getJObject(json, "maxDosePerDay")));
        }
        if (json.has("maxDosePerTreatmentPeriod")) {
            res.setMaxDosePerTreatmentPeriod(this.parseRatio(this.getJObject(json, "maxDosePerTreatmentPeriod")));
        }
        if (json.has("maxTreatmentPeriod")) {
            res.setMaxTreatmentPeriod(this.parseDuration(this.getJObject(json, "maxTreatmentPeriod")));
        }
        if (json.has("targetSpecies")) {
            JsonArray array = this.getJArray(json, "targetSpecies");
            for (int i = 0; i < array.size(); ++i) {
                res.getTargetSpecies().add(this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent();
        this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentProperties(json, res);
        return res;
    }

    protected void parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("withdrawalPeriod")) {
            JsonArray array = this.getJArray(json, "withdrawalPeriod");
            for (int i = 0; i < array.size(); ++i) {
                res.getWithdrawalPeriod().add(this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
        this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentProperties(json, res);
        return res;
    }

    protected void parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("tissue")) {
            res.setTissue(this.parseCodeableConcept(this.getJObject(json, "tissue")));
        }
        if (json.has("value")) {
            res.setValue(this.parseQuantity(this.getJObject(json, "value")));
        }
        if (json.has("supportingInformation")) {
            res.setSupportingInformationElement(this.parseString(json.get("supportingInformation").getAsString()));
        }
        if (json.has("_supportingInformation")) {
            this.parseElementProperties(this.getJObject(json, "_supportingInformation"), res.getSupportingInformationElement());
        }
    }

    protected AdverseEvent parseAdverseEvent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent res = new AdverseEvent();
        this.parseAdverseEventProperties(json, res);
        return res;
    }

    protected void parseAdverseEventProperties(JsonObject json, AdverseEvent res) throws IOException, FHIRFormatError {
        int i;
        DataType occurrence;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), AdverseEvent.AdverseEventStatus.NULL, new AdverseEvent.AdverseEventStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("actuality")) {
            res.setActualityElement(this.parseEnumeration(json.get("actuality").getAsString(), AdverseEvent.AdverseEventActuality.NULL, new AdverseEvent.AdverseEventActualityEnumFactory()));
        }
        if (json.has("_actuality")) {
            this.parseElementProperties(this.getJObject(json, "_actuality"), res.getActualityElement());
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("detected")) {
            res.setDetectedElement(this.parseDateTime(json.get("detected").getAsString()));
        }
        if (json.has("_detected")) {
            this.parseElementProperties(this.getJObject(json, "_detected"), res.getDetectedElement());
        }
        if (json.has("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(json.get("recordedDate").getAsString()));
        }
        if (json.has("_recordedDate")) {
            this.parseElementProperties(this.getJObject(json, "_recordedDate"), res.getRecordedDateElement());
        }
        if (json.has("resultingEffect")) {
            JsonArray array2 = this.getJArray(json, "resultingEffect");
            for (i = 0; i < array2.size(); ++i) {
                res.getResultingEffect().add(this.parseReference(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("seriousness")) {
            res.setSeriousness(this.parseCodeableConcept(this.getJObject(json, "seriousness")));
        }
        if (json.has("outcome")) {
            JsonArray array3 = this.getJArray(json, "outcome");
            for (i = 0; i < array3.size(); ++i) {
                res.getOutcome().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array3, i)));
            }
        }
        if (json.has("recorder")) {
            res.setRecorder(this.parseReference(this.getJObject(json, "recorder")));
        }
        if (json.has("participant")) {
            JsonArray array4 = this.getJArray(json, "participant");
            for (i = 0; i < array4.size(); ++i) {
                res.getParticipant().add(this.parseAdverseEventParticipantComponent(this.getJsonObjectFromArray(array4, i)));
            }
        }
        if (json.has("study")) {
            JsonArray array5 = this.getJArray(json, "study");
            for (i = 0; i < array5.size(); ++i) {
                res.getStudy().add(this.parseReference(this.getJsonObjectFromArray(array5, i)));
            }
        }
        if (json.has("expectedInResearchStudy")) {
            res.setExpectedInResearchStudyElement(this.parseBoolean(json.get("expectedInResearchStudy").getAsBoolean()));
        }
        if (json.has("_expectedInResearchStudy")) {
            this.parseElementProperties(this.getJObject(json, "_expectedInResearchStudy"), res.getExpectedInResearchStudyElement());
        }
        if (json.has("suspectEntity")) {
            JsonArray array6 = this.getJArray(json, "suspectEntity");
            for (i = 0; i < array6.size(); ++i) {
                res.getSuspectEntity().add(this.parseAdverseEventSuspectEntityComponent(this.getJsonObjectFromArray(array6, i)));
            }
        }
        if (json.has("contributingFactor")) {
            JsonArray array7 = this.getJArray(json, "contributingFactor");
            for (i = 0; i < array7.size(); ++i) {
                res.getContributingFactor().add(this.parseAdverseEventContributingFactorComponent(this.getJsonObjectFromArray(array7, i)));
            }
        }
        if (json.has("preventiveAction")) {
            JsonArray array8 = this.getJArray(json, "preventiveAction");
            for (i = 0; i < array8.size(); ++i) {
                res.getPreventiveAction().add(this.parseAdverseEventPreventiveActionComponent(this.getJsonObjectFromArray(array8, i)));
            }
        }
        if (json.has("mitigatingAction")) {
            JsonArray array9 = this.getJArray(json, "mitigatingAction");
            for (i = 0; i < array9.size(); ++i) {
                res.getMitigatingAction().add(this.parseAdverseEventMitigatingActionComponent(this.getJsonObjectFromArray(array9, i)));
            }
        }
        if (json.has("supportingInfo")) {
            JsonArray array10 = this.getJArray(json, "supportingInfo");
            for (i = 0; i < array10.size(); ++i) {
                res.getSupportingInfo().add(this.parseAdverseEventSupportingInfoComponent(this.getJsonObjectFromArray(array10, i)));
            }
        }
        if (json.has("note")) {
            JsonArray array11 = this.getJArray(json, "note");
            for (i = 0; i < array11.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array11, i)));
            }
        }
    }

    protected AdverseEvent.AdverseEventParticipantComponent parseAdverseEventParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventParticipantComponent res = new AdverseEvent.AdverseEventParticipantComponent();
        this.parseAdverseEventParticipantComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventParticipantComponentProperties(JsonObject json, AdverseEvent.AdverseEventParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("function")) {
            res.setFunction(this.parseCodeableConcept(this.getJObject(json, "function")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
    }

    protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventSuspectEntityComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
        this.parseAdverseEventSuspectEntityComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventSuspectEntityComponentProperties(JsonObject json, AdverseEvent.AdverseEventSuspectEntityComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType instance = this.parseType("instance", json);
        if (instance != null) {
            res.setInstance(instance);
        }
        if (json.has("causality")) {
            res.setCausality(this.parseAdverseEventSuspectEntityCausalityComponent(this.getJObject(json, "causality")));
        }
    }

    protected AdverseEvent.AdverseEventSuspectEntityCausalityComponent parseAdverseEventSuspectEntityCausalityComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSuspectEntityCausalityComponent res = new AdverseEvent.AdverseEventSuspectEntityCausalityComponent();
        this.parseAdverseEventSuspectEntityCausalityComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventSuspectEntityCausalityComponentProperties(JsonObject json, AdverseEvent.AdverseEventSuspectEntityCausalityComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("assessmentMethod")) {
            res.setAssessmentMethod(this.parseCodeableConcept(this.getJObject(json, "assessmentMethod")));
        }
        if (json.has("entityRelatedness")) {
            res.setEntityRelatedness(this.parseCodeableConcept(this.getJObject(json, "entityRelatedness")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
    }

    protected AdverseEvent.AdverseEventContributingFactorComponent parseAdverseEventContributingFactorComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventContributingFactorComponent res = new AdverseEvent.AdverseEventContributingFactorComponent();
        this.parseAdverseEventContributingFactorComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventContributingFactorComponentProperties(JsonObject json, AdverseEvent.AdverseEventContributingFactorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
    }

    protected AdverseEvent.AdverseEventPreventiveActionComponent parseAdverseEventPreventiveActionComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventPreventiveActionComponent res = new AdverseEvent.AdverseEventPreventiveActionComponent();
        this.parseAdverseEventPreventiveActionComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventPreventiveActionComponentProperties(JsonObject json, AdverseEvent.AdverseEventPreventiveActionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
    }

    protected AdverseEvent.AdverseEventMitigatingActionComponent parseAdverseEventMitigatingActionComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventMitigatingActionComponent res = new AdverseEvent.AdverseEventMitigatingActionComponent();
        this.parseAdverseEventMitigatingActionComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventMitigatingActionComponentProperties(JsonObject json, AdverseEvent.AdverseEventMitigatingActionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
    }

    protected AdverseEvent.AdverseEventSupportingInfoComponent parseAdverseEventSupportingInfoComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSupportingInfoComponent res = new AdverseEvent.AdverseEventSupportingInfoComponent();
        this.parseAdverseEventSupportingInfoComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventSupportingInfoComponentProperties(JsonObject json, AdverseEvent.AdverseEventSupportingInfoComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
    }

    protected AllergyIntolerance parseAllergyIntolerance(JsonObject json) throws IOException, FHIRFormatError {
        AllergyIntolerance res = new AllergyIntolerance();
        this.parseAllergyIntoleranceProperties(json, res);
        return res;
    }

    protected void parseAllergyIntoleranceProperties(JsonObject json, AllergyIntolerance res) throws IOException, FHIRFormatError {
        int i;
        DataType onset;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("clinicalStatus")) {
            res.setClinicalStatus(this.parseCodeableConcept(this.getJObject(json, "clinicalStatus")));
        }
        if (json.has("verificationStatus")) {
            res.setVerificationStatus(this.parseCodeableConcept(this.getJObject(json, "verificationStatus")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getCategory().add(new Enumeration<AllergyIntolerance.AllergyIntoleranceCategory>(new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory(), AllergyIntolerance.AllergyIntoleranceCategory.NULL));
                    continue;
                }
                res.getCategory().add(this.parseEnumeration(array.get(i2).getAsString(), AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
            }
        }
        if (json.has("_category")) {
            array = this.getJArray(json, "_category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getCategory().size()) {
                    res.getCategory().add(this.parseEnumeration(null, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i2), res.getCategory().get(i2));
            }
        }
        if (json.has("criticality")) {
            res.setCriticalityElement(this.parseEnumeration(json.get("criticality").getAsString(), AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
        }
        if (json.has("_criticality")) {
            this.parseElementProperties(this.getJObject(json, "_criticality"), res.getCriticalityElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((onset = this.parseType("onset", json)) != null) {
            res.setOnset(onset);
        }
        if (json.has("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(json.get("recordedDate").getAsString()));
        }
        if (json.has("_recordedDate")) {
            this.parseElementProperties(this.getJObject(json, "_recordedDate"), res.getRecordedDateElement());
        }
        if (json.has("participant")) {
            JsonArray array2 = this.getJArray(json, "participant");
            for (i = 0; i < array2.size(); ++i) {
                res.getParticipant().add(this.parseAllergyIntoleranceParticipantComponent(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("lastOccurrence")) {
            res.setLastOccurrenceElement(this.parseDateTime(json.get("lastOccurrence").getAsString()));
        }
        if (json.has("_lastOccurrence")) {
            this.parseElementProperties(this.getJObject(json, "_lastOccurrence"), res.getLastOccurrenceElement());
        }
        if (json.has("note")) {
            JsonArray array3 = this.getJArray(json, "note");
            for (i = 0; i < array3.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array3, i)));
            }
        }
        if (json.has("reaction")) {
            JsonArray array4 = this.getJArray(json, "reaction");
            for (i = 0; i < array4.size(); ++i) {
                res.getReaction().add(this.parseAllergyIntoleranceReactionComponent(this.getJsonObjectFromArray(array4, i)));
            }
        }
    }

    protected AllergyIntolerance.AllergyIntoleranceParticipantComponent parseAllergyIntoleranceParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
        AllergyIntolerance.AllergyIntoleranceParticipantComponent res = new AllergyIntolerance.AllergyIntoleranceParticipantComponent();
        this.parseAllergyIntoleranceParticipantComponentProperties(json, res);
        return res;
    }

    protected void parseAllergyIntoleranceParticipantComponentProperties(JsonObject json, AllergyIntolerance.AllergyIntoleranceParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("function")) {
            res.setFunction(this.parseCodeableConcept(this.getJObject(json, "function")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
    }

    protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceReactionComponent(JsonObject json) throws IOException, FHIRFormatError {
        AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        this.parseAllergyIntoleranceReactionComponentProperties(json, res);
        return res;
    }

    protected void parseAllergyIntoleranceReactionComponentProperties(JsonObject json, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("substance")) {
            res.setSubstance(this.parseCodeableConcept(this.getJObject(json, "substance")));
        }
        if (json.has("manifestation")) {
            array = this.getJArray(json, "manifestation");
            for (i = 0; i < array.size(); ++i) {
                res.getManifestation().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("onset")) {
            res.setOnsetElement(this.parseDateTime(json.get("onset").getAsString()));
        }
        if (json.has("_onset")) {
            this.parseElementProperties(this.getJObject(json, "_onset"), res.getOnsetElement());
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(this.getJObject(json, "_severity"), res.getSeverityElement());
        }
        if (json.has("exposureRoute")) {
            res.setExposureRoute(this.parseCodeableConcept(this.getJObject(json, "exposureRoute")));
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Appointment parseAppointment(JsonObject json) throws IOException, FHIRFormatError {
        Appointment res = new Appointment();
        this.parseAppointmentProperties(json, res);
        return res;
    }

    protected void parseAppointmentProperties(JsonObject json, Appointment res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("cancellationReason")) {
            res.setCancellationReason(this.parseCodeableConcept(this.getJObject(json, "cancellationReason")));
        }
        if (json.has("class")) {
            array = this.getJArray(json, "class");
            for (i = 0; i < array.size(); ++i) {
                res.getClass_().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("serviceCategory")) {
            array = this.getJArray(json, "serviceCategory");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("serviceType")) {
            array = this.getJArray(json, "serviceType");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceType().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("specialty")) {
            array = this.getJArray(json, "specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("appointmentType")) {
            res.setAppointmentType(this.parseCodeableConcept(this.getJObject(json, "appointmentType")));
        }
        if (json.has("reason")) {
            array = this.getJArray(json, "reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(this.getJObject(json, "priority")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("replaces")) {
            array = this.getJArray(json, "replaces");
            for (i = 0; i < array.size(); ++i) {
                res.getReplaces().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("virtualService")) {
            array = this.getJArray(json, "virtualService");
            for (i = 0; i < array.size(); ++i) {
                res.getVirtualService().add(this.parseVirtualServiceDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("supportingInformation")) {
            array = this.getJArray(json, "supportingInformation");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("previousAppointment")) {
            res.setPreviousAppointment(this.parseReference(this.getJObject(json, "previousAppointment")));
        }
        if (json.has("originatingAppointment")) {
            res.setOriginatingAppointment(this.parseReference(this.getJObject(json, "originatingAppointment")));
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInstant(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(this.getJObject(json, "_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(this.getJObject(json, "_end"), res.getEndElement());
        }
        if (json.has("minutesDuration")) {
            res.setMinutesDurationElement(this.parsePositiveInt(json.get("minutesDuration").getAsString()));
        }
        if (json.has("_minutesDuration")) {
            this.parseElementProperties(this.getJObject(json, "_minutesDuration"), res.getMinutesDurationElement());
        }
        if (json.has("requestedPeriod")) {
            array = this.getJArray(json, "requestedPeriod");
            for (i = 0; i < array.size(); ++i) {
                res.getRequestedPeriod().add(this.parsePeriod(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("slot")) {
            array = this.getJArray(json, "slot");
            for (i = 0; i < array.size(); ++i) {
                res.getSlot().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("account")) {
            array = this.getJArray(json, "account");
            for (i = 0; i < array.size(); ++i) {
                res.getAccount().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("cancellationDate")) {
            res.setCancellationDateElement(this.parseDateTime(json.get("cancellationDate").getAsString()));
        }
        if (json.has("_cancellationDate")) {
            this.parseElementProperties(this.getJObject(json, "_cancellationDate"), res.getCancellationDateElement());
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("patientInstruction")) {
            array = this.getJArray(json, "patientInstruction");
            for (i = 0; i < array.size(); ++i) {
                res.getPatientInstruction().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("basedOn")) {
            array = this.getJArray(json, "basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("participant")) {
            array = this.getJArray(json, "participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseAppointmentParticipantComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("recurrenceId")) {
            res.setRecurrenceIdElement(this.parsePositiveInt(json.get("recurrenceId").getAsString()));
        }
        if (json.has("_recurrenceId")) {
            this.parseElementProperties(this.getJObject(json, "_recurrenceId"), res.getRecurrenceIdElement());
        }
        if (json.has("occurrenceChanged")) {
            res.setOccurrenceChangedElement(this.parseBoolean(json.get("occurrenceChanged").getAsBoolean()));
        }
        if (json.has("_occurrenceChanged")) {
            this.parseElementProperties(this.getJObject(json, "_occurrenceChanged"), res.getOccurrenceChangedElement());
        }
        if (json.has("recurrenceTemplate")) {
            array = this.getJArray(json, "recurrenceTemplate");
            for (i = 0; i < array.size(); ++i) {
                res.getRecurrenceTemplate().add(this.parseAppointmentRecurrenceTemplateComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Appointment.AppointmentParticipantComponent parseAppointmentParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
        Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
        this.parseAppointmentParticipantComponentProperties(json, res);
        return res;
    }

    protected void parseAppointmentParticipantComponentProperties(JsonObject json, Appointment.AppointmentParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            JsonArray array = this.getJArray(json, "type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
        if (json.has("required")) {
            res.setRequiredElement(this.parseBoolean(json.get("required").getAsBoolean()));
        }
        if (json.has("_required")) {
            this.parseElementProperties(this.getJObject(json, "_required"), res.getRequiredElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
    }

    protected Appointment.AppointmentRecurrenceTemplateComponent parseAppointmentRecurrenceTemplateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Appointment.AppointmentRecurrenceTemplateComponent res = new Appointment.AppointmentRecurrenceTemplateComponent();
        this.parseAppointmentRecurrenceTemplateComponentProperties(json, res);
        return res;
    }

    protected void parseAppointmentRecurrenceTemplateComponentProperties(JsonObject json, Appointment.AppointmentRecurrenceTemplateComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("timezone")) {
            res.setTimezone(this.parseCodeableConcept(this.getJObject(json, "timezone")));
        }
        if (json.has("recurrenceType")) {
            res.setRecurrenceType(this.parseCodeableConcept(this.getJObject(json, "recurrenceType")));
        }
        if (json.has("lastOccurrenceDate")) {
            res.setLastOccurrenceDateElement(this.parseDate(json.get("lastOccurrenceDate").getAsString()));
        }
        if (json.has("_lastOccurrenceDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastOccurrenceDate"), res.getLastOccurrenceDateElement());
        }
        if (json.has("occurrenceCount")) {
            res.setOccurrenceCountElement(this.parsePositiveInt(json.get("occurrenceCount").getAsString()));
        }
        if (json.has("_occurrenceCount")) {
            this.parseElementProperties(this.getJObject(json, "_occurrenceCount"), res.getOccurrenceCountElement());
        }
        if (json.has("occurrenceDate")) {
            array = this.getJArray(json, "occurrenceDate");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getOccurrenceDate().add(new DateType());
                    continue;
                }
                res.getOccurrenceDate().add(this.parseDate(array.get(i).getAsString()));
            }
        }
        if (json.has("_occurrenceDate")) {
            array = this.getJArray(json, "_occurrenceDate");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getOccurrenceDate().size()) {
                    res.getOccurrenceDate().add(this.parseDate(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getOccurrenceDate().get(i));
            }
        }
        if (json.has("weeklyTemplate")) {
            res.setWeeklyTemplate(this.parseAppointmentRecurrenceTemplateWeeklyTemplateComponent(this.getJObject(json, "weeklyTemplate")));
        }
        if (json.has("monthlyTemplate")) {
            res.setMonthlyTemplate(this.parseAppointmentRecurrenceTemplateMonthlyTemplateComponent(this.getJObject(json, "monthlyTemplate")));
        }
        if (json.has("yearlyTemplate")) {
            res.setYearlyTemplate(this.parseAppointmentRecurrenceTemplateYearlyTemplateComponent(this.getJObject(json, "yearlyTemplate")));
        }
        if (json.has("excludingDate")) {
            array = this.getJArray(json, "excludingDate");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getExcludingDate().add(new DateType());
                    continue;
                }
                res.getExcludingDate().add(this.parseDate(array.get(i).getAsString()));
            }
        }
        if (json.has("_excludingDate")) {
            array = this.getJArray(json, "_excludingDate");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getExcludingDate().size()) {
                    res.getExcludingDate().add(this.parseDate(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getExcludingDate().get(i));
            }
        }
        if (json.has("excludingRecurrenceId")) {
            array = this.getJArray(json, "excludingRecurrenceId");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getExcludingRecurrenceId().add(new PositiveIntType());
                    continue;
                }
                res.getExcludingRecurrenceId().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_excludingRecurrenceId")) {
            array = this.getJArray(json, "_excludingRecurrenceId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getExcludingRecurrenceId().size()) {
                    res.getExcludingRecurrenceId().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getExcludingRecurrenceId().get(i));
            }
        }
    }

    protected Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent parseAppointmentRecurrenceTemplateWeeklyTemplateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent res = new Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent();
        this.parseAppointmentRecurrenceTemplateWeeklyTemplateComponentProperties(json, res);
        return res;
    }

    protected void parseAppointmentRecurrenceTemplateWeeklyTemplateComponentProperties(JsonObject json, Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("monday")) {
            res.setMondayElement(this.parseBoolean(json.get("monday").getAsBoolean()));
        }
        if (json.has("_monday")) {
            this.parseElementProperties(this.getJObject(json, "_monday"), res.getMondayElement());
        }
        if (json.has("tuesday")) {
            res.setTuesdayElement(this.parseBoolean(json.get("tuesday").getAsBoolean()));
        }
        if (json.has("_tuesday")) {
            this.parseElementProperties(this.getJObject(json, "_tuesday"), res.getTuesdayElement());
        }
        if (json.has("wednesday")) {
            res.setWednesdayElement(this.parseBoolean(json.get("wednesday").getAsBoolean()));
        }
        if (json.has("_wednesday")) {
            this.parseElementProperties(this.getJObject(json, "_wednesday"), res.getWednesdayElement());
        }
        if (json.has("thursday")) {
            res.setThursdayElement(this.parseBoolean(json.get("thursday").getAsBoolean()));
        }
        if (json.has("_thursday")) {
            this.parseElementProperties(this.getJObject(json, "_thursday"), res.getThursdayElement());
        }
        if (json.has("friday")) {
            res.setFridayElement(this.parseBoolean(json.get("friday").getAsBoolean()));
        }
        if (json.has("_friday")) {
            this.parseElementProperties(this.getJObject(json, "_friday"), res.getFridayElement());
        }
        if (json.has("saturday")) {
            res.setSaturdayElement(this.parseBoolean(json.get("saturday").getAsBoolean()));
        }
        if (json.has("_saturday")) {
            this.parseElementProperties(this.getJObject(json, "_saturday"), res.getSaturdayElement());
        }
        if (json.has("sunday")) {
            res.setSundayElement(this.parseBoolean(json.get("sunday").getAsBoolean()));
        }
        if (json.has("_sunday")) {
            this.parseElementProperties(this.getJObject(json, "_sunday"), res.getSundayElement());
        }
        if (json.has("weekInterval")) {
            res.setWeekIntervalElement(this.parsePositiveInt(json.get("weekInterval").getAsString()));
        }
        if (json.has("_weekInterval")) {
            this.parseElementProperties(this.getJObject(json, "_weekInterval"), res.getWeekIntervalElement());
        }
    }

    protected Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent parseAppointmentRecurrenceTemplateMonthlyTemplateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent res = new Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent();
        this.parseAppointmentRecurrenceTemplateMonthlyTemplateComponentProperties(json, res);
        return res;
    }

    protected void parseAppointmentRecurrenceTemplateMonthlyTemplateComponentProperties(JsonObject json, Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("dayOfMonth")) {
            res.setDayOfMonthElement(this.parsePositiveInt(json.get("dayOfMonth").getAsString()));
        }
        if (json.has("_dayOfMonth")) {
            this.parseElementProperties(this.getJObject(json, "_dayOfMonth"), res.getDayOfMonthElement());
        }
        if (json.has("nthWeekOfMonth")) {
            res.setNthWeekOfMonth(this.parseCoding(this.getJObject(json, "nthWeekOfMonth")));
        }
        if (json.has("dayOfWeek")) {
            res.setDayOfWeek(this.parseCoding(this.getJObject(json, "dayOfWeek")));
        }
        if (json.has("monthInterval")) {
            res.setMonthIntervalElement(this.parsePositiveInt(json.get("monthInterval").getAsString()));
        }
        if (json.has("_monthInterval")) {
            this.parseElementProperties(this.getJObject(json, "_monthInterval"), res.getMonthIntervalElement());
        }
    }

    protected Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent parseAppointmentRecurrenceTemplateYearlyTemplateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent res = new Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent();
        this.parseAppointmentRecurrenceTemplateYearlyTemplateComponentProperties(json, res);
        return res;
    }

    protected void parseAppointmentRecurrenceTemplateYearlyTemplateComponentProperties(JsonObject json, Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("yearInterval")) {
            res.setYearIntervalElement(this.parsePositiveInt(json.get("yearInterval").getAsString()));
        }
        if (json.has("_yearInterval")) {
            this.parseElementProperties(this.getJObject(json, "_yearInterval"), res.getYearIntervalElement());
        }
    }

    protected AppointmentResponse parseAppointmentResponse(JsonObject json) throws IOException, FHIRFormatError {
        AppointmentResponse res = new AppointmentResponse();
        this.parseAppointmentResponseProperties(json, res);
        return res;
    }

    protected void parseAppointmentResponseProperties(JsonObject json, AppointmentResponse res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("appointment")) {
            res.setAppointment(this.parseReference(this.getJObject(json, "appointment")));
        }
        if (json.has("proposedNewTime")) {
            res.setProposedNewTimeElement(this.parseBoolean(json.get("proposedNewTime").getAsBoolean()));
        }
        if (json.has("_proposedNewTime")) {
            this.parseElementProperties(this.getJObject(json, "_proposedNewTime"), res.getProposedNewTimeElement());
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInstant(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(this.getJObject(json, "_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(this.getJObject(json, "_end"), res.getEndElement());
        }
        if (json.has("participantType")) {
            array = this.getJArray(json, "participantType");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipantType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
        if (json.has("participantStatus")) {
            res.setParticipantStatusElement(this.parseEnumeration(json.get("participantStatus").getAsString(), AppointmentResponse.AppointmentResponseStatus.NULL, new AppointmentResponse.AppointmentResponseStatusEnumFactory()));
        }
        if (json.has("_participantStatus")) {
            this.parseElementProperties(this.getJObject(json, "_participantStatus"), res.getParticipantStatusElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseMarkdown(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
        if (json.has("recurring")) {
            res.setRecurringElement(this.parseBoolean(json.get("recurring").getAsBoolean()));
        }
        if (json.has("_recurring")) {
            this.parseElementProperties(this.getJObject(json, "_recurring"), res.getRecurringElement());
        }
        if (json.has("occurrenceDate")) {
            res.setOccurrenceDateElement(this.parseDate(json.get("occurrenceDate").getAsString()));
        }
        if (json.has("_occurrenceDate")) {
            this.parseElementProperties(this.getJObject(json, "_occurrenceDate"), res.getOccurrenceDateElement());
        }
        if (json.has("recurrenceId")) {
            res.setRecurrenceIdElement(this.parsePositiveInt(json.get("recurrenceId").getAsString()));
        }
        if (json.has("_recurrenceId")) {
            this.parseElementProperties(this.getJObject(json, "_recurrenceId"), res.getRecurrenceIdElement());
        }
    }

    protected ArtifactAssessment parseArtifactAssessment(JsonObject json) throws IOException, FHIRFormatError {
        ArtifactAssessment res = new ArtifactAssessment();
        this.parseArtifactAssessmentProperties(json, res);
        return res;
    }

    protected void parseArtifactAssessmentProperties(JsonObject json, ArtifactAssessment res) throws IOException, FHIRFormatError {
        DataType artifact;
        DataType citeAs;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if ((citeAs = this.parseType("citeAs", json)) != null) {
            res.setCiteAs(citeAs);
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if ((artifact = this.parseType("artifact", json)) != null) {
            res.setArtifact(artifact);
        }
        if (json.has("content")) {
            JsonArray array = this.getJArray(json, "content");
            for (int i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseArtifactAssessmentContentComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("workflowStatus")) {
            res.setWorkflowStatusElement(this.parseEnumeration(json.get("workflowStatus").getAsString(), ArtifactAssessment.ArtifactAssessmentWorkflowStatus.NULL, new ArtifactAssessment.ArtifactAssessmentWorkflowStatusEnumFactory()));
        }
        if (json.has("_workflowStatus")) {
            this.parseElementProperties(this.getJObject(json, "_workflowStatus"), res.getWorkflowStatusElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseEnumeration(json.get("disposition").getAsString(), ArtifactAssessment.ArtifactAssessmentDisposition.NULL, new ArtifactAssessment.ArtifactAssessmentDispositionEnumFactory()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(this.getJObject(json, "_disposition"), res.getDispositionElement());
        }
    }

    protected ArtifactAssessment.ArtifactAssessmentContentComponent parseArtifactAssessmentContentComponent(JsonObject json) throws IOException, FHIRFormatError {
        ArtifactAssessment.ArtifactAssessmentContentComponent res = new ArtifactAssessment.ArtifactAssessmentContentComponent();
        this.parseArtifactAssessmentContentComponentProperties(json, res);
        return res;
    }

    protected void parseArtifactAssessmentContentComponentProperties(JsonObject json, ArtifactAssessment.ArtifactAssessmentContentComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("informationType")) {
            res.setInformationTypeElement(this.parseEnumeration(json.get("informationType").getAsString(), ArtifactAssessment.ArtifactAssessmentInformationType.NULL, new ArtifactAssessment.ArtifactAssessmentInformationTypeEnumFactory()));
        }
        if (json.has("_informationType")) {
            this.parseElementProperties(this.getJObject(json, "_informationType"), res.getInformationTypeElement());
        }
        if (json.has("summary")) {
            res.setSummaryElement(this.parseMarkdown(json.get("summary").getAsString()));
        }
        if (json.has("_summary")) {
            this.parseElementProperties(this.getJObject(json, "_summary"), res.getSummaryElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("classifier")) {
            array = this.getJArray(json, "classifier");
            for (i = 0; i < array.size(); ++i) {
                res.getClassifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
        if (json.has("path")) {
            array = this.getJArray(json, "path");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPath().add(new UriType());
                    continue;
                }
                res.getPath().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_path")) {
            array = this.getJArray(json, "_path");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPath().size()) {
                    res.getPath().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getPath().get(i));
            }
        }
        if (json.has("relatedArtifact")) {
            array = this.getJArray(json, "relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("freeToShare")) {
            res.setFreeToShareElement(this.parseBoolean(json.get("freeToShare").getAsBoolean()));
        }
        if (json.has("_freeToShare")) {
            this.parseElementProperties(this.getJObject(json, "_freeToShare"), res.getFreeToShareElement());
        }
        if (json.has("component")) {
            array = this.getJArray(json, "component");
            for (i = 0; i < array.size(); ++i) {
                res.getComponent().add(this.parseArtifactAssessmentContentComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected AuditEvent parseAuditEvent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent res = new AuditEvent();
        this.parseAuditEventProperties(json, res);
        return res;
    }

    protected void parseAuditEventProperties(JsonObject json, AuditEvent res) throws IOException, FHIRFormatError {
        int i;
        DataType occurred;
        this.parseDomainResourceProperties(json, res);
        if (json.has("category")) {
            JsonArray array = this.getJArray(json, "category");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("action")) {
            res.setActionElement(this.parseEnumeration(json.get("action").getAsString(), AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
        }
        if (json.has("_action")) {
            this.parseElementProperties(this.getJObject(json, "_action"), res.getActionElement());
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), AuditEvent.AuditEventSeverity.NULL, new AuditEvent.AuditEventSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(this.getJObject(json, "_severity"), res.getSeverityElement());
        }
        if ((occurred = this.parseType("occurred", json)) != null) {
            res.setOccurred(occurred);
        }
        if (json.has("recorded")) {
            res.setRecordedElement(this.parseInstant(json.get("recorded").getAsString()));
        }
        if (json.has("_recorded")) {
            this.parseElementProperties(this.getJObject(json, "_recorded"), res.getRecordedElement());
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseAuditEventOutcomeComponent(this.getJObject(json, "outcome")));
        }
        if (json.has("authorization")) {
            JsonArray array = this.getJArray(json, "authorization");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthorization().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("basedOn")) {
            JsonArray array = this.getJArray(json, "basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("agent")) {
            JsonArray array = this.getJArray(json, "agent");
            for (i = 0; i < array.size(); ++i) {
                res.getAgent().add(this.parseAuditEventAgentComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("source")) {
            res.setSource(this.parseAuditEventSourceComponent(this.getJObject(json, "source")));
        }
        if (json.has("entity")) {
            JsonArray array = this.getJArray(json, "entity");
            for (i = 0; i < array.size(); ++i) {
                res.getEntity().add(this.parseAuditEventEntityComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected AuditEvent.AuditEventOutcomeComponent parseAuditEventOutcomeComponent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventOutcomeComponent res = new AuditEvent.AuditEventOutcomeComponent();
        this.parseAuditEventOutcomeComponentProperties(json, res);
        return res;
    }

    protected void parseAuditEventOutcomeComponentProperties(JsonObject json, AuditEvent.AuditEventOutcomeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(this.getJObject(json, "code")));
        }
        if (json.has("detail")) {
            JsonArray array = this.getJArray(json, "detail");
            for (int i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected AuditEvent.AuditEventAgentComponent parseAuditEventAgentComponent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
        this.parseAuditEventAgentComponentProperties(json, res);
        return res;
    }

    protected void parseAuditEventAgentComponentProperties(JsonObject json, AuditEvent.AuditEventAgentComponent res) throws IOException, FHIRFormatError {
        DataType network;
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("role")) {
            array = this.getJArray(json, "role");
            for (i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("who")) {
            res.setWho(this.parseReference(this.getJObject(json, "who")));
        }
        if (json.has("requestor")) {
            res.setRequestorElement(this.parseBoolean(json.get("requestor").getAsBoolean()));
        }
        if (json.has("_requestor")) {
            this.parseElementProperties(this.getJObject(json, "_requestor"), res.getRequestorElement());
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("policy")) {
            array = this.getJArray(json, "policy");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPolicy().add(new UriType());
                    continue;
                }
                res.getPolicy().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_policy")) {
            array = this.getJArray(json, "_policy");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPolicy().size()) {
                    res.getPolicy().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getPolicy().get(i));
            }
        }
        if ((network = this.parseType("network", json)) != null) {
            res.setNetwork(network);
        }
        if (json.has("authorization")) {
            JsonArray array2 = this.getJArray(json, "authorization");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getAuthorization().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i2)));
            }
        }
    }

    protected AuditEvent.AuditEventSourceComponent parseAuditEventSourceComponent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
        this.parseAuditEventSourceComponentProperties(json, res);
        return res;
    }

    protected void parseAuditEventSourceComponentProperties(JsonObject json, AuditEvent.AuditEventSourceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("site")) {
            res.setSite(this.parseReference(this.getJObject(json, "site")));
        }
        if (json.has("observer")) {
            res.setObserver(this.parseReference(this.getJObject(json, "observer")));
        }
        if (json.has("type")) {
            JsonArray array = this.getJArray(json, "type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected AuditEvent.AuditEventEntityComponent parseAuditEventEntityComponent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
        this.parseAuditEventEntityComponentProperties(json, res);
        return res;
    }

    protected void parseAuditEventEntityComponentProperties(JsonObject json, AuditEvent.AuditEventEntityComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("what")) {
            res.setWhat(this.parseReference(this.getJObject(json, "what")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("securityLabel")) {
            array = this.getJArray(json, "securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("query")) {
            res.setQueryElement(this.parseBase64Binary(json.get("query").getAsString()));
        }
        if (json.has("_query")) {
            this.parseElementProperties(this.getJObject(json, "_query"), res.getQueryElement());
        }
        if (json.has("detail")) {
            array = this.getJArray(json, "detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseAuditEventEntityDetailComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("agent")) {
            array = this.getJArray(json, "agent");
            for (i = 0; i < array.size(); ++i) {
                res.getAgent().add(this.parseAuditEventAgentComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventEntityDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
        this.parseAuditEventEntityDetailComponentProperties(json, res);
        return res;
    }

    protected void parseAuditEventEntityDetailComponentProperties(JsonObject json, AuditEvent.AuditEventEntityDetailComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected Basic parseBasic(JsonObject json) throws IOException, FHIRFormatError {
        Basic res = new Basic();
        this.parseBasicProperties(json, res);
        return res;
    }

    protected void parseBasicProperties(JsonObject json, Basic res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
    }

    protected Binary parseBinary(JsonObject json) throws IOException, FHIRFormatError {
        Binary res = new Binary();
        this.parseBinaryProperties(json, res);
        return res;
    }

    protected void parseBinaryProperties(JsonObject json, Binary res) throws IOException, FHIRFormatError {
        this.parseResourceProperties(json, res);
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(this.getJObject(json, "_contentType"), res.getContentTypeElement());
        }
        if (json.has("securityContext")) {
            res.setSecurityContext(this.parseReference(this.getJObject(json, "securityContext")));
        }
        if (json.has("data")) {
            res.setDataElement(this.parseBase64Binary(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(this.getJObject(json, "_data"), res.getDataElement());
        }
    }

    protected BiologicallyDerivedProduct parseBiologicallyDerivedProduct(JsonObject json) throws IOException, FHIRFormatError {
        BiologicallyDerivedProduct res = new BiologicallyDerivedProduct();
        this.parseBiologicallyDerivedProductProperties(json, res);
        return res;
    }

    protected void parseBiologicallyDerivedProductProperties(JsonObject json, BiologicallyDerivedProduct res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("productCategory")) {
            res.setProductCategory(this.parseCoding(this.getJObject(json, "productCategory")));
        }
        if (json.has("productCode")) {
            res.setProductCode(this.parseCodeableConcept(this.getJObject(json, "productCode")));
        }
        if (json.has("parent")) {
            array = this.getJArray(json, "parent");
            for (i = 0; i < array.size(); ++i) {
                res.getParent().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("request")) {
            array = this.getJArray(json, "request");
            for (i = 0; i < array.size(); ++i) {
                res.getRequest().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("biologicalSourceEvent")) {
            res.setBiologicalSourceEvent(this.parseIdentifier(this.getJObject(json, "biologicalSourceEvent")));
        }
        if (json.has("processingFacility")) {
            array = this.getJArray(json, "processingFacility");
            for (i = 0; i < array.size(); ++i) {
                res.getProcessingFacility().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("division")) {
            res.setDivisionElement(this.parseString(json.get("division").getAsString()));
        }
        if (json.has("_division")) {
            this.parseElementProperties(this.getJObject(json, "_division"), res.getDivisionElement());
        }
        if (json.has("productStatus")) {
            res.setProductStatus(this.parseCoding(this.getJObject(json, "productStatus")));
        }
        if (json.has("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(json.get("expirationDate").getAsString()));
        }
        if (json.has("_expirationDate")) {
            this.parseElementProperties(this.getJObject(json, "_expirationDate"), res.getExpirationDateElement());
        }
        if (json.has("collection")) {
            res.setCollection(this.parseBiologicallyDerivedProductCollectionComponent(this.getJObject(json, "collection")));
        }
        if (json.has("storageTempRequirements")) {
            res.setStorageTempRequirements(this.parseRange(this.getJObject(json, "storageTempRequirements")));
        }
        if (json.has("property")) {
            array = this.getJArray(json, "property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseBiologicallyDerivedProductPropertyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent parseBiologicallyDerivedProductCollectionComponent(JsonObject json) throws IOException, FHIRFormatError {
        BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent();
        this.parseBiologicallyDerivedProductCollectionComponentProperties(json, res);
        return res;
    }

    protected void parseBiologicallyDerivedProductCollectionComponentProperties(JsonObject json, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res) throws IOException, FHIRFormatError {
        DataType collected;
        this.parseBackboneElementProperties(json, res);
        if (json.has("collector")) {
            res.setCollector(this.parseReference(this.getJObject(json, "collector")));
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(this.getJObject(json, "source")));
        }
        if ((collected = this.parseType("collected", json)) != null) {
            res.setCollected(collected);
        }
    }

    protected BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent parseBiologicallyDerivedProductPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent();
        this.parseBiologicallyDerivedProductPropertyComponentProperties(json, res);
        return res;
    }

    protected void parseBiologicallyDerivedProductPropertyComponentProperties(JsonObject json, BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected BiologicallyDerivedProductDispense parseBiologicallyDerivedProductDispense(JsonObject json) throws IOException, FHIRFormatError {
        BiologicallyDerivedProductDispense res = new BiologicallyDerivedProductDispense();
        this.parseBiologicallyDerivedProductDispenseProperties(json, res);
        return res;
    }

    protected void parseBiologicallyDerivedProductDispenseProperties(JsonObject json, BiologicallyDerivedProductDispense res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("basedOn")) {
            array = this.getJArray(json, "basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("partOf")) {
            array = this.getJArray(json, "partOf");
            for (i = 0; i < array.size(); ++i) {
                res.getPartOf().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), BiologicallyDerivedProductDispense.BiologicallyDerivedProductDispenseCodes.NULL, new BiologicallyDerivedProductDispense.BiologicallyDerivedProductDispenseCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("originRelationshipType")) {
            res.setOriginRelationshipType(this.parseCodeableConcept(this.getJObject(json, "originRelationshipType")));
        }
        if (json.has("product")) {
            res.setProduct(this.parseReference(this.getJObject(json, "product")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("matchStatus")) {
            res.setMatchStatus(this.parseCodeableConcept(this.getJObject(json, "matchStatus")));
        }
        if (json.has("performer")) {
            array = this.getJArray(json, "performer");
            for (i = 0; i < array.size(); ++i) {
                res.getPerformer().add(this.parseBiologicallyDerivedProductDispensePerformerComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("preparedDate")) {
            res.setPreparedDateElement(this.parseDateTime(json.get("preparedDate").getAsString()));
        }
        if (json.has("_preparedDate")) {
            this.parseElementProperties(this.getJObject(json, "_preparedDate"), res.getPreparedDateElement());
        }
        if (json.has("whenHandedOver")) {
            res.setWhenHandedOverElement(this.parseDateTime(json.get("whenHandedOver").getAsString()));
        }
        if (json.has("_whenHandedOver")) {
            this.parseElementProperties(this.getJObject(json, "_whenHandedOver"), res.getWhenHandedOverElement());
        }
        if (json.has("destination")) {
            res.setDestination(this.parseReference(this.getJObject(json, "destination")));
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("usageInstruction")) {
            res.setUsageInstructionElement(this.parseString(json.get("usageInstruction").getAsString()));
        }
        if (json.has("_usageInstruction")) {
            this.parseElementProperties(this.getJObject(json, "_usageInstruction"), res.getUsageInstructionElement());
        }
    }

    protected BiologicallyDerivedProductDispense.BiologicallyDerivedProductDispensePerformerComponent parseBiologicallyDerivedProductDispensePerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
        BiologicallyDerivedProductDispense.BiologicallyDerivedProductDispensePerformerComponent res = new BiologicallyDerivedProductDispense.BiologicallyDerivedProductDispensePerformerComponent();
        this.parseBiologicallyDerivedProductDispensePerformerComponentProperties(json, res);
        return res;
    }

    protected void parseBiologicallyDerivedProductDispensePerformerComponentProperties(JsonObject json, BiologicallyDerivedProductDispense.BiologicallyDerivedProductDispensePerformerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("function")) {
            res.setFunction(this.parseCodeableConcept(this.getJObject(json, "function")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
    }

    protected BodyStructure parseBodyStructure(JsonObject json) throws IOException, FHIRFormatError {
        BodyStructure res = new BodyStructure();
        this.parseBodyStructureProperties(json, res);
        return res;
    }

    protected void parseBodyStructureProperties(JsonObject json, BodyStructure res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(this.getJObject(json, "_active"), res.getActiveElement());
        }
        if (json.has("morphology")) {
            res.setMorphology(this.parseCodeableConcept(this.getJObject(json, "morphology")));
        }
        if (json.has("includedStructure")) {
            array = this.getJArray(json, "includedStructure");
            for (i = 0; i < array.size(); ++i) {
                res.getIncludedStructure().add(this.parseBodyStructureIncludedStructureComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("excludedStructure")) {
            array = this.getJArray(json, "excludedStructure");
            for (i = 0; i < array.size(); ++i) {
                res.getExcludedStructure().add(this.parseBodyStructureIncludedStructureComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("image")) {
            array = this.getJArray(json, "image");
            for (i = 0; i < array.size(); ++i) {
                res.getImage().add(this.parseAttachment(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
    }

    protected BodyStructure.BodyStructureIncludedStructureComponent parseBodyStructureIncludedStructureComponent(JsonObject json) throws IOException, FHIRFormatError {
        BodyStructure.BodyStructureIncludedStructureComponent res = new BodyStructure.BodyStructureIncludedStructureComponent();
        this.parseBodyStructureIncludedStructureComponentProperties(json, res);
        return res;
    }

    protected void parseBodyStructureIncludedStructureComponentProperties(JsonObject json, BodyStructure.BodyStructureIncludedStructureComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("structure")) {
            res.setStructure(this.parseCodeableConcept(this.getJObject(json, "structure")));
        }
        if (json.has("laterality")) {
            res.setLaterality(this.parseCodeableConcept(this.getJObject(json, "laterality")));
        }
        if (json.has("bodyLandmarkOrientation")) {
            array = this.getJArray(json, "bodyLandmarkOrientation");
            for (i = 0; i < array.size(); ++i) {
                res.getBodyLandmarkOrientation().add(this.parseBodyStructureIncludedStructureBodyLandmarkOrientationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("spatialReference")) {
            array = this.getJArray(json, "spatialReference");
            for (i = 0; i < array.size(); ++i) {
                res.getSpatialReference().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("qualifier")) {
            array = this.getJArray(json, "qualifier");
            for (i = 0; i < array.size(); ++i) {
                res.getQualifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationComponent parseBodyStructureIncludedStructureBodyLandmarkOrientationComponent(JsonObject json) throws IOException, FHIRFormatError {
        BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationComponent res = new BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationComponent();
        this.parseBodyStructureIncludedStructureBodyLandmarkOrientationComponentProperties(json, res);
        return res;
    }

    protected void parseBodyStructureIncludedStructureBodyLandmarkOrientationComponentProperties(JsonObject json, BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("landmarkDescription")) {
            array = this.getJArray(json, "landmarkDescription");
            for (i = 0; i < array.size(); ++i) {
                res.getLandmarkDescription().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("clockFacePosition")) {
            array = this.getJArray(json, "clockFacePosition");
            for (i = 0; i < array.size(); ++i) {
                res.getClockFacePosition().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("distanceFromLandmark")) {
            array = this.getJArray(json, "distanceFromLandmark");
            for (i = 0; i < array.size(); ++i) {
                res.getDistanceFromLandmark().add(this.parseBodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("surfaceOrientation")) {
            array = this.getJArray(json, "surfaceOrientation");
            for (i = 0; i < array.size(); ++i) {
                res.getSurfaceOrientation().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent parseBodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent(JsonObject json) throws IOException, FHIRFormatError {
        BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent res = new BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent();
        this.parseBodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponentProperties(json, res);
        return res;
    }

    protected void parseBodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponentProperties(JsonObject json, BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("device")) {
            array = this.getJArray(json, "device");
            for (i = 0; i < array.size(); ++i) {
                res.getDevice().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("value")) {
            array = this.getJArray(json, "value");
            for (i = 0; i < array.size(); ++i) {
                res.getValue().add(this.parseQuantity(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Bundle parseBundle(JsonObject json) throws IOException, FHIRFormatError {
        Bundle res = new Bundle();
        this.parseBundleProperties(json, res);
        return res;
    }

    protected void parseBundleProperties(JsonObject json, Bundle res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("timestamp")) {
            res.setTimestampElement(this.parseInstant(json.get("timestamp").getAsString()));
        }
        if (json.has("_timestamp")) {
            this.parseElementProperties(this.getJObject(json, "_timestamp"), res.getTimestampElement());
        }
        if (json.has("total")) {
            res.setTotalElement(this.parseUnsignedInt(json.get("total").getAsString()));
        }
        if (json.has("_total")) {
            this.parseElementProperties(this.getJObject(json, "_total"), res.getTotalElement());
        }
        if (json.has("link")) {
            array = this.getJArray(json, "link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseBundleLinkComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("entry")) {
            array = this.getJArray(json, "entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseBundleEntryComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("signature")) {
            res.setSignature(this.parseSignature(this.getJObject(json, "signature")));
        }
        if (json.has("issues")) {
            res.setIssues(this.parseResource(this.getJObject(json, "issues")));
        }
    }

    protected Bundle.BundleLinkComponent parseBundleLinkComponent(JsonObject json) throws IOException, FHIRFormatError {
        Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
        this.parseBundleLinkComponentProperties(json, res);
        return res;
    }

    protected void parseBundleLinkComponentProperties(JsonObject json, Bundle.BundleLinkComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("relation")) {
            res.setRelationElement(this.parseEnumeration(json.get("relation").getAsString(), Bundle.LinkRelationTypes.NULL, new Bundle.LinkRelationTypesEnumFactory()));
        }
        if (json.has("_relation")) {
            this.parseElementProperties(this.getJObject(json, "_relation"), res.getRelationElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
    }

    protected Bundle.BundleEntryComponent parseBundleEntryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
        this.parseBundleEntryComponentProperties(json, res);
        return res;
    }

    protected void parseBundleEntryComponentProperties(JsonObject json, Bundle.BundleEntryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("link")) {
            JsonArray array = this.getJArray(json, "link");
            for (int i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseBundleLinkComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("fullUrl")) {
            res.setFullUrlElement(this.parseUri(json.get("fullUrl").getAsString()));
        }
        if (json.has("_fullUrl")) {
            this.parseElementProperties(this.getJObject(json, "_fullUrl"), res.getFullUrlElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseResource(this.getJObject(json, "resource")));
        }
        if (json.has("search")) {
            res.setSearch(this.parseBundleEntrySearchComponent(this.getJObject(json, "search")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseBundleEntryRequestComponent(this.getJObject(json, "request")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseBundleEntryResponseComponent(this.getJObject(json, "response")));
        }
    }

    protected Bundle.BundleEntrySearchComponent parseBundleEntrySearchComponent(JsonObject json) throws IOException, FHIRFormatError {
        Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
        this.parseBundleEntrySearchComponentProperties(json, res);
        return res;
    }

    protected void parseBundleEntrySearchComponentProperties(JsonObject json, Bundle.BundleEntrySearchComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("score")) {
            res.setScoreElement(this.parseDecimal(json.get("score").getAsBigDecimal()));
        }
        if (json.has("_score")) {
            this.parseElementProperties(this.getJObject(json, "_score"), res.getScoreElement());
        }
    }

    protected Bundle.BundleEntryRequestComponent parseBundleEntryRequestComponent(JsonObject json) throws IOException, FHIRFormatError {
        Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
        this.parseBundleEntryRequestComponentProperties(json, res);
        return res;
    }

    protected void parseBundleEntryRequestComponentProperties(JsonObject json, Bundle.BundleEntryRequestComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("method")) {
            res.setMethodElement(this.parseEnumeration(json.get("method").getAsString(), Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
        }
        if (json.has("_method")) {
            this.parseElementProperties(this.getJObject(json, "_method"), res.getMethodElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("ifNoneMatch")) {
            res.setIfNoneMatchElement(this.parseString(json.get("ifNoneMatch").getAsString()));
        }
        if (json.has("_ifNoneMatch")) {
            this.parseElementProperties(this.getJObject(json, "_ifNoneMatch"), res.getIfNoneMatchElement());
        }
        if (json.has("ifModifiedSince")) {
            res.setIfModifiedSinceElement(this.parseInstant(json.get("ifModifiedSince").getAsString()));
        }
        if (json.has("_ifModifiedSince")) {
            this.parseElementProperties(this.getJObject(json, "_ifModifiedSince"), res.getIfModifiedSinceElement());
        }
        if (json.has("ifMatch")) {
            res.setIfMatchElement(this.parseString(json.get("ifMatch").getAsString()));
        }
        if (json.has("_ifMatch")) {
            this.parseElementProperties(this.getJObject(json, "_ifMatch"), res.getIfMatchElement());
        }
        if (json.has("ifNoneExist")) {
            res.setIfNoneExistElement(this.parseString(json.get("ifNoneExist").getAsString()));
        }
        if (json.has("_ifNoneExist")) {
            this.parseElementProperties(this.getJObject(json, "_ifNoneExist"), res.getIfNoneExistElement());
        }
    }

    protected Bundle.BundleEntryResponseComponent parseBundleEntryResponseComponent(JsonObject json) throws IOException, FHIRFormatError {
        Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
        this.parseBundleEntryResponseComponentProperties(json, res);
        return res;
    }

    protected void parseBundleEntryResponseComponentProperties(JsonObject json, Bundle.BundleEntryResponseComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseString(json.get("status").getAsString()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("location")) {
            res.setLocationElement(this.parseUri(json.get("location").getAsString()));
        }
        if (json.has("_location")) {
            this.parseElementProperties(this.getJObject(json, "_location"), res.getLocationElement());
        }
        if (json.has("etag")) {
            res.setEtagElement(this.parseString(json.get("etag").getAsString()));
        }
        if (json.has("_etag")) {
            this.parseElementProperties(this.getJObject(json, "_etag"), res.getEtagElement());
        }
        if (json.has("lastModified")) {
            res.setLastModifiedElement(this.parseInstant(json.get("lastModified").getAsString()));
        }
        if (json.has("_lastModified")) {
            this.parseElementProperties(this.getJObject(json, "_lastModified"), res.getLastModifiedElement());
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseResource(this.getJObject(json, "outcome")));
        }
    }

    protected CapabilityStatement parseCapabilityStatement(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement res = new CapabilityStatement();
        this.parseCapabilityStatementProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementProperties(JsonObject json, CapabilityStatement res) throws IOException, FHIRFormatError {
        int i;
        DataType versionAlgorithm;
        this.parseCanonicalResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            JsonArray array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("jurisdiction")) {
            JsonArray array = this.getJArray(json, "jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(json.get("copyrightLabel").getAsString()));
        }
        if (json.has("_copyrightLabel")) {
            this.parseElementProperties(this.getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), Enumerations.CapabilityStatementKind.NULL, new Enumerations.CapabilityStatementKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(this.getJObject(json, "_kind"), res.getKindElement());
        }
        if (json.has("instantiates")) {
            JsonArray array = this.getJArray(json, "instantiates");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiates().add(new CanonicalType());
                    continue;
                }
                res.getInstantiates().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiates")) {
            JsonArray array = this.getJArray(json, "_instantiates");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiates().size()) {
                    res.getInstantiates().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getInstantiates().get(i));
            }
        }
        if (json.has("imports")) {
            JsonArray array = this.getJArray(json, "imports");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getImports().add(new CanonicalType());
                    continue;
                }
                res.getImports().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_imports")) {
            JsonArray array = this.getJArray(json, "_imports");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getImports().size()) {
                    res.getImports().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getImports().get(i));
            }
        }
        if (json.has("software")) {
            res.setSoftware(this.parseCapabilityStatementSoftwareComponent(this.getJObject(json, "software")));
        }
        if (json.has("implementation")) {
            res.setImplementation(this.parseCapabilityStatementImplementationComponent(this.getJObject(json, "implementation")));
        }
        if (json.has("fhirVersion")) {
            res.setFhirVersionElement(this.parseEnumeration(json.get("fhirVersion").getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        }
        if (json.has("_fhirVersion")) {
            this.parseElementProperties(this.getJObject(json, "_fhirVersion"), res.getFhirVersionElement());
        }
        if (json.has("format")) {
            JsonArray array = this.getJArray(json, "format");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getFormat().add(new CodeType());
                    continue;
                }
                res.getFormat().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_format")) {
            JsonArray array = this.getJArray(json, "_format");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFormat().size()) {
                    res.getFormat().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getFormat().get(i));
            }
        }
        if (json.has("patchFormat")) {
            JsonArray array = this.getJArray(json, "patchFormat");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPatchFormat().add(new CodeType());
                    continue;
                }
                res.getPatchFormat().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_patchFormat")) {
            JsonArray array = this.getJArray(json, "_patchFormat");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPatchFormat().size()) {
                    res.getPatchFormat().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getPatchFormat().get(i));
            }
        }
        if (json.has("acceptLanguage")) {
            JsonArray array = this.getJArray(json, "acceptLanguage");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getAcceptLanguage().add(new CodeType());
                    continue;
                }
                res.getAcceptLanguage().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_acceptLanguage")) {
            JsonArray array = this.getJArray(json, "_acceptLanguage");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getAcceptLanguage().size()) {
                    res.getAcceptLanguage().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getAcceptLanguage().get(i));
            }
        }
        if (json.has("implementationGuide")) {
            JsonArray array = this.getJArray(json, "implementationGuide");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getImplementationGuide().add(new CanonicalType());
                    continue;
                }
                res.getImplementationGuide().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_implementationGuide")) {
            JsonArray array = this.getJArray(json, "_implementationGuide");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getImplementationGuide().size()) {
                    res.getImplementationGuide().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getImplementationGuide().get(i));
            }
        }
        if (json.has("rest")) {
            JsonArray array = this.getJArray(json, "rest");
            for (i = 0; i < array.size(); ++i) {
                res.getRest().add(this.parseCapabilityStatementRestComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("messaging")) {
            JsonArray array = this.getJArray(json, "messaging");
            for (i = 0; i < array.size(); ++i) {
                res.getMessaging().add(this.parseCapabilityStatementMessagingComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("document")) {
            JsonArray array = this.getJArray(json, "document");
            for (i = 0; i < array.size(); ++i) {
                res.getDocument().add(this.parseCapabilityStatementDocumentComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementSoftwareComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        this.parseCapabilityStatementSoftwareComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementSoftwareComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("releaseDate")) {
            res.setReleaseDateElement(this.parseDateTime(json.get("releaseDate").getAsString()));
        }
        if (json.has("_releaseDate")) {
            this.parseElementProperties(this.getJObject(json, "_releaseDate"), res.getReleaseDateElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementImplementationComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
        this.parseCapabilityStatementImplementationComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementImplementationComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementImplementationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUrl(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(this.getJObject(json, "custodian")));
        }
    }

    protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementRestComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
        this.parseCapabilityStatementRestComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementRestComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.RestfulCapabilityMode.NULL, new CapabilityStatement.RestfulCapabilityModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("security")) {
            res.setSecurity(this.parseCapabilityStatementRestSecurityComponent(this.getJObject(json, "security")));
        }
        if (json.has("resource")) {
            array = this.getJArray(json, "resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseCapabilityStatementRestResourceComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("interaction")) {
            array = this.getJArray(json, "interaction");
            for (i = 0; i < array.size(); ++i) {
                res.getInteraction().add(this.parseCapabilityStatementSystemInteractionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("searchParam")) {
            array = this.getJArray(json, "searchParam");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchParam().add(this.parseCapabilityStatementRestResourceSearchParamComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("operation")) {
            array = this.getJArray(json, "operation");
            for (i = 0; i < array.size(); ++i) {
                res.getOperation().add(this.parseCapabilityStatementRestResourceOperationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("compartment")) {
            array = this.getJArray(json, "compartment");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getCompartment().add(new CanonicalType());
                    continue;
                }
                res.getCompartment().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_compartment")) {
            array = this.getJArray(json, "_compartment");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCompartment().size()) {
                    res.getCompartment().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getCompartment().get(i));
            }
        }
    }

    protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementRestSecurityComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        this.parseCapabilityStatementRestSecurityComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementRestSecurityComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("cors")) {
            res.setCorsElement(this.parseBoolean(json.get("cors").getAsBoolean()));
        }
        if (json.has("_cors")) {
            this.parseElementProperties(this.getJObject(json, "_cors"), res.getCorsElement());
        }
        if (json.has("service")) {
            JsonArray array = this.getJArray(json, "service");
            for (int i = 0; i < array.size(); ++i) {
                res.getService().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementRestResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        this.parseCapabilityStatementRestResourceComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementRestResourceComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseCanonical(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(this.getJObject(json, "_profile"), res.getProfileElement());
        }
        if (json.has("supportedProfile")) {
            array = this.getJArray(json, "supportedProfile");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSupportedProfile().add(new CanonicalType());
                    continue;
                }
                res.getSupportedProfile().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_supportedProfile")) {
            array = this.getJArray(json, "_supportedProfile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSupportedProfile().size()) {
                    res.getSupportedProfile().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getSupportedProfile().get(i));
            }
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("interaction")) {
            array = this.getJArray(json, "interaction");
            for (i = 0; i < array.size(); ++i) {
                res.getInteraction().add(this.parseCapabilityStatementResourceInteractionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("versioning")) {
            res.setVersioningElement(this.parseEnumeration(json.get("versioning").getAsString(), CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
        }
        if (json.has("_versioning")) {
            this.parseElementProperties(this.getJObject(json, "_versioning"), res.getVersioningElement());
        }
        if (json.has("readHistory")) {
            res.setReadHistoryElement(this.parseBoolean(json.get("readHistory").getAsBoolean()));
        }
        if (json.has("_readHistory")) {
            this.parseElementProperties(this.getJObject(json, "_readHistory"), res.getReadHistoryElement());
        }
        if (json.has("updateCreate")) {
            res.setUpdateCreateElement(this.parseBoolean(json.get("updateCreate").getAsBoolean()));
        }
        if (json.has("_updateCreate")) {
            this.parseElementProperties(this.getJObject(json, "_updateCreate"), res.getUpdateCreateElement());
        }
        if (json.has("conditionalCreate")) {
            res.setConditionalCreateElement(this.parseBoolean(json.get("conditionalCreate").getAsBoolean()));
        }
        if (json.has("_conditionalCreate")) {
            this.parseElementProperties(this.getJObject(json, "_conditionalCreate"), res.getConditionalCreateElement());
        }
        if (json.has("conditionalRead")) {
            res.setConditionalReadElement(this.parseEnumeration(json.get("conditionalRead").getAsString(), CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
        }
        if (json.has("_conditionalRead")) {
            this.parseElementProperties(this.getJObject(json, "_conditionalRead"), res.getConditionalReadElement());
        }
        if (json.has("conditionalUpdate")) {
            res.setConditionalUpdateElement(this.parseBoolean(json.get("conditionalUpdate").getAsBoolean()));
        }
        if (json.has("_conditionalUpdate")) {
            this.parseElementProperties(this.getJObject(json, "_conditionalUpdate"), res.getConditionalUpdateElement());
        }
        if (json.has("conditionalPatch")) {
            res.setConditionalPatchElement(this.parseBoolean(json.get("conditionalPatch").getAsBoolean()));
        }
        if (json.has("_conditionalPatch")) {
            this.parseElementProperties(this.getJObject(json, "_conditionalPatch"), res.getConditionalPatchElement());
        }
        if (json.has("conditionalDelete")) {
            res.setConditionalDeleteElement(this.parseEnumeration(json.get("conditionalDelete").getAsString(), CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
        }
        if (json.has("_conditionalDelete")) {
            this.parseElementProperties(this.getJObject(json, "_conditionalDelete"), res.getConditionalDeleteElement());
        }
        if (json.has("referencePolicy")) {
            array = this.getJArray(json, "referencePolicy");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getReferencePolicy().add(new Enumeration<CapabilityStatement.ReferenceHandlingPolicy>(new CapabilityStatement.ReferenceHandlingPolicyEnumFactory(), CapabilityStatement.ReferenceHandlingPolicy.NULL));
                    continue;
                }
                res.getReferencePolicy().add(this.parseEnumeration(array.get(i).getAsString(), CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
            }
        }
        if (json.has("_referencePolicy")) {
            array = this.getJArray(json, "_referencePolicy");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getReferencePolicy().size()) {
                    res.getReferencePolicy().add(this.parseEnumeration(null, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getReferencePolicy().get(i));
            }
        }
        if (json.has("searchInclude")) {
            array = this.getJArray(json, "searchInclude");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSearchInclude().add(new StringType());
                    continue;
                }
                res.getSearchInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_searchInclude")) {
            array = this.getJArray(json, "_searchInclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSearchInclude().size()) {
                    res.getSearchInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getSearchInclude().get(i));
            }
        }
        if (json.has("searchRevInclude")) {
            array = this.getJArray(json, "searchRevInclude");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSearchRevInclude().add(new StringType());
                    continue;
                }
                res.getSearchRevInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_searchRevInclude")) {
            array = this.getJArray(json, "_searchRevInclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSearchRevInclude().size()) {
                    res.getSearchRevInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getSearchRevInclude().get(i));
            }
        }
        if (json.has("searchParam")) {
            array = this.getJArray(json, "searchParam");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchParam().add(this.parseCapabilityStatementRestResourceSearchParamComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("operation")) {
            array = this.getJArray(json, "operation");
            for (i = 0; i < array.size(); ++i) {
                res.getOperation().add(this.parseCapabilityStatementRestResourceOperationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
        this.parseCapabilityStatementResourceInteractionComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementResourceInteractionComponentProperties(JsonObject json, CapabilityStatement.ResourceInteractionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementRestResourceSearchParamComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        this.parseCapabilityStatementRestResourceSearchParamComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementRestResourceSearchParamComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseCanonical(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(this.getJObject(json, "_definition"), res.getDefinitionElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementRestResourceOperationComponent parseCapabilityStatementRestResourceOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent res = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
        this.parseCapabilityStatementRestResourceOperationComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementRestResourceOperationComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestResourceOperationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseCanonical(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(this.getJObject(json, "_definition"), res.getDefinitionElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
        this.parseCapabilityStatementSystemInteractionComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementSystemInteractionComponentProperties(JsonObject json, CapabilityStatement.SystemInteractionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementMessagingComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
        this.parseCapabilityStatementMessagingComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementMessagingComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementMessagingComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("endpoint")) {
            array = this.getJArray(json, "endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseCapabilityStatementMessagingEndpointComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("reliableCache")) {
            res.setReliableCacheElement(this.parseUnsignedInt(json.get("reliableCache").getAsString()));
        }
        if (json.has("_reliableCache")) {
            this.parseElementProperties(this.getJObject(json, "_reliableCache"), res.getReliableCacheElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("supportedMessage")) {
            array = this.getJArray(json, "supportedMessage");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportedMessage().add(this.parseCapabilityStatementMessagingSupportedMessageComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementMessagingEndpointComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        this.parseCapabilityStatementMessagingEndpointComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementMessagingEndpointComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("protocol")) {
            res.setProtocol(this.parseCoding(this.getJObject(json, "protocol")));
        }
        if (json.has("address")) {
            res.setAddressElement(this.parseUrl(json.get("address").getAsString()));
        }
        if (json.has("_address")) {
            this.parseElementProperties(this.getJObject(json, "_address"), res.getAddressElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementMessagingSupportedMessageComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
        this.parseCapabilityStatementMessagingSupportedMessageComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementMessagingSupportedMessageComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseCanonical(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(this.getJObject(json, "_definition"), res.getDefinitionElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementDocumentComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
        this.parseCapabilityStatementDocumentComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementDocumentComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementDocumentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseCanonical(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(this.getJObject(json, "_profile"), res.getProfileElement());
        }
    }

    protected CarePlan parseCarePlan(JsonObject json) throws IOException, FHIRFormatError {
        CarePlan res = new CarePlan();
        this.parseCarePlanProperties(json, res);
        return res;
    }

    protected void parseCarePlanProperties(JsonObject json, CarePlan res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("instantiatesCanonical")) {
            array = this.getJArray(json, "instantiatesCanonical");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiatesCanonical().add(new CanonicalType());
                    continue;
                }
                res.getInstantiatesCanonical().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiatesCanonical")) {
            array = this.getJArray(json, "_instantiatesCanonical");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiatesCanonical().size()) {
                    res.getInstantiatesCanonical().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getInstantiatesCanonical().get(i));
            }
        }
        if (json.has("instantiatesUri")) {
            array = this.getJArray(json, "instantiatesUri");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiatesUri().add(new UriType());
                    continue;
                }
                res.getInstantiatesUri().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiatesUri")) {
            array = this.getJArray(json, "_instantiatesUri");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiatesUri().size()) {
                    res.getInstantiatesUri().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getInstantiatesUri().get(i));
            }
        }
        if (json.has("basedOn")) {
            array = this.getJArray(json, "basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("replaces")) {
            array = this.getJArray(json, "replaces");
            for (i = 0; i < array.size(); ++i) {
                res.getReplaces().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("partOf")) {
            array = this.getJArray(json, "partOf");
            for (i = 0; i < array.size(); ++i) {
                res.getPartOf().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("intent")) {
            res.setIntentElement(this.parseEnumeration(json.get("intent").getAsString(), CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
        }
        if (json.has("_intent")) {
            this.parseElementProperties(this.getJObject(json, "_intent"), res.getIntentElement());
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(this.getJObject(json, "custodian")));
        }
        if (json.has("contributor")) {
            array = this.getJArray(json, "contributor");
            for (i = 0; i < array.size(); ++i) {
                res.getContributor().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("careTeam")) {
            array = this.getJArray(json, "careTeam");
            for (i = 0; i < array.size(); ++i) {
                res.getCareTeam().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("addresses")) {
            array = this.getJArray(json, "addresses");
            for (i = 0; i < array.size(); ++i) {
                res.getAddresses().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("supportingInfo")) {
            array = this.getJArray(json, "supportingInfo");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInfo().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("goal")) {
            array = this.getJArray(json, "goal");
            for (i = 0; i < array.size(); ++i) {
                res.getGoal().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("activity")) {
            array = this.getJArray(json, "activity");
            for (i = 0; i < array.size(); ++i) {
                res.getActivity().add(this.parseCarePlanActivityComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected CarePlan.CarePlanActivityComponent parseCarePlanActivityComponent(JsonObject json) throws IOException, FHIRFormatError {
        CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
        this.parseCarePlanActivityComponentProperties(json, res);
        return res;
    }

    protected void parseCarePlanActivityComponentProperties(JsonObject json, CarePlan.CarePlanActivityComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("performedActivity")) {
            array = this.getJArray(json, "performedActivity");
            for (i = 0; i < array.size(); ++i) {
                res.getPerformedActivity().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("progress")) {
            array = this.getJArray(json, "progress");
            for (i = 0; i < array.size(); ++i) {
                res.getProgress().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("plannedActivityReference")) {
            res.setPlannedActivityReference(this.parseReference(this.getJObject(json, "plannedActivityReference")));
        }
    }

    protected CareTeam parseCareTeam(JsonObject json) throws IOException, FHIRFormatError {
        CareTeam res = new CareTeam();
        this.parseCareTeamProperties(json, res);
        return res;
    }

    protected void parseCareTeamProperties(JsonObject json, CareTeam res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("participant")) {
            array = this.getJArray(json, "participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseCareTeamParticipantComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("reason")) {
            array = this.getJArray(json, "reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("managingOrganization")) {
            array = this.getJArray(json, "managingOrganization");
            for (i = 0; i < array.size(); ++i) {
                res.getManagingOrganization().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("telecom")) {
            array = this.getJArray(json, "telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected CareTeam.CareTeamParticipantComponent parseCareTeamParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
        CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
        this.parseCareTeamParticipantComponentProperties(json, res);
        return res;
    }

    protected void parseCareTeamParticipantComponentProperties(JsonObject json, CareTeam.CareTeamParticipantComponent res) throws IOException, FHIRFormatError {
        DataType coverage;
        this.parseBackboneElementProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("member")) {
            res.setMember(this.parseReference(this.getJObject(json, "member")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(this.getJObject(json, "onBehalfOf")));
        }
        if ((coverage = this.parseType("coverage", json)) != null) {
            res.setCoverage(coverage);
        }
    }

    protected ChargeItem parseChargeItem(JsonObject json) throws IOException, FHIRFormatError {
        ChargeItem res = new ChargeItem();
        this.parseChargeItemProperties(json, res);
        return res;
    }

    protected void parseChargeItemProperties(JsonObject json, ChargeItem res) throws IOException, FHIRFormatError {
        int i;
        DataType occurrence;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("definitionUri")) {
            array = this.getJArray(json, "definitionUri");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getDefinitionUri().add(new UriType());
                    continue;
                }
                res.getDefinitionUri().add(this.parseUri(array.get(i2).getAsString()));
            }
        }
        if (json.has("_definitionUri")) {
            array = this.getJArray(json, "_definitionUri");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getDefinitionUri().size()) {
                    res.getDefinitionUri().add(this.parseUri(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i2), res.getDefinitionUri().get(i2));
            }
        }
        if (json.has("definitionCanonical")) {
            array = this.getJArray(json, "definitionCanonical");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getDefinitionCanonical().add(new CanonicalType());
                    continue;
                }
                res.getDefinitionCanonical().add(this.parseCanonical(array.get(i2).getAsString()));
            }
        }
        if (json.has("_definitionCanonical")) {
            array = this.getJArray(json, "_definitionCanonical");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getDefinitionCanonical().size()) {
                    res.getDefinitionCanonical().add(this.parseCanonical(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i2), res.getDefinitionCanonical().get(i2));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("partOf")) {
            array = this.getJArray(json, "partOf");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getPartOf().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("performer")) {
            JsonArray array2 = this.getJArray(json, "performer");
            for (i = 0; i < array2.size(); ++i) {
                res.getPerformer().add(this.parseChargeItemPerformerComponent(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("performingOrganization")) {
            res.setPerformingOrganization(this.parseReference(this.getJObject(json, "performingOrganization")));
        }
        if (json.has("requestingOrganization")) {
            res.setRequestingOrganization(this.parseReference(this.getJObject(json, "requestingOrganization")));
        }
        if (json.has("costCenter")) {
            res.setCostCenter(this.parseReference(this.getJObject(json, "costCenter")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("bodysite")) {
            JsonArray array3 = this.getJArray(json, "bodysite");
            for (i = 0; i < array3.size(); ++i) {
                res.getBodysite().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array3, i)));
            }
        }
        if (json.has("unitPriceComponent")) {
            res.setUnitPriceComponent(this.parseMonetaryComponent(this.getJObject(json, "unitPriceComponent")));
        }
        if (json.has("totalPriceComponent")) {
            res.setTotalPriceComponent(this.parseMonetaryComponent(this.getJObject(json, "totalPriceComponent")));
        }
        if (json.has("overrideReason")) {
            res.setOverrideReason(this.parseCodeableConcept(this.getJObject(json, "overrideReason")));
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(this.getJObject(json, "enterer")));
        }
        if (json.has("enteredDate")) {
            res.setEnteredDateElement(this.parseDateTime(json.get("enteredDate").getAsString()));
        }
        if (json.has("_enteredDate")) {
            this.parseElementProperties(this.getJObject(json, "_enteredDate"), res.getEnteredDateElement());
        }
        if (json.has("reason")) {
            JsonArray array4 = this.getJArray(json, "reason");
            for (i = 0; i < array4.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array4, i)));
            }
        }
        if (json.has("service")) {
            JsonArray array5 = this.getJArray(json, "service");
            for (i = 0; i < array5.size(); ++i) {
                res.getService().add(this.parseCodeableReference(this.getJsonObjectFromArray(array5, i)));
            }
        }
        if (json.has("product")) {
            JsonArray array6 = this.getJArray(json, "product");
            for (i = 0; i < array6.size(); ++i) {
                res.getProduct().add(this.parseCodeableReference(this.getJsonObjectFromArray(array6, i)));
            }
        }
        if (json.has("account")) {
            JsonArray array7 = this.getJArray(json, "account");
            for (i = 0; i < array7.size(); ++i) {
                res.getAccount().add(this.parseReference(this.getJsonObjectFromArray(array7, i)));
            }
        }
        if (json.has("note")) {
            JsonArray array8 = this.getJArray(json, "note");
            for (i = 0; i < array8.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array8, i)));
            }
        }
        if (json.has("supportingInformation")) {
            JsonArray array9 = this.getJArray(json, "supportingInformation");
            for (i = 0; i < array9.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(this.getJsonObjectFromArray(array9, i)));
            }
        }
    }

    protected ChargeItem.ChargeItemPerformerComponent parseChargeItemPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
        ChargeItem.ChargeItemPerformerComponent res = new ChargeItem.ChargeItemPerformerComponent();
        this.parseChargeItemPerformerComponentProperties(json, res);
        return res;
    }

    protected void parseChargeItemPerformerComponentProperties(JsonObject json, ChargeItem.ChargeItemPerformerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("function")) {
            res.setFunction(this.parseCodeableConcept(this.getJObject(json, "function")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
    }

    protected ChargeItemDefinition parseChargeItemDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ChargeItemDefinition res = new ChargeItemDefinition();
        this.parseChargeItemDefinitionProperties(json, res);
        return res;
    }

    protected void parseChargeItemDefinitionProperties(JsonObject json, ChargeItemDefinition res) throws IOException, FHIRFormatError {
        int i;
        DataType versionAlgorithm;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("derivedFromUri")) {
            JsonArray array = this.getJArray(json, "derivedFromUri");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getDerivedFromUri().add(new UriType());
                    continue;
                }
                res.getDerivedFromUri().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_derivedFromUri")) {
            JsonArray array = this.getJArray(json, "_derivedFromUri");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDerivedFromUri().size()) {
                    res.getDerivedFromUri().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getDerivedFromUri().get(i));
            }
        }
        if (json.has("partOf")) {
            JsonArray array = this.getJArray(json, "partOf");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPartOf().add(new CanonicalType());
                    continue;
                }
                res.getPartOf().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_partOf")) {
            JsonArray array = this.getJArray(json, "_partOf");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPartOf().size()) {
                    res.getPartOf().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getPartOf().get(i));
            }
        }
        if (json.has("replaces")) {
            JsonArray array = this.getJArray(json, "replaces");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getReplaces().add(new CanonicalType());
                    continue;
                }
                res.getReplaces().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_replaces")) {
            JsonArray array = this.getJArray(json, "_replaces");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getReplaces().size()) {
                    res.getReplaces().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getReplaces().get(i));
            }
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            JsonArray array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("jurisdiction")) {
            JsonArray array = this.getJArray(json, "jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(json.get("copyrightLabel").getAsString()));
        }
        if (json.has("_copyrightLabel")) {
            this.parseElementProperties(this.getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("instance")) {
            JsonArray array = this.getJArray(json, "instance");
            for (i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("applicability")) {
            JsonArray array = this.getJArray(json, "applicability");
            for (i = 0; i < array.size(); ++i) {
                res.getApplicability().add(this.parseChargeItemDefinitionApplicabilityComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("propertyGroup")) {
            JsonArray array = this.getJArray(json, "propertyGroup");
            for (i = 0; i < array.size(); ++i) {
                res.getPropertyGroup().add(this.parseChargeItemDefinitionPropertyGroupComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent parseChargeItemDefinitionApplicabilityComponent(JsonObject json) throws IOException, FHIRFormatError {
        ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res = new ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent();
        this.parseChargeItemDefinitionApplicabilityComponentProperties(json, res);
        return res;
    }

    protected void parseChargeItemDefinitionApplicabilityComponentProperties(JsonObject json, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("condition")) {
            res.setCondition(this.parseExpression(this.getJObject(json, "condition")));
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(this.getJObject(json, "effectivePeriod")));
        }
        if (json.has("relatedArtifact")) {
            res.setRelatedArtifact(this.parseRelatedArtifact(this.getJObject(json, "relatedArtifact")));
        }
    }

    protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent parseChargeItemDefinitionPropertyGroupComponent(JsonObject json) throws IOException, FHIRFormatError {
        ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent();
        this.parseChargeItemDefinitionPropertyGroupComponentProperties(json, res);
        return res;
    }

    protected void parseChargeItemDefinitionPropertyGroupComponentProperties(JsonObject json, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("applicability")) {
            array = this.getJArray(json, "applicability");
            for (i = 0; i < array.size(); ++i) {
                res.getApplicability().add(this.parseChargeItemDefinitionApplicabilityComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("priceComponent")) {
            array = this.getJArray(json, "priceComponent");
            for (i = 0; i < array.size(); ++i) {
                res.getPriceComponent().add(this.parseMonetaryComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Citation parseCitation(JsonObject json) throws IOException, FHIRFormatError {
        Citation res = new Citation();
        this.parseCitationProperties(json, res);
        return res;
    }

    protected void parseCitationProperties(JsonObject json, Citation res) throws IOException, FHIRFormatError {
        int i;
        DataType versionAlgorithm;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            JsonArray array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("jurisdiction")) {
            JsonArray array = this.getJArray(json, "jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(json.get("copyrightLabel").getAsString()));
        }
        if (json.has("_copyrightLabel")) {
            this.parseElementProperties(this.getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(this.getJObject(json, "effectivePeriod")));
        }
        if (json.has("author")) {
            JsonArray array = this.getJArray(json, "author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("editor")) {
            JsonArray array = this.getJArray(json, "editor");
            for (i = 0; i < array.size(); ++i) {
                res.getEditor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("reviewer")) {
            JsonArray array = this.getJArray(json, "reviewer");
            for (i = 0; i < array.size(); ++i) {
                res.getReviewer().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("endorser")) {
            JsonArray array = this.getJArray(json, "endorser");
            for (i = 0; i < array.size(); ++i) {
                res.getEndorser().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("summary")) {
            JsonArray array = this.getJArray(json, "summary");
            for (i = 0; i < array.size(); ++i) {
                res.getSummary().add(this.parseCitationSummaryComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("classification")) {
            JsonArray array = this.getJArray(json, "classification");
            for (i = 0; i < array.size(); ++i) {
                res.getClassification().add(this.parseCitationClassificationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("note")) {
            JsonArray array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("currentState")) {
            JsonArray array = this.getJArray(json, "currentState");
            for (i = 0; i < array.size(); ++i) {
                res.getCurrentState().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("statusDate")) {
            JsonArray array = this.getJArray(json, "statusDate");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusDate().add(this.parseCitationStatusDateComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("relatedArtifact")) {
            JsonArray array = this.getJArray(json, "relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("citedArtifact")) {
            res.setCitedArtifact(this.parseCitationCitedArtifactComponent(this.getJObject(json, "citedArtifact")));
        }
    }

    protected Citation.CitationSummaryComponent parseCitationSummaryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationSummaryComponent res = new Citation.CitationSummaryComponent();
        this.parseCitationSummaryComponentProperties(json, res);
        return res;
    }

    protected void parseCitationSummaryComponentProperties(JsonObject json, Citation.CitationSummaryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("style")) {
            res.setStyle(this.parseCodeableConcept(this.getJObject(json, "style")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseMarkdown(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
    }

    protected Citation.CitationClassificationComponent parseCitationClassificationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationClassificationComponent res = new Citation.CitationClassificationComponent();
        this.parseCitationClassificationComponentProperties(json, res);
        return res;
    }

    protected void parseCitationClassificationComponentProperties(JsonObject json, Citation.CitationClassificationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("classifier")) {
            JsonArray array = this.getJArray(json, "classifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getClassifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Citation.CitationStatusDateComponent parseCitationStatusDateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationStatusDateComponent res = new Citation.CitationStatusDateComponent();
        this.parseCitationStatusDateComponentProperties(json, res);
        return res;
    }

    protected void parseCitationStatusDateComponentProperties(JsonObject json, Citation.CitationStatusDateComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("activity")) {
            res.setActivity(this.parseCodeableConcept(this.getJObject(json, "activity")));
        }
        if (json.has("actual")) {
            res.setActualElement(this.parseBoolean(json.get("actual").getAsBoolean()));
        }
        if (json.has("_actual")) {
            this.parseElementProperties(this.getJObject(json, "_actual"), res.getActualElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Citation.CitationCitedArtifactComponent parseCitationCitedArtifactComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactComponent res = new Citation.CitationCitedArtifactComponent();
        this.parseCitationCitedArtifactComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactComponentProperties(JsonObject json, Citation.CitationCitedArtifactComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("relatedIdentifier")) {
            array = this.getJArray(json, "relatedIdentifier");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("dateAccessed")) {
            res.setDateAccessedElement(this.parseDateTime(json.get("dateAccessed").getAsString()));
        }
        if (json.has("_dateAccessed")) {
            this.parseElementProperties(this.getJObject(json, "_dateAccessed"), res.getDateAccessedElement());
        }
        if (json.has("version")) {
            res.setVersion(this.parseCitationCitedArtifactVersionComponent(this.getJObject(json, "version")));
        }
        if (json.has("currentState")) {
            array = this.getJArray(json, "currentState");
            for (i = 0; i < array.size(); ++i) {
                res.getCurrentState().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("statusDate")) {
            array = this.getJArray(json, "statusDate");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusDate().add(this.parseCitationCitedArtifactStatusDateComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("title")) {
            array = this.getJArray(json, "title");
            for (i = 0; i < array.size(); ++i) {
                res.getTitle().add(this.parseCitationCitedArtifactTitleComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("abstract")) {
            array = this.getJArray(json, "abstract");
            for (i = 0; i < array.size(); ++i) {
                res.getAbstract().add(this.parseCitationCitedArtifactAbstractComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("part")) {
            res.setPart(this.parseCitationCitedArtifactPartComponent(this.getJObject(json, "part")));
        }
        if (json.has("relatesTo")) {
            array = this.getJArray(json, "relatesTo");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatesTo().add(this.parseCitationCitedArtifactRelatesToComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("publicationForm")) {
            array = this.getJArray(json, "publicationForm");
            for (i = 0; i < array.size(); ++i) {
                res.getPublicationForm().add(this.parseCitationCitedArtifactPublicationFormComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("webLocation")) {
            array = this.getJArray(json, "webLocation");
            for (i = 0; i < array.size(); ++i) {
                res.getWebLocation().add(this.parseCitationCitedArtifactWebLocationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("classification")) {
            array = this.getJArray(json, "classification");
            for (i = 0; i < array.size(); ++i) {
                res.getClassification().add(this.parseCitationCitedArtifactClassificationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("contributorship")) {
            res.setContributorship(this.parseCitationCitedArtifactContributorshipComponent(this.getJObject(json, "contributorship")));
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Citation.CitationCitedArtifactVersionComponent parseCitationCitedArtifactVersionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactVersionComponent res = new Citation.CitationCitedArtifactVersionComponent();
        this.parseCitationCitedArtifactVersionComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactVersionComponentProperties(JsonObject json, Citation.CitationCitedArtifactVersionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("baseCitation")) {
            res.setBaseCitation(this.parseReference(this.getJObject(json, "baseCitation")));
        }
    }

    protected Citation.CitationCitedArtifactStatusDateComponent parseCitationCitedArtifactStatusDateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactStatusDateComponent res = new Citation.CitationCitedArtifactStatusDateComponent();
        this.parseCitationCitedArtifactStatusDateComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactStatusDateComponentProperties(JsonObject json, Citation.CitationCitedArtifactStatusDateComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("activity")) {
            res.setActivity(this.parseCodeableConcept(this.getJObject(json, "activity")));
        }
        if (json.has("actual")) {
            res.setActualElement(this.parseBoolean(json.get("actual").getAsBoolean()));
        }
        if (json.has("_actual")) {
            this.parseElementProperties(this.getJObject(json, "_actual"), res.getActualElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Citation.CitationCitedArtifactTitleComponent parseCitationCitedArtifactTitleComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactTitleComponent res = new Citation.CitationCitedArtifactTitleComponent();
        this.parseCitationCitedArtifactTitleComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactTitleComponentProperties(JsonObject json, Citation.CitationCitedArtifactTitleComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            JsonArray array = this.getJArray(json, "type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(this.getJObject(json, "language")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseMarkdown(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
    }

    protected Citation.CitationCitedArtifactAbstractComponent parseCitationCitedArtifactAbstractComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactAbstractComponent res = new Citation.CitationCitedArtifactAbstractComponent();
        this.parseCitationCitedArtifactAbstractComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactAbstractComponentProperties(JsonObject json, Citation.CitationCitedArtifactAbstractComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(this.getJObject(json, "language")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseMarkdown(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
    }

    protected Citation.CitationCitedArtifactPartComponent parseCitationCitedArtifactPartComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactPartComponent res = new Citation.CitationCitedArtifactPartComponent();
        this.parseCitationCitedArtifactPartComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactPartComponentProperties(JsonObject json, Citation.CitationCitedArtifactPartComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("baseCitation")) {
            res.setBaseCitation(this.parseReference(this.getJObject(json, "baseCitation")));
        }
    }

    protected Citation.CitationCitedArtifactRelatesToComponent parseCitationCitedArtifactRelatesToComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactRelatesToComponent res = new Citation.CitationCitedArtifactRelatesToComponent();
        this.parseCitationCitedArtifactRelatesToComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactRelatesToComponentProperties(JsonObject json, Citation.CitationCitedArtifactRelatesToComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Citation.RelatedArtifactTypeExpanded.NULL, new Citation.RelatedArtifactTypeExpandedEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("classifier")) {
            JsonArray array = this.getJArray(json, "classifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getClassifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(this.getJObject(json, "_label"), res.getLabelElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("citation")) {
            res.setCitationElement(this.parseMarkdown(json.get("citation").getAsString()));
        }
        if (json.has("_citation")) {
            this.parseElementProperties(this.getJObject(json, "_citation"), res.getCitationElement());
        }
        if (json.has("document")) {
            res.setDocument(this.parseAttachment(this.getJObject(json, "document")));
        }
        if (json.has("resource")) {
            res.setResourceElement(this.parseCanonical(json.get("resource").getAsString()));
        }
        if (json.has("_resource")) {
            this.parseElementProperties(this.getJObject(json, "_resource"), res.getResourceElement());
        }
        if (json.has("resourceReference")) {
            res.setResourceReference(this.parseReference(this.getJObject(json, "resourceReference")));
        }
    }

    protected Citation.CitationCitedArtifactPublicationFormComponent parseCitationCitedArtifactPublicationFormComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactPublicationFormComponent res = new Citation.CitationCitedArtifactPublicationFormComponent();
        this.parseCitationCitedArtifactPublicationFormComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactPublicationFormComponentProperties(JsonObject json, Citation.CitationCitedArtifactPublicationFormComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("publishedIn")) {
            res.setPublishedIn(this.parseCitationCitedArtifactPublicationFormPublishedInComponent(this.getJObject(json, "publishedIn")));
        }
        if (json.has("citedMedium")) {
            res.setCitedMedium(this.parseCodeableConcept(this.getJObject(json, "citedMedium")));
        }
        if (json.has("volume")) {
            res.setVolumeElement(this.parseString(json.get("volume").getAsString()));
        }
        if (json.has("_volume")) {
            this.parseElementProperties(this.getJObject(json, "_volume"), res.getVolumeElement());
        }
        if (json.has("issue")) {
            res.setIssueElement(this.parseString(json.get("issue").getAsString()));
        }
        if (json.has("_issue")) {
            this.parseElementProperties(this.getJObject(json, "_issue"), res.getIssueElement());
        }
        if (json.has("articleDate")) {
            res.setArticleDateElement(this.parseDateTime(json.get("articleDate").getAsString()));
        }
        if (json.has("_articleDate")) {
            this.parseElementProperties(this.getJObject(json, "_articleDate"), res.getArticleDateElement());
        }
        if (json.has("publicationDateText")) {
            res.setPublicationDateTextElement(this.parseString(json.get("publicationDateText").getAsString()));
        }
        if (json.has("_publicationDateText")) {
            this.parseElementProperties(this.getJObject(json, "_publicationDateText"), res.getPublicationDateTextElement());
        }
        if (json.has("publicationDateSeason")) {
            res.setPublicationDateSeasonElement(this.parseString(json.get("publicationDateSeason").getAsString()));
        }
        if (json.has("_publicationDateSeason")) {
            this.parseElementProperties(this.getJObject(json, "_publicationDateSeason"), res.getPublicationDateSeasonElement());
        }
        if (json.has("lastRevisionDate")) {
            res.setLastRevisionDateElement(this.parseDateTime(json.get("lastRevisionDate").getAsString()));
        }
        if (json.has("_lastRevisionDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastRevisionDate"), res.getLastRevisionDateElement());
        }
        if (json.has("language")) {
            JsonArray array = this.getJArray(json, "language");
            for (int i = 0; i < array.size(); ++i) {
                res.getLanguage().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("accessionNumber")) {
            res.setAccessionNumberElement(this.parseString(json.get("accessionNumber").getAsString()));
        }
        if (json.has("_accessionNumber")) {
            this.parseElementProperties(this.getJObject(json, "_accessionNumber"), res.getAccessionNumberElement());
        }
        if (json.has("pageString")) {
            res.setPageStringElement(this.parseString(json.get("pageString").getAsString()));
        }
        if (json.has("_pageString")) {
            this.parseElementProperties(this.getJObject(json, "_pageString"), res.getPageStringElement());
        }
        if (json.has("firstPage")) {
            res.setFirstPageElement(this.parseString(json.get("firstPage").getAsString()));
        }
        if (json.has("_firstPage")) {
            this.parseElementProperties(this.getJObject(json, "_firstPage"), res.getFirstPageElement());
        }
        if (json.has("lastPage")) {
            res.setLastPageElement(this.parseString(json.get("lastPage").getAsString()));
        }
        if (json.has("_lastPage")) {
            this.parseElementProperties(this.getJObject(json, "_lastPage"), res.getLastPageElement());
        }
        if (json.has("pageCount")) {
            res.setPageCountElement(this.parseString(json.get("pageCount").getAsString()));
        }
        if (json.has("_pageCount")) {
            this.parseElementProperties(this.getJObject(json, "_pageCount"), res.getPageCountElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
    }

    protected Citation.CitationCitedArtifactPublicationFormPublishedInComponent parseCitationCitedArtifactPublicationFormPublishedInComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactPublicationFormPublishedInComponent res = new Citation.CitationCitedArtifactPublicationFormPublishedInComponent();
        this.parseCitationCitedArtifactPublicationFormPublishedInComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactPublicationFormPublishedInComponentProperties(JsonObject json, Citation.CitationCitedArtifactPublicationFormPublishedInComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("publisher")) {
            res.setPublisher(this.parseReference(this.getJObject(json, "publisher")));
        }
        if (json.has("publisherLocation")) {
            res.setPublisherLocationElement(this.parseString(json.get("publisherLocation").getAsString()));
        }
        if (json.has("_publisherLocation")) {
            this.parseElementProperties(this.getJObject(json, "_publisherLocation"), res.getPublisherLocationElement());
        }
    }

    protected Citation.CitationCitedArtifactWebLocationComponent parseCitationCitedArtifactWebLocationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactWebLocationComponent res = new Citation.CitationCitedArtifactWebLocationComponent();
        this.parseCitationCitedArtifactWebLocationComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactWebLocationComponentProperties(JsonObject json, Citation.CitationCitedArtifactWebLocationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("classifier")) {
            JsonArray array = this.getJArray(json, "classifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getClassifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
    }

    protected Citation.CitationCitedArtifactClassificationComponent parseCitationCitedArtifactClassificationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactClassificationComponent res = new Citation.CitationCitedArtifactClassificationComponent();
        this.parseCitationCitedArtifactClassificationComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactClassificationComponentProperties(JsonObject json, Citation.CitationCitedArtifactClassificationComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("classifier")) {
            array = this.getJArray(json, "classifier");
            for (i = 0; i < array.size(); ++i) {
                res.getClassifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("artifactAssessment")) {
            array = this.getJArray(json, "artifactAssessment");
            for (i = 0; i < array.size(); ++i) {
                res.getArtifactAssessment().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Citation.CitationCitedArtifactContributorshipComponent parseCitationCitedArtifactContributorshipComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactContributorshipComponent res = new Citation.CitationCitedArtifactContributorshipComponent();
        this.parseCitationCitedArtifactContributorshipComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactContributorshipComponentProperties(JsonObject json, Citation.CitationCitedArtifactContributorshipComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("complete")) {
            res.setCompleteElement(this.parseBoolean(json.get("complete").getAsBoolean()));
        }
        if (json.has("_complete")) {
            this.parseElementProperties(this.getJObject(json, "_complete"), res.getCompleteElement());
        }
        if (json.has("entry")) {
            array = this.getJArray(json, "entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseCitationCitedArtifactContributorshipEntryComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("summary")) {
            array = this.getJArray(json, "summary");
            for (i = 0; i < array.size(); ++i) {
                res.getSummary().add(this.parseCitationContributorshipSummaryComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Citation.CitationCitedArtifactContributorshipEntryComponent parseCitationCitedArtifactContributorshipEntryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactContributorshipEntryComponent res = new Citation.CitationCitedArtifactContributorshipEntryComponent();
        this.parseCitationCitedArtifactContributorshipEntryComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactContributorshipEntryComponentProperties(JsonObject json, Citation.CitationCitedArtifactContributorshipEntryComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("contributor")) {
            res.setContributor(this.parseReference(this.getJObject(json, "contributor")));
        }
        if (json.has("forenameInitials")) {
            res.setForenameInitialsElement(this.parseString(json.get("forenameInitials").getAsString()));
        }
        if (json.has("_forenameInitials")) {
            this.parseElementProperties(this.getJObject(json, "_forenameInitials"), res.getForenameInitialsElement());
        }
        if (json.has("affiliation")) {
            array = this.getJArray(json, "affiliation");
            for (i = 0; i < array.size(); ++i) {
                res.getAffiliation().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("contributionType")) {
            array = this.getJArray(json, "contributionType");
            for (i = 0; i < array.size(); ++i) {
                res.getContributionType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("contributionInstance")) {
            array = this.getJArray(json, "contributionInstance");
            for (i = 0; i < array.size(); ++i) {
                res.getContributionInstance().add(this.parseCitationCitedArtifactContributorshipEntryContributionInstanceComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("correspondingContact")) {
            res.setCorrespondingContactElement(this.parseBoolean(json.get("correspondingContact").getAsBoolean()));
        }
        if (json.has("_correspondingContact")) {
            this.parseElementProperties(this.getJObject(json, "_correspondingContact"), res.getCorrespondingContactElement());
        }
        if (json.has("rankingOrder")) {
            res.setRankingOrderElement(this.parsePositiveInt(json.get("rankingOrder").getAsString()));
        }
        if (json.has("_rankingOrder")) {
            this.parseElementProperties(this.getJObject(json, "_rankingOrder"), res.getRankingOrderElement());
        }
    }

    protected Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent parseCitationCitedArtifactContributorshipEntryContributionInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent res = new Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent();
        this.parseCitationCitedArtifactContributorshipEntryContributionInstanceComponentProperties(json, res);
        return res;
    }

    protected void parseCitationCitedArtifactContributorshipEntryContributionInstanceComponentProperties(JsonObject json, Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(this.getJObject(json, "_time"), res.getTimeElement());
        }
    }

    protected Citation.ContributorshipSummaryComponent parseCitationContributorshipSummaryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.ContributorshipSummaryComponent res = new Citation.ContributorshipSummaryComponent();
        this.parseCitationContributorshipSummaryComponentProperties(json, res);
        return res;
    }

    protected void parseCitationContributorshipSummaryComponentProperties(JsonObject json, Citation.ContributorshipSummaryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("style")) {
            res.setStyle(this.parseCodeableConcept(this.getJObject(json, "style")));
        }
        if (json.has("source")) {
            res.setSource(this.parseCodeableConcept(this.getJObject(json, "source")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseMarkdown(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected Claim parseClaim(JsonObject json) throws IOException, FHIRFormatError {
        Claim res = new Claim();
        this.parseClaimProperties(json, res);
        return res;
    }

    protected void parseClaimProperties(JsonObject json, Claim res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(this.getJObject(json, "subType")));
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(this.getJObject(json, "billablePeriod")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(this.getJObject(json, "enterer")));
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(this.getJObject(json, "priority")));
        }
        if (json.has("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(this.getJObject(json, "fundsReserve")));
        }
        if (json.has("related")) {
            array = this.getJArray(json, "related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseClaimRelatedClaimComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("prescription")) {
            res.setPrescription(this.parseReference(this.getJObject(json, "prescription")));
        }
        if (json.has("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(this.getJObject(json, "originalPrescription")));
        }
        if (json.has("payee")) {
            res.setPayee(this.parseClaimPayeeComponent(this.getJObject(json, "payee")));
        }
        if (json.has("referral")) {
            res.setReferral(this.parseReference(this.getJObject(json, "referral")));
        }
        if (json.has("encounter")) {
            array = this.getJArray(json, "encounter");
            for (i = 0; i < array.size(); ++i) {
                res.getEncounter().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("facility")) {
            res.setFacility(this.parseReference(this.getJObject(json, "facility")));
        }
        if (json.has("diagnosisRelatedGroup")) {
            res.setDiagnosisRelatedGroup(this.parseCodeableConcept(this.getJObject(json, "diagnosisRelatedGroup")));
        }
        if (json.has("event")) {
            array = this.getJArray(json, "event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseClaimEventComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("careTeam")) {
            array = this.getJArray(json, "careTeam");
            for (i = 0; i < array.size(); ++i) {
                res.getCareTeam().add(this.parseClaimCareTeamComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("supportingInfo")) {
            array = this.getJArray(json, "supportingInfo");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInfo().add(this.parseClaimSupportingInformationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("diagnosis")) {
            array = this.getJArray(json, "diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseClaimDiagnosisComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("procedure")) {
            array = this.getJArray(json, "procedure");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedure().add(this.parseClaimProcedureComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("insurance")) {
            array = this.getJArray(json, "insurance");
            for (i = 0; i < array.size(); ++i) {
                res.getInsurance().add(this.parseClaimInsuranceComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("accident")) {
            res.setAccident(this.parseClaimAccidentComponent(this.getJObject(json, "accident")));
        }
        if (json.has("patientPaid")) {
            res.setPatientPaid(this.parseMoney(this.getJObject(json, "patientPaid")));
        }
        if (json.has("item")) {
            array = this.getJArray(json, "item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseClaimItemComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("total")) {
            res.setTotal(this.parseMoney(this.getJObject(json, "total")));
        }
    }

    protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
        this.parseClaimRelatedClaimComponentProperties(json, res);
        return res;
    }

    protected void parseClaimRelatedClaimComponentProperties(JsonObject json, Claim.RelatedClaimComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("claim")) {
            res.setClaim(this.parseReference(this.getJObject(json, "claim")));
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(this.getJObject(json, "relationship")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseIdentifier(this.getJObject(json, "reference")));
        }
    }

    protected Claim.PayeeComponent parseClaimPayeeComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.PayeeComponent res = new Claim.PayeeComponent();
        this.parseClaimPayeeComponentProperties(json, res);
        return res;
    }

    protected void parseClaimPayeeComponentProperties(JsonObject json, Claim.PayeeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
    }

    protected Claim.ClaimEventComponent parseClaimEventComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.ClaimEventComponent res = new Claim.ClaimEventComponent();
        this.parseClaimEventComponentProperties(json, res);
        return res;
    }

    protected void parseClaimEventComponentProperties(JsonObject json, Claim.ClaimEventComponent res) throws IOException, FHIRFormatError {
        DataType when;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((when = this.parseType("when", json)) != null) {
            res.setWhen(when);
        }
    }

    protected Claim.CareTeamComponent parseClaimCareTeamComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.CareTeamComponent res = new Claim.CareTeamComponent();
        this.parseClaimCareTeamComponentProperties(json, res);
        return res;
    }

    protected void parseClaimCareTeamComponentProperties(JsonObject json, Claim.CareTeamComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("responsible")) {
            res.setResponsibleElement(this.parseBoolean(json.get("responsible").getAsBoolean()));
        }
        if (json.has("_responsible")) {
            this.parseElementProperties(this.getJObject(json, "_responsible"), res.getResponsibleElement());
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("specialty")) {
            res.setSpecialty(this.parseCodeableConcept(this.getJObject(json, "specialty")));
        }
    }

    protected Claim.SupportingInformationComponent parseClaimSupportingInformationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.SupportingInformationComponent res = new Claim.SupportingInformationComponent();
        this.parseClaimSupportingInformationComponentProperties(json, res);
        return res;
    }

    protected void parseClaimSupportingInformationComponentProperties(JsonObject json, Claim.SupportingInformationComponent res) throws IOException, FHIRFormatError {
        DataType value;
        DataType timing;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(this.getJObject(json, "reason")));
        }
    }

    protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
        this.parseClaimDiagnosisComponentProperties(json, res);
        return res;
    }

    protected void parseClaimDiagnosisComponentProperties(JsonObject json, Claim.DiagnosisComponent res) throws IOException, FHIRFormatError {
        DataType diagnosis;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if ((diagnosis = this.parseType("diagnosis", json)) != null) {
            res.setDiagnosis(diagnosis);
        }
        if (json.has("type")) {
            JsonArray array = this.getJArray(json, "type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("onAdmission")) {
            res.setOnAdmission(this.parseCodeableConcept(this.getJObject(json, "onAdmission")));
        }
    }

    protected Claim.ProcedureComponent parseClaimProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.ProcedureComponent res = new Claim.ProcedureComponent();
        this.parseClaimProcedureComponentProperties(json, res);
        return res;
    }

    protected void parseClaimProcedureComponentProperties(JsonObject json, Claim.ProcedureComponent res) throws IOException, FHIRFormatError {
        DataType procedure;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            JsonArray array = this.getJArray(json, "type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if ((procedure = this.parseType("procedure", json)) != null) {
            res.setProcedure(procedure);
        }
        if (json.has("udi")) {
            JsonArray array = this.getJArray(json, "udi");
            for (int i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Claim.InsuranceComponent parseClaimInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.InsuranceComponent res = new Claim.InsuranceComponent();
        this.parseClaimInsuranceComponentProperties(json, res);
        return res;
    }

    protected void parseClaimInsuranceComponentProperties(JsonObject json, Claim.InsuranceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(this.getJObject(json, "_focal"), res.getFocalElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(this.getJObject(json, "_businessArrangement"), res.getBusinessArrangementElement());
        }
        if (json.has("preAuthRef")) {
            array = this.getJArray(json, "preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPreAuthRef().add(new StringType());
                    continue;
                }
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = this.getJArray(json, "_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getPreAuthRef().get(i));
            }
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(this.getJObject(json, "claimResponse")));
        }
    }

    protected Claim.AccidentComponent parseClaimAccidentComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.AccidentComponent res = new Claim.AccidentComponent();
        this.parseClaimAccidentComponentProperties(json, res);
        return res;
    }

    protected void parseClaimAccidentComponentProperties(JsonObject json, Claim.AccidentComponent res) throws IOException, FHIRFormatError {
        DataType location;
        this.parseBackboneElementProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
    }

    protected Claim.ItemComponent parseClaimItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.ItemComponent res = new Claim.ItemComponent();
        this.parseClaimItemComponentProperties(json, res);
        return res;
    }

    protected void parseClaimItemComponentProperties(JsonObject json, Claim.ItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType location;
        DataType serviced;
        int i2;
        JsonArray array2;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("traceNumber")) {
            array2 = this.getJArray(json, "traceNumber");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("careTeamSequence")) {
            array2 = this.getJArray(json, "careTeamSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getCareTeamSequence().add(new PositiveIntType());
                    continue;
                }
                res.getCareTeamSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_careTeamSequence")) {
            array2 = this.getJArray(json, "_careTeamSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getCareTeamSequence().size()) {
                    res.getCareTeamSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getCareTeamSequence().get(i2));
            }
        }
        if (json.has("diagnosisSequence")) {
            array2 = this.getJArray(json, "diagnosisSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getDiagnosisSequence().add(new PositiveIntType());
                    continue;
                }
                res.getDiagnosisSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_diagnosisSequence")) {
            array2 = this.getJArray(json, "_diagnosisSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getDiagnosisSequence().size()) {
                    res.getDiagnosisSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getDiagnosisSequence().get(i2));
            }
        }
        if (json.has("procedureSequence")) {
            array2 = this.getJArray(json, "procedureSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getProcedureSequence().add(new PositiveIntType());
                    continue;
                }
                res.getProcedureSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_procedureSequence")) {
            array2 = this.getJArray(json, "_procedureSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getProcedureSequence().size()) {
                    res.getProcedureSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getProcedureSequence().get(i2));
            }
        }
        if (json.has("informationSequence")) {
            array2 = this.getJArray(json, "informationSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getInformationSequence().add(new PositiveIntType());
                    continue;
                }
                res.getInformationSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_informationSequence")) {
            array2 = this.getJArray(json, "_informationSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getInformationSequence().size()) {
                    res.getInformationSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getInformationSequence().get(i2));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(this.getJObject(json, "productOrServiceEnd")));
        }
        if (json.has("request")) {
            array2 = this.getJArray(json, "request");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getRequest().add(this.parseReference(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("modifier")) {
            array2 = this.getJArray(json, "modifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("programCode")) {
            array2 = this.getJArray(json, "programCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProgramCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
        if (json.has("patientPaid")) {
            res.setPatientPaid(this.parseMoney(this.getJObject(json, "patientPaid")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("tax")) {
            res.setTax(this.parseMoney(this.getJObject(json, "tax")));
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("udi")) {
            array = this.getJArray(json, "udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("bodySite")) {
            array = this.getJArray(json, "bodySite");
            for (i = 0; i < array.size(); ++i) {
                res.getBodySite().add(this.parseClaimBodySiteComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("encounter")) {
            array = this.getJArray(json, "encounter");
            for (i = 0; i < array.size(); ++i) {
                res.getEncounter().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("detail")) {
            array = this.getJArray(json, "detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimDetailComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Claim.BodySiteComponent parseClaimBodySiteComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.BodySiteComponent res = new Claim.BodySiteComponent();
        this.parseClaimBodySiteComponentProperties(json, res);
        return res;
    }

    protected void parseClaimBodySiteComponentProperties(JsonObject json, Claim.BodySiteComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("site")) {
            array = this.getJArray(json, "site");
            for (i = 0; i < array.size(); ++i) {
                res.getSite().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subSite")) {
            array = this.getJArray(json, "subSite");
            for (i = 0; i < array.size(); ++i) {
                res.getSubSite().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Claim.DetailComponent parseClaimDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.DetailComponent res = new Claim.DetailComponent();
        this.parseClaimDetailComponentProperties(json, res);
        return res;
    }

    protected void parseClaimDetailComponentProperties(JsonObject json, Claim.DetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(this.getJObject(json, "productOrServiceEnd")));
        }
        if (json.has("modifier")) {
            array = this.getJArray(json, "modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("programCode")) {
            array = this.getJArray(json, "programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("patientPaid")) {
            res.setPatientPaid(this.parseMoney(this.getJObject(json, "patientPaid")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("tax")) {
            res.setTax(this.parseMoney(this.getJObject(json, "tax")));
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("udi")) {
            array = this.getJArray(json, "udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subDetail")) {
            array = this.getJArray(json, "subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseClaimSubDetailComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Claim.SubDetailComponent parseClaimSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.SubDetailComponent res = new Claim.SubDetailComponent();
        this.parseClaimSubDetailComponentProperties(json, res);
        return res;
    }

    protected void parseClaimSubDetailComponentProperties(JsonObject json, Claim.SubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(this.getJObject(json, "productOrServiceEnd")));
        }
        if (json.has("modifier")) {
            array = this.getJArray(json, "modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("programCode")) {
            array = this.getJArray(json, "programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("patientPaid")) {
            res.setPatientPaid(this.parseMoney(this.getJObject(json, "patientPaid")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("tax")) {
            res.setTax(this.parseMoney(this.getJObject(json, "tax")));
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("udi")) {
            array = this.getJArray(json, "udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClaimResponse parseClaimResponse(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse res = new ClaimResponse();
        this.parseClaimResponseProperties(json, res);
        return res;
    }

    protected void parseClaimResponseProperties(JsonObject json, ClaimResponse res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(this.getJObject(json, "subType")));
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("requestor")) {
            res.setRequestor(this.parseReference(this.getJObject(json, "requestor")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(this.getJObject(json, "request")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(this.getJObject(json, "_outcome"), res.getOutcomeElement());
        }
        if (json.has("decision")) {
            res.setDecision(this.parseCodeableConcept(this.getJObject(json, "decision")));
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(this.getJObject(json, "_disposition"), res.getDispositionElement());
        }
        if (json.has("preAuthRef")) {
            res.setPreAuthRefElement(this.parseString(json.get("preAuthRef").getAsString()));
        }
        if (json.has("_preAuthRef")) {
            this.parseElementProperties(this.getJObject(json, "_preAuthRef"), res.getPreAuthRefElement());
        }
        if (json.has("preAuthPeriod")) {
            res.setPreAuthPeriod(this.parsePeriod(this.getJObject(json, "preAuthPeriod")));
        }
        if (json.has("event")) {
            array = this.getJArray(json, "event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseClaimResponseEventComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("payeeType")) {
            res.setPayeeType(this.parseCodeableConcept(this.getJObject(json, "payeeType")));
        }
        if (json.has("encounter")) {
            array = this.getJArray(json, "encounter");
            for (i = 0; i < array.size(); ++i) {
                res.getEncounter().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("diagnosisRelatedGroup")) {
            res.setDiagnosisRelatedGroup(this.parseCodeableConcept(this.getJObject(json, "diagnosisRelatedGroup")));
        }
        if (json.has("item")) {
            array = this.getJArray(json, "item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseClaimResponseItemComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("addItem")) {
            array = this.getJArray(json, "addItem");
            for (i = 0; i < array.size(); ++i) {
                res.getAddItem().add(this.parseClaimResponseAddedItemComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("total")) {
            array = this.getJArray(json, "total");
            for (i = 0; i < array.size(); ++i) {
                res.getTotal().add(this.parseClaimResponseTotalComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("payment")) {
            res.setPayment(this.parseClaimResponsePaymentComponent(this.getJObject(json, "payment")));
        }
        if (json.has("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(this.getJObject(json, "fundsReserve")));
        }
        if (json.has("formCode")) {
            res.setFormCode(this.parseCodeableConcept(this.getJObject(json, "formCode")));
        }
        if (json.has("form")) {
            res.setForm(this.parseAttachment(this.getJObject(json, "form")));
        }
        if (json.has("processNote")) {
            array = this.getJArray(json, "processNote");
            for (i = 0; i < array.size(); ++i) {
                res.getProcessNote().add(this.parseClaimResponseNoteComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("communicationRequest")) {
            array = this.getJArray(json, "communicationRequest");
            for (i = 0; i < array.size(); ++i) {
                res.getCommunicationRequest().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("insurance")) {
            array = this.getJArray(json, "insurance");
            for (i = 0; i < array.size(); ++i) {
                res.getInsurance().add(this.parseClaimResponseInsuranceComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("error")) {
            array = this.getJArray(json, "error");
            for (i = 0; i < array.size(); ++i) {
                res.getError().add(this.parseClaimResponseErrorComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClaimResponse.ClaimResponseEventComponent parseClaimResponseEventComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.ClaimResponseEventComponent res = new ClaimResponse.ClaimResponseEventComponent();
        this.parseClaimResponseEventComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseEventComponentProperties(JsonObject json, ClaimResponse.ClaimResponseEventComponent res) throws IOException, FHIRFormatError {
        DataType when;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((when = this.parseType("when", json)) != null) {
            res.setWhen(when);
        }
    }

    protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
        this.parseClaimResponseItemComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseItemComponentProperties(JsonObject json, ClaimResponse.ItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("itemSequence")) {
            res.setItemSequenceElement(this.parsePositiveInt(json.get("itemSequence").getAsString()));
        }
        if (json.has("_itemSequence")) {
            this.parseElementProperties(this.getJObject(json, "_itemSequence"), res.getItemSequenceElement());
        }
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("noteNumber")) {
            array = this.getJArray(json, "noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = this.getJArray(json, "_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
            }
        }
        if (json.has("reviewOutcome")) {
            res.setReviewOutcome(this.parseClaimResponseReviewOutcomeComponent(this.getJObject(json, "reviewOutcome")));
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("detail")) {
            array = this.getJArray(json, "detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimResponseItemDetailComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClaimResponse.ReviewOutcomeComponent parseClaimResponseReviewOutcomeComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.ReviewOutcomeComponent res = new ClaimResponse.ReviewOutcomeComponent();
        this.parseClaimResponseReviewOutcomeComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseReviewOutcomeComponentProperties(JsonObject json, ClaimResponse.ReviewOutcomeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("decision")) {
            res.setDecision(this.parseCodeableConcept(this.getJObject(json, "decision")));
        }
        if (json.has("reason")) {
            JsonArray array = this.getJArray(json, "reason");
            for (int i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("preAuthRef")) {
            res.setPreAuthRefElement(this.parseString(json.get("preAuthRef").getAsString()));
        }
        if (json.has("_preAuthRef")) {
            this.parseElementProperties(this.getJObject(json, "_preAuthRef"), res.getPreAuthRefElement());
        }
        if (json.has("preAuthPeriod")) {
            res.setPreAuthPeriod(this.parsePeriod(this.getJObject(json, "preAuthPeriod")));
        }
    }

    protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
        this.parseClaimResponseAdjudicationComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseAdjudicationComponentProperties(JsonObject json, ClaimResponse.AdjudicationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(this.getJObject(json, "reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
    }

    protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
        this.parseClaimResponseItemDetailComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseItemDetailComponentProperties(JsonObject json, ClaimResponse.ItemDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("detailSequence")) {
            res.setDetailSequenceElement(this.parsePositiveInt(json.get("detailSequence").getAsString()));
        }
        if (json.has("_detailSequence")) {
            this.parseElementProperties(this.getJObject(json, "_detailSequence"), res.getDetailSequenceElement());
        }
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("noteNumber")) {
            array = this.getJArray(json, "noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = this.getJArray(json, "_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
            }
        }
        if (json.has("reviewOutcome")) {
            res.setReviewOutcome(this.parseClaimResponseReviewOutcomeComponent(this.getJObject(json, "reviewOutcome")));
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subDetail")) {
            array = this.getJArray(json, "subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseClaimResponseSubDetailComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
        this.parseClaimResponseSubDetailComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseSubDetailComponentProperties(JsonObject json, ClaimResponse.SubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("subDetailSequence")) {
            res.setSubDetailSequenceElement(this.parsePositiveInt(json.get("subDetailSequence").getAsString()));
        }
        if (json.has("_subDetailSequence")) {
            this.parseElementProperties(this.getJObject(json, "_subDetailSequence"), res.getSubDetailSequenceElement());
        }
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("noteNumber")) {
            array = this.getJArray(json, "noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = this.getJArray(json, "_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
            }
        }
        if (json.has("reviewOutcome")) {
            res.setReviewOutcome(this.parseClaimResponseReviewOutcomeComponent(this.getJObject(json, "reviewOutcome")));
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
        this.parseClaimResponseAddedItemComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseAddedItemComponentProperties(JsonObject json, ClaimResponse.AddedItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType location;
        DataType serviced;
        int i2;
        JsonArray array2;
        this.parseBackboneElementProperties(json, res);
        if (json.has("itemSequence")) {
            array2 = this.getJArray(json, "itemSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getItemSequence().add(new PositiveIntType());
                    continue;
                }
                res.getItemSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_itemSequence")) {
            array2 = this.getJArray(json, "_itemSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getItemSequence().size()) {
                    res.getItemSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getItemSequence().get(i2));
            }
        }
        if (json.has("detailSequence")) {
            array2 = this.getJArray(json, "detailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getDetailSequence().add(new PositiveIntType());
                    continue;
                }
                res.getDetailSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_detailSequence")) {
            array2 = this.getJArray(json, "_detailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getDetailSequence().size()) {
                    res.getDetailSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getDetailSequence().get(i2));
            }
        }
        if (json.has("subdetailSequence")) {
            array2 = this.getJArray(json, "subdetailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getSubdetailSequence().add(new PositiveIntType());
                    continue;
                }
                res.getSubdetailSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_subdetailSequence")) {
            array2 = this.getJArray(json, "_subdetailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getSubdetailSequence().size()) {
                    res.getSubdetailSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getSubdetailSequence().get(i2));
            }
        }
        if (json.has("traceNumber")) {
            array2 = this.getJArray(json, "traceNumber");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("provider")) {
            array2 = this.getJArray(json, "provider");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProvider().add(this.parseReference(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(this.getJObject(json, "productOrServiceEnd")));
        }
        if (json.has("request")) {
            array2 = this.getJArray(json, "request");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getRequest().add(this.parseReference(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("modifier")) {
            array2 = this.getJArray(json, "modifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("programCode")) {
            array2 = this.getJArray(json, "programCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProgramCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("tax")) {
            res.setTax(this.parseMoney(this.getJObject(json, "tax")));
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("bodySite")) {
            array = this.getJArray(json, "bodySite");
            for (i = 0; i < array.size(); ++i) {
                res.getBodySite().add(this.parseClaimResponseBodySiteComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("noteNumber")) {
            array = this.getJArray(json, "noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = this.getJArray(json, "_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
            }
        }
        if (json.has("reviewOutcome")) {
            res.setReviewOutcome(this.parseClaimResponseReviewOutcomeComponent(this.getJObject(json, "reviewOutcome")));
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("detail")) {
            array = this.getJArray(json, "detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimResponseAddedItemDetailComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClaimResponse.BodySiteComponent parseClaimResponseBodySiteComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.BodySiteComponent res = new ClaimResponse.BodySiteComponent();
        this.parseClaimResponseBodySiteComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseBodySiteComponentProperties(JsonObject json, ClaimResponse.BodySiteComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("site")) {
            array = this.getJArray(json, "site");
            for (i = 0; i < array.size(); ++i) {
                res.getSite().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subSite")) {
            array = this.getJArray(json, "subSite");
            for (i = 0; i < array.size(); ++i) {
                res.getSubSite().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClaimResponse.AddedItemDetailComponent parseClaimResponseAddedItemDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemDetailComponent res = new ClaimResponse.AddedItemDetailComponent();
        this.parseClaimResponseAddedItemDetailComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseAddedItemDetailComponentProperties(JsonObject json, ClaimResponse.AddedItemDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(this.getJObject(json, "productOrServiceEnd")));
        }
        if (json.has("modifier")) {
            array = this.getJArray(json, "modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("tax")) {
            res.setTax(this.parseMoney(this.getJObject(json, "tax")));
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("noteNumber")) {
            array = this.getJArray(json, "noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = this.getJArray(json, "_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
            }
        }
        if (json.has("reviewOutcome")) {
            res.setReviewOutcome(this.parseClaimResponseReviewOutcomeComponent(this.getJObject(json, "reviewOutcome")));
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subDetail")) {
            array = this.getJArray(json, "subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseClaimResponseAddedItemSubDetailComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClaimResponse.AddedItemSubDetailComponent parseClaimResponseAddedItemSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemSubDetailComponent res = new ClaimResponse.AddedItemSubDetailComponent();
        this.parseClaimResponseAddedItemSubDetailComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseAddedItemSubDetailComponentProperties(JsonObject json, ClaimResponse.AddedItemSubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(this.getJObject(json, "productOrServiceEnd")));
        }
        if (json.has("modifier")) {
            array = this.getJArray(json, "modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("tax")) {
            res.setTax(this.parseMoney(this.getJObject(json, "tax")));
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("noteNumber")) {
            array = this.getJArray(json, "noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = this.getJArray(json, "_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
            }
        }
        if (json.has("reviewOutcome")) {
            res.setReviewOutcome(this.parseClaimResponseReviewOutcomeComponent(this.getJObject(json, "reviewOutcome")));
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClaimResponse.TotalComponent parseClaimResponseTotalComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.TotalComponent res = new ClaimResponse.TotalComponent();
        this.parseClaimResponseTotalComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseTotalComponentProperties(JsonObject json, ClaimResponse.TotalComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
    }

    protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
        this.parseClaimResponsePaymentComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponsePaymentComponentProperties(JsonObject json, ClaimResponse.PaymentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("adjustment")) {
            res.setAdjustment(this.parseMoney(this.getJObject(json, "adjustment")));
        }
        if (json.has("adjustmentReason")) {
            res.setAdjustmentReason(this.parseCodeableConcept(this.getJObject(json, "adjustmentReason")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
    }

    protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
        this.parseClaimResponseNoteComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseNoteComponentProperties(JsonObject json, ClaimResponse.NoteComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parsePositiveInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(this.getJObject(json, "_number"), res.getNumberElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(this.getJObject(json, "language")));
        }
    }

    protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
        this.parseClaimResponseInsuranceComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseInsuranceComponentProperties(JsonObject json, ClaimResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(this.getJObject(json, "_focal"), res.getFocalElement());
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(this.getJObject(json, "_businessArrangement"), res.getBusinessArrangementElement());
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(this.getJObject(json, "claimResponse")));
        }
    }

    protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
        this.parseClaimResponseErrorComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseErrorComponentProperties(JsonObject json, ClaimResponse.ErrorComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("itemSequence")) {
            res.setItemSequenceElement(this.parsePositiveInt(json.get("itemSequence").getAsString()));
        }
        if (json.has("_itemSequence")) {
            this.parseElementProperties(this.getJObject(json, "_itemSequence"), res.getItemSequenceElement());
        }
        if (json.has("detailSequence")) {
            res.setDetailSequenceElement(this.parsePositiveInt(json.get("detailSequence").getAsString()));
        }
        if (json.has("_detailSequence")) {
            this.parseElementProperties(this.getJObject(json, "_detailSequence"), res.getDetailSequenceElement());
        }
        if (json.has("subDetailSequence")) {
            res.setSubDetailSequenceElement(this.parsePositiveInt(json.get("subDetailSequence").getAsString()));
        }
        if (json.has("_subDetailSequence")) {
            this.parseElementProperties(this.getJObject(json, "_subDetailSequence"), res.getSubDetailSequenceElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("expression")) {
            array = this.getJArray(json, "expression");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getExpression().add(new StringType());
                    continue;
                }
                res.getExpression().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_expression")) {
            array = this.getJArray(json, "_expression");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getExpression().size()) {
                    res.getExpression().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getExpression().get(i));
            }
        }
    }

    protected ClinicalImpression parseClinicalImpression(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalImpression res = new ClinicalImpression();
        this.parseClinicalImpressionProperties(json, res);
        return res;
    }

    protected void parseClinicalImpressionProperties(JsonObject json, ClinicalImpression res) throws IOException, FHIRFormatError {
        int i;
        DataType effective;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.EventStatus.NULL, new Enumerations.EventStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(this.getJObject(json, "statusReason")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(this.getJObject(json, "performer")));
        }
        if (json.has("previous")) {
            res.setPrevious(this.parseReference(this.getJObject(json, "previous")));
        }
        if (json.has("problem")) {
            JsonArray array = this.getJArray(json, "problem");
            for (i = 0; i < array.size(); ++i) {
                res.getProblem().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("changePattern")) {
            res.setChangePattern(this.parseCodeableConcept(this.getJObject(json, "changePattern")));
        }
        if (json.has("protocol")) {
            JsonArray array = this.getJArray(json, "protocol");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getProtocol().add(new UriType());
                    continue;
                }
                res.getProtocol().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_protocol")) {
            JsonArray array = this.getJArray(json, "_protocol");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProtocol().size()) {
                    res.getProtocol().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getProtocol().get(i));
            }
        }
        if (json.has("summary")) {
            res.setSummaryElement(this.parseString(json.get("summary").getAsString()));
        }
        if (json.has("_summary")) {
            this.parseElementProperties(this.getJObject(json, "_summary"), res.getSummaryElement());
        }
        if (json.has("finding")) {
            JsonArray array = this.getJArray(json, "finding");
            for (i = 0; i < array.size(); ++i) {
                res.getFinding().add(this.parseClinicalImpressionFindingComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("prognosisCodeableConcept")) {
            JsonArray array = this.getJArray(json, "prognosisCodeableConcept");
            for (i = 0; i < array.size(); ++i) {
                res.getPrognosisCodeableConcept().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("prognosisReference")) {
            JsonArray array = this.getJArray(json, "prognosisReference");
            for (i = 0; i < array.size(); ++i) {
                res.getPrognosisReference().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("supportingInfo")) {
            JsonArray array = this.getJArray(json, "supportingInfo");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInfo().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("note")) {
            JsonArray array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionFindingComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
        this.parseClinicalImpressionFindingComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalImpressionFindingComponentProperties(JsonObject json, ClinicalImpression.ClinicalImpressionFindingComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("item")) {
            res.setItem(this.parseCodeableReference(this.getJObject(json, "item")));
        }
        if (json.has("basis")) {
            res.setBasisElement(this.parseString(json.get("basis").getAsString()));
        }
        if (json.has("_basis")) {
            this.parseElementProperties(this.getJObject(json, "_basis"), res.getBasisElement());
        }
    }

    protected ClinicalUseDefinition parseClinicalUseDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseDefinition res = new ClinicalUseDefinition();
        this.parseClinicalUseDefinitionProperties(json, res);
        return res;
    }

    protected void parseClinicalUseDefinitionProperties(JsonObject json, ClinicalUseDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ClinicalUseDefinition.ClinicalUseDefinitionType.NULL, new ClinicalUseDefinition.ClinicalUseDefinitionTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subject")) {
            array = this.getJArray(json, "subject");
            for (i = 0; i < array.size(); ++i) {
                res.getSubject().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatus(this.parseCodeableConcept(this.getJObject(json, "status")));
        }
        if (json.has("contraindication")) {
            res.setContraindication(this.parseClinicalUseDefinitionContraindicationComponent(this.getJObject(json, "contraindication")));
        }
        if (json.has("indication")) {
            res.setIndication(this.parseClinicalUseDefinitionIndicationComponent(this.getJObject(json, "indication")));
        }
        if (json.has("interaction")) {
            res.setInteraction(this.parseClinicalUseDefinitionInteractionComponent(this.getJObject(json, "interaction")));
        }
        if (json.has("population")) {
            array = this.getJArray(json, "population");
            for (i = 0; i < array.size(); ++i) {
                res.getPopulation().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("library")) {
            array = this.getJArray(json, "library");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getLibrary().add(new CanonicalType());
                    continue;
                }
                res.getLibrary().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_library")) {
            array = this.getJArray(json, "_library");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLibrary().size()) {
                    res.getLibrary().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getLibrary().get(i));
            }
        }
        if (json.has("undesirableEffect")) {
            res.setUndesirableEffect(this.parseClinicalUseDefinitionUndesirableEffectComponent(this.getJObject(json, "undesirableEffect")));
        }
        if (json.has("warning")) {
            res.setWarning(this.parseClinicalUseDefinitionWarningComponent(this.getJObject(json, "warning")));
        }
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent parseClinicalUseDefinitionContraindicationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent();
        this.parseClinicalUseDefinitionContraindicationComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseDefinitionContraindicationComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("diseaseSymptomProcedure")) {
            res.setDiseaseSymptomProcedure(this.parseCodeableReference(this.getJObject(json, "diseaseSymptomProcedure")));
        }
        if (json.has("diseaseStatus")) {
            res.setDiseaseStatus(this.parseCodeableReference(this.getJObject(json, "diseaseStatus")));
        }
        if (json.has("comorbidity")) {
            array = this.getJArray(json, "comorbidity");
            for (i = 0; i < array.size(); ++i) {
                res.getComorbidity().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("indication")) {
            array = this.getJArray(json, "indication");
            for (i = 0; i < array.size(); ++i) {
                res.getIndication().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("applicability")) {
            res.setApplicability(this.parseExpression(this.getJObject(json, "applicability")));
        }
        if (json.has("otherTherapy")) {
            array = this.getJArray(json, "otherTherapy");
            for (i = 0; i < array.size(); ++i) {
                res.getOtherTherapy().add(this.parseClinicalUseDefinitionContraindicationOtherTherapyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent parseClinicalUseDefinitionContraindicationOtherTherapyComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent();
        this.parseClinicalUseDefinitionContraindicationOtherTherapyComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseDefinitionContraindicationOtherTherapyComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("relationshipType")) {
            res.setRelationshipType(this.parseCodeableConcept(this.getJObject(json, "relationshipType")));
        }
        if (json.has("treatment")) {
            res.setTreatment(this.parseCodeableReference(this.getJObject(json, "treatment")));
        }
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent parseClinicalUseDefinitionIndicationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent();
        this.parseClinicalUseDefinitionIndicationComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseDefinitionIndicationComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent res) throws IOException, FHIRFormatError {
        int i;
        DataType duration;
        this.parseBackboneElementProperties(json, res);
        if (json.has("diseaseSymptomProcedure")) {
            res.setDiseaseSymptomProcedure(this.parseCodeableReference(this.getJObject(json, "diseaseSymptomProcedure")));
        }
        if (json.has("diseaseStatus")) {
            res.setDiseaseStatus(this.parseCodeableReference(this.getJObject(json, "diseaseStatus")));
        }
        if (json.has("comorbidity")) {
            JsonArray array = this.getJArray(json, "comorbidity");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getComorbidity().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("intendedEffect")) {
            res.setIntendedEffect(this.parseCodeableReference(this.getJObject(json, "intendedEffect")));
        }
        if ((duration = this.parseType("duration", json)) != null) {
            res.setDuration(duration);
        }
        if (json.has("undesirableEffect")) {
            JsonArray array = this.getJArray(json, "undesirableEffect");
            for (i = 0; i < array.size(); ++i) {
                res.getUndesirableEffect().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("applicability")) {
            res.setApplicability(this.parseExpression(this.getJObject(json, "applicability")));
        }
        if (json.has("otherTherapy")) {
            JsonArray array = this.getJArray(json, "otherTherapy");
            for (i = 0; i < array.size(); ++i) {
                res.getOtherTherapy().add(this.parseClinicalUseDefinitionContraindicationOtherTherapyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent parseClinicalUseDefinitionInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent();
        this.parseClinicalUseDefinitionInteractionComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseDefinitionInteractionComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("interactant")) {
            array = this.getJArray(json, "interactant");
            for (i = 0; i < array.size(); ++i) {
                res.getInteractant().add(this.parseClinicalUseDefinitionInteractionInteractantComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("effect")) {
            res.setEffect(this.parseCodeableReference(this.getJObject(json, "effect")));
        }
        if (json.has("incidence")) {
            res.setIncidence(this.parseCodeableConcept(this.getJObject(json, "incidence")));
        }
        if (json.has("management")) {
            array = this.getJArray(json, "management");
            for (i = 0; i < array.size(); ++i) {
                res.getManagement().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent parseClinicalUseDefinitionInteractionInteractantComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent();
        this.parseClinicalUseDefinitionInteractionInteractantComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseDefinitionInteractionInteractantComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent parseClinicalUseDefinitionUndesirableEffectComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent();
        this.parseClinicalUseDefinitionUndesirableEffectComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseDefinitionUndesirableEffectComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("symptomConditionEffect")) {
            res.setSymptomConditionEffect(this.parseCodeableReference(this.getJObject(json, "symptomConditionEffect")));
        }
        if (json.has("classification")) {
            res.setClassification(this.parseCodeableConcept(this.getJObject(json, "classification")));
        }
        if (json.has("frequencyOfOccurrence")) {
            res.setFrequencyOfOccurrence(this.parseCodeableConcept(this.getJObject(json, "frequencyOfOccurrence")));
        }
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent parseClinicalUseDefinitionWarningComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent();
        this.parseClinicalUseDefinitionWarningComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseDefinitionWarningComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
    }

    protected CodeSystem parseCodeSystem(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem res = new CodeSystem();
        this.parseCodeSystemProperties(json, res);
        return res;
    }

    protected void parseCodeSystemProperties(JsonObject json, CodeSystem res) throws IOException, FHIRFormatError {
        int i;
        DataType versionAlgorithm;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            JsonArray array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("jurisdiction")) {
            JsonArray array = this.getJArray(json, "jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(json.get("copyrightLabel").getAsString()));
        }
        if (json.has("_copyrightLabel")) {
            this.parseElementProperties(this.getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(this.getJObject(json, "effectivePeriod")));
        }
        if (json.has("topic")) {
            JsonArray array = this.getJArray(json, "topic");
            for (i = 0; i < array.size(); ++i) {
                res.getTopic().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("author")) {
            JsonArray array = this.getJArray(json, "author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("editor")) {
            JsonArray array = this.getJArray(json, "editor");
            for (i = 0; i < array.size(); ++i) {
                res.getEditor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("reviewer")) {
            JsonArray array = this.getJArray(json, "reviewer");
            for (i = 0; i < array.size(); ++i) {
                res.getReviewer().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("endorser")) {
            JsonArray array = this.getJArray(json, "endorser");
            for (i = 0; i < array.size(); ++i) {
                res.getEndorser().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("relatedArtifact")) {
            JsonArray array = this.getJArray(json, "relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("caseSensitive")) {
            res.setCaseSensitiveElement(this.parseBoolean(json.get("caseSensitive").getAsBoolean()));
        }
        if (json.has("_caseSensitive")) {
            this.parseElementProperties(this.getJObject(json, "_caseSensitive"), res.getCaseSensitiveElement());
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseCanonical(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(this.getJObject(json, "_valueSet"), res.getValueSetElement());
        }
        if (json.has("hierarchyMeaning")) {
            res.setHierarchyMeaningElement(this.parseEnumeration(json.get("hierarchyMeaning").getAsString(), CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
        }
        if (json.has("_hierarchyMeaning")) {
            this.parseElementProperties(this.getJObject(json, "_hierarchyMeaning"), res.getHierarchyMeaningElement());
        }
        if (json.has("compositional")) {
            res.setCompositionalElement(this.parseBoolean(json.get("compositional").getAsBoolean()));
        }
        if (json.has("_compositional")) {
            this.parseElementProperties(this.getJObject(json, "_compositional"), res.getCompositionalElement());
        }
        if (json.has("versionNeeded")) {
            res.setVersionNeededElement(this.parseBoolean(json.get("versionNeeded").getAsBoolean()));
        }
        if (json.has("_versionNeeded")) {
            this.parseElementProperties(this.getJObject(json, "_versionNeeded"), res.getVersionNeededElement());
        }
        if (json.has("content")) {
            res.setContentElement(this.parseEnumeration(json.get("content").getAsString(), Enumerations.CodeSystemContentMode.NULL, new Enumerations.CodeSystemContentModeEnumFactory()));
        }
        if (json.has("_content")) {
            this.parseElementProperties(this.getJObject(json, "_content"), res.getContentElement());
        }
        if (json.has("supplements")) {
            res.setSupplementsElement(this.parseCanonical(json.get("supplements").getAsString()));
        }
        if (json.has("_supplements")) {
            this.parseElementProperties(this.getJObject(json, "_supplements"), res.getSupplementsElement());
        }
        if (json.has("count")) {
            res.setCountElement(this.parseUnsignedInt(json.get("count").getAsString()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(this.getJObject(json, "_count"), res.getCountElement());
        }
        if (json.has("filter")) {
            JsonArray array = this.getJArray(json, "filter");
            for (i = 0; i < array.size(); ++i) {
                res.getFilter().add(this.parseCodeSystemFilterComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("property")) {
            JsonArray array = this.getJArray(json, "property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseCodeSystemPropertyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("concept")) {
            JsonArray array = this.getJArray(json, "concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected CodeSystem.CodeSystemFilterComponent parseCodeSystemFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
        this.parseCodeSystemFilterComponentProperties(json, res);
        return res;
    }

    protected void parseCodeSystemFilterComponentProperties(JsonObject json, CodeSystem.CodeSystemFilterComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("operator")) {
            array = this.getJArray(json, "operator");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getOperator().add(new Enumeration<Enumerations.FilterOperator>(new Enumerations.FilterOperatorEnumFactory(), Enumerations.FilterOperator.NULL));
                    continue;
                }
                res.getOperator().add(this.parseEnumeration(array.get(i).getAsString(), Enumerations.FilterOperator.NULL, new Enumerations.FilterOperatorEnumFactory()));
            }
        }
        if (json.has("_operator")) {
            array = this.getJArray(json, "_operator");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getOperator().size()) {
                    res.getOperator().add(this.parseEnumeration(null, Enumerations.FilterOperator.NULL, new Enumerations.FilterOperatorEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getOperator().get(i));
            }
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
        this.parseCodeSystemPropertyComponentProperties(json, res);
        return res;
    }

    protected void parseCodeSystemPropertyComponentProperties(JsonObject json, CodeSystem.PropertyComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(this.getJObject(json, "_uri"), res.getUriElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
    }

    protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
        this.parseCodeSystemConceptDefinitionComponentProperties(json, res);
        return res;
    }

    protected void parseCodeSystemConceptDefinitionComponentProperties(JsonObject json, CodeSystem.ConceptDefinitionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseString(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(this.getJObject(json, "_definition"), res.getDefinitionElement());
        }
        if (json.has("designation")) {
            array = this.getJArray(json, "designation");
            for (i = 0; i < array.size(); ++i) {
                res.getDesignation().add(this.parseCodeSystemConceptDefinitionDesignationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("property")) {
            array = this.getJArray(json, "property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseCodeSystemConceptPropertyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("concept")) {
            array = this.getJArray(json, "concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
        this.parseCodeSystemConceptDefinitionDesignationComponentProperties(json, res);
        return res;
    }

    protected void parseCodeSystemConceptDefinitionDesignationComponentProperties(JsonObject json, CodeSystem.ConceptDefinitionDesignationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(this.getJObject(json, "_language"), res.getLanguageElement());
        }
        if (json.has("use")) {
            res.setUse(this.parseCoding(this.getJObject(json, "use")));
        }
        if (json.has("additionalUse")) {
            JsonArray array = this.getJArray(json, "additionalUse");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdditionalUse().add(this.parseCoding(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
        this.parseCodeSystemConceptPropertyComponentProperties(json, res);
        return res;
    }

    protected void parseCodeSystemConceptPropertyComponentProperties(JsonObject json, CodeSystem.ConceptPropertyComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected Communication parseCommunication(JsonObject json) throws IOException, FHIRFormatError {
        Communication res = new Communication();
        this.parseCommunicationProperties(json, res);
        return res;
    }

    protected void parseCommunicationProperties(JsonObject json, Communication res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("instantiatesCanonical")) {
            array = this.getJArray(json, "instantiatesCanonical");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiatesCanonical().add(new CanonicalType());
                    continue;
                }
                res.getInstantiatesCanonical().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiatesCanonical")) {
            array = this.getJArray(json, "_instantiatesCanonical");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiatesCanonical().size()) {
                    res.getInstantiatesCanonical().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getInstantiatesCanonical().get(i));
            }
        }
        if (json.has("instantiatesUri")) {
            array = this.getJArray(json, "instantiatesUri");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiatesUri().add(new UriType());
                    continue;
                }
                res.getInstantiatesUri().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiatesUri")) {
            array = this.getJArray(json, "_instantiatesUri");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiatesUri().size()) {
                    res.getInstantiatesUri().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getInstantiatesUri().get(i));
            }
        }
        if (json.has("basedOn")) {
            array = this.getJArray(json, "basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("partOf")) {
            array = this.getJArray(json, "partOf");
            for (i = 0; i < array.size(); ++i) {
                res.getPartOf().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("inResponseTo")) {
            array = this.getJArray(json, "inResponseTo");
            for (i = 0; i < array.size(); ++i) {
                res.getInResponseTo().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.EventStatus.NULL, new Enumerations.EventStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(this.getJObject(json, "statusReason")));
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(this.getJObject(json, "_priority"), res.getPriorityElement());
        }
        if (json.has("medium")) {
            array = this.getJArray(json, "medium");
            for (i = 0; i < array.size(); ++i) {
                res.getMedium().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("topic")) {
            res.setTopic(this.parseCodeableConcept(this.getJObject(json, "topic")));
        }
        if (json.has("about")) {
            array = this.getJArray(json, "about");
            for (i = 0; i < array.size(); ++i) {
                res.getAbout().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("sent")) {
            res.setSentElement(this.parseDateTime(json.get("sent").getAsString()));
        }
        if (json.has("_sent")) {
            this.parseElementProperties(this.getJObject(json, "_sent"), res.getSentElement());
        }
        if (json.has("received")) {
            res.setReceivedElement(this.parseDateTime(json.get("received").getAsString()));
        }
        if (json.has("_received")) {
            this.parseElementProperties(this.getJObject(json, "_received"), res.getReceivedElement());
        }
        if (json.has("recipient")) {
            array = this.getJArray(json, "recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("sender")) {
            res.setSender(this.parseReference(this.getJObject(json, "sender")));
        }
        if (json.has("reason")) {
            array = this.getJArray(json, "reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("payload")) {
            array = this.getJArray(json, "payload");
            for (i = 0; i < array.size(); ++i) {
                res.getPayload().add(this.parseCommunicationPayloadComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Communication.CommunicationPayloadComponent parseCommunicationPayloadComponent(JsonObject json) throws IOException, FHIRFormatError {
        Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
        this.parseCommunicationPayloadComponentProperties(json, res);
        return res;
    }

    protected void parseCommunicationPayloadComponentProperties(JsonObject json, Communication.CommunicationPayloadComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected CommunicationRequest parseCommunicationRequest(JsonObject json) throws IOException, FHIRFormatError {
        CommunicationRequest res = new CommunicationRequest();
        this.parseCommunicationRequestProperties(json, res);
        return res;
    }

    protected void parseCommunicationRequestProperties(JsonObject json, CommunicationRequest res) throws IOException, FHIRFormatError {
        int i;
        DataType occurrence;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("basedOn")) {
            array = this.getJArray(json, "basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("replaces")) {
            array = this.getJArray(json, "replaces");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getReplaces().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(this.getJObject(json, "groupIdentifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(this.getJObject(json, "statusReason")));
        }
        if (json.has("intent")) {
            res.setIntentElement(this.parseEnumeration(json.get("intent").getAsString(), Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
        }
        if (json.has("_intent")) {
            this.parseElementProperties(this.getJObject(json, "_intent"), res.getIntentElement());
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(this.getJObject(json, "_priority"), res.getPriorityElement());
        }
        if (json.has("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(json.get("doNotPerform").getAsBoolean()));
        }
        if (json.has("_doNotPerform")) {
            this.parseElementProperties(this.getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
        }
        if (json.has("medium")) {
            array = this.getJArray(json, "medium");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getMedium().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("about")) {
            array = this.getJArray(json, "about");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAbout().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("payload")) {
            array = this.getJArray(json, "payload");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getPayload().add(this.parseCommunicationRequestPayloadComponent(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(json.get("authoredOn").getAsString()));
        }
        if (json.has("_authoredOn")) {
            this.parseElementProperties(this.getJObject(json, "_authoredOn"), res.getAuthoredOnElement());
        }
        if (json.has("requester")) {
            res.setRequester(this.parseReference(this.getJObject(json, "requester")));
        }
        if (json.has("recipient")) {
            JsonArray array2 = this.getJArray(json, "recipient");
            for (i = 0; i < array2.size(); ++i) {
                res.getRecipient().add(this.parseReference(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("informationProvider")) {
            JsonArray array3 = this.getJArray(json, "informationProvider");
            for (i = 0; i < array3.size(); ++i) {
                res.getInformationProvider().add(this.parseReference(this.getJsonObjectFromArray(array3, i)));
            }
        }
        if (json.has("reason")) {
            JsonArray array4 = this.getJArray(json, "reason");
            for (i = 0; i < array4.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(this.getJsonObjectFromArray(array4, i)));
            }
        }
        if (json.has("note")) {
            JsonArray array5 = this.getJArray(json, "note");
            for (i = 0; i < array5.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array5, i)));
            }
        }
    }

    protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestPayloadComponent(JsonObject json) throws IOException, FHIRFormatError {
        CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
        this.parseCommunicationRequestPayloadComponentProperties(json, res);
        return res;
    }

    protected void parseCommunicationRequestPayloadComponentProperties(JsonObject json, CommunicationRequest.CommunicationRequestPayloadComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected CompartmentDefinition parseCompartmentDefinition(JsonObject json) throws IOException, FHIRFormatError {
        CompartmentDefinition res = new CompartmentDefinition();
        this.parseCompartmentDefinitionProperties(json, res);
        return res;
    }

    protected void parseCompartmentDefinitionProperties(JsonObject json, CompartmentDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType versionAlgorithm;
        this.parseCanonicalResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), Enumerations.CompartmentType.NULL, new Enumerations.CompartmentTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("search")) {
            res.setSearchElement(this.parseBoolean(json.get("search").getAsBoolean()));
        }
        if (json.has("_search")) {
            this.parseElementProperties(this.getJObject(json, "_search"), res.getSearchElement());
        }
        if (json.has("resource")) {
            array = this.getJArray(json, "resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseCompartmentDefinitionResourceComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
        CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        this.parseCompartmentDefinitionResourceComponentProperties(json, res);
        return res;
    }

    protected void parseCompartmentDefinitionResourceComponentProperties(JsonObject json, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("param")) {
            array = this.getJArray(json, "param");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getParam().add(new StringType());
                    continue;
                }
                res.getParam().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_param")) {
            array = this.getJArray(json, "_param");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getParam().size()) {
                    res.getParam().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getParam().get(i));
            }
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("startParam")) {
            res.setStartParamElement(this.parseUri(json.get("startParam").getAsString()));
        }
        if (json.has("_startParam")) {
            this.parseElementProperties(this.getJObject(json, "_startParam"), res.getStartParamElement());
        }
        if (json.has("endParam")) {
            res.setEndParamElement(this.parseUri(json.get("endParam").getAsString()));
        }
        if (json.has("_endParam")) {
            this.parseElementProperties(this.getJObject(json, "_endParam"), res.getEndParamElement());
        }
    }

    protected Composition parseComposition(JsonObject json) throws IOException, FHIRFormatError {
        Composition res = new Composition();
        this.parseCompositionProperties(json, res);
        return res;
    }

    protected void parseCompositionProperties(JsonObject json, Composition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.CompositionStatus.NULL, new Enumerations.CompositionStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subject")) {
            array = this.getJArray(json, "subject");
            for (i = 0; i < array.size(); ++i) {
                res.getSubject().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("useContext")) {
            array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("author")) {
            array = this.getJArray(json, "author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("attester")) {
            array = this.getJArray(json, "attester");
            for (i = 0; i < array.size(); ++i) {
                res.getAttester().add(this.parseCompositionAttesterComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(this.getJObject(json, "custodian")));
        }
        if (json.has("relatesTo")) {
            array = this.getJArray(json, "relatesTo");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatesTo().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("event")) {
            array = this.getJArray(json, "event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseCompositionEventComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("section")) {
            array = this.getJArray(json, "section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseCompositionSectionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Composition.CompositionAttesterComponent parseCompositionAttesterComponent(JsonObject json) throws IOException, FHIRFormatError {
        Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
        this.parseCompositionAttesterComponentProperties(json, res);
        return res;
    }

    protected void parseCompositionAttesterComponentProperties(JsonObject json, Composition.CompositionAttesterComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setMode(this.parseCodeableConcept(this.getJObject(json, "mode")));
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(this.getJObject(json, "_time"), res.getTimeElement());
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
    }

    protected Composition.CompositionEventComponent parseCompositionEventComponent(JsonObject json) throws IOException, FHIRFormatError {
        Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
        this.parseCompositionEventComponentProperties(json, res);
        return res;
    }

    protected void parseCompositionEventComponentProperties(JsonObject json, Composition.CompositionEventComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("detail")) {
            JsonArray array = this.getJArray(json, "detail");
            for (int i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Composition.SectionComponent parseCompositionSectionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Composition.SectionComponent res = new Composition.SectionComponent();
        this.parseCompositionSectionComponentProperties(json, res);
        return res;
    }

    protected void parseCompositionSectionComponentProperties(JsonObject json, Composition.SectionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("author")) {
            array = this.getJArray(json, "author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("focus")) {
            res.setFocus(this.parseReference(this.getJObject(json, "focus")));
        }
        if (json.has("text")) {
            res.setText(this.parseNarrative(this.getJObject(json, "text")));
        }
        if (json.has("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(this.getJObject(json, "orderedBy")));
        }
        if (json.has("entry")) {
            array = this.getJArray(json, "entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(this.getJObject(json, "emptyReason")));
        }
        if (json.has("section")) {
            array = this.getJArray(json, "section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseCompositionSectionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ConceptMap parseConceptMap(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap res = new ConceptMap();
        this.parseConceptMapProperties(json, res);
        return res;
    }

    protected void parseConceptMapProperties(JsonObject json, ConceptMap res) throws IOException, FHIRFormatError {
        DataType targetScope;
        DataType sourceScope;
        int i;
        DataType versionAlgorithm;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            JsonArray array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("jurisdiction")) {
            JsonArray array = this.getJArray(json, "jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(json.get("copyrightLabel").getAsString()));
        }
        if (json.has("_copyrightLabel")) {
            this.parseElementProperties(this.getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(this.getJObject(json, "effectivePeriod")));
        }
        if (json.has("topic")) {
            JsonArray array = this.getJArray(json, "topic");
            for (i = 0; i < array.size(); ++i) {
                res.getTopic().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("author")) {
            JsonArray array = this.getJArray(json, "author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("editor")) {
            JsonArray array = this.getJArray(json, "editor");
            for (i = 0; i < array.size(); ++i) {
                res.getEditor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("reviewer")) {
            JsonArray array = this.getJArray(json, "reviewer");
            for (i = 0; i < array.size(); ++i) {
                res.getReviewer().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("endorser")) {
            JsonArray array = this.getJArray(json, "endorser");
            for (i = 0; i < array.size(); ++i) {
                res.getEndorser().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("relatedArtifact")) {
            JsonArray array = this.getJArray(json, "relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("property")) {
            JsonArray array = this.getJArray(json, "property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseConceptMapPropertyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("additionalAttribute")) {
            JsonArray array = this.getJArray(json, "additionalAttribute");
            for (i = 0; i < array.size(); ++i) {
                res.getAdditionalAttribute().add(this.parseConceptMapAdditionalAttributeComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if ((sourceScope = this.parseType("sourceScope", json)) != null) {
            res.setSourceScope(sourceScope);
        }
        if ((targetScope = this.parseType("targetScope", json)) != null) {
            res.setTargetScope(targetScope);
        }
        if (json.has("group")) {
            JsonArray array = this.getJArray(json, "group");
            for (int i3 = 0; i3 < array.size(); ++i3) {
                res.getGroup().add(this.parseConceptMapGroupComponent(this.getJsonObjectFromArray(array, i3)));
            }
        }
    }

    protected ConceptMap.PropertyComponent parseConceptMapPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.PropertyComponent res = new ConceptMap.PropertyComponent();
        this.parseConceptMapPropertyComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapPropertyComponentProperties(JsonObject json, ConceptMap.PropertyComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(this.getJObject(json, "_uri"), res.getUriElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ConceptMap.ConceptMapPropertyType.NULL, new ConceptMap.ConceptMapPropertyTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseCanonical(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(this.getJObject(json, "_system"), res.getSystemElement());
        }
    }

    protected ConceptMap.AdditionalAttributeComponent parseConceptMapAdditionalAttributeComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.AdditionalAttributeComponent res = new ConceptMap.AdditionalAttributeComponent();
        this.parseConceptMapAdditionalAttributeComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapAdditionalAttributeComponentProperties(JsonObject json, ConceptMap.AdditionalAttributeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(this.getJObject(json, "_uri"), res.getUriElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ConceptMap.ConceptMapAttributeType.NULL, new ConceptMap.ConceptMapAttributeTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
    }

    protected ConceptMap.ConceptMapGroupComponent parseConceptMapGroupComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
        this.parseConceptMapGroupComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapGroupComponentProperties(JsonObject json, ConceptMap.ConceptMapGroupComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("source")) {
            res.setSourceElement(this.parseCanonical(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(this.getJObject(json, "_source"), res.getSourceElement());
        }
        if (json.has("target")) {
            res.setTargetElement(this.parseCanonical(json.get("target").getAsString()));
        }
        if (json.has("_target")) {
            this.parseElementProperties(this.getJObject(json, "_target"), res.getTargetElement());
        }
        if (json.has("element")) {
            JsonArray array = this.getJArray(json, "element");
            for (int i = 0; i < array.size(); ++i) {
                res.getElement().add(this.parseConceptMapSourceElementComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("unmapped")) {
            res.setUnmapped(this.parseConceptMapGroupUnmappedComponent(this.getJObject(json, "unmapped")));
        }
    }

    protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
        this.parseConceptMapSourceElementComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapSourceElementComponentProperties(JsonObject json, ConceptMap.SourceElementComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseCanonical(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(this.getJObject(json, "_valueSet"), res.getValueSetElement());
        }
        if (json.has("noMap")) {
            res.setNoMapElement(this.parseBoolean(json.get("noMap").getAsBoolean()));
        }
        if (json.has("_noMap")) {
            this.parseElementProperties(this.getJObject(json, "_noMap"), res.getNoMapElement());
        }
        if (json.has("target")) {
            JsonArray array = this.getJArray(json, "target");
            for (int i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseConceptMapTargetElementComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
        this.parseConceptMapTargetElementComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapTargetElementComponentProperties(JsonObject json, ConceptMap.TargetElementComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseCanonical(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(this.getJObject(json, "_valueSet"), res.getValueSetElement());
        }
        if (json.has("relationship")) {
            res.setRelationshipElement(this.parseEnumeration(json.get("relationship").getAsString(), Enumerations.ConceptMapRelationship.NULL, new Enumerations.ConceptMapRelationshipEnumFactory()));
        }
        if (json.has("_relationship")) {
            this.parseElementProperties(this.getJObject(json, "_relationship"), res.getRelationshipElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
        if (json.has("property")) {
            array = this.getJArray(json, "property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseConceptMapMappingPropertyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("dependsOn")) {
            array = this.getJArray(json, "dependsOn");
            for (i = 0; i < array.size(); ++i) {
                res.getDependsOn().add(this.parseConceptMapOtherElementComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("product")) {
            array = this.getJArray(json, "product");
            for (i = 0; i < array.size(); ++i) {
                res.getProduct().add(this.parseConceptMapOtherElementComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ConceptMap.MappingPropertyComponent parseConceptMapMappingPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.MappingPropertyComponent res = new ConceptMap.MappingPropertyComponent();
        this.parseConceptMapMappingPropertyComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapMappingPropertyComponentProperties(JsonObject json, ConceptMap.MappingPropertyComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
        this.parseConceptMapOtherElementComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapOtherElementComponentProperties(JsonObject json, ConceptMap.OtherElementComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("attribute")) {
            res.setAttributeElement(this.parseCode(json.get("attribute").getAsString()));
        }
        if (json.has("_attribute")) {
            this.parseElementProperties(this.getJObject(json, "_attribute"), res.getAttributeElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseCanonical(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(this.getJObject(json, "_valueSet"), res.getValueSetElement());
        }
    }

    protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapGroupUnmappedComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
        this.parseConceptMapGroupUnmappedComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapGroupUnmappedComponentProperties(JsonObject json, ConceptMap.ConceptMapGroupUnmappedComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseCanonical(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(this.getJObject(json, "_valueSet"), res.getValueSetElement());
        }
        if (json.has("relationship")) {
            res.setRelationshipElement(this.parseEnumeration(json.get("relationship").getAsString(), Enumerations.ConceptMapRelationship.NULL, new Enumerations.ConceptMapRelationshipEnumFactory()));
        }
        if (json.has("_relationship")) {
            this.parseElementProperties(this.getJObject(json, "_relationship"), res.getRelationshipElement());
        }
        if (json.has("otherMap")) {
            res.setOtherMapElement(this.parseCanonical(json.get("otherMap").getAsString()));
        }
        if (json.has("_otherMap")) {
            this.parseElementProperties(this.getJObject(json, "_otherMap"), res.getOtherMapElement());
        }
    }

    protected Condition parseCondition(JsonObject json) throws IOException, FHIRFormatError {
        Condition res = new Condition();
        this.parseConditionProperties(json, res);
        return res;
    }

    protected void parseConditionProperties(JsonObject json, Condition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType abatement;
        DataType onset;
        int i2;
        JsonArray array2;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array2 = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("clinicalStatus")) {
            res.setClinicalStatus(this.parseCodeableConcept(this.getJObject(json, "clinicalStatus")));
        }
        if (json.has("verificationStatus")) {
            res.setVerificationStatus(this.parseCodeableConcept(this.getJObject(json, "verificationStatus")));
        }
        if (json.has("category")) {
            array2 = this.getJArray(json, "category");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("severity")) {
            res.setSeverity(this.parseCodeableConcept(this.getJObject(json, "severity")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("bodySite")) {
            array2 = this.getJArray(json, "bodySite");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getBodySite().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((onset = this.parseType("onset", json)) != null) {
            res.setOnset(onset);
        }
        if ((abatement = this.parseType("abatement", json)) != null) {
            res.setAbatement(abatement);
        }
        if (json.has("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(json.get("recordedDate").getAsString()));
        }
        if (json.has("_recordedDate")) {
            this.parseElementProperties(this.getJObject(json, "_recordedDate"), res.getRecordedDateElement());
        }
        if (json.has("participant")) {
            array = this.getJArray(json, "participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseConditionParticipantComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("stage")) {
            array = this.getJArray(json, "stage");
            for (i = 0; i < array.size(); ++i) {
                res.getStage().add(this.parseConditionStageComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("evidence")) {
            array = this.getJArray(json, "evidence");
            for (i = 0; i < array.size(); ++i) {
                res.getEvidence().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Condition.ConditionParticipantComponent parseConditionParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
        Condition.ConditionParticipantComponent res = new Condition.ConditionParticipantComponent();
        this.parseConditionParticipantComponentProperties(json, res);
        return res;
    }

    protected void parseConditionParticipantComponentProperties(JsonObject json, Condition.ConditionParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("function")) {
            res.setFunction(this.parseCodeableConcept(this.getJObject(json, "function")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
    }

    protected Condition.ConditionStageComponent parseConditionStageComponent(JsonObject json) throws IOException, FHIRFormatError {
        Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
        this.parseConditionStageComponentProperties(json, res);
        return res;
    }

    protected void parseConditionStageComponentProperties(JsonObject json, Condition.ConditionStageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("summary")) {
            res.setSummary(this.parseCodeableConcept(this.getJObject(json, "summary")));
        }
        if (json.has("assessment")) {
            JsonArray array = this.getJArray(json, "assessment");
            for (int i = 0; i < array.size(); ++i) {
                res.getAssessment().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
    }

    protected ConditionDefinition parseConditionDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ConditionDefinition res = new ConditionDefinition();
        this.parseConditionDefinitionProperties(json, res);
        return res;
    }

    protected void parseConditionDefinitionProperties(JsonObject json, ConditionDefinition res) throws IOException, FHIRFormatError {
        int i;
        DataType versionAlgorithm;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("subtitle")) {
            res.setSubtitleElement(this.parseString(json.get("subtitle").getAsString()));
        }
        if (json.has("_subtitle")) {
            this.parseElementProperties(this.getJObject(json, "_subtitle"), res.getSubtitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            JsonArray array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("jurisdiction")) {
            JsonArray array = this.getJArray(json, "jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("severity")) {
            res.setSeverity(this.parseCodeableConcept(this.getJObject(json, "severity")));
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(this.getJObject(json, "bodySite")));
        }
        if (json.has("stage")) {
            res.setStage(this.parseCodeableConcept(this.getJObject(json, "stage")));
        }
        if (json.has("hasSeverity")) {
            res.setHasSeverityElement(this.parseBoolean(json.get("hasSeverity").getAsBoolean()));
        }
        if (json.has("_hasSeverity")) {
            this.parseElementProperties(this.getJObject(json, "_hasSeverity"), res.getHasSeverityElement());
        }
        if (json.has("hasBodySite")) {
            res.setHasBodySiteElement(this.parseBoolean(json.get("hasBodySite").getAsBoolean()));
        }
        if (json.has("_hasBodySite")) {
            this.parseElementProperties(this.getJObject(json, "_hasBodySite"), res.getHasBodySiteElement());
        }
        if (json.has("hasStage")) {
            res.setHasStageElement(this.parseBoolean(json.get("hasStage").getAsBoolean()));
        }
        if (json.has("_hasStage")) {
            this.parseElementProperties(this.getJObject(json, "_hasStage"), res.getHasStageElement());
        }
        if (json.has("definition")) {
            JsonArray array = this.getJArray(json, "definition");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getDefinition().add(new UriType());
                    continue;
                }
                res.getDefinition().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_definition")) {
            JsonArray array = this.getJArray(json, "_definition");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDefinition().size()) {
                    res.getDefinition().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getDefinition().get(i));
            }
        }
        if (json.has("observation")) {
            JsonArray array = this.getJArray(json, "observation");
            for (i = 0; i < array.size(); ++i) {
                res.getObservation().add(this.parseConditionDefinitionObservationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("medication")) {
            JsonArray array = this.getJArray(json, "medication");
            for (i = 0; i < array.size(); ++i) {
                res.getMedication().add(this.parseConditionDefinitionMedicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("precondition")) {
            JsonArray array = this.getJArray(json, "precondition");
            for (i = 0; i < array.size(); ++i) {
                res.getPrecondition().add(this.parseConditionDefinitionPreconditionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("team")) {
            JsonArray array = this.getJArray(json, "team");
            for (i = 0; i < array.size(); ++i) {
                res.getTeam().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("questionnaire")) {
            JsonArray array = this.getJArray(json, "questionnaire");
            for (i = 0; i < array.size(); ++i) {
                res.getQuestionnaire().add(this.parseConditionDefinitionQuestionnaireComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("plan")) {
            JsonArray array = this.getJArray(json, "plan");
            for (i = 0; i < array.size(); ++i) {
                res.getPlan().add(this.parseConditionDefinitionPlanComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ConditionDefinition.ConditionDefinitionObservationComponent parseConditionDefinitionObservationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionObservationComponent res = new ConditionDefinition.ConditionDefinitionObservationComponent();
        this.parseConditionDefinitionObservationComponentProperties(json, res);
        return res;
    }

    protected void parseConditionDefinitionObservationComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionObservationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
    }

    protected ConditionDefinition.ConditionDefinitionMedicationComponent parseConditionDefinitionMedicationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionMedicationComponent res = new ConditionDefinition.ConditionDefinitionMedicationComponent();
        this.parseConditionDefinitionMedicationComponentProperties(json, res);
        return res;
    }

    protected void parseConditionDefinitionMedicationComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionMedicationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
    }

    protected ConditionDefinition.ConditionDefinitionPreconditionComponent parseConditionDefinitionPreconditionComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionPreconditionComponent res = new ConditionDefinition.ConditionDefinitionPreconditionComponent();
        this.parseConditionDefinitionPreconditionComponentProperties(json, res);
        return res;
    }

    protected void parseConditionDefinitionPreconditionComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionPreconditionComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ConditionDefinition.ConditionPreconditionType.NULL, new ConditionDefinition.ConditionPreconditionTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected ConditionDefinition.ConditionDefinitionQuestionnaireComponent parseConditionDefinitionQuestionnaireComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionQuestionnaireComponent res = new ConditionDefinition.ConditionDefinitionQuestionnaireComponent();
        this.parseConditionDefinitionQuestionnaireComponentProperties(json, res);
        return res;
    }

    protected void parseConditionDefinitionQuestionnaireComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionQuestionnaireComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseEnumeration(json.get("purpose").getAsString(), ConditionDefinition.ConditionQuestionnairePurpose.NULL, new ConditionDefinition.ConditionQuestionnairePurposeEnumFactory()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
    }

    protected ConditionDefinition.ConditionDefinitionPlanComponent parseConditionDefinitionPlanComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionPlanComponent res = new ConditionDefinition.ConditionDefinitionPlanComponent();
        this.parseConditionDefinitionPlanComponentProperties(json, res);
        return res;
    }

    protected void parseConditionDefinitionPlanComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionPlanComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
    }

    protected Consent parseConsent(JsonObject json) throws IOException, FHIRFormatError {
        Consent res = new Consent();
        this.parseConsentProperties(json, res);
        return res;
    }

    protected void parseConsentProperties(JsonObject json, Consent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("grantor")) {
            array = this.getJArray(json, "grantor");
            for (i = 0; i < array.size(); ++i) {
                res.getGrantor().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("grantee")) {
            array = this.getJArray(json, "grantee");
            for (i = 0; i < array.size(); ++i) {
                res.getGrantee().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("manager")) {
            array = this.getJArray(json, "manager");
            for (i = 0; i < array.size(); ++i) {
                res.getManager().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("controller")) {
            array = this.getJArray(json, "controller");
            for (i = 0; i < array.size(); ++i) {
                res.getController().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("sourceAttachment")) {
            array = this.getJArray(json, "sourceAttachment");
            for (i = 0; i < array.size(); ++i) {
                res.getSourceAttachment().add(this.parseAttachment(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("sourceReference")) {
            array = this.getJArray(json, "sourceReference");
            for (i = 0; i < array.size(); ++i) {
                res.getSourceReference().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("regulatoryBasis")) {
            array = this.getJArray(json, "regulatoryBasis");
            for (i = 0; i < array.size(); ++i) {
                res.getRegulatoryBasis().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("policyBasis")) {
            res.setPolicyBasis(this.parseConsentPolicyBasisComponent(this.getJObject(json, "policyBasis")));
        }
        if (json.has("policyText")) {
            array = this.getJArray(json, "policyText");
            for (i = 0; i < array.size(); ++i) {
                res.getPolicyText().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("verification")) {
            array = this.getJArray(json, "verification");
            for (i = 0; i < array.size(); ++i) {
                res.getVerification().add(this.parseConsentVerificationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("decision")) {
            res.setDecisionElement(this.parseEnumeration(json.get("decision").getAsString(), Enumerations.ConsentProvisionType.NULL, new Enumerations.ConsentProvisionTypeEnumFactory()));
        }
        if (json.has("_decision")) {
            this.parseElementProperties(this.getJObject(json, "_decision"), res.getDecisionElement());
        }
        if (json.has("provision")) {
            array = this.getJArray(json, "provision");
            for (i = 0; i < array.size(); ++i) {
                res.getProvision().add(this.parseConsentProvisionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Consent.ConsentPolicyBasisComponent parseConsentPolicyBasisComponent(JsonObject json) throws IOException, FHIRFormatError {
        Consent.ConsentPolicyBasisComponent res = new Consent.ConsentPolicyBasisComponent();
        this.parseConsentPolicyBasisComponentProperties(json, res);
        return res;
    }

    protected void parseConsentPolicyBasisComponentProperties(JsonObject json, Consent.ConsentPolicyBasisComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUrl(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
    }

    protected Consent.ConsentVerificationComponent parseConsentVerificationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Consent.ConsentVerificationComponent res = new Consent.ConsentVerificationComponent();
        this.parseConsentVerificationComponentProperties(json, res);
        return res;
    }

    protected void parseConsentVerificationComponentProperties(JsonObject json, Consent.ConsentVerificationComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("verified")) {
            res.setVerifiedElement(this.parseBoolean(json.get("verified").getAsBoolean()));
        }
        if (json.has("_verified")) {
            this.parseElementProperties(this.getJObject(json, "_verified"), res.getVerifiedElement());
        }
        if (json.has("verificationType")) {
            res.setVerificationType(this.parseCodeableConcept(this.getJObject(json, "verificationType")));
        }
        if (json.has("verifiedBy")) {
            res.setVerifiedBy(this.parseReference(this.getJObject(json, "verifiedBy")));
        }
        if (json.has("verifiedWith")) {
            res.setVerifiedWith(this.parseReference(this.getJObject(json, "verifiedWith")));
        }
        if (json.has("verificationDate")) {
            array = this.getJArray(json, "verificationDate");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getVerificationDate().add(new DateTimeType());
                    continue;
                }
                res.getVerificationDate().add(this.parseDateTime(array.get(i).getAsString()));
            }
        }
        if (json.has("_verificationDate")) {
            array = this.getJArray(json, "_verificationDate");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getVerificationDate().size()) {
                    res.getVerificationDate().add(this.parseDateTime(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getVerificationDate().get(i));
            }
        }
    }

    protected Consent.ProvisionComponent parseConsentProvisionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Consent.ProvisionComponent res = new Consent.ProvisionComponent();
        this.parseConsentProvisionComponentProperties(json, res);
        return res;
    }

    protected void parseConsentProvisionComponentProperties(JsonObject json, Consent.ProvisionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("actor")) {
            array = this.getJArray(json, "actor");
            for (i = 0; i < array.size(); ++i) {
                res.getActor().add(this.parseConsentProvisionActorComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("action")) {
            array = this.getJArray(json, "action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("securityLabel")) {
            array = this.getJArray(json, "securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCoding(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("purpose")) {
            array = this.getJArray(json, "purpose");
            for (i = 0; i < array.size(); ++i) {
                res.getPurpose().add(this.parseCoding(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("documentType")) {
            array = this.getJArray(json, "documentType");
            for (i = 0; i < array.size(); ++i) {
                res.getDocumentType().add(this.parseCoding(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("resourceType")) {
            array = this.getJArray(json, "resourceType");
            for (i = 0; i < array.size(); ++i) {
                res.getResourceType().add(this.parseCoding(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("code")) {
            array = this.getJArray(json, "code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("dataPeriod")) {
            res.setDataPeriod(this.parsePeriod(this.getJObject(json, "dataPeriod")));
        }
        if (json.has("data")) {
            array = this.getJArray(json, "data");
            for (i = 0; i < array.size(); ++i) {
                res.getData().add(this.parseConsentProvisionDataComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("expression")) {
            res.setExpression(this.parseExpression(this.getJObject(json, "expression")));
        }
        if (json.has("provision")) {
            array = this.getJArray(json, "provision");
            for (i = 0; i < array.size(); ++i) {
                res.getProvision().add(this.parseConsentProvisionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Consent.ProvisionActorComponent parseConsentProvisionActorComponent(JsonObject json) throws IOException, FHIRFormatError {
        Consent.ProvisionActorComponent res = new Consent.ProvisionActorComponent();
        this.parseConsentProvisionActorComponentProperties(json, res);
        return res;
    }

    protected void parseConsentProvisionActorComponentProperties(JsonObject json, Consent.ProvisionActorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
    }

    protected Consent.ProvisionDataComponent parseConsentProvisionDataComponent(JsonObject json) throws IOException, FHIRFormatError {
        Consent.ProvisionDataComponent res = new Consent.ProvisionDataComponent();
        this.parseConsentProvisionDataComponentProperties(json, res);
        return res;
    }

    protected void parseConsentProvisionDataComponentProperties(JsonObject json, Consent.ProvisionDataComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("meaning")) {
            res.setMeaningElement(this.parseEnumeration(json.get("meaning").getAsString(), Enumerations.ConsentDataMeaning.NULL, new Enumerations.ConsentDataMeaningEnumFactory()));
        }
        if (json.has("_meaning")) {
            this.parseElementProperties(this.getJObject(json, "_meaning"), res.getMeaningElement());
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
    }

    protected Contract parseContract(JsonObject json) throws IOException, FHIRFormatError {
        Contract res = new Contract();
        this.parseContractProperties(json, res);
        return res;
    }

    protected void parseContractProperties(JsonObject json, Contract res) throws IOException, FHIRFormatError {
        DataType legallyBinding;
        int i;
        DataType topic;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Contract.ContractResourceStatusCodes.NULL, new Contract.ContractResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("legalState")) {
            res.setLegalState(this.parseCodeableConcept(this.getJObject(json, "legalState")));
        }
        if (json.has("instantiatesCanonical")) {
            res.setInstantiatesCanonical(this.parseReference(this.getJObject(json, "instantiatesCanonical")));
        }
        if (json.has("instantiatesUri")) {
            res.setInstantiatesUriElement(this.parseUri(json.get("instantiatesUri").getAsString()));
        }
        if (json.has("_instantiatesUri")) {
            this.parseElementProperties(this.getJObject(json, "_instantiatesUri"), res.getInstantiatesUriElement());
        }
        if (json.has("contentDerivative")) {
            res.setContentDerivative(this.parseCodeableConcept(this.getJObject(json, "contentDerivative")));
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseDateTime(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(this.getJObject(json, "_issued"), res.getIssuedElement());
        }
        if (json.has("applies")) {
            res.setApplies(this.parsePeriod(this.getJObject(json, "applies")));
        }
        if (json.has("expirationType")) {
            res.setExpirationType(this.parseCodeableConcept(this.getJObject(json, "expirationType")));
        }
        if (json.has("subject")) {
            array = this.getJArray(json, "subject");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSubject().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("authority")) {
            array = this.getJArray(json, "authority");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAuthority().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("domain")) {
            array = this.getJArray(json, "domain");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDomain().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("site")) {
            array = this.getJArray(json, "site");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSite().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("subtitle")) {
            res.setSubtitleElement(this.parseString(json.get("subtitle").getAsString()));
        }
        if (json.has("_subtitle")) {
            this.parseElementProperties(this.getJObject(json, "_subtitle"), res.getSubtitleElement());
        }
        if (json.has("alias")) {
            array = this.getJArray(json, "alias");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getAlias().add(new StringType());
                    continue;
                }
                res.getAlias().add(this.parseString(array.get(i2).getAsString()));
            }
        }
        if (json.has("_alias")) {
            array = this.getJArray(json, "_alias");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getAlias().size()) {
                    res.getAlias().add(this.parseString(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i2), res.getAlias().get(i2));
            }
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
        if (json.has("scope")) {
            res.setScope(this.parseCodeableConcept(this.getJObject(json, "scope")));
        }
        if ((topic = this.parseType("topic", json)) != null) {
            res.setTopic(topic);
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subType")) {
            JsonArray array2 = this.getJArray(json, "subType");
            for (i = 0; i < array2.size(); ++i) {
                res.getSubType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("contentDefinition")) {
            res.setContentDefinition(this.parseContractContentDefinitionComponent(this.getJObject(json, "contentDefinition")));
        }
        if (json.has("term")) {
            JsonArray array3 = this.getJArray(json, "term");
            for (i = 0; i < array3.size(); ++i) {
                res.getTerm().add(this.parseContractTermComponent(this.getJsonObjectFromArray(array3, i)));
            }
        }
        if (json.has("supportingInfo")) {
            JsonArray array4 = this.getJArray(json, "supportingInfo");
            for (i = 0; i < array4.size(); ++i) {
                res.getSupportingInfo().add(this.parseReference(this.getJsonObjectFromArray(array4, i)));
            }
        }
        if (json.has("relevantHistory")) {
            JsonArray array5 = this.getJArray(json, "relevantHistory");
            for (i = 0; i < array5.size(); ++i) {
                res.getRelevantHistory().add(this.parseReference(this.getJsonObjectFromArray(array5, i)));
            }
        }
        if (json.has("signer")) {
            JsonArray array6 = this.getJArray(json, "signer");
            for (i = 0; i < array6.size(); ++i) {
                res.getSigner().add(this.parseContractSignatoryComponent(this.getJsonObjectFromArray(array6, i)));
            }
        }
        if (json.has("friendly")) {
            JsonArray array7 = this.getJArray(json, "friendly");
            for (i = 0; i < array7.size(); ++i) {
                res.getFriendly().add(this.parseContractFriendlyLanguageComponent(this.getJsonObjectFromArray(array7, i)));
            }
        }
        if (json.has("legal")) {
            JsonArray array8 = this.getJArray(json, "legal");
            for (i = 0; i < array8.size(); ++i) {
                res.getLegal().add(this.parseContractLegalLanguageComponent(this.getJsonObjectFromArray(array8, i)));
            }
        }
        if (json.has("rule")) {
            JsonArray array9 = this.getJArray(json, "rule");
            for (i = 0; i < array9.size(); ++i) {
                res.getRule().add(this.parseContractComputableLanguageComponent(this.getJsonObjectFromArray(array9, i)));
            }
        }
        if ((legallyBinding = this.parseType("legallyBinding", json)) != null) {
            res.setLegallyBinding(legallyBinding);
        }
    }

    protected Contract.ContentDefinitionComponent parseContractContentDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ContentDefinitionComponent res = new Contract.ContentDefinitionComponent();
        this.parseContractContentDefinitionComponentProperties(json, res);
        return res;
    }

    protected void parseContractContentDefinitionComponentProperties(JsonObject json, Contract.ContentDefinitionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(this.getJObject(json, "subType")));
        }
        if (json.has("publisher")) {
            res.setPublisher(this.parseReference(this.getJObject(json, "publisher")));
        }
        if (json.has("publicationDate")) {
            res.setPublicationDateElement(this.parseDateTime(json.get("publicationDate").getAsString()));
        }
        if (json.has("_publicationDate")) {
            this.parseElementProperties(this.getJObject(json, "_publicationDate"), res.getPublicationDateElement());
        }
        if (json.has("publicationStatus")) {
            res.setPublicationStatusElement(this.parseEnumeration(json.get("publicationStatus").getAsString(), Contract.ContractResourcePublicationStatusCodes.NULL, new Contract.ContractResourcePublicationStatusCodesEnumFactory()));
        }
        if (json.has("_publicationStatus")) {
            this.parseElementProperties(this.getJObject(json, "_publicationStatus"), res.getPublicationStatusElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
    }

    protected Contract.TermComponent parseContractTermComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.TermComponent res = new Contract.TermComponent();
        this.parseContractTermComponentProperties(json, res);
        return res;
    }

    protected void parseContractTermComponentProperties(JsonObject json, Contract.TermComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType topic;
        this.parseBackboneElementProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseDateTime(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(this.getJObject(json, "_issued"), res.getIssuedElement());
        }
        if (json.has("applies")) {
            res.setApplies(this.parsePeriod(this.getJObject(json, "applies")));
        }
        if ((topic = this.parseType("topic", json)) != null) {
            res.setTopic(topic);
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(this.getJObject(json, "subType")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("securityLabel")) {
            array = this.getJArray(json, "securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseContractSecurityLabelComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("offer")) {
            res.setOffer(this.parseContractOfferComponent(this.getJObject(json, "offer")));
        }
        if (json.has("asset")) {
            array = this.getJArray(json, "asset");
            for (i = 0; i < array.size(); ++i) {
                res.getAsset().add(this.parseContractAssetComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("action")) {
            array = this.getJArray(json, "action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseContractActionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("group")) {
            array = this.getJArray(json, "group");
            for (i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseContractTermComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Contract.SecurityLabelComponent parseContractSecurityLabelComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.SecurityLabelComponent res = new Contract.SecurityLabelComponent();
        this.parseContractSecurityLabelComponentProperties(json, res);
        return res;
    }

    protected void parseContractSecurityLabelComponentProperties(JsonObject json, Contract.SecurityLabelComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("number")) {
            array = this.getJArray(json, "number");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNumber().add(new UnsignedIntType());
                    continue;
                }
                res.getNumber().add(this.parseUnsignedInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_number")) {
            array = this.getJArray(json, "_number");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNumber().size()) {
                    res.getNumber().add(this.parseUnsignedInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNumber().get(i));
            }
        }
        if (json.has("classification")) {
            res.setClassification(this.parseCoding(this.getJObject(json, "classification")));
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCoding(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("control")) {
            array = this.getJArray(json, "control");
            for (i = 0; i < array.size(); ++i) {
                res.getControl().add(this.parseCoding(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Contract.ContractOfferComponent parseContractOfferComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ContractOfferComponent res = new Contract.ContractOfferComponent();
        this.parseContractOfferComponentProperties(json, res);
        return res;
    }

    protected void parseContractOfferComponentProperties(JsonObject json, Contract.ContractOfferComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("party")) {
            array = this.getJArray(json, "party");
            for (i = 0; i < array.size(); ++i) {
                res.getParty().add(this.parseContractPartyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("topic")) {
            res.setTopic(this.parseReference(this.getJObject(json, "topic")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("decision")) {
            res.setDecision(this.parseCodeableConcept(this.getJObject(json, "decision")));
        }
        if (json.has("decisionMode")) {
            array = this.getJArray(json, "decisionMode");
            for (i = 0; i < array.size(); ++i) {
                res.getDecisionMode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("answer")) {
            array = this.getJArray(json, "answer");
            for (i = 0; i < array.size(); ++i) {
                res.getAnswer().add(this.parseContractAnswerComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("linkId")) {
            array = this.getJArray(json, "linkId");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getLinkId().add(new StringType());
                    continue;
                }
                res.getLinkId().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_linkId")) {
            array = this.getJArray(json, "_linkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLinkId().size()) {
                    res.getLinkId().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getLinkId().get(i));
            }
        }
        if (json.has("securityLabelNumber")) {
            array = this.getJArray(json, "securityLabelNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSecurityLabelNumber().add(new UnsignedIntType());
                    continue;
                }
                res.getSecurityLabelNumber().add(this.parseUnsignedInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_securityLabelNumber")) {
            array = this.getJArray(json, "_securityLabelNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSecurityLabelNumber().size()) {
                    res.getSecurityLabelNumber().add(this.parseUnsignedInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getSecurityLabelNumber().get(i));
            }
        }
    }

    protected Contract.ContractPartyComponent parseContractPartyComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ContractPartyComponent res = new Contract.ContractPartyComponent();
        this.parseContractPartyComponentProperties(json, res);
        return res;
    }

    protected void parseContractPartyComponentProperties(JsonObject json, Contract.ContractPartyComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("reference")) {
            JsonArray array = this.getJArray(json, "reference");
            for (int i = 0; i < array.size(); ++i) {
                res.getReference().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
    }

    protected Contract.AnswerComponent parseContractAnswerComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.AnswerComponent res = new Contract.AnswerComponent();
        this.parseContractAnswerComponentProperties(json, res);
        return res;
    }

    protected void parseContractAnswerComponentProperties(JsonObject json, Contract.AnswerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType value = this.parseType("value", json);
        if (value != null) {
            res.setValue(value);
        }
    }

    protected Contract.ContractAssetComponent parseContractAssetComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ContractAssetComponent res = new Contract.ContractAssetComponent();
        this.parseContractAssetComponentProperties(json, res);
        return res;
    }

    protected void parseContractAssetComponentProperties(JsonObject json, Contract.ContractAssetComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("scope")) {
            res.setScope(this.parseCodeableConcept(this.getJObject(json, "scope")));
        }
        if (json.has("type")) {
            array = this.getJArray(json, "type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("typeReference")) {
            array = this.getJArray(json, "typeReference");
            for (i = 0; i < array.size(); ++i) {
                res.getTypeReference().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subtype")) {
            array = this.getJArray(json, "subtype");
            for (i = 0; i < array.size(); ++i) {
                res.getSubtype().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCoding(this.getJObject(json, "relationship")));
        }
        if (json.has("context")) {
            array = this.getJArray(json, "context");
            for (i = 0; i < array.size(); ++i) {
                res.getContext().add(this.parseContractAssetContextComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("condition")) {
            res.setConditionElement(this.parseString(json.get("condition").getAsString()));
        }
        if (json.has("_condition")) {
            this.parseElementProperties(this.getJObject(json, "_condition"), res.getConditionElement());
        }
        if (json.has("periodType")) {
            array = this.getJArray(json, "periodType");
            for (i = 0; i < array.size(); ++i) {
                res.getPeriodType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("period")) {
            array = this.getJArray(json, "period");
            for (i = 0; i < array.size(); ++i) {
                res.getPeriod().add(this.parsePeriod(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("usePeriod")) {
            array = this.getJArray(json, "usePeriod");
            for (i = 0; i < array.size(); ++i) {
                res.getUsePeriod().add(this.parsePeriod(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("linkId")) {
            array = this.getJArray(json, "linkId");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getLinkId().add(new StringType());
                    continue;
                }
                res.getLinkId().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_linkId")) {
            array = this.getJArray(json, "_linkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLinkId().size()) {
                    res.getLinkId().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getLinkId().get(i));
            }
        }
        if (json.has("answer")) {
            array = this.getJArray(json, "answer");
            for (i = 0; i < array.size(); ++i) {
                res.getAnswer().add(this.parseContractAnswerComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("securityLabelNumber")) {
            array = this.getJArray(json, "securityLabelNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSecurityLabelNumber().add(new UnsignedIntType());
                    continue;
                }
                res.getSecurityLabelNumber().add(this.parseUnsignedInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_securityLabelNumber")) {
            array = this.getJArray(json, "_securityLabelNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSecurityLabelNumber().size()) {
                    res.getSecurityLabelNumber().add(this.parseUnsignedInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getSecurityLabelNumber().get(i));
            }
        }
        if (json.has("valuedItem")) {
            array = this.getJArray(json, "valuedItem");
            for (i = 0; i < array.size(); ++i) {
                res.getValuedItem().add(this.parseContractValuedItemComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Contract.AssetContextComponent parseContractAssetContextComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.AssetContextComponent res = new Contract.AssetContextComponent();
        this.parseContractAssetContextComponentProperties(json, res);
        return res;
    }

    protected void parseContractAssetContextComponentProperties(JsonObject json, Contract.AssetContextComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
        if (json.has("code")) {
            JsonArray array = this.getJArray(json, "code");
            for (int i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
    }

    protected Contract.ValuedItemComponent parseContractValuedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
        this.parseContractValuedItemComponentProperties(json, res);
        return res;
    }

    protected void parseContractValuedItemComponentProperties(JsonObject json, Contract.ValuedItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        DataType entity = this.parseType("entity", json);
        if (entity != null) {
            res.setEntity(entity);
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("effectiveTime")) {
            res.setEffectiveTimeElement(this.parseDateTime(json.get("effectiveTime").getAsString()));
        }
        if (json.has("_effectiveTime")) {
            this.parseElementProperties(this.getJObject(json, "_effectiveTime"), res.getEffectiveTimeElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(this.getJObject(json, "_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("payment")) {
            res.setPaymentElement(this.parseString(json.get("payment").getAsString()));
        }
        if (json.has("_payment")) {
            this.parseElementProperties(this.getJObject(json, "_payment"), res.getPaymentElement());
        }
        if (json.has("paymentDate")) {
            res.setPaymentDateElement(this.parseDateTime(json.get("paymentDate").getAsString()));
        }
        if (json.has("_paymentDate")) {
            this.parseElementProperties(this.getJObject(json, "_paymentDate"), res.getPaymentDateElement());
        }
        if (json.has("responsible")) {
            res.setResponsible(this.parseReference(this.getJObject(json, "responsible")));
        }
        if (json.has("recipient")) {
            res.setRecipient(this.parseReference(this.getJObject(json, "recipient")));
        }
        if (json.has("linkId")) {
            array = this.getJArray(json, "linkId");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getLinkId().add(new StringType());
                    continue;
                }
                res.getLinkId().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_linkId")) {
            array = this.getJArray(json, "_linkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLinkId().size()) {
                    res.getLinkId().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getLinkId().get(i));
            }
        }
        if (json.has("securityLabelNumber")) {
            array = this.getJArray(json, "securityLabelNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSecurityLabelNumber().add(new UnsignedIntType());
                    continue;
                }
                res.getSecurityLabelNumber().add(this.parseUnsignedInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_securityLabelNumber")) {
            array = this.getJArray(json, "_securityLabelNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSecurityLabelNumber().size()) {
                    res.getSecurityLabelNumber().add(this.parseUnsignedInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getSecurityLabelNumber().get(i));
            }
        }
    }

    protected Contract.ActionComponent parseContractActionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ActionComponent res = new Contract.ActionComponent();
        this.parseContractActionComponentProperties(json, res);
        return res;
    }

    protected void parseContractActionComponentProperties(JsonObject json, Contract.ActionComponent res) throws IOException, FHIRFormatError {
        int i;
        DataType occurrence;
        int i2;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(json.get("doNotPerform").getAsBoolean()));
        }
        if (json.has("_doNotPerform")) {
            this.parseElementProperties(this.getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subject")) {
            array = this.getJArray(json, "subject");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSubject().add(this.parseContractActionSubjectComponent(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("intent")) {
            res.setIntent(this.parseCodeableConcept(this.getJObject(json, "intent")));
        }
        if (json.has("linkId")) {
            array = this.getJArray(json, "linkId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getLinkId().add(new StringType());
                    continue;
                }
                res.getLinkId().add(this.parseString(array.get(i2).getAsString()));
            }
        }
        if (json.has("_linkId")) {
            array = this.getJArray(json, "_linkId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getLinkId().size()) {
                    res.getLinkId().add(this.parseString(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i2), res.getLinkId().get(i2));
            }
        }
        if (json.has("status")) {
            res.setStatus(this.parseCodeableConcept(this.getJObject(json, "status")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(this.getJObject(json, "context")));
        }
        if (json.has("contextLinkId")) {
            array = this.getJArray(json, "contextLinkId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getContextLinkId().add(new StringType());
                    continue;
                }
                res.getContextLinkId().add(this.parseString(array.get(i2).getAsString()));
            }
        }
        if (json.has("_contextLinkId")) {
            array = this.getJArray(json, "_contextLinkId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getContextLinkId().size()) {
                    res.getContextLinkId().add(this.parseString(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i2), res.getContextLinkId().get(i2));
            }
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("requester")) {
            JsonArray array2 = this.getJArray(json, "requester");
            for (i = 0; i < array2.size(); ++i) {
                res.getRequester().add(this.parseReference(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("requesterLinkId")) {
            JsonArray array3 = this.getJArray(json, "requesterLinkId");
            for (i = 0; i < array3.size(); ++i) {
                if (array3.get(i).isJsonNull()) {
                    res.getRequesterLinkId().add(new StringType());
                    continue;
                }
                res.getRequesterLinkId().add(this.parseString(array3.get(i).getAsString()));
            }
        }
        if (json.has("_requesterLinkId")) {
            JsonArray array4 = this.getJArray(json, "_requesterLinkId");
            for (i = 0; i < array4.size(); ++i) {
                if (i == res.getRequesterLinkId().size()) {
                    res.getRequesterLinkId().add(this.parseString(null));
                }
                if (!(array4.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array4, i), res.getRequesterLinkId().get(i));
            }
        }
        if (json.has("performerType")) {
            JsonArray array5 = this.getJArray(json, "performerType");
            for (i = 0; i < array5.size(); ++i) {
                res.getPerformerType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array5, i)));
            }
        }
        if (json.has("performerRole")) {
            res.setPerformerRole(this.parseCodeableConcept(this.getJObject(json, "performerRole")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(this.getJObject(json, "performer")));
        }
        if (json.has("performerLinkId")) {
            JsonArray array6 = this.getJArray(json, "performerLinkId");
            for (i = 0; i < array6.size(); ++i) {
                if (array6.get(i).isJsonNull()) {
                    res.getPerformerLinkId().add(new StringType());
                    continue;
                }
                res.getPerformerLinkId().add(this.parseString(array6.get(i).getAsString()));
            }
        }
        if (json.has("_performerLinkId")) {
            JsonArray array7 = this.getJArray(json, "_performerLinkId");
            for (i = 0; i < array7.size(); ++i) {
                if (i == res.getPerformerLinkId().size()) {
                    res.getPerformerLinkId().add(this.parseString(null));
                }
                if (!(array7.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array7, i), res.getPerformerLinkId().get(i));
            }
        }
        if (json.has("reason")) {
            JsonArray array8 = this.getJArray(json, "reason");
            for (i = 0; i < array8.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(this.getJsonObjectFromArray(array8, i)));
            }
        }
        if (json.has("reasonLinkId")) {
            JsonArray array9 = this.getJArray(json, "reasonLinkId");
            for (i = 0; i < array9.size(); ++i) {
                if (array9.get(i).isJsonNull()) {
                    res.getReasonLinkId().add(new StringType());
                    continue;
                }
                res.getReasonLinkId().add(this.parseString(array9.get(i).getAsString()));
            }
        }
        if (json.has("_reasonLinkId")) {
            JsonArray array10 = this.getJArray(json, "_reasonLinkId");
            for (i = 0; i < array10.size(); ++i) {
                if (i == res.getReasonLinkId().size()) {
                    res.getReasonLinkId().add(this.parseString(null));
                }
                if (!(array10.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array10, i), res.getReasonLinkId().get(i));
            }
        }
        if (json.has("note")) {
            JsonArray array11 = this.getJArray(json, "note");
            for (i = 0; i < array11.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array11, i)));
            }
        }
        if (json.has("securityLabelNumber")) {
            JsonArray array12 = this.getJArray(json, "securityLabelNumber");
            for (i = 0; i < array12.size(); ++i) {
                if (array12.get(i).isJsonNull()) {
                    res.getSecurityLabelNumber().add(new UnsignedIntType());
                    continue;
                }
                res.getSecurityLabelNumber().add(this.parseUnsignedInt(array12.get(i).getAsString()));
            }
        }
        if (json.has("_securityLabelNumber")) {
            JsonArray array13 = this.getJArray(json, "_securityLabelNumber");
            for (i = 0; i < array13.size(); ++i) {
                if (i == res.getSecurityLabelNumber().size()) {
                    res.getSecurityLabelNumber().add(this.parseUnsignedInt(null));
                }
                if (!(array13.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array13, i), res.getSecurityLabelNumber().get(i));
            }
        }
    }

    protected Contract.ActionSubjectComponent parseContractActionSubjectComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ActionSubjectComponent res = new Contract.ActionSubjectComponent();
        this.parseContractActionSubjectComponentProperties(json, res);
        return res;
    }

    protected void parseContractActionSubjectComponentProperties(JsonObject json, Contract.ActionSubjectComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("reference")) {
            JsonArray array = this.getJArray(json, "reference");
            for (int i = 0; i < array.size(); ++i) {
                res.getReference().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
    }

    protected Contract.SignatoryComponent parseContractSignatoryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.SignatoryComponent res = new Contract.SignatoryComponent();
        this.parseContractSignatoryComponentProperties(json, res);
        return res;
    }

    protected void parseContractSignatoryComponentProperties(JsonObject json, Contract.SignatoryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(this.getJObject(json, "type")));
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
        if (json.has("signature")) {
            JsonArray array = this.getJArray(json, "signature");
            for (int i = 0; i < array.size(); ++i) {
                res.getSignature().add(this.parseSignature(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
        this.parseContractFriendlyLanguageComponentProperties(json, res);
        return res;
    }

    protected void parseContractFriendlyLanguageComponentProperties(JsonObject json, Contract.FriendlyLanguageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
        this.parseContractLegalLanguageComponentProperties(json, res);
        return res;
    }

    protected void parseContractLegalLanguageComponentProperties(JsonObject json, Contract.LegalLanguageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
        this.parseContractComputableLanguageComponentProperties(json, res);
        return res;
    }

    protected void parseContractComputableLanguageComponentProperties(JsonObject json, Contract.ComputableLanguageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected Coverage parseCoverage(JsonObject json) throws IOException, FHIRFormatError {
        Coverage res = new Coverage();
        this.parseCoverageProperties(json, res);
        return res;
    }

    protected void parseCoverageProperties(JsonObject json, Coverage res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), Coverage.Kind.NULL, new Coverage.KindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(this.getJObject(json, "_kind"), res.getKindElement());
        }
        if (json.has("paymentBy")) {
            array = this.getJArray(json, "paymentBy");
            for (i = 0; i < array.size(); ++i) {
                res.getPaymentBy().add(this.parseCoveragePaymentByComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("policyHolder")) {
            res.setPolicyHolder(this.parseReference(this.getJObject(json, "policyHolder")));
        }
        if (json.has("subscriber")) {
            res.setSubscriber(this.parseReference(this.getJObject(json, "subscriber")));
        }
        if (json.has("subscriberId")) {
            array = this.getJArray(json, "subscriberId");
            for (i = 0; i < array.size(); ++i) {
                res.getSubscriberId().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("beneficiary")) {
            res.setBeneficiary(this.parseReference(this.getJObject(json, "beneficiary")));
        }
        if (json.has("dependent")) {
            res.setDependentElement(this.parseString(json.get("dependent").getAsString()));
        }
        if (json.has("_dependent")) {
            this.parseElementProperties(this.getJObject(json, "_dependent"), res.getDependentElement());
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(this.getJObject(json, "relationship")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("class")) {
            array = this.getJArray(json, "class");
            for (i = 0; i < array.size(); ++i) {
                res.getClass_().add(this.parseCoverageClassComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("order")) {
            res.setOrderElement(this.parsePositiveInt(json.get("order").getAsString()));
        }
        if (json.has("_order")) {
            this.parseElementProperties(this.getJObject(json, "_order"), res.getOrderElement());
        }
        if (json.has("network")) {
            res.setNetworkElement(this.parseString(json.get("network").getAsString()));
        }
        if (json.has("_network")) {
            this.parseElementProperties(this.getJObject(json, "_network"), res.getNetworkElement());
        }
        if (json.has("costToBeneficiary")) {
            array = this.getJArray(json, "costToBeneficiary");
            for (i = 0; i < array.size(); ++i) {
                res.getCostToBeneficiary().add(this.parseCoverageCostToBeneficiaryComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subrogation")) {
            res.setSubrogationElement(this.parseBoolean(json.get("subrogation").getAsBoolean()));
        }
        if (json.has("_subrogation")) {
            this.parseElementProperties(this.getJObject(json, "_subrogation"), res.getSubrogationElement());
        }
        if (json.has("contract")) {
            array = this.getJArray(json, "contract");
            for (i = 0; i < array.size(); ++i) {
                res.getContract().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("insurancePlan")) {
            res.setInsurancePlan(this.parseReference(this.getJObject(json, "insurancePlan")));
        }
    }

    protected Coverage.CoveragePaymentByComponent parseCoveragePaymentByComponent(JsonObject json) throws IOException, FHIRFormatError {
        Coverage.CoveragePaymentByComponent res = new Coverage.CoveragePaymentByComponent();
        this.parseCoveragePaymentByComponentProperties(json, res);
        return res;
    }

    protected void parseCoveragePaymentByComponentProperties(JsonObject json, Coverage.CoveragePaymentByComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
        if (json.has("responsibility")) {
            res.setResponsibilityElement(this.parseString(json.get("responsibility").getAsString()));
        }
        if (json.has("_responsibility")) {
            this.parseElementProperties(this.getJObject(json, "_responsibility"), res.getResponsibilityElement());
        }
    }

    protected Coverage.ClassComponent parseCoverageClassComponent(JsonObject json) throws IOException, FHIRFormatError {
        Coverage.ClassComponent res = new Coverage.ClassComponent();
        this.parseCoverageClassComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageClassComponentProperties(JsonObject json, Coverage.ClassComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("value")) {
            res.setValue(this.parseIdentifier(this.getJObject(json, "value")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
    }

    protected Coverage.CostToBeneficiaryComponent parseCoverageCostToBeneficiaryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Coverage.CostToBeneficiaryComponent res = new Coverage.CostToBeneficiaryComponent();
        this.parseCoverageCostToBeneficiaryComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageCostToBeneficiaryComponentProperties(JsonObject json, Coverage.CostToBeneficiaryComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("network")) {
            res.setNetwork(this.parseCodeableConcept(this.getJObject(json, "network")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCodeableConcept(this.getJObject(json, "unit")));
        }
        if (json.has("term")) {
            res.setTerm(this.parseCodeableConcept(this.getJObject(json, "term")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("exception")) {
            JsonArray array = this.getJArray(json, "exception");
            for (int i = 0; i < array.size(); ++i) {
                res.getException().add(this.parseCoverageExemptionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Coverage.ExemptionComponent parseCoverageExemptionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Coverage.ExemptionComponent res = new Coverage.ExemptionComponent();
        this.parseCoverageExemptionComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageExemptionComponentProperties(JsonObject json, Coverage.ExemptionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected CoverageEligibilityRequest parseCoverageEligibilityRequest(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityRequest res = new CoverageEligibilityRequest();
        this.parseCoverageEligibilityRequestProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityRequestProperties(JsonObject json, CoverageEligibilityRequest res) throws IOException, FHIRFormatError {
        int i;
        DataType serviced;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(this.getJObject(json, "priority")));
        }
        if (json.has("purpose")) {
            array = this.getJArray(json, "purpose");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getPurpose().add(new Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose>(new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory(), CoverageEligibilityRequest.EligibilityRequestPurpose.NULL));
                    continue;
                }
                res.getPurpose().add(this.parseEnumeration(array.get(i2).getAsString(), CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
            }
        }
        if (json.has("_purpose")) {
            array = this.getJArray(json, "_purpose");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getPurpose().size()) {
                    res.getPurpose().add(this.parseEnumeration(null, CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i2), res.getPurpose().get(i2));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("event")) {
            array = this.getJArray(json, "event");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getEvent().add(this.parseCoverageEligibilityRequestEventComponent(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(this.getJObject(json, "enterer")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("facility")) {
            res.setFacility(this.parseReference(this.getJObject(json, "facility")));
        }
        if (json.has("supportingInfo")) {
            JsonArray array2 = this.getJArray(json, "supportingInfo");
            for (i = 0; i < array2.size(); ++i) {
                res.getSupportingInfo().add(this.parseCoverageEligibilityRequestSupportingInformationComponent(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("insurance")) {
            JsonArray array3 = this.getJArray(json, "insurance");
            for (i = 0; i < array3.size(); ++i) {
                res.getInsurance().add(this.parseCoverageEligibilityRequestInsuranceComponent(this.getJsonObjectFromArray(array3, i)));
            }
        }
        if (json.has("item")) {
            JsonArray array4 = this.getJArray(json, "item");
            for (i = 0; i < array4.size(); ++i) {
                res.getItem().add(this.parseCoverageEligibilityRequestDetailsComponent(this.getJsonObjectFromArray(array4, i)));
            }
        }
    }

    protected CoverageEligibilityRequest.CoverageEligibilityRequestEventComponent parseCoverageEligibilityRequestEventComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityRequest.CoverageEligibilityRequestEventComponent res = new CoverageEligibilityRequest.CoverageEligibilityRequestEventComponent();
        this.parseCoverageEligibilityRequestEventComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityRequestEventComponentProperties(JsonObject json, CoverageEligibilityRequest.CoverageEligibilityRequestEventComponent res) throws IOException, FHIRFormatError {
        DataType when;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((when = this.parseType("when", json)) != null) {
            res.setWhen(when);
        }
    }

    protected CoverageEligibilityRequest.SupportingInformationComponent parseCoverageEligibilityRequestSupportingInformationComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityRequest.SupportingInformationComponent res = new CoverageEligibilityRequest.SupportingInformationComponent();
        this.parseCoverageEligibilityRequestSupportingInformationComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityRequestSupportingInformationComponentProperties(JsonObject json, CoverageEligibilityRequest.SupportingInformationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("information")) {
            res.setInformation(this.parseReference(this.getJObject(json, "information")));
        }
        if (json.has("appliesToAll")) {
            res.setAppliesToAllElement(this.parseBoolean(json.get("appliesToAll").getAsBoolean()));
        }
        if (json.has("_appliesToAll")) {
            this.parseElementProperties(this.getJObject(json, "_appliesToAll"), res.getAppliesToAllElement());
        }
    }

    protected CoverageEligibilityRequest.InsuranceComponent parseCoverageEligibilityRequestInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityRequest.InsuranceComponent res = new CoverageEligibilityRequest.InsuranceComponent();
        this.parseCoverageEligibilityRequestInsuranceComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityRequestInsuranceComponentProperties(JsonObject json, CoverageEligibilityRequest.InsuranceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(this.getJObject(json, "_focal"), res.getFocalElement());
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(this.getJObject(json, "_businessArrangement"), res.getBusinessArrangementElement());
        }
    }

    protected CoverageEligibilityRequest.DetailsComponent parseCoverageEligibilityRequestDetailsComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityRequest.DetailsComponent res = new CoverageEligibilityRequest.DetailsComponent();
        this.parseCoverageEligibilityRequestDetailsComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityRequestDetailsComponentProperties(JsonObject json, CoverageEligibilityRequest.DetailsComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("supportingInfoSequence")) {
            array = this.getJArray(json, "supportingInfoSequence");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSupportingInfoSequence().add(new PositiveIntType());
                    continue;
                }
                res.getSupportingInfoSequence().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_supportingInfoSequence")) {
            array = this.getJArray(json, "_supportingInfoSequence");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSupportingInfoSequence().size()) {
                    res.getSupportingInfoSequence().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getSupportingInfoSequence().get(i));
            }
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array = this.getJArray(json, "modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("facility")) {
            res.setFacility(this.parseReference(this.getJObject(json, "facility")));
        }
        if (json.has("diagnosis")) {
            array = this.getJArray(json, "diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseCoverageEligibilityRequestDiagnosisComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("detail")) {
            array = this.getJArray(json, "detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected CoverageEligibilityRequest.DiagnosisComponent parseCoverageEligibilityRequestDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityRequest.DiagnosisComponent res = new CoverageEligibilityRequest.DiagnosisComponent();
        this.parseCoverageEligibilityRequestDiagnosisComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityRequestDiagnosisComponentProperties(JsonObject json, CoverageEligibilityRequest.DiagnosisComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType diagnosis = this.parseType("diagnosis", json);
        if (diagnosis != null) {
            res.setDiagnosis(diagnosis);
        }
    }

    protected CoverageEligibilityResponse parseCoverageEligibilityResponse(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityResponse res = new CoverageEligibilityResponse();
        this.parseCoverageEligibilityResponseProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityResponseProperties(JsonObject json, CoverageEligibilityResponse res) throws IOException, FHIRFormatError {
        int i;
        DataType serviced;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("purpose")) {
            array = this.getJArray(json, "purpose");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getPurpose().add(new Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose>(new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory(), CoverageEligibilityResponse.EligibilityResponsePurpose.NULL));
                    continue;
                }
                res.getPurpose().add(this.parseEnumeration(array.get(i2).getAsString(), CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
            }
        }
        if (json.has("_purpose")) {
            array = this.getJArray(json, "_purpose");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getPurpose().size()) {
                    res.getPurpose().add(this.parseEnumeration(null, CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i2), res.getPurpose().get(i2));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("event")) {
            array = this.getJArray(json, "event");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getEvent().add(this.parseCoverageEligibilityResponseEventComponent(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("requestor")) {
            res.setRequestor(this.parseReference(this.getJObject(json, "requestor")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(this.getJObject(json, "request")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), CoverageEligibilityResponse.EligibilityOutcome.NULL, new CoverageEligibilityResponse.EligibilityOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(this.getJObject(json, "_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(this.getJObject(json, "_disposition"), res.getDispositionElement());
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("insurance")) {
            JsonArray array2 = this.getJArray(json, "insurance");
            for (i = 0; i < array2.size(); ++i) {
                res.getInsurance().add(this.parseCoverageEligibilityResponseInsuranceComponent(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("preAuthRef")) {
            res.setPreAuthRefElement(this.parseString(json.get("preAuthRef").getAsString()));
        }
        if (json.has("_preAuthRef")) {
            this.parseElementProperties(this.getJObject(json, "_preAuthRef"), res.getPreAuthRefElement());
        }
        if (json.has("form")) {
            res.setForm(this.parseCodeableConcept(this.getJObject(json, "form")));
        }
        if (json.has("error")) {
            JsonArray array3 = this.getJArray(json, "error");
            for (i = 0; i < array3.size(); ++i) {
                res.getError().add(this.parseCoverageEligibilityResponseErrorsComponent(this.getJsonObjectFromArray(array3, i)));
            }
        }
    }

    protected CoverageEligibilityResponse.CoverageEligibilityResponseEventComponent parseCoverageEligibilityResponseEventComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityResponse.CoverageEligibilityResponseEventComponent res = new CoverageEligibilityResponse.CoverageEligibilityResponseEventComponent();
        this.parseCoverageEligibilityResponseEventComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityResponseEventComponentProperties(JsonObject json, CoverageEligibilityResponse.CoverageEligibilityResponseEventComponent res) throws IOException, FHIRFormatError {
        DataType when;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((when = this.parseType("when", json)) != null) {
            res.setWhen(when);
        }
    }

    protected CoverageEligibilityResponse.InsuranceComponent parseCoverageEligibilityResponseInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityResponse.InsuranceComponent res = new CoverageEligibilityResponse.InsuranceComponent();
        this.parseCoverageEligibilityResponseInsuranceComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityResponseInsuranceComponentProperties(JsonObject json, CoverageEligibilityResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
        if (json.has("inforce")) {
            res.setInforceElement(this.parseBoolean(json.get("inforce").getAsBoolean()));
        }
        if (json.has("_inforce")) {
            this.parseElementProperties(this.getJObject(json, "_inforce"), res.getInforceElement());
        }
        if (json.has("benefitPeriod")) {
            res.setBenefitPeriod(this.parsePeriod(this.getJObject(json, "benefitPeriod")));
        }
        if (json.has("item")) {
            JsonArray array = this.getJArray(json, "item");
            for (int i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseCoverageEligibilityResponseItemsComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected CoverageEligibilityResponse.ItemsComponent parseCoverageEligibilityResponseItemsComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityResponse.ItemsComponent res = new CoverageEligibilityResponse.ItemsComponent();
        this.parseCoverageEligibilityResponseItemsComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityResponseItemsComponentProperties(JsonObject json, CoverageEligibilityResponse.ItemsComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array = this.getJArray(json, "modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("excluded")) {
            res.setExcludedElement(this.parseBoolean(json.get("excluded").getAsBoolean()));
        }
        if (json.has("_excluded")) {
            this.parseElementProperties(this.getJObject(json, "_excluded"), res.getExcludedElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("network")) {
            res.setNetwork(this.parseCodeableConcept(this.getJObject(json, "network")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCodeableConcept(this.getJObject(json, "unit")));
        }
        if (json.has("term")) {
            res.setTerm(this.parseCodeableConcept(this.getJObject(json, "term")));
        }
        if (json.has("benefit")) {
            array = this.getJArray(json, "benefit");
            for (i = 0; i < array.size(); ++i) {
                res.getBenefit().add(this.parseCoverageEligibilityResponseBenefitComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("authorizationRequired")) {
            res.setAuthorizationRequiredElement(this.parseBoolean(json.get("authorizationRequired").getAsBoolean()));
        }
        if (json.has("_authorizationRequired")) {
            this.parseElementProperties(this.getJObject(json, "_authorizationRequired"), res.getAuthorizationRequiredElement());
        }
        if (json.has("authorizationSupporting")) {
            array = this.getJArray(json, "authorizationSupporting");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthorizationSupporting().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("authorizationUrl")) {
            res.setAuthorizationUrlElement(this.parseUri(json.get("authorizationUrl").getAsString()));
        }
        if (json.has("_authorizationUrl")) {
            this.parseElementProperties(this.getJObject(json, "_authorizationUrl"), res.getAuthorizationUrlElement());
        }
    }

    protected CoverageEligibilityResponse.BenefitComponent parseCoverageEligibilityResponseBenefitComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityResponse.BenefitComponent res = new CoverageEligibilityResponse.BenefitComponent();
        this.parseCoverageEligibilityResponseBenefitComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityResponseBenefitComponentProperties(JsonObject json, CoverageEligibilityResponse.BenefitComponent res) throws IOException, FHIRFormatError {
        DataType used;
        DataType allowed;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((allowed = this.parseType("allowed", json)) != null) {
            res.setAllowed(allowed);
        }
        if ((used = this.parseType("used", json)) != null) {
            res.setUsed(used);
        }
    }

    protected CoverageEligibilityResponse.ErrorsComponent parseCoverageEligibilityResponseErrorsComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityResponse.ErrorsComponent res = new CoverageEligibilityResponse.ErrorsComponent();
        this.parseCoverageEligibilityResponseErrorsComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityResponseErrorsComponentProperties(JsonObject json, CoverageEligibilityResponse.ErrorsComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("expression")) {
            array = this.getJArray(json, "expression");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getExpression().add(new StringType());
                    continue;
                }
                res.getExpression().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_expression")) {
            array = this.getJArray(json, "_expression");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getExpression().size()) {
                    res.getExpression().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getExpression().get(i));
            }
        }
    }

    protected DetectedIssue parseDetectedIssue(JsonObject json) throws IOException, FHIRFormatError {
        DetectedIssue res = new DetectedIssue();
        this.parseDetectedIssueProperties(json, res);
        return res;
    }

    protected void parseDetectedIssueProperties(JsonObject json, DetectedIssue res) throws IOException, FHIRFormatError {
        int i;
        DataType identified;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DetectedIssue.DetectedIssueStatus.NULL, new DetectedIssue.DetectedIssueStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(this.getJObject(json, "_severity"), res.getSeverityElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((identified = this.parseType("identified", json)) != null) {
            res.setIdentified(identified);
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
        if (json.has("implicated")) {
            JsonArray array2 = this.getJArray(json, "implicated");
            for (i = 0; i < array2.size(); ++i) {
                res.getImplicated().add(this.parseReference(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("evidence")) {
            JsonArray array3 = this.getJArray(json, "evidence");
            for (i = 0; i < array3.size(); ++i) {
                res.getEvidence().add(this.parseDetectedIssueEvidenceComponent(this.getJsonObjectFromArray(array3, i)));
            }
        }
        if (json.has("detail")) {
            res.setDetailElement(this.parseMarkdown(json.get("detail").getAsString()));
        }
        if (json.has("_detail")) {
            this.parseElementProperties(this.getJObject(json, "_detail"), res.getDetailElement());
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseUri(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(this.getJObject(json, "_reference"), res.getReferenceElement());
        }
        if (json.has("mitigation")) {
            JsonArray array4 = this.getJArray(json, "mitigation");
            for (i = 0; i < array4.size(); ++i) {
                res.getMitigation().add(this.parseDetectedIssueMitigationComponent(this.getJsonObjectFromArray(array4, i)));
            }
        }
    }

    protected DetectedIssue.DetectedIssueEvidenceComponent parseDetectedIssueEvidenceComponent(JsonObject json) throws IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueEvidenceComponent res = new DetectedIssue.DetectedIssueEvidenceComponent();
        this.parseDetectedIssueEvidenceComponentProperties(json, res);
        return res;
    }

    protected void parseDetectedIssueEvidenceComponentProperties(JsonObject json, DetectedIssue.DetectedIssueEvidenceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            array = this.getJArray(json, "code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("detail")) {
            array = this.getJArray(json, "detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueMitigationComponent(JsonObject json) throws IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
        this.parseDetectedIssueMitigationComponentProperties(json, res);
        return res;
    }

    protected void parseDetectedIssueMitigationComponentProperties(JsonObject json, DetectedIssue.DetectedIssueMitigationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("action")) {
            res.setAction(this.parseCodeableConcept(this.getJObject(json, "action")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
        if (json.has("note")) {
            JsonArray array = this.getJArray(json, "note");
            for (int i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Device parseDevice(JsonObject json) throws IOException, FHIRFormatError {
        Device res = new Device();
        this.parseDeviceProperties(json, res);
        return res;
    }

    protected void parseDeviceProperties(JsonObject json, Device res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("displayName")) {
            res.setDisplayNameElement(this.parseString(json.get("displayName").getAsString()));
        }
        if (json.has("_displayName")) {
            this.parseElementProperties(this.getJObject(json, "_displayName"), res.getDisplayNameElement());
        }
        if (json.has("definition")) {
            res.setDefinition(this.parseCodeableReference(this.getJObject(json, "definition")));
        }
        if (json.has("udiCarrier")) {
            array = this.getJArray(json, "udiCarrier");
            for (i = 0; i < array.size(); ++i) {
                res.getUdiCarrier().add(this.parseDeviceUdiCarrierComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("availabilityStatus")) {
            res.setAvailabilityStatus(this.parseCodeableConcept(this.getJObject(json, "availabilityStatus")));
        }
        if (json.has("biologicalSourceEvent")) {
            res.setBiologicalSourceEvent(this.parseIdentifier(this.getJObject(json, "biologicalSourceEvent")));
        }
        if (json.has("manufacturer")) {
            res.setManufacturerElement(this.parseString(json.get("manufacturer").getAsString()));
        }
        if (json.has("_manufacturer")) {
            this.parseElementProperties(this.getJObject(json, "_manufacturer"), res.getManufacturerElement());
        }
        if (json.has("manufactureDate")) {
            res.setManufactureDateElement(this.parseDateTime(json.get("manufactureDate").getAsString()));
        }
        if (json.has("_manufactureDate")) {
            this.parseElementProperties(this.getJObject(json, "_manufactureDate"), res.getManufactureDateElement());
        }
        if (json.has("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(json.get("expirationDate").getAsString()));
        }
        if (json.has("_expirationDate")) {
            this.parseElementProperties(this.getJObject(json, "_expirationDate"), res.getExpirationDateElement());
        }
        if (json.has("lotNumber")) {
            res.setLotNumberElement(this.parseString(json.get("lotNumber").getAsString()));
        }
        if (json.has("_lotNumber")) {
            this.parseElementProperties(this.getJObject(json, "_lotNumber"), res.getLotNumberElement());
        }
        if (json.has("serialNumber")) {
            res.setSerialNumberElement(this.parseString(json.get("serialNumber").getAsString()));
        }
        if (json.has("_serialNumber")) {
            this.parseElementProperties(this.getJObject(json, "_serialNumber"), res.getSerialNumberElement());
        }
        if (json.has("name")) {
            array = this.getJArray(json, "name");
            for (i = 0; i < array.size(); ++i) {
                res.getName().add(this.parseDeviceNameComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("modelNumber")) {
            res.setModelNumberElement(this.parseString(json.get("modelNumber").getAsString()));
        }
        if (json.has("_modelNumber")) {
            this.parseElementProperties(this.getJObject(json, "_modelNumber"), res.getModelNumberElement());
        }
        if (json.has("partNumber")) {
            res.setPartNumberElement(this.parseString(json.get("partNumber").getAsString()));
        }
        if (json.has("_partNumber")) {
            this.parseElementProperties(this.getJObject(json, "_partNumber"), res.getPartNumberElement());
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("type")) {
            array = this.getJArray(json, "type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("version")) {
            array = this.getJArray(json, "version");
            for (i = 0; i < array.size(); ++i) {
                res.getVersion().add(this.parseDeviceVersionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("conformsTo")) {
            array = this.getJArray(json, "conformsTo");
            for (i = 0; i < array.size(); ++i) {
                res.getConformsTo().add(this.parseDeviceConformsToComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("property")) {
            array = this.getJArray(json, "property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseDevicePropertyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("mode")) {
            res.setMode(this.parseCodeableConcept(this.getJObject(json, "mode")));
        }
        if (json.has("cycle")) {
            res.setCycle(this.parseCount(this.getJObject(json, "cycle")));
        }
        if (json.has("duration")) {
            res.setDuration(this.parseDuration(this.getJObject(json, "duration")));
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(this.getJObject(json, "owner")));
        }
        if (json.has("contact")) {
            array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactPoint(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("endpoint")) {
            array = this.getJArray(json, "endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("gateway")) {
            array = this.getJArray(json, "gateway");
            for (i = 0; i < array.size(); ++i) {
                res.getGateway().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("safety")) {
            array = this.getJArray(json, "safety");
            for (i = 0; i < array.size(); ++i) {
                res.getSafety().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("parent")) {
            res.setParent(this.parseReference(this.getJObject(json, "parent")));
        }
    }

    protected Device.DeviceUdiCarrierComponent parseDeviceUdiCarrierComponent(JsonObject json) throws IOException, FHIRFormatError {
        Device.DeviceUdiCarrierComponent res = new Device.DeviceUdiCarrierComponent();
        this.parseDeviceUdiCarrierComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceUdiCarrierComponentProperties(JsonObject json, Device.DeviceUdiCarrierComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("deviceIdentifier")) {
            res.setDeviceIdentifierElement(this.parseString(json.get("deviceIdentifier").getAsString()));
        }
        if (json.has("_deviceIdentifier")) {
            this.parseElementProperties(this.getJObject(json, "_deviceIdentifier"), res.getDeviceIdentifierElement());
        }
        if (json.has("issuer")) {
            res.setIssuerElement(this.parseUri(json.get("issuer").getAsString()));
        }
        if (json.has("_issuer")) {
            this.parseElementProperties(this.getJObject(json, "_issuer"), res.getIssuerElement());
        }
        if (json.has("jurisdiction")) {
            res.setJurisdictionElement(this.parseUri(json.get("jurisdiction").getAsString()));
        }
        if (json.has("_jurisdiction")) {
            this.parseElementProperties(this.getJObject(json, "_jurisdiction"), res.getJurisdictionElement());
        }
        if (json.has("carrierAIDC")) {
            res.setCarrierAIDCElement(this.parseBase64Binary(json.get("carrierAIDC").getAsString()));
        }
        if (json.has("_carrierAIDC")) {
            this.parseElementProperties(this.getJObject(json, "_carrierAIDC"), res.getCarrierAIDCElement());
        }
        if (json.has("carrierHRF")) {
            res.setCarrierHRFElement(this.parseString(json.get("carrierHRF").getAsString()));
        }
        if (json.has("_carrierHRF")) {
            this.parseElementProperties(this.getJObject(json, "_carrierHRF"), res.getCarrierHRFElement());
        }
        if (json.has("entryType")) {
            res.setEntryTypeElement(this.parseEnumeration(json.get("entryType").getAsString(), Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
        }
        if (json.has("_entryType")) {
            this.parseElementProperties(this.getJObject(json, "_entryType"), res.getEntryTypeElement());
        }
    }

    protected Device.DeviceNameComponent parseDeviceNameComponent(JsonObject json) throws IOException, FHIRFormatError {
        Device.DeviceNameComponent res = new Device.DeviceNameComponent();
        this.parseDeviceNameComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceNameComponentProperties(JsonObject json, Device.DeviceNameComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.DeviceNameType.NULL, new Enumerations.DeviceNameTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseBoolean(json.get("display").getAsBoolean()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
    }

    protected Device.DeviceVersionComponent parseDeviceVersionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Device.DeviceVersionComponent res = new Device.DeviceVersionComponent();
        this.parseDeviceVersionComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceVersionComponentProperties(JsonObject json, Device.DeviceVersionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("component")) {
            res.setComponent(this.parseIdentifier(this.getJObject(json, "component")));
        }
        if (json.has("installDate")) {
            res.setInstallDateElement(this.parseDateTime(json.get("installDate").getAsString()));
        }
        if (json.has("_installDate")) {
            this.parseElementProperties(this.getJObject(json, "_installDate"), res.getInstallDateElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected Device.DeviceConformsToComponent parseDeviceConformsToComponent(JsonObject json) throws IOException, FHIRFormatError {
        Device.DeviceConformsToComponent res = new Device.DeviceConformsToComponent();
        this.parseDeviceConformsToComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceConformsToComponentProperties(JsonObject json, Device.DeviceConformsToComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("specification")) {
            res.setSpecification(this.parseCodeableConcept(this.getJObject(json, "specification")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
    }

    protected Device.DevicePropertyComponent parseDevicePropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        Device.DevicePropertyComponent res = new Device.DevicePropertyComponent();
        this.parseDevicePropertyComponentProperties(json, res);
        return res;
    }

    protected void parseDevicePropertyComponentProperties(JsonObject json, Device.DevicePropertyComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected DeviceAssociation parseDeviceAssociation(JsonObject json) throws IOException, FHIRFormatError {
        DeviceAssociation res = new DeviceAssociation();
        this.parseDeviceAssociationProperties(json, res);
        return res;
    }

    protected void parseDeviceAssociationProperties(JsonObject json, DeviceAssociation res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(this.getJObject(json, "device")));
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatus(this.parseCodeableConcept(this.getJObject(json, "status")));
        }
        if (json.has("statusReason")) {
            array = this.getJArray(json, "statusReason");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusReason().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("bodyStructure")) {
            res.setBodyStructure(this.parseReference(this.getJObject(json, "bodyStructure")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("operation")) {
            array = this.getJArray(json, "operation");
            for (i = 0; i < array.size(); ++i) {
                res.getOperation().add(this.parseDeviceAssociationOperationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DeviceAssociation.DeviceAssociationOperationComponent parseDeviceAssociationOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceAssociation.DeviceAssociationOperationComponent res = new DeviceAssociation.DeviceAssociationOperationComponent();
        this.parseDeviceAssociationOperationComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceAssociationOperationComponentProperties(JsonObject json, DeviceAssociation.DeviceAssociationOperationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("status")) {
            res.setStatus(this.parseCodeableConcept(this.getJObject(json, "status")));
        }
        if (json.has("operator")) {
            JsonArray array = this.getJArray(json, "operator");
            for (int i = 0; i < array.size(); ++i) {
                res.getOperator().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected DeviceDefinition parseDeviceDefinition(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition res = new DeviceDefinition();
        this.parseDeviceDefinitionProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionProperties(JsonObject json, DeviceDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("udiDeviceIdentifier")) {
            array = this.getJArray(json, "udiDeviceIdentifier");
            for (i = 0; i < array.size(); ++i) {
                res.getUdiDeviceIdentifier().add(this.parseDeviceDefinitionUdiDeviceIdentifierComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("regulatoryIdentifier")) {
            array = this.getJArray(json, "regulatoryIdentifier");
            for (i = 0; i < array.size(); ++i) {
                res.getRegulatoryIdentifier().add(this.parseDeviceDefinitionRegulatoryIdentifierComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("partNumber")) {
            res.setPartNumberElement(this.parseString(json.get("partNumber").getAsString()));
        }
        if (json.has("_partNumber")) {
            this.parseElementProperties(this.getJObject(json, "_partNumber"), res.getPartNumberElement());
        }
        if (json.has("manufacturer")) {
            res.setManufacturer(this.parseReference(this.getJObject(json, "manufacturer")));
        }
        if (json.has("deviceName")) {
            array = this.getJArray(json, "deviceName");
            for (i = 0; i < array.size(); ++i) {
                res.getDeviceName().add(this.parseDeviceDefinitionDeviceNameComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("modelNumber")) {
            res.setModelNumberElement(this.parseString(json.get("modelNumber").getAsString()));
        }
        if (json.has("_modelNumber")) {
            this.parseElementProperties(this.getJObject(json, "_modelNumber"), res.getModelNumberElement());
        }
        if (json.has("classification")) {
            array = this.getJArray(json, "classification");
            for (i = 0; i < array.size(); ++i) {
                res.getClassification().add(this.parseDeviceDefinitionClassificationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("conformsTo")) {
            array = this.getJArray(json, "conformsTo");
            for (i = 0; i < array.size(); ++i) {
                res.getConformsTo().add(this.parseDeviceDefinitionConformsToComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("hasPart")) {
            array = this.getJArray(json, "hasPart");
            for (i = 0; i < array.size(); ++i) {
                res.getHasPart().add(this.parseDeviceDefinitionHasPartComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("packaging")) {
            array = this.getJArray(json, "packaging");
            for (i = 0; i < array.size(); ++i) {
                res.getPackaging().add(this.parseDeviceDefinitionPackagingComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("version")) {
            array = this.getJArray(json, "version");
            for (i = 0; i < array.size(); ++i) {
                res.getVersion().add(this.parseDeviceDefinitionVersionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("safety")) {
            array = this.getJArray(json, "safety");
            for (i = 0; i < array.size(); ++i) {
                res.getSafety().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("shelfLifeStorage")) {
            array = this.getJArray(json, "shelfLifeStorage");
            for (i = 0; i < array.size(); ++i) {
                res.getShelfLifeStorage().add(this.parseProductShelfLife(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("languageCode")) {
            array = this.getJArray(json, "languageCode");
            for (i = 0; i < array.size(); ++i) {
                res.getLanguageCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("property")) {
            array = this.getJArray(json, "property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseDeviceDefinitionPropertyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(this.getJObject(json, "owner")));
        }
        if (json.has("contact")) {
            array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactPoint(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("link")) {
            array = this.getJArray(json, "link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseDeviceDefinitionLinkComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("material")) {
            array = this.getJArray(json, "material");
            for (i = 0; i < array.size(); ++i) {
                res.getMaterial().add(this.parseDeviceDefinitionMaterialComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("productionIdentifierInUDI")) {
            array = this.getJArray(json, "productionIdentifierInUDI");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getProductionIdentifierInUDI().add(new Enumeration<DeviceDefinition.DeviceProductionIdentifierInUDI>(new DeviceDefinition.DeviceProductionIdentifierInUDIEnumFactory(), DeviceDefinition.DeviceProductionIdentifierInUDI.NULL));
                    continue;
                }
                res.getProductionIdentifierInUDI().add(this.parseEnumeration(array.get(i).getAsString(), DeviceDefinition.DeviceProductionIdentifierInUDI.NULL, new DeviceDefinition.DeviceProductionIdentifierInUDIEnumFactory()));
            }
        }
        if (json.has("_productionIdentifierInUDI")) {
            array = this.getJArray(json, "_productionIdentifierInUDI");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProductionIdentifierInUDI().size()) {
                    res.getProductionIdentifierInUDI().add(this.parseEnumeration(null, DeviceDefinition.DeviceProductionIdentifierInUDI.NULL, new DeviceDefinition.DeviceProductionIdentifierInUDIEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getProductionIdentifierInUDI().get(i));
            }
        }
        if (json.has("guideline")) {
            res.setGuideline(this.parseDeviceDefinitionGuidelineComponent(this.getJObject(json, "guideline")));
        }
        if (json.has("correctiveAction")) {
            res.setCorrectiveAction(this.parseDeviceDefinitionCorrectiveActionComponent(this.getJObject(json, "correctiveAction")));
        }
        if (json.has("chargeItem")) {
            array = this.getJArray(json, "chargeItem");
            for (i = 0; i < array.size(); ++i) {
                res.getChargeItem().add(this.parseDeviceDefinitionChargeItemComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent parseDeviceDefinitionUdiDeviceIdentifierComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res = new DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent();
        this.parseDeviceDefinitionUdiDeviceIdentifierComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionUdiDeviceIdentifierComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("deviceIdentifier")) {
            res.setDeviceIdentifierElement(this.parseString(json.get("deviceIdentifier").getAsString()));
        }
        if (json.has("_deviceIdentifier")) {
            this.parseElementProperties(this.getJObject(json, "_deviceIdentifier"), res.getDeviceIdentifierElement());
        }
        if (json.has("issuer")) {
            res.setIssuerElement(this.parseUri(json.get("issuer").getAsString()));
        }
        if (json.has("_issuer")) {
            this.parseElementProperties(this.getJObject(json, "_issuer"), res.getIssuerElement());
        }
        if (json.has("jurisdiction")) {
            res.setJurisdictionElement(this.parseUri(json.get("jurisdiction").getAsString()));
        }
        if (json.has("_jurisdiction")) {
            this.parseElementProperties(this.getJObject(json, "_jurisdiction"), res.getJurisdictionElement());
        }
        if (json.has("marketDistribution")) {
            JsonArray array = this.getJArray(json, "marketDistribution");
            for (int i = 0; i < array.size(); ++i) {
                res.getMarketDistribution().add(this.parseDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent parseDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent res = new DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent();
        this.parseDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponentProperties(JsonObject json, DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("marketPeriod")) {
            res.setMarketPeriod(this.parsePeriod(this.getJObject(json, "marketPeriod")));
        }
        if (json.has("subJurisdiction")) {
            res.setSubJurisdictionElement(this.parseUri(json.get("subJurisdiction").getAsString()));
        }
        if (json.has("_subJurisdiction")) {
            this.parseElementProperties(this.getJObject(json, "_subJurisdiction"), res.getSubJurisdictionElement());
        }
    }

    protected DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent parseDeviceDefinitionRegulatoryIdentifierComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent res = new DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent();
        this.parseDeviceDefinitionRegulatoryIdentifierComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionRegulatoryIdentifierComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), DeviceDefinition.DeviceDefinitionRegulatoryIdentifierType.NULL, new DeviceDefinition.DeviceDefinitionRegulatoryIdentifierTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("deviceIdentifier")) {
            res.setDeviceIdentifierElement(this.parseString(json.get("deviceIdentifier").getAsString()));
        }
        if (json.has("_deviceIdentifier")) {
            this.parseElementProperties(this.getJObject(json, "_deviceIdentifier"), res.getDeviceIdentifierElement());
        }
        if (json.has("issuer")) {
            res.setIssuerElement(this.parseUri(json.get("issuer").getAsString()));
        }
        if (json.has("_issuer")) {
            this.parseElementProperties(this.getJObject(json, "_issuer"), res.getIssuerElement());
        }
        if (json.has("jurisdiction")) {
            res.setJurisdictionElement(this.parseUri(json.get("jurisdiction").getAsString()));
        }
        if (json.has("_jurisdiction")) {
            this.parseElementProperties(this.getJObject(json, "_jurisdiction"), res.getJurisdictionElement());
        }
    }

    protected DeviceDefinition.DeviceDefinitionDeviceNameComponent parseDeviceDefinitionDeviceNameComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionDeviceNameComponent res = new DeviceDefinition.DeviceDefinitionDeviceNameComponent();
        this.parseDeviceDefinitionDeviceNameComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionDeviceNameComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionDeviceNameComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.DeviceNameType.NULL, new Enumerations.DeviceNameTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
    }

    protected DeviceDefinition.DeviceDefinitionClassificationComponent parseDeviceDefinitionClassificationComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionClassificationComponent res = new DeviceDefinition.DeviceDefinitionClassificationComponent();
        this.parseDeviceDefinitionClassificationComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionClassificationComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionClassificationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("justification")) {
            JsonArray array = this.getJArray(json, "justification");
            for (int i = 0; i < array.size(); ++i) {
                res.getJustification().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DeviceDefinition.DeviceDefinitionConformsToComponent parseDeviceDefinitionConformsToComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionConformsToComponent res = new DeviceDefinition.DeviceDefinitionConformsToComponent();
        this.parseDeviceDefinitionConformsToComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionConformsToComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionConformsToComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("specification")) {
            res.setSpecification(this.parseCodeableConcept(this.getJObject(json, "specification")));
        }
        if (json.has("version")) {
            array = this.getJArray(json, "version");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getVersion().add(new StringType());
                    continue;
                }
                res.getVersion().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_version")) {
            array = this.getJArray(json, "_version");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getVersion().size()) {
                    res.getVersion().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getVersion().get(i));
            }
        }
        if (json.has("source")) {
            array = this.getJArray(json, "source");
            for (i = 0; i < array.size(); ++i) {
                res.getSource().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DeviceDefinition.DeviceDefinitionHasPartComponent parseDeviceDefinitionHasPartComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionHasPartComponent res = new DeviceDefinition.DeviceDefinitionHasPartComponent();
        this.parseDeviceDefinitionHasPartComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionHasPartComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionHasPartComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
        if (json.has("count")) {
            res.setCountElement(this.parseInteger(json.get("count").getAsLong()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(this.getJObject(json, "_count"), res.getCountElement());
        }
    }

    protected DeviceDefinition.DeviceDefinitionPackagingComponent parseDeviceDefinitionPackagingComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionPackagingComponent res = new DeviceDefinition.DeviceDefinitionPackagingComponent();
        this.parseDeviceDefinitionPackagingComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionPackagingComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionPackagingComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("count")) {
            res.setCountElement(this.parseInteger(json.get("count").getAsLong()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(this.getJObject(json, "_count"), res.getCountElement());
        }
        if (json.has("distributor")) {
            array = this.getJArray(json, "distributor");
            for (i = 0; i < array.size(); ++i) {
                res.getDistributor().add(this.parseDeviceDefinitionPackagingDistributorComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("udiDeviceIdentifier")) {
            array = this.getJArray(json, "udiDeviceIdentifier");
            for (i = 0; i < array.size(); ++i) {
                res.getUdiDeviceIdentifier().add(this.parseDeviceDefinitionUdiDeviceIdentifierComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("packaging")) {
            array = this.getJArray(json, "packaging");
            for (i = 0; i < array.size(); ++i) {
                res.getPackaging().add(this.parseDeviceDefinitionPackagingComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DeviceDefinition.PackagingDistributorComponent parseDeviceDefinitionPackagingDistributorComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.PackagingDistributorComponent res = new DeviceDefinition.PackagingDistributorComponent();
        this.parseDeviceDefinitionPackagingDistributorComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionPackagingDistributorComponentProperties(JsonObject json, DeviceDefinition.PackagingDistributorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("organizationReference")) {
            JsonArray array = this.getJArray(json, "organizationReference");
            for (int i = 0; i < array.size(); ++i) {
                res.getOrganizationReference().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DeviceDefinition.DeviceDefinitionVersionComponent parseDeviceDefinitionVersionComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionVersionComponent res = new DeviceDefinition.DeviceDefinitionVersionComponent();
        this.parseDeviceDefinitionVersionComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionVersionComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionVersionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("component")) {
            res.setComponent(this.parseIdentifier(this.getJObject(json, "component")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected DeviceDefinition.DeviceDefinitionPropertyComponent parseDeviceDefinitionPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionPropertyComponent res = new DeviceDefinition.DeviceDefinitionPropertyComponent();
        this.parseDeviceDefinitionPropertyComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionPropertyComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionPropertyComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected DeviceDefinition.DeviceDefinitionLinkComponent parseDeviceDefinitionLinkComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionLinkComponent res = new DeviceDefinition.DeviceDefinitionLinkComponent();
        this.parseDeviceDefinitionLinkComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionLinkComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionLinkComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("relation")) {
            res.setRelation(this.parseCoding(this.getJObject(json, "relation")));
        }
        if (json.has("relatedDevice")) {
            res.setRelatedDevice(this.parseCodeableReference(this.getJObject(json, "relatedDevice")));
        }
    }

    protected DeviceDefinition.DeviceDefinitionMaterialComponent parseDeviceDefinitionMaterialComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionMaterialComponent res = new DeviceDefinition.DeviceDefinitionMaterialComponent();
        this.parseDeviceDefinitionMaterialComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionMaterialComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionMaterialComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("substance")) {
            res.setSubstance(this.parseCodeableConcept(this.getJObject(json, "substance")));
        }
        if (json.has("alternate")) {
            res.setAlternateElement(this.parseBoolean(json.get("alternate").getAsBoolean()));
        }
        if (json.has("_alternate")) {
            this.parseElementProperties(this.getJObject(json, "_alternate"), res.getAlternateElement());
        }
        if (json.has("allergenicIndicator")) {
            res.setAllergenicIndicatorElement(this.parseBoolean(json.get("allergenicIndicator").getAsBoolean()));
        }
        if (json.has("_allergenicIndicator")) {
            this.parseElementProperties(this.getJObject(json, "_allergenicIndicator"), res.getAllergenicIndicatorElement());
        }
    }

    protected DeviceDefinition.DeviceDefinitionGuidelineComponent parseDeviceDefinitionGuidelineComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionGuidelineComponent res = new DeviceDefinition.DeviceDefinitionGuidelineComponent();
        this.parseDeviceDefinitionGuidelineComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionGuidelineComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionGuidelineComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("useContext")) {
            array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("usageInstruction")) {
            res.setUsageInstructionElement(this.parseMarkdown(json.get("usageInstruction").getAsString()));
        }
        if (json.has("_usageInstruction")) {
            this.parseElementProperties(this.getJObject(json, "_usageInstruction"), res.getUsageInstructionElement());
        }
        if (json.has("relatedArtifact")) {
            array = this.getJArray(json, "relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("indication")) {
            array = this.getJArray(json, "indication");
            for (i = 0; i < array.size(); ++i) {
                res.getIndication().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("contraindication")) {
            array = this.getJArray(json, "contraindication");
            for (i = 0; i < array.size(); ++i) {
                res.getContraindication().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("warning")) {
            array = this.getJArray(json, "warning");
            for (i = 0; i < array.size(); ++i) {
                res.getWarning().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("intendedUse")) {
            res.setIntendedUseElement(this.parseString(json.get("intendedUse").getAsString()));
        }
        if (json.has("_intendedUse")) {
            this.parseElementProperties(this.getJObject(json, "_intendedUse"), res.getIntendedUseElement());
        }
    }

    protected DeviceDefinition.DeviceDefinitionCorrectiveActionComponent parseDeviceDefinitionCorrectiveActionComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionCorrectiveActionComponent res = new DeviceDefinition.DeviceDefinitionCorrectiveActionComponent();
        this.parseDeviceDefinitionCorrectiveActionComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionCorrectiveActionComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionCorrectiveActionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("recall")) {
            res.setRecallElement(this.parseBoolean(json.get("recall").getAsBoolean()));
        }
        if (json.has("_recall")) {
            this.parseElementProperties(this.getJObject(json, "_recall"), res.getRecallElement());
        }
        if (json.has("scope")) {
            res.setScopeElement(this.parseEnumeration(json.get("scope").getAsString(), DeviceDefinition.DeviceCorrectiveActionScope.NULL, new DeviceDefinition.DeviceCorrectiveActionScopeEnumFactory()));
        }
        if (json.has("_scope")) {
            this.parseElementProperties(this.getJObject(json, "_scope"), res.getScopeElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected DeviceDefinition.DeviceDefinitionChargeItemComponent parseDeviceDefinitionChargeItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionChargeItemComponent res = new DeviceDefinition.DeviceDefinitionChargeItemComponent();
        this.parseDeviceDefinitionChargeItemComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionChargeItemComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionChargeItemComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("chargeItemCode")) {
            res.setChargeItemCode(this.parseCodeableReference(this.getJObject(json, "chargeItemCode")));
        }
        if (json.has("count")) {
            res.setCount(this.parseQuantity(this.getJObject(json, "count")));
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(this.getJObject(json, "effectivePeriod")));
        }
        if (json.has("useContext")) {
            JsonArray array = this.getJArray(json, "useContext");
            for (int i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DeviceDispense parseDeviceDispense(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDispense res = new DeviceDispense();
        this.parseDeviceDispenseProperties(json, res);
        return res;
    }

    protected void parseDeviceDispenseProperties(JsonObject json, DeviceDispense res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("basedOn")) {
            array = this.getJArray(json, "basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("partOf")) {
            array = this.getJArray(json, "partOf");
            for (i = 0; i < array.size(); ++i) {
                res.getPartOf().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DeviceDispense.DeviceDispenseStatusCodes.NULL, new DeviceDispense.DeviceDispenseStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableReference(this.getJObject(json, "statusReason")));
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("device")) {
            res.setDevice(this.parseCodeableReference(this.getJObject(json, "device")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("receiver")) {
            res.setReceiver(this.parseReference(this.getJObject(json, "receiver")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("supportingInformation")) {
            array = this.getJArray(json, "supportingInformation");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("performer")) {
            array = this.getJArray(json, "performer");
            for (i = 0; i < array.size(); ++i) {
                res.getPerformer().add(this.parseDeviceDispensePerformerComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("preparedDate")) {
            res.setPreparedDateElement(this.parseDateTime(json.get("preparedDate").getAsString()));
        }
        if (json.has("_preparedDate")) {
            this.parseElementProperties(this.getJObject(json, "_preparedDate"), res.getPreparedDateElement());
        }
        if (json.has("whenHandedOver")) {
            res.setWhenHandedOverElement(this.parseDateTime(json.get("whenHandedOver").getAsString()));
        }
        if (json.has("_whenHandedOver")) {
            this.parseElementProperties(this.getJObject(json, "_whenHandedOver"), res.getWhenHandedOverElement());
        }
        if (json.has("destination")) {
            res.setDestination(this.parseReference(this.getJObject(json, "destination")));
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("usageInstruction")) {
            res.setUsageInstructionElement(this.parseMarkdown(json.get("usageInstruction").getAsString()));
        }
        if (json.has("_usageInstruction")) {
            this.parseElementProperties(this.getJObject(json, "_usageInstruction"), res.getUsageInstructionElement());
        }
        if (json.has("eventHistory")) {
            array = this.getJArray(json, "eventHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getEventHistory().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DeviceDispense.DeviceDispensePerformerComponent parseDeviceDispensePerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDispense.DeviceDispensePerformerComponent res = new DeviceDispense.DeviceDispensePerformerComponent();
        this.parseDeviceDispensePerformerComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDispensePerformerComponentProperties(JsonObject json, DeviceDispense.DeviceDispensePerformerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("function")) {
            res.setFunction(this.parseCodeableConcept(this.getJObject(json, "function")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
    }

    protected DeviceMetric parseDeviceMetric(JsonObject json) throws IOException, FHIRFormatError {
        DeviceMetric res = new DeviceMetric();
        this.parseDeviceMetricProperties(json, res);
        return res;
    }

    protected void parseDeviceMetricProperties(JsonObject json, DeviceMetric res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCodeableConcept(this.getJObject(json, "unit")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(this.getJObject(json, "device")));
        }
        if (json.has("operationalStatus")) {
            res.setOperationalStatusElement(this.parseEnumeration(json.get("operationalStatus").getAsString(), DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
        }
        if (json.has("_operationalStatus")) {
            this.parseElementProperties(this.getJObject(json, "_operationalStatus"), res.getOperationalStatusElement());
        }
        if (json.has("color")) {
            res.setColorElement(this.parseCode(json.get("color").getAsString()));
        }
        if (json.has("_color")) {
            this.parseElementProperties(this.getJObject(json, "_color"), res.getColorElement());
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(this.getJObject(json, "_category"), res.getCategoryElement());
        }
        if (json.has("measurementFrequency")) {
            res.setMeasurementFrequency(this.parseQuantity(this.getJObject(json, "measurementFrequency")));
        }
        if (json.has("calibration")) {
            array = this.getJArray(json, "calibration");
            for (i = 0; i < array.size(); ++i) {
                res.getCalibration().add(this.parseDeviceMetricCalibrationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricCalibrationComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
        this.parseDeviceMetricCalibrationComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceMetricCalibrationComponentProperties(JsonObject json, DeviceMetric.DeviceMetricCalibrationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("state")) {
            res.setStateElement(this.parseEnumeration(json.get("state").getAsString(), DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
        }
        if (json.has("_state")) {
            this.parseElementProperties(this.getJObject(json, "_state"), res.getStateElement());
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseInstant(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(this.getJObject(json, "_time"), res.getTimeElement());
        }
    }

    protected DeviceRequest parseDeviceRequest(JsonObject json) throws IOException, FHIRFormatError {
        DeviceRequest res = new DeviceRequest();
        this.parseDeviceRequestProperties(json, res);
        return res;
    }

    protected void parseDeviceRequestProperties(JsonObject json, DeviceRequest res) throws IOException, FHIRFormatError {
        int i;
        DataType occurrence;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("instantiatesCanonical")) {
            array = this.getJArray(json, "instantiatesCanonical");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getInstantiatesCanonical().add(new CanonicalType());
                    continue;
                }
                res.getInstantiatesCanonical().add(this.parseCanonical(array.get(i2).getAsString()));
            }
        }
        if (json.has("_instantiatesCanonical")) {
            array = this.getJArray(json, "_instantiatesCanonical");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getInstantiatesCanonical().size()) {
                    res.getInstantiatesCanonical().add(this.parseCanonical(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i2), res.getInstantiatesCanonical().get(i2));
            }
        }
        if (json.has("instantiatesUri")) {
            array = this.getJArray(json, "instantiatesUri");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getInstantiatesUri().add(new UriType());
                    continue;
                }
                res.getInstantiatesUri().add(this.parseUri(array.get(i2).getAsString()));
            }
        }
        if (json.has("_instantiatesUri")) {
            array = this.getJArray(json, "_instantiatesUri");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getInstantiatesUri().size()) {
                    res.getInstantiatesUri().add(this.parseUri(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i2), res.getInstantiatesUri().get(i2));
            }
        }
        if (json.has("basedOn")) {
            array = this.getJArray(json, "basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("replaces")) {
            array = this.getJArray(json, "replaces");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getReplaces().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(this.getJObject(json, "groupIdentifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("intent")) {
            res.setIntentElement(this.parseEnumeration(json.get("intent").getAsString(), Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
        }
        if (json.has("_intent")) {
            this.parseElementProperties(this.getJObject(json, "_intent"), res.getIntentElement());
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(this.getJObject(json, "_priority"), res.getPriorityElement());
        }
        if (json.has("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(json.get("doNotPerform").getAsBoolean()));
        }
        if (json.has("_doNotPerform")) {
            this.parseElementProperties(this.getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableReference(this.getJObject(json, "code")));
        }
        if (json.has("quantity")) {
            res.setQuantityElement(this.parseInteger(json.get("quantity").getAsLong()));
        }
        if (json.has("_quantity")) {
            this.parseElementProperties(this.getJObject(json, "_quantity"), res.getQuantityElement());
        }
        if (json.has("parameter")) {
            array = this.getJArray(json, "parameter");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getParameter().add(this.parseDeviceRequestParameterComponent(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(json.get("authoredOn").getAsString()));
        }
        if (json.has("_authoredOn")) {
            this.parseElementProperties(this.getJObject(json, "_authoredOn"), res.getAuthoredOnElement());
        }
        if (json.has("requester")) {
            res.setRequester(this.parseReference(this.getJObject(json, "requester")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseCodeableReference(this.getJObject(json, "performer")));
        }
        if (json.has("reason")) {
            JsonArray array2 = this.getJArray(json, "reason");
            for (i = 0; i < array2.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("asNeeded")) {
            res.setAsNeededElement(this.parseBoolean(json.get("asNeeded").getAsBoolean()));
        }
        if (json.has("_asNeeded")) {
            this.parseElementProperties(this.getJObject(json, "_asNeeded"), res.getAsNeededElement());
        }
        if (json.has("asNeededFor")) {
            res.setAsNeededFor(this.parseCodeableConcept(this.getJObject(json, "asNeededFor")));
        }
        if (json.has("insurance")) {
            JsonArray array3 = this.getJArray(json, "insurance");
            for (i = 0; i < array3.size(); ++i) {
                res.getInsurance().add(this.parseReference(this.getJsonObjectFromArray(array3, i)));
            }
        }
        if (json.has("supportingInfo")) {
            JsonArray array4 = this.getJArray(json, "supportingInfo");
            for (i = 0; i < array4.size(); ++i) {
                res.getSupportingInfo().add(this.parseReference(this.getJsonObjectFromArray(array4, i)));
            }
        }
        if (json.has("note")) {
            JsonArray array5 = this.getJArray(json, "note");
            for (i = 0; i < array5.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array5, i)));
            }
        }
        if (json.has("relevantHistory")) {
            JsonArray array6 = this.getJArray(json, "relevantHistory");
            for (i = 0; i < array6.size(); ++i) {
                res.getRelevantHistory().add(this.parseReference(this.getJsonObjectFromArray(array6, i)));
            }
        }
    }

    protected DeviceRequest.DeviceRequestParameterComponent parseDeviceRequestParameterComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceRequest.DeviceRequestParameterComponent res = new DeviceRequest.DeviceRequestParameterComponent();
        this.parseDeviceRequestParameterComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceRequestParameterComponentProperties(JsonObject json, DeviceRequest.DeviceRequestParameterComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected DeviceUsage parseDeviceUsage(JsonObject json) throws IOException, FHIRFormatError {
        DeviceUsage res = new DeviceUsage();
        this.parseDeviceUsageProperties(json, res);
        return res;
    }

    protected void parseDeviceUsageProperties(JsonObject json, DeviceUsage res) throws IOException, FHIRFormatError {
        int i;
        DataType timing;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("basedOn")) {
            array = this.getJArray(json, "basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DeviceUsage.DeviceUsageStatus.NULL, new DeviceUsage.DeviceUsageStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("derivedFrom")) {
            array = this.getJArray(json, "derivedFrom");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDerivedFrom().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(this.getJObject(json, "context")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if (json.has("dateAsserted")) {
            res.setDateAssertedElement(this.parseDateTime(json.get("dateAsserted").getAsString()));
        }
        if (json.has("_dateAsserted")) {
            this.parseElementProperties(this.getJObject(json, "_dateAsserted"), res.getDateAssertedElement());
        }
        if (json.has("usageStatus")) {
            res.setUsageStatus(this.parseCodeableConcept(this.getJObject(json, "usageStatus")));
        }
        if (json.has("usageReason")) {
            JsonArray array2 = this.getJArray(json, "usageReason");
            for (i = 0; i < array2.size(); ++i) {
                res.getUsageReason().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("adherence")) {
            res.setAdherence(this.parseDeviceUsageAdherenceComponent(this.getJObject(json, "adherence")));
        }
        if (json.has("informationSource")) {
            res.setInformationSource(this.parseReference(this.getJObject(json, "informationSource")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseCodeableReference(this.getJObject(json, "device")));
        }
        if (json.has("reason")) {
            JsonArray array3 = this.getJArray(json, "reason");
            for (i = 0; i < array3.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(this.getJsonObjectFromArray(array3, i)));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableReference(this.getJObject(json, "bodySite")));
        }
        if (json.has("note")) {
            JsonArray array4 = this.getJArray(json, "note");
            for (i = 0; i < array4.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array4, i)));
            }
        }
    }

    protected DeviceUsage.DeviceUsageAdherenceComponent parseDeviceUsageAdherenceComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceUsage.DeviceUsageAdherenceComponent res = new DeviceUsage.DeviceUsageAdherenceComponent();
        this.parseDeviceUsageAdherenceComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceUsageAdherenceComponentProperties(JsonObject json, DeviceUsage.DeviceUsageAdherenceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("reason")) {
            JsonArray array = this.getJArray(json, "reason");
            for (int i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DiagnosticReport parseDiagnosticReport(JsonObject json) throws IOException, FHIRFormatError {
        DiagnosticReport res = new DiagnosticReport();
        this.parseDiagnosticReportProperties(json, res);
        return res;
    }

    protected void parseDiagnosticReportProperties(JsonObject json, DiagnosticReport res) throws IOException, FHIRFormatError {
        int i;
        DataType effective;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("basedOn")) {
            array = this.getJArray(json, "basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseInstant(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(this.getJObject(json, "_issued"), res.getIssuedElement());
        }
        if (json.has("performer")) {
            JsonArray array2 = this.getJArray(json, "performer");
            for (i = 0; i < array2.size(); ++i) {
                res.getPerformer().add(this.parseReference(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("resultsInterpreter")) {
            JsonArray array3 = this.getJArray(json, "resultsInterpreter");
            for (i = 0; i < array3.size(); ++i) {
                res.getResultsInterpreter().add(this.parseReference(this.getJsonObjectFromArray(array3, i)));
            }
        }
        if (json.has("specimen")) {
            JsonArray array4 = this.getJArray(json, "specimen");
            for (i = 0; i < array4.size(); ++i) {
                res.getSpecimen().add(this.parseReference(this.getJsonObjectFromArray(array4, i)));
            }
        }
        if (json.has("result")) {
            JsonArray array5 = this.getJArray(json, "result");
            for (i = 0; i < array5.size(); ++i) {
                res.getResult().add(this.parseReference(this.getJsonObjectFromArray(array5, i)));
            }
        }
        if (json.has("note")) {
            JsonArray array6 = this.getJArray(json, "note");
            for (i = 0; i < array6.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array6, i)));
            }
        }
        if (json.has("study")) {
            JsonArray array7 = this.getJArray(json, "study");
            for (i = 0; i < array7.size(); ++i) {
                res.getStudy().add(this.parseReference(this.getJsonObjectFromArray(array7, i)));
            }
        }
        if (json.has("supportingInfo")) {
            JsonArray array8 = this.getJArray(json, "supportingInfo");
            for (i = 0; i < array8.size(); ++i) {
                res.getSupportingInfo().add(this.parseDiagnosticReportSupportingInfoComponent(this.getJsonObjectFromArray(array8, i)));
            }
        }
        if (json.has("media")) {
            JsonArray array9 = this.getJArray(json, "media");
            for (i = 0; i < array9.size(); ++i) {
                res.getMedia().add(this.parseDiagnosticReportMediaComponent(this.getJsonObjectFromArray(array9, i)));
            }
        }
        if (json.has("composition")) {
            res.setComposition(this.parseReference(this.getJObject(json, "composition")));
        }
        if (json.has("conclusion")) {
            res.setConclusionElement(this.parseMarkdown(json.get("conclusion").getAsString()));
        }
        if (json.has("_conclusion")) {
            this.parseElementProperties(this.getJObject(json, "_conclusion"), res.getConclusionElement());
        }
        if (json.has("conclusionCode")) {
            JsonArray array10 = this.getJArray(json, "conclusionCode");
            for (i = 0; i < array10.size(); ++i) {
                res.getConclusionCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array10, i)));
            }
        }
        if (json.has("presentedForm")) {
            JsonArray array11 = this.getJArray(json, "presentedForm");
            for (i = 0; i < array11.size(); ++i) {
                res.getPresentedForm().add(this.parseAttachment(this.getJsonObjectFromArray(array11, i)));
            }
        }
    }

    protected DiagnosticReport.DiagnosticReportSupportingInfoComponent parseDiagnosticReportSupportingInfoComponent(JsonObject json) throws IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportSupportingInfoComponent res = new DiagnosticReport.DiagnosticReportSupportingInfoComponent();
        this.parseDiagnosticReportSupportingInfoComponentProperties(json, res);
        return res;
    }

    protected void parseDiagnosticReportSupportingInfoComponentProperties(JsonObject json, DiagnosticReport.DiagnosticReportSupportingInfoComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
    }

    protected DiagnosticReport.DiagnosticReportMediaComponent parseDiagnosticReportMediaComponent(JsonObject json) throws IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportMediaComponent res = new DiagnosticReport.DiagnosticReportMediaComponent();
        this.parseDiagnosticReportMediaComponentProperties(json, res);
        return res;
    }

    protected void parseDiagnosticReportMediaComponentProperties(JsonObject json, DiagnosticReport.DiagnosticReportMediaComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
        if (json.has("link")) {
            res.setLink(this.parseReference(this.getJObject(json, "link")));
        }
    }

    protected DocumentReference parseDocumentReference(JsonObject json) throws IOException, FHIRFormatError {
        DocumentReference res = new DocumentReference();
        this.parseDocumentReferenceProperties(json, res);
        return res;
    }

    protected void parseDocumentReferenceProperties(JsonObject json, DocumentReference res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("basedOn")) {
            array = this.getJArray(json, "basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DocumentReference.DocumentReferenceStatus.NULL, new DocumentReference.DocumentReferenceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("docStatus")) {
            res.setDocStatusElement(this.parseEnumeration(json.get("docStatus").getAsString(), Enumerations.CompositionStatus.NULL, new Enumerations.CompositionStatusEnumFactory()));
        }
        if (json.has("_docStatus")) {
            this.parseElementProperties(this.getJObject(json, "_docStatus"), res.getDocStatusElement());
        }
        if (json.has("modality")) {
            array = this.getJArray(json, "modality");
            for (i = 0; i < array.size(); ++i) {
                res.getModality().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("category")) {
            array = this.getJArray(json, "category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("context")) {
            array = this.getJArray(json, "context");
            for (i = 0; i < array.size(); ++i) {
                res.getContext().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("event")) {
            array = this.getJArray(json, "event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("bodySite")) {
            array = this.getJArray(json, "bodySite");
            for (i = 0; i < array.size(); ++i) {
                res.getBodySite().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("facilityType")) {
            res.setFacilityType(this.parseCodeableConcept(this.getJObject(json, "facilityType")));
        }
        if (json.has("practiceSetting")) {
            res.setPracticeSetting(this.parseCodeableConcept(this.getJObject(json, "practiceSetting")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseInstant(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("author")) {
            array = this.getJArray(json, "author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("attester")) {
            array = this.getJArray(json, "attester");
            for (i = 0; i < array.size(); ++i) {
                res.getAttester().add(this.parseDocumentReferenceAttesterComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(this.getJObject(json, "custodian")));
        }
        if (json.has("relatesTo")) {
            array = this.getJArray(json, "relatesTo");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatesTo().add(this.parseDocumentReferenceRelatesToComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("securityLabel")) {
            array = this.getJArray(json, "securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("content")) {
            array = this.getJArray(json, "content");
            for (i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseDocumentReferenceContentComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DocumentReference.DocumentReferenceAttesterComponent parseDocumentReferenceAttesterComponent(JsonObject json) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceAttesterComponent res = new DocumentReference.DocumentReferenceAttesterComponent();
        this.parseDocumentReferenceAttesterComponentProperties(json, res);
        return res;
    }

    protected void parseDocumentReferenceAttesterComponentProperties(JsonObject json, DocumentReference.DocumentReferenceAttesterComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setMode(this.parseCodeableConcept(this.getJObject(json, "mode")));
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(this.getJObject(json, "_time"), res.getTimeElement());
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
    }

    protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceRelatesToComponent(JsonObject json) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.parseDocumentReferenceRelatesToComponentProperties(json, res);
        return res;
    }

    protected void parseDocumentReferenceRelatesToComponentProperties(JsonObject json, DocumentReference.DocumentReferenceRelatesToComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(this.getJObject(json, "target")));
        }
    }

    protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceContentComponent(JsonObject json) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
        this.parseDocumentReferenceContentComponentProperties(json, res);
        return res;
    }

    protected void parseDocumentReferenceContentComponentProperties(JsonObject json, DocumentReference.DocumentReferenceContentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("attachment")) {
            res.setAttachment(this.parseAttachment(this.getJObject(json, "attachment")));
        }
        if (json.has("profile")) {
            JsonArray array = this.getJArray(json, "profile");
            for (int i = 0; i < array.size(); ++i) {
                res.getProfile().add(this.parseDocumentReferenceContentProfileComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected DocumentReference.DocumentReferenceContentProfileComponent parseDocumentReferenceContentProfileComponent(JsonObject json) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContentProfileComponent res = new DocumentReference.DocumentReferenceContentProfileComponent();
        this.parseDocumentReferenceContentProfileComponentProperties(json, res);
        return res;
    }

    protected void parseDocumentReferenceContentProfileComponentProperties(JsonObject json, DocumentReference.DocumentReferenceContentProfileComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType value = this.parseType("value", json);
        if (value != null) {
            res.setValue(value);
        }
    }

    protected Encounter parseEncounter(JsonObject json) throws IOException, FHIRFormatError {
        Encounter res = new Encounter();
        this.parseEncounterProperties(json, res);
        return res;
    }

    protected void parseEncounterProperties(JsonObject json, Encounter res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.EncounterStatus.NULL, new Enumerations.EncounterStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("class")) {
            array = this.getJArray(json, "class");
            for (i = 0; i < array.size(); ++i) {
                res.getClass_().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(this.getJObject(json, "priority")));
        }
        if (json.has("type")) {
            array = this.getJArray(json, "type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("serviceType")) {
            array = this.getJArray(json, "serviceType");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceType().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("subjectStatus")) {
            res.setSubjectStatus(this.parseCodeableConcept(this.getJObject(json, "subjectStatus")));
        }
        if (json.has("episodeOfCare")) {
            array = this.getJArray(json, "episodeOfCare");
            for (i = 0; i < array.size(); ++i) {
                res.getEpisodeOfCare().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("basedOn")) {
            array = this.getJArray(json, "basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("careTeam")) {
            array = this.getJArray(json, "careTeam");
            for (i = 0; i < array.size(); ++i) {
                res.getCareTeam().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("partOf")) {
            res.setPartOf(this.parseReference(this.getJObject(json, "partOf")));
        }
        if (json.has("serviceProvider")) {
            res.setServiceProvider(this.parseReference(this.getJObject(json, "serviceProvider")));
        }
        if (json.has("participant")) {
            array = this.getJArray(json, "participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseEncounterParticipantComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("appointment")) {
            array = this.getJArray(json, "appointment");
            for (i = 0; i < array.size(); ++i) {
                res.getAppointment().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("virtualService")) {
            array = this.getJArray(json, "virtualService");
            for (i = 0; i < array.size(); ++i) {
                res.getVirtualService().add(this.parseVirtualServiceDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("actualPeriod")) {
            res.setActualPeriod(this.parsePeriod(this.getJObject(json, "actualPeriod")));
        }
        if (json.has("plannedStartDate")) {
            res.setPlannedStartDateElement(this.parseDateTime(json.get("plannedStartDate").getAsString()));
        }
        if (json.has("_plannedStartDate")) {
            this.parseElementProperties(this.getJObject(json, "_plannedStartDate"), res.getPlannedStartDateElement());
        }
        if (json.has("plannedEndDate")) {
            res.setPlannedEndDateElement(this.parseDateTime(json.get("plannedEndDate").getAsString()));
        }
        if (json.has("_plannedEndDate")) {
            this.parseElementProperties(this.getJObject(json, "_plannedEndDate"), res.getPlannedEndDateElement());
        }
        if (json.has("length")) {
            res.setLength(this.parseDuration(this.getJObject(json, "length")));
        }
        if (json.has("reason")) {
            array = this.getJArray(json, "reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseEncounterReasonComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("diagnosis")) {
            array = this.getJArray(json, "diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseEncounterDiagnosisComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("account")) {
            array = this.getJArray(json, "account");
            for (i = 0; i < array.size(); ++i) {
                res.getAccount().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("dietPreference")) {
            array = this.getJArray(json, "dietPreference");
            for (i = 0; i < array.size(); ++i) {
                res.getDietPreference().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("specialArrangement")) {
            array = this.getJArray(json, "specialArrangement");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialArrangement().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("specialCourtesy")) {
            array = this.getJArray(json, "specialCourtesy");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialCourtesy().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("admission")) {
            res.setAdmission(this.parseEncounterAdmissionComponent(this.getJObject(json, "admission")));
        }
        if (json.has("location")) {
            array = this.getJArray(json, "location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseEncounterLocationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Encounter.EncounterParticipantComponent parseEncounterParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
        Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
        this.parseEncounterParticipantComponentProperties(json, res);
        return res;
    }

    protected void parseEncounterParticipantComponentProperties(JsonObject json, Encounter.EncounterParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            JsonArray array = this.getJArray(json, "type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
    }

    protected Encounter.ReasonComponent parseEncounterReasonComponent(JsonObject json) throws IOException, FHIRFormatError {
        Encounter.ReasonComponent res = new Encounter.ReasonComponent();
        this.parseEncounterReasonComponentProperties(json, res);
        return res;
    }

    protected void parseEncounterReasonComponentProperties(JsonObject json, Encounter.ReasonComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("use")) {
            array = this.getJArray(json, "use");
            for (i = 0; i < array.size(); ++i) {
                res.getUse().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("value")) {
            array = this.getJArray(json, "value");
            for (i = 0; i < array.size(); ++i) {
                res.getValue().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
        Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
        this.parseEncounterDiagnosisComponentProperties(json, res);
        return res;
    }

    protected void parseEncounterDiagnosisComponentProperties(JsonObject json, Encounter.DiagnosisComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("condition")) {
            array = this.getJArray(json, "condition");
            for (i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("use")) {
            array = this.getJArray(json, "use");
            for (i = 0; i < array.size(); ++i) {
                res.getUse().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Encounter.EncounterAdmissionComponent parseEncounterAdmissionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Encounter.EncounterAdmissionComponent res = new Encounter.EncounterAdmissionComponent();
        this.parseEncounterAdmissionComponentProperties(json, res);
        return res;
    }

    protected void parseEncounterAdmissionComponentProperties(JsonObject json, Encounter.EncounterAdmissionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("preAdmissionIdentifier")) {
            res.setPreAdmissionIdentifier(this.parseIdentifier(this.getJObject(json, "preAdmissionIdentifier")));
        }
        if (json.has("origin")) {
            res.setOrigin(this.parseReference(this.getJObject(json, "origin")));
        }
        if (json.has("admitSource")) {
            res.setAdmitSource(this.parseCodeableConcept(this.getJObject(json, "admitSource")));
        }
        if (json.has("reAdmission")) {
            res.setReAdmission(this.parseCodeableConcept(this.getJObject(json, "reAdmission")));
        }
        if (json.has("destination")) {
            res.setDestination(this.parseReference(this.getJObject(json, "destination")));
        }
        if (json.has("dischargeDisposition")) {
            res.setDischargeDisposition(this.parseCodeableConcept(this.getJObject(json, "dischargeDisposition")));
        }
    }

    protected Encounter.EncounterLocationComponent parseEncounterLocationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
        this.parseEncounterLocationComponentProperties(json, res);
        return res;
    }

    protected void parseEncounterLocationComponentProperties(JsonObject json, Encounter.EncounterLocationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("form")) {
            res.setForm(this.parseCodeableConcept(this.getJObject(json, "form")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected EncounterHistory parseEncounterHistory(JsonObject json) throws IOException, FHIRFormatError {
        EncounterHistory res = new EncounterHistory();
        this.parseEncounterHistoryProperties(json, res);
        return res;
    }

    protected void parseEncounterHistoryProperties(JsonObject json, EncounterHistory res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.EncounterStatus.NULL, new Enumerations.EncounterStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("class")) {
            res.setClass_(this.parseCodeableConcept(this.getJObject(json, "class")));
        }
        if (json.has("type")) {
            array = this.getJArray(json, "type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("serviceType")) {
            array = this.getJArray(json, "serviceType");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceType().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("subjectStatus")) {
            res.setSubjectStatus(this.parseCodeableConcept(this.getJObject(json, "subjectStatus")));
        }
        if (json.has("actualPeriod")) {
            res.setActualPeriod(this.parsePeriod(this.getJObject(json, "actualPeriod")));
        }
        if (json.has("plannedStartDate")) {
            res.setPlannedStartDateElement(this.parseDateTime(json.get("plannedStartDate").getAsString()));
        }
        if (json.has("_plannedStartDate")) {
            this.parseElementProperties(this.getJObject(json, "_plannedStartDate"), res.getPlannedStartDateElement());
        }
        if (json.has("plannedEndDate")) {
            res.setPlannedEndDateElement(this.parseDateTime(json.get("plannedEndDate").getAsString()));
        }
        if (json.has("_plannedEndDate")) {
            this.parseElementProperties(this.getJObject(json, "_plannedEndDate"), res.getPlannedEndDateElement());
        }
        if (json.has("length")) {
            res.setLength(this.parseDuration(this.getJObject(json, "length")));
        }
        if (json.has("location")) {
            array = this.getJArray(json, "location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseEncounterHistoryLocationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected EncounterHistory.EncounterHistoryLocationComponent parseEncounterHistoryLocationComponent(JsonObject json) throws IOException, FHIRFormatError {
        EncounterHistory.EncounterHistoryLocationComponent res = new EncounterHistory.EncounterHistoryLocationComponent();
        this.parseEncounterHistoryLocationComponentProperties(json, res);
        return res;
    }

    protected void parseEncounterHistoryLocationComponentProperties(JsonObject json, EncounterHistory.EncounterHistoryLocationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("form")) {
            res.setForm(this.parseCodeableConcept(this.getJObject(json, "form")));
        }
    }

    protected Endpoint parseEndpoint(JsonObject json) throws IOException, FHIRFormatError {
        Endpoint res = new Endpoint();
        this.parseEndpointProperties(json, res);
        return res;
    }

    protected void parseEndpointProperties(JsonObject json, Endpoint res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("connectionType")) {
            array = this.getJArray(json, "connectionType");
            for (i = 0; i < array.size(); ++i) {
                res.getConnectionType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("environmentType")) {
            array = this.getJArray(json, "environmentType");
            for (i = 0; i < array.size(); ++i) {
                res.getEnvironmentType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(this.getJObject(json, "managingOrganization")));
        }
        if (json.has("contact")) {
            array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactPoint(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("payload")) {
            array = this.getJArray(json, "payload");
            for (i = 0; i < array.size(); ++i) {
                res.getPayload().add(this.parseEndpointPayloadComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("address")) {
            res.setAddressElement(this.parseUrl(json.get("address").getAsString()));
        }
        if (json.has("_address")) {
            this.parseElementProperties(this.getJObject(json, "_address"), res.getAddressElement());
        }
        if (json.has("header")) {
            array = this.getJArray(json, "header");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getHeader().add(new StringType());
                    continue;
                }
                res.getHeader().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_header")) {
            array = this.getJArray(json, "_header");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getHeader().size()) {
                    res.getHeader().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getHeader().get(i));
            }
        }
    }

    protected Endpoint.EndpointPayloadComponent parseEndpointPayloadComponent(JsonObject json) throws IOException, FHIRFormatError {
        Endpoint.EndpointPayloadComponent res = new Endpoint.EndpointPayloadComponent();
        this.parseEndpointPayloadComponentProperties(json, res);
        return res;
    }

    protected void parseEndpointPayloadComponentProperties(JsonObject json, Endpoint.EndpointPayloadComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            array = this.getJArray(json, "type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("mimeType")) {
            array = this.getJArray(json, "mimeType");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getMimeType().add(new CodeType());
                    continue;
                }
                res.getMimeType().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_mimeType")) {
            array = this.getJArray(json, "_mimeType");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getMimeType().size()) {
                    res.getMimeType().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getMimeType().get(i));
            }
        }
    }

    protected EnrollmentRequest parseEnrollmentRequest(JsonObject json) throws IOException, FHIRFormatError {
        EnrollmentRequest res = new EnrollmentRequest();
        this.parseEnrollmentRequestProperties(json, res);
        return res;
    }

    protected void parseEnrollmentRequestProperties(JsonObject json, EnrollmentRequest res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("candidate")) {
            res.setCandidate(this.parseReference(this.getJObject(json, "candidate")));
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
    }

    protected EnrollmentResponse parseEnrollmentResponse(JsonObject json) throws IOException, FHIRFormatError {
        EnrollmentResponse res = new EnrollmentResponse();
        this.parseEnrollmentResponseProperties(json, res);
        return res;
    }

    protected void parseEnrollmentResponseProperties(JsonObject json, EnrollmentResponse res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(this.getJObject(json, "request")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), EnrollmentResponse.EnrollmentOutcome.NULL, new EnrollmentResponse.EnrollmentOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(this.getJObject(json, "_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(this.getJObject(json, "_disposition"), res.getDispositionElement());
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(this.getJObject(json, "organization")));
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(this.getJObject(json, "requestProvider")));
        }
    }

    protected EpisodeOfCare parseEpisodeOfCare(JsonObject json) throws IOException, FHIRFormatError {
        EpisodeOfCare res = new EpisodeOfCare();
        this.parseEpisodeOfCareProperties(json, res);
        return res;
    }

    protected void parseEpisodeOfCareProperties(JsonObject json, EpisodeOfCare res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusHistory")) {
            array = this.getJArray(json, "statusHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusHistory().add(this.parseEpisodeOfCareStatusHistoryComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("type")) {
            array = this.getJArray(json, "type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("reason")) {
            array = this.getJArray(json, "reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseEpisodeOfCareReasonComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("diagnosis")) {
            array = this.getJArray(json, "diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseEpisodeOfCareDiagnosisComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(this.getJObject(json, "managingOrganization")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("referralRequest")) {
            array = this.getJArray(json, "referralRequest");
            for (i = 0; i < array.size(); ++i) {
                res.getReferralRequest().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("careManager")) {
            res.setCareManager(this.parseReference(this.getJObject(json, "careManager")));
        }
        if (json.has("careTeam")) {
            array = this.getJArray(json, "careTeam");
            for (i = 0; i < array.size(); ++i) {
                res.getCareTeam().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("account")) {
            array = this.getJArray(json, "account");
            for (i = 0; i < array.size(); ++i) {
                res.getAccount().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareStatusHistoryComponent(JsonObject json) throws IOException, FHIRFormatError {
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        this.parseEpisodeOfCareStatusHistoryComponentProperties(json, res);
        return res;
    }

    protected void parseEpisodeOfCareStatusHistoryComponentProperties(JsonObject json, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected EpisodeOfCare.ReasonComponent parseEpisodeOfCareReasonComponent(JsonObject json) throws IOException, FHIRFormatError {
        EpisodeOfCare.ReasonComponent res = new EpisodeOfCare.ReasonComponent();
        this.parseEpisodeOfCareReasonComponentProperties(json, res);
        return res;
    }

    protected void parseEpisodeOfCareReasonComponentProperties(JsonObject json, EpisodeOfCare.ReasonComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("use")) {
            res.setUse(this.parseCodeableConcept(this.getJObject(json, "use")));
        }
        if (json.has("value")) {
            JsonArray array = this.getJArray(json, "value");
            for (int i = 0; i < array.size(); ++i) {
                res.getValue().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
        EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
        this.parseEpisodeOfCareDiagnosisComponentProperties(json, res);
        return res;
    }

    protected void parseEpisodeOfCareDiagnosisComponentProperties(JsonObject json, EpisodeOfCare.DiagnosisComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("condition")) {
            JsonArray array = this.getJArray(json, "condition");
            for (int i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("use")) {
            res.setUse(this.parseCodeableConcept(this.getJObject(json, "use")));
        }
    }

    protected EventDefinition parseEventDefinition(JsonObject json) throws IOException, FHIRFormatError {
        EventDefinition res = new EventDefinition();
        this.parseEventDefinitionProperties(json, res);
        return res;
    }

    protected void parseEventDefinitionProperties(JsonObject json, EventDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType subject;
        DataType versionAlgorithm;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array2 = this.getJArray(json, "identifier");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("subtitle")) {
            res.setSubtitleElement(this.parseString(json.get("subtitle").getAsString()));
        }
        if (json.has("_subtitle")) {
            this.parseElementProperties(this.getJObject(json, "_subtitle"), res.getSubtitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if ((subject = this.parseType("subject", json)) != null) {
            res.setSubject(subject);
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("jurisdiction")) {
            array = this.getJArray(json, "jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("usage")) {
            res.setUsageElement(this.parseMarkdown(json.get("usage").getAsString()));
        }
        if (json.has("_usage")) {
            this.parseElementProperties(this.getJObject(json, "_usage"), res.getUsageElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(json.get("copyrightLabel").getAsString()));
        }
        if (json.has("_copyrightLabel")) {
            this.parseElementProperties(this.getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(this.getJObject(json, "effectivePeriod")));
        }
        if (json.has("topic")) {
            array = this.getJArray(json, "topic");
            for (i = 0; i < array.size(); ++i) {
                res.getTopic().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("author")) {
            array = this.getJArray(json, "author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("editor")) {
            array = this.getJArray(json, "editor");
            for (i = 0; i < array.size(); ++i) {
                res.getEditor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("reviewer")) {
            array = this.getJArray(json, "reviewer");
            for (i = 0; i < array.size(); ++i) {
                res.getReviewer().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("endorser")) {
            array = this.getJArray(json, "endorser");
            for (i = 0; i < array.size(); ++i) {
                res.getEndorser().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("relatedArtifact")) {
            array = this.getJArray(json, "relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("trigger")) {
            array = this.getJArray(json, "trigger");
            for (i = 0; i < array.size(); ++i) {
                res.getTrigger().add(this.parseTriggerDefinition(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Evidence parseEvidence(JsonObject json) throws IOException, FHIRFormatError {
        Evidence res = new Evidence();
        this.parseEvidenceProperties(json, res);
        return res;
    }

    protected void parseEvidenceProperties(JsonObject json, Evidence res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType citeAs;
        DataType versionAlgorithm;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array2 = this.getJArray(json, "identifier");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if ((citeAs = this.parseType("citeAs", json)) != null) {
            res.setCiteAs(citeAs);
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("author")) {
            array = this.getJArray(json, "author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("editor")) {
            array = this.getJArray(json, "editor");
            for (i = 0; i < array.size(); ++i) {
                res.getEditor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("reviewer")) {
            array = this.getJArray(json, "reviewer");
            for (i = 0; i < array.size(); ++i) {
                res.getReviewer().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("endorser")) {
            array = this.getJArray(json, "endorser");
            for (i = 0; i < array.size(); ++i) {
                res.getEndorser().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("useContext")) {
            array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(json.get("copyrightLabel").getAsString()));
        }
        if (json.has("_copyrightLabel")) {
            this.parseElementProperties(this.getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
        }
        if (json.has("relatedArtifact")) {
            array = this.getJArray(json, "relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("assertion")) {
            res.setAssertionElement(this.parseMarkdown(json.get("assertion").getAsString()));
        }
        if (json.has("_assertion")) {
            this.parseElementProperties(this.getJObject(json, "_assertion"), res.getAssertionElement());
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("variableDefinition")) {
            array = this.getJArray(json, "variableDefinition");
            for (i = 0; i < array.size(); ++i) {
                res.getVariableDefinition().add(this.parseEvidenceVariableDefinitionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("synthesisType")) {
            res.setSynthesisType(this.parseCodeableConcept(this.getJObject(json, "synthesisType")));
        }
        if (json.has("studyDesign")) {
            array = this.getJArray(json, "studyDesign");
            for (i = 0; i < array.size(); ++i) {
                res.getStudyDesign().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("statistic")) {
            array = this.getJArray(json, "statistic");
            for (i = 0; i < array.size(); ++i) {
                res.getStatistic().add(this.parseEvidenceStatisticComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("certainty")) {
            array = this.getJArray(json, "certainty");
            for (i = 0; i < array.size(); ++i) {
                res.getCertainty().add(this.parseEvidenceCertaintyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Evidence.EvidenceVariableDefinitionComponent parseEvidenceVariableDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Evidence.EvidenceVariableDefinitionComponent res = new Evidence.EvidenceVariableDefinitionComponent();
        this.parseEvidenceVariableDefinitionComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceVariableDefinitionComponentProperties(JsonObject json, Evidence.EvidenceVariableDefinitionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            JsonArray array = this.getJArray(json, "note");
            for (int i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("variableRole")) {
            res.setVariableRole(this.parseCodeableConcept(this.getJObject(json, "variableRole")));
        }
        if (json.has("observed")) {
            res.setObserved(this.parseReference(this.getJObject(json, "observed")));
        }
        if (json.has("intended")) {
            res.setIntended(this.parseReference(this.getJObject(json, "intended")));
        }
        if (json.has("directnessMatch")) {
            res.setDirectnessMatch(this.parseCodeableConcept(this.getJObject(json, "directnessMatch")));
        }
    }

    protected Evidence.EvidenceStatisticComponent parseEvidenceStatisticComponent(JsonObject json) throws IOException, FHIRFormatError {
        Evidence.EvidenceStatisticComponent res = new Evidence.EvidenceStatisticComponent();
        this.parseEvidenceStatisticComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceStatisticComponentProperties(JsonObject json, Evidence.EvidenceStatisticComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("statisticType")) {
            res.setStatisticType(this.parseCodeableConcept(this.getJObject(json, "statisticType")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("numberOfEvents")) {
            res.setNumberOfEventsElement(this.parseUnsignedInt(json.get("numberOfEvents").getAsString()));
        }
        if (json.has("_numberOfEvents")) {
            this.parseElementProperties(this.getJObject(json, "_numberOfEvents"), res.getNumberOfEventsElement());
        }
        if (json.has("numberAffected")) {
            res.setNumberAffectedElement(this.parseUnsignedInt(json.get("numberAffected").getAsString()));
        }
        if (json.has("_numberAffected")) {
            this.parseElementProperties(this.getJObject(json, "_numberAffected"), res.getNumberAffectedElement());
        }
        if (json.has("sampleSize")) {
            res.setSampleSize(this.parseEvidenceStatisticSampleSizeComponent(this.getJObject(json, "sampleSize")));
        }
        if (json.has("attributeEstimate")) {
            array = this.getJArray(json, "attributeEstimate");
            for (i = 0; i < array.size(); ++i) {
                res.getAttributeEstimate().add(this.parseEvidenceStatisticAttributeEstimateComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("modelCharacteristic")) {
            array = this.getJArray(json, "modelCharacteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getModelCharacteristic().add(this.parseEvidenceStatisticModelCharacteristicComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Evidence.EvidenceStatisticSampleSizeComponent parseEvidenceStatisticSampleSizeComponent(JsonObject json) throws IOException, FHIRFormatError {
        Evidence.EvidenceStatisticSampleSizeComponent res = new Evidence.EvidenceStatisticSampleSizeComponent();
        this.parseEvidenceStatisticSampleSizeComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceStatisticSampleSizeComponentProperties(JsonObject json, Evidence.EvidenceStatisticSampleSizeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            JsonArray array = this.getJArray(json, "note");
            for (int i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("numberOfStudies")) {
            res.setNumberOfStudiesElement(this.parseUnsignedInt(json.get("numberOfStudies").getAsString()));
        }
        if (json.has("_numberOfStudies")) {
            this.parseElementProperties(this.getJObject(json, "_numberOfStudies"), res.getNumberOfStudiesElement());
        }
        if (json.has("numberOfParticipants")) {
            res.setNumberOfParticipantsElement(this.parseUnsignedInt(json.get("numberOfParticipants").getAsString()));
        }
        if (json.has("_numberOfParticipants")) {
            this.parseElementProperties(this.getJObject(json, "_numberOfParticipants"), res.getNumberOfParticipantsElement());
        }
        if (json.has("knownDataCount")) {
            res.setKnownDataCountElement(this.parseUnsignedInt(json.get("knownDataCount").getAsString()));
        }
        if (json.has("_knownDataCount")) {
            this.parseElementProperties(this.getJObject(json, "_knownDataCount"), res.getKnownDataCountElement());
        }
    }

    protected Evidence.EvidenceStatisticAttributeEstimateComponent parseEvidenceStatisticAttributeEstimateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Evidence.EvidenceStatisticAttributeEstimateComponent res = new Evidence.EvidenceStatisticAttributeEstimateComponent();
        this.parseEvidenceStatisticAttributeEstimateComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceStatisticAttributeEstimateComponentProperties(JsonObject json, Evidence.EvidenceStatisticAttributeEstimateComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("level")) {
            res.setLevelElement(this.parseDecimal(json.get("level").getAsBigDecimal()));
        }
        if (json.has("_level")) {
            this.parseElementProperties(this.getJObject(json, "_level"), res.getLevelElement());
        }
        if (json.has("range")) {
            res.setRange(this.parseRange(this.getJObject(json, "range")));
        }
        if (json.has("attributeEstimate")) {
            array = this.getJArray(json, "attributeEstimate");
            for (i = 0; i < array.size(); ++i) {
                res.getAttributeEstimate().add(this.parseEvidenceStatisticAttributeEstimateComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Evidence.EvidenceStatisticModelCharacteristicComponent parseEvidenceStatisticModelCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
        Evidence.EvidenceStatisticModelCharacteristicComponent res = new Evidence.EvidenceStatisticModelCharacteristicComponent();
        this.parseEvidenceStatisticModelCharacteristicComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceStatisticModelCharacteristicComponentProperties(JsonObject json, Evidence.EvidenceStatisticModelCharacteristicComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("value")) {
            res.setValue(this.parseQuantity(this.getJObject(json, "value")));
        }
        if (json.has("variable")) {
            array = this.getJArray(json, "variable");
            for (i = 0; i < array.size(); ++i) {
                res.getVariable().add(this.parseEvidenceStatisticModelCharacteristicVariableComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("attributeEstimate")) {
            array = this.getJArray(json, "attributeEstimate");
            for (i = 0; i < array.size(); ++i) {
                res.getAttributeEstimate().add(this.parseEvidenceStatisticAttributeEstimateComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Evidence.EvidenceStatisticModelCharacteristicVariableComponent parseEvidenceStatisticModelCharacteristicVariableComponent(JsonObject json) throws IOException, FHIRFormatError {
        Evidence.EvidenceStatisticModelCharacteristicVariableComponent res = new Evidence.EvidenceStatisticModelCharacteristicVariableComponent();
        this.parseEvidenceStatisticModelCharacteristicVariableComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceStatisticModelCharacteristicVariableComponentProperties(JsonObject json, Evidence.EvidenceStatisticModelCharacteristicVariableComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("variableDefinition")) {
            res.setVariableDefinition(this.parseReference(this.getJObject(json, "variableDefinition")));
        }
        if (json.has("handling")) {
            res.setHandlingElement(this.parseEnumeration(json.get("handling").getAsString(), Enumerations.EvidenceVariableHandling.NULL, new Enumerations.EvidenceVariableHandlingEnumFactory()));
        }
        if (json.has("_handling")) {
            this.parseElementProperties(this.getJObject(json, "_handling"), res.getHandlingElement());
        }
        if (json.has("valueCategory")) {
            array = this.getJArray(json, "valueCategory");
            for (i = 0; i < array.size(); ++i) {
                res.getValueCategory().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("valueQuantity")) {
            array = this.getJArray(json, "valueQuantity");
            for (i = 0; i < array.size(); ++i) {
                res.getValueQuantity().add(this.parseQuantity(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("valueRange")) {
            array = this.getJArray(json, "valueRange");
            for (i = 0; i < array.size(); ++i) {
                res.getValueRange().add(this.parseRange(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected Evidence.EvidenceCertaintyComponent parseEvidenceCertaintyComponent(JsonObject json) throws IOException, FHIRFormatError {
        Evidence.EvidenceCertaintyComponent res = new Evidence.EvidenceCertaintyComponent();
        this.parseEvidenceCertaintyComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceCertaintyComponentProperties(JsonObject json, Evidence.EvidenceCertaintyComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("rating")) {
            res.setRating(this.parseCodeableConcept(this.getJObject(json, "rating")));
        }
        if (json.has("rater")) {
            res.setRaterElement(this.parseString(json.get("rater").getAsString()));
        }
        if (json.has("_rater")) {
            this.parseElementProperties(this.getJObject(json, "_rater"), res.getRaterElement());
        }
        if (json.has("subcomponent")) {
            array = this.getJArray(json, "subcomponent");
            for (i = 0; i < array.size(); ++i) {
                res.getSubcomponent().add(this.parseEvidenceCertaintyComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected EvidenceReport parseEvidenceReport(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceReport res = new EvidenceReport();
        this.parseEvidenceReportProperties(json, res);
        return res;
    }

    protected void parseEvidenceReportProperties(JsonObject json, EvidenceReport res) throws IOException, FHIRFormatError {
        int i;
        DataType citeAs;
        int i2;
        JsonArray array;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("useContext")) {
            array = this.getJArray(json, "useContext");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("relatedIdentifier")) {
            array = this.getJArray(json, "relatedIdentifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getRelatedIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if ((citeAs = this.parseType("citeAs", json)) != null) {
            res.setCiteAs(citeAs);
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("note")) {
            JsonArray array2 = this.getJArray(json, "note");
            for (i = 0; i < array2.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array2, i)));
            }
        }
        if (json.has("relatedArtifact")) {
            JsonArray array3 = this.getJArray(json, "relatedArtifact");
            for (i = 0; i < array3.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array3, i)));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseEvidenceReportSubjectComponent(this.getJObject(json, "subject")));
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array4 = this.getJArray(json, "contact");
            for (i = 0; i < array4.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array4, i)));
            }
        }
        if (json.has("author")) {
            JsonArray array5 = this.getJArray(json, "author");
            for (i = 0; i < array5.size(); ++i) {
                res.getAuthor().add(this.parseContactDetail(this.getJsonObjectFromArray(array5, i)));
            }
        }
        if (json.has("editor")) {
            JsonArray array6 = this.getJArray(json, "editor");
            for (i = 0; i < array6.size(); ++i) {
                res.getEditor().add(this.parseContactDetail(this.getJsonObjectFromArray(array6, i)));
            }
        }
        if (json.has("reviewer")) {
            JsonArray array7 = this.getJArray(json, "reviewer");
            for (i = 0; i < array7.size(); ++i) {
                res.getReviewer().add(this.parseContactDetail(this.getJsonObjectFromArray(array7, i)));
            }
        }
        if (json.has("endorser")) {
            JsonArray array8 = this.getJArray(json, "endorser");
            for (i = 0; i < array8.size(); ++i) {
                res.getEndorser().add(this.parseContactDetail(this.getJsonObjectFromArray(array8, i)));
            }
        }
        if (json.has("relatesTo")) {
            JsonArray array9 = this.getJArray(json, "relatesTo");
            for (i = 0; i < array9.size(); ++i) {
                res.getRelatesTo().add(this.parseEvidenceReportRelatesToComponent(this.getJsonObjectFromArray(array9, i)));
            }
        }
        if (json.has("section")) {
            JsonArray array10 = this.getJArray(json, "section");
            for (i = 0; i < array10.size(); ++i) {
                res.getSection().add(this.parseEvidenceReportSectionComponent(this.getJsonObjectFromArray(array10, i)));
            }
        }
    }

    protected EvidenceReport.EvidenceReportSubjectComponent parseEvidenceReportSubjectComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceReport.EvidenceReportSubjectComponent res = new EvidenceReport.EvidenceReportSubjectComponent();
        this.parseEvidenceReportSubjectComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceReportSubjectComponentProperties(JsonObject json, EvidenceReport.EvidenceReportSubjectComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("characteristic")) {
            array = this.getJArray(json, "characteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseEvidenceReportSubjectCharacteristicComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected EvidenceReport.EvidenceReportSubjectCharacteristicComponent parseEvidenceReportSubjectCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceReport.EvidenceReportSubjectCharacteristicComponent res = new EvidenceReport.EvidenceReportSubjectCharacteristicComponent();
        this.parseEvidenceReportSubjectCharacteristicComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceReportSubjectCharacteristicComponentProperties(JsonObject json, EvidenceReport.EvidenceReportSubjectCharacteristicComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("exclude")) {
            res.setExcludeElement(this.parseBoolean(json.get("exclude").getAsBoolean()));
        }
        if (json.has("_exclude")) {
            this.parseElementProperties(this.getJObject(json, "_exclude"), res.getExcludeElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected EvidenceReport.EvidenceReportRelatesToComponent parseEvidenceReportRelatesToComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceReport.EvidenceReportRelatesToComponent res = new EvidenceReport.EvidenceReportRelatesToComponent();
        this.parseEvidenceReportRelatesToComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceReportRelatesToComponentProperties(JsonObject json, EvidenceReport.EvidenceReportRelatesToComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), EvidenceReport.ReportRelationshipType.NULL, new EvidenceReport.ReportRelationshipTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseEvidenceReportRelatesToTargetComponent(this.getJObject(json, "target")));
        }
    }

    protected EvidenceReport.EvidenceReportRelatesToTargetComponent parseEvidenceReportRelatesToTargetComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceReport.EvidenceReportRelatesToTargetComponent res = new EvidenceReport.EvidenceReportRelatesToTargetComponent();
        this.parseEvidenceReportRelatesToTargetComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceReportRelatesToTargetComponentProperties(JsonObject json, EvidenceReport.EvidenceReportRelatesToTargetComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseMarkdown(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseReference(this.getJObject(json, "resource")));
        }
    }

    protected EvidenceReport.SectionComponent parseEvidenceReportSectionComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceReport.SectionComponent res = new EvidenceReport.SectionComponent();
        this.parseEvidenceReportSectionComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceReportSectionComponentProperties(JsonObject json, EvidenceReport.SectionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("focus")) {
            res.setFocus(this.parseCodeableConcept(this.getJObject(json, "focus")));
        }
        if (json.has("focusReference")) {
            res.setFocusReference(this.parseReference(this.getJObject(json, "focusReference")));
        }
        if (json.has("author")) {
            array = this.getJArray(json, "author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("text")) {
            res.setText(this.parseNarrative(this.getJObject(json, "text")));
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(this.getJObject(json, "orderedBy")));
        }
        if (json.has("entryClassifier")) {
            array = this.getJArray(json, "entryClassifier");
            for (i = 0; i < array.size(); ++i) {
                res.getEntryClassifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("entryReference")) {
            array = this.getJArray(json, "entryReference");
            for (i = 0; i < array.size(); ++i) {
                res.getEntryReference().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("entryQuantity")) {
            array = this.getJArray(json, "entryQuantity");
            for (i = 0; i < array.size(); ++i) {
                res.getEntryQuantity().add(this.parseQuantity(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(this.getJObject(json, "emptyReason")));
        }
        if (json.has("section")) {
            array = this.getJArray(json, "section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseEvidenceReportSectionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected EvidenceVariable parseEvidenceVariable(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceVariable res = new EvidenceVariable();
        this.parseEvidenceVariableProperties(json, res);
        return res;
    }

    protected void parseEvidenceVariableProperties(JsonObject json, EvidenceVariable res) throws IOException, FHIRFormatError {
        int i;
        DataType versionAlgorithm;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("shortTitle")) {
            res.setShortTitleElement(this.parseString(json.get("shortTitle").getAsString()));
        }
        if (json.has("_shortTitle")) {
            this.parseElementProperties(this.getJObject(json, "_shortTitle"), res.getShortTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            JsonArray array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("useContext")) {
            JsonArray array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(json.get("copyrightLabel").getAsString()));
        }
        if (json.has("_copyrightLabel")) {
            this.parseElementProperties(this.getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(this.getJObject(json, "effectivePeriod")));
        }
        if (json.has("author")) {
            JsonArray array = this.getJArray(json, "author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("editor")) {
            JsonArray array = this.getJArray(json, "editor");
            for (i = 0; i < array.size(); ++i) {
                res.getEditor().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("reviewer")) {
            JsonArray array = this.getJArray(json, "reviewer");
            for (i = 0; i < array.size(); ++i) {
                res.getReviewer().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("endorser")) {
            JsonArray array = this.getJArray(json, "endorser");
            for (i = 0; i < array.size(); ++i) {
                res.getEndorser().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("relatedArtifact")) {
            JsonArray array = this.getJArray(json, "relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("actual")) {
            res.setActualElement(this.parseBoolean(json.get("actual").getAsBoolean()));
        }
        if (json.has("_actual")) {
            this.parseElementProperties(this.getJObject(json, "_actual"), res.getActualElement());
        }
        if (json.has("characteristic")) {
            JsonArray array = this.getJArray(json, "characteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseEvidenceVariableCharacteristicComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("handling")) {
            res.setHandlingElement(this.parseEnumeration(json.get("handling").getAsString(), Enumerations.EvidenceVariableHandling.NULL, new Enumerations.EvidenceVariableHandlingEnumFactory()));
        }
        if (json.has("_handling")) {
            this.parseElementProperties(this.getJObject(json, "_handling"), res.getHandlingElement());
        }
        if (json.has("category")) {
            JsonArray array = this.getJArray(json, "category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseEvidenceVariableCategoryComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected EvidenceVariable.EvidenceVariableCharacteristicComponent parseEvidenceVariableCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCharacteristicComponent res = new EvidenceVariable.EvidenceVariableCharacteristicComponent();
        this.parseEvidenceVariableCharacteristicComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceVariableCharacteristicComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCharacteristicComponent res) throws IOException, FHIRFormatError {
        DataType duration;
        DataType instances;
        this.parseBackboneElementProperties(json, res);
        if (json.has("linkId")) {
            res.setLinkIdElement(this.parseId(json.get("linkId").getAsString()));
        }
        if (json.has("_linkId")) {
            this.parseElementProperties(this.getJObject(json, "_linkId"), res.getLinkIdElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            JsonArray array = this.getJArray(json, "note");
            for (int i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("exclude")) {
            res.setExcludeElement(this.parseBoolean(json.get("exclude").getAsBoolean()));
        }
        if (json.has("_exclude")) {
            this.parseElementProperties(this.getJObject(json, "_exclude"), res.getExcludeElement());
        }
        if (json.has("definitionReference")) {
            res.setDefinitionReference(this.parseReference(this.getJObject(json, "definitionReference")));
        }
        if (json.has("definitionCanonical")) {
            res.setDefinitionCanonicalElement(this.parseCanonical(json.get("definitionCanonical").getAsString()));
        }
        if (json.has("_definitionCanonical")) {
            this.parseElementProperties(this.getJObject(json, "_definitionCanonical"), res.getDefinitionCanonicalElement());
        }
        if (json.has("definitionCodeableConcept")) {
            res.setDefinitionCodeableConcept(this.parseCodeableConcept(this.getJObject(json, "definitionCodeableConcept")));
        }
        if (json.has("definitionExpression")) {
            res.setDefinitionExpression(this.parseExpression(this.getJObject(json, "definitionExpression")));
        }
        if (json.has("definitionId")) {
            res.setDefinitionIdElement(this.parseId(json.get("definitionId").getAsString()));
        }
        if (json.has("_definitionId")) {
            this.parseElementProperties(this.getJObject(json, "_definitionId"), res.getDefinitionIdElement());
        }
        if (json.has("definitionByTypeAndValue")) {
            res.setDefinitionByTypeAndValue(this.parseEvidenceVariableCharacteristicDefinitionByTypeAndValueComponent(this.getJObject(json, "definitionByTypeAndValue")));
        }
        if (json.has("definitionByCombination")) {
            res.setDefinitionByCombination(this.parseEvidenceVariableCharacteristicDefinitionByCombinationComponent(this.getJObject(json, "definitionByCombination")));
        }
        if ((instances = this.parseType("instances", json)) != null) {
            res.setInstances(instances);
        }
        if ((duration = this.parseType("duration", json)) != null) {
            res.setDuration(duration);
        }
        if (json.has("timeFromEvent")) {
            JsonArray array = this.getJArray(json, "timeFromEvent");
            for (int i = 0; i < array.size(); ++i) {
                res.getTimeFromEvent().add(this.parseEvidenceVariableCharacteristicTimeFromEventComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent parseEvidenceVariableCharacteristicDefinitionByTypeAndValueComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent res = new EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent();
        this.parseEvidenceVariableCharacteristicDefinitionByTypeAndValueComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceVariableCharacteristicDefinitionByTypeAndValueComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("method")) {
            JsonArray array = this.getJArray(json, "method");
            for (int i = 0; i < array.size(); ++i) {
                res.getMethod().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(this.getJObject(json, "device")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("offset")) {
            res.setOffset(this.parseCodeableConcept(this.getJObject(json, "offset")));
        }
    }

    protected EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent parseEvidenceVariableCharacteristicDefinitionByCombinationComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent res = new EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent();
        this.parseEvidenceVariableCharacteristicDefinitionByCombinationComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceVariableCharacteristicDefinitionByCombinationComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), EvidenceVariable.CharacteristicCombination.NULL, new EvidenceVariable.CharacteristicCombinationEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("threshold")) {
            res.setThresholdElement(this.parsePositiveInt(json.get("threshold").getAsString()));
        }
        if (json.has("_threshold")) {
            this.parseElementProperties(this.getJObject(json, "_threshold"), res.getThresholdElement());
        }
        if (json.has("characteristic")) {
            JsonArray array = this.getJArray(json, "characteristic");
            for (int i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseEvidenceVariableCharacteristicComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent parseEvidenceVariableCharacteristicTimeFromEventComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent res = new EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent();
        this.parseEvidenceVariableCharacteristicTimeFromEventComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceVariableCharacteristicTimeFromEventComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent res) throws IOException, FHIRFormatError {
        DataType event;
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            JsonArray array = this.getJArray(json, "note");
            for (int i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if ((event = this.parseType("event", json)) != null) {
            res.setEvent(event);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("range")) {
            res.setRange(this.parseRange(this.getJObject(json, "range")));
        }
    }

    protected EvidenceVariable.EvidenceVariableCategoryComponent parseEvidenceVariableCategoryComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCategoryComponent res = new EvidenceVariable.EvidenceVariableCategoryComponent();
        this.parseEvidenceVariableCategoryComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceVariableCategoryComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCategoryComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected ExampleScenario parseExampleScenario(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario res = new ExampleScenario();
        this.parseExampleScenarioProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioProperties(JsonObject json, ExampleScenario res) throws IOException, FHIRFormatError {
        int i;
        DataType versionAlgorithm;
        this.parseCanonicalResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array = this.getJArray(json, "identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i2)));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if ((versionAlgorithm = this.parseType("versionAlgorithm", json)) != null) {
            res.setVersionAlgorithm(versionAlgorithm);
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array = this.getJArray(json, "contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            JsonArray array = this.getJArray(json, "useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("jurisdiction")) {
            JsonArray array = this.getJArray(json, "jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(json.get("copyrightLabel").getAsString()));
        }
        if (json.has("_copyrightLabel")) {
            this.parseElementProperties(this.getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
        }
        if (json.has("actor")) {
            JsonArray array = this.getJArray(json, "actor");
            for (i = 0; i < array.size(); ++i) {
                res.getActor().add(this.parseExampleScenarioActorComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("instance")) {
            JsonArray array = this.getJArray(json, "instance");
            for (i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseExampleScenarioInstanceComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("process")) {
            JsonArray array = this.getJArray(json, "process");
            for (i = 0; i < array.size(); ++i) {
                res.getProcess().add(this.parseExampleScenarioProcessComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExampleScenario.ExampleScenarioActorComponent parseExampleScenarioActorComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioActorComponent res = new ExampleScenario.ExampleScenarioActorComponent();
        this.parseExampleScenarioActorComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioActorComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioActorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("key")) {
            res.setKeyElement(this.parseString(json.get("key").getAsString()));
        }
        if (json.has("_key")) {
            this.parseElementProperties(this.getJObject(json, "_key"), res.getKeyElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.ExampleScenarioActorType.NULL, new Enumerations.ExampleScenarioActorTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
    }

    protected ExampleScenario.ExampleScenarioInstanceComponent parseExampleScenarioInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceComponent();
        this.parseExampleScenarioInstanceComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioInstanceComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioInstanceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType structureProfile;
        this.parseBackboneElementProperties(json, res);
        if (json.has("key")) {
            res.setKeyElement(this.parseString(json.get("key").getAsString()));
        }
        if (json.has("_key")) {
            this.parseElementProperties(this.getJObject(json, "_key"), res.getKeyElement());
        }
        if (json.has("structureType")) {
            res.setStructureType(this.parseCoding(this.getJObject(json, "structureType")));
        }
        if (json.has("structureVersion")) {
            res.setStructureVersionElement(this.parseString(json.get("structureVersion").getAsString()));
        }
        if (json.has("_structureVersion")) {
            this.parseElementProperties(this.getJObject(json, "_structureVersion"), res.getStructureVersionElement());
        }
        if ((structureProfile = this.parseType("structureProfile", json)) != null) {
            res.setStructureProfile(structureProfile);
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("content")) {
            res.setContent(this.parseReference(this.getJObject(json, "content")));
        }
        if (json.has("version")) {
            array = this.getJArray(json, "version");
            for (i = 0; i < array.size(); ++i) {
                res.getVersion().add(this.parseExampleScenarioInstanceVersionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("containedInstance")) {
            array = this.getJArray(json, "containedInstance");
            for (i = 0; i < array.size(); ++i) {
                res.getContainedInstance().add(this.parseExampleScenarioInstanceContainedInstanceComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExampleScenario.ExampleScenarioInstanceVersionComponent parseExampleScenarioInstanceVersionComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioInstanceVersionComponent res = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
        this.parseExampleScenarioInstanceVersionComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioInstanceVersionComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioInstanceVersionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("key")) {
            res.setKeyElement(this.parseString(json.get("key").getAsString()));
        }
        if (json.has("_key")) {
            this.parseElementProperties(this.getJObject(json, "_key"), res.getKeyElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("content")) {
            res.setContent(this.parseReference(this.getJObject(json, "content")));
        }
    }

    protected ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent parseExampleScenarioInstanceContainedInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
        this.parseExampleScenarioInstanceContainedInstanceComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioInstanceContainedInstanceComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("instanceReference")) {
            res.setInstanceReferenceElement(this.parseString(json.get("instanceReference").getAsString()));
        }
        if (json.has("_instanceReference")) {
            this.parseElementProperties(this.getJObject(json, "_instanceReference"), res.getInstanceReferenceElement());
        }
        if (json.has("versionReference")) {
            res.setVersionReferenceElement(this.parseString(json.get("versionReference").getAsString()));
        }
        if (json.has("_versionReference")) {
            this.parseElementProperties(this.getJObject(json, "_versionReference"), res.getVersionReferenceElement());
        }
    }

    protected ExampleScenario.ExampleScenarioProcessComponent parseExampleScenarioProcessComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessComponent res = new ExampleScenario.ExampleScenarioProcessComponent();
        this.parseExampleScenarioProcessComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioProcessComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("preConditions")) {
            res.setPreConditionsElement(this.parseMarkdown(json.get("preConditions").getAsString()));
        }
        if (json.has("_preConditions")) {
            this.parseElementProperties(this.getJObject(json, "_preConditions"), res.getPreConditionsElement());
        }
        if (json.has("postConditions")) {
            res.setPostConditionsElement(this.parseMarkdown(json.get("postConditions").getAsString()));
        }
        if (json.has("_postConditions")) {
            this.parseElementProperties(this.getJObject(json, "_postConditions"), res.getPostConditionsElement());
        }
        if (json.has("step")) {
            JsonArray array = this.getJArray(json, "step");
            for (int i = 0; i < array.size(); ++i) {
                res.getStep().add(this.parseExampleScenarioProcessStepComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExampleScenario.ExampleScenarioProcessStepComponent parseExampleScenarioProcessStepComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessStepComponent res = new ExampleScenario.ExampleScenarioProcessStepComponent();
        this.parseExampleScenarioProcessStepComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioProcessStepComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessStepComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parseString(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(this.getJObject(json, "_number"), res.getNumberElement());
        }
        if (json.has("process")) {
            res.setProcess(this.parseExampleScenarioProcessComponent(this.getJObject(json, "process")));
        }
        if (json.has("workflow")) {
            res.setWorkflowElement(this.parseCanonical(json.get("workflow").getAsString()));
        }
        if (json.has("_workflow")) {
            this.parseElementProperties(this.getJObject(json, "_workflow"), res.getWorkflowElement());
        }
        if (json.has("operation")) {
            res.setOperation(this.parseExampleScenarioProcessStepOperationComponent(this.getJObject(json, "operation")));
        }
        if (json.has("alternative")) {
            JsonArray array = this.getJArray(json, "alternative");
            for (int i = 0; i < array.size(); ++i) {
                res.getAlternative().add(this.parseExampleScenarioProcessStepAlternativeComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("pause")) {
            res.setPauseElement(this.parseBoolean(json.get("pause").getAsBoolean()));
        }
        if (json.has("_pause")) {
            this.parseElementProperties(this.getJObject(json, "_pause"), res.getPauseElement());
        }
    }

    protected ExampleScenario.ExampleScenarioProcessStepOperationComponent parseExampleScenarioProcessStepOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessStepOperationComponent res = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
        this.parseExampleScenarioProcessStepOperationComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioProcessStepOperationComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessStepOperationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(this.getJObject(json, "type")));
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("initiator")) {
            res.setInitiatorElement(this.parseString(json.get("initiator").getAsString()));
        }
        if (json.has("_initiator")) {
            this.parseElementProperties(this.getJObject(json, "_initiator"), res.getInitiatorElement());
        }
        if (json.has("receiver")) {
            res.setReceiverElement(this.parseString(json.get("receiver").getAsString()));
        }
        if (json.has("_receiver")) {
            this.parseElementProperties(this.getJObject(json, "_receiver"), res.getReceiverElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("initiatorActive")) {
            res.setInitiatorActiveElement(this.parseBoolean(json.get("initiatorActive").getAsBoolean()));
        }
        if (json.has("_initiatorActive")) {
            this.parseElementProperties(this.getJObject(json, "_initiatorActive"), res.getInitiatorActiveElement());
        }
        if (json.has("receiverActive")) {
            res.setReceiverActiveElement(this.parseBoolean(json.get("receiverActive").getAsBoolean()));
        }
        if (json.has("_receiverActive")) {
            this.parseElementProperties(this.getJObject(json, "_receiverActive"), res.getReceiverActiveElement());
        }
        if (json.has("request")) {
            res.setRequest(this.parseExampleScenarioInstanceContainedInstanceComponent(this.getJObject(json, "request")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseExampleScenarioInstanceContainedInstanceComponent(this.getJObject(json, "response")));
        }
    }

    protected ExampleScenario.ExampleScenarioProcessStepAlternativeComponent parseExampleScenarioProcessStepAlternativeComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
        this.parseExampleScenarioProcessStepAlternativeComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioProcessStepAlternativeComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("step")) {
            JsonArray array = this.getJArray(json, "step");
            for (int i = 0; i < array.size(); ++i) {
                res.getStep().add(this.parseExampleScenarioProcessStepComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExplanationOfBenefit parseExplanationOfBenefit(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit res = new ExplanationOfBenefit();
        this.parseExplanationOfBenefitProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitProperties(JsonObject json, ExplanationOfBenefit res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = this.getJArray(json, "identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(this.getJObject(json, "subType")));
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(this.getJObject(json, "billablePeriod")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(this.getJObject(json, "enterer")));
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(this.getJObject(json, "priority")));
        }
        if (json.has("fundsReserveRequested")) {
            res.setFundsReserveRequested(this.parseCodeableConcept(this.getJObject(json, "fundsReserveRequested")));
        }
        if (json.has("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(this.getJObject(json, "fundsReserve")));
        }
        if (json.has("related")) {
            array = this.getJArray(json, "related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseExplanationOfBenefitRelatedClaimComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("prescription")) {
            res.setPrescription(this.parseReference(this.getJObject(json, "prescription")));
        }
        if (json.has("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(this.getJObject(json, "originalPrescription")));
        }
        if (json.has("event")) {
            array = this.getJArray(json, "event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseExplanationOfBenefitEventComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("payee")) {
            res.setPayee(this.parseExplanationOfBenefitPayeeComponent(this.getJObject(json, "payee")));
        }
        if (json.has("referral")) {
            res.setReferral(this.parseReference(this.getJObject(json, "referral")));
        }
        if (json.has("encounter")) {
            array = this.getJArray(json, "encounter");
            for (i = 0; i < array.size(); ++i) {
                res.getEncounter().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("facility")) {
            res.setFacility(this.parseReference(this.getJObject(json, "facility")));
        }
        if (json.has("claim")) {
            res.setClaim(this.parseReference(this.getJObject(json, "claim")));
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(this.getJObject(json, "claimResponse")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(this.getJObject(json, "_outcome"), res.getOutcomeElement());
        }
        if (json.has("decision")) {
            res.setDecision(this.parseCodeableConcept(this.getJObject(json, "decision")));
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(this.getJObject(json, "_disposition"), res.getDispositionElement());
        }
        if (json.has("preAuthRef")) {
            array = this.getJArray(json, "preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPreAuthRef().add(new StringType());
                    continue;
                }
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = this.getJArray(json, "_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getPreAuthRef().get(i));
            }
        }
        if (json.has("preAuthRefPeriod")) {
            array = this.getJArray(json, "preAuthRefPeriod");
            for (i = 0; i < array.size(); ++i) {
                res.getPreAuthRefPeriod().add(this.parsePeriod(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("diagnosisRelatedGroup")) {
            res.setDiagnosisRelatedGroup(this.parseCodeableConcept(this.getJObject(json, "diagnosisRelatedGroup")));
        }
        if (json.has("careTeam")) {
            array = this.getJArray(json, "careTeam");
            for (i = 0; i < array.size(); ++i) {
                res.getCareTeam().add(this.parseExplanationOfBenefitCareTeamComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("supportingInfo")) {
            array = this.getJArray(json, "supportingInfo");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInfo().add(this.parseExplanationOfBenefitSupportingInformationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("diagnosis")) {
            array = this.getJArray(json, "diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseExplanationOfBenefitDiagnosisComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("procedure")) {
            array = this.getJArray(json, "procedure");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedure().add(this.parseExplanationOfBenefitProcedureComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("precedence")) {
            res.setPrecedenceElement(this.parsePositiveInt(json.get("precedence").getAsString()));
        }
        if (json.has("_precedence")) {
            this.parseElementProperties(this.getJObject(json, "_precedence"), res.getPrecedenceElement());
        }
        if (json.has("insurance")) {
            array = this.getJArray(json, "insurance");
            for (i = 0; i < array.size(); ++i) {
                res.getInsurance().add(this.parseExplanationOfBenefitInsuranceComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("accident")) {
            res.setAccident(this.parseExplanationOfBenefitAccidentComponent(this.getJObject(json, "accident")));
        }
        if (json.has("patientPaid")) {
            res.setPatientPaid(this.parseMoney(this.getJObject(json, "patientPaid")));
        }
        if (json.has("item")) {
            array = this.getJArray(json, "item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseExplanationOfBenefitItemComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("addItem")) {
            array = this.getJArray(json, "addItem");
            for (i = 0; i < array.size(); ++i) {
                res.getAddItem().add(this.parseExplanationOfBenefitAddedItemComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("total")) {
            array = this.getJArray(json, "total");
            for (i = 0; i < array.size(); ++i) {
                res.getTotal().add(this.parseExplanationOfBenefitTotalComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("payment")) {
            res.setPayment(this.parseExplanationOfBenefitPaymentComponent(this.getJObject(json, "payment")));
        }
        if (json.has("formCode")) {
            res.setFormCode(this.parseCodeableConcept(this.getJObject(json, "formCode")));
        }
        if (json.has("form")) {
            res.setForm(this.parseAttachment(this.getJObject(json, "form")));
        }
        if (json.has("processNote")) {
            array = this.getJArray(json, "processNote");
            for (i = 0; i < array.size(); ++i) {
                res.getProcessNote().add(this.parseExplanationOfBenefitNoteComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("benefitPeriod")) {
            res.setBenefitPeriod(this.parsePeriod(this.getJObject(json, "benefitPeriod")));
        }
        if (json.has("benefitBalance")) {
            array = this.getJArray(json, "benefitBalance");
            for (i = 0; i < array.size(); ++i) {
                res.getBenefitBalance().add(this.parseExplanationOfBenefitBenefitBalanceComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
        this.parseExplanationOfBenefitRelatedClaimComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitRelatedClaimComponentProperties(JsonObject json, ExplanationOfBenefit.RelatedClaimComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("claim")) {
            res.setClaim(this.parseReference(this.getJObject(json, "claim")));
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(this.getJObject(json, "relationship")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseIdentifier(this.getJObject(json, "reference")));
        }
    }

    protected ExplanationOfBenefit.ExplanationOfBenefitEventComponent parseExplanationOfBenefitEventComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.ExplanationOfBenefitEventComponent res = new ExplanationOfBenefit.ExplanationOfBenefitEventComponent();
        this.parseExplanationOfBenefitEventComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitEventComponentProperties(JsonObject json, ExplanationOfBenefit.ExplanationOfBenefitEventComponent res) throws IOException, FHIRFormatError {
        DataType when;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((when = this.parseType("when", json)) != null) {
            res.setWhen(when);
        }
    }

    protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
        this.parseExplanationOfBenefitPayeeComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitPayeeComponentProperties(JsonObject json, ExplanationOfBenefit.PayeeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
    }

    protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
        this.parseExplanationOfBenefitCareTeamComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitCareTeamComponentProperties(JsonObject json, ExplanationOfBenefit.CareTeamComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("responsible")) {
            res.setResponsibleElement(this.parseBoolean(json.get("responsible").getAsBoolean()));
        }
        if (json.has("_responsible")) {
            this.parseElementProperties(this.getJObject(json, "_responsible"), res.getResponsibleElement());
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("specialty")) {
            res.setSpecialty(this.parseCodeableConcept(this.getJObject(json, "specialty")));
        }
    }

    protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
        this.parseExplanationOfBenefitSupportingInformationComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitSupportingInformationComponentProperties(JsonObject json, ExplanationOfBenefit.SupportingInformationComponent res) throws IOException, FHIRFormatError {
        DataType value;
        DataType timing;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(this.getJObject(json, "reason")));
        }
    }

    protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
        this.parseExplanationOfBenefitDiagnosisComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitDiagnosisComponentProperties(JsonObject json, ExplanationOfBenefit.DiagnosisComponent res) throws IOException, FHIRFormatError {
        DataType diagnosis;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if ((diagnosis = this.parseType("diagnosis", json)) != null) {
            res.setDiagnosis(diagnosis);
        }
        if (json.has("type")) {
            JsonArray array = this.getJArray(json, "type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("onAdmission")) {
            res.setOnAdmission(this.parseCodeableConcept(this.getJObject(json, "onAdmission")));
        }
    }

    protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
        this.parseExplanationOfBenefitProcedureComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitProcedureComponentProperties(JsonObject json, ExplanationOfBenefit.ProcedureComponent res) throws IOException, FHIRFormatError {
        DataType procedure;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            JsonArray array = this.getJArray(json, "type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if ((procedure = this.parseType("procedure", json)) != null) {
            res.setProcedure(procedure);
        }
        if (json.has("udi")) {
            JsonArray array = this.getJArray(json, "udi");
            for (int i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
        this.parseExplanationOfBenefitInsuranceComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitInsuranceComponentProperties(JsonObject json, ExplanationOfBenefit.InsuranceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(this.getJObject(json, "_focal"), res.getFocalElement());
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
        if (json.has("preAuthRef")) {
            array = this.getJArray(json, "preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPreAuthRef().add(new StringType());
                    continue;
                }
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = this.getJArray(json, "_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getPreAuthRef().get(i));
            }
        }
    }

    protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
        this.parseExplanationOfBenefitAccidentComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitAccidentComponentProperties(JsonObject json, ExplanationOfBenefit.AccidentComponent res) throws IOException, FHIRFormatError {
        DataType location;
        this.parseBackboneElementProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
    }

    protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
        this.parseExplanationOfBenefitItemComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitItemComponentProperties(JsonObject json, ExplanationOfBenefit.ItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType location;
        DataType serviced;
        int i2;
        JsonArray array2;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("careTeamSequence")) {
            array2 = this.getJArray(json, "careTeamSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getCareTeamSequence().add(new PositiveIntType());
                    continue;
                }
                res.getCareTeamSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_careTeamSequence")) {
            array2 = this.getJArray(json, "_careTeamSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getCareTeamSequence().size()) {
                    res.getCareTeamSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getCareTeamSequence().get(i2));
            }
        }
        if (json.has("diagnosisSequence")) {
            array2 = this.getJArray(json, "diagnosisSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getDiagnosisSequence().add(new PositiveIntType());
                    continue;
                }
                res.getDiagnosisSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_diagnosisSequence")) {
            array2 = this.getJArray(json, "_diagnosisSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getDiagnosisSequence().size()) {
                    res.getDiagnosisSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getDiagnosisSequence().get(i2));
            }
        }
        if (json.has("procedureSequence")) {
            array2 = this.getJArray(json, "procedureSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getProcedureSequence().add(new PositiveIntType());
                    continue;
                }
                res.getProcedureSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_procedureSequence")) {
            array2 = this.getJArray(json, "_procedureSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getProcedureSequence().size()) {
                    res.getProcedureSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getProcedureSequence().get(i2));
            }
        }
        if (json.has("informationSequence")) {
            array2 = this.getJArray(json, "informationSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getInformationSequence().add(new PositiveIntType());
                    continue;
                }
                res.getInformationSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_informationSequence")) {
            array2 = this.getJArray(json, "_informationSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getInformationSequence().size()) {
                    res.getInformationSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getInformationSequence().get(i2));
            }
        }
        if (json.has("traceNumber")) {
            array2 = this.getJArray(json, "traceNumber");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(this.getJObject(json, "productOrServiceEnd")));
        }
        if (json.has("request")) {
            array2 = this.getJArray(json, "request");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getRequest().add(this.parseReference(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("modifier")) {
            array2 = this.getJArray(json, "modifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("programCode")) {
            array2 = this.getJArray(json, "programCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProgramCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
        if (json.has("patientPaid")) {
            res.setPatientPaid(this.parseMoney(this.getJObject(json, "patientPaid")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("tax")) {
            res.setTax(this.parseMoney(this.getJObject(json, "tax")));
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("udi")) {
            array = this.getJArray(json, "udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("bodySite")) {
            array = this.getJArray(json, "bodySite");
            for (i = 0; i < array.size(); ++i) {
                res.getBodySite().add(this.parseExplanationOfBenefitItemBodySiteComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("encounter")) {
            array = this.getJArray(json, "encounter");
            for (i = 0; i < array.size(); ++i) {
                res.getEncounter().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("noteNumber")) {
            array = this.getJArray(json, "noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = this.getJArray(json, "_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
            }
        }
        if (json.has("reviewOutcome")) {
            res.setReviewOutcome(this.parseExplanationOfBenefitItemReviewOutcomeComponent(this.getJObject(json, "reviewOutcome")));
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("detail")) {
            array = this.getJArray(json, "detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseExplanationOfBenefitDetailComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExplanationOfBenefit.ItemBodySiteComponent parseExplanationOfBenefitItemBodySiteComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.ItemBodySiteComponent res = new ExplanationOfBenefit.ItemBodySiteComponent();
        this.parseExplanationOfBenefitItemBodySiteComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitItemBodySiteComponentProperties(JsonObject json, ExplanationOfBenefit.ItemBodySiteComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("site")) {
            array = this.getJArray(json, "site");
            for (i = 0; i < array.size(); ++i) {
                res.getSite().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subSite")) {
            array = this.getJArray(json, "subSite");
            for (i = 0; i < array.size(); ++i) {
                res.getSubSite().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExplanationOfBenefit.ItemReviewOutcomeComponent parseExplanationOfBenefitItemReviewOutcomeComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.ItemReviewOutcomeComponent res = new ExplanationOfBenefit.ItemReviewOutcomeComponent();
        this.parseExplanationOfBenefitItemReviewOutcomeComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitItemReviewOutcomeComponentProperties(JsonObject json, ExplanationOfBenefit.ItemReviewOutcomeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("decision")) {
            res.setDecision(this.parseCodeableConcept(this.getJObject(json, "decision")));
        }
        if (json.has("reason")) {
            JsonArray array = this.getJArray(json, "reason");
            for (int i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("preAuthRef")) {
            res.setPreAuthRefElement(this.parseString(json.get("preAuthRef").getAsString()));
        }
        if (json.has("_preAuthRef")) {
            this.parseElementProperties(this.getJObject(json, "_preAuthRef"), res.getPreAuthRefElement());
        }
        if (json.has("preAuthPeriod")) {
            res.setPreAuthPeriod(this.parsePeriod(this.getJObject(json, "preAuthPeriod")));
        }
    }

    protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
        this.parseExplanationOfBenefitAdjudicationComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitAdjudicationComponentProperties(JsonObject json, ExplanationOfBenefit.AdjudicationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(this.getJObject(json, "reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
    }

    protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
        this.parseExplanationOfBenefitDetailComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitDetailComponentProperties(JsonObject json, ExplanationOfBenefit.DetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(this.getJObject(json, "productOrServiceEnd")));
        }
        if (json.has("modifier")) {
            array = this.getJArray(json, "modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("programCode")) {
            array = this.getJArray(json, "programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("patientPaid")) {
            res.setPatientPaid(this.parseMoney(this.getJObject(json, "patientPaid")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("tax")) {
            res.setTax(this.parseMoney(this.getJObject(json, "tax")));
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("udi")) {
            array = this.getJArray(json, "udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("noteNumber")) {
            array = this.getJArray(json, "noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = this.getJArray(json, "_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
            }
        }
        if (json.has("reviewOutcome")) {
            res.setReviewOutcome(this.parseExplanationOfBenefitItemReviewOutcomeComponent(this.getJObject(json, "reviewOutcome")));
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subDetail")) {
            array = this.getJArray(json, "subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseExplanationOfBenefitSubDetailComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
        this.parseExplanationOfBenefitSubDetailComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit.SubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(this.getJObject(json, "productOrServiceEnd")));
        }
        if (json.has("modifier")) {
            array = this.getJArray(json, "modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("programCode")) {
            array = this.getJArray(json, "programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("patientPaid")) {
            res.setPatientPaid(this.parseMoney(this.getJObject(json, "patientPaid")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("tax")) {
            res.setTax(this.parseMoney(this.getJObject(json, "tax")));
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("udi")) {
            array = this.getJArray(json, "udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("noteNumber")) {
            array = this.getJArray(json, "noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = this.getJArray(json, "_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
            }
        }
        if (json.has("reviewOutcome")) {
            res.setReviewOutcome(this.parseExplanationOfBenefitItemReviewOutcomeComponent(this.getJObject(json, "reviewOutcome")));
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
        this.parseExplanationOfBenefitAddedItemComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitAddedItemComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType location;
        DataType serviced;
        int i2;
        JsonArray array2;
        this.parseBackboneElementProperties(json, res);
        if (json.has("itemSequence")) {
            array2 = this.getJArray(json, "itemSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getItemSequence().add(new PositiveIntType());
                    continue;
                }
                res.getItemSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_itemSequence")) {
            array2 = this.getJArray(json, "_itemSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getItemSequence().size()) {
                    res.getItemSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getItemSequence().get(i2));
            }
        }
        if (json.has("detailSequence")) {
            array2 = this.getJArray(json, "detailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getDetailSequence().add(new PositiveIntType());
                    continue;
                }
                res.getDetailSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_detailSequence")) {
            array2 = this.getJArray(json, "_detailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getDetailSequence().size()) {
                    res.getDetailSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getDetailSequence().get(i2));
            }
        }
        if (json.has("subDetailSequence")) {
            array2 = this.getJArray(json, "subDetailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getSubDetailSequence().add(new PositiveIntType());
                    continue;
                }
                res.getSubDetailSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_subDetailSequence")) {
            array2 = this.getJArray(json, "_subDetailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getSubDetailSequence().size()) {
                    res.getSubDetailSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getSubDetailSequence().get(i2));
            }
        }
        if (json.has("traceNumber")) {
            array2 = this.getJArray(json, "traceNumber");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("provider")) {
            array2 = this.getJArray(json, "provider");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProvider().add(this.parseReference(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(this.getJObject(json, "productOrServiceEnd")));
        }
        if (json.has("request")) {
            array2 = this.getJArray(json, "request");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getRequest().add(this.parseReference(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("modifier")) {
            array2 = this.getJArray(json, "modifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("programCode")) {
            array2 = this.getJArray(json, "programCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProgramCode().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
        if (json.has("patientPaid")) {
            res.setPatientPaid(this.parseMoney(this.getJObject(json, "patientPaid")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("tax")) {
            res.setTax(this.parseMoney(this.getJObject(json, "tax")));
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("bodySite")) {
            array = this.getJArray(json, "bodySite");
            for (i = 0; i < array.size(); ++i) {
                res.getBodySite().add(this.parseExplanationOfBenefitAddedItemBodySiteComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("noteNumber")) {
            array = this.getJArray(json, "noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = this.getJArray(json, "_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
            }
        }
        if (json.has("reviewOutcome")) {
            res.setReviewOutcome(this.parseExplanationOfBenefitItemReviewOutcomeComponent(this.getJObject(json, "reviewOutcome")));
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("detail")) {
            array = this.getJArray(json, "detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseExplanationOfBenefitAddedItemDetailComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExplanationOfBenefit.AddedItemBodySiteComponent parseExplanationOfBenefitAddedItemBodySiteComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemBodySiteComponent res = new ExplanationOfBenefit.AddedItemBodySiteComponent();
        this.parseExplanationOfBenefitAddedItemBodySiteComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitAddedItemBodySiteComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemBodySiteComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("site")) {
            array = this.getJArray(json, "site");
            for (i = 0; i < array.size(); ++i) {
                res.getSite().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subSite")) {
            array = this.getJArray(json, "subSite");
            for (i = 0; i < array.size(); ++i) {
                res.getSubSite().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExplanationOfBenefit.AddedItemDetailComponent parseExplanationOfBenefitAddedItemDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemDetailComponent res = new ExplanationOfBenefit.AddedItemDetailComponent();
        this.parseExplanationOfBenefitAddedItemDetailComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitAddedItemDetailComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(this.getJObject(json, "productOrServiceEnd")));
        }
        if (json.has("modifier")) {
            array = this.getJArray(json, "modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("patientPaid")) {
            res.setPatientPaid(this.parseMoney(this.getJObject(json, "patientPaid")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("tax")) {
            res.setTax(this.parseMoney(this.getJObject(json, "tax")));
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("noteNumber")) {
            array = this.getJArray(json, "noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = this.getJArray(json, "_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
            }
        }
        if (json.has("reviewOutcome")) {
            res.setReviewOutcome(this.parseExplanationOfBenefitItemReviewOutcomeComponent(this.getJObject(json, "reviewOutcome")));
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("subDetail")) {
            array = this.getJArray(json, "subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseExplanationOfBenefitAddedItemDetailSubDetailComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExplanationOfBenefit.AddedItemDetailSubDetailComponent parseExplanationOfBenefitAddedItemDetailSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemDetailSubDetailComponent res = new ExplanationOfBenefit.AddedItemDetailSubDetailComponent();
        this.parseExplanationOfBenefitAddedItemDetailSubDetailComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitAddedItemDetailSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemDetailSubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("traceNumber")) {
            array = this.getJArray(json, "traceNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getTraceNumber().add(this.parseIdentifier(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(this.getJObject(json, "productOrServiceEnd")));
        }
        if (json.has("modifier")) {
            array = this.getJArray(json, "modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("patientPaid")) {
            res.setPatientPaid(this.parseMoney(this.getJObject(json, "patientPaid")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("tax")) {
            res.setTax(this.parseMoney(this.getJObject(json, "tax")));
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("noteNumber")) {
            array = this.getJArray(json, "noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = this.getJArray(json, "_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
            }
        }
        if (json.has("reviewOutcome")) {
            res.setReviewOutcome(this.parseExplanationOfBenefitItemReviewOutcomeComponent(this.getJObject(json, "reviewOutcome")));
        }
        if (json.has("adjudication")) {
            array = this.getJArray(json, "adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExplanationOfBenefit.TotalComponent parseExplanationOfBenefitTotalComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.TotalComponent res = new ExplanationOfBenefit.TotalComponent();
        this.parseExplanationOfBenefitTotalComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitTotalComponentProperties(JsonObject json, ExplanationOfBenefit.TotalComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
    }

    protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
        this.parseExplanationOfBenefitPaymentComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitPaymentComponentProperties(JsonObject json, ExplanationOfBenefit.PaymentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("adjustment")) {
            res.setAdjustment(this.parseMoney(this.getJObject(json, "adjustment")));
        }
        if (json.has("adjustmentReason")) {
            res.setAdjustmentReason(this.parseCodeableConcept(this.getJObject(json, "adjustmentReason")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
    }

    protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
        this.parseExplanationOfBenefitNoteComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitNoteComponentProperties(JsonObject json, ExplanationOfBenefit.NoteComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parsePositiveInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(this.getJObject(json, "_number"), res.getNumberElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(this.getJObject(json, "language")));
        }
    }

    protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
        this.parseExplanationOfBenefitBenefitBalanceComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitBenefitBalanceComponentProperties(JsonObject json, ExplanationOfBenefit.BenefitBalanceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("excluded")) {
            res.setExcludedElement(this.parseBoolean(json.get("excluded").getAsBoolean()));
        }
        if (json.has("_excluded")) {
            this.parseElementProperties(this.getJObject(json, "_excluded"), res.getExcludedElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("network")) {
            res.setNetwork(this.parseCodeableConcept(this.getJObject(json, "network")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCodeableConcept(this.getJObject(json, "unit")));
        }
        if (json.has("term")) {
            res.setTerm(this.parseCodeableConcept(this.getJObject(json, "term")));
        }
        if (json.has("financial")) {
            JsonArray array = this.getJArray(json, "financial");
            for (int i = 0; i < array.size(); ++i) {
                res.getFinancial().add(this.parseExplanationOfBenefitBenefitComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
        this.parseExplanationOfBenefitBenefitComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitBenefitComponentProperties(JsonObject json, ExplanationOfBenefit.BenefitComponent res) throws IOException, FHIRFormatError {
        DataType used;
        DataType allowed;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((allowed = this.parseType("allowed", json)) != null) {
            res.setAllowed(allowed);
        }
        if ((used = this.parseType("used", json)) != null) {
            res.setUsed(used);
        }
    }

    protected FamilyMemberHistory parseFamilyMemberHistory(JsonObject json) throws IOException, FHIRFormatError {
        FamilyMemberHistory res = new FamilyMemberHistory();
        this.parseFamilyMemberHistoryProperties(json, res);
        return res;
    }

    protected void parseFamilyMemberHistoryProperties(JsonObject json, FamilyMemberHistory res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType deceased;
        DataType age;
        DataType born;
        int i2;
        JsonArray array2;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array2 = this.getJArray(json, "identifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("instantiatesCanonical")) {
            array2 = this.getJArray(json, "instantiatesCanonical");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getInstantiatesCanonical().add(new CanonicalType());
                    continue;
                }
                res.getInstantiatesCanonical().add(this.parseCanonical(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_instantiatesCanonical")) {
            array2 = this.getJArray(json, "_instantiatesCanonical");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getInstantiatesCanonical().size()) {
                    res.getInstantiatesCanonical().add(this.parseCanonical(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getInstantiatesCanonical().get(i2));
            }
        }
        if (json.has("instantiatesUri")) {
            array2 = this.getJArray(json, "instantiatesUri");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getInstantiatesUri().add(new UriType());
                    continue;
                }
                res.getInstantiatesUri().add(this.parseUri(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_instantiatesUri")) {
            array2 = this.getJArray(json, "_instantiatesUri");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getInstantiatesUri().size()) {
                    res.getInstantiatesUri().add(this.parseUri(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(this.getJsonObjectFromArray(array2, i2), res.getInstantiatesUri().get(i2));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("dataAbsentReason")) {
            res.setDataAbsentReason(this.parseCodeableConcept(this.getJObject(json, "dataAbsentReason")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("participant")) {
            array2 = this.getJArray(json, "participant");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getParticipant().add(this.parseFamilyMemberHistoryParticipantComponent(this.getJsonObjectFromArray(array2, i2)));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(this.getJObject(json, "relationship")));
        }
        if (json.has("sex")) {
            res.setSex(this.parseCodeableConcept(this.getJObject(json, "sex")));
        }
        if ((born = this.parseType("born", json)) != null) {
            res.setBorn(born);
        }
        if ((age = this.parseType("age", json)) != null) {
            res.setAge(age);
        }
        if (json.has("estimatedAge")) {
            res.setEstimatedAgeElement(this.parseBoolean(json.get("estimatedAge").getAsBoolean()));
        }
        if (json.has("_estimatedAge")) {
            this.parseElementProperties(this.getJObject(json, "_estimatedAge"), res.getEstimatedAgeElement());
        }
        if ((deceased = this.parseType("deceased", json)) != null) {
            res.setDeceased(deceased);
        }
        if (json.has("reason")) {
            array = this.getJArray(json, "reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("note")) {
            array = this.getJArray(json, "note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("condition")) {
            array = this.getJArray(json, "condition");
            for (i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseFamilyMemberHistoryConditionComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
        if (json.has("procedure")) {
            array = this.getJArray(json, "procedure");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedure().add(this.parseFamilyMemberHistoryProcedureComponent(this.getJsonObjectFromArray(array, i)));
            }
        }
    }

    protected FamilyMemberHistory.FamilyMemberHistoryParticipantComponent parseFami