/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.liquid;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class GlobalObject
extends Base {
    private DateTimeType dt;
    private StringType pathToSpec;

    public GlobalObject(DateTimeType td, StringType pathToSpec) {
        this.dt = td;
        this.pathToSpec = pathToSpec;
    }

    @Override
    public String fhirType() {
        return "GlobalObject";
    }

    @Override
    public String getIdBase() {
        return null;
    }

    @Override
    public void setIdBase(String value) {
        throw new Error("Read only");
    }

    @Override
    public Base copy() {
        return this;
    }

    @Override
    public FhirPublication getFHIRPublicationVersion() {
        return FhirPublication.R5;
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        if ("dateTime".equals(name)) {
            return this.wrap(this.dt);
        }
        if ("path".equals(name)) {
            return this.wrap(this.pathToSpec);
        }
        return super.getProperty(hash, name, checkValid);
    }

    private Base[] wrap(Base b) {
        Base[] l = new Base[]{b};
        return l;
    }

    @Override
    public List<Base> executeFunction(FHIRPathEngine engine, Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
        return null;
    }

    public static class GlobalObjectRandomFunction
    extends FHIRPathEngine.IEvaluationContext.FunctionDefinition {
        @Override
        public String name() {
            return "random";
        }

        @Override
        public FHIRPathUtilityClasses.FunctionDetails details() {
            return new FHIRPathUtilityClasses.FunctionDetails("Generate a Random Number", 1, 1);
        }

        @Override
        public TypeDetails check(FHIRPathEngine engine, Object appContext, TypeDetails focus, List<TypeDetails> parameters) {
            if (focus.hasType("GlobalObject")) {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "integer");
            }
            return null;
        }

        @Override
        public List<Base> execute(FHIRPathEngine engine, Object appContext, List<Base> focus, List<List<Base>> parameters) {
            ArrayList<Base> list = new ArrayList<Base>();
            int scale = Utilities.parseInt((String)parameters.get(0).get(0).primitiveValue(), (int)100) + 1;
            list.add(new IntegerType((int)(Math.random() * (double)scale)));
            return list;
        }
    }
}

