/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.SpecialClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;

public abstract class DomainResource
extends Resource
implements IBaseHasExtensions,
IBaseHasModifierExtensions,
IDomainResource {
    @Child(name="text", type={Narrative.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Text summary of the resource, for human interpretation", formalDefinition="A human-readable narrative that contains a summary of the resource and can be used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative. Resource definitions may define what content should be represented in the narrative to ensure clinical safety.")
    protected Narrative text;
    @Child(name="contained", type={Resource.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contained, inline Resources", formalDefinition="These resources do not have an independent existence apart from the resource that contains them - they cannot be identified independently, nor can they have their own independent transaction scope. This is allowed to be a Parameters resource if and only if it is referenced by a resource that provides context/meaning.")
    protected List<Resource> contained;
    @Child(name="extension", type={Extension.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional content defined by implementations", formalDefinition="May be used to represent additional information that is not part of the basic definition of the resource. To make the use of extensions safe and managable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.")
    protected List<Extension> extension;
    @Child(name="modifierExtension", type={Extension.class}, order=3, min=0, max=-1, modifier=true, summary=true)
    @Description(shortDefinition="Extensions that cannot be ignored", formalDefinition="May be used to represent additional information that is not part of the basic definition of the resource and that modifies the understanding of the element that contains it and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and managable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.\n\nModifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).")
    protected List<Extension> modifierExtension;
    private static final long serialVersionUID = -970285559L;
    @SearchParamDefinition(name="_text", path="", description="Search on the narrative of the resource", type="special")
    public static final String SP_TEXT = "_text";
    public static final SpecialClientParam TEXT = new SpecialClientParam("_text");

    public Narrative getText() {
        if (this.text == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DomainResource.text");
            }
            if (Configuration.doAutoCreate()) {
                this.text = new Narrative();
            }
        }
        return this.text;
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public DomainResource setText(Narrative value) {
        this.text = value;
        return this;
    }

    public List<Resource> getContained() {
        if (this.contained == null) {
            this.contained = new ArrayList<Resource>();
        }
        return this.contained;
    }

    public DomainResource setContained(List<Resource> theContained) {
        this.contained = theContained;
        return this;
    }

    public boolean hasContained() {
        if (this.contained == null) {
            return false;
        }
        for (Resource item : this.contained) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DomainResource addContained(Resource t) {
        if (t == null) {
            return this;
        }
        if (this.contained == null) {
            this.contained = new ArrayList<Resource>();
        }
        this.contained.add(t);
        return this;
    }

    public List<Extension> getExtension() {
        if (this.extension == null) {
            this.extension = new ArrayList<Extension>();
        }
        return this.extension;
    }

    public DomainResource setExtension(List<Extension> theExtension) {
        this.extension = theExtension;
        return this;
    }

    public boolean hasExtension() {
        if (this.extension == null) {
            return false;
        }
        for (Extension item : this.extension) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Extension addExtension() {
        Extension t = new Extension();
        if (this.extension == null) {
            this.extension = new ArrayList<Extension>();
        }
        this.extension.add(t);
        return t;
    }

    public DomainResource addExtension(Extension t) {
        if (t == null) {
            return this;
        }
        if (this.extension == null) {
            this.extension = new ArrayList<Extension>();
        }
        this.extension.add(t);
        return this;
    }

    public List<Extension> getModifierExtension() {
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        return this.modifierExtension;
    }

    public DomainResource setModifierExtension(List<Extension> theModifierExtension) {
        this.modifierExtension = theModifierExtension;
        return this;
    }

    public boolean hasModifierExtension() {
        if (this.modifierExtension == null) {
            return false;
        }
        for (Extension item : this.modifierExtension) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Extension addModifierExtension() {
        Extension t = new Extension();
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        this.modifierExtension.add(t);
        return t;
    }

    public DomainResource addModifierExtension(Extension t) {
        if (t == null) {
            return this;
        }
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        this.modifierExtension.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("text", "Narrative", "A human-readable narrative that contains a summary of the resource and can be used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative. Resource definitions may define what content should be represented in the narrative to ensure clinical safety.", 0, 1, this.text));
        children.add(new Property("contained", "Resource", "These resources do not have an independent existence apart from the resource that contains them - they cannot be identified independently, nor can they have their own independent transaction scope. This is allowed to be a Parameters resource if and only if it is referenced by a resource that provides context/meaning.", 0, Integer.MAX_VALUE, this.contained));
        children.add(new Property("extension", "Extension", "May be used to represent additional information that is not part of the basic definition of the resource. To make the use of extensions safe and managable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.", 0, Integer.MAX_VALUE, this.extension));
        children.add(new Property("modifierExtension", "Extension", "May be used to represent additional information that is not part of the basic definition of the resource and that modifies the understanding of the element that contains it and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and managable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.\n\nModifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).", 0, Integer.MAX_VALUE, this.modifierExtension));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3556653: {
                return new Property("text", "Narrative", "A human-readable narrative that contains a summary of the resource and can be used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative. Resource definitions may define what content should be represented in the narrative to ensure clinical safety.", 0, 1, this.text);
            }
            case -410956685: {
                return new Property("contained", "Resource", "These resources do not have an independent existence apart from the resource that contains them - they cannot be identified independently, nor can they have their own independent transaction scope. This is allowed to be a Parameters resource if and only if it is referenced by a resource that provides context/meaning.", 0, Integer.MAX_VALUE, this.contained);
            }
            case -612557761: {
                return new Property("extension", "Extension", "May be used to represent additional information that is not part of the basic definition of the resource. To make the use of extensions safe and managable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.", 0, Integer.MAX_VALUE, this.extension);
            }
            case -298878168: {
                return new Property("modifierExtension", "Extension", "May be used to represent additional information that is not part of the basic definition of the resource and that modifies the understanding of the element that contains it and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and managable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.\n\nModifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).", 0, Integer.MAX_VALUE, this.modifierExtension);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3556653: {
                Base[] baseArray;
                if (this.text == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.text;
                }
                return baseArray;
            }
            case -410956685: {
                return this.contained == null ? new Base[]{} : this.contained.toArray(new Base[this.contained.size()]);
            }
            case -612557761: {
                return this.extension == null ? new Base[]{} : this.extension.toArray(new Base[this.extension.size()]);
            }
            case -298878168: {
                return this.modifierExtension == null ? new Base[]{} : this.modifierExtension.toArray(new Base[this.modifierExtension.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3556653: {
                this.text = TypeConvertor.castToNarrative(value);
                return value;
            }
            case -410956685: {
                this.getContained().add(TypeConvertor.castToResource(value));
                return value;
            }
            case -612557761: {
                this.getExtension().add(TypeConvertor.castToExtension(value));
                return value;
            }
            case -298878168: {
                this.getModifierExtension().add(TypeConvertor.castToExtension(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("text")) {
            this.text = TypeConvertor.castToNarrative(value);
        } else if (name.equals("contained")) {
            this.getContained().add(TypeConvertor.castToResource(value));
        } else if (name.equals("extension")) {
            this.getExtension().add(TypeConvertor.castToExtension(value));
        } else if (name.equals("modifierExtension")) {
            this.getModifierExtension().add(TypeConvertor.castToExtension(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("text")) {
            this.text = null;
        } else if (name.equals("contained")) {
            this.getContained().remove(value);
        } else if (name.equals("extension")) {
            this.getExtension().remove(value);
        } else if (name.equals("modifierExtension")) {
            this.getModifierExtension().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3556653: {
                return this.getText();
            }
            case -410956685: {
                throw new FHIRException("Cannot make property contained as it is not a complex type");
            }
            case -612557761: {
                return this.addExtension();
            }
            case -298878168: {
                return this.addModifierExtension();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3556653: {
                return new String[]{"Narrative"};
            }
            case -410956685: {
                return new String[]{"Resource"};
            }
            case -612557761: {
                return new String[]{"Extension"};
            }
            case -298878168: {
                return new String[]{"Extension"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("text")) {
            this.text = new Narrative();
            return this.text;
        }
        if (name.equals("contained")) {
            throw new FHIRException("Cannot call addChild on an abstract type DomainResource.contained");
        }
        if (name.equals("extension")) {
            return this.addExtension();
        }
        if (name.equals("modifierExtension")) {
            return this.addModifierExtension();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DomainResource";
    }

    @Override
    public abstract DomainResource copy();

    public void copyValues(DomainResource dst) {
        super.copyValues(dst);
        Narrative narrative = dst.text = this.text == null ? null : this.text.copy();
        if (this.contained != null) {
            dst.contained = new ArrayList<Resource>();
            for (Resource resource : this.contained) {
                dst.contained.add(resource.copy());
            }
        }
        if (this.extension != null) {
            dst.extension = new ArrayList<Extension>();
            for (Extension extension : this.extension) {
                dst.extension.add(extension.copy());
            }
        }
        if (this.modifierExtension != null) {
            dst.modifierExtension = new ArrayList<Extension>();
            for (Extension extension : this.modifierExtension) {
                dst.modifierExtension.add(extension.copy());
            }
        }
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DomainResource)) {
            return false;
        }
        DomainResource o = (DomainResource)other_;
        return DomainResource.compareDeep(this.text, o.text, true) && DomainResource.compareDeep(this.contained, o.contained, true) && DomainResource.compareDeep(this.extension, o.extension, true) && DomainResource.compareDeep(this.modifierExtension, o.modifierExtension, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DomainResource)) {
            return false;
        }
        DomainResource o = (DomainResource)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.text, this.contained, this.extension, this.modifierExtension});
    }

    public void checkNoModifiers(String noun, String verb) throws FHIRException {
        if (this.hasModifierExtension()) {
            throw new FHIRException("Found unknown Modifier Exceptions on " + noun + " doing " + verb);
        }
    }

    public void addExtension(String url, DataType value) {
        Extension ex = new Extension();
        ex.setUrl(url);
        ex.setValue(value);
        this.getExtension().add(ex);
    }

    public boolean hasExtension(String ... theUrls) {
        for (Extension next : this.getModifierExtension()) {
            if (!Utilities.existsInList((String)next.getUrl(), (String[])theUrls)) continue;
            return true;
        }
        for (Extension next : this.getExtension()) {
            if (!Utilities.existsInList((String)next.getUrl(), (String[])theUrls)) continue;
            return true;
        }
        return false;
    }

    public boolean hasExtension(String url) {
        for (Extension next : this.getModifierExtension()) {
            if (!url.equals(next.getUrl())) continue;
            return true;
        }
        for (Extension e : this.getExtension()) {
            if (!url.equals(e.getUrl())) continue;
            return true;
        }
        return false;
    }

    public Extension getExtensionByUrl(String theUrl) {
        Validate.notBlank((CharSequence)theUrl, (String)"theUrl must not be blank or null", (Object[])new Object[0]);
        ArrayList<Extension> retVal = new ArrayList<Extension>();
        for (Extension next : this.getExtension()) {
            if (!theUrl.equals(next.getUrl())) continue;
            retVal.add(next);
        }
        for (Extension next : this.getModifierExtension()) {
            if (!theUrl.equals(next.getUrl())) continue;
            retVal.add(next);
        }
        if (retVal.size() == 0) {
            return null;
        }
        Validate.isTrue((retVal.size() == 1 ? 1 : 0) != 0, (String)("Url " + theUrl + " must have only one match"), (Object[])new Object[0]);
        return (Extension)retVal.get(0);
    }

    public Resource getContained(String ref) {
        if (ref == null) {
            return null;
        }
        if (ref.startsWith("#")) {
            ref = ref.substring(1);
        }
        for (Resource r : this.getContained()) {
            if (!r.getId().equals(ref)) continue;
            return r;
        }
        return null;
    }

    public List<Extension> getExtensionsByUrl(String theUrl) {
        Validate.notBlank((CharSequence)theUrl, (String)"theUrl must be provided with a value", (Object[])new Object[0]);
        ArrayList<Extension> retVal = new ArrayList<Extension>();
        for (Extension next : this.getExtension()) {
            if (!theUrl.equals(next.getUrl())) continue;
            retVal.add(next);
        }
        for (Extension next : this.getModifierExtension()) {
            if (!theUrl.equals(next.getUrl())) continue;
            retVal.add(next);
        }
        return Collections.unmodifiableList(retVal);
    }

    public List<Extension> getExtensionsByUrl(String ... theUrls) {
        ArrayList<Extension> retVal = new ArrayList<Extension>();
        for (Extension next : this.getExtension()) {
            if (!Utilities.existsInList((String)next.getUrl(), (String[])theUrls)) continue;
            retVal.add(next);
        }
        for (Extension next : this.getModifierExtension()) {
            if (!Utilities.existsInList((String)next.getUrl(), (String[])theUrls)) continue;
            retVal.add(next);
        }
        return Collections.unmodifiableList(retVal);
    }

    public List<Extension> getModifierExtensionsByUrl(String theUrl) {
        Validate.notBlank((CharSequence)theUrl, (String)"theUrl must be provided with a value", (Object[])new Object[0]);
        ArrayList<Extension> retVal = new ArrayList<Extension>();
        for (Extension next : this.getModifierExtension()) {
            if (!theUrl.equals(next.getUrl())) continue;
            retVal.add(next);
        }
        return Collections.unmodifiableList(retVal);
    }

    public StandardsStatus getStandardsStatus() {
        return ToolingExtensions.getStandardsStatus(this);
    }

    public void setStandardsStatus(StandardsStatus status) {
        ToolingExtensions.setStandardsStatus(this, status, null);
    }
}

