/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Identifier")
public class Identifier
extends DataType
implements ICompositeType {
    @Child(name="use", type={CodeType.class}, order=0, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="usual | official | temp | secondary | old (If known)", formalDefinition="The purpose of this identifier.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/identifier-use")
    protected Enumeration<IdentifierUse> use;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of identifier", formalDefinition="A coded type for the identifier that can be used to determine which identifier to use for a specific purpose.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/identifier-type")
    protected CodeableConcept type;
    @Child(name="system", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The namespace for the identifier value", formalDefinition="Establishes the namespace for the value - that is, an absolute URL that describes a set values that are unique.")
    protected UriType system;
    @Child(name="value", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The value that is unique", formalDefinition="The portion of the identifier typically relevant to the user and which is unique within the context of the system.")
    protected StringType value;
    @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time period when id is/was valid for use", formalDefinition="Time period during which identifier is/was valid for use.")
    protected Period period;
    @Child(name="assigner", type={Organization.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that issued id (may be just text)", formalDefinition="Organization that issued/manages the identifier.")
    protected Reference assigner;
    private static final long serialVersionUID = 2098433371L;

    public Enumeration<IdentifierUse> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<IdentifierUse>(new IdentifierUseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public Identifier setUseElement(Enumeration<IdentifierUse> value) {
        this.use = value;
        return this;
    }

    public IdentifierUse getUse() {
        return this.use == null ? null : (IdentifierUse)((Object)this.use.getValue());
    }

    public Identifier setUse(IdentifierUse value) {
        if (value == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration<IdentifierUse>(new IdentifierUseEnumFactory());
            }
            this.use.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Identifier setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public UriType getSystemElement() {
        if (this.system == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.system");
            }
            if (Configuration.doAutoCreate()) {
                this.system = new UriType();
            }
        }
        return this.system;
    }

    public boolean hasSystemElement() {
        return this.system != null && !this.system.isEmpty();
    }

    public boolean hasSystem() {
        return this.system != null && !this.system.isEmpty();
    }

    public Identifier setSystemElement(UriType value) {
        this.system = value;
        return this;
    }

    public String getSystem() {
        return this.system == null ? null : (String)this.system.getValue();
    }

    public Identifier setSystem(String value) {
        if (Utilities.noString((String)value)) {
            this.system = null;
        } else {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(value);
        }
        return this;
    }

    public StringType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new StringType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public Identifier setValueElement(StringType value) {
        this.value = value;
        return this;
    }

    public String getValue() {
        return this.value == null ? null : (String)this.value.getValue();
    }

    public Identifier setValue(String value) {
        if (Utilities.noString((String)value)) {
            this.value = null;
        } else {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
        }
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Identifier setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getAssigner() {
        if (this.assigner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Identifier.assigner");
            }
            if (Configuration.doAutoCreate()) {
                this.assigner = new Reference();
            }
        }
        return this.assigner;
    }

    public boolean hasAssigner() {
        return this.assigner != null && !this.assigner.isEmpty();
    }

    public Identifier setAssigner(Reference value) {
        this.assigner = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("use", "code", "The purpose of this identifier.", 0, 1, this.use));
        children.add(new Property("type", "CodeableConcept", "A coded type for the identifier that can be used to determine which identifier to use for a specific purpose.", 0, 1, this.type));
        children.add(new Property("system", "uri", "Establishes the namespace for the value - that is, an absolute URL that describes a set values that are unique.", 0, 1, this.system));
        children.add(new Property("value", "string", "The portion of the identifier typically relevant to the user and which is unique within the context of the system.", 0, 1, this.value));
        children.add(new Property("period", "Period", "Time period during which identifier is/was valid for use.", 0, 1, this.period));
        children.add(new Property("assigner", "Reference(Organization)", "Organization that issued/manages the identifier.", 0, 1, this.assigner));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116103: {
                return new Property("use", "code", "The purpose of this identifier.", 0, 1, this.use);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "A coded type for the identifier that can be used to determine which identifier to use for a specific purpose.", 0, 1, this.type);
            }
            case -887328209: {
                return new Property("system", "uri", "Establishes the namespace for the value - that is, an absolute URL that describes a set values that are unique.", 0, 1, this.system);
            }
            case 111972721: {
                return new Property("value", "string", "The portion of the identifier typically relevant to the user and which is unique within the context of the system.", 0, 1, this.value);
            }
            case -991726143: {
                return new Property("period", "Period", "Time period during which identifier is/was valid for use.", 0, 1, this.period);
            }
            case -369881636: {
                return new Property("assigner", "Reference(Organization)", "Organization that issued/manages the identifier.", 0, 1, this.assigner);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.use;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -887328209: {
                Base[] baseArray;
                if (this.system == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.system;
                }
                return baseArray;
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.value;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.period;
                }
                return baseArray;
            }
            case -369881636: {
                Base[] baseArray;
                if (this.assigner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.assigner;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116103: {
                value = new IdentifierUseEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.use = value;
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -887328209: {
                this.system = TypeConvertor.castToUri(value);
                return value;
            }
            case 111972721: {
                this.value = TypeConvertor.castToString(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -369881636: {
                this.assigner = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("use")) {
            value = new IdentifierUseEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.use = value;
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("system")) {
            this.system = TypeConvertor.castToUri(value);
        } else if (name.equals("value")) {
            this.value = TypeConvertor.castToString(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals("assigner")) {
            this.assigner = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("use")) {
            value = new IdentifierUseEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.use = value;
        } else if (name.equals("type")) {
            this.type = null;
        } else if (name.equals("system")) {
            this.system = null;
        } else if (name.equals("value")) {
            this.value = null;
        } else if (name.equals("period")) {
            this.period = null;
        } else if (name.equals("assigner")) {
            this.assigner = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116103: {
                return this.getUseElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -887328209: {
                return this.getSystemElement();
            }
            case 111972721: {
                return this.getValueElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -369881636: {
                return this.getAssigner();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116103: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -887328209: {
                return new String[]{"uri"};
            }
            case 111972721: {
                return new String[]{"string"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -369881636: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("use")) {
            throw new FHIRException("Cannot call addChild on a singleton property Identifier.use");
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("system")) {
            throw new FHIRException("Cannot call addChild on a singleton property Identifier.system");
        }
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property Identifier.value");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("assigner")) {
            this.assigner = new Reference();
            return this.assigner;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Identifier";
    }

    @Override
    public Identifier copy() {
        Identifier dst = new Identifier();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Identifier dst) {
        super.copyValues(dst);
        dst.use = this.use == null ? null : this.use.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.system = this.system == null ? null : this.system.copy();
        dst.value = this.value == null ? null : this.value.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.assigner = this.assigner == null ? null : this.assigner.copy();
    }

    protected Identifier typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Identifier)) {
            return false;
        }
        Identifier o = (Identifier)other_;
        return Identifier.compareDeep(this.use, o.use, true) && Identifier.compareDeep(this.type, o.type, true) && Identifier.compareDeep(this.system, o.system, true) && Identifier.compareDeep(this.value, o.value, true) && Identifier.compareDeep(this.period, o.period, true) && Identifier.compareDeep(this.assigner, o.assigner, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Identifier)) {
            return false;
        }
        Identifier o = (Identifier)other_;
        return Identifier.compareValues(this.use, o.use, true) && Identifier.compareValues(this.system, o.system, true) && Identifier.compareValues(this.value, o.value, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.use, this.type, this.system, this.value, this.period, this.assigner});
    }

    public boolean matches(Identifier other) {
        return this.hasSystem() && this.hasValue() && this.getSystem().matches(other.getSystem()) && this.getValue().matches(other.getValue());
    }

    public static class IdentifierUseEnumFactory
    implements EnumFactory<IdentifierUse> {
        @Override
        public IdentifierUse fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("usual".equals(codeString)) {
                return IdentifierUse.USUAL;
            }
            if ("official".equals(codeString)) {
                return IdentifierUse.OFFICIAL;
            }
            if ("temp".equals(codeString)) {
                return IdentifierUse.TEMP;
            }
            if ("secondary".equals(codeString)) {
                return IdentifierUse.SECONDARY;
            }
            if ("old".equals(codeString)) {
                return IdentifierUse.OLD;
            }
            throw new IllegalArgumentException("Unknown IdentifierUse code '" + codeString + "'");
        }

        public Enumeration<IdentifierUse> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<IdentifierUse>(this, IdentifierUse.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<IdentifierUse>(this, IdentifierUse.NULL, code);
            }
            if ("usual".equals(codeString)) {
                return new Enumeration<IdentifierUse>(this, IdentifierUse.USUAL, code);
            }
            if ("official".equals(codeString)) {
                return new Enumeration<IdentifierUse>(this, IdentifierUse.OFFICIAL, code);
            }
            if ("temp".equals(codeString)) {
                return new Enumeration<IdentifierUse>(this, IdentifierUse.TEMP, code);
            }
            if ("secondary".equals(codeString)) {
                return new Enumeration<IdentifierUse>(this, IdentifierUse.SECONDARY, code);
            }
            if ("old".equals(codeString)) {
                return new Enumeration<IdentifierUse>(this, IdentifierUse.OLD, code);
            }
            throw new FHIRException("Unknown IdentifierUse code '" + codeString + "'");
        }

        @Override
        public String toCode(IdentifierUse code) {
            if (code == IdentifierUse.NULL) {
                return null;
            }
            if (code == IdentifierUse.USUAL) {
                return "usual";
            }
            if (code == IdentifierUse.OFFICIAL) {
                return "official";
            }
            if (code == IdentifierUse.TEMP) {
                return "temp";
            }
            if (code == IdentifierUse.SECONDARY) {
                return "secondary";
            }
            if (code == IdentifierUse.OLD) {
                return "old";
            }
            return "?";
        }

        @Override
        public String toSystem(IdentifierUse code) {
            return code.getSystem();
        }
    }

    public static enum IdentifierUse {
        USUAL,
        OFFICIAL,
        TEMP,
        SECONDARY,
        OLD,
        NULL;


        public static IdentifierUse fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("usual".equals(codeString)) {
                return USUAL;
            }
            if ("official".equals(codeString)) {
                return OFFICIAL;
            }
            if ("temp".equals(codeString)) {
                return TEMP;
            }
            if ("secondary".equals(codeString)) {
                return SECONDARY;
            }
            if ("old".equals(codeString)) {
                return OLD;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown IdentifierUse code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case USUAL: {
                    return "usual";
                }
                case OFFICIAL: {
                    return "official";
                }
                case TEMP: {
                    return "temp";
                }
                case SECONDARY: {
                    return "secondary";
                }
                case OLD: {
                    return "old";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case USUAL: {
                    return "http://hl7.org/fhir/identifier-use";
                }
                case OFFICIAL: {
                    return "http://hl7.org/fhir/identifier-use";
                }
                case TEMP: {
                    return "http://hl7.org/fhir/identifier-use";
                }
                case SECONDARY: {
                    return "http://hl7.org/fhir/identifier-use";
                }
                case OLD: {
                    return "http://hl7.org/fhir/identifier-use";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case USUAL: {
                    return "The identifier recommended for display and use in real-world interactions which should be used when such identifier is different from the \"official\" identifier.";
                }
                case OFFICIAL: {
                    return "The identifier considered to be most trusted for the identification of this item. Sometimes also known as \"primary\" and \"main\". The determination of \"official\" is subjective and implementation guides often provide additional guidelines for use.";
                }
                case TEMP: {
                    return "A temporary identifier.";
                }
                case SECONDARY: {
                    return "An identifier that was assigned in secondary use - it serves to identify the object in a relative context, but cannot be consistently assigned to the same object again in a different context.";
                }
                case OLD: {
                    return "The identifier id no longer considered valid, but may be relevant for search purposes.  E.g. Changes to identifier schemes, account merges, etc.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case USUAL: {
                    return "Usual";
                }
                case OFFICIAL: {
                    return "Official";
                }
                case TEMP: {
                    return "Temp";
                }
                case SECONDARY: {
                    return "Secondary";
                }
                case OLD: {
                    return "Old";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

