/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImmunizationEvaluation", profile="http://hl7.org/fhir/StructureDefinition/ImmunizationEvaluation")
public class ImmunizationEvaluation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business identifier", formalDefinition="A unique identifier assigned to this immunization evaluation record.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="completed | entered-in-error", formalDefinition="Indicates the current status of the evaluation of the vaccination administration event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-evaluation-status")
    protected Enumeration<ImmunizationEvaluationStatusCodes> status;
    @Child(name="patient", type={Patient.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who this evaluation is for", formalDefinition="The individual for whom the evaluation is being done.")
    protected Reference patient;
    @Child(name="date", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date evaluation was performed", formalDefinition="The date the evaluation of the vaccine administration event was performed.")
    protected DateTimeType date;
    @Child(name="authority", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who is responsible for publishing the recommendations", formalDefinition="Indicates the authority who published the protocol (e.g. ACIP).")
    protected Reference authority;
    @Child(name="targetDisease", type={CodeableConcept.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The vaccine preventable disease schedule being evaluated", formalDefinition="The vaccine preventable disease the dose is being evaluated against.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-target-disease")
    protected CodeableConcept targetDisease;
    @Child(name="immunizationEvent", type={Immunization.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Immunization being evaluated", formalDefinition="The vaccine administration event being evaluated.")
    protected Reference immunizationEvent;
    @Child(name="doseStatus", type={CodeableConcept.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Status of the dose relative to published recommendations", formalDefinition="Indicates if the dose is valid or not valid with respect to the published recommendations.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-evaluation-dose-status")
    protected CodeableConcept doseStatus;
    @Child(name="doseStatusReason", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason why the doese is considered valid, invalid or some other status", formalDefinition="Provides an explanation as to why the vaccine administration event is valid or not relative to the published recommendations.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-evaluation-dose-status-reason")
    protected List<CodeableConcept> doseStatusReason;
    @Child(name="description", type={MarkdownType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Evaluation notes", formalDefinition="Additional information about the evaluation.")
    protected MarkdownType description;
    @Child(name="series", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of vaccine series", formalDefinition="One possible path to achieve presumed immunity against a disease - within the context of an authority.")
    protected StringType series;
    @Child(name="doseNumber", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Dose number within series", formalDefinition="Nominal position in a series as determined by the outcome of the evaluation process.")
    protected StringType doseNumber;
    @Child(name="seriesDoses", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Recommended number of doses for immunity", formalDefinition="The recommended number of doses to achieve immunity as determined by the outcome of the evaluation process.")
    protected StringType seriesDoses;
    private static final long serialVersionUID = 1336970813L;
    @SearchParamDefinition(name="dose-status", path="ImmunizationEvaluation.doseStatus", description="The status of the dose relative to published recommendations", type="token")
    public static final String SP_DOSE_STATUS = "dose-status";
    public static final TokenClientParam DOSE_STATUS = new TokenClientParam("dose-status");
    @SearchParamDefinition(name="immunization-event", path="ImmunizationEvaluation.immunizationEvent", description="The vaccine administration event being evaluated", type="reference", target={Immunization.class})
    public static final String SP_IMMUNIZATION_EVENT = "immunization-event";
    public static final ReferenceClientParam IMMUNIZATION_EVENT = new ReferenceClientParam("immunization-event");
    public static final Include INCLUDE_IMMUNIZATION_EVENT = new Include("ImmunizationEvaluation:immunization-event").toLocked();
    @SearchParamDefinition(name="status", path="ImmunizationEvaluation.status", description="Immunization evaluation status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="target-disease", path="ImmunizationEvaluation.targetDisease", description="The vaccine preventable disease being evaluated against", type="token")
    public static final String SP_TARGET_DISEASE = "target-disease";
    public static final TokenClientParam TARGET_DISEASE = new TokenClientParam("target-disease");
    @SearchParamDefinition(name="date", path="AdverseEvent.occurrence.ofType(dateTime) | AdverseEvent.occurrence.ofType(Period) | AdverseEvent.occurrence.ofType(Timing) | AllergyIntolerance.recordedDate | (start | requestedPeriod.start).first() | AuditEvent.recorded | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.ofType(dateTime) | DiagnosticReport.effective.ofType(Period) | DocumentReference.date | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence.ofType(dateTime)) | ImmunizationEvaluation.date | ImmunizationRecommendation.date | Invoice.date | List.date | MeasureReport.date | NutritionIntake.occurrence.ofType(dateTime) | NutritionIntake.occurrence.ofType(Period) | Observation.effective.ofType(dateTime) | Observation.effective.ofType(Period) | Observation.effective.ofType(Timing) | Observation.effective.ofType(instant) | Procedure.occurrence.ofType(dateTime) | Procedure.occurrence.ofType(Period) | Procedure.occurrence.ofType(Timing) | ResearchSubject.period | (RiskAssessment.occurrence.ofType(dateTime)) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): When the event occurred\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [Appointment](appointment.html): Appointment date/time.\r\n* [AuditEvent](auditevent.html): Time when the event was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [DocumentReference](documentreference.html): When this document reference was created\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created\r\n* [Invoice](invoice.html): Invoice date / posting date\r\n* [List](list.html): When the list was prepared\r\n* [MeasureReport](measurereport.html): The date of the measure report\r\n* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication\r\n* [Observation](observation.html): Clinically relevant time/time-period for observation\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [ResearchSubject](researchsubject.html): Start and end of participation\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ImmunizationEvaluation:patient").toLocked();

    public ImmunizationEvaluation() {
    }

    public ImmunizationEvaluation(ImmunizationEvaluationStatusCodes status, Reference patient, CodeableConcept targetDisease, Reference immunizationEvent, CodeableConcept doseStatus) {
        this.setStatus(status);
        this.setPatient(patient);
        this.setTargetDisease(targetDisease);
        this.setImmunizationEvent(immunizationEvent);
        this.setDoseStatus(doseStatus);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ImmunizationEvaluation setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ImmunizationEvaluation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ImmunizationEvaluationStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationEvaluation.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ImmunizationEvaluationStatusCodes>(new ImmunizationEvaluationStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ImmunizationEvaluation setStatusElement(Enumeration<ImmunizationEvaluationStatusCodes> value) {
        this.status = value;
        return this;
    }

    public ImmunizationEvaluationStatusCodes getStatus() {
        return this.status == null ? null : (ImmunizationEvaluationStatusCodes)((Object)this.status.getValue());
    }

    public ImmunizationEvaluation setStatus(ImmunizationEvaluationStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<ImmunizationEvaluationStatusCodes>(new ImmunizationEvaluationStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationEvaluation.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ImmunizationEvaluation setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationEvaluation.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ImmunizationEvaluation setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ImmunizationEvaluation setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getAuthority() {
        if (this.authority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationEvaluation.authority");
            }
            if (Configuration.doAutoCreate()) {
                this.authority = new Reference();
            }
        }
        return this.authority;
    }

    public boolean hasAuthority() {
        return this.authority != null && !this.authority.isEmpty();
    }

    public ImmunizationEvaluation setAuthority(Reference value) {
        this.authority = value;
        return this;
    }

    public CodeableConcept getTargetDisease() {
        if (this.targetDisease == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationEvaluation.targetDisease");
            }
            if (Configuration.doAutoCreate()) {
                this.targetDisease = new CodeableConcept();
            }
        }
        return this.targetDisease;
    }

    public boolean hasTargetDisease() {
        return this.targetDisease != null && !this.targetDisease.isEmpty();
    }

    public ImmunizationEvaluation setTargetDisease(CodeableConcept value) {
        this.targetDisease = value;
        return this;
    }

    public Reference getImmunizationEvent() {
        if (this.immunizationEvent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationEvaluation.immunizationEvent");
            }
            if (Configuration.doAutoCreate()) {
                this.immunizationEvent = new Reference();
            }
        }
        return this.immunizationEvent;
    }

    public boolean hasImmunizationEvent() {
        return this.immunizationEvent != null && !this.immunizationEvent.isEmpty();
    }

    public ImmunizationEvaluation setImmunizationEvent(Reference value) {
        this.immunizationEvent = value;
        return this;
    }

    public CodeableConcept getDoseStatus() {
        if (this.doseStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationEvaluation.doseStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.doseStatus = new CodeableConcept();
            }
        }
        return this.doseStatus;
    }

    public boolean hasDoseStatus() {
        return this.doseStatus != null && !this.doseStatus.isEmpty();
    }

    public ImmunizationEvaluation setDoseStatus(CodeableConcept value) {
        this.doseStatus = value;
        return this;
    }

    public List<CodeableConcept> getDoseStatusReason() {
        if (this.doseStatusReason == null) {
            this.doseStatusReason = new ArrayList<CodeableConcept>();
        }
        return this.doseStatusReason;
    }

    public ImmunizationEvaluation setDoseStatusReason(List<CodeableConcept> theDoseStatusReason) {
        this.doseStatusReason = theDoseStatusReason;
        return this;
    }

    public boolean hasDoseStatusReason() {
        if (this.doseStatusReason == null) {
            return false;
        }
        for (CodeableConcept item : this.doseStatusReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addDoseStatusReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.doseStatusReason == null) {
            this.doseStatusReason = new ArrayList<CodeableConcept>();
        }
        this.doseStatusReason.add(t);
        return t;
    }

    public ImmunizationEvaluation addDoseStatusReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.doseStatusReason == null) {
            this.doseStatusReason = new ArrayList<CodeableConcept>();
        }
        this.doseStatusReason.add(t);
        return this;
    }

    public CodeableConcept getDoseStatusReasonFirstRep() {
        if (this.getDoseStatusReason().isEmpty()) {
            this.addDoseStatusReason();
        }
        return this.getDoseStatusReason().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationEvaluation.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ImmunizationEvaluation setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ImmunizationEvaluation setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public StringType getSeriesElement() {
        if (this.series == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationEvaluation.series");
            }
            if (Configuration.doAutoCreate()) {
                this.series = new StringType();
            }
        }
        return this.series;
    }

    public boolean hasSeriesElement() {
        return this.series != null && !this.series.isEmpty();
    }

    public boolean hasSeries() {
        return this.series != null && !this.series.isEmpty();
    }

    public ImmunizationEvaluation setSeriesElement(StringType value) {
        this.series = value;
        return this;
    }

    public String getSeries() {
        return this.series == null ? null : (String)this.series.getValue();
    }

    public ImmunizationEvaluation setSeries(String value) {
        if (Utilities.noString((String)value)) {
            this.series = null;
        } else {
            if (this.series == null) {
                this.series = new StringType();
            }
            this.series.setValue(value);
        }
        return this;
    }

    public StringType getDoseNumberElement() {
        if (this.doseNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationEvaluation.doseNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.doseNumber = new StringType();
            }
        }
        return this.doseNumber;
    }

    public boolean hasDoseNumberElement() {
        return this.doseNumber != null && !this.doseNumber.isEmpty();
    }

    public boolean hasDoseNumber() {
        return this.doseNumber != null && !this.doseNumber.isEmpty();
    }

    public ImmunizationEvaluation setDoseNumberElement(StringType value) {
        this.doseNumber = value;
        return this;
    }

    public String getDoseNumber() {
        return this.doseNumber == null ? null : (String)this.doseNumber.getValue();
    }

    public ImmunizationEvaluation setDoseNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.doseNumber = null;
        } else {
            if (this.doseNumber == null) {
                this.doseNumber = new StringType();
            }
            this.doseNumber.setValue(value);
        }
        return this;
    }

    public StringType getSeriesDosesElement() {
        if (this.seriesDoses == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationEvaluation.seriesDoses");
            }
            if (Configuration.doAutoCreate()) {
                this.seriesDoses = new StringType();
            }
        }
        return this.seriesDoses;
    }

    public boolean hasSeriesDosesElement() {
        return this.seriesDoses != null && !this.seriesDoses.isEmpty();
    }

    public boolean hasSeriesDoses() {
        return this.seriesDoses != null && !this.seriesDoses.isEmpty();
    }

    public ImmunizationEvaluation setSeriesDosesElement(StringType value) {
        this.seriesDoses = value;
        return this;
    }

    public String getSeriesDoses() {
        return this.seriesDoses == null ? null : (String)this.seriesDoses.getValue();
    }

    public ImmunizationEvaluation setSeriesDoses(String value) {
        if (Utilities.noString((String)value)) {
            this.seriesDoses = null;
        } else {
            if (this.seriesDoses == null) {
                this.seriesDoses = new StringType();
            }
            this.seriesDoses.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this immunization evaluation record.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Indicates the current status of the evaluation of the vaccination administration event.", 0, 1, this.status));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The individual for whom the evaluation is being done.", 0, 1, this.patient));
        children.add(new Property(SP_DATE, "dateTime", "The date the evaluation of the vaccine administration event was performed.", 0, 1, this.date));
        children.add(new Property("authority", "Reference(Organization)", "Indicates the authority who published the protocol (e.g. ACIP).", 0, 1, this.authority));
        children.add(new Property("targetDisease", "CodeableConcept", "The vaccine preventable disease the dose is being evaluated against.", 0, 1, this.targetDisease));
        children.add(new Property("immunizationEvent", "Reference(Immunization)", "The vaccine administration event being evaluated.", 0, 1, this.immunizationEvent));
        children.add(new Property("doseStatus", "CodeableConcept", "Indicates if the dose is valid or not valid with respect to the published recommendations.", 0, 1, this.doseStatus));
        children.add(new Property("doseStatusReason", "CodeableConcept", "Provides an explanation as to why the vaccine administration event is valid or not relative to the published recommendations.", 0, Integer.MAX_VALUE, this.doseStatusReason));
        children.add(new Property("description", "markdown", "Additional information about the evaluation.", 0, 1, this.description));
        children.add(new Property("series", "string", "One possible path to achieve presumed immunity against a disease - within the context of an authority.", 0, 1, this.series));
        children.add(new Property("doseNumber", "string", "Nominal position in a series as determined by the outcome of the evaluation process.", 0, 1, this.doseNumber));
        children.add(new Property("seriesDoses", "string", "The recommended number of doses to achieve immunity as determined by the outcome of the evaluation process.", 0, 1, this.seriesDoses));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this immunization evaluation record.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Indicates the current status of the evaluation of the vaccination administration event.", 0, 1, this.status);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The individual for whom the evaluation is being done.", 0, 1, this.patient);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date the evaluation of the vaccine administration event was performed.", 0, 1, this.date);
            }
            case 1475610435: {
                return new Property("authority", "Reference(Organization)", "Indicates the authority who published the protocol (e.g. ACIP).", 0, 1, this.authority);
            }
            case -319593813: {
                return new Property("targetDisease", "CodeableConcept", "The vaccine preventable disease the dose is being evaluated against.", 0, 1, this.targetDisease);
            }
            case 1081446840: {
                return new Property("immunizationEvent", "Reference(Immunization)", "The vaccine administration event being evaluated.", 0, 1, this.immunizationEvent);
            }
            case -745826705: {
                return new Property("doseStatus", "CodeableConcept", "Indicates if the dose is valid or not valid with respect to the published recommendations.", 0, 1, this.doseStatus);
            }
            case 662783379: {
                return new Property("doseStatusReason", "CodeableConcept", "Provides an explanation as to why the vaccine administration event is valid or not relative to the published recommendations.", 0, Integer.MAX_VALUE, this.doseStatusReason);
            }
            case -1724546052: {
                return new Property("description", "markdown", "Additional information about the evaluation.", 0, 1, this.description);
            }
            case -905838985: {
                return new Property("series", "string", "One possible path to achieve presumed immunity against a disease - within the context of an authority.", 0, 1, this.series);
            }
            case -887709242: {
                return new Property("doseNumber", "string", "Nominal position in a series as determined by the outcome of the evaluation process.", 0, 1, this.doseNumber);
            }
            case -1936727105: {
                return new Property("seriesDoses", "string", "The recommended number of doses to achieve immunity as determined by the outcome of the evaluation process.", 0, 1, this.seriesDoses);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.date;
                }
                return baseArray;
            }
            case 1475610435: {
                Base[] baseArray;
                if (this.authority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.authority;
                }
                return baseArray;
            }
            case -319593813: {
                Base[] baseArray;
                if (this.targetDisease == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.targetDisease;
                }
                return baseArray;
            }
            case 1081446840: {
                Base[] baseArray;
                if (this.immunizationEvent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.immunizationEvent;
                }
                return baseArray;
            }
            case -745826705: {
                Base[] baseArray;
                if (this.doseStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.doseStatus;
                }
                return baseArray;
            }
            case 662783379: {
                return this.doseStatusReason == null ? new Base[]{} : this.doseStatusReason.toArray(new Base[this.doseStatusReason.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -905838985: {
                Base[] baseArray;
                if (this.series == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.series;
                }
                return baseArray;
            }
            case -887709242: {
                Base[] baseArray;
                if (this.doseNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.doseNumber;
                }
                return baseArray;
            }
            case -1936727105: {
                Base[] baseArray;
                if (this.seriesDoses == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.seriesDoses;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ImmunizationEvaluationStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1475610435: {
                this.authority = TypeConvertor.castToReference(value);
                return value;
            }
            case -319593813: {
                this.targetDisease = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1081446840: {
                this.immunizationEvent = TypeConvertor.castToReference(value);
                return value;
            }
            case -745826705: {
                this.doseStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 662783379: {
                this.getDoseStatusReason().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -905838985: {
                this.series = TypeConvertor.castToString(value);
                return value;
            }
            case -887709242: {
                this.doseNumber = TypeConvertor.castToString(value);
                return value;
            }
            case -1936727105: {
                this.seriesDoses = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ImmunizationEvaluationStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("authority")) {
            this.authority = TypeConvertor.castToReference(value);
        } else if (name.equals("targetDisease")) {
            this.targetDisease = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("immunizationEvent")) {
            this.immunizationEvent = TypeConvertor.castToReference(value);
        } else if (name.equals("doseStatus")) {
            this.doseStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("doseStatusReason")) {
            this.getDoseStatusReason().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("series")) {
            this.series = TypeConvertor.castToString(value);
        } else if (name.equals("doseNumber")) {
            this.doseNumber = TypeConvertor.castToString(value);
        } else if (name.equals("seriesDoses")) {
            this.seriesDoses = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new ImmunizationEvaluationStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals("authority")) {
            this.authority = null;
        } else if (name.equals("targetDisease")) {
            this.targetDisease = null;
        } else if (name.equals("immunizationEvent")) {
            this.immunizationEvent = null;
        } else if (name.equals("doseStatus")) {
            this.doseStatus = null;
        } else if (name.equals("doseStatusReason")) {
            this.getDoseStatusReason().remove(value);
        } else if (name.equals("description")) {
            this.description = null;
        } else if (name.equals("series")) {
            this.series = null;
        } else if (name.equals("doseNumber")) {
            this.doseNumber = null;
        } else if (name.equals("seriesDoses")) {
            this.seriesDoses = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1475610435: {
                return this.getAuthority();
            }
            case -319593813: {
                return this.getTargetDisease();
            }
            case 1081446840: {
                return this.getImmunizationEvent();
            }
            case -745826705: {
                return this.getDoseStatus();
            }
            case 662783379: {
                return this.addDoseStatusReason();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -905838985: {
                return this.getSeriesElement();
            }
            case -887709242: {
                return this.getDoseNumberElement();
            }
            case -1936727105: {
                return this.getSeriesDosesElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1475610435: {
                return new String[]{"Reference"};
            }
            case -319593813: {
                return new String[]{"CodeableConcept"};
            }
            case 1081446840: {
                return new String[]{"Reference"};
            }
            case -745826705: {
                return new String[]{"CodeableConcept"};
            }
            case 662783379: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -905838985: {
                return new String[]{"string"};
            }
            case -887709242: {
                return new String[]{"string"};
            }
            case -1936727105: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImmunizationEvaluation.status");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImmunizationEvaluation.date");
        }
        if (name.equals("authority")) {
            this.authority = new Reference();
            return this.authority;
        }
        if (name.equals("targetDisease")) {
            this.targetDisease = new CodeableConcept();
            return this.targetDisease;
        }
        if (name.equals("immunizationEvent")) {
            this.immunizationEvent = new Reference();
            return this.immunizationEvent;
        }
        if (name.equals("doseStatus")) {
            this.doseStatus = new CodeableConcept();
            return this.doseStatus;
        }
        if (name.equals("doseStatusReason")) {
            return this.addDoseStatusReason();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImmunizationEvaluation.description");
        }
        if (name.equals("series")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImmunizationEvaluation.series");
        }
        if (name.equals("doseNumber")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImmunizationEvaluation.doseNumber");
        }
        if (name.equals("seriesDoses")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImmunizationEvaluation.seriesDoses");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImmunizationEvaluation";
    }

    @Override
    public ImmunizationEvaluation copy() {
        ImmunizationEvaluation dst = new ImmunizationEvaluation();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ImmunizationEvaluation dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.authority = this.authority == null ? null : this.authority.copy();
        dst.targetDisease = this.targetDisease == null ? null : this.targetDisease.copy();
        dst.immunizationEvent = this.immunizationEvent == null ? null : this.immunizationEvent.copy();
        CodeableConcept codeableConcept = dst.doseStatus = this.doseStatus == null ? null : this.doseStatus.copy();
        if (this.doseStatusReason != null) {
            dst.doseStatusReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.doseStatusReason) {
                dst.doseStatusReason.add(codeableConcept2.copy());
            }
        }
        dst.description = this.description == null ? null : this.description.copy();
        dst.series = this.series == null ? null : this.series.copy();
        dst.doseNumber = this.doseNumber == null ? null : this.doseNumber.copy();
        dst.seriesDoses = this.seriesDoses == null ? null : this.seriesDoses.copy();
    }

    protected ImmunizationEvaluation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ImmunizationEvaluation)) {
            return false;
        }
        ImmunizationEvaluation o = (ImmunizationEvaluation)other_;
        return ImmunizationEvaluation.compareDeep(this.identifier, o.identifier, true) && ImmunizationEvaluation.compareDeep(this.status, o.status, true) && ImmunizationEvaluation.compareDeep(this.patient, o.patient, true) && ImmunizationEvaluation.compareDeep(this.date, o.date, true) && ImmunizationEvaluation.compareDeep(this.authority, o.authority, true) && ImmunizationEvaluation.compareDeep(this.targetDisease, o.targetDisease, true) && ImmunizationEvaluation.compareDeep(this.immunizationEvent, o.immunizationEvent, true) && ImmunizationEvaluation.compareDeep(this.doseStatus, o.doseStatus, true) && ImmunizationEvaluation.compareDeep(this.doseStatusReason, o.doseStatusReason, true) && ImmunizationEvaluation.compareDeep(this.description, o.description, true) && ImmunizationEvaluation.compareDeep(this.series, o.series, true) && ImmunizationEvaluation.compareDeep(this.doseNumber, o.doseNumber, true) && ImmunizationEvaluation.compareDeep(this.seriesDoses, o.seriesDoses, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ImmunizationEvaluation)) {
            return false;
        }
        ImmunizationEvaluation o = (ImmunizationEvaluation)other_;
        return ImmunizationEvaluation.compareValues(this.status, o.status, true) && ImmunizationEvaluation.compareValues(this.date, o.date, true) && ImmunizationEvaluation.compareValues(this.description, o.description, true) && ImmunizationEvaluation.compareValues(this.series, o.series, true) && ImmunizationEvaluation.compareValues(this.doseNumber, o.doseNumber, true) && ImmunizationEvaluation.compareValues(this.seriesDoses, o.seriesDoses, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.patient, this.date, this.authority, this.targetDisease, this.immunizationEvent, this.doseStatus, this.doseStatusReason, this.description, this.series, this.doseNumber, this.seriesDoses});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImmunizationEvaluation;
    }

    public static enum ImmunizationEvaluationStatusCodes {
        COMPLETED,
        ENTEREDINERROR,
        NULL;


        public static ImmunizationEvaluationStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ImmunizationEvaluationStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case COMPLETED: {
                    return "http://hl7.org/fhir/CodeSystem/medication-admin-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/CodeSystem/medication-admin-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case COMPLETED: {
                    return "All actions that are implied by the administration have occurred.";
                }
                case ENTEREDINERROR: {
                    return "The administration was entered in error and therefore nullified.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ImmunizationEvaluationStatusCodesEnumFactory
    implements EnumFactory<ImmunizationEvaluationStatusCodes> {
        @Override
        public ImmunizationEvaluationStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("completed".equals(codeString)) {
                return ImmunizationEvaluationStatusCodes.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ImmunizationEvaluationStatusCodes.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ImmunizationEvaluationStatusCodes code '" + codeString + "'");
        }

        public Enumeration<ImmunizationEvaluationStatusCodes> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ImmunizationEvaluationStatusCodes>(this, ImmunizationEvaluationStatusCodes.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ImmunizationEvaluationStatusCodes>(this, ImmunizationEvaluationStatusCodes.NULL, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ImmunizationEvaluationStatusCodes>(this, ImmunizationEvaluationStatusCodes.COMPLETED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ImmunizationEvaluationStatusCodes>(this, ImmunizationEvaluationStatusCodes.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown ImmunizationEvaluationStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(ImmunizationEvaluationStatusCodes code) {
            if (code == ImmunizationEvaluationStatusCodes.NULL) {
                return null;
            }
            if (code == ImmunizationEvaluationStatusCodes.COMPLETED) {
                return "completed";
            }
            if (code == ImmunizationEvaluationStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ImmunizationEvaluationStatusCodes code) {
            return code.getSystem();
        }
    }
}

