/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openapi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.hl7.fhir.r5.openapi.BaseWriter;
import org.hl7.fhir.r5.openapi.ComponentsWriter;
import org.hl7.fhir.r5.openapi.ExternalDocsWriter;
import org.hl7.fhir.r5.openapi.InfoWriter;
import org.hl7.fhir.r5.openapi.PathItemWriter;
import org.hl7.fhir.r5.openapi.ServerWriter;
import org.hl7.fhir.r5.openapi.TagWriter;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class Writer
extends BaseWriter {
    private OutputStream stream;

    public Writer(OutputStream stream) {
        super(new JsonObject());
        this.stream = stream;
        this.object.addProperty("openapi", "3.0.2");
    }

    public Writer(OutputStream stream, InputStream template) throws JsonSyntaxException, IOException {
        super(Writer.parse(template));
        this.stream = stream;
        this.object.addProperty("openapi", "3.0.2");
    }

    private static JsonObject parse(InputStream template) throws JsonSyntaxException, IOException {
        JsonParser parser = new JsonParser();
        return parser.parse(FileUtilities.streamToString((InputStream)template)).getAsJsonObject();
    }

    public void commit() throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)this.object);
        OutputStreamWriter sw = new OutputStreamWriter(this.stream, "UTF-8");
        sw.write(65279);
        sw.write(json);
        sw.flush();
        sw.close();
    }

    public InfoWriter info() {
        return new InfoWriter(this.ensureObject("info"));
    }

    public PathItemWriter path(String path) {
        return new PathItemWriter(this.ensureMapObject("paths", path));
    }

    public Writer pathRef(String path, String url) {
        this.ensureMapObject("paths", path).addProperty("$ref", url);
        return this;
    }

    public ServerWriter server(String url) {
        return new ServerWriter(this.ensureArrayObject("servers", "url", url));
    }

    public TagWriter tag(String name) {
        return new TagWriter(this.ensureArrayObject("tags", "name", name));
    }

    public ExternalDocsWriter externalDocs() {
        return new ExternalDocsWriter(this.ensureObject("externalDocs"));
    }

    public ComponentsWriter components() {
        return new ComponentsWriter(this.ensureObject("components"));
    }
}

