/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;
import org.hl7.fhir.r5.openehr.RESOURCE_DESCRIPTION;
import org.hl7.fhir.r5.openehr.REVISION_HISTORY;
import org.hl7.fhir.r5.openehr.TRANSLATION_DETAILS;

@DatatypeDef(name="AUTHORED_RESOURCE")
public abstract class AUTHORED_RESOURCE
extends LogicalBase
implements ICompositeType {
    @Child(name="original_language", type={CODE_PHRASE.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Language in which this resource was initially authored", formalDefinition="Language in which this resource was initially authored. Although there is no language primacy of resources overall, the language of original authoring is required to ensure natural language translations can preserve quality. Language is relevant in both the description and ontology sections.")
    protected CODE_PHRASE original_language;
    @Child(name="is_controlled", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="True if this resource is under any kind of change control (even file copying), in which case revision history is created", formalDefinition="True if this resource is under any kind of change control (even file copying), in which case revision history is created.")
    protected BooleanType is_controlled;
    @Child(name="translations", type={TRANSLATION_DETAILS.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of details for each natural-language translation made of this resource, keyed by language", formalDefinition="List of details for each natural-language translation made of this resource, keyed by language. For each translation listed here, there must be corresponding sections in all language-dependent parts of the resource. The original_language does not appear in this list.")
    protected List<TRANSLATION_DETAILS> translationsList;
    @Child(name="description", type={RESOURCE_DESCRIPTION.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description and lifecycle information of the resource", formalDefinition="Description and lifecycle information of the resource.")
    protected RESOURCE_DESCRIPTION description;
    @Child(name="revision_history", type={REVISION_HISTORY.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The revision history of the resource. Only required if is_controlled = True", formalDefinition="The revision history of the resource. Only required if is_controlled = True (avoids large revision histories for informal or private editing situations).")
    protected REVISION_HISTORY revision_history;
    private static final long serialVersionUID = 673004665L;

    public AUTHORED_RESOURCE() {
    }

    public AUTHORED_RESOURCE(CODE_PHRASE original_language) {
        this.setOriginal_language(original_language);
    }

    public CODE_PHRASE getOriginal_language() {
        if (this.original_language == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AUTHORED_RESOURCE.original_language");
            }
            if (Configuration.doAutoCreate()) {
                this.original_language = new CODE_PHRASE();
            }
        }
        return this.original_language;
    }

    public boolean hasOriginal_language() {
        return this.original_language != null && !this.original_language.isEmpty();
    }

    public AUTHORED_RESOURCE setOriginal_language(CODE_PHRASE value) {
        this.original_language = value;
        return this;
    }

    public BooleanType getIs_controlledElement() {
        if (this.is_controlled == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AUTHORED_RESOURCE.is_controlled");
            }
            if (Configuration.doAutoCreate()) {
                this.is_controlled = new BooleanType();
            }
        }
        return this.is_controlled;
    }

    public boolean hasIs_controlledElement() {
        return this.is_controlled != null && !this.is_controlled.isEmpty();
    }

    public boolean hasIs_controlled() {
        return this.is_controlled != null && !this.is_controlled.isEmpty();
    }

    public AUTHORED_RESOURCE setIs_controlledElement(BooleanType value) {
        this.is_controlled = value;
        return this;
    }

    public boolean getIs_controlled() {
        return this.is_controlled == null || this.is_controlled.isEmpty() ? false : (Boolean)this.is_controlled.getValue();
    }

    public AUTHORED_RESOURCE setIs_controlled(boolean value) {
        if (this.is_controlled == null) {
            this.is_controlled = new BooleanType();
        }
        this.is_controlled.setValue((Object)value);
        return this;
    }

    public List<TRANSLATION_DETAILS> getTranslationsList() {
        if (this.translationsList == null) {
            this.translationsList = new ArrayList<TRANSLATION_DETAILS>();
        }
        return this.translationsList;
    }

    public AUTHORED_RESOURCE setTranslationsList(List<TRANSLATION_DETAILS> theTranslations) {
        this.translationsList = theTranslations;
        return this;
    }

    public boolean hasTranslations() {
        if (this.translationsList == null) {
            return false;
        }
        for (TRANSLATION_DETAILS item : this.translationsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TRANSLATION_DETAILS addTranslations() {
        TRANSLATION_DETAILS t = new TRANSLATION_DETAILS();
        if (this.translationsList == null) {
            this.translationsList = new ArrayList<TRANSLATION_DETAILS>();
        }
        this.translationsList.add(t);
        return t;
    }

    public AUTHORED_RESOURCE addTranslations(TRANSLATION_DETAILS t) {
        if (t == null) {
            return this;
        }
        if (this.translationsList == null) {
            this.translationsList = new ArrayList<TRANSLATION_DETAILS>();
        }
        this.translationsList.add(t);
        return this;
    }

    public TRANSLATION_DETAILS getTranslationsFirstRep() {
        if (this.getTranslationsList().isEmpty()) {
            this.addTranslations();
        }
        return this.getTranslationsList().get(0);
    }

    public RESOURCE_DESCRIPTION getDescription() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AUTHORED_RESOURCE.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new RESOURCE_DESCRIPTION();
            }
        }
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public AUTHORED_RESOURCE setDescription(RESOURCE_DESCRIPTION value) {
        this.description = value;
        return this;
    }

    public REVISION_HISTORY getRevision_history() {
        if (this.revision_history == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AUTHORED_RESOURCE.revision_history");
            }
            if (Configuration.doAutoCreate()) {
                this.revision_history = new REVISION_HISTORY();
            }
        }
        return this.revision_history;
    }

    public boolean hasRevision_history() {
        return this.revision_history != null && !this.revision_history.isEmpty();
    }

    public AUTHORED_RESOURCE setRevision_history(REVISION_HISTORY value) {
        this.revision_history = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("original_language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Language in which this resource was initially authored. Although there is no language primacy of resources overall, the language of original authoring is required to ensure natural language translations can preserve quality. Language is relevant in both the description and ontology sections.", 0, 1, this.original_language));
        children.add(new Property("is_controlled", "boolean", "True if this resource is under any kind of change control (even file copying), in which case revision history is created.", 0, 1, this.is_controlled));
        children.add(new Property("translations", "http://openehr.org/fhir/StructureDefinition/TRANSLATION-DETAILS", "List of details for each natural-language translation made of this resource, keyed by language. For each translation listed here, there must be corresponding sections in all language-dependent parts of the resource. The original_language does not appear in this list.", 0, Integer.MAX_VALUE, this.translationsList));
        children.add(new Property("description", "http://openehr.org/fhir/StructureDefinition/RESOURCE-DESCRIPTION", "Description and lifecycle information of the resource.", 0, 1, this.description));
        children.add(new Property("revision_history", "http://openehr.org/fhir/StructureDefinition/REVISION-HISTORY", "The revision history of the resource. Only required if is_controlled = True (avoids large revision histories for informal or private editing situations).", 0, 1, this.revision_history));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1757722118: {
                return new Property("original_language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Language in which this resource was initially authored. Although there is no language primacy of resources overall, the language of original authoring is required to ensure natural language translations can preserve quality. Language is relevant in both the description and ontology sections.", 0, 1, this.original_language);
            }
            case -1352159805: {
                return new Property("is_controlled", "boolean", "True if this resource is under any kind of change control (even file copying), in which case revision history is created.", 0, 1, this.is_controlled);
            }
            case -1225497630: {
                return new Property("translations", "http://openehr.org/fhir/StructureDefinition/TRANSLATION-DETAILS", "List of details for each natural-language translation made of this resource, keyed by language. For each translation listed here, there must be corresponding sections in all language-dependent parts of the resource. The original_language does not appear in this list.", 0, Integer.MAX_VALUE, this.translationsList);
            }
            case -1724546052: {
                return new Property("description", "http://openehr.org/fhir/StructureDefinition/RESOURCE-DESCRIPTION", "Description and lifecycle information of the resource.", 0, 1, this.description);
            }
            case -1037551568: {
                return new Property("revision_history", "http://openehr.org/fhir/StructureDefinition/REVISION-HISTORY", "The revision history of the resource. Only required if is_controlled = True (avoids large revision histories for informal or private editing situations).", 0, 1, this.revision_history);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1757722118: {
                Base[] baseArray;
                if (this.original_language == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.original_language;
                }
                return baseArray;
            }
            case -1352159805: {
                Base[] baseArray;
                if (this.is_controlled == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.is_controlled;
                }
                return baseArray;
            }
            case -1225497630: {
                return this.translationsList == null ? new Base[]{} : this.translationsList.toArray(new Base[this.translationsList.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.description;
                }
                return baseArray;
            }
            case -1037551568: {
                Base[] baseArray;
                if (this.revision_history == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.revision_history;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1757722118: {
                this.original_language = (CODE_PHRASE)value;
                return value;
            }
            case -1352159805: {
                this.is_controlled = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1225497630: {
                this.getTranslationsList().add((TRANSLATION_DETAILS)value);
                return value;
            }
            case -1724546052: {
                this.description = (RESOURCE_DESCRIPTION)value;
                return value;
            }
            case -1037551568: {
                this.revision_history = (REVISION_HISTORY)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("original_language")) {
            this.original_language = (CODE_PHRASE)value;
        } else if (name.equals("is_controlled")) {
            this.is_controlled = TypeConvertor.castToBoolean(value);
        } else if (name.equals("translations")) {
            this.getTranslationsList().add((TRANSLATION_DETAILS)value);
        } else if (name.equals("description")) {
            this.description = (RESOURCE_DESCRIPTION)value;
        } else if (name.equals("revision_history")) {
            this.revision_history = (REVISION_HISTORY)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1757722118: {
                return this.getOriginal_language();
            }
            case -1352159805: {
                return this.getIs_controlledElement();
            }
            case -1225497630: {
                return this.addTranslations();
            }
            case -1724546052: {
                return this.getDescription();
            }
            case -1037551568: {
                return this.getRevision_history();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1757722118: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case -1352159805: {
                return new String[]{"boolean"};
            }
            case -1225497630: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/TRANSLATION-DETAILS"};
            }
            case -1724546052: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/RESOURCE-DESCRIPTION"};
            }
            case -1037551568: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/REVISION-HISTORY"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("original_language")) {
            this.original_language = new CODE_PHRASE();
            return this.original_language;
        }
        if (name.equals("is_controlled")) {
            throw new FHIRException("Cannot call addChild on a singleton property AUTHORED_RESOURCE.is_controlled");
        }
        if (name.equals("translations")) {
            return this.addTranslations();
        }
        if (name.equals("description")) {
            this.description = new RESOURCE_DESCRIPTION();
            return this.description;
        }
        if (name.equals("revision_history")) {
            this.revision_history = new REVISION_HISTORY();
            return this.revision_history;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AUTHORED_RESOURCE";
    }

    @Override
    public abstract AUTHORED_RESOURCE copy();

    public void copyValues(AUTHORED_RESOURCE dst) {
        super.copyValues(dst);
        dst.original_language = this.original_language == null ? null : this.original_language.copy();
        BooleanType booleanType = dst.is_controlled = this.is_controlled == null ? null : this.is_controlled.copy();
        if (this.translationsList != null) {
            dst.translationsList = new ArrayList<TRANSLATION_DETAILS>();
            for (TRANSLATION_DETAILS i : this.translationsList) {
                dst.translationsList.add(i.copy());
            }
        }
        dst.description = this.description == null ? null : this.description.copy();
        dst.revision_history = this.revision_history == null ? null : this.revision_history.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof AUTHORED_RESOURCE)) {
            return false;
        }
        AUTHORED_RESOURCE o = (AUTHORED_RESOURCE)other_;
        return AUTHORED_RESOURCE.compareDeep(this.original_language, o.original_language, true) && AUTHORED_RESOURCE.compareDeep(this.is_controlled, o.is_controlled, true) && AUTHORED_RESOURCE.compareDeep(this.translationsList, o.translationsList, true) && AUTHORED_RESOURCE.compareDeep(this.description, o.description, true) && AUTHORED_RESOURCE.compareDeep(this.revision_history, o.revision_history, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof AUTHORED_RESOURCE)) {
            return false;
        }
        AUTHORED_RESOURCE o = (AUTHORED_RESOURCE)other_;
        return AUTHORED_RESOURCE.compareValues(this.is_controlled, o.is_controlled, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.original_language, this.is_controlled, this.translationsList, this.description, this.revision_history});
    }
}

