/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Annotations")
public class Annotations
extends LogicalBase
implements ICompositeType {
    @Child(name="comment", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType comment;
    @Child(name="fhir_mapping", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType fhir_mapping;
    @Child(name="vset_description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType vset_description;
    @Child(name="hl7v2_mapping", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType hl7v2_mapping;
    @Child(name="visibleInView", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType visibleInView;
    private static final long serialVersionUID = 1193300325L;

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Annotations.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public Annotations setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public Annotations setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public StringType getFhir_mappingElement() {
        if (this.fhir_mapping == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Annotations.fhir_mapping");
            }
            if (Configuration.doAutoCreate()) {
                this.fhir_mapping = new StringType();
            }
        }
        return this.fhir_mapping;
    }

    public boolean hasFhir_mappingElement() {
        return this.fhir_mapping != null && !this.fhir_mapping.isEmpty();
    }

    public boolean hasFhir_mapping() {
        return this.fhir_mapping != null && !this.fhir_mapping.isEmpty();
    }

    public Annotations setFhir_mappingElement(StringType value) {
        this.fhir_mapping = value;
        return this;
    }

    public String getFhir_mapping() {
        return this.fhir_mapping == null ? null : (String)this.fhir_mapping.getValue();
    }

    public Annotations setFhir_mapping(String value) {
        if (Utilities.noString((String)value)) {
            this.fhir_mapping = null;
        } else {
            if (this.fhir_mapping == null) {
                this.fhir_mapping = new StringType();
            }
            this.fhir_mapping.setValue(value);
        }
        return this;
    }

    public StringType getVset_descriptionElement() {
        if (this.vset_description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Annotations.vset_description");
            }
            if (Configuration.doAutoCreate()) {
                this.vset_description = new StringType();
            }
        }
        return this.vset_description;
    }

    public boolean hasVset_descriptionElement() {
        return this.vset_description != null && !this.vset_description.isEmpty();
    }

    public boolean hasVset_description() {
        return this.vset_description != null && !this.vset_description.isEmpty();
    }

    public Annotations setVset_descriptionElement(StringType value) {
        this.vset_description = value;
        return this;
    }

    public String getVset_description() {
        return this.vset_description == null ? null : (String)this.vset_description.getValue();
    }

    public Annotations setVset_description(String value) {
        if (Utilities.noString((String)value)) {
            this.vset_description = null;
        } else {
            if (this.vset_description == null) {
                this.vset_description = new StringType();
            }
            this.vset_description.setValue(value);
        }
        return this;
    }

    public StringType getHl7v2_mappingElement() {
        if (this.hl7v2_mapping == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Annotations.hl7v2_mapping");
            }
            if (Configuration.doAutoCreate()) {
                this.hl7v2_mapping = new StringType();
            }
        }
        return this.hl7v2_mapping;
    }

    public boolean hasHl7v2_mappingElement() {
        return this.hl7v2_mapping != null && !this.hl7v2_mapping.isEmpty();
    }

    public boolean hasHl7v2_mapping() {
        return this.hl7v2_mapping != null && !this.hl7v2_mapping.isEmpty();
    }

    public Annotations setHl7v2_mappingElement(StringType value) {
        this.hl7v2_mapping = value;
        return this;
    }

    public String getHl7v2_mapping() {
        return this.hl7v2_mapping == null ? null : (String)this.hl7v2_mapping.getValue();
    }

    public Annotations setHl7v2_mapping(String value) {
        if (Utilities.noString((String)value)) {
            this.hl7v2_mapping = null;
        } else {
            if (this.hl7v2_mapping == null) {
                this.hl7v2_mapping = new StringType();
            }
            this.hl7v2_mapping.setValue(value);
        }
        return this;
    }

    public StringType getVisibleInViewElement() {
        if (this.visibleInView == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Annotations.visibleInView");
            }
            if (Configuration.doAutoCreate()) {
                this.visibleInView = new StringType();
            }
        }
        return this.visibleInView;
    }

    public boolean hasVisibleInViewElement() {
        return this.visibleInView != null && !this.visibleInView.isEmpty();
    }

    public boolean hasVisibleInView() {
        return this.visibleInView != null && !this.visibleInView.isEmpty();
    }

    public Annotations setVisibleInViewElement(StringType value) {
        this.visibleInView = value;
        return this;
    }

    public String getVisibleInView() {
        return this.visibleInView == null ? null : (String)this.visibleInView.getValue();
    }

    public Annotations setVisibleInView(String value) {
        if (Utilities.noString((String)value)) {
            this.visibleInView = null;
        } else {
            if (this.visibleInView == null) {
                this.visibleInView = new StringType();
            }
            this.visibleInView.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("comment", "string", "", 0, 1, this.comment));
        children.add(new Property("fhir_mapping", "string", "", 0, 1, this.fhir_mapping));
        children.add(new Property("vset_description", "string", "", 0, 1, this.vset_description));
        children.add(new Property("hl7v2_mapping", "string", "", 0, 1, this.hl7v2_mapping));
        children.add(new Property("visibleInView", "string", "", 0, 1, this.visibleInView));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 950398559: {
                return new Property("comment", "string", "", 0, 1, this.comment);
            }
            case -2067458566: {
                return new Property("fhir_mapping", "string", "", 0, 1, this.fhir_mapping);
            }
            case -87138199: {
                return new Property("vset_description", "string", "", 0, 1, this.vset_description);
            }
            case 1862427134: {
                return new Property("hl7v2_mapping", "string", "", 0, 1, this.hl7v2_mapping);
            }
            case 602726524: {
                return new Property("visibleInView", "string", "", 0, 1, this.visibleInView);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.comment;
                }
                return baseArray;
            }
            case -2067458566: {
                Base[] baseArray;
                if (this.fhir_mapping == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.fhir_mapping;
                }
                return baseArray;
            }
            case -87138199: {
                Base[] baseArray;
                if (this.vset_description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.vset_description;
                }
                return baseArray;
            }
            case 1862427134: {
                Base[] baseArray;
                if (this.hl7v2_mapping == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.hl7v2_mapping;
                }
                return baseArray;
            }
            case 602726524: {
                Base[] baseArray;
                if (this.visibleInView == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.visibleInView;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 950398559: {
                this.comment = TypeConvertor.castToString(value);
                return value;
            }
            case -2067458566: {
                this.fhir_mapping = TypeConvertor.castToString(value);
                return value;
            }
            case -87138199: {
                this.vset_description = TypeConvertor.castToString(value);
                return value;
            }
            case 1862427134: {
                this.hl7v2_mapping = TypeConvertor.castToString(value);
                return value;
            }
            case 602726524: {
                this.visibleInView = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("comment")) {
            this.comment = TypeConvertor.castToString(value);
        } else if (name.equals("fhir_mapping")) {
            this.fhir_mapping = TypeConvertor.castToString(value);
        } else if (name.equals("vset_description")) {
            this.vset_description = TypeConvertor.castToString(value);
        } else if (name.equals("hl7v2_mapping")) {
            this.hl7v2_mapping = TypeConvertor.castToString(value);
        } else if (name.equals("visibleInView")) {
            this.visibleInView = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 950398559: {
                return this.getCommentElement();
            }
            case -2067458566: {
                return this.getFhir_mappingElement();
            }
            case -87138199: {
                return this.getVset_descriptionElement();
            }
            case 1862427134: {
                return this.getHl7v2_mappingElement();
            }
            case 602726524: {
                return this.getVisibleInViewElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 950398559: {
                return new String[]{"string"};
            }
            case -2067458566: {
                return new String[]{"string"};
            }
            case -87138199: {
                return new String[]{"string"};
            }
            case 1862427134: {
                return new String[]{"string"};
            }
            case 602726524: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a singleton property Annotations.comment");
        }
        if (name.equals("fhir_mapping")) {
            throw new FHIRException("Cannot call addChild on a singleton property Annotations.fhir_mapping");
        }
        if (name.equals("vset_description")) {
            throw new FHIRException("Cannot call addChild on a singleton property Annotations.vset_description");
        }
        if (name.equals("hl7v2_mapping")) {
            throw new FHIRException("Cannot call addChild on a singleton property Annotations.hl7v2_mapping");
        }
        if (name.equals("visibleInView")) {
            throw new FHIRException("Cannot call addChild on a singleton property Annotations.visibleInView");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Annotations";
    }

    @Override
    public Annotations copy() {
        Annotations dst = new Annotations();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Annotations dst) {
        super.copyValues(dst);
        dst.comment = this.comment == null ? null : this.comment.copy();
        dst.fhir_mapping = this.fhir_mapping == null ? null : this.fhir_mapping.copy();
        dst.vset_description = this.vset_description == null ? null : this.vset_description.copy();
        dst.hl7v2_mapping = this.hl7v2_mapping == null ? null : this.hl7v2_mapping.copy();
        dst.visibleInView = this.visibleInView == null ? null : this.visibleInView.copy();
    }

    protected Annotations typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Annotations)) {
            return false;
        }
        Annotations o = (Annotations)other_;
        return Annotations.compareDeep(this.comment, o.comment, true) && Annotations.compareDeep(this.fhir_mapping, o.fhir_mapping, true) && Annotations.compareDeep(this.vset_description, o.vset_description, true) && Annotations.compareDeep(this.hl7v2_mapping, o.hl7v2_mapping, true) && Annotations.compareDeep(this.visibleInView, o.visibleInView, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Annotations)) {
            return false;
        }
        Annotations o = (Annotations)other_;
        return Annotations.compareValues(this.comment, o.comment, true) && Annotations.compareValues(this.fhir_mapping, o.fhir_mapping, true) && Annotations.compareValues(this.vset_description, o.vset_description, true) && Annotations.compareValues(this.hl7v2_mapping, o.hl7v2_mapping, true) && Annotations.compareValues(this.visibleInView, o.visibleInView, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.comment, this.fhir_mapping, this.vset_description, this.hl7v2_mapping, this.visibleInView});
    }
}

