/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DV_INTERVAL;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.LOCATABLE;

@DatatypeDef(name="CAPABILITY")
public class CAPABILITY
extends LOCATABLE
implements ICompositeType {
    @Child(name="credentials", type={ITEM_STRUCTURE.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The qualifications of the performer of the role for this capability", formalDefinition="The qualifications of the performer of the role for this capability. This might include professional qualifications and official identifications such as provider numbers etc.")
    protected ITEM_STRUCTURE credentials;
    @Child(name="time_validity", type={DV_INTERVAL.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Valid time interval for the credentials of this capability", formalDefinition="Valid time interval for the credentials of this capability.")
    protected DV_INTERVAL time_validity;
    private static final long serialVersionUID = -541927433L;

    public CAPABILITY() {
    }

    public CAPABILITY(ITEM_STRUCTURE credentials) {
        this.setCredentials(credentials);
    }

    public ITEM_STRUCTURE getCredentials() {
        return this.credentials;
    }

    public boolean hasCredentials() {
        return this.credentials != null && !this.credentials.isEmpty();
    }

    public CAPABILITY setCredentials(ITEM_STRUCTURE value) {
        this.credentials = value;
        return this;
    }

    public DV_INTERVAL getTime_validity() {
        if (this.time_validity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CAPABILITY.time_validity");
            }
            if (Configuration.doAutoCreate()) {
                this.time_validity = new DV_INTERVAL();
            }
        }
        return this.time_validity;
    }

    public boolean hasTime_validity() {
        return this.time_validity != null && !this.time_validity.isEmpty();
    }

    public CAPABILITY setTime_validity(DV_INTERVAL value) {
        this.time_validity = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("credentials", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "The qualifications of the performer of the role for this capability. This might include professional qualifications and official identifications such as provider numbers etc.", 0, 1, this.credentials));
        children.add(new Property("time_validity", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "Valid time interval for the credentials of this capability.", 0, 1, this.time_validity));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 288957180: {
                return new Property("credentials", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "The qualifications of the performer of the role for this capability. This might include professional qualifications and official identifications such as provider numbers etc.", 0, 1, this.credentials);
            }
            case -1304171420: {
                return new Property("time_validity", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "Valid time interval for the credentials of this capability.", 0, 1, this.time_validity);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 288957180: {
                Base[] baseArray;
                if (this.credentials == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.credentials;
                }
                return baseArray;
            }
            case -1304171420: {
                Base[] baseArray;
                if (this.time_validity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.time_validity;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 288957180: {
                this.credentials = (ITEM_STRUCTURE)value;
                return value;
            }
            case -1304171420: {
                this.time_validity = (DV_INTERVAL)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("credentials")) {
            this.credentials = (ITEM_STRUCTURE)value;
        } else if (name.equals("time_validity")) {
            this.time_validity = (DV_INTERVAL)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 288957180: {
                throw new Error("Unable to make an instance of the abstract property 'credentials'");
            }
            case -1304171420: {
                return this.getTime_validity();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 288957180: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
            case -1304171420: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-INTERVAL"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("credentials")) {
            throw new FHIRException("Cannot call addChild on an abstract type CAPABILITY.credentials");
        }
        if (name.equals("time_validity")) {
            this.time_validity = new DV_INTERVAL();
            return this.time_validity;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CAPABILITY";
    }

    @Override
    public CAPABILITY copy() {
        CAPABILITY dst = new CAPABILITY();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CAPABILITY dst) {
        super.copyValues(dst);
        dst.credentials = this.credentials == null ? null : this.credentials.copy();
        dst.time_validity = this.time_validity == null ? null : this.time_validity.copy();
    }

    protected CAPABILITY typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CAPABILITY)) {
            return false;
        }
        CAPABILITY o = (CAPABILITY)other_;
        return CAPABILITY.compareDeep(this.credentials, o.credentials, true) && CAPABILITY.compareDeep(this.time_validity, o.time_validity, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CAPABILITY)) {
            return false;
        }
        CAPABILITY o = (CAPABILITY)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.credentials, this.time_validity});
    }
}

