/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.TERMINOLOGY_ID;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="CODE_PHRASE")
public class CODE_PHRASE
extends LogicalBase
implements ICompositeType {
    @Child(name="terminology_id", type={TERMINOLOGY_ID.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Identifier of the distinct terminology from which the code_string was extracted", formalDefinition="Identifier of the distinct terminology from which the code_string (or its elements) was extracted.")
    protected TERMINOLOGY_ID terminology_id;
    @Child(name="code_string", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The key used by the terminology service to identify a concept or coordination of concepts", formalDefinition="The key used by the terminology service to identify a concept or coordination of concepts. This string is most likely parsable inside the terminology service, but nothing can be assumed about its syntax outside that context.")
    protected StringType code_string;
    @Child(name="preferred_term", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional attribute to carry preferred term corresponding to the code or expression in code_string", formalDefinition="Optional attribute to carry preferred term corresponding to the code or expression in code_string. Typical use in integration situations which create mappings, and representing data for which both a (non-preferred) actual term and a preferred term are both required.")
    protected StringType preferred_term;
    private static final long serialVersionUID = -380890311L;

    public CODE_PHRASE() {
    }

    public CODE_PHRASE(TERMINOLOGY_ID terminology_id, String code_string) {
        this.setTerminology_id(terminology_id);
        this.setCode_string(code_string);
    }

    public TERMINOLOGY_ID getTerminology_id() {
        if (this.terminology_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CODE_PHRASE.terminology_id");
            }
            if (Configuration.doAutoCreate()) {
                this.terminology_id = new TERMINOLOGY_ID();
            }
        }
        return this.terminology_id;
    }

    public boolean hasTerminology_id() {
        return this.terminology_id != null && !this.terminology_id.isEmpty();
    }

    public CODE_PHRASE setTerminology_id(TERMINOLOGY_ID value) {
        this.terminology_id = value;
        return this;
    }

    public StringType getCode_stringElement() {
        if (this.code_string == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CODE_PHRASE.code_string");
            }
            if (Configuration.doAutoCreate()) {
                this.code_string = new StringType();
            }
        }
        return this.code_string;
    }

    public boolean hasCode_stringElement() {
        return this.code_string != null && !this.code_string.isEmpty();
    }

    public boolean hasCode_string() {
        return this.code_string != null && !this.code_string.isEmpty();
    }

    public CODE_PHRASE setCode_stringElement(StringType value) {
        this.code_string = value;
        return this;
    }

    public String getCode_string() {
        return this.code_string == null ? null : (String)this.code_string.getValue();
    }

    public CODE_PHRASE setCode_string(String value) {
        if (this.code_string == null) {
            this.code_string = new StringType();
        }
        this.code_string.setValue(value);
        return this;
    }

    public StringType getPreferred_termElement() {
        if (this.preferred_term == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CODE_PHRASE.preferred_term");
            }
            if (Configuration.doAutoCreate()) {
                this.preferred_term = new StringType();
            }
        }
        return this.preferred_term;
    }

    public boolean hasPreferred_termElement() {
        return this.preferred_term != null && !this.preferred_term.isEmpty();
    }

    public boolean hasPreferred_term() {
        return this.preferred_term != null && !this.preferred_term.isEmpty();
    }

    public CODE_PHRASE setPreferred_termElement(StringType value) {
        this.preferred_term = value;
        return this;
    }

    public String getPreferred_term() {
        return this.preferred_term == null ? null : (String)this.preferred_term.getValue();
    }

    public CODE_PHRASE setPreferred_term(String value) {
        if (Utilities.noString((String)value)) {
            this.preferred_term = null;
        } else {
            if (this.preferred_term == null) {
                this.preferred_term = new StringType();
            }
            this.preferred_term.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("terminology_id", "http://openehr.org/fhir/StructureDefinition/TERMINOLOGY-ID", "Identifier of the distinct terminology from which the code_string (or its elements) was extracted.", 0, 1, this.terminology_id));
        children.add(new Property("code_string", "string", "The key used by the terminology service to identify a concept or coordination of concepts. This string is most likely parsable inside the terminology service, but nothing can be assumed about its syntax outside that context.", 0, 1, this.code_string));
        children.add(new Property("preferred_term", "string", "Optional attribute to carry preferred term corresponding to the code or expression in code_string. Typical use in integration situations which create mappings, and representing data for which both a (non-preferred) actual term and a preferred term are both required.", 0, 1, this.preferred_term));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1262816807: {
                return new Property("terminology_id", "http://openehr.org/fhir/StructureDefinition/TERMINOLOGY-ID", "Identifier of the distinct terminology from which the code_string (or its elements) was extracted.", 0, 1, this.terminology_id);
            }
            case -752837981: {
                return new Property("code_string", "string", "The key used by the terminology service to identify a concept or coordination of concepts. This string is most likely parsable inside the terminology service, but nothing can be assumed about its syntax outside that context.", 0, 1, this.code_string);
            }
            case -1673881238: {
                return new Property("preferred_term", "string", "Optional attribute to carry preferred term corresponding to the code or expression in code_string. Typical use in integration situations which create mappings, and representing data for which both a (non-preferred) actual term and a preferred term are both required.", 0, 1, this.preferred_term);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1262816807: {
                Base[] baseArray;
                if (this.terminology_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.terminology_id;
                }
                return baseArray;
            }
            case -752837981: {
                Base[] baseArray;
                if (this.code_string == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code_string;
                }
                return baseArray;
            }
            case -1673881238: {
                Base[] baseArray;
                if (this.preferred_term == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.preferred_term;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1262816807: {
                this.terminology_id = (TERMINOLOGY_ID)value;
                return value;
            }
            case -752837981: {
                this.code_string = TypeConvertor.castToString(value);
                return value;
            }
            case -1673881238: {
                this.preferred_term = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("terminology_id")) {
            this.terminology_id = (TERMINOLOGY_ID)value;
        } else if (name.equals("code_string")) {
            this.code_string = TypeConvertor.castToString(value);
        } else if (name.equals("preferred_term")) {
            this.preferred_term = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1262816807: {
                return this.getTerminology_id();
            }
            case -752837981: {
                return this.getCode_stringElement();
            }
            case -1673881238: {
                return this.getPreferred_termElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1262816807: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/TERMINOLOGY-ID"};
            }
            case -752837981: {
                return new String[]{"string"};
            }
            case -1673881238: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("terminology_id")) {
            this.terminology_id = new TERMINOLOGY_ID();
            return this.terminology_id;
        }
        if (name.equals("code_string")) {
            throw new FHIRException("Cannot call addChild on a singleton property CODE_PHRASE.code_string");
        }
        if (name.equals("preferred_term")) {
            throw new FHIRException("Cannot call addChild on a singleton property CODE_PHRASE.preferred_term");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CODE_PHRASE";
    }

    @Override
    public CODE_PHRASE copy() {
        CODE_PHRASE dst = new CODE_PHRASE();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CODE_PHRASE dst) {
        super.copyValues(dst);
        dst.terminology_id = this.terminology_id == null ? null : this.terminology_id.copy();
        dst.code_string = this.code_string == null ? null : this.code_string.copy();
        dst.preferred_term = this.preferred_term == null ? null : this.preferred_term.copy();
    }

    protected CODE_PHRASE typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CODE_PHRASE)) {
            return false;
        }
        CODE_PHRASE o = (CODE_PHRASE)other_;
        return CODE_PHRASE.compareDeep(this.terminology_id, o.terminology_id, true) && CODE_PHRASE.compareDeep(this.code_string, o.code_string, true) && CODE_PHRASE.compareDeep(this.preferred_term, o.preferred_term, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CODE_PHRASE)) {
            return false;
        }
        CODE_PHRASE o = (CODE_PHRASE)other_;
        return CODE_PHRASE.compareValues(this.code_string, o.code_string, true) && CODE_PHRASE.compareValues(this.preferred_term, o.preferred_term, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.terminology_id, this.code_string, this.preferred_term});
    }
}

