/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;
import org.hl7.fhir.r5.openehr.DV_TEXT;

@DatatypeDef(name="DV_CODED_TEXT")
public class DV_CODED_TEXT
extends DV_TEXT
implements ICompositeType {
    @Child(name="defining_code", type={CODE_PHRASE.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Displayable rendition of the item, regardless of its underlying structure", formalDefinition="Displayable rendition of the item, regardless of its underlying structure. For DV_CODED_TEXT, this is the rubric of the complete term as provided by the terminology service.")
    protected CODE_PHRASE defining_code;
    private static final long serialVersionUID = 599862763L;

    public DV_CODED_TEXT() {
    }

    public DV_CODED_TEXT(CODE_PHRASE defining_code) {
        this.setDefining_code(defining_code);
    }

    public CODE_PHRASE getDefining_code() {
        if (this.defining_code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_CODED_TEXT.defining_code");
            }
            if (Configuration.doAutoCreate()) {
                this.defining_code = new CODE_PHRASE();
            }
        }
        return this.defining_code;
    }

    public boolean hasDefining_code() {
        return this.defining_code != null && !this.defining_code.isEmpty();
    }

    public DV_CODED_TEXT setDefining_code(CODE_PHRASE value) {
        this.defining_code = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("defining_code", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Displayable rendition of the item, regardless of its underlying structure. For DV_CODED_TEXT, this is the rubric of the complete term as provided by the terminology service.", 0, 1, this.defining_code));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 2053146132: {
                return new Property("defining_code", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Displayable rendition of the item, regardless of its underlying structure. For DV_CODED_TEXT, this is the rubric of the complete term as provided by the terminology service.", 0, 1, this.defining_code);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 2053146132: {
                Base[] baseArray;
                if (this.defining_code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.defining_code;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 2053146132: {
                this.defining_code = (CODE_PHRASE)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("defining_code")) {
            return super.setProperty(name, value);
        }
        this.defining_code = (CODE_PHRASE)value;
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 2053146132: {
                return this.getDefining_code();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 2053146132: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("defining_code")) {
            this.defining_code = new CODE_PHRASE();
            return this.defining_code;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_CODED_TEXT";
    }

    @Override
    public DV_CODED_TEXT copy() {
        DV_CODED_TEXT dst = new DV_CODED_TEXT();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_CODED_TEXT dst) {
        super.copyValues(dst);
        dst.defining_code = this.defining_code == null ? null : this.defining_code.copy();
    }

    @Override
    protected DV_CODED_TEXT typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_CODED_TEXT)) {
            return false;
        }
        DV_CODED_TEXT o = (DV_CODED_TEXT)other_;
        return DV_CODED_TEXT.compareDeep(this.defining_code, o.defining_code, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_CODED_TEXT)) {
            return false;
        }
        DV_CODED_TEXT o = (DV_CODED_TEXT)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.defining_code});
    }
}

