/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DATA_VALUE;
import org.hl7.fhir.r5.openehr.DV_TEXT;

@DatatypeDef(name="DV_PARAGRAPH")
public class DV_PARAGRAPH
extends DATA_VALUE
implements ICompositeType {
    @Child(name="items", type={DV_TEXT.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Items making up the paragraph", formalDefinition="Items making up the paragraph, each of which is a text item (which may have its own formatting, and/or have hyperlinks).")
    protected List<DV_TEXT> itemsList;
    private static final long serialVersionUID = 356597994L;

    public List<DV_TEXT> getItemsList() {
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<DV_TEXT>();
        }
        return this.itemsList;
    }

    public DV_PARAGRAPH setItemsList(List<DV_TEXT> theItems) {
        this.itemsList = theItems;
        return this;
    }

    public boolean hasItems() {
        if (this.itemsList == null) {
            return false;
        }
        for (DV_TEXT item : this.itemsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DV_TEXT addItems() {
        DV_TEXT t = new DV_TEXT();
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<DV_TEXT>();
        }
        this.itemsList.add(t);
        return t;
    }

    public DV_PARAGRAPH addItems(DV_TEXT t) {
        if (t == null) {
            return this;
        }
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<DV_TEXT>();
        }
        this.itemsList.add(t);
        return this;
    }

    public DV_TEXT getItemsFirstRep() {
        if (this.getItemsList().isEmpty()) {
            this.addItems();
        }
        return this.getItemsList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("items", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Items making up the paragraph, each of which is a text item (which may have its own formatting, and/or have hyperlinks).", 0, Integer.MAX_VALUE, this.itemsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 100526016: {
                return new Property("items", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Items making up the paragraph, each of which is a text item (which may have its own formatting, and/or have hyperlinks).", 0, Integer.MAX_VALUE, this.itemsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return this.itemsList == null ? new Base[]{} : this.itemsList.toArray(new Base[this.itemsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 100526016: {
                this.getItemsList().add((DV_TEXT)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("items")) {
            return super.setProperty(name, value);
        }
        this.getItemsList().add((DV_TEXT)value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return this.addItems();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-TEXT"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("items")) {
            return this.addItems();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_PARAGRAPH";
    }

    @Override
    public DV_PARAGRAPH copy() {
        DV_PARAGRAPH dst = new DV_PARAGRAPH();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_PARAGRAPH dst) {
        super.copyValues(dst);
        if (this.itemsList != null) {
            dst.itemsList = new ArrayList<DV_TEXT>();
            for (DV_TEXT i : this.itemsList) {
                dst.itemsList.add(i.copy());
            }
        }
    }

    protected DV_PARAGRAPH typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_PARAGRAPH)) {
            return false;
        }
        DV_PARAGRAPH o = (DV_PARAGRAPH)other_;
        return DV_PARAGRAPH.compareDeep(this.itemsList, o.itemsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_PARAGRAPH)) {
            return false;
        }
        DV_PARAGRAPH o = (DV_PARAGRAPH)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.itemsList);
    }
}

