/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.DV_DATE_TIME;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.LOCATABLE;
import org.hl7.fhir.r5.openehr.PARTICIPATION;
import org.hl7.fhir.r5.openehr.PARTY_IDENTIFIED;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="EVENT_CONTEXT")
public class EVENT_CONTEXT
extends LOCATABLE
implements ICompositeType {
    @Child(name="start_time", type={DV_DATE_TIME.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Start time of the clinical session or other kind of event during which a provider performs a service of any kind for the patient", formalDefinition="Start time of the clinical session or other kind of event during which a provider performs a service of any kind for the patient.")
    protected DV_DATE_TIME start_time;
    @Child(name="end_time", type={DV_DATE_TIME.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional end time of the clinical session", formalDefinition="Optional end time of the clinical session.")
    protected DV_DATE_TIME end_time;
    @Child(name="location", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The actual location where the session occurred, e.g. 'microbiology lab 2', 'home', 'ward A3' and so on", formalDefinition="The actual location where the session occurred, e.g. 'microbiology lab 2', 'home', 'ward A3' and so on.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-composition_category")
    protected StringType location;
    @Child(name="setting", type={DV_CODED_TEXT.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The clinical session context of this Composition, i.e. the contextual attributes of the clinical session", formalDefinition="The clinical session context of this Composition, i.e. the contextual attributes of the clinical session.")
    protected DV_CODED_TEXT setting;
    @Child(name="other_context", type={ITEM_STRUCTURE.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Other optional context which will be archetyped", formalDefinition="Other optional context which will be archetyped.")
    protected ITEM_STRUCTURE other_context;
    @Child(name="health_care_facility", type={PARTY_IDENTIFIED.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The health care facility under whose care the event took place", formalDefinition="The health care facility under whose care the event took place. This is the most specific workgroup or delivery unit within a care delivery enterprise that has an official identifier in the health system, and can be used to ensure medico-legal accountability.")
    protected PARTY_IDENTIFIED health_care_facility;
    @Child(name="participations", type={PARTICIPATION.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Parties involved in the healthcare event", formalDefinition="Parties involved in the healthcare event. These would normally include the physician(s) and often the patient (but not the latter if the clinical session is a pathology test for example).")
    protected List<PARTICIPATION> participationsList;
    private static final long serialVersionUID = -454658763L;

    public EVENT_CONTEXT() {
    }

    public EVENT_CONTEXT(DV_DATE_TIME start_time, DV_CODED_TEXT setting) {
        this.setStart_time(start_time);
        this.setSetting(setting);
    }

    public DV_DATE_TIME getStart_time() {
        if (this.start_time == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EVENT_CONTEXT.start_time");
            }
            if (Configuration.doAutoCreate()) {
                this.start_time = new DV_DATE_TIME();
            }
        }
        return this.start_time;
    }

    public boolean hasStart_time() {
        return this.start_time != null && !this.start_time.isEmpty();
    }

    public EVENT_CONTEXT setStart_time(DV_DATE_TIME value) {
        this.start_time = value;
        return this;
    }

    public DV_DATE_TIME getEnd_time() {
        if (this.end_time == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EVENT_CONTEXT.end_time");
            }
            if (Configuration.doAutoCreate()) {
                this.end_time = new DV_DATE_TIME();
            }
        }
        return this.end_time;
    }

    public boolean hasEnd_time() {
        return this.end_time != null && !this.end_time.isEmpty();
    }

    public EVENT_CONTEXT setEnd_time(DV_DATE_TIME value) {
        this.end_time = value;
        return this;
    }

    public StringType getLocationElement() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EVENT_CONTEXT.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new StringType();
            }
        }
        return this.location;
    }

    public boolean hasLocationElement() {
        return this.location != null && !this.location.isEmpty();
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public EVENT_CONTEXT setLocationElement(StringType value) {
        this.location = value;
        return this;
    }

    public String getLocation() {
        return this.location == null ? null : (String)this.location.getValue();
    }

    public EVENT_CONTEXT setLocation(String value) {
        if (Utilities.noString((String)value)) {
            this.location = null;
        } else {
            if (this.location == null) {
                this.location = new StringType();
            }
            this.location.setValue(value);
        }
        return this;
    }

    public DV_CODED_TEXT getSetting() {
        if (this.setting == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EVENT_CONTEXT.setting");
            }
            if (Configuration.doAutoCreate()) {
                this.setting = new DV_CODED_TEXT();
            }
        }
        return this.setting;
    }

    public boolean hasSetting() {
        return this.setting != null && !this.setting.isEmpty();
    }

    public EVENT_CONTEXT setSetting(DV_CODED_TEXT value) {
        this.setting = value;
        return this;
    }

    public ITEM_STRUCTURE getOther_context() {
        return this.other_context;
    }

    public boolean hasOther_context() {
        return this.other_context != null && !this.other_context.isEmpty();
    }

    public EVENT_CONTEXT setOther_context(ITEM_STRUCTURE value) {
        this.other_context = value;
        return this;
    }

    public PARTY_IDENTIFIED getHealth_care_facility() {
        if (this.health_care_facility == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EVENT_CONTEXT.health_care_facility");
            }
            if (Configuration.doAutoCreate()) {
                this.health_care_facility = new PARTY_IDENTIFIED();
            }
        }
        return this.health_care_facility;
    }

    public boolean hasHealth_care_facility() {
        return this.health_care_facility != null && !this.health_care_facility.isEmpty();
    }

    public EVENT_CONTEXT setHealth_care_facility(PARTY_IDENTIFIED value) {
        this.health_care_facility = value;
        return this;
    }

    public List<PARTICIPATION> getParticipationsList() {
        if (this.participationsList == null) {
            this.participationsList = new ArrayList<PARTICIPATION>();
        }
        return this.participationsList;
    }

    public EVENT_CONTEXT setParticipationsList(List<PARTICIPATION> theParticipations) {
        this.participationsList = theParticipations;
        return this;
    }

    public boolean hasParticipations() {
        if (this.participationsList == null) {
            return false;
        }
        for (PARTICIPATION item : this.participationsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PARTICIPATION addParticipations() {
        PARTICIPATION t = new PARTICIPATION();
        if (this.participationsList == null) {
            this.participationsList = new ArrayList<PARTICIPATION>();
        }
        this.participationsList.add(t);
        return t;
    }

    public EVENT_CONTEXT addParticipations(PARTICIPATION t) {
        if (t == null) {
            return this;
        }
        if (this.participationsList == null) {
            this.participationsList = new ArrayList<PARTICIPATION>();
        }
        this.participationsList.add(t);
        return this;
    }

    public PARTICIPATION getParticipationsFirstRep() {
        if (this.getParticipationsList().isEmpty()) {
            this.addParticipations();
        }
        return this.getParticipationsList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("start_time", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Start time of the clinical session or other kind of event during which a provider performs a service of any kind for the patient.", 0, 1, this.start_time));
        children.add(new Property("end_time", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Optional end time of the clinical session.", 0, 1, this.end_time));
        children.add(new Property("location", "string", "The actual location where the session occurred, e.g. 'microbiology lab 2', 'home', 'ward A3' and so on.", 0, 1, this.location));
        children.add(new Property("setting", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "The clinical session context of this Composition, i.e. the contextual attributes of the clinical session.", 0, 1, this.setting));
        children.add(new Property("other_context", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Other optional context which will be archetyped.", 0, 1, this.other_context));
        children.add(new Property("health_care_facility", "http://openehr.org/fhir/StructureDefinition/PARTY-IDENTIFIED", "The health care facility under whose care the event took place. This is the most specific workgroup or delivery unit within a care delivery enterprise that has an official identifier in the health system, and can be used to ensure medico-legal accountability.", 0, 1, this.health_care_facility));
        children.add(new Property("participations", "http://openehr.org/fhir/StructureDefinition/PARTICIPATION", "Parties involved in the healthcare event. These would normally include the physician(s) and often the patient (but not the latter if the clinical session is a pathology test for example).", 0, Integer.MAX_VALUE, this.participationsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1573145462: {
                return new Property("start_time", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Start time of the clinical session or other kind of event during which a provider performs a service of any kind for the patient.", 0, 1, this.start_time);
            }
            case 1725551537: {
                return new Property("end_time", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Optional end time of the clinical session.", 0, 1, this.end_time);
            }
            case 1901043637: {
                return new Property("location", "string", "The actual location where the session occurred, e.g. 'microbiology lab 2', 'home', 'ward A3' and so on.", 0, 1, this.location);
            }
            case 1985941072: {
                return new Property("setting", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "The clinical session context of this Composition, i.e. the contextual attributes of the clinical session.", 0, 1, this.setting);
            }
            case -1863234688: {
                return new Property("other_context", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Other optional context which will be archetyped.", 0, 1, this.other_context);
            }
            case 1115786094: {
                return new Property("health_care_facility", "http://openehr.org/fhir/StructureDefinition/PARTY-IDENTIFIED", "The health care facility under whose care the event took place. This is the most specific workgroup or delivery unit within a care delivery enterprise that has an official identifier in the health system, and can be used to ensure medico-legal accountability.", 0, 1, this.health_care_facility);
            }
            case 170924882: {
                return new Property("participations", "http://openehr.org/fhir/StructureDefinition/PARTICIPATION", "Parties involved in the healthcare event. These would normally include the physician(s) and often the patient (but not the latter if the clinical session is a pathology test for example).", 0, Integer.MAX_VALUE, this.participationsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1573145462: {
                Base[] baseArray;
                if (this.start_time == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.start_time;
                }
                return baseArray;
            }
            case 1725551537: {
                Base[] baseArray;
                if (this.end_time == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.end_time;
                }
                return baseArray;
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.location;
                }
                return baseArray;
            }
            case 1985941072: {
                Base[] baseArray;
                if (this.setting == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.setting;
                }
                return baseArray;
            }
            case -1863234688: {
                Base[] baseArray;
                if (this.other_context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.other_context;
                }
                return baseArray;
            }
            case 1115786094: {
                Base[] baseArray;
                if (this.health_care_facility == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.health_care_facility;
                }
                return baseArray;
            }
            case 170924882: {
                return this.participationsList == null ? new Base[]{} : this.participationsList.toArray(new Base[this.participationsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1573145462: {
                this.start_time = (DV_DATE_TIME)value;
                return value;
            }
            case 1725551537: {
                this.end_time = (DV_DATE_TIME)value;
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToString(value);
                return value;
            }
            case 1985941072: {
                this.setting = (DV_CODED_TEXT)value;
                return value;
            }
            case -1863234688: {
                this.other_context = (ITEM_STRUCTURE)value;
                return value;
            }
            case 1115786094: {
                this.health_care_facility = (PARTY_IDENTIFIED)value;
                return value;
            }
            case 170924882: {
                this.getParticipationsList().add((PARTICIPATION)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("start_time")) {
            this.start_time = (DV_DATE_TIME)value;
        } else if (name.equals("end_time")) {
            this.end_time = (DV_DATE_TIME)value;
        } else if (name.equals("location")) {
            this.location = TypeConvertor.castToString(value);
        } else if (name.equals("setting")) {
            this.setting = (DV_CODED_TEXT)value;
        } else if (name.equals("other_context")) {
            this.other_context = (ITEM_STRUCTURE)value;
        } else if (name.equals("health_care_facility")) {
            this.health_care_facility = (PARTY_IDENTIFIED)value;
        } else if (name.equals("participations")) {
            this.getParticipationsList().add((PARTICIPATION)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1573145462: {
                return this.getStart_time();
            }
            case 1725551537: {
                return this.getEnd_time();
            }
            case 1901043637: {
                return this.getLocationElement();
            }
            case 1985941072: {
                return this.getSetting();
            }
            case -1863234688: {
                throw new Error("Unable to make an instance of the abstract property 'other_context'");
            }
            case 1115786094: {
                return this.getHealth_care_facility();
            }
            case 170924882: {
                return this.addParticipations();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1573145462: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME"};
            }
            case 1725551537: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME"};
            }
            case 1901043637: {
                return new String[]{"string"};
            }
            case 1985941072: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case -1863234688: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
            case 1115786094: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-IDENTIFIED"};
            }
            case 170924882: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTICIPATION"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("start_time")) {
            this.start_time = new DV_DATE_TIME();
            return this.start_time;
        }
        if (name.equals("end_time")) {
            this.end_time = new DV_DATE_TIME();
            return this.end_time;
        }
        if (name.equals("location")) {
            throw new FHIRException("Cannot call addChild on a singleton property EVENT_CONTEXT.location");
        }
        if (name.equals("setting")) {
            this.setting = new DV_CODED_TEXT();
            return this.setting;
        }
        if (name.equals("other_context")) {
            throw new FHIRException("Cannot call addChild on an abstract type EVENT_CONTEXT.other_context");
        }
        if (name.equals("health_care_facility")) {
            this.health_care_facility = new PARTY_IDENTIFIED();
            return this.health_care_facility;
        }
        if (name.equals("participations")) {
            return this.addParticipations();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EVENT_CONTEXT";
    }

    @Override
    public EVENT_CONTEXT copy() {
        EVENT_CONTEXT dst = new EVENT_CONTEXT();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EVENT_CONTEXT dst) {
        super.copyValues(dst);
        dst.start_time = this.start_time == null ? null : this.start_time.copy();
        dst.end_time = this.end_time == null ? null : this.end_time.copy();
        dst.location = this.location == null ? null : this.location.copy();
        dst.setting = this.setting == null ? null : this.setting.copy();
        dst.other_context = this.other_context == null ? null : this.other_context.copy();
        PARTY_IDENTIFIED pARTY_IDENTIFIED = dst.health_care_facility = this.health_care_facility == null ? null : this.health_care_facility.copy();
        if (this.participationsList != null) {
            dst.participationsList = new ArrayList<PARTICIPATION>();
            for (PARTICIPATION i : this.participationsList) {
                dst.participationsList.add(i.copy());
            }
        }
    }

    protected EVENT_CONTEXT typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EVENT_CONTEXT)) {
            return false;
        }
        EVENT_CONTEXT o = (EVENT_CONTEXT)other_;
        return EVENT_CONTEXT.compareDeep(this.start_time, o.start_time, true) && EVENT_CONTEXT.compareDeep(this.end_time, o.end_time, true) && EVENT_CONTEXT.compareDeep(this.location, o.location, true) && EVENT_CONTEXT.compareDeep(this.setting, o.setting, true) && EVENT_CONTEXT.compareDeep(this.other_context, o.other_context, true) && EVENT_CONTEXT.compareDeep(this.health_care_facility, o.health_care_facility, true) && EVENT_CONTEXT.compareDeep(this.participationsList, o.participationsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EVENT_CONTEXT)) {
            return false;
        }
        EVENT_CONTEXT o = (EVENT_CONTEXT)other_;
        return EVENT_CONTEXT.compareValues(this.location, o.location, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.start_time, this.end_time, this.location, this.setting, this.other_context, this.health_care_facility, this.participationsList});
    }
}

