/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DV_ENCAPSULATED;
import org.hl7.fhir.r5.openehr.DV_IDENTIFIER;
import org.hl7.fhir.r5.openehr.FEEDER_AUDIT_DETAILS;

@DatatypeDef(name="FEEDER_AUDIT")
public class FEEDER_AUDIT
extends LogicalBase
implements ICompositeType {
    @Child(name="originating_system_item_ids", type={DV_IDENTIFIER.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Identifiers used for the item in the originating system", formalDefinition="Identifiers used for the item in the originating system, e.g. filler and placer ids.")
    protected List<DV_IDENTIFIER> originating_system_item_idsList;
    @Child(name="feeder_system_item_ids", type={DV_IDENTIFIER.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Identifiers used for the item in the feeder system", formalDefinition="Identifiers used for the item in the feeder system, where the feeder system is distinct from the originating system.")
    protected List<DV_IDENTIFIER> feeder_system_item_idsList;
    @Child(name="original_content", type={DV_ENCAPSULATED.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional inline inclusion of or reference to original content corresponding to the openEHR content at this node", formalDefinition="Optional inline inclusion of or reference to original content corresponding to the openEHR content at this node. Typically a URI reference to a document or message in a persistent store associated with the EHR.")
    protected DV_ENCAPSULATED original_content;
    @Child(name="originating_system_audit", type={FEEDER_AUDIT_DETAILS.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Any audit information for the information item from the originating system", formalDefinition="Any audit information for the information item from the originating system.")
    protected FEEDER_AUDIT_DETAILS originating_system_audit;
    @Child(name="feeder_system_audit", type={FEEDER_AUDIT_DETAILS.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Any audit information for the information item from the feeder system", formalDefinition="Any audit information for the information item from the feeder system, if different from the originating system.")
    protected FEEDER_AUDIT_DETAILS feeder_system_audit;
    private static final long serialVersionUID = -345281835L;

    public FEEDER_AUDIT() {
    }

    public FEEDER_AUDIT(FEEDER_AUDIT_DETAILS originating_system_audit) {
        this.setOriginating_system_audit(originating_system_audit);
    }

    public List<DV_IDENTIFIER> getOriginating_system_item_idsList() {
        if (this.originating_system_item_idsList == null) {
            this.originating_system_item_idsList = new ArrayList<DV_IDENTIFIER>();
        }
        return this.originating_system_item_idsList;
    }

    public FEEDER_AUDIT setOriginating_system_item_idsList(List<DV_IDENTIFIER> theOriginating_system_item_ids) {
        this.originating_system_item_idsList = theOriginating_system_item_ids;
        return this;
    }

    public boolean hasOriginating_system_item_ids() {
        if (this.originating_system_item_idsList == null) {
            return false;
        }
        for (DV_IDENTIFIER item : this.originating_system_item_idsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DV_IDENTIFIER addOriginating_system_item_ids() {
        DV_IDENTIFIER t = new DV_IDENTIFIER();
        if (this.originating_system_item_idsList == null) {
            this.originating_system_item_idsList = new ArrayList<DV_IDENTIFIER>();
        }
        this.originating_system_item_idsList.add(t);
        return t;
    }

    public FEEDER_AUDIT addOriginating_system_item_ids(DV_IDENTIFIER t) {
        if (t == null) {
            return this;
        }
        if (this.originating_system_item_idsList == null) {
            this.originating_system_item_idsList = new ArrayList<DV_IDENTIFIER>();
        }
        this.originating_system_item_idsList.add(t);
        return this;
    }

    public DV_IDENTIFIER getOriginating_system_item_idsFirstRep() {
        if (this.getOriginating_system_item_idsList().isEmpty()) {
            this.addOriginating_system_item_ids();
        }
        return this.getOriginating_system_item_idsList().get(0);
    }

    public List<DV_IDENTIFIER> getFeeder_system_item_idsList() {
        if (this.feeder_system_item_idsList == null) {
            this.feeder_system_item_idsList = new ArrayList<DV_IDENTIFIER>();
        }
        return this.feeder_system_item_idsList;
    }

    public FEEDER_AUDIT setFeeder_system_item_idsList(List<DV_IDENTIFIER> theFeeder_system_item_ids) {
        this.feeder_system_item_idsList = theFeeder_system_item_ids;
        return this;
    }

    public boolean hasFeeder_system_item_ids() {
        if (this.feeder_system_item_idsList == null) {
            return false;
        }
        for (DV_IDENTIFIER item : this.feeder_system_item_idsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DV_IDENTIFIER addFeeder_system_item_ids() {
        DV_IDENTIFIER t = new DV_IDENTIFIER();
        if (this.feeder_system_item_idsList == null) {
            this.feeder_system_item_idsList = new ArrayList<DV_IDENTIFIER>();
        }
        this.feeder_system_item_idsList.add(t);
        return t;
    }

    public FEEDER_AUDIT addFeeder_system_item_ids(DV_IDENTIFIER t) {
        if (t == null) {
            return this;
        }
        if (this.feeder_system_item_idsList == null) {
            this.feeder_system_item_idsList = new ArrayList<DV_IDENTIFIER>();
        }
        this.feeder_system_item_idsList.add(t);
        return this;
    }

    public DV_IDENTIFIER getFeeder_system_item_idsFirstRep() {
        if (this.getFeeder_system_item_idsList().isEmpty()) {
            this.addFeeder_system_item_ids();
        }
        return this.getFeeder_system_item_idsList().get(0);
    }

    public DV_ENCAPSULATED getOriginal_content() {
        return this.original_content;
    }

    public boolean hasOriginal_content() {
        return this.original_content != null && !this.original_content.isEmpty();
    }

    public FEEDER_AUDIT setOriginal_content(DV_ENCAPSULATED value) {
        this.original_content = value;
        return this;
    }

    public FEEDER_AUDIT_DETAILS getOriginating_system_audit() {
        if (this.originating_system_audit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FEEDER_AUDIT.originating_system_audit");
            }
            if (Configuration.doAutoCreate()) {
                this.originating_system_audit = new FEEDER_AUDIT_DETAILS();
            }
        }
        return this.originating_system_audit;
    }

    public boolean hasOriginating_system_audit() {
        return this.originating_system_audit != null && !this.originating_system_audit.isEmpty();
    }

    public FEEDER_AUDIT setOriginating_system_audit(FEEDER_AUDIT_DETAILS value) {
        this.originating_system_audit = value;
        return this;
    }

    public FEEDER_AUDIT_DETAILS getFeeder_system_audit() {
        if (this.feeder_system_audit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FEEDER_AUDIT.feeder_system_audit");
            }
            if (Configuration.doAutoCreate()) {
                this.feeder_system_audit = new FEEDER_AUDIT_DETAILS();
            }
        }
        return this.feeder_system_audit;
    }

    public boolean hasFeeder_system_audit() {
        return this.feeder_system_audit != null && !this.feeder_system_audit.isEmpty();
    }

    public FEEDER_AUDIT setFeeder_system_audit(FEEDER_AUDIT_DETAILS value) {
        this.feeder_system_audit = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("originating_system_item_ids", "http://openehr.org/fhir/StructureDefinition/DV-IDENTIFIER", "Identifiers used for the item in the originating system, e.g. filler and placer ids.", 0, Integer.MAX_VALUE, this.originating_system_item_idsList));
        children.add(new Property("feeder_system_item_ids", "http://openehr.org/fhir/StructureDefinition/DV-IDENTIFIER", "Identifiers used for the item in the feeder system, where the feeder system is distinct from the originating system.", 0, Integer.MAX_VALUE, this.feeder_system_item_idsList));
        children.add(new Property("original_content", "http://openehr.org/fhir/StructureDefinition/DV-ENCAPSULATED", "Optional inline inclusion of or reference to original content corresponding to the openEHR content at this node. Typically a URI reference to a document or message in a persistent store associated with the EHR.", 0, 1, this.original_content));
        children.add(new Property("originating_system_audit", "http://openehr.org/fhir/StructureDefinition/FEEDER-AUDIT-DETAILS", "Any audit information for the information item from the originating system.", 0, 1, this.originating_system_audit));
        children.add(new Property("feeder_system_audit", "http://openehr.org/fhir/StructureDefinition/FEEDER-AUDIT-DETAILS", "Any audit information for the information item from the feeder system, if different from the originating system.", 0, 1, this.feeder_system_audit));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 156875462: {
                return new Property("originating_system_item_ids", "http://openehr.org/fhir/StructureDefinition/DV-IDENTIFIER", "Identifiers used for the item in the originating system, e.g. filler and placer ids.", 0, Integer.MAX_VALUE, this.originating_system_item_idsList);
            }
            case 1194763816: {
                return new Property("feeder_system_item_ids", "http://openehr.org/fhir/StructureDefinition/DV-IDENTIFIER", "Identifiers used for the item in the feeder system, where the feeder system is distinct from the originating system.", 0, Integer.MAX_VALUE, this.feeder_system_item_idsList);
            }
            case 1891566603: {
                return new Property("original_content", "http://openehr.org/fhir/StructureDefinition/DV-ENCAPSULATED", "Optional inline inclusion of or reference to original content corresponding to the openEHR content at this node. Typically a URI reference to a document or message in a persistent store associated with the EHR.", 0, 1, this.original_content);
            }
            case 1684191969: {
                return new Property("originating_system_audit", "http://openehr.org/fhir/StructureDefinition/FEEDER-AUDIT-DETAILS", "Any audit information for the information item from the originating system.", 0, 1, this.originating_system_audit);
            }
            case -455976257: {
                return new Property("feeder_system_audit", "http://openehr.org/fhir/StructureDefinition/FEEDER-AUDIT-DETAILS", "Any audit information for the information item from the feeder system, if different from the originating system.", 0, 1, this.feeder_system_audit);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 156875462: {
                return this.originating_system_item_idsList == null ? new Base[]{} : this.originating_system_item_idsList.toArray(new Base[this.originating_system_item_idsList.size()]);
            }
            case 1194763816: {
                return this.feeder_system_item_idsList == null ? new Base[]{} : this.feeder_system_item_idsList.toArray(new Base[this.feeder_system_item_idsList.size()]);
            }
            case 1891566603: {
                Base[] baseArray;
                if (this.original_content == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.original_content;
                }
                return baseArray;
            }
            case 1684191969: {
                Base[] baseArray;
                if (this.originating_system_audit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.originating_system_audit;
                }
                return baseArray;
            }
            case -455976257: {
                Base[] baseArray;
                if (this.feeder_system_audit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.feeder_system_audit;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 156875462: {
                this.getOriginating_system_item_idsList().add((DV_IDENTIFIER)value);
                return value;
            }
            case 1194763816: {
                this.getFeeder_system_item_idsList().add((DV_IDENTIFIER)value);
                return value;
            }
            case 1891566603: {
                this.original_content = (DV_ENCAPSULATED)value;
                return value;
            }
            case 1684191969: {
                this.originating_system_audit = (FEEDER_AUDIT_DETAILS)value;
                return value;
            }
            case -455976257: {
                this.feeder_system_audit = (FEEDER_AUDIT_DETAILS)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("originating_system_item_ids")) {
            this.getOriginating_system_item_idsList().add((DV_IDENTIFIER)value);
        } else if (name.equals("feeder_system_item_ids")) {
            this.getFeeder_system_item_idsList().add((DV_IDENTIFIER)value);
        } else if (name.equals("original_content")) {
            this.original_content = (DV_ENCAPSULATED)value;
        } else if (name.equals("originating_system_audit")) {
            this.originating_system_audit = (FEEDER_AUDIT_DETAILS)value;
        } else if (name.equals("feeder_system_audit")) {
            this.feeder_system_audit = (FEEDER_AUDIT_DETAILS)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 156875462: {
                return this.addOriginating_system_item_ids();
            }
            case 1194763816: {
                return this.addFeeder_system_item_ids();
            }
            case 1891566603: {
                throw new Error("Unable to make an instance of the abstract property 'original_content'");
            }
            case 1684191969: {
                return this.getOriginating_system_audit();
            }
            case -455976257: {
                return this.getFeeder_system_audit();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 156875462: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-IDENTIFIER"};
            }
            case 1194763816: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-IDENTIFIER"};
            }
            case 1891566603: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-ENCAPSULATED"};
            }
            case 1684191969: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/FEEDER-AUDIT-DETAILS"};
            }
            case -455976257: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/FEEDER-AUDIT-DETAILS"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("originating_system_item_ids")) {
            return this.addOriginating_system_item_ids();
        }
        if (name.equals("feeder_system_item_ids")) {
            return this.addFeeder_system_item_ids();
        }
        if (name.equals("original_content")) {
            throw new FHIRException("Cannot call addChild on an abstract type FEEDER_AUDIT.original_content");
        }
        if (name.equals("originating_system_audit")) {
            this.originating_system_audit = new FEEDER_AUDIT_DETAILS();
            return this.originating_system_audit;
        }
        if (name.equals("feeder_system_audit")) {
            this.feeder_system_audit = new FEEDER_AUDIT_DETAILS();
            return this.feeder_system_audit;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "FEEDER_AUDIT";
    }

    @Override
    public FEEDER_AUDIT copy() {
        FEEDER_AUDIT dst = new FEEDER_AUDIT();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(FEEDER_AUDIT dst) {
        super.copyValues(dst);
        if (this.originating_system_item_idsList != null) {
            dst.originating_system_item_idsList = new ArrayList<DV_IDENTIFIER>();
            for (DV_IDENTIFIER i : this.originating_system_item_idsList) {
                dst.originating_system_item_idsList.add(i.copy());
            }
        }
        if (this.feeder_system_item_idsList != null) {
            dst.feeder_system_item_idsList = new ArrayList<DV_IDENTIFIER>();
            for (DV_IDENTIFIER i : this.feeder_system_item_idsList) {
                dst.feeder_system_item_idsList.add(i.copy());
            }
        }
        dst.original_content = this.original_content == null ? null : this.original_content.copy();
        dst.originating_system_audit = this.originating_system_audit == null ? null : this.originating_system_audit.copy();
        dst.feeder_system_audit = this.feeder_system_audit == null ? null : this.feeder_system_audit.copy();
    }

    protected FEEDER_AUDIT typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof FEEDER_AUDIT)) {
            return false;
        }
        FEEDER_AUDIT o = (FEEDER_AUDIT)other_;
        return FEEDER_AUDIT.compareDeep(this.originating_system_item_idsList, o.originating_system_item_idsList, true) && FEEDER_AUDIT.compareDeep(this.feeder_system_item_idsList, o.feeder_system_item_idsList, true) && FEEDER_AUDIT.compareDeep(this.original_content, o.original_content, true) && FEEDER_AUDIT.compareDeep(this.originating_system_audit, o.originating_system_audit, true) && FEEDER_AUDIT.compareDeep(this.feeder_system_audit, o.feeder_system_audit, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof FEEDER_AUDIT)) {
            return false;
        }
        FEEDER_AUDIT o = (FEEDER_AUDIT)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.originating_system_item_idsList, this.feeder_system_item_idsList, this.original_content, this.originating_system_audit, this.feeder_system_audit});
    }
}

