/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.ELEMENT;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;

@DatatypeDef(name="ITEM_LIST")
public class ITEM_LIST
extends ITEM_STRUCTURE
implements ICompositeType {
    @Child(name="items", type={ELEMENT.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Physical representation of the list", formalDefinition="Physical representation of the list.")
    protected List<ELEMENT> itemsList;
    private static final long serialVersionUID = 42602380L;

    public List<ELEMENT> getItemsList() {
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<ELEMENT>();
        }
        return this.itemsList;
    }

    public ITEM_LIST setItemsList(List<ELEMENT> theItems) {
        this.itemsList = theItems;
        return this;
    }

    public boolean hasItems() {
        if (this.itemsList == null) {
            return false;
        }
        for (ELEMENT item : this.itemsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ELEMENT addItems() {
        ELEMENT t = new ELEMENT();
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<ELEMENT>();
        }
        this.itemsList.add(t);
        return t;
    }

    public ITEM_LIST addItems(ELEMENT t) {
        if (t == null) {
            return this;
        }
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<ELEMENT>();
        }
        this.itemsList.add(t);
        return this;
    }

    public ELEMENT getItemsFirstRep() {
        if (this.getItemsList().isEmpty()) {
            this.addItems();
        }
        return this.getItemsList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("items", "http://openehr.org/fhir/StructureDefinition/ELEMENT", "Physical representation of the list.", 0, Integer.MAX_VALUE, this.itemsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 100526016: {
                return new Property("items", "http://openehr.org/fhir/StructureDefinition/ELEMENT", "Physical representation of the list.", 0, Integer.MAX_VALUE, this.itemsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return this.itemsList == null ? new Base[]{} : this.itemsList.toArray(new Base[this.itemsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 100526016: {
                this.getItemsList().add((ELEMENT)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("items")) {
            return super.setProperty(name, value);
        }
        this.getItemsList().add((ELEMENT)value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return this.addItems();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ELEMENT"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("items")) {
            return this.addItems();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ITEM_LIST";
    }

    @Override
    public ITEM_LIST copy() {
        ITEM_LIST dst = new ITEM_LIST();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ITEM_LIST dst) {
        super.copyValues(dst);
        if (this.itemsList != null) {
            dst.itemsList = new ArrayList<ELEMENT>();
            for (ELEMENT i : this.itemsList) {
                dst.itemsList.add(i.copy());
            }
        }
    }

    protected ITEM_LIST typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ITEM_LIST)) {
            return false;
        }
        ITEM_LIST o = (ITEM_LIST)other_;
        return ITEM_LIST.compareDeep(this.itemsList, o.itemsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ITEM_LIST)) {
            return false;
        }
        ITEM_LIST o = (ITEM_LIST)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.itemsList);
    }
}

