/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.CLUSTER;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;

@DatatypeDef(name="ITEM_TABLE")
public class ITEM_TABLE
extends ITEM_STRUCTURE
implements ICompositeType {
    @Child(name="rows", type={CLUSTER.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Physical representation of the table as a list of CLUSTERs, each containing the data of one row of the table", formalDefinition="Physical representation of the table as a list of CLUSTERs, each containing the data of one row of the table.")
    protected List<CLUSTER> rowsList;
    private static final long serialVersionUID = 514606961L;

    public List<CLUSTER> getRowsList() {
        if (this.rowsList == null) {
            this.rowsList = new ArrayList<CLUSTER>();
        }
        return this.rowsList;
    }

    public ITEM_TABLE setRowsList(List<CLUSTER> theRows) {
        this.rowsList = theRows;
        return this;
    }

    public boolean hasRows() {
        if (this.rowsList == null) {
            return false;
        }
        for (CLUSTER item : this.rowsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CLUSTER addRows() {
        CLUSTER t = new CLUSTER();
        if (this.rowsList == null) {
            this.rowsList = new ArrayList<CLUSTER>();
        }
        this.rowsList.add(t);
        return t;
    }

    public ITEM_TABLE addRows(CLUSTER t) {
        if (t == null) {
            return this;
        }
        if (this.rowsList == null) {
            this.rowsList = new ArrayList<CLUSTER>();
        }
        this.rowsList.add(t);
        return this;
    }

    public CLUSTER getRowsFirstRep() {
        if (this.getRowsList().isEmpty()) {
            this.addRows();
        }
        return this.getRowsList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("rows", "http://openehr.org/fhir/StructureDefinition/CLUSTER", "Physical representation of the table as a list of CLUSTERs, each containing the data of one row of the table.", 0, Integer.MAX_VALUE, this.rowsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3506649: {
                return new Property("rows", "http://openehr.org/fhir/StructureDefinition/CLUSTER", "Physical representation of the table as a list of CLUSTERs, each containing the data of one row of the table.", 0, Integer.MAX_VALUE, this.rowsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3506649: {
                return this.rowsList == null ? new Base[]{} : this.rowsList.toArray(new Base[this.rowsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3506649: {
                this.getRowsList().add((CLUSTER)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("rows")) {
            return super.setProperty(name, value);
        }
        this.getRowsList().add((CLUSTER)value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3506649: {
                return this.addRows();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3506649: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CLUSTER"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("rows")) {
            return this.addRows();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ITEM_TABLE";
    }

    @Override
    public ITEM_TABLE copy() {
        ITEM_TABLE dst = new ITEM_TABLE();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ITEM_TABLE dst) {
        super.copyValues(dst);
        if (this.rowsList != null) {
            dst.rowsList = new ArrayList<CLUSTER>();
            for (CLUSTER i : this.rowsList) {
                dst.rowsList.add(i.copy());
            }
        }
    }

    protected ITEM_TABLE typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ITEM_TABLE)) {
            return false;
        }
        ITEM_TABLE o = (ITEM_TABLE)other_;
        return ITEM_TABLE.compareDeep(this.rowsList, o.rowsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ITEM_TABLE)) {
            return false;
        }
        ITEM_TABLE o = (ITEM_TABLE)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.rowsList);
    }
}

