/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.OBJECT_REF;
import org.hl7.fhir.r5.openehr.UID_BASED_ID;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="ITEM_TAG")
public class ITEM_TAG
extends LogicalBase
implements ICompositeType {
    @Child(name="key", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The tag key. May not be empty or contain leading or trailing whitespace", formalDefinition="The tag key. May not be empty or contain leading or trailing whitespace.")
    protected StringType key;
    @Child(name="value", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The value. If set, may not be empty", formalDefinition="The value. If set, may not be empty.")
    protected StringType value;
    @Child(name="target", type={UID_BASED_ID.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Identifier of target, which may be a VERSIONED_OBJECT<T> or a VERSION<T>", formalDefinition="Identifier of target, which may be a VERSIONED_OBJECT<T> or a VERSION<T>.")
    protected UID_BASED_ID target;
    @Child(name="target_path", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional archetype (i.e. AQL) or RM path within target, used to tag a fine-grained element", formalDefinition="Optional archetype (i.e. AQL) or RM path within target, used to tag a fine-grained element.")
    protected StringType target_path;
    @Child(name="owner_id", type={OBJECT_REF.class}, order=4, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Identifier of owner object, such as EHR", formalDefinition="Identifier of owner object, such as EHR.")
    protected OBJECT_REF owner_id;
    private static final long serialVersionUID = -1845987839L;

    public ITEM_TAG() {
    }

    public ITEM_TAG(String key, UID_BASED_ID target, OBJECT_REF owner_id) {
        this.setKey(key);
        this.setTarget(target);
        this.setOwner_id(owner_id);
    }

    public StringType getKeyElement() {
        if (this.key == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ITEM_TAG.key");
            }
            if (Configuration.doAutoCreate()) {
                this.key = new StringType();
            }
        }
        return this.key;
    }

    public boolean hasKeyElement() {
        return this.key != null && !this.key.isEmpty();
    }

    public boolean hasKey() {
        return this.key != null && !this.key.isEmpty();
    }

    public ITEM_TAG setKeyElement(StringType value) {
        this.key = value;
        return this;
    }

    public String getKey() {
        return this.key == null ? null : (String)this.key.getValue();
    }

    public ITEM_TAG setKey(String value) {
        if (this.key == null) {
            this.key = new StringType();
        }
        this.key.setValue(value);
        return this;
    }

    public StringType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ITEM_TAG.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new StringType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public ITEM_TAG setValueElement(StringType value) {
        this.value = value;
        return this;
    }

    public String getValue() {
        return this.value == null ? null : (String)this.value.getValue();
    }

    public ITEM_TAG setValue(String value) {
        if (Utilities.noString((String)value)) {
            this.value = null;
        } else {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
        }
        return this;
    }

    public UID_BASED_ID getTarget() {
        return this.target;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public ITEM_TAG setTarget(UID_BASED_ID value) {
        this.target = value;
        return this;
    }

    public StringType getTarget_pathElement() {
        if (this.target_path == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ITEM_TAG.target_path");
            }
            if (Configuration.doAutoCreate()) {
                this.target_path = new StringType();
            }
        }
        return this.target_path;
    }

    public boolean hasTarget_pathElement() {
        return this.target_path != null && !this.target_path.isEmpty();
    }

    public boolean hasTarget_path() {
        return this.target_path != null && !this.target_path.isEmpty();
    }

    public ITEM_TAG setTarget_pathElement(StringType value) {
        this.target_path = value;
        return this;
    }

    public String getTarget_path() {
        return this.target_path == null ? null : (String)this.target_path.getValue();
    }

    public ITEM_TAG setTarget_path(String value) {
        if (Utilities.noString((String)value)) {
            this.target_path = null;
        } else {
            if (this.target_path == null) {
                this.target_path = new StringType();
            }
            this.target_path.setValue(value);
        }
        return this;
    }

    public OBJECT_REF getOwner_id() {
        if (this.owner_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ITEM_TAG.owner_id");
            }
            if (Configuration.doAutoCreate()) {
                this.owner_id = new OBJECT_REF();
            }
        }
        return this.owner_id;
    }

    public boolean hasOwner_id() {
        return this.owner_id != null && !this.owner_id.isEmpty();
    }

    public ITEM_TAG setOwner_id(OBJECT_REF value) {
        this.owner_id = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("key", "string", "The tag key. May not be empty or contain leading or trailing whitespace.", 0, 1, this.key));
        children.add(new Property("value", "string", "The value. If set, may not be empty.", 0, 1, this.value));
        children.add(new Property("target", "http://openehr.org/fhir/StructureDefinition/UID-BASED-ID", "Identifier of target, which may be a VERSIONED_OBJECT<T> or a VERSION<T>.", 0, 1, this.target));
        children.add(new Property("target_path", "string", "Optional archetype (i.e. AQL) or RM path within target, used to tag a fine-grained element.", 0, 1, this.target_path));
        children.add(new Property("owner_id", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Identifier of owner object, such as EHR.", 0, 1, this.owner_id));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 106079: {
                return new Property("key", "string", "The tag key. May not be empty or contain leading or trailing whitespace.", 0, 1, this.key);
            }
            case 111972721: {
                return new Property("value", "string", "The value. If set, may not be empty.", 0, 1, this.value);
            }
            case -880905839: {
                return new Property("target", "http://openehr.org/fhir/StructureDefinition/UID-BASED-ID", "Identifier of target, which may be a VERSIONED_OBJECT<T> or a VERSION<T>.", 0, 1, this.target);
            }
            case -2084700653: {
                return new Property("target_path", "string", "Optional archetype (i.e. AQL) or RM path within target, used to tag a fine-grained element.", 0, 1, this.target_path);
            }
            case 1663147559: {
                return new Property("owner_id", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Identifier of owner object, such as EHR.", 0, 1, this.owner_id);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 106079: {
                Base[] baseArray;
                if (this.key == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.key;
                }
                return baseArray;
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.value;
                }
                return baseArray;
            }
            case -880905839: {
                Base[] baseArray;
                if (this.target == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.target;
                }
                return baseArray;
            }
            case -2084700653: {
                Base[] baseArray;
                if (this.target_path == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.target_path;
                }
                return baseArray;
            }
            case 1663147559: {
                Base[] baseArray;
                if (this.owner_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.owner_id;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 106079: {
                this.key = TypeConvertor.castToString(value);
                return value;
            }
            case 111972721: {
                this.value = TypeConvertor.castToString(value);
                return value;
            }
            case -880905839: {
                this.target = (UID_BASED_ID)value;
                return value;
            }
            case -2084700653: {
                this.target_path = TypeConvertor.castToString(value);
                return value;
            }
            case 1663147559: {
                this.owner_id = (OBJECT_REF)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("key")) {
            this.key = TypeConvertor.castToString(value);
        } else if (name.equals("value")) {
            this.value = TypeConvertor.castToString(value);
        } else if (name.equals("target")) {
            this.target = (UID_BASED_ID)value;
        } else if (name.equals("target_path")) {
            this.target_path = TypeConvertor.castToString(value);
        } else if (name.equals("owner_id")) {
            this.owner_id = (OBJECT_REF)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 106079: {
                return this.getKeyElement();
            }
            case 111972721: {
                return this.getValueElement();
            }
            case -880905839: {
                throw new Error("Unable to make an instance of the abstract property 'target'");
            }
            case -2084700653: {
                return this.getTarget_pathElement();
            }
            case 1663147559: {
                return this.getOwner_id();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 106079: {
                return new String[]{"string"};
            }
            case 111972721: {
                return new String[]{"string"};
            }
            case -880905839: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/UID-BASED-ID"};
            }
            case -2084700653: {
                return new String[]{"string"};
            }
            case 1663147559: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("key")) {
            throw new FHIRException("Cannot call addChild on a singleton property ITEM_TAG.key");
        }
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property ITEM_TAG.value");
        }
        if (name.equals("target")) {
            throw new FHIRException("Cannot call addChild on an abstract type ITEM_TAG.target");
        }
        if (name.equals("target_path")) {
            throw new FHIRException("Cannot call addChild on a singleton property ITEM_TAG.target_path");
        }
        if (name.equals("owner_id")) {
            this.owner_id = new OBJECT_REF();
            return this.owner_id;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ITEM_TAG";
    }

    @Override
    public ITEM_TAG copy() {
        ITEM_TAG dst = new ITEM_TAG();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ITEM_TAG dst) {
        super.copyValues(dst);
        dst.key = this.key == null ? null : this.key.copy();
        dst.value = this.value == null ? null : this.value.copy();
        dst.target = this.target == null ? null : this.target.copy();
        dst.target_path = this.target_path == null ? null : this.target_path.copy();
        dst.owner_id = this.owner_id == null ? null : this.owner_id.copy();
    }

    protected ITEM_TAG typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ITEM_TAG)) {
            return false;
        }
        ITEM_TAG o = (ITEM_TAG)other_;
        return ITEM_TAG.compareDeep(this.key, o.key, true) && ITEM_TAG.compareDeep(this.value, o.value, true) && ITEM_TAG.compareDeep(this.target, o.target, true) && ITEM_TAG.compareDeep(this.target_path, o.target_path, true) && ITEM_TAG.compareDeep(this.owner_id, o.owner_id, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ITEM_TAG)) {
            return false;
        }
        ITEM_TAG o = (ITEM_TAG)other_;
        return ITEM_TAG.compareValues(this.key, o.key, true) && ITEM_TAG.compareValues(this.value, o.value, true) && ITEM_TAG.compareValues(this.target_path, o.target_path, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.key, this.value, this.target, this.target_path, this.owner_id});
    }
}

