/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.CARE_ENTRY;
import org.hl7.fhir.r5.openehr.HISTORY;

@DatatypeDef(name="OBSERVATION")
public class OBSERVATION
extends CARE_ENTRY
implements ICompositeType {
    @Child(name="data", type={HISTORY.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The data of this observation, in the form of a history of values which may be of any complexity", formalDefinition="The data of this observation, in the form of a history of values which may be of any complexity.")
    protected HISTORY data;
    @Child(name="state", type={HISTORY.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional recording of the state of subject of this observation during the observation process", formalDefinition="Optional recording of the state of subject of this observation during the observation process, in the form of a separate history of values which may be of any complexity. State may also be recorded within the History of the data attribute.")
    protected HISTORY state;
    private static final long serialVersionUID = -787276715L;

    public OBSERVATION() {
    }

    public OBSERVATION(HISTORY data) {
        this.setData(data);
    }

    public HISTORY getData() {
        if (this.data == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OBSERVATION.data");
            }
            if (Configuration.doAutoCreate()) {
                this.data = new HISTORY();
            }
        }
        return this.data;
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public OBSERVATION setData(HISTORY value) {
        this.data = value;
        return this;
    }

    public HISTORY getState() {
        if (this.state == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OBSERVATION.state");
            }
            if (Configuration.doAutoCreate()) {
                this.state = new HISTORY();
            }
        }
        return this.state;
    }

    public boolean hasState() {
        return this.state != null && !this.state.isEmpty();
    }

    public OBSERVATION setState(HISTORY value) {
        this.state = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("data", "http://openehr.org/fhir/StructureDefinition/HISTORY", "The data of this observation, in the form of a history of values which may be of any complexity.", 0, 1, this.data));
        children.add(new Property("state", "http://openehr.org/fhir/StructureDefinition/HISTORY", "Optional recording of the state of subject of this observation during the observation process, in the form of a separate history of values which may be of any complexity. State may also be recorded within the History of the data attribute.", 0, 1, this.state));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3076010: {
                return new Property("data", "http://openehr.org/fhir/StructureDefinition/HISTORY", "The data of this observation, in the form of a history of values which may be of any complexity.", 0, 1, this.data);
            }
            case 109757585: {
                return new Property("state", "http://openehr.org/fhir/StructureDefinition/HISTORY", "Optional recording of the state of subject of this observation during the observation process, in the form of a separate history of values which may be of any complexity. State may also be recorded within the History of the data attribute.", 0, 1, this.state);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3076010: {
                Base[] baseArray;
                if (this.data == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.data;
                }
                return baseArray;
            }
            case 109757585: {
                Base[] baseArray;
                if (this.state == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.state;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3076010: {
                this.data = (HISTORY)value;
                return value;
            }
            case 109757585: {
                this.state = (HISTORY)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("data")) {
            this.data = (HISTORY)value;
        } else if (name.equals("state")) {
            this.state = (HISTORY)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3076010: {
                return this.getData();
            }
            case 109757585: {
                return this.getState();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3076010: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/HISTORY"};
            }
            case 109757585: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/HISTORY"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("data")) {
            this.data = new HISTORY();
            return this.data;
        }
        if (name.equals("state")) {
            this.state = new HISTORY();
            return this.state;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "OBSERVATION";
    }

    @Override
    public OBSERVATION copy() {
        OBSERVATION dst = new OBSERVATION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(OBSERVATION dst) {
        super.copyValues(dst);
        dst.data = this.data == null ? null : this.data.copy();
        dst.state = this.state == null ? null : this.state.copy();
    }

    protected OBSERVATION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof OBSERVATION)) {
            return false;
        }
        OBSERVATION o = (OBSERVATION)other_;
        return OBSERVATION.compareDeep(this.data, o.data, true) && OBSERVATION.compareDeep(this.state, o.state, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof OBSERVATION)) {
            return false;
        }
        OBSERVATION o = (OBSERVATION)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.data, this.state});
    }
}

