/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.openehr.ACCESS_CONTROL_SETTINGS;
import org.hl7.fhir.r5.openehr.ACTION;
import org.hl7.fhir.r5.openehr.ACTIVITY;
import org.hl7.fhir.r5.openehr.ACTOR;
import org.hl7.fhir.r5.openehr.ADDRESS;
import org.hl7.fhir.r5.openehr.ADMIN_ENTRY;
import org.hl7.fhir.r5.openehr.AGENT;
import org.hl7.fhir.r5.openehr.ARCHETYPED;
import org.hl7.fhir.r5.openehr.ARCHETYPE_ID;
import org.hl7.fhir.r5.openehr.ATTESTATION;
import org.hl7.fhir.r5.openehr.AUDIT_DETAILS;
import org.hl7.fhir.r5.openehr.AUTHORED_RESOURCE;
import org.hl7.fhir.r5.openehr.Annotations;
import org.hl7.fhir.r5.openehr.Any;
import org.hl7.fhir.r5.openehr.CAPABILITY;
import org.hl7.fhir.r5.openehr.CARE_ENTRY;
import org.hl7.fhir.r5.openehr.CLUSTER;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;
import org.hl7.fhir.r5.openehr.COMPOSITION;
import org.hl7.fhir.r5.openehr.CONTACT;
import org.hl7.fhir.r5.openehr.CONTENT_ITEM;
import org.hl7.fhir.r5.openehr.CONTRIBUTION;
import org.hl7.fhir.r5.openehr.DATA_STRUCTURE;
import org.hl7.fhir.r5.openehr.DATA_VALUE;
import org.hl7.fhir.r5.openehr.DV_ABSOLUTE_QUANTITY;
import org.hl7.fhir.r5.openehr.DV_AMOUNT;
import org.hl7.fhir.r5.openehr.DV_BOOLEAN;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.DV_COUNT;
import org.hl7.fhir.r5.openehr.DV_DATE;
import org.hl7.fhir.r5.openehr.DV_DATE_TIME;
import org.hl7.fhir.r5.openehr.DV_DURATION;
import org.hl7.fhir.r5.openehr.DV_EHR_URI;
import org.hl7.fhir.r5.openehr.DV_ENCAPSULATED;
import org.hl7.fhir.r5.openehr.DV_GENERAL_TIME_SPECIFICATION;
import org.hl7.fhir.r5.openehr.DV_IDENTIFIER;
import org.hl7.fhir.r5.openehr.DV_INTERVAL;
import org.hl7.fhir.r5.openehr.DV_MULTIMEDIA;
import org.hl7.fhir.r5.openehr.DV_ORDERED;
import org.hl7.fhir.r5.openehr.DV_ORDINAL;
import org.hl7.fhir.r5.openehr.DV_PARAGRAPH;
import org.hl7.fhir.r5.openehr.DV_PARSABLE;
import org.hl7.fhir.r5.openehr.DV_PERIODIC_TIME_SPECIFICATION;
import org.hl7.fhir.r5.openehr.DV_PROPORTION;
import org.hl7.fhir.r5.openehr.DV_QUANTIFIED;
import org.hl7.fhir.r5.openehr.DV_QUANTITY;
import org.hl7.fhir.r5.openehr.DV_SCALE;
import org.hl7.fhir.r5.openehr.DV_STATE;
import org.hl7.fhir.r5.openehr.DV_TEMPORAL;
import org.hl7.fhir.r5.openehr.DV_TEXT;
import org.hl7.fhir.r5.openehr.DV_TIME;
import org.hl7.fhir.r5.openehr.DV_TIME_SPECIFICATION;
import org.hl7.fhir.r5.openehr.DV_URI;
import org.hl7.fhir.r5.openehr.EHR;
import org.hl7.fhir.r5.openehr.EHR_ACCESS;
import org.hl7.fhir.r5.openehr.EHR_STATUS;
import org.hl7.fhir.r5.openehr.ELEMENT;
import org.hl7.fhir.r5.openehr.ENTRY;
import org.hl7.fhir.r5.openehr.EVALUATION;
import org.hl7.fhir.r5.openehr.EVENT;
import org.hl7.fhir.r5.openehr.EVENT_CONTEXT;
import org.hl7.fhir.r5.openehr.FEEDER_AUDIT;
import org.hl7.fhir.r5.openehr.FEEDER_AUDIT_DETAILS;
import org.hl7.fhir.r5.openehr.FOLDER;
import org.hl7.fhir.r5.openehr.GENERIC_ID;
import org.hl7.fhir.r5.openehr.GROUP;
import org.hl7.fhir.r5.openehr.HIER_OBJECT_ID;
import org.hl7.fhir.r5.openehr.HISTORY;
import org.hl7.fhir.r5.openehr.IMPORTED_VERSION;
import org.hl7.fhir.r5.openehr.INSTRUCTION;
import org.hl7.fhir.r5.openehr.INSTRUCTION_DETAILS;
import org.hl7.fhir.r5.openehr.INTERNET_ID;
import org.hl7.fhir.r5.openehr.INTERVAL_EVENT;
import org.hl7.fhir.r5.openehr.ISM_TRANSITION;
import org.hl7.fhir.r5.openehr.ISO_OID;
import org.hl7.fhir.r5.openehr.ITEM;
import org.hl7.fhir.r5.openehr.ITEM_LIST;
import org.hl7.fhir.r5.openehr.ITEM_SINGLE;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.ITEM_TABLE;
import org.hl7.fhir.r5.openehr.ITEM_TAG;
import org.hl7.fhir.r5.openehr.ITEM_TREE;
import org.hl7.fhir.r5.openehr.LINK;
import org.hl7.fhir.r5.openehr.LOCATABLE;
import org.hl7.fhir.r5.openehr.LOCATABLE_REF;
import org.hl7.fhir.r5.openehr.OBJECT_ID;
import org.hl7.fhir.r5.openehr.OBJECT_REF;
import org.hl7.fhir.r5.openehr.OBJECT_VERSION_ID;
import org.hl7.fhir.r5.openehr.OBSERVATION;
import org.hl7.fhir.r5.openehr.ORGANISATION;
import org.hl7.fhir.r5.openehr.ORIGINAL_VERSION;
import org.hl7.fhir.r5.openehr.PARTICIPATION;
import org.hl7.fhir.r5.openehr.PARTY;
import org.hl7.fhir.r5.openehr.PARTY_IDENTIFIED;
import org.hl7.fhir.r5.openehr.PARTY_IDENTITY;
import org.hl7.fhir.r5.openehr.PARTY_PROXY;
import org.hl7.fhir.r5.openehr.PARTY_REF;
import org.hl7.fhir.r5.openehr.PARTY_RELATED;
import org.hl7.fhir.r5.openehr.PARTY_RELATIONSHIP;
import org.hl7.fhir.r5.openehr.PARTY_SELF;
import org.hl7.fhir.r5.openehr.PATHABLE;
import org.hl7.fhir.r5.openehr.PERSON;
import org.hl7.fhir.r5.openehr.POINT_EVENT;
import org.hl7.fhir.r5.openehr.REFERENCE_RANGE;
import org.hl7.fhir.r5.openehr.RESOURCE_DESCRIPTION;
import org.hl7.fhir.r5.openehr.RESOURCE_DESCRIPTION_ITEM;
import org.hl7.fhir.r5.openehr.REVISION_HISTORY;
import org.hl7.fhir.r5.openehr.REVISION_HISTORY_ITEM;
import org.hl7.fhir.r5.openehr.ROLE;
import org.hl7.fhir.r5.openehr.SECTION;
import org.hl7.fhir.r5.openehr.TEMPLATE_ID;
import org.hl7.fhir.r5.openehr.TERMINOLOGY_ID;
import org.hl7.fhir.r5.openehr.TERM_MAPPING;
import org.hl7.fhir.r5.openehr.TRANSLATION_DETAILS;
import org.hl7.fhir.r5.openehr.TranslatedString;
import org.hl7.fhir.r5.openehr.UID;
import org.hl7.fhir.r5.openehr.UID_BASED_ID;
import org.hl7.fhir.r5.openehr.UUID;
import org.hl7.fhir.r5.openehr.VERSION;
import org.hl7.fhir.r5.openehr.VERSIONED_COMPOSITION;
import org.hl7.fhir.r5.openehr.VERSIONED_EHR_ACCESS;
import org.hl7.fhir.r5.openehr.VERSIONED_EHR_STATUS;
import org.hl7.fhir.r5.openehr.VERSIONED_FOLDER;
import org.hl7.fhir.r5.openehr.VERSIONED_OBJECT;
import org.hl7.fhir.r5.openehr.VERSIONED_PARTY;
import org.hl7.fhir.r5.openehr.VERSION_TREE_ID;
import org.hl7.fhir.r5.openehr.WebTemplate;
import org.hl7.fhir.r5.openehr.WebTemplateInput;
import org.hl7.fhir.r5.openehr.WebTemplateInputListItem;
import org.hl7.fhir.r5.openehr.WebTemplateInputValidation;
import org.hl7.fhir.r5.openehr.WebTemplateInputValidationRange;
import org.hl7.fhir.r5.openehr.WebTemplateItem;
import org.hl7.fhir.r5.openehr.WebTemplateTermBinding;
import org.hl7.fhir.r5.openehr.WebTemplateTermBindingValue;
import org.hl7.fhir.utilities.xml.IXMLWriter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class OpenehrXmlParser
extends XmlParser {
    public OpenehrXmlParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    public OpenehrXmlParser(IXMLWriter xml) {
        this.xml = xml;
    }

    protected ACCESS_CONTROL_SETTINGS parseACCESS_CONTROL_SETTINGS(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            default: 
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseACCESS_CONTROL_SETTINGSContent(int eventType, XmlPullParser xpp, ACCESS_CONTROL_SETTINGS res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseBaseContent(eventType, xpp, res);
    }

    protected ACTOR parseACTOR(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "AGENT": {
                return this.parseAGENT(xpp);
            }
            case "GROUP": {
                return this.parseGROUP(xpp);
            }
            case "PERSON": {
                return this.parsePERSON(xpp);
            }
            case "ORGANISATION": {
                return this.parseORGANISATION(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseACTORContent(int eventType, XmlPullParser xpp, ACTOR res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("languages")) {
            res.getLanguagesList().add(this.parseDV_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("roles")) {
            res.getRolesList().add(this.parsePARTY_REF(xpp));
        } else if (!this.parsePARTYContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AUTHORED_RESOURCE parseAUTHORED_RESOURCE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            default: 
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseAUTHORED_RESOURCEContent(int eventType, XmlPullParser xpp, AUTHORED_RESOURCE res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("original_language")) {
            res.setOriginal_language(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("is_controlled")) {
            res.setIs_controlledElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("translations")) {
            res.getTranslationsList().add(this.parseTRANSLATION_DETAILS(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescription(this.parseRESOURCE_DESCRIPTION(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revision_history")) {
            res.setRevision_history(this.parseREVISION_HISTORY(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Any parseAny(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "EHR": {
                return this.parseEHR(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseAnyContent(int eventType, XmlPullParser xpp, Any res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseBaseContent(eventType, xpp, res);
    }

    protected CARE_ENTRY parseCARE_ENTRY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "INSTRUCTION": {
                return this.parseINSTRUCTION(xpp);
            }
            case "OBSERVATION": {
                return this.parseOBSERVATION(xpp);
            }
            case "ACTION": {
                return this.parseACTION(xpp);
            }
            case "EVALUATION": {
                return this.parseEVALUATION(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseCARE_ENTRYContent(int eventType, XmlPullParser xpp, CARE_ENTRY res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("protocol")) {
            res.setProtocol(this.parseITEM_STRUCTURE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("guideline_id")) {
            res.setGuideline_id(this.parseOBJECT_REF(xpp));
        } else if (!this.parseENTRYContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CONTENT_ITEM parseCONTENT_ITEM(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "SECTION": {
                return this.parseSECTION(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseCONTENT_ITEMContent(int eventType, XmlPullParser xpp, CONTENT_ITEM res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseLOCATABLEContent(eventType, xpp, res);
    }

    protected DATA_STRUCTURE parseDATA_STRUCTURE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "HISTORY": {
                return this.parseHISTORY(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseDATA_STRUCTUREContent(int eventType, XmlPullParser xpp, DATA_STRUCTURE res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseLOCATABLEContent(eventType, xpp, res);
    }

    protected DATA_VALUE parseDATA_VALUE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "DV-TEXT": {
                return this.parseDV_TEXT(xpp);
            }
            case "DV-IDENTIFIER": {
                return this.parseDV_IDENTIFIER(xpp);
            }
            case "DV-BOOLEAN": {
                return this.parseDV_BOOLEAN(xpp);
            }
            case "DV-PARAGRAPH": {
                return this.parseDV_PARAGRAPH(xpp);
            }
            case "DV-URI": {
                return this.parseDV_URI(xpp);
            }
            case "DV-STATE": {
                return this.parseDV_STATE(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseDATA_VALUEContent(int eventType, XmlPullParser xpp, DATA_VALUE res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseBaseContent(eventType, xpp, res);
    }

    protected DV_ABSOLUTE_QUANTITY parseDV_ABSOLUTE_QUANTITY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            default: 
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseDV_ABSOLUTE_QUANTITYContent(int eventType, XmlPullParser xpp, DV_ABSOLUTE_QUANTITY res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseDV_QUANTIFIEDContent(eventType, xpp, res);
    }

    protected DV_AMOUNT parseDV_AMOUNT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "DV-DURATION": {
                return this.parseDV_DURATION(xpp);
            }
            case "DV-COUNT": {
                return this.parseDV_COUNT(xpp);
            }
            case "DV-PROPORTION": {
                return this.parseDV_PROPORTION(xpp);
            }
            case "DV-QUANTITY": {
                return this.parseDV_QUANTITY(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseDV_AMOUNTContent(int eventType, XmlPullParser xpp, DV_AMOUNT res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("accuracy_is_percent")) {
            res.setAccuracy_is_percentElement(this.parseBoolean(xpp));
        } else if (!this.parseDV_QUANTIFIEDContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_ENCAPSULATED parseDV_ENCAPSULATED(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "DV-MULTIMEDIA": {
                return this.parseDV_MULTIMEDIA(xpp);
            }
            case "DV-PARSABLE": {
                return this.parseDV_PARSABLE(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseDV_ENCAPSULATEDContent(int eventType, XmlPullParser xpp, DV_ENCAPSULATED res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("charset")) {
            res.setCharset(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCODE_PHRASE(xpp));
        } else if (!this.parseDV_AMOUNTContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_ORDERED parseDV_ORDERED(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "DV-DATE-TIME": {
                return this.parseDV_DATE_TIME(xpp);
            }
            case "DV-TIME": {
                return this.parseDV_TIME(xpp);
            }
            case "DV-INTERVAL": {
                return this.parseDV_INTERVAL(xpp);
            }
            case "DV-ORDINAL": {
                return this.parseDV_ORDINAL(xpp);
            }
            case "DV-SCALE": {
                return this.parseDV_SCALE(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseDV_ORDEREDContent(int eventType, XmlPullParser xpp, DV_ORDERED res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("normal_status")) {
            res.setNormal_status(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("normal_range")) {
            res.setNormal_range(this.parseDV_INTERVAL(xpp));
        } else if (eventType == 2 && xpp.getName().equals("other_reference_ranges")) {
            res.getOther_reference_rangesList().add(this.parseREFERENCE_RANGE(xpp));
        } else if (!this.parseDATA_VALUEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_QUANTIFIED parseDV_QUANTIFIED(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            default: 
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseDV_QUANTIFIEDContent(int eventType, XmlPullParser xpp, DV_QUANTIFIED res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("magnitude_status")) {
            res.setMagnitude_statusElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("accuracy")) {
            res.setAccuracy(this.parseBase(xpp));
        } else if (!this.parseDV_ORDEREDContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_TEMPORAL parseDV_TEMPORAL(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "DV-DATE": {
                return this.parseDV_DATE(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseDV_TEMPORALContent(int eventType, XmlPullParser xpp, DV_TEMPORAL res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseDV_ABSOLUTE_QUANTITYContent(eventType, xpp, res);
    }

    protected DV_TIME_SPECIFICATION parseDV_TIME_SPECIFICATION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "DV-GENERAL-TIME-SPECIFICATION": {
                return this.parseDV_GENERAL_TIME_SPECIFICATION(xpp);
            }
            case "DV-PERIODIC-TIME-SPECIFICATION": {
                return this.parseDV_PERIODIC_TIME_SPECIFICATION(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseDV_TIME_SPECIFICATIONContent(int eventType, XmlPullParser xpp, DV_TIME_SPECIFICATION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("DV_PARSABLE")) {
            res.setDV_PARSABLEElement(this.parseString(xpp));
        } else if (!this.parseDATA_VALUEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ENTRY parseENTRY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "ADMIN-ENTRY": {
                return this.parseADMIN_ENTRY(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseENTRYContent(int eventType, XmlPullParser xpp, ENTRY res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encoding")) {
            res.setEncoding(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("other_participations")) {
            res.getOther_participationsList().add(this.parsePARTICIPATION(xpp));
        } else if (eventType == 2 && xpp.getName().equals("workflow_id")) {
            res.setWorkflow_id(this.parseOBJECT_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parsePARTY_PROXY(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parsePARTY_PROXY(xpp));
        } else if (!this.parseCONTENT_ITEMContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EVENT parseEVENT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "INTERVAL-EVENT": {
                return this.parseINTERVAL_EVENT(xpp);
            }
            case "POINT-EVENT": {
                return this.parsePOINT_EVENT(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseEVENTContent(int eventType, XmlPullParser xpp, EVENT res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTime(this.parseDV_DATE_TIME(xpp));
        } else if (eventType == 2 && xpp.getName().equals("state")) {
            res.setState(this.parseITEM_STRUCTURE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setData(this.parseAny(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ITEM_STRUCTURE parseITEM_STRUCTURE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "ITEM-SINGLE": {
                return this.parseITEM_SINGLE(xpp);
            }
            case "ITEM-TREE": {
                return this.parseITEM_TREE(xpp);
            }
            case "ITEM-TABLE": {
                return this.parseITEM_TABLE(xpp);
            }
            case "ITEM-LIST": {
                return this.parseITEM_LIST(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseITEM_STRUCTUREContent(int eventType, XmlPullParser xpp, ITEM_STRUCTURE res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseDATA_STRUCTUREContent(eventType, xpp, res);
    }

    protected ITEM parseITEM(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "ELEMENT": {
                return this.parseELEMENT(xpp);
            }
            case "CLUSTER": {
                return this.parseCLUSTER(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseITEMContent(int eventType, XmlPullParser xpp, ITEM res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseLOCATABLEContent(eventType, xpp, res);
    }

    protected LOCATABLE parseLOCATABLE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "CONTACT": {
                return this.parseCONTACT(xpp);
            }
            case "EVENT-CONTEXT": {
                return this.parseEVENT_CONTEXT(xpp);
            }
            case "EHR-STATUS": {
                return this.parseEHR_STATUS(xpp);
            }
            case "PARTY-IDENTITY": {
                return this.parsePARTY_IDENTITY(xpp);
            }
            case "ADDRESS": {
                return this.parseADDRESS(xpp);
            }
            case "COMPOSITION": {
                return this.parseCOMPOSITION(xpp);
            }
            case "PARTY-RELATIONSHIP": {
                return this.parsePARTY_RELATIONSHIP(xpp);
            }
            case "CAPABILITY": {
                return this.parseCAPABILITY(xpp);
            }
            case "EHR-ACCESS": {
                return this.parseEHR_ACCESS(xpp);
            }
            case "ACTIVITY": {
                return this.parseACTIVITY(xpp);
            }
            case "FOLDER": {
                return this.parseFOLDER(xpp);
            }
            case "PARTICIPATION": {
                return this.parsePARTICIPATION(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseLOCATABLEContent(int eventType, XmlPullParser xpp, LOCATABLE res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parsePATHABLEContent(eventType, xpp, res);
    }

    protected OBJECT_ID parseOBJECT_ID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "TEMPLATE-ID": {
                return this.parseTEMPLATE_ID(xpp);
            }
            case "ARCHETYPE-ID": {
                return this.parseARCHETYPE_ID(xpp);
            }
            case "GENERIC-ID": {
                return this.parseGENERIC_ID(xpp);
            }
            case "TERMINOLOGY-ID": {
                return this.parseTERMINOLOGY_ID(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseOBJECT_IDContent(int eventType, XmlPullParser xpp, OBJECT_ID res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseUIDContent(eventType, xpp, res);
    }

    protected PARTY_PROXY parsePARTY_PROXY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "PARTY-SELF": {
                return this.parsePARTY_SELF(xpp);
            }
            case "PARTY-IDENTIFIED": {
                return this.parsePARTY_IDENTIFIED(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parsePARTY_PROXYContent(int eventType, XmlPullParser xpp, PARTY_PROXY res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("external_ref")) {
            res.setExternal_ref(this.parsePARTY_REF(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PARTY parsePARTY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "ROLE": {
                return this.parseROLE(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parsePARTYContent(int eventType, XmlPullParser xpp, PARTY res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identities")) {
            res.getIdentitiesList().add(this.parsePARTY_IDENTITY(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contacts")) {
            res.setContacts(this.parseCONTACT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("details")) {
            res.setDetails(this.parseITEM_STRUCTURE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reverse_relationships")) {
            res.getReverse_relationshipsList().add(this.parseLOCATABLE_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationships")) {
            res.getRelationshipsList().add(this.parsePARTY_RELATIONSHIP(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PATHABLE parsePATHABLE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "INSTRUCTION-DETAILS": {
                return this.parseINSTRUCTION_DETAILS(xpp);
            }
            case "ISM-TRANSITION": {
                return this.parseISM_TRANSITION(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parsePATHABLEContent(int eventType, XmlPullParser xpp, PATHABLE res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setName(this.parseDV_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("archetype_node_id")) {
            res.setArchetype_node_idElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUid(this.parseUID_BASED_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("links")) {
            res.getLinksList().add(this.parseLINK(xpp));
        } else if (eventType == 2 && xpp.getName().equals("archetype_details")) {
            res.setArchetype_details(this.parseARCHETYPED(xpp));
        } else if (eventType == 2 && xpp.getName().equals("feeder_audit")) {
            res.setFeeder_audit(this.parseFEEDER_AUDIT(xpp));
        } else if (!this.parseAnyContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected UID_BASED_ID parseUID_BASED_ID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "OBJECT-VERSION-ID": {
                return this.parseOBJECT_VERSION_ID(xpp);
            }
            case "HIER-OBJECT-ID": {
                return this.parseHIER_OBJECT_ID(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseUID_BASED_IDContent(int eventType, XmlPullParser xpp, UID_BASED_ID res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseOBJECT_IDContent(eventType, xpp, res);
    }

    protected UID parseUID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "ISO-OID": {
                return this.parseISO_OID(xpp);
            }
            case "UUID": {
                return this.parseUUID(xpp);
            }
            case "INTERNET-ID": {
                return this.parseINTERNET_ID(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseUIDContent(int eventType, XmlPullParser xpp, UID res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected VERSION parseVERSION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String type;
        switch (type = xpp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) {
            case "IMPORTED-VERSION": {
                return this.parseIMPORTED_VERSION(xpp);
            }
            case "ORIGINAL-VERSION": {
                return this.parseORIGINAL_VERSION(xpp);
            }
        }
        throw new FHIRException("Unsupported type '" + type + "'");
    }

    protected boolean parseVERSIONContent(int eventType, XmlPullParser xpp, VERSION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("contribution")) {
            res.setContribution(this.parseOBJECT_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("signature")) {
            res.setSignatureElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("commit_audit")) {
            res.setCommit_audit(this.parseAUDIT_DETAILS(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ACTION parseACTION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ACTION res = new ACTION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseACTIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseACTIONContent(int eventType, XmlPullParser xpp, ACTION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTime(this.parseDV_DATE_TIME(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ism_transition")) {
            res.setIsm_transition(this.parseISM_TRANSITION(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instruction_details")) {
            res.setInstruction_details(this.parseINSTRUCTION_DETAILS(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescription(this.parseITEM_STRUCTURE(xpp));
        } else if (!this.parseCARE_ENTRYContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ACTIVITY parseACTIVITY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ACTIVITY res = new ACTIVITY();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseACTIVITYContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseACTIVITYContent(int eventType, XmlPullParser xpp, ACTIVITY res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("timing")) {
            res.setTiming(this.parseDV_PARSABLE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("action_archetype_id")) {
            res.setAction_archetype_idElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescription(this.parseITEM_STRUCTURE(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ADDRESS parseADDRESS(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ADDRESS res = new ADDRESS();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseADDRESSContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseADDRESSContent(int eventType, XmlPullParser xpp, ADDRESS res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("details")) {
            res.setDetails(this.parseITEM_STRUCTURE(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ADMIN_ENTRY parseADMIN_ENTRY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ADMIN_ENTRY res = new ADMIN_ENTRY();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseADMIN_ENTRYContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseADMIN_ENTRYContent(int eventType, XmlPullParser xpp, ADMIN_ENTRY res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("data")) {
            res.setData(this.parseITEM_STRUCTURE(xpp));
        } else if (!this.parseENTRYContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AGENT parseAGENT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AGENT res = new AGENT();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAGENTContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAGENTContent(int eventType, XmlPullParser xpp, AGENT res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseACTORContent(eventType, xpp, res);
    }

    protected ARCHETYPE_ID parseARCHETYPE_ID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ARCHETYPE_ID res = new ARCHETYPE_ID();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseARCHETYPE_IDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseARCHETYPE_IDContent(int eventType, XmlPullParser xpp, ARCHETYPE_ID res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseOBJECT_IDContent(eventType, xpp, res);
    }

    protected ARCHETYPED parseARCHETYPED(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ARCHETYPED res = new ARCHETYPED();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseARCHETYPEDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseARCHETYPEDContent(int eventType, XmlPullParser xpp, ARCHETYPED res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("archetype_id")) {
            res.setArchetype_id(this.parseARCHETYPE_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("template_id")) {
            res.setTemplate_id(this.parseTEMPLATE_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rm_version")) {
            res.setRm_versionElement(this.parseString(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ATTESTATION parseATTESTATION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ATTESTATION res = new ATTESTATION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseATTESTATIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseATTESTATIONContent(int eventType, XmlPullParser xpp, ATTESTATION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("attested_view")) {
            res.setAttested_view(this.parseDV_MULTIMEDIA(xpp));
        } else if (eventType == 2 && xpp.getName().equals("proof")) {
            res.setProofElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("items")) {
            res.getItemsList().add(this.parseDV_EHR_URI(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseDV_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("is_pending")) {
            res.setIs_pendingElement(this.parseBoolean(xpp));
        } else if (!this.parseAUDIT_DETAILSContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AUDIT_DETAILS parseAUDIT_DETAILS(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AUDIT_DETAILS res = new AUDIT_DETAILS();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAUDIT_DETAILSContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAUDIT_DETAILSContent(int eventType, XmlPullParser xpp, AUDIT_DETAILS res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("system_id")) {
            res.setSystem_idElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("time_committed")) {
            res.setTime_committed(this.parseDV_DATE_TIME(xpp));
        } else if (eventType == 2 && xpp.getName().equals("change_type")) {
            res.setChange_type(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescription(this.parseDV_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("committer")) {
            res.setCommitter(this.parsePARTY_PROXY(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Annotations parseAnnotations(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Annotations res = new Annotations();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAnnotationsContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAnnotationsContent(int eventType, XmlPullParser xpp, Annotations res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fhir_mapping")) {
            res.setFhir_mappingElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("vset_description")) {
            res.setVset_descriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hl7v2_mapping")) {
            res.setHl7v2_mappingElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("visibleInView")) {
            res.setVisibleInViewElement(this.parseString(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CAPABILITY parseCAPABILITY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CAPABILITY res = new CAPABILITY();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCAPABILITYContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCAPABILITYContent(int eventType, XmlPullParser xpp, CAPABILITY res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("credentials")) {
            res.setCredentials(this.parseITEM_STRUCTURE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("time_validity")) {
            res.setTime_validity(this.parseDV_INTERVAL(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CLUSTER parseCLUSTER(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CLUSTER res = new CLUSTER();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCLUSTERContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCLUSTERContent(int eventType, XmlPullParser xpp, CLUSTER res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("items")) {
            res.getItemsList().add(this.parseITEM(xpp));
        } else if (!this.parseITEMContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CODE_PHRASE parseCODE_PHRASE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CODE_PHRASE res = new CODE_PHRASE();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCODE_PHRASEContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCODE_PHRASEContent(int eventType, XmlPullParser xpp, CODE_PHRASE res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("terminology_id")) {
            res.setTerminology_id(this.parseTERMINOLOGY_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code_string")) {
            res.setCode_stringElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preferred_term")) {
            res.setPreferred_termElement(this.parseString(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected COMPOSITION parseCOMPOSITION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        COMPOSITION res = new COMPOSITION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCOMPOSITIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCOMPOSITIONContent(int eventType, XmlPullParser xpp, COMPOSITION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("territory")) {
            res.setTerritory(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseEVENT_CONTEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("composer")) {
            res.setComposer(this.parsePARTY_PROXY(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.getContentList().add(this.parseCONTENT_ITEM(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CONTACT parseCONTACT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CONTACT res = new CONTACT();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCONTACTContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCONTACTContent(int eventType, XmlPullParser xpp, CONTACT res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("addresses")) {
            res.getAddressesList().add(this.parseADDRESS(xpp));
        } else if (eventType == 2 && xpp.getName().equals("time_validity")) {
            res.setTime_validity(this.parseDV_INTERVAL(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CONTRIBUTION parseCONTRIBUTION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CONTRIBUTION res = new CONTRIBUTION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCONTRIBUTIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCONTRIBUTIONContent(int eventType, XmlPullParser xpp, CONTRIBUTION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUid(this.parseHIER_OBJECT_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("versions")) {
            res.getVersionsList().add(this.parseOBJECT_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("audit")) {
            res.setAudit(this.parseAUDIT_DETAILS(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_BOOLEAN parseDV_BOOLEAN(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_BOOLEAN res = new DV_BOOLEAN();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_BOOLEANContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_BOOLEANContent(int eventType, XmlPullParser xpp, DV_BOOLEAN res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseBoolean(xpp));
        } else if (!this.parseDATA_VALUEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_CODED_TEXT parseDV_CODED_TEXT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_CODED_TEXT res = new DV_CODED_TEXT();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_CODED_TEXTContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_CODED_TEXTContent(int eventType, XmlPullParser xpp, DV_CODED_TEXT res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("defining_code")) {
            res.setDefining_code(this.parseCODE_PHRASE(xpp));
        } else if (!this.parseDV_TEXTContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_COUNT parseDV_COUNT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_COUNT res = new DV_COUNT();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_COUNTContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_COUNTContent(int eventType, XmlPullParser xpp, DV_COUNT res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("magnitude")) {
            res.setMagnitudeElement(this.parseDecimal(xpp));
        } else if (!this.parseDV_AMOUNTContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_DATE_TIME parseDV_DATE_TIME(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_DATE_TIME res = new DV_DATE_TIME();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_DATE_TIMEContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_DATE_TIMEContent(int eventType, XmlPullParser xpp, DV_DATE_TIME res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDateTime(xpp));
        } else if (!this.parseDV_ORDEREDContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_DATE parseDV_DATE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_DATE res = new DV_DATE();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_DATEContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_DATEContent(int eventType, XmlPullParser xpp, DV_DATE res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDateTime(xpp));
        } else if (!this.parseDV_TEMPORALContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_DURATION parseDV_DURATION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_DURATION res = new DV_DURATION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_DURATIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_DURATIONContent(int eventType, XmlPullParser xpp, DV_DURATION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseDV_AMOUNTContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_EHR_URI parseDV_EHR_URI(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_EHR_URI res = new DV_EHR_URI();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_EHR_URIContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_EHR_URIContent(int eventType, XmlPullParser xpp, DV_EHR_URI res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseDV_URIContent(eventType, xpp, res);
    }

    protected DV_GENERAL_TIME_SPECIFICATION parseDV_GENERAL_TIME_SPECIFICATION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_GENERAL_TIME_SPECIFICATION res = new DV_GENERAL_TIME_SPECIFICATION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_GENERAL_TIME_SPECIFICATIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_GENERAL_TIME_SPECIFICATIONContent(int eventType, XmlPullParser xpp, DV_GENERAL_TIME_SPECIFICATION res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseDV_TIME_SPECIFICATIONContent(eventType, xpp, res);
    }

    protected DV_IDENTIFIER parseDV_IDENTIFIER(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_IDENTIFIER res = new DV_IDENTIFIER();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_IDENTIFIERContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_IDENTIFIERContent(int eventType, XmlPullParser xpp, DV_IDENTIFIER res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("issuer")) {
            res.setIssuerElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("assigner")) {
            res.setAssignerElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("id")) {
            res.setIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseString(xpp));
        } else if (!this.parseDATA_VALUEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_INTERVAL parseDV_INTERVAL(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_INTERVAL res = new DV_INTERVAL();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_INTERVALContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_INTERVALContent(int eventType, XmlPullParser xpp, DV_INTERVAL res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseDV_ORDEREDContent(eventType, xpp, res);
    }

    protected DV_MULTIMEDIA parseDV_MULTIMEDIA(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_MULTIMEDIA res = new DV_MULTIMEDIA();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_MULTIMEDIAContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_MULTIMEDIAContent(int eventType, XmlPullParser xpp, DV_MULTIMEDIA res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("alternate_text")) {
            res.setAlternate_textElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uri")) {
            res.setUri(this.parseDV_URI(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setDataElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("media_type")) {
            res.setMedia_type(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("compression_algorithm")) {
            res.setCompression_algorithm(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("integrity_check")) {
            res.setIntegrity_checkElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("integrity_check_algorithm")) {
            res.setIntegrity_check_algorithm(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("thumbnail")) {
            res.setThumbnail(this.parseDV_MULTIMEDIA(xpp));
        } else if (eventType == 2 && xpp.getName().equals("size")) {
            res.setSizeElement(this.parseInteger(xpp));
        } else if (!this.parseDV_ENCAPSULATEDContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_ORDINAL parseDV_ORDINAL(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_ORDINAL res = new DV_ORDINAL();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_ORDINALContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_ORDINALContent(int eventType, XmlPullParser xpp, DV_ORDINAL res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("symbol")) {
            res.setSymbol(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseInteger(xpp));
        } else if (!this.parseDV_ORDEREDContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_PARAGRAPH parseDV_PARAGRAPH(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_PARAGRAPH res = new DV_PARAGRAPH();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_PARAGRAPHContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_PARAGRAPHContent(int eventType, XmlPullParser xpp, DV_PARAGRAPH res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("items")) {
            res.getItemsList().add(this.parseDV_TEXT(xpp));
        } else if (!this.parseDATA_VALUEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_PARSABLE parseDV_PARSABLE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_PARSABLE res = new DV_PARSABLE();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_PARSABLEContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_PARSABLEContent(int eventType, XmlPullParser xpp, DV_PARSABLE res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("formalism")) {
            res.setFormalismElement(this.parseString(xpp));
        } else if (!this.parseDV_ENCAPSULATEDContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_PERIODIC_TIME_SPECIFICATION parseDV_PERIODIC_TIME_SPECIFICATION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_PERIODIC_TIME_SPECIFICATION res = new DV_PERIODIC_TIME_SPECIFICATION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_PERIODIC_TIME_SPECIFICATIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_PERIODIC_TIME_SPECIFICATIONContent(int eventType, XmlPullParser xpp, DV_PERIODIC_TIME_SPECIFICATION res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseDV_TIME_SPECIFICATIONContent(eventType, xpp, res);
    }

    protected DV_PROPORTION parseDV_PROPORTION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_PROPORTION res = new DV_PROPORTION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_PROPORTIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_PROPORTIONContent(int eventType, XmlPullParser xpp, DV_PROPORTION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("numerator")) {
            res.setNumeratorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("denominator")) {
            res.setDenominatorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("precision")) {
            res.setPrecisionElement(this.parseInteger(xpp));
        } else if (!this.parseDV_AMOUNTContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_QUANTITY parseDV_QUANTITY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_QUANTITY res = new DV_QUANTITY();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_QUANTITYContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_QUANTITYContent(int eventType, XmlPullParser xpp, DV_QUANTITY res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("magnitude")) {
            res.setMagnitudeElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("precision")) {
            res.setPrecisionElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("units")) {
            res.setUnitsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("units_system")) {
            res.setUnits_systemElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("units_display_name")) {
            res.setUnits_display_nameElement(this.parseString(xpp));
        } else if (!this.parseDV_AMOUNTContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_SCALE parseDV_SCALE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_SCALE res = new DV_SCALE();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_SCALEContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_SCALEContent(int eventType, XmlPullParser xpp, DV_SCALE res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("symbol")) {
            res.setSymbol(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (!this.parseDV_ORDEREDContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_STATE parseDV_STATE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_STATE res = new DV_STATE();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_STATEContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_STATEContent(int eventType, XmlPullParser xpp, DV_STATE res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("is_terminal")) {
            res.setIs_terminalElement(this.parseBoolean(xpp));
        } else if (!this.parseDATA_VALUEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_TEXT parseDV_TEXT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_TEXT res = new DV_TEXT();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_TEXTContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_TEXTContent(int eventType, XmlPullParser xpp, DV_TEXT res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hyperlink")) {
            res.setHyperlink(this.parseDV_URI(xpp));
        } else if (eventType == 2 && xpp.getName().equals("formatting")) {
            res.setFormattingElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mappings")) {
            res.getMappingsList().add(this.parseTERM_MAPPING(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encoding")) {
            res.setEncoding(this.parseCODE_PHRASE(xpp));
        } else if (!this.parseDATA_VALUEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_TIME parseDV_TIME(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_TIME res = new DV_TIME();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_TIMEContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_TIMEContent(int eventType, XmlPullParser xpp, DV_TIME res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseDV_ORDEREDContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DV_URI parseDV_URI(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DV_URI res = new DV_URI();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDV_URIContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDV_URIContent(int eventType, XmlPullParser xpp, DV_URI res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseUri(xpp));
        } else if (!this.parseDATA_VALUEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EHR_ACCESS parseEHR_ACCESS(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EHR_ACCESS res = new EHR_ACCESS();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEHR_ACCESSContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEHR_ACCESSContent(int eventType, XmlPullParser xpp, EHR_ACCESS res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("settings")) {
            res.setSettings(this.parseACCESS_CONTROL_SETTINGS(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EHR_STATUS parseEHR_STATUS(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EHR_STATUS res = new EHR_STATUS();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEHR_STATUSContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEHR_STATUSContent(int eventType, XmlPullParser xpp, EHR_STATUS res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parsePARTY_SELF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("is_queryable")) {
            res.setIs_queryableElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("is_modifiable")) {
            res.setIs_modifiableElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("other_details")) {
            res.setOther_details(this.parseITEM_STRUCTURE(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EHR parseEHR(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EHR res = new EHR();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEHRContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEHRContent(int eventType, XmlPullParser xpp, EHR res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("system_id")) {
            res.getSystem_idList().add(this.parseHIER_OBJECT_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ehr_id")) {
            res.setEhr_id(this.parseHIER_OBJECT_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributions")) {
            res.getContributionsList().add(this.parseOBJECT_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ehr_status")) {
            res.setEhr_status(this.parseOBJECT_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ehr_access")) {
            res.setEhr_access(this.parseOBJECT_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("compositions")) {
            res.getCompositionsList().add(this.parseOBJECT_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("directory")) {
            res.setDirectory(this.parseOBJECT_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("time_created")) {
            res.setTime_created(this.parseDV_DATE_TIME(xpp));
        } else if (eventType == 2 && xpp.getName().equals("folders")) {
            res.getFoldersList().add(this.parseOBJECT_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tags")) {
            res.getTagsList().add(this.parseOBJECT_REF(xpp));
        } else if (!this.parseAnyContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ELEMENT parseELEMENT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ELEMENT res = new ELEMENT();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseELEMENTContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseELEMENTContent(int eventType, XmlPullParser xpp, ELEMENT res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("null_flavour")) {
            res.setNull_flavour(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseDATA_VALUE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("null_reason")) {
            res.setNull_reason(this.parseDV_TEXT(xpp));
        } else if (!this.parseITEMContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EVALUATION parseEVALUATION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EVALUATION res = new EVALUATION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEVALUATIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEVALUATIONContent(int eventType, XmlPullParser xpp, EVALUATION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("data")) {
            res.setData(this.parseITEM_STRUCTURE(xpp));
        } else if (!this.parseCARE_ENTRYContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EVENT_CONTEXT parseEVENT_CONTEXT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EVENT_CONTEXT res = new EVENT_CONTEXT();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEVENT_CONTEXTContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEVENT_CONTEXTContent(int eventType, XmlPullParser xpp, EVENT_CONTEXT res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("start_time")) {
            res.setStart_time(this.parseDV_DATE_TIME(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end_time")) {
            res.setEnd_time(this.parseDV_DATE_TIME(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("setting")) {
            res.setSetting(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("other_context")) {
            res.setOther_context(this.parseITEM_STRUCTURE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("health_care_facility")) {
            res.setHealth_care_facility(this.parsePARTY_IDENTIFIED(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participations")) {
            res.getParticipationsList().add(this.parsePARTICIPATION(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected FEEDER_AUDIT_DETAILS parseFEEDER_AUDIT_DETAILS(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        FEEDER_AUDIT_DETAILS res = new FEEDER_AUDIT_DETAILS();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFEEDER_AUDIT_DETAILSContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFEEDER_AUDIT_DETAILSContent(int eventType, XmlPullParser xpp, FEEDER_AUDIT_DETAILS res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("system_id")) {
            res.setSystem_idElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parsePARTY_IDENTIFIED(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parsePARTY_PROXY(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parsePARTY_IDENTIFIED(xpp));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTime(this.parseDV_DATE_TIME(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version_id")) {
            res.setVersion_idElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("other_details")) {
            res.setOther_details(this.parseITEM_STRUCTURE(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected FEEDER_AUDIT parseFEEDER_AUDIT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        FEEDER_AUDIT res = new FEEDER_AUDIT();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFEEDER_AUDITContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFEEDER_AUDITContent(int eventType, XmlPullParser xpp, FEEDER_AUDIT res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("originating_system_item_ids")) {
            res.getOriginating_system_item_idsList().add(this.parseDV_IDENTIFIER(xpp));
        } else if (eventType == 2 && xpp.getName().equals("feeder_system_item_ids")) {
            res.getFeeder_system_item_idsList().add(this.parseDV_IDENTIFIER(xpp));
        } else if (eventType == 2 && xpp.getName().equals("original_content")) {
            res.setOriginal_content(this.parseDV_ENCAPSULATED(xpp));
        } else if (eventType == 2 && xpp.getName().equals("originating_system_audit")) {
            res.setOriginating_system_audit(this.parseFEEDER_AUDIT_DETAILS(xpp));
        } else if (eventType == 2 && xpp.getName().equals("feeder_system_audit")) {
            res.setFeeder_system_audit(this.parseFEEDER_AUDIT_DETAILS(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected FOLDER parseFOLDER(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        FOLDER res = new FOLDER();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFOLDERContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFOLDERContent(int eventType, XmlPullParser xpp, FOLDER res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("items")) {
            res.getItemsList().add(this.parseOBJECT_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("folders")) {
            res.getFoldersList().add(this.parseFOLDER(xpp));
        } else if (eventType == 2 && xpp.getName().equals("details")) {
            res.setDetails(this.parseITEM_STRUCTURE(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GENERIC_ID parseGENERIC_ID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GENERIC_ID res = new GENERIC_ID();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGENERIC_IDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGENERIC_IDContent(int eventType, XmlPullParser xpp, GENERIC_ID res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseOBJECT_IDContent(eventType, xpp, res);
    }

    protected GROUP parseGROUP(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GROUP res = new GROUP();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGROUPContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGROUPContent(int eventType, XmlPullParser xpp, GROUP res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseACTORContent(eventType, xpp, res);
    }

    protected HIER_OBJECT_ID parseHIER_OBJECT_ID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HIER_OBJECT_ID res = new HIER_OBJECT_ID();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHIER_OBJECT_IDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHIER_OBJECT_IDContent(int eventType, XmlPullParser xpp, HIER_OBJECT_ID res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseUID_BASED_IDContent(eventType, xpp, res);
    }

    protected HISTORY parseHISTORY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HISTORY res = new HISTORY();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHISTORYContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHISTORYContent(int eventType, XmlPullParser xpp, HISTORY res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("origin")) {
            res.setOrigin(this.parseDV_DATE_TIME(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parseDV_DURATION(xpp));
        } else if (eventType == 2 && xpp.getName().equals("duration")) {
            res.setDuration(this.parseDV_DURATION(xpp));
        } else if (eventType == 2 && xpp.getName().equals("summary")) {
            res.setSummary(this.parseITEM_STRUCTURE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("events")) {
            res.getEventsList().add(this.parseEVENT(xpp));
        } else if (!this.parseDATA_STRUCTUREContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected IMPORTED_VERSION parseIMPORTED_VERSION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        IMPORTED_VERSION res = new IMPORTED_VERSION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseIMPORTED_VERSIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseIMPORTED_VERSIONContent(int eventType, XmlPullParser xpp, IMPORTED_VERSION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("item")) {
            res.setItem(this.parseORIGINAL_VERSION(xpp));
        } else if (!this.parseVERSIONContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected INSTRUCTION_DETAILS parseINSTRUCTION_DETAILS(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        INSTRUCTION_DETAILS res = new INSTRUCTION_DETAILS();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseINSTRUCTION_DETAILSContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseINSTRUCTION_DETAILSContent(int eventType, XmlPullParser xpp, INSTRUCTION_DETAILS res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("instruction_id")) {
            res.setInstruction_id(this.parseLOCATABLE_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("activity_id")) {
            res.setActivity_idElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("wf_details")) {
            res.setWf_details(this.parseITEM_STRUCTURE(xpp));
        } else if (!this.parsePATHABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected INSTRUCTION parseINSTRUCTION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        INSTRUCTION res = new INSTRUCTION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseINSTRUCTIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseINSTRUCTIONContent(int eventType, XmlPullParser xpp, INSTRUCTION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("narrative")) {
            res.setNarrative(this.parseDV_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expiry_time")) {
            res.setExpiry_time(this.parseDV_DATE_TIME(xpp));
        } else if (eventType == 2 && xpp.getName().equals("wf_definition")) {
            res.setWf_definition(this.parseDV_PARSABLE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("activities")) {
            res.getActivitiesList().add(this.parseACTIVITY(xpp));
        } else if (!this.parseCARE_ENTRYContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected INTERNET_ID parseINTERNET_ID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        INTERNET_ID res = new INTERNET_ID();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseINTERNET_IDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseINTERNET_IDContent(int eventType, XmlPullParser xpp, INTERNET_ID res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseUIDContent(eventType, xpp, res);
    }

    protected INTERVAL_EVENT parseINTERVAL_EVENT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        INTERVAL_EVENT res = new INTERVAL_EVENT();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseINTERVAL_EVENTContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseINTERVAL_EVENTContent(int eventType, XmlPullParser xpp, INTERVAL_EVENT res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("width")) {
            res.setWidth(this.parseDV_DURATION(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sample_count")) {
            res.setSample_countElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("math_function")) {
            res.setMath_function(this.parseDV_CODED_TEXT(xpp));
        } else if (!this.parseEVENTContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ISM_TRANSITION parseISM_TRANSITION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ISM_TRANSITION res = new ISM_TRANSITION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseISM_TRANSITIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseISM_TRANSITIONContent(int eventType, XmlPullParser xpp, ISM_TRANSITION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("current_state")) {
            res.setCurrent_state(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("transition")) {
            res.setTransition(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careflow_step")) {
            res.setCareflow_step(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReasonList().add(this.parseDV_TEXT(xpp));
        } else if (!this.parsePATHABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ISO_OID parseISO_OID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ISO_OID res = new ISO_OID();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseISO_OIDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseISO_OIDContent(int eventType, XmlPullParser xpp, ISO_OID res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseUIDContent(eventType, xpp, res);
    }

    protected ITEM_LIST parseITEM_LIST(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ITEM_LIST res = new ITEM_LIST();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseITEM_LISTContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseITEM_LISTContent(int eventType, XmlPullParser xpp, ITEM_LIST res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("items")) {
            res.getItemsList().add(this.parseELEMENT(xpp));
        } else if (!this.parseITEM_STRUCTUREContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ITEM_SINGLE parseITEM_SINGLE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ITEM_SINGLE res = new ITEM_SINGLE();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseITEM_SINGLEContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseITEM_SINGLEContent(int eventType, XmlPullParser xpp, ITEM_SINGLE res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("item")) {
            res.setItem(this.parseELEMENT(xpp));
        } else if (!this.parseITEM_STRUCTUREContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ITEM_TABLE parseITEM_TABLE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ITEM_TABLE res = new ITEM_TABLE();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseITEM_TABLEContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseITEM_TABLEContent(int eventType, XmlPullParser xpp, ITEM_TABLE res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("rows")) {
            res.getRowsList().add(this.parseCLUSTER(xpp));
        } else if (!this.parseITEM_STRUCTUREContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ITEM_TAG parseITEM_TAG(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ITEM_TAG res = new ITEM_TAG();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseITEM_TAGContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseITEM_TAGContent(int eventType, XmlPullParser xpp, ITEM_TAG res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("key")) {
            res.setKeyElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseUID_BASED_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target_path")) {
            res.setTarget_pathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("owner_id")) {
            res.setOwner_id(this.parseOBJECT_REF(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ITEM_TREE parseITEM_TREE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ITEM_TREE res = new ITEM_TREE();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseITEM_TREEContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseITEM_TREEContent(int eventType, XmlPullParser xpp, ITEM_TREE res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("items")) {
            res.getItemsList().add(this.parseITEM(xpp));
        } else if (!this.parseITEM_STRUCTUREContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected LINK parseLINK(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        LINK res = new LINK();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLINKContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLINKContent(int eventType, XmlPullParser xpp, LINK res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("meaning")) {
            res.setMeaning(this.parseDV_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseDV_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseDV_EHR_URI(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected LOCATABLE_REF parseLOCATABLE_REF(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        LOCATABLE_REF res = new LOCATABLE_REF();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLOCATABLE_REFContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLOCATABLE_REFContent(int eventType, XmlPullParser xpp, LOCATABLE_REF res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (!this.parseOBJECT_REFContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected OBJECT_REF parseOBJECT_REF(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OBJECT_REF res = new OBJECT_REF();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseOBJECT_REFContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseOBJECT_REFContent(int eventType, XmlPullParser xpp, OBJECT_REF res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("namespace")) {
            res.setNamespaceElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("id")) {
            res.setId(this.parseOBJECT_ID(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected OBJECT_VERSION_ID parseOBJECT_VERSION_ID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OBJECT_VERSION_ID res = new OBJECT_VERSION_ID();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseOBJECT_VERSION_IDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseOBJECT_VERSION_IDContent(int eventType, XmlPullParser xpp, OBJECT_VERSION_ID res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseUID_BASED_IDContent(eventType, xpp, res);
    }

    protected OBSERVATION parseOBSERVATION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OBSERVATION res = new OBSERVATION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseOBSERVATIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseOBSERVATIONContent(int eventType, XmlPullParser xpp, OBSERVATION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("data")) {
            res.setData(this.parseHISTORY(xpp));
        } else if (eventType == 2 && xpp.getName().equals("state")) {
            res.setState(this.parseHISTORY(xpp));
        } else if (!this.parseCARE_ENTRYContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ORGANISATION parseORGANISATION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ORGANISATION res = new ORGANISATION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseORGANISATIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseORGANISATIONContent(int eventType, XmlPullParser xpp, ORGANISATION res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseACTORContent(eventType, xpp, res);
    }

    protected ORIGINAL_VERSION parseORIGINAL_VERSION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ORIGINAL_VERSION res = new ORIGINAL_VERSION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseORIGINAL_VERSIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseORIGINAL_VERSIONContent(int eventType, XmlPullParser xpp, ORIGINAL_VERSION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUid(this.parseOBJECT_VERSION_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preceding_version_uid")) {
            res.setPreceding_version_uid(this.parseOBJECT_VERSION_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("other_input_version_uids")) {
            res.getOther_input_version_uidsList().add(this.parseOBJECT_VERSION_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lifecycle_state")) {
            res.setLifecycle_state(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("attestations")) {
            res.getAttestationsList().add(this.parseATTESTATION(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setData(this.parseAny(xpp));
        } else if (!this.parseVERSIONContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PARTICIPATION parsePARTICIPATION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PARTICIPATION res = new PARTICIPATION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePARTICIPATIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePARTICIPATIONContent(int eventType, XmlPullParser xpp, PARTICIPATION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseDV_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setMode(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parsePARTY_PROXY(xpp));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTime(this.parseDV_INTERVAL(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PARTY_IDENTIFIED parsePARTY_IDENTIFIED(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PARTY_IDENTIFIED res = new PARTY_IDENTIFIED();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePARTY_IDENTIFIEDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePARTY_IDENTIFIEDContent(int eventType, XmlPullParser xpp, PARTY_IDENTIFIED res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifiers")) {
            res.getIdentifiersList().add(this.parseDV_IDENTIFIER(xpp));
        } else if (!this.parsePARTY_PROXYContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PARTY_IDENTITY parsePARTY_IDENTITY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PARTY_IDENTITY res = new PARTY_IDENTITY();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePARTY_IDENTITYContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePARTY_IDENTITYContent(int eventType, XmlPullParser xpp, PARTY_IDENTITY res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("details")) {
            res.setDetails(this.parseITEM_STRUCTURE(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PARTY_REF parsePARTY_REF(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PARTY_REF res = new PARTY_REF();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePARTY_REFContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePARTY_REFContent(int eventType, XmlPullParser xpp, PARTY_REF res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseOBJECT_REFContent(eventType, xpp, res);
    }

    protected PARTY_RELATED parsePARTY_RELATED(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PARTY_RELATED res = new PARTY_RELATED();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePARTY_RELATEDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePARTY_RELATEDContent(int eventType, XmlPullParser xpp, PARTY_RELATED res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseDV_CODED_TEXT(xpp));
        } else if (!this.parsePARTY_IDENTIFIEDContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PARTY_RELATIONSHIP parsePARTY_RELATIONSHIP(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PARTY_RELATIONSHIP res = new PARTY_RELATIONSHIP();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePARTY_RELATIONSHIPContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePARTY_RELATIONSHIPContent(int eventType, XmlPullParser xpp, PARTY_RELATIONSHIP res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("details")) {
            res.setDetails(this.parseITEM_STRUCTURE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parsePARTY_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("time_validity")) {
            res.setTime_validity(this.parseDV_INTERVAL(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parsePARTY_REF(xpp));
        } else if (!this.parseLOCATABLEContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected PARTY_SELF parsePARTY_SELF(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PARTY_SELF res = new PARTY_SELF();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePARTY_SELFContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePARTY_SELFContent(int eventType, XmlPullParser xpp, PARTY_SELF res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parsePARTY_PROXYContent(eventType, xpp, res);
    }

    protected PERSON parsePERSON(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PERSON res = new PERSON();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePERSONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePERSONContent(int eventType, XmlPullParser xpp, PERSON res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseACTORContent(eventType, xpp, res);
    }

    protected POINT_EVENT parsePOINT_EVENT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        POINT_EVENT res = new POINT_EVENT();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePOINT_EVENTContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePOINT_EVENTContent(int eventType, XmlPullParser xpp, POINT_EVENT res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseEVENTContent(eventType, xpp, res);
    }

    protected REFERENCE_RANGE parseREFERENCE_RANGE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        REFERENCE_RANGE res = new REFERENCE_RANGE();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseREFERENCE_RANGEContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseREFERENCE_RANGEContent(int eventType, XmlPullParser xpp, REFERENCE_RANGE res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("meaning")) {
            res.setMeaning(this.parseDV_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("range")) {
            res.setRange(this.parseDV_INTERVAL(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RESOURCE_DESCRIPTION_ITEM parseRESOURCE_DESCRIPTION_ITEM(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RESOURCE_DESCRIPTION_ITEM res = new RESOURCE_DESCRIPTION_ITEM();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRESOURCE_DESCRIPTION_ITEMContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRESOURCE_DESCRIPTION_ITEMContent(int eventType, XmlPullParser xpp, RESOURCE_DESCRIPTION_ITEM res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("keywords")) {
            res.getKeywordsList().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("misuse")) {
            res.setMisuseElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("original_resource_uri")) {
            res.getOriginal_resource_uriList().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("other_details")) {
            res.getOther_detailsList().add(this.parseString(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RESOURCE_DESCRIPTION parseRESOURCE_DESCRIPTION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RESOURCE_DESCRIPTION res = new RESOURCE_DESCRIPTION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRESOURCE_DESCRIPTIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRESOURCE_DESCRIPTIONContent(int eventType, XmlPullParser xpp, RESOURCE_DESCRIPTION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("original_author")) {
            res.getOriginal_authorList().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("other_contributors")) {
            res.getOther_contributorsList().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lifecycle_state")) {
            res.setLifecycle_stateElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource_package_uri")) {
            res.setResource_package_uriElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("other_details")) {
            res.getOther_detailsList().add(this.parseOBJECT_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent_resource")) {
            res.setParent_resource(this.parseAUTHORED_RESOURCE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("details")) {
            res.getDetailsList().add(this.parseRESOURCE_DESCRIPTION_ITEM(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected REVISION_HISTORY_ITEM parseREVISION_HISTORY_ITEM(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        REVISION_HISTORY_ITEM res = new REVISION_HISTORY_ITEM();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseREVISION_HISTORY_ITEMContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseREVISION_HISTORY_ITEMContent(int eventType, XmlPullParser xpp, REVISION_HISTORY_ITEM res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("version_id")) {
            res.setVersion_id(this.parseOBJECT_VERSION_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("audits")) {
            res.getAuditsList().add(this.parseAUDIT_DETAILS(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected REVISION_HISTORY parseREVISION_HISTORY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        REVISION_HISTORY res = new REVISION_HISTORY();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseREVISION_HISTORYContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseREVISION_HISTORYContent(int eventType, XmlPullParser xpp, REVISION_HISTORY res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("most_recent_version")) {
            res.setMost_recent_versionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("most_recent_version_time_committed")) {
            res.setMost_recent_version_time_committedElement(this.parseString(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ROLE parseROLE(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ROLE res = new ROLE();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseROLEContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseROLEContent(int eventType, XmlPullParser xpp, ROLE res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("time_validity")) {
            res.setTime_validity(this.parseDV_INTERVAL(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parsePARTY_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("capabilities")) {
            res.getCapabilitiesList().add(this.parseCAPABILITY(xpp));
        } else if (!this.parsePARTYContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SECTION parseSECTION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SECTION res = new SECTION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSECTIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSECTIONContent(int eventType, XmlPullParser xpp, SECTION res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("items")) {
            res.getItemsList().add(this.parseCONTENT_ITEM(xpp));
        } else if (!this.parseCONTENT_ITEMContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TEMPLATE_ID parseTEMPLATE_ID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TEMPLATE_ID res = new TEMPLATE_ID();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTEMPLATE_IDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTEMPLATE_IDContent(int eventType, XmlPullParser xpp, TEMPLATE_ID res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseOBJECT_IDContent(eventType, xpp, res);
    }

    protected TERM_MAPPING parseTERM_MAPPING(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TERM_MAPPING res = new TERM_MAPPING();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTERM_MAPPINGContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTERM_MAPPINGContent(int eventType, XmlPullParser xpp, TERM_MAPPING res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("match")) {
            res.setMatchElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurpose(this.parseDV_CODED_TEXT(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseCODE_PHRASE(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TERMINOLOGY_ID parseTERMINOLOGY_ID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TERMINOLOGY_ID res = new TERMINOLOGY_ID();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTERMINOLOGY_IDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTERMINOLOGY_IDContent(int eventType, XmlPullParser xpp, TERMINOLOGY_ID res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseOBJECT_IDContent(eventType, xpp, res);
    }

    protected TRANSLATION_DETAILS parseTRANSLATION_DETAILS(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TRANSLATION_DETAILS res = new TRANSLATION_DETAILS();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTRANSLATION_DETAILSContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTRANSLATION_DETAILSContent(int eventType, XmlPullParser xpp, TRANSLATION_DETAILS res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCODE_PHRASE(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthorList().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("accreditation")) {
            res.setAccreditationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("other_details")) {
            res.getOther_detailsList().add(this.parseString(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TranslatedString parseTranslatedString(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TranslatedString res = new TranslatedString();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTranslatedStringContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTranslatedStringContent(int eventType, XmlPullParser xpp, TranslatedString res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected UUID parseUUID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UUID res = new UUID();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseUUIDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseUUIDContent(int eventType, XmlPullParser xpp, UUID res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseUIDContent(eventType, xpp, res);
    }

    protected VERSION_TREE_ID parseVERSION_TREE_ID(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        VERSION_TREE_ID res = new VERSION_TREE_ID();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseVERSION_TREE_IDContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseVERSION_TREE_IDContent(int eventType, XmlPullParser xpp, VERSION_TREE_ID res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected VERSIONED_COMPOSITION parseVERSIONED_COMPOSITION(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        VERSIONED_COMPOSITION res = new VERSIONED_COMPOSITION();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseVERSIONED_COMPOSITIONContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseVERSIONED_COMPOSITIONContent(int eventType, XmlPullParser xpp, VERSIONED_COMPOSITION res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseVERSIONED_OBJECTContent(eventType, xpp, res);
    }

    protected VERSIONED_EHR_ACCESS parseVERSIONED_EHR_ACCESS(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        VERSIONED_EHR_ACCESS res = new VERSIONED_EHR_ACCESS();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseVERSIONED_EHR_ACCESSContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseVERSIONED_EHR_ACCESSContent(int eventType, XmlPullParser xpp, VERSIONED_EHR_ACCESS res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseVERSIONED_OBJECTContent(eventType, xpp, res);
    }

    protected VERSIONED_EHR_STATUS parseVERSIONED_EHR_STATUS(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        VERSIONED_EHR_STATUS res = new VERSIONED_EHR_STATUS();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseVERSIONED_EHR_STATUSContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseVERSIONED_EHR_STATUSContent(int eventType, XmlPullParser xpp, VERSIONED_EHR_STATUS res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseVERSIONED_OBJECTContent(eventType, xpp, res);
    }

    protected VERSIONED_FOLDER parseVERSIONED_FOLDER(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        VERSIONED_FOLDER res = new VERSIONED_FOLDER();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseVERSIONED_FOLDERContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseVERSIONED_FOLDERContent(int eventType, XmlPullParser xpp, VERSIONED_FOLDER res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseVERSIONED_OBJECTContent(eventType, xpp, res);
    }

    protected VERSIONED_OBJECT parseVERSIONED_OBJECT(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        VERSIONED_OBJECT res = new VERSIONED_OBJECT();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseVERSIONED_OBJECTContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseVERSIONED_OBJECTContent(int eventType, XmlPullParser xpp, VERSIONED_OBJECT res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUid(this.parseHIER_OBJECT_ID(xpp));
        } else if (eventType == 2 && xpp.getName().equals("owner_id")) {
            res.setOwner_id(this.parseOBJECT_REF(xpp));
        } else if (eventType == 2 && xpp.getName().equals("time_created")) {
            res.setTime_created(this.parseDV_DATE_TIME(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected VERSIONED_PARTY parseVERSIONED_PARTY(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        VERSIONED_PARTY res = new VERSIONED_PARTY();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseVERSIONED_PARTYContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseVERSIONED_PARTYContent(int eventType, XmlPullParser xpp, VERSIONED_PARTY res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseVERSIONED_OBJECTContent(eventType, xpp, res);
    }

    protected WebTemplate parseWebTemplate(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        WebTemplate res = new WebTemplate();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseWebTemplateContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseWebTemplateContent(int eventType, XmlPullParser xpp, WebTemplate res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("templateId")) {
            res.setTemplateIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("semver")) {
            res.setSemverElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("defaultLanguage")) {
            res.setDefaultLanguageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("languages")) {
            res.getLanguagesList().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tree")) {
            res.setTree(this.parseWebTemplateItem(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected WebTemplateInput parseWebTemplateInput(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        WebTemplateInput res = new WebTemplateInput();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseWebTemplateInputContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseWebTemplateInputContent(int eventType, XmlPullParser xpp, WebTemplateInput res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("suffix")) {
            res.setSuffixElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("defaultValue")) {
            res.setDefaultValue(this.parseNativePrimitive(xpp));
        } else if (eventType == 2 && xpp.getName().equals("terminology")) {
            res.setTerminologyElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("validation")) {
            res.setValidation(this.parseWebTemplateInputValidation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("list")) {
            res.getListList().add(this.parseWebTemplateInputListItem(xpp));
        } else if (eventType == 2 && xpp.getName().equals("listOpen")) {
            res.setListOpenElement(this.parseBoolean(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected WebTemplateInputListItem parseWebTemplateInputListItem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        WebTemplateInputListItem res = new WebTemplateInputListItem();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseWebTemplateInputListItemContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseWebTemplateInputListItemContent(int eventType, XmlPullParser xpp, WebTemplateInputListItem res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ordinal")) {
            res.setOrdinalElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("localizedLabels")) {
            res.getLocalizedLabelsList().add(this.parseTranslatedString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("localizedDescriptions")) {
            res.getLocalizedDescriptionsList().add(this.parseTranslatedString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("currentStates")) {
            res.setCurrentStatesElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("range")) {
            res.setRangeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("precision")) {
            res.setPrecisionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("termBindings")) {
            res.getTermBindingsList().add(this.parseWebTemplateTermBinding(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected WebTemplateInputValidation parseWebTemplateInputValidation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        WebTemplateInputValidation res = new WebTemplateInputValidation();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseWebTemplateInputValidationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseWebTemplateInputValidationContent(int eventType, XmlPullParser xpp, WebTemplateInputValidation res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("range")) {
            res.setRange(this.parseWebTemplateInputValidationRange(xpp));
        } else if (eventType == 2 && xpp.getName().equals("precision")) {
            res.setPrecision(this.parseWebTemplateInputValidationRange(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected WebTemplateInputValidationRange parseWebTemplateInputValidationRange(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        WebTemplateInputValidationRange res = new WebTemplateInputValidationRange();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseWebTemplateInputValidationRangeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseWebTemplateInputValidationRangeContent(int eventType, XmlPullParser xpp, WebTemplateInputValidationRange res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("minOp")) {
            res.setMinOpElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxOp")) {
            res.setMaxOpElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseDecimal(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected WebTemplateItem parseWebTemplateItem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        WebTemplateItem res = new WebTemplateItem();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseWebTemplateItemContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseWebTemplateItemContent(int eventType, XmlPullParser xpp, WebTemplateItem res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("id")) {
            res.setIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("depth")) {
            res.setDepthElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("localizedName")) {
            res.setLocalizedNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rmType")) {
            res.setRmTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("nodeId")) {
            res.setNodeIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dependsOn")) {
            res.setDependsOnElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("localizedNames")) {
            res.getLocalizedNamesList().add(this.parseTranslatedString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("localizedDescriptions")) {
            res.getLocalizedDescriptionsList().add(this.parseTranslatedString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("annotations")) {
            res.setAnnotations(this.parseAnnotations(xpp));
        } else if (eventType == 2 && xpp.getName().equals("archetype_id")) {
            res.setArchetype_idElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("aqlPath")) {
            res.setAqlPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("custodian_namespace")) {
            res.setCustodian_namespaceElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("custodian_organisation")) {
            res.setCustodian_organisationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lifecycleState")) {
            res.setLifecycleStateElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("original_namespace")) {
            res.setOriginal_namespaceElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("original_publisher")) {
            res.setOriginal_publisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("proportionTypes")) {
            res.setProportionTypesElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revision")) {
            res.setRevisionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("inContext")) {
            res.setInContextElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("inputs")) {
            res.getInputsList().add(this.parseWebTemplateInput(xpp));
        } else if (eventType == 2 && xpp.getName().equals("termBindings")) {
            res.getTermBindingsList().add(this.parseWebTemplateTermBinding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("children")) {
            res.getChildrenList().add(this.parseWebTemplateItem(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected WebTemplateTermBinding parseWebTemplateTermBinding(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        WebTemplateTermBinding res = new WebTemplateTermBinding();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseWebTemplateTermBindingContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseWebTemplateTermBindingContent(int eventType, XmlPullParser xpp, WebTemplateTermBinding res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseWebTemplateTermBindingValue(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected WebTemplateTermBindingValue parseWebTemplateTermBindingValue(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        WebTemplateTermBindingValue res = new WebTemplateTermBindingValue();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseWebTemplateTermBindingValueContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseWebTemplateTermBindingValueContent(int eventType, XmlPullParser xpp, WebTemplateTermBindingValue res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("terminologyId")) {
            res.setTerminologyIdElement(this.parseString(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    @Override
    protected Resource parseResource(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        if (xpp == null) {
            throw new IOException("xpp == null!");
        }
        throw new FHIRFormatError("Unknown resource type " + xpp.getName());
    }

    @Override
    protected DataType parseType(String prefix, XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        if (prefix == null) {
            throw new IOException("prefix == null!");
        }
        if (xpp == null) {
            throw new IOException("xpp == null!");
        }
        if (xpp.getName().equals(prefix + "Date")) {
            return this.parseDate(xpp);
        }
        if (xpp.getName().equals(prefix + "DateTime")) {
            return this.parseDateTime(xpp);
        }
        if (xpp.getName().equals(prefix + "Code")) {
            return this.parseCode(xpp);
        }
        if (xpp.getName().equals(prefix + "String")) {
            return this.parseString(xpp);
        }
        if (xpp.getName().equals(prefix + "Integer")) {
            return this.parseInteger(xpp);
        }
        if (xpp.getName().equals(prefix + "Integer64")) {
            return this.parseInteger64(xpp);
        }
        if (xpp.getName().equals(prefix + "Oid")) {
            return this.parseOid(xpp);
        }
        if (xpp.getName().equals(prefix + "Canonical")) {
            return this.parseCanonical(xpp);
        }
        if (xpp.getName().equals(prefix + "Uri")) {
            return this.parseUri(xpp);
        }
        if (xpp.getName().equals(prefix + "Uuid")) {
            return this.parseUuid(xpp);
        }
        if (xpp.getName().equals(prefix + "Url")) {
            return this.parseUrl(xpp);
        }
        if (xpp.getName().equals(prefix + "Instant")) {
            return this.parseInstant(xpp);
        }
        if (xpp.getName().equals(prefix + "Boolean")) {
            return this.parseBoolean(xpp);
        }
        if (xpp.getName().equals(prefix + "Base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (xpp.getName().equals(prefix + "UnsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (xpp.getName().equals(prefix + "Markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (xpp.getName().equals(prefix + "Time")) {
            return this.parseTime(xpp);
        }
        if (xpp.getName().equals(prefix + "Id")) {
            return this.parseId(xpp);
        }
        if (xpp.getName().equals(prefix + "PositiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (xpp.getName().equals(prefix + "Decimal")) {
            return this.parseDecimal(xpp);
        }
        throw new FHIRFormatError("Unknown type " + xpp.getName());
    }

    @Override
    protected DataType parseType(XmlPullParser xpp, String type) throws XmlPullParserException, IOException, FHIRFormatError {
        if (type == null) {
            throw new IOException("type == null!");
        }
        if (xpp == null) {
            throw new IOException("xpp == null!");
        }
        if (type.equals("date")) {
            return this.parseDate(xpp);
        }
        if (type.equals("dateTime")) {
            return this.parseDateTime(xpp);
        }
        if (type.equals("code")) {
            return this.parseCode(xpp);
        }
        if (type.equals("string")) {
            return this.parseString(xpp);
        }
        if (type.equals("integer")) {
            return this.parseInteger(xpp);
        }
        if (type.equals("integer64")) {
            return this.parseInteger64(xpp);
        }
        if (type.equals("oid")) {
            return this.parseOid(xpp);
        }
        if (type.equals("canonical")) {
            return this.parseCanonical(xpp);
        }
        if (type.equals("uri")) {
            return this.parseUri(xpp);
        }
        if (type.equals("uuid")) {
            return this.parseUuid(xpp);
        }
        if (type.equals("url")) {
            return this.parseUrl(xpp);
        }
        if (type.equals("instant")) {
            return this.parseInstant(xpp);
        }
        if (type.equals("boolean")) {
            return this.parseBoolean(xpp);
        }
        if (type.equals("base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (type.equals("unsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (type.equals("markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (type.equals("time")) {
            return this.parseTime(xpp);
        }
        if (type.equals("id")) {
            return this.parseId(xpp);
        }
        if (type.equals("positiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (type.equals("decimal")) {
            return this.parseDecimal(xpp);
        }
        throw new FHIRFormatError("Unknown type " + type);
    }

    @Override
    public Base parseFragment(XmlPullParser xpp, String type) throws XmlPullParserException, IOException, FHIRFormatError {
        if (type == null) {
            throw new IOException("type == null!");
        }
        if (xpp == null) {
            throw new IOException("xpp == null!");
        }
        if (type.equals("ACTION")) {
            return this.parseACTION(xpp);
        }
        if (type.equals("ACTIVITY")) {
            return this.parseACTIVITY(xpp);
        }
        if (type.equals("ADDRESS")) {
            return this.parseADDRESS(xpp);
        }
        if (type.equals("ADMIN_ENTRY")) {
            return this.parseADMIN_ENTRY(xpp);
        }
        if (type.equals("AGENT")) {
            return this.parseAGENT(xpp);
        }
        if (type.equals("ARCHETYPE_ID")) {
            return this.parseARCHETYPE_ID(xpp);
        }
        if (type.equals("ARCHETYPED")) {
            return this.parseARCHETYPED(xpp);
        }
        if (type.equals("ATTESTATION")) {
            return this.parseATTESTATION(xpp);
        }
        if (type.equals("AUDIT_DETAILS")) {
            return this.parseAUDIT_DETAILS(xpp);
        }
        if (type.equals("Annotations")) {
            return this.parseAnnotations(xpp);
        }
        if (type.equals("CAPABILITY")) {
            return this.parseCAPABILITY(xpp);
        }
        if (type.equals("CLUSTER")) {
            return this.parseCLUSTER(xpp);
        }
        if (type.equals("CODE_PHRASE")) {
            return this.parseCODE_PHRASE(xpp);
        }
        if (type.equals("COMPOSITION")) {
            return this.parseCOMPOSITION(xpp);
        }
        if (type.equals("CONTACT")) {
            return this.parseCONTACT(xpp);
        }
        if (type.equals("CONTRIBUTION")) {
            return this.parseCONTRIBUTION(xpp);
        }
        if (type.equals("DV_BOOLEAN")) {
            return this.parseDV_BOOLEAN(xpp);
        }
        if (type.equals("DV_CODED_TEXT")) {
            return this.parseDV_CODED_TEXT(xpp);
        }
        if (type.equals("DV_COUNT")) {
            return this.parseDV_COUNT(xpp);
        }
        if (type.equals("DV_DATE_TIME")) {
            return this.parseDV_DATE_TIME(xpp);
        }
        if (type.equals("DV_DATE")) {
            return this.parseDV_DATE(xpp);
        }
        if (type.equals("DV_DURATION")) {
            return this.parseDV_DURATION(xpp);
        }
        if (type.equals("DV_EHR_URI")) {
            return this.parseDV_EHR_URI(xpp);
        }
        if (type.equals("DV_GENERAL_TIME_SPECIFICATION")) {
            return this.parseDV_GENERAL_TIME_SPECIFICATION(xpp);
        }
        if (type.equals("DV_IDENTIFIER")) {
            return this.parseDV_IDENTIFIER(xpp);
        }
        if (type.equals("DV_INTERVAL")) {
            return this.parseDV_INTERVAL(xpp);
        }
        if (type.equals("DV_MULTIMEDIA")) {
            return this.parseDV_MULTIMEDIA(xpp);
        }
        if (type.equals("DV_ORDINAL")) {
            return this.parseDV_ORDINAL(xpp);
        }
        if (type.equals("DV_PARAGRAPH")) {
            return this.parseDV_PARAGRAPH(xpp);
        }
        if (type.equals("DV_PARSABLE")) {
            return this.parseDV_PARSABLE(xpp);
        }
        if (type.equals("DV_PERIODIC_TIME_SPECIFICATION")) {
            return this.parseDV_PERIODIC_TIME_SPECIFICATION(xpp);
        }
        if (type.equals("DV_PROPORTION")) {
            return this.parseDV_PROPORTION(xpp);
        }
        if (type.equals("DV_QUANTITY")) {
            return this.parseDV_QUANTITY(xpp);
        }
        if (type.equals("DV_SCALE")) {
            return this.parseDV_SCALE(xpp);
        }
        if (type.equals("DV_STATE")) {
            return this.parseDV_STATE(xpp);
        }
        if (type.equals("DV_TEXT")) {
            return this.parseDV_TEXT(xpp);
        }
        if (type.equals("DV_TIME")) {
            return this.parseDV_TIME(xpp);
        }
        if (type.equals("DV_URI")) {
            return this.parseDV_URI(xpp);
        }
        if (type.equals("EHR_ACCESS")) {
            return this.parseEHR_ACCESS(xpp);
        }
        if (type.equals("EHR_STATUS")) {
            return this.parseEHR_STATUS(xpp);
        }
        if (type.equals("EHR")) {
            return this.parseEHR(xpp);
        }
        if (type.equals("ELEMENT")) {
            return this.parseELEMENT(xpp);
        }
        if (type.equals("EVALUATION")) {
            return this.parseEVALUATION(xpp);
        }
        if (type.equals("EVENT_CONTEXT")) {
            return this.parseEVENT_CONTEXT(xpp);
        }
        if (type.equals("FEEDER_AUDIT_DETAILS")) {
            return this.parseFEEDER_AUDIT_DETAILS(xpp);
        }
        if (type.equals("FEEDER_AUDIT")) {
            return this.parseFEEDER_AUDIT(xpp);
        }
        if (type.equals("FOLDER")) {
            return this.parseFOLDER(xpp);
        }
        if (type.equals("GENERIC_ID")) {
            return this.parseGENERIC_ID(xpp);
        }
        if (type.equals("GROUP")) {
            return this.parseGROUP(xpp);
        }
        if (type.equals("HIER_OBJECT_ID")) {
            return this.parseHIER_OBJECT_ID(xpp);
        }
        if (type.equals("HISTORY")) {
            return this.parseHISTORY(xpp);
        }
        if (type.equals("IMPORTED_VERSION")) {
            return this.parseIMPORTED_VERSION(xpp);
        }
        if (type.equals("INSTRUCTION_DETAILS")) {
            return this.parseINSTRUCTION_DETAILS(xpp);
        }
        if (type.equals("INSTRUCTION")) {
            return this.parseINSTRUCTION(xpp);
        }
        if (type.equals("INTERNET_ID")) {
            return this.parseINTERNET_ID(xpp);
        }
        if (type.equals("INTERVAL_EVENT")) {
            return this.parseINTERVAL_EVENT(xpp);
        }
        if (type.equals("ISM_TRANSITION")) {
            return this.parseISM_TRANSITION(xpp);
        }
        if (type.equals("ISO_OID")) {
            return this.parseISO_OID(xpp);
        }
        if (type.equals("ITEM_LIST")) {
            return this.parseITEM_LIST(xpp);
        }
        if (type.equals("ITEM_SINGLE")) {
            return this.parseITEM_SINGLE(xpp);
        }
        if (type.equals("ITEM_TABLE")) {
            return this.parseITEM_TABLE(xpp);
        }
        if (type.equals("ITEM_TAG")) {
            return this.parseITEM_TAG(xpp);
        }
        if (type.equals("ITEM_TREE")) {
            return this.parseITEM_TREE(xpp);
        }
        if (type.equals("LINK")) {
            return this.parseLINK(xpp);
        }
        if (type.equals("LOCATABLE_REF")) {
            return this.parseLOCATABLE_REF(xpp);
        }
        if (type.equals("OBJECT_REF")) {
            return this.parseOBJECT_REF(xpp);
        }
        if (type.equals("OBJECT_VERSION_ID")) {
            return this.parseOBJECT_VERSION_ID(xpp);
        }
        if (type.equals("OBSERVATION")) {
            return this.parseOBSERVATION(xpp);
        }
        if (type.equals("ORGANISATION")) {
            return this.parseORGANISATION(xpp);
        }
        if (type.equals("ORIGINAL_VERSION")) {
            return this.parseORIGINAL_VERSION(xpp);
        }
        if (type.equals("PARTICIPATION")) {
            return this.parsePARTICIPATION(xpp);
        }
        if (type.equals("PARTY_IDENTIFIED")) {
            return this.parsePARTY_IDENTIFIED(xpp);
        }
        if (type.equals("PARTY_IDENTITY")) {
            return this.parsePARTY_IDENTITY(xpp);
        }
        if (type.equals("PARTY_REF")) {
            return this.parsePARTY_REF(xpp);
        }
        if (type.equals("PARTY_RELATED")) {
            return this.parsePARTY_RELATED(xpp);
        }
        if (type.equals("PARTY_RELATIONSHIP")) {
            return this.parsePARTY_RELATIONSHIP(xpp);
        }
        if (type.equals("PARTY_SELF")) {
            return this.parsePARTY_SELF(xpp);
        }
        if (type.equals("PERSON")) {
            return this.parsePERSON(xpp);
        }
        if (type.equals("POINT_EVENT")) {
            return this.parsePOINT_EVENT(xpp);
        }
        if (type.equals("REFERENCE_RANGE")) {
            return this.parseREFERENCE_RANGE(xpp);
        }
        if (type.equals("RESOURCE_DESCRIPTION_ITEM")) {
            return this.parseRESOURCE_DESCRIPTION_ITEM(xpp);
        }
        if (type.equals("RESOURCE_DESCRIPTION")) {
            return this.parseRESOURCE_DESCRIPTION(xpp);
        }
        if (type.equals("REVISION_HISTORY_ITEM")) {
            return this.parseREVISION_HISTORY_ITEM(xpp);
        }
        if (type.equals("REVISION_HISTORY")) {
            return this.parseREVISION_HISTORY(xpp);
        }
        if (type.equals("ROLE")) {
            return this.parseROLE(xpp);
        }
        if (type.equals("SECTION")) {
            return this.parseSECTION(xpp);
        }
        if (type.equals("TEMPLATE_ID")) {
            return this.parseTEMPLATE_ID(xpp);
        }
        if (type.equals("TERM_MAPPING")) {
            return this.parseTERM_MAPPING(xpp);
        }
        if (type.equals("TERMINOLOGY_ID")) {
            return this.parseTERMINOLOGY_ID(xpp);
        }
        if (type.equals("TRANSLATION_DETAILS")) {
            return this.parseTRANSLATION_DETAILS(xpp);
        }
        if (type.equals("TranslatedString")) {
            return this.parseTranslatedString(xpp);
        }
        if (type.equals("UUID")) {
            return this.parseUUID(xpp);
        }
        if (type.equals("VERSION_TREE_ID")) {
            return this.parseVERSION_TREE_ID(xpp);
        }
        if (type.equals("VERSIONED_COMPOSITION")) {
            return this.parseVERSIONED_COMPOSITION(xpp);
        }
        if (type.equals("VERSIONED_EHR_ACCESS")) {
            return this.parseVERSIONED_EHR_ACCESS(xpp);
        }
        if (type.equals("VERSIONED_EHR_STATUS")) {
            return this.parseVERSIONED_EHR_STATUS(xpp);
        }
        if (type.equals("VERSIONED_FOLDER")) {
            return this.parseVERSIONED_FOLDER(xpp);
        }
        if (type.equals("VERSIONED_OBJECT")) {
            return this.parseVERSIONED_OBJECT(xpp);
        }
        if (type.equals("VERSIONED_PARTY")) {
            return this.parseVERSIONED_PARTY(xpp);
        }
        if (type.equals("WebTemplate")) {
            return this.parseWebTemplate(xpp);
        }
        if (type.equals("WebTemplateInput")) {
            return this.parseWebTemplateInput(xpp);
        }
        if (type.equals("WebTemplateInputListItem")) {
            return this.parseWebTemplateInputListItem(xpp);
        }
        if (type.equals("WebTemplateInputValidation")) {
            return this.parseWebTemplateInputValidation(xpp);
        }
        if (type.equals("WebTemplateInputValidationRange")) {
            return this.parseWebTemplateInputValidationRange(xpp);
        }
        if (type.equals("WebTemplateItem")) {
            return this.parseWebTemplateItem(xpp);
        }
        if (type.equals("WebTemplateTermBinding")) {
            return this.parseWebTemplateTermBinding(xpp);
        }
        if (type.equals("WebTemplateTermBindingValue")) {
            return this.parseWebTemplateTermBindingValue(xpp);
        }
        if (type.equals("date")) {
            return this.parseDate(xpp);
        }
        if (type.equals("dateTime")) {
            return this.parseDateTime(xpp);
        }
        if (type.equals("code")) {
            return this.parseCode(xpp);
        }
        if (type.equals("string")) {
            return this.parseString(xpp);
        }
        if (type.equals("integer")) {
            return this.parseInteger(xpp);
        }
        if (type.equals("integer64")) {
            return this.parseInteger64(xpp);
        }
        if (type.equals("oid")) {
            return this.parseOid(xpp);
        }
        if (type.equals("canonical")) {
            return this.parseCanonical(xpp);
        }
        if (type.equals("uri")) {
            return this.parseUri(xpp);
        }
        if (type.equals("uuid")) {
            return this.parseUuid(xpp);
        }
        if (type.equals("url")) {
            return this.parseUrl(xpp);
        }
        if (type.equals("instant")) {
            return this.parseInstant(xpp);
        }
        if (type.equals("boolean")) {
            return this.parseBoolean(xpp);
        }
        if (type.equals("base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (type.equals("unsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (type.equals("markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (type.equals("time")) {
            return this.parseTime(xpp);
        }
        if (type.equals("id")) {
            return this.parseId(xpp);
        }
        if (type.equals("positiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (type.equals("decimal")) {
            return this.parseDecimal(xpp);
        }
        throw new FHIRFormatError("Unknown type " + type);
    }

    private boolean nameIsTypeName(XmlPullParser xpp, String prefix) throws IOException {
        if (prefix == null) {
            throw new IOException("prefix == null!");
        }
        if (xpp == null) {
            throw new IOException("xpp == null!");
        }
        if (xpp.getName().equals(prefix + "ACTION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ACTIVITY")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ADDRESS")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ADMIN_ENTRY")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "AGENT")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ARCHETYPE_ID")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ARCHETYPED")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ATTESTATION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "AUDIT_DETAILS")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Annotations")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CAPABILITY")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CLUSTER")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CODE_PHRASE")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "COMPOSITION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CONTACT")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CONTRIBUTION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_BOOLEAN")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_CODED_TEXT")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_COUNT")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_DATE_TIME")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_DATE")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_DURATION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_EHR_URI")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_GENERAL_TIME_SPECIFICATION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_IDENTIFIER")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_INTERVAL")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_MULTIMEDIA")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_ORDINAL")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_PARAGRAPH")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_PARSABLE")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_PERIODIC_TIME_SPECIFICATION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_PROPORTION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_QUANTITY")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_SCALE")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_STATE")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_TEXT")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_TIME")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DV_URI")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EHR_ACCESS")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EHR_STATUS")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EHR")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ELEMENT")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EVALUATION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "EVENT_CONTEXT")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "FEEDER_AUDIT_DETAILS")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "FEEDER_AUDIT")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "FOLDER")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "GENERIC_ID")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "GROUP")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "HIER_OBJECT_ID")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "HISTORY")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "IMPORTED_VERSION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "INSTRUCTION_DETAILS")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "INSTRUCTION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "INTERNET_ID")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "INTERVAL_EVENT")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ISM_TRANSITION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ISO_OID")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ITEM_LIST")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ITEM_SINGLE")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ITEM_TABLE")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ITEM_TAG")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ITEM_TREE")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "LINK")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "LOCATABLE_REF")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "OBJECT_REF")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "OBJECT_VERSION_ID")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "OBSERVATION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ORGANISATION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ORIGINAL_VERSION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PARTICIPATION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PARTY_IDENTIFIED")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PARTY_IDENTITY")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PARTY_REF")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PARTY_RELATED")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PARTY_RELATIONSHIP")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PARTY_SELF")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PERSON")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "POINT_EVENT")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "REFERENCE_RANGE")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "RESOURCE_DESCRIPTION_ITEM")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "RESOURCE_DESCRIPTION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "REVISION_HISTORY_ITEM")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "REVISION_HISTORY")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "ROLE")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "SECTION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "TEMPLATE_ID")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "TERM_MAPPING")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "TERMINOLOGY_ID")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "TRANSLATION_DETAILS")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "TranslatedString")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "UUID")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "VERSION_TREE_ID")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "VERSIONED_COMPOSITION")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "VERSIONED_EHR_ACCESS")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "VERSIONED_EHR_STATUS")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "VERSIONED_FOLDER")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "VERSIONED_OBJECT")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "VERSIONED_PARTY")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "WebTemplate")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "WebTemplateInput")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "WebTemplateInputListItem")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "WebTemplateInputValidation")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "WebTemplateInputValidationRange")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "WebTemplateItem")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "WebTemplateTermBinding")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "WebTemplateTermBindingValue")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Date")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DateTime")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Code")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "String")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Integer")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Integer64")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Oid")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Canonical")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Uri")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Uuid")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Url")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Instant")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Boolean")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Base64Binary")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "UnsignedInt")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Markdown")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Time")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Id")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PositiveInt")) {
            return true;
        }
        return xpp.getName().equals(prefix + "Decimal");
    }

    @Override
    protected DataType parseAnyType(XmlPullParser xpp, String type) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseType(xpp, type);
    }

    protected void composeACCESS_CONTROL_SETTINGS(String name, ACCESS_CONTROL_SETTINGS element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                default: 
            }
            throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
        }
    }

    protected void composeACCESS_CONTROL_SETTINGSElements(ACCESS_CONTROL_SETTINGS element) throws IOException {
        this.composeBaseElements(element);
    }

    protected void composeACTOR(String name, ACTOR element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "AGENT": {
                    this.composeAGENT(name, (AGENT)element);
                    break;
                }
                case "GROUP": {
                    this.composeGROUP(name, (GROUP)element);
                    break;
                }
                case "PERSON": {
                    this.composePERSON(name, (PERSON)element);
                    break;
                }
                case "ORGANISATION": {
                    this.composeORGANISATION(name, (ORGANISATION)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeACTORElements(ACTOR element) throws IOException {
        this.composePARTYElements(element);
        if (element.hasLanguages()) {
            for (DV_TEXT dV_TEXT : element.getLanguagesList()) {
                this.composeDV_TEXT("languages", dV_TEXT);
            }
        }
        if (element.hasRoles()) {
            for (PARTY_REF pARTY_REF : element.getRolesList()) {
                this.composePARTY_REF("roles", pARTY_REF);
            }
        }
    }

    protected void composeAUTHORED_RESOURCE(String name, AUTHORED_RESOURCE element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                default: 
            }
            throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
        }
    }

    protected void composeAUTHORED_RESOURCEElements(AUTHORED_RESOURCE element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasOriginal_language()) {
            this.composeCODE_PHRASE("original_language", element.getOriginal_language());
        }
        if (element.hasIs_controlledElement()) {
            this.composeBoolean("is_controlled", element.getIs_controlledElement());
        }
        if (element.hasTranslations()) {
            for (TRANSLATION_DETAILS e : element.getTranslationsList()) {
                this.composeTRANSLATION_DETAILS("translations", e);
            }
        }
        if (element.hasDescription()) {
            this.composeRESOURCE_DESCRIPTION("description", element.getDescription());
        }
        if (element.hasRevision_history()) {
            this.composeREVISION_HISTORY("revision_history", element.getRevision_history());
        }
    }

    protected void composeAny(String name, Any element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "EHR": {
                    this.composeEHR(name, (EHR)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeAnyElements(Any element) throws IOException {
        this.composeBaseElements(element);
    }

    protected void composeCARE_ENTRY(String name, CARE_ENTRY element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "INSTRUCTION": {
                    this.composeINSTRUCTION(name, (INSTRUCTION)element);
                    break;
                }
                case "OBSERVATION": {
                    this.composeOBSERVATION(name, (OBSERVATION)element);
                    break;
                }
                case "ACTION": {
                    this.composeACTION(name, (ACTION)element);
                    break;
                }
                case "EVALUATION": {
                    this.composeEVALUATION(name, (EVALUATION)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeCARE_ENTRYElements(CARE_ENTRY element) throws IOException {
        this.composeENTRYElements(element);
        if (element.hasProtocol()) {
            this.composeITEM_STRUCTURE("protocol", element.getProtocol());
        }
        if (element.hasGuideline_id()) {
            this.composeOBJECT_REF("guideline_id", element.getGuideline_id());
        }
    }

    protected void composeCONTENT_ITEM(String name, CONTENT_ITEM element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "SECTION": {
                    this.composeSECTION(name, (SECTION)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeCONTENT_ITEMElements(CONTENT_ITEM element) throws IOException {
        this.composeLOCATABLEElements(element);
    }

    protected void composeDATA_STRUCTURE(String name, DATA_STRUCTURE element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "HISTORY": {
                    this.composeHISTORY(name, (HISTORY)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDATA_STRUCTUREElements(DATA_STRUCTURE element) throws IOException {
        this.composeLOCATABLEElements(element);
    }

    protected void composeDATA_VALUE(String name, DATA_VALUE element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "DV-TEXT": {
                    this.composeDV_TEXT(name, (DV_TEXT)element);
                    break;
                }
                case "DV-IDENTIFIER": {
                    this.composeDV_IDENTIFIER(name, (DV_IDENTIFIER)element);
                    break;
                }
                case "DV-BOOLEAN": {
                    this.composeDV_BOOLEAN(name, (DV_BOOLEAN)element);
                    break;
                }
                case "DV-PARAGRAPH": {
                    this.composeDV_PARAGRAPH(name, (DV_PARAGRAPH)element);
                    break;
                }
                case "DV-URI": {
                    this.composeDV_URI(name, (DV_URI)element);
                    break;
                }
                case "DV-STATE": {
                    this.composeDV_STATE(name, (DV_STATE)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDATA_VALUEElements(DATA_VALUE element) throws IOException {
        this.composeBaseElements(element);
    }

    protected void composeDV_ABSOLUTE_QUANTITY(String name, DV_ABSOLUTE_QUANTITY element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                default: 
            }
            throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
        }
    }

    protected void composeDV_ABSOLUTE_QUANTITYElements(DV_ABSOLUTE_QUANTITY element) throws IOException {
        this.composeDV_QUANTIFIEDElements(element);
    }

    protected void composeDV_AMOUNT(String name, DV_AMOUNT element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "DV-DURATION": {
                    this.composeDV_DURATION(name, (DV_DURATION)element);
                    break;
                }
                case "DV-COUNT": {
                    this.composeDV_COUNT(name, (DV_COUNT)element);
                    break;
                }
                case "DV-PROPORTION": {
                    this.composeDV_PROPORTION(name, (DV_PROPORTION)element);
                    break;
                }
                case "DV-QUANTITY": {
                    this.composeDV_QUANTITY(name, (DV_QUANTITY)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDV_AMOUNTElements(DV_AMOUNT element) throws IOException {
        this.composeDV_QUANTIFIEDElements(element);
        if (element.hasAccuracy_is_percentElement()) {
            this.composeBoolean("accuracy_is_percent", element.getAccuracy_is_percentElement());
        }
    }

    protected void composeDV_ENCAPSULATED(String name, DV_ENCAPSULATED element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "DV-MULTIMEDIA": {
                    this.composeDV_MULTIMEDIA(name, (DV_MULTIMEDIA)element);
                    break;
                }
                case "DV-PARSABLE": {
                    this.composeDV_PARSABLE(name, (DV_PARSABLE)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDV_ENCAPSULATEDElements(DV_ENCAPSULATED element) throws IOException {
        this.composeDV_AMOUNTElements(element);
        if (element.hasCharset()) {
            this.composeCODE_PHRASE("charset", element.getCharset());
        }
        if (element.hasLanguage()) {
            this.composeCODE_PHRASE("language", element.getLanguage());
        }
    }

    protected void composeDV_ORDERED(String name, DV_ORDERED element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "DV-DATE-TIME": {
                    this.composeDV_DATE_TIME(name, (DV_DATE_TIME)element);
                    break;
                }
                case "DV-TIME": {
                    this.composeDV_TIME(name, (DV_TIME)element);
                    break;
                }
                case "DV-INTERVAL": {
                    this.composeDV_INTERVAL(name, (DV_INTERVAL)element);
                    break;
                }
                case "DV-ORDINAL": {
                    this.composeDV_ORDINAL(name, (DV_ORDINAL)element);
                    break;
                }
                case "DV-SCALE": {
                    this.composeDV_SCALE(name, (DV_SCALE)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDV_ORDEREDElements(DV_ORDERED element) throws IOException {
        this.composeDATA_VALUEElements(element);
        if (element.hasNormal_status()) {
            this.composeCODE_PHRASE("normal_status", element.getNormal_status());
        }
        if (element.hasNormal_range()) {
            this.composeDV_INTERVAL("normal_range", element.getNormal_range());
        }
        if (element.hasOther_reference_ranges()) {
            for (REFERENCE_RANGE e : element.getOther_reference_rangesList()) {
                this.composeREFERENCE_RANGE("other_reference_ranges", e);
            }
        }
    }

    protected void composeDV_QUANTIFIED(String name, DV_QUANTIFIED element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                default: 
            }
            throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
        }
    }

    protected void composeDV_QUANTIFIEDElements(DV_QUANTIFIED element) throws IOException {
        this.composeDV_ORDEREDElements(element);
        if (element.hasMagnitude_statusElement()) {
            this.composeString("magnitude_status", element.getMagnitude_statusElement());
        }
        if (element.hasAccuracy()) {
            this.composeBase("accuracy", element.getAccuracy());
        }
    }

    protected void composeDV_TEMPORAL(String name, DV_TEMPORAL element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "DV-DATE": {
                    this.composeDV_DATE(name, (DV_DATE)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDV_TEMPORALElements(DV_TEMPORAL element) throws IOException {
        this.composeDV_ABSOLUTE_QUANTITYElements(element);
    }

    protected void composeDV_TIME_SPECIFICATION(String name, DV_TIME_SPECIFICATION element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "DV-GENERAL-TIME-SPECIFICATION": {
                    this.composeDV_GENERAL_TIME_SPECIFICATION(name, (DV_GENERAL_TIME_SPECIFICATION)element);
                    break;
                }
                case "DV-PERIODIC-TIME-SPECIFICATION": {
                    this.composeDV_PERIODIC_TIME_SPECIFICATION(name, (DV_PERIODIC_TIME_SPECIFICATION)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeDV_TIME_SPECIFICATIONElements(DV_TIME_SPECIFICATION element) throws IOException {
        this.composeDATA_VALUEElements(element);
        if (element.hasDV_PARSABLEElement()) {
            this.composeString("DV_PARSABLE", element.getDV_PARSABLEElement());
        }
    }

    protected void composeENTRY(String name, ENTRY element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "ADMIN-ENTRY": {
                    this.composeADMIN_ENTRY(name, (ADMIN_ENTRY)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeENTRYElements(ENTRY element) throws IOException {
        this.composeCONTENT_ITEMElements(element);
        if (element.hasLanguage()) {
            this.composeCODE_PHRASE("language", element.getLanguage());
        }
        if (element.hasEncoding()) {
            this.composeCODE_PHRASE("encoding", element.getEncoding());
        }
        if (element.hasOther_participations()) {
            for (PARTICIPATION e : element.getOther_participationsList()) {
                this.composePARTICIPATION("other_participations", e);
            }
        }
        if (element.hasWorkflow_id()) {
            this.composeOBJECT_REF("workflow_id", element.getWorkflow_id());
        }
        if (element.hasSubject()) {
            this.composePARTY_PROXY("subject", element.getSubject());
        }
        if (element.hasProvider()) {
            this.composePARTY_PROXY("provider", element.getProvider());
        }
    }

    protected void composeEVENT(String name, EVENT element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "INTERVAL-EVENT": {
                    this.composeINTERVAL_EVENT(name, (INTERVAL_EVENT)element);
                    break;
                }
                case "POINT-EVENT": {
                    this.composePOINT_EVENT(name, (POINT_EVENT)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeEVENTElements(EVENT element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasTime()) {
            this.composeDV_DATE_TIME("time", element.getTime());
        }
        if (element.hasState()) {
            this.composeITEM_STRUCTURE("state", element.getState());
        }
        if (element.hasData()) {
            this.composeAny("data", element.getData());
        }
    }

    protected void composeITEM_STRUCTURE(String name, ITEM_STRUCTURE element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "ITEM-SINGLE": {
                    this.composeITEM_SINGLE(name, (ITEM_SINGLE)element);
                    break;
                }
                case "ITEM-TREE": {
                    this.composeITEM_TREE(name, (ITEM_TREE)element);
                    break;
                }
                case "ITEM-TABLE": {
                    this.composeITEM_TABLE(name, (ITEM_TABLE)element);
                    break;
                }
                case "ITEM-LIST": {
                    this.composeITEM_LIST(name, (ITEM_LIST)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeITEM_STRUCTUREElements(ITEM_STRUCTURE element) throws IOException {
        this.composeDATA_STRUCTUREElements(element);
    }

    protected void composeITEM(String name, ITEM element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "ELEMENT": {
                    this.composeELEMENT(name, (ELEMENT)element);
                    break;
                }
                case "CLUSTER": {
                    this.composeCLUSTER(name, (CLUSTER)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeITEMElements(ITEM element) throws IOException {
        this.composeLOCATABLEElements(element);
    }

    protected void composeLOCATABLE(String name, LOCATABLE element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "CONTACT": {
                    this.composeCONTACT(name, (CONTACT)element);
                    break;
                }
                case "EVENT-CONTEXT": {
                    this.composeEVENT_CONTEXT(name, (EVENT_CONTEXT)element);
                    break;
                }
                case "EHR-STATUS": {
                    this.composeEHR_STATUS(name, (EHR_STATUS)element);
                    break;
                }
                case "PARTY-IDENTITY": {
                    this.composePARTY_IDENTITY(name, (PARTY_IDENTITY)element);
                    break;
                }
                case "ADDRESS": {
                    this.composeADDRESS(name, (ADDRESS)element);
                    break;
                }
                case "COMPOSITION": {
                    this.composeCOMPOSITION(name, (COMPOSITION)element);
                    break;
                }
                case "PARTY-RELATIONSHIP": {
                    this.composePARTY_RELATIONSHIP(name, (PARTY_RELATIONSHIP)element);
                    break;
                }
                case "CAPABILITY": {
                    this.composeCAPABILITY(name, (CAPABILITY)element);
                    break;
                }
                case "EHR-ACCESS": {
                    this.composeEHR_ACCESS(name, (EHR_ACCESS)element);
                    break;
                }
                case "ACTIVITY": {
                    this.composeACTIVITY(name, (ACTIVITY)element);
                    break;
                }
                case "FOLDER": {
                    this.composeFOLDER(name, (FOLDER)element);
                    break;
                }
                case "PARTICIPATION": {
                    this.composePARTICIPATION(name, (PARTICIPATION)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeLOCATABLEElements(LOCATABLE element) throws IOException {
        this.composePATHABLEElements(element);
    }

    protected void composeOBJECT_ID(String name, OBJECT_ID element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "TEMPLATE-ID": {
                    this.composeTEMPLATE_ID(name, (TEMPLATE_ID)element);
                    break;
                }
                case "ARCHETYPE-ID": {
                    this.composeARCHETYPE_ID(name, (ARCHETYPE_ID)element);
                    break;
                }
                case "GENERIC-ID": {
                    this.composeGENERIC_ID(name, (GENERIC_ID)element);
                    break;
                }
                case "TERMINOLOGY-ID": {
                    this.composeTERMINOLOGY_ID(name, (TERMINOLOGY_ID)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeOBJECT_IDElements(OBJECT_ID element) throws IOException {
        this.composeUIDElements(element);
    }

    protected void composePARTY_PROXY(String name, PARTY_PROXY element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "PARTY-SELF": {
                    this.composePARTY_SELF(name, (PARTY_SELF)element);
                    break;
                }
                case "PARTY-IDENTIFIED": {
                    this.composePARTY_IDENTIFIED(name, (PARTY_IDENTIFIED)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composePARTY_PROXYElements(PARTY_PROXY element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasExternal_ref()) {
            this.composePARTY_REF("external_ref", element.getExternal_ref());
        }
    }

    protected void composePARTY(String name, PARTY element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "ROLE": {
                    this.composeROLE(name, (ROLE)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composePARTYElements(PARTY element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasIdentities()) {
            for (PARTY_IDENTITY pARTY_IDENTITY : element.getIdentitiesList()) {
                this.composePARTY_IDENTITY("identities", pARTY_IDENTITY);
            }
        }
        if (element.hasContacts()) {
            this.composeCONTACT("contacts", element.getContacts());
        }
        if (element.hasDetails()) {
            this.composeITEM_STRUCTURE("details", element.getDetails());
        }
        if (element.hasReverse_relationships()) {
            for (LOCATABLE_REF lOCATABLE_REF : element.getReverse_relationshipsList()) {
                this.composeLOCATABLE_REF("reverse_relationships", lOCATABLE_REF);
            }
        }
        if (element.hasRelationships()) {
            for (PARTY_RELATIONSHIP pARTY_RELATIONSHIP : element.getRelationshipsList()) {
                this.composePARTY_RELATIONSHIP("relationships", pARTY_RELATIONSHIP);
            }
        }
    }

    protected void composePATHABLE(String name, PATHABLE element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "INSTRUCTION-DETAILS": {
                    this.composeINSTRUCTION_DETAILS(name, (INSTRUCTION_DETAILS)element);
                    break;
                }
                case "ISM-TRANSITION": {
                    this.composeISM_TRANSITION(name, (ISM_TRANSITION)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composePATHABLEElements(PATHABLE element) throws IOException {
        this.composeAnyElements(element);
        if (element.hasName()) {
            this.composeDV_TEXT("name", element.getName());
        }
        if (element.hasArchetype_node_idElement()) {
            this.composeString("archetype_node_id", element.getArchetype_node_idElement());
        }
        if (element.hasUid()) {
            this.composeUID_BASED_ID("uid", element.getUid());
        }
        if (element.hasLinks()) {
            for (LINK e : element.getLinksList()) {
                this.composeLINK("links", e);
            }
        }
        if (element.hasArchetype_details()) {
            this.composeARCHETYPED("archetype_details", element.getArchetype_details());
        }
        if (element.hasFeeder_audit()) {
            this.composeFEEDER_AUDIT("feeder_audit", element.getFeeder_audit());
        }
    }

    protected void composeUID_BASED_ID(String name, UID_BASED_ID element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "OBJECT-VERSION-ID": {
                    this.composeOBJECT_VERSION_ID(name, (OBJECT_VERSION_ID)element);
                    break;
                }
                case "HIER-OBJECT-ID": {
                    this.composeHIER_OBJECT_ID(name, (HIER_OBJECT_ID)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeUID_BASED_IDElements(UID_BASED_ID element) throws IOException {
        this.composeOBJECT_IDElements(element);
    }

    protected void composeUID(String name, UID element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "ISO-OID": {
                    this.composeISO_OID(name, (ISO_OID)element);
                    break;
                }
                case "UUID": {
                    this.composeUUID(name, (UUID)element);
                    break;
                }
                case "INTERNET-ID": {
                    this.composeINTERNET_ID(name, (INTERNET_ID)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeUIDElements(UID element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasValueElement()) {
            this.composeString("value", element.getValueElement());
        }
    }

    protected void composeVERSION(String name, VERSION element) throws IOException {
        if (element != null) {
            this.xml.attribute("xsi:type", element.fhirType());
            switch (element.fhirType()) {
                case "IMPORTED-VERSION": {
                    this.composeIMPORTED_VERSION(name, (IMPORTED_VERSION)element);
                    break;
                }
                case "ORIGINAL-VERSION": {
                    this.composeORIGINAL_VERSION(name, (ORIGINAL_VERSION)element);
                    break;
                }
                default: {
                    throw new FHIRException("Unsupported type '" + element.fhirType() + "'");
                }
            }
        }
    }

    protected void composeVERSIONElements(VERSION element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasContribution()) {
            this.composeOBJECT_REF("contribution", element.getContribution());
        }
        if (element.hasSignatureElement()) {
            this.composeString("signature", element.getSignatureElement());
        }
        if (element.hasCommit_audit()) {
            this.composeAUDIT_DETAILS("commit_audit", element.getCommit_audit());
        }
    }

    protected void composeACTION(String name, ACTION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeACTIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeACTIONElements(ACTION element) throws IOException {
        this.composeCARE_ENTRYElements(element);
        if (element.hasTime()) {
            this.composeDV_DATE_TIME("time", element.getTime());
        }
        if (element.hasIsm_transition()) {
            this.composeISM_TRANSITION("ism_transition", element.getIsm_transition());
        }
        if (element.hasInstruction_details()) {
            this.composeINSTRUCTION_DETAILS("instruction_details", element.getInstruction_details());
        }
        if (element.hasDescription()) {
            this.composeITEM_STRUCTURE("description", element.getDescription());
        }
    }

    protected void composeACTIVITY(String name, ACTIVITY element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeACTIVITYElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeACTIVITYElements(ACTIVITY element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasTiming()) {
            this.composeDV_PARSABLE("timing", element.getTiming());
        }
        if (element.hasAction_archetype_idElement()) {
            this.composeString("action_archetype_id", element.getAction_archetype_idElement());
        }
        if (element.hasDescription()) {
            this.composeITEM_STRUCTURE("description", element.getDescription());
        }
    }

    protected void composeADDRESS(String name, ADDRESS element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeADDRESSElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeADDRESSElements(ADDRESS element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasDetails()) {
            this.composeITEM_STRUCTURE("details", element.getDetails());
        }
    }

    protected void composeADMIN_ENTRY(String name, ADMIN_ENTRY element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeADMIN_ENTRYElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeADMIN_ENTRYElements(ADMIN_ENTRY element) throws IOException {
        this.composeENTRYElements(element);
        if (element.hasData()) {
            this.composeITEM_STRUCTURE("data", element.getData());
        }
    }

    protected void composeAGENT(String name, AGENT element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeAGENTElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAGENTElements(AGENT element) throws IOException {
        this.composeACTORElements(element);
    }

    protected void composeARCHETYPE_ID(String name, ARCHETYPE_ID element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeARCHETYPE_IDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeARCHETYPE_IDElements(ARCHETYPE_ID element) throws IOException {
        this.composeOBJECT_IDElements(element);
    }

    protected void composeARCHETYPED(String name, ARCHETYPED element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeARCHETYPEDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeARCHETYPEDElements(ARCHETYPED element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasArchetype_id()) {
            this.composeARCHETYPE_ID("archetype_id", element.getArchetype_id());
        }
        if (element.hasTemplate_id()) {
            this.composeTEMPLATE_ID("template_id", element.getTemplate_id());
        }
        if (element.hasRm_versionElement()) {
            this.composeString("rm_version", element.getRm_versionElement());
        }
    }

    protected void composeATTESTATION(String name, ATTESTATION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeATTESTATIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeATTESTATIONElements(ATTESTATION element) throws IOException {
        this.composeAUDIT_DETAILSElements(element);
        if (element.hasAttested_view()) {
            this.composeDV_MULTIMEDIA("attested_view", element.getAttested_view());
        }
        if (element.hasProofElement()) {
            this.composeString("proof", element.getProofElement());
        }
        if (element.hasItems()) {
            for (DV_EHR_URI e : element.getItemsList()) {
                this.composeDV_EHR_URI("items", e);
            }
        }
        if (element.hasReason()) {
            this.composeDV_TEXT("reason", element.getReason());
        }
        if (element.hasIs_pendingElement()) {
            this.composeBoolean("is_pending", element.getIs_pendingElement());
        }
    }

    protected void composeAUDIT_DETAILS(String name, AUDIT_DETAILS element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeAUDIT_DETAILSElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAUDIT_DETAILSElements(AUDIT_DETAILS element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasSystem_idElement()) {
            this.composeString("system_id", element.getSystem_idElement());
        }
        if (element.hasTime_committed()) {
            this.composeDV_DATE_TIME("time_committed", element.getTime_committed());
        }
        if (element.hasChange_type()) {
            this.composeDV_CODED_TEXT("change_type", element.getChange_type());
        }
        if (element.hasDescription()) {
            this.composeDV_TEXT("description", element.getDescription());
        }
        if (element.hasCommitter()) {
            this.composePARTY_PROXY("committer", element.getCommitter());
        }
    }

    protected void composeAnnotations(String name, Annotations element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeAnnotationsElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeAnnotationsElements(Annotations element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasCommentElement()) {
            this.composeString("comment", element.getCommentElement());
        }
        if (element.hasFhir_mappingElement()) {
            this.composeString("fhir_mapping", element.getFhir_mappingElement());
        }
        if (element.hasVset_descriptionElement()) {
            this.composeString("vset_description", element.getVset_descriptionElement());
        }
        if (element.hasHl7v2_mappingElement()) {
            this.composeString("hl7v2_mapping", element.getHl7v2_mappingElement());
        }
        if (element.hasVisibleInViewElement()) {
            this.composeString("visibleInView", element.getVisibleInViewElement());
        }
    }

    protected void composeCAPABILITY(String name, CAPABILITY element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCAPABILITYElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCAPABILITYElements(CAPABILITY element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasCredentials()) {
            this.composeITEM_STRUCTURE("credentials", element.getCredentials());
        }
        if (element.hasTime_validity()) {
            this.composeDV_INTERVAL("time_validity", element.getTime_validity());
        }
    }

    protected void composeCLUSTER(String name, CLUSTER element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCLUSTERElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCLUSTERElements(CLUSTER element) throws IOException {
        this.composeITEMElements(element);
        if (element.hasItems()) {
            for (ITEM e : element.getItemsList()) {
                this.composeITEM("items", e);
            }
        }
    }

    protected void composeCODE_PHRASE(String name, CODE_PHRASE element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCODE_PHRASEElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCODE_PHRASEElements(CODE_PHRASE element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasTerminology_id()) {
            this.composeTERMINOLOGY_ID("terminology_id", element.getTerminology_id());
        }
        if (element.hasCode_stringElement()) {
            this.composeString("code_string", element.getCode_stringElement());
        }
        if (element.hasPreferred_termElement()) {
            this.composeString("preferred_term", element.getPreferred_termElement());
        }
    }

    protected void composeCOMPOSITION(String name, COMPOSITION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCOMPOSITIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCOMPOSITIONElements(COMPOSITION element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasLanguage()) {
            this.composeCODE_PHRASE("language", element.getLanguage());
        }
        if (element.hasTerritory()) {
            this.composeCODE_PHRASE("territory", element.getTerritory());
        }
        if (element.hasCategory()) {
            this.composeDV_CODED_TEXT("category", element.getCategory());
        }
        if (element.hasContext()) {
            this.composeEVENT_CONTEXT("context", element.getContext());
        }
        if (element.hasComposer()) {
            this.composePARTY_PROXY("composer", element.getComposer());
        }
        if (element.hasContent()) {
            for (CONTENT_ITEM e : element.getContentList()) {
                this.composeCONTENT_ITEM("content", e);
            }
        }
    }

    protected void composeCONTACT(String name, CONTACT element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCONTACTElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCONTACTElements(CONTACT element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasAddresses()) {
            for (ADDRESS e : element.getAddressesList()) {
                this.composeADDRESS("addresses", e);
            }
        }
        if (element.hasTime_validity()) {
            this.composeDV_INTERVAL("time_validity", element.getTime_validity());
        }
    }

    protected void composeCONTRIBUTION(String name, CONTRIBUTION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCONTRIBUTIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCONTRIBUTIONElements(CONTRIBUTION element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasUid()) {
            this.composeHIER_OBJECT_ID("uid", element.getUid());
        }
        if (element.hasVersions()) {
            for (OBJECT_REF e : element.getVersionsList()) {
                this.composeOBJECT_REF("versions", e);
            }
        }
        if (element.hasAudit()) {
            this.composeAUDIT_DETAILS("audit", element.getAudit());
        }
    }

    protected void composeDV_BOOLEAN(String name, DV_BOOLEAN element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_BOOLEANElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_BOOLEANElements(DV_BOOLEAN element) throws IOException {
        this.composeDATA_VALUEElements(element);
        if (element.hasValueElement()) {
            this.composeBoolean("value", element.getValueElement());
        }
    }

    protected void composeDV_CODED_TEXT(String name, DV_CODED_TEXT element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_CODED_TEXTElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_CODED_TEXTElements(DV_CODED_TEXT element) throws IOException {
        this.composeDV_TEXTElements(element);
        if (element.hasDefining_code()) {
            this.composeCODE_PHRASE("defining_code", element.getDefining_code());
        }
    }

    protected void composeDV_COUNT(String name, DV_COUNT element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_COUNTElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_COUNTElements(DV_COUNT element) throws IOException {
        this.composeDV_AMOUNTElements(element);
        if (element.hasMagnitudeElement()) {
            this.composeDecimal("magnitude", element.getMagnitudeElement());
        }
    }

    protected void composeDV_DATE_TIME(String name, DV_DATE_TIME element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_DATE_TIMEElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_DATE_TIMEElements(DV_DATE_TIME element) throws IOException {
        this.composeDV_ORDEREDElements(element);
        if (element.hasValueElement()) {
            this.composeDateTime("value", element.getValueElement());
        }
    }

    protected void composeDV_DATE(String name, DV_DATE element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_DATEElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_DATEElements(DV_DATE element) throws IOException {
        this.composeDV_TEMPORALElements(element);
        if (element.hasValueElement()) {
            this.composeDateTime("value", element.getValueElement());
        }
    }

    protected void composeDV_DURATION(String name, DV_DURATION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_DURATIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_DURATIONElements(DV_DURATION element) throws IOException {
        this.composeDV_AMOUNTElements(element);
        if (element.hasValueElement()) {
            this.composeString("value", element.getValueElement());
        }
    }

    protected void composeDV_EHR_URI(String name, DV_EHR_URI element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_EHR_URIElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_EHR_URIElements(DV_EHR_URI element) throws IOException {
        this.composeDV_URIElements(element);
    }

    protected void composeDV_GENERAL_TIME_SPECIFICATION(String name, DV_GENERAL_TIME_SPECIFICATION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_GENERAL_TIME_SPECIFICATIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_GENERAL_TIME_SPECIFICATIONElements(DV_GENERAL_TIME_SPECIFICATION element) throws IOException {
        this.composeDV_TIME_SPECIFICATIONElements(element);
    }

    protected void composeDV_IDENTIFIER(String name, DV_IDENTIFIER element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_IDENTIFIERElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_IDENTIFIERElements(DV_IDENTIFIER element) throws IOException {
        this.composeDATA_VALUEElements(element);
        if (element.hasIssuerElement()) {
            this.composeString("issuer", element.getIssuerElement());
        }
        if (element.hasAssignerElement()) {
            this.composeString("assigner", element.getAssignerElement());
        }
        if (element.hasIdElement()) {
            this.composeString("id", element.getIdElement());
        }
        if (element.hasTypeElement()) {
            this.composeString("type", element.getTypeElement());
        }
    }

    protected void composeDV_INTERVAL(String name, DV_INTERVAL element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_INTERVALElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_INTERVALElements(DV_INTERVAL element) throws IOException {
        this.composeDV_ORDEREDElements(element);
    }

    protected void composeDV_MULTIMEDIA(String name, DV_MULTIMEDIA element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_MULTIMEDIAElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_MULTIMEDIAElements(DV_MULTIMEDIA element) throws IOException {
        this.composeDV_ENCAPSULATEDElements(element);
        if (element.hasAlternate_textElement()) {
            this.composeString("alternate_text", element.getAlternate_textElement());
        }
        if (element.hasUri()) {
            this.composeDV_URI("uri", element.getUri());
        }
        if (element.hasDataElement()) {
            this.composeBase64Binary("data", element.getDataElement());
        }
        if (element.hasMedia_type()) {
            this.composeCODE_PHRASE("media_type", element.getMedia_type());
        }
        if (element.hasCompression_algorithm()) {
            this.composeCODE_PHRASE("compression_algorithm", element.getCompression_algorithm());
        }
        if (element.hasIntegrity_checkElement()) {
            this.composeBase64Binary("integrity_check", element.getIntegrity_checkElement());
        }
        if (element.hasIntegrity_check_algorithm()) {
            this.composeCODE_PHRASE("integrity_check_algorithm", element.getIntegrity_check_algorithm());
        }
        if (element.hasThumbnail()) {
            this.composeDV_MULTIMEDIA("thumbnail", element.getThumbnail());
        }
        if (element.hasSizeElement()) {
            this.composeInteger("size", element.getSizeElement());
        }
    }

    protected void composeDV_ORDINAL(String name, DV_ORDINAL element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_ORDINALElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_ORDINALElements(DV_ORDINAL element) throws IOException {
        this.composeDV_ORDEREDElements(element);
        if (element.hasSymbol()) {
            this.composeDV_CODED_TEXT("symbol", element.getSymbol());
        }
        if (element.hasValueElement()) {
            this.composeInteger("value", element.getValueElement());
        }
    }

    protected void composeDV_PARAGRAPH(String name, DV_PARAGRAPH element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_PARAGRAPHElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_PARAGRAPHElements(DV_PARAGRAPH element) throws IOException {
        this.composeDATA_VALUEElements(element);
        if (element.hasItems()) {
            for (DV_TEXT e : element.getItemsList()) {
                this.composeDV_TEXT("items", e);
            }
        }
    }

    protected void composeDV_PARSABLE(String name, DV_PARSABLE element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_PARSABLEElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_PARSABLEElements(DV_PARSABLE element) throws IOException {
        this.composeDV_ENCAPSULATEDElements(element);
        if (element.hasValueElement()) {
            this.composeString("value", element.getValueElement());
        }
        if (element.hasFormalismElement()) {
            this.composeString("formalism", element.getFormalismElement());
        }
    }

    protected void composeDV_PERIODIC_TIME_SPECIFICATION(String name, DV_PERIODIC_TIME_SPECIFICATION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_PERIODIC_TIME_SPECIFICATIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_PERIODIC_TIME_SPECIFICATIONElements(DV_PERIODIC_TIME_SPECIFICATION element) throws IOException {
        this.composeDV_TIME_SPECIFICATIONElements(element);
    }

    protected void composeDV_PROPORTION(String name, DV_PROPORTION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_PROPORTIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_PROPORTIONElements(DV_PROPORTION element) throws IOException {
        this.composeDV_AMOUNTElements(element);
        if (element.hasNumeratorElement()) {
            this.composeDecimal("numerator", element.getNumeratorElement());
        }
        if (element.hasDenominatorElement()) {
            this.composeDecimal("denominator", element.getDenominatorElement());
        }
        if (element.hasTypeElement()) {
            this.composeCode("type", element.getTypeElement());
        }
        if (element.hasPrecisionElement()) {
            this.composeInteger("precision", element.getPrecisionElement());
        }
    }

    protected void composeDV_QUANTITY(String name, DV_QUANTITY element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_QUANTITYElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_QUANTITYElements(DV_QUANTITY element) throws IOException {
        this.composeDV_AMOUNTElements(element);
        if (element.hasMagnitudeElement()) {
            this.composeDecimal("magnitude", element.getMagnitudeElement());
        }
        if (element.hasPrecisionElement()) {
            this.composeInteger("precision", element.getPrecisionElement());
        }
        if (element.hasUnitsElement()) {
            this.composeString("units", element.getUnitsElement());
        }
        if (element.hasUnits_systemElement()) {
            this.composeString("units_system", element.getUnits_systemElement());
        }
        if (element.hasUnits_display_nameElement()) {
            this.composeString("units_display_name", element.getUnits_display_nameElement());
        }
    }

    protected void composeDV_SCALE(String name, DV_SCALE element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_SCALEElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_SCALEElements(DV_SCALE element) throws IOException {
        this.composeDV_ORDEREDElements(element);
        if (element.hasSymbol()) {
            this.composeDV_CODED_TEXT("symbol", element.getSymbol());
        }
        if (element.hasValueElement()) {
            this.composeDecimal("value", element.getValueElement());
        }
    }

    protected void composeDV_STATE(String name, DV_STATE element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_STATEElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_STATEElements(DV_STATE element) throws IOException {
        this.composeDATA_VALUEElements(element);
        if (element.hasValue()) {
            this.composeDV_CODED_TEXT("value", element.getValue());
        }
        if (element.hasIs_terminalElement()) {
            this.composeBoolean("is_terminal", element.getIs_terminalElement());
        }
    }

    protected void composeDV_TEXT(String name, DV_TEXT element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_TEXTElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_TEXTElements(DV_TEXT element) throws IOException {
        this.composeDATA_VALUEElements(element);
        if (element.hasValueElement()) {
            this.composeString("value", element.getValueElement());
        }
        if (element.hasHyperlink()) {
            this.composeDV_URI("hyperlink", element.getHyperlink());
        }
        if (element.hasFormattingElement()) {
            this.composeString("formatting", element.getFormattingElement());
        }
        if (element.hasMappings()) {
            for (TERM_MAPPING e : element.getMappingsList()) {
                this.composeTERM_MAPPING("mappings", e);
            }
        }
        if (element.hasLanguage()) {
            this.composeCODE_PHRASE("language", element.getLanguage());
        }
        if (element.hasEncoding()) {
            this.composeCODE_PHRASE("encoding", element.getEncoding());
        }
    }

    protected void composeDV_TIME(String name, DV_TIME element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_TIMEElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_TIMEElements(DV_TIME element) throws IOException {
        this.composeDV_ORDEREDElements(element);
        if (element.hasValueElement()) {
            this.composeString("value", element.getValueElement());
        }
    }

    protected void composeDV_URI(String name, DV_URI element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeDV_URIElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeDV_URIElements(DV_URI element) throws IOException {
        this.composeDATA_VALUEElements(element);
        if (element.hasValueElement()) {
            this.composeUri("value", element.getValueElement());
        }
    }

    protected void composeEHR_ACCESS(String name, EHR_ACCESS element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeEHR_ACCESSElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEHR_ACCESSElements(EHR_ACCESS element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasSettings()) {
            this.composeACCESS_CONTROL_SETTINGS("settings", element.getSettings());
        }
    }

    protected void composeEHR_STATUS(String name, EHR_STATUS element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeEHR_STATUSElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEHR_STATUSElements(EHR_STATUS element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasSubject()) {
            this.composePARTY_SELF("subject", element.getSubject());
        }
        if (element.hasIs_queryableElement()) {
            this.composeBoolean("is_queryable", element.getIs_queryableElement());
        }
        if (element.hasIs_modifiableElement()) {
            this.composeBoolean("is_modifiable", element.getIs_modifiableElement());
        }
        if (element.hasOther_details()) {
            this.composeITEM_STRUCTURE("other_details", element.getOther_details());
        }
    }

    protected void composeEHR(String name, EHR element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeEHRElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEHRElements(EHR element) throws IOException {
        this.composeAnyElements(element);
        if (element.hasSystem_id()) {
            for (HIER_OBJECT_ID hIER_OBJECT_ID : element.getSystem_idList()) {
                this.composeHIER_OBJECT_ID("system_id", hIER_OBJECT_ID);
            }
        }
        if (element.hasEhr_id()) {
            this.composeHIER_OBJECT_ID("ehr_id", element.getEhr_id());
        }
        if (element.hasContributions()) {
            for (OBJECT_REF oBJECT_REF : element.getContributionsList()) {
                this.composeOBJECT_REF("contributions", oBJECT_REF);
            }
        }
        if (element.hasEhr_status()) {
            this.composeOBJECT_REF("ehr_status", element.getEhr_status());
        }
        if (element.hasEhr_access()) {
            this.composeOBJECT_REF("ehr_access", element.getEhr_access());
        }
        if (element.hasCompositions()) {
            for (OBJECT_REF oBJECT_REF : element.getCompositionsList()) {
                this.composeOBJECT_REF("compositions", oBJECT_REF);
            }
        }
        if (element.hasDirectory()) {
            this.composeOBJECT_REF("directory", element.getDirectory());
        }
        if (element.hasTime_created()) {
            this.composeDV_DATE_TIME("time_created", element.getTime_created());
        }
        if (element.hasFolders()) {
            for (OBJECT_REF oBJECT_REF : element.getFoldersList()) {
                this.composeOBJECT_REF("folders", oBJECT_REF);
            }
        }
        if (element.hasTags()) {
            for (OBJECT_REF oBJECT_REF : element.getTagsList()) {
                this.composeOBJECT_REF("tags", oBJECT_REF);
            }
        }
    }

    protected void composeELEMENT(String name, ELEMENT element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeELEMENTElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeELEMENTElements(ELEMENT element) throws IOException {
        this.composeITEMElements(element);
        if (element.hasNull_flavour()) {
            this.composeDV_CODED_TEXT("null_flavour", element.getNull_flavour());
        }
        if (element.hasValue()) {
            this.composeDATA_VALUE("value", element.getValue());
        }
        if (element.hasNull_reason()) {
            this.composeDV_TEXT("null_reason", element.getNull_reason());
        }
    }

    protected void composeEVALUATION(String name, EVALUATION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeEVALUATIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEVALUATIONElements(EVALUATION element) throws IOException {
        this.composeCARE_ENTRYElements(element);
        if (element.hasData()) {
            this.composeITEM_STRUCTURE("data", element.getData());
        }
    }

    protected void composeEVENT_CONTEXT(String name, EVENT_CONTEXT element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeEVENT_CONTEXTElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeEVENT_CONTEXTElements(EVENT_CONTEXT element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasStart_time()) {
            this.composeDV_DATE_TIME("start_time", element.getStart_time());
        }
        if (element.hasEnd_time()) {
            this.composeDV_DATE_TIME("end_time", element.getEnd_time());
        }
        if (element.hasLocationElement()) {
            this.composeString("location", element.getLocationElement());
        }
        if (element.hasSetting()) {
            this.composeDV_CODED_TEXT("setting", element.getSetting());
        }
        if (element.hasOther_context()) {
            this.composeITEM_STRUCTURE("other_context", element.getOther_context());
        }
        if (element.hasHealth_care_facility()) {
            this.composePARTY_IDENTIFIED("health_care_facility", element.getHealth_care_facility());
        }
        if (element.hasParticipations()) {
            for (PARTICIPATION e : element.getParticipationsList()) {
                this.composePARTICIPATION("participations", e);
            }
        }
    }

    protected void composeFEEDER_AUDIT_DETAILS(String name, FEEDER_AUDIT_DETAILS element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeFEEDER_AUDIT_DETAILSElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeFEEDER_AUDIT_DETAILSElements(FEEDER_AUDIT_DETAILS element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasSystem_idElement()) {
            this.composeString("system_id", element.getSystem_idElement());
        }
        if (element.hasLocation()) {
            this.composePARTY_IDENTIFIED("location", element.getLocation());
        }
        if (element.hasSubject()) {
            this.composePARTY_PROXY("subject", element.getSubject());
        }
        if (element.hasProvider()) {
            this.composePARTY_IDENTIFIED("provider", element.getProvider());
        }
        if (element.hasTime()) {
            this.composeDV_DATE_TIME("time", element.getTime());
        }
        if (element.hasVersion_idElement()) {
            this.composeString("version_id", element.getVersion_idElement());
        }
        if (element.hasOther_details()) {
            this.composeITEM_STRUCTURE("other_details", element.getOther_details());
        }
    }

    protected void composeFEEDER_AUDIT(String name, FEEDER_AUDIT element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeFEEDER_AUDITElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeFEEDER_AUDITElements(FEEDER_AUDIT element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasOriginating_system_item_ids()) {
            for (DV_IDENTIFIER e : element.getOriginating_system_item_idsList()) {
                this.composeDV_IDENTIFIER("originating_system_item_ids", e);
            }
        }
        if (element.hasFeeder_system_item_ids()) {
            for (DV_IDENTIFIER e : element.getFeeder_system_item_idsList()) {
                this.composeDV_IDENTIFIER("feeder_system_item_ids", e);
            }
        }
        if (element.hasOriginal_content()) {
            this.composeDV_ENCAPSULATED("original_content", element.getOriginal_content());
        }
        if (element.hasOriginating_system_audit()) {
            this.composeFEEDER_AUDIT_DETAILS("originating_system_audit", element.getOriginating_system_audit());
        }
        if (element.hasFeeder_system_audit()) {
            this.composeFEEDER_AUDIT_DETAILS("feeder_system_audit", element.getFeeder_system_audit());
        }
    }

    protected void composeFOLDER(String name, FOLDER element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeFOLDERElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeFOLDERElements(FOLDER element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasItems()) {
            for (OBJECT_REF oBJECT_REF : element.getItemsList()) {
                this.composeOBJECT_REF("items", oBJECT_REF);
            }
        }
        if (element.hasFolders()) {
            for (FOLDER fOLDER : element.getFoldersList()) {
                this.composeFOLDER("folders", fOLDER);
            }
        }
        if (element.hasDetails()) {
            this.composeITEM_STRUCTURE("details", element.getDetails());
        }
    }

    protected void composeGENERIC_ID(String name, GENERIC_ID element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeGENERIC_IDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeGENERIC_IDElements(GENERIC_ID element) throws IOException {
        this.composeOBJECT_IDElements(element);
    }

    protected void composeGROUP(String name, GROUP element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeGROUPElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeGROUPElements(GROUP element) throws IOException {
        this.composeACTORElements(element);
    }

    protected void composeHIER_OBJECT_ID(String name, HIER_OBJECT_ID element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeHIER_OBJECT_IDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeHIER_OBJECT_IDElements(HIER_OBJECT_ID element) throws IOException {
        this.composeUID_BASED_IDElements(element);
    }

    protected void composeHISTORY(String name, HISTORY element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeHISTORYElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeHISTORYElements(HISTORY element) throws IOException {
        this.composeDATA_STRUCTUREElements(element);
        if (element.hasOrigin()) {
            this.composeDV_DATE_TIME("origin", element.getOrigin());
        }
        if (element.hasPeriod()) {
            this.composeDV_DURATION("period", element.getPeriod());
        }
        if (element.hasDuration()) {
            this.composeDV_DURATION("duration", element.getDuration());
        }
        if (element.hasSummary()) {
            this.composeITEM_STRUCTURE("summary", element.getSummary());
        }
        if (element.hasEvents()) {
            for (EVENT e : element.getEventsList()) {
                this.composeEVENT("events", e);
            }
        }
    }

    protected void composeIMPORTED_VERSION(String name, IMPORTED_VERSION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeIMPORTED_VERSIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeIMPORTED_VERSIONElements(IMPORTED_VERSION element) throws IOException {
        this.composeVERSIONElements(element);
        if (element.hasItem()) {
            this.composeORIGINAL_VERSION("item", element.getItem());
        }
    }

    protected void composeINSTRUCTION_DETAILS(String name, INSTRUCTION_DETAILS element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeINSTRUCTION_DETAILSElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeINSTRUCTION_DETAILSElements(INSTRUCTION_DETAILS element) throws IOException {
        this.composePATHABLEElements(element);
        if (element.hasInstruction_id()) {
            this.composeLOCATABLE_REF("instruction_id", element.getInstruction_id());
        }
        if (element.hasActivity_idElement()) {
            this.composeString("activity_id", element.getActivity_idElement());
        }
        if (element.hasWf_details()) {
            this.composeITEM_STRUCTURE("wf_details", element.getWf_details());
        }
    }

    protected void composeINSTRUCTION(String name, INSTRUCTION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeINSTRUCTIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeINSTRUCTIONElements(INSTRUCTION element) throws IOException {
        this.composeCARE_ENTRYElements(element);
        if (element.hasNarrative()) {
            this.composeDV_TEXT("narrative", element.getNarrative());
        }
        if (element.hasExpiry_time()) {
            this.composeDV_DATE_TIME("expiry_time", element.getExpiry_time());
        }
        if (element.hasWf_definition()) {
            this.composeDV_PARSABLE("wf_definition", element.getWf_definition());
        }
        if (element.hasActivities()) {
            for (ACTIVITY e : element.getActivitiesList()) {
                this.composeACTIVITY("activities", e);
            }
        }
    }

    protected void composeINTERNET_ID(String name, INTERNET_ID element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeINTERNET_IDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeINTERNET_IDElements(INTERNET_ID element) throws IOException {
        this.composeUIDElements(element);
    }

    protected void composeINTERVAL_EVENT(String name, INTERVAL_EVENT element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeINTERVAL_EVENTElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeINTERVAL_EVENTElements(INTERVAL_EVENT element) throws IOException {
        this.composeEVENTElements(element);
        if (element.hasWidth()) {
            this.composeDV_DURATION("width", element.getWidth());
        }
        if (element.hasSample_countElement()) {
            this.composeInteger("sample_count", element.getSample_countElement());
        }
        if (element.hasMath_function()) {
            this.composeDV_CODED_TEXT("math_function", element.getMath_function());
        }
    }

    protected void composeISM_TRANSITION(String name, ISM_TRANSITION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeISM_TRANSITIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeISM_TRANSITIONElements(ISM_TRANSITION element) throws IOException {
        this.composePATHABLEElements(element);
        if (element.hasCurrent_state()) {
            this.composeDV_CODED_TEXT("current_state", element.getCurrent_state());
        }
        if (element.hasTransition()) {
            this.composeDV_CODED_TEXT("transition", element.getTransition());
        }
        if (element.hasCareflow_step()) {
            this.composeDV_CODED_TEXT("careflow_step", element.getCareflow_step());
        }
        if (element.hasReason()) {
            for (DV_TEXT e : element.getReasonList()) {
                this.composeDV_TEXT("reason", e);
            }
        }
    }

    protected void composeISO_OID(String name, ISO_OID element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeISO_OIDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeISO_OIDElements(ISO_OID element) throws IOException {
        this.composeUIDElements(element);
    }

    protected void composeITEM_LIST(String name, ITEM_LIST element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeITEM_LISTElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeITEM_LISTElements(ITEM_LIST element) throws IOException {
        this.composeITEM_STRUCTUREElements(element);
        if (element.hasItems()) {
            for (ELEMENT e : element.getItemsList()) {
                this.composeELEMENT("items", e);
            }
        }
    }

    protected void composeITEM_SINGLE(String name, ITEM_SINGLE element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeITEM_SINGLEElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeITEM_SINGLEElements(ITEM_SINGLE element) throws IOException {
        this.composeITEM_STRUCTUREElements(element);
        if (element.hasItem()) {
            this.composeELEMENT("item", element.getItem());
        }
    }

    protected void composeITEM_TABLE(String name, ITEM_TABLE element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeITEM_TABLEElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeITEM_TABLEElements(ITEM_TABLE element) throws IOException {
        this.composeITEM_STRUCTUREElements(element);
        if (element.hasRows()) {
            for (CLUSTER e : element.getRowsList()) {
                this.composeCLUSTER("rows", e);
            }
        }
    }

    protected void composeITEM_TAG(String name, ITEM_TAG element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeITEM_TAGElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeITEM_TAGElements(ITEM_TAG element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasKeyElement()) {
            this.composeString("key", element.getKeyElement());
        }
        if (element.hasValueElement()) {
            this.composeString("value", element.getValueElement());
        }
        if (element.hasTarget()) {
            this.composeUID_BASED_ID("target", element.getTarget());
        }
        if (element.hasTarget_pathElement()) {
            this.composeString("target_path", element.getTarget_pathElement());
        }
        if (element.hasOwner_id()) {
            this.composeOBJECT_REF("owner_id", element.getOwner_id());
        }
    }

    protected void composeITEM_TREE(String name, ITEM_TREE element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeITEM_TREEElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeITEM_TREEElements(ITEM_TREE element) throws IOException {
        this.composeITEM_STRUCTUREElements(element);
        if (element.hasItems()) {
            for (ITEM e : element.getItemsList()) {
                this.composeITEM("items", e);
            }
        }
    }

    protected void composeLINK(String name, LINK element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeLINKElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeLINKElements(LINK element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasMeaning()) {
            this.composeDV_TEXT("meaning", element.getMeaning());
        }
        if (element.hasType()) {
            this.composeDV_TEXT("type", element.getType());
        }
        if (element.hasTarget()) {
            this.composeDV_EHR_URI("target", element.getTarget());
        }
    }

    protected void composeLOCATABLE_REF(String name, LOCATABLE_REF element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeLOCATABLE_REFElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeLOCATABLE_REFElements(LOCATABLE_REF element) throws IOException {
        this.composeOBJECT_REFElements(element);
        if (element.hasPathElement()) {
            this.composeString("path", element.getPathElement());
        }
    }

    protected void composeOBJECT_REF(String name, OBJECT_REF element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeOBJECT_REFElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeOBJECT_REFElements(OBJECT_REF element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasNamespaceElement()) {
            this.composeString("namespace", element.getNamespaceElement());
        }
        if (element.hasTypeElement()) {
            this.composeString("type", element.getTypeElement());
        }
        if (element.hasId()) {
            this.composeOBJECT_ID("id", element.getId());
        }
    }

    protected void composeOBJECT_VERSION_ID(String name, OBJECT_VERSION_ID element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeOBJECT_VERSION_IDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeOBJECT_VERSION_IDElements(OBJECT_VERSION_ID element) throws IOException {
        this.composeUID_BASED_IDElements(element);
    }

    protected void composeOBSERVATION(String name, OBSERVATION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeOBSERVATIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeOBSERVATIONElements(OBSERVATION element) throws IOException {
        this.composeCARE_ENTRYElements(element);
        if (element.hasData()) {
            this.composeHISTORY("data", element.getData());
        }
        if (element.hasState()) {
            this.composeHISTORY("state", element.getState());
        }
    }

    protected void composeORGANISATION(String name, ORGANISATION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeORGANISATIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeORGANISATIONElements(ORGANISATION element) throws IOException {
        this.composeACTORElements(element);
    }

    protected void composeORIGINAL_VERSION(String name, ORIGINAL_VERSION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeORIGINAL_VERSIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeORIGINAL_VERSIONElements(ORIGINAL_VERSION element) throws IOException {
        this.composeVERSIONElements(element);
        if (element.hasUid()) {
            this.composeOBJECT_VERSION_ID("uid", element.getUid());
        }
        if (element.hasPreceding_version_uid()) {
            this.composeOBJECT_VERSION_ID("preceding_version_uid", element.getPreceding_version_uid());
        }
        if (element.hasOther_input_version_uids()) {
            for (OBJECT_VERSION_ID oBJECT_VERSION_ID : element.getOther_input_version_uidsList()) {
                this.composeOBJECT_VERSION_ID("other_input_version_uids", oBJECT_VERSION_ID);
            }
        }
        if (element.hasLifecycle_state()) {
            this.composeDV_CODED_TEXT("lifecycle_state", element.getLifecycle_state());
        }
        if (element.hasAttestations()) {
            for (ATTESTATION aTTESTATION : element.getAttestationsList()) {
                this.composeATTESTATION("attestations", aTTESTATION);
            }
        }
        if (element.hasData()) {
            this.composeAny("data", element.getData());
        }
    }

    protected void composePARTICIPATION(String name, PARTICIPATION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composePARTICIPATIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePARTICIPATIONElements(PARTICIPATION element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasFunction()) {
            this.composeDV_TEXT("function", element.getFunction());
        }
        if (element.hasMode()) {
            this.composeDV_CODED_TEXT("mode", element.getMode());
        }
        if (element.hasPerformer()) {
            this.composePARTY_PROXY("performer", element.getPerformer());
        }
        if (element.hasTime()) {
            this.composeDV_INTERVAL("time", element.getTime());
        }
    }

    protected void composePARTY_IDENTIFIED(String name, PARTY_IDENTIFIED element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composePARTY_IDENTIFIEDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePARTY_IDENTIFIEDElements(PARTY_IDENTIFIED element) throws IOException {
        this.composePARTY_PROXYElements(element);
        if (element.hasNameElement()) {
            this.composeString("name", element.getNameElement());
        }
        if (element.hasIdentifiers()) {
            for (DV_IDENTIFIER e : element.getIdentifiersList()) {
                this.composeDV_IDENTIFIER("identifiers", e);
            }
        }
    }

    protected void composePARTY_IDENTITY(String name, PARTY_IDENTITY element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composePARTY_IDENTITYElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePARTY_IDENTITYElements(PARTY_IDENTITY element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasDetails()) {
            this.composeITEM_STRUCTURE("details", element.getDetails());
        }
    }

    protected void composePARTY_REF(String name, PARTY_REF element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composePARTY_REFElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePARTY_REFElements(PARTY_REF element) throws IOException {
        this.composeOBJECT_REFElements(element);
    }

    protected void composePARTY_RELATED(String name, PARTY_RELATED element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composePARTY_RELATEDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePARTY_RELATEDElements(PARTY_RELATED element) throws IOException {
        this.composePARTY_IDENTIFIEDElements(element);
        if (element.hasRelationship()) {
            this.composeDV_CODED_TEXT("relationship", element.getRelationship());
        }
    }

    protected void composePARTY_RELATIONSHIP(String name, PARTY_RELATIONSHIP element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composePARTY_RELATIONSHIPElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePARTY_RELATIONSHIPElements(PARTY_RELATIONSHIP element) throws IOException {
        this.composeLOCATABLEElements(element);
        if (element.hasDetails()) {
            this.composeITEM_STRUCTURE("details", element.getDetails());
        }
        if (element.hasTarget()) {
            this.composePARTY_REF("target", element.getTarget());
        }
        if (element.hasTime_validity()) {
            this.composeDV_INTERVAL("time_validity", element.getTime_validity());
        }
        if (element.hasSource()) {
            this.composePARTY_REF("source", element.getSource());
        }
    }

    protected void composePARTY_SELF(String name, PARTY_SELF element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composePARTY_SELFElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePARTY_SELFElements(PARTY_SELF element) throws IOException {
        this.composePARTY_PROXYElements(element);
    }

    protected void composePERSON(String name, PERSON element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composePERSONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePERSONElements(PERSON element) throws IOException {
        this.composeACTORElements(element);
    }

    protected void composePOINT_EVENT(String name, POINT_EVENT element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composePOINT_EVENTElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composePOINT_EVENTElements(POINT_EVENT element) throws IOException {
        this.composeEVENTElements(element);
    }

    protected void composeREFERENCE_RANGE(String name, REFERENCE_RANGE element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeREFERENCE_RANGEElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeREFERENCE_RANGEElements(REFERENCE_RANGE element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasMeaning()) {
            this.composeDV_TEXT("meaning", element.getMeaning());
        }
        if (element.hasRange()) {
            this.composeDV_INTERVAL("range", element.getRange());
        }
    }

    protected void composeRESOURCE_DESCRIPTION_ITEM(String name, RESOURCE_DESCRIPTION_ITEM element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeRESOURCE_DESCRIPTION_ITEMElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeRESOURCE_DESCRIPTION_ITEMElements(RESOURCE_DESCRIPTION_ITEM element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasLanguage()) {
            this.composeCODE_PHRASE("language", element.getLanguage());
        }
        if (element.hasPurposeElement()) {
            this.composeString("purpose", element.getPurposeElement());
        }
        if (element.hasKeywords()) {
            for (StringType e : element.getKeywordsList()) {
                this.composeString("keywords", e);
            }
        }
        if (element.hasUseElement()) {
            this.composeString("use", element.getUseElement());
        }
        if (element.hasMisuseElement()) {
            this.composeString("misuse", element.getMisuseElement());
        }
        if (element.hasCopyrightElement()) {
            this.composeString("copyright", element.getCopyrightElement());
        }
        if (element.hasOriginal_resource_uri()) {
            for (StringType e : element.getOriginal_resource_uriList()) {
                this.composeString("original_resource_uri", e);
            }
        }
        if (element.hasOther_details()) {
            for (StringType e : element.getOther_detailsList()) {
                this.composeString("other_details", e);
            }
        }
    }

    protected void composeRESOURCE_DESCRIPTION(String name, RESOURCE_DESCRIPTION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeRESOURCE_DESCRIPTIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeRESOURCE_DESCRIPTIONElements(RESOURCE_DESCRIPTION element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasOriginal_author()) {
            for (StringType stringType : element.getOriginal_authorList()) {
                this.composeString("original_author", stringType);
            }
        }
        if (element.hasOther_contributors()) {
            for (StringType stringType : element.getOther_contributorsList()) {
                this.composeString("other_contributors", stringType);
            }
        }
        if (element.hasLifecycle_stateElement()) {
            this.composeString("lifecycle_state", element.getLifecycle_stateElement());
        }
        if (element.hasResource_package_uriElement()) {
            this.composeString("resource_package_uri", element.getResource_package_uriElement());
        }
        if (element.hasOther_details()) {
            for (OBJECT_REF oBJECT_REF : element.getOther_detailsList()) {
                this.composeOBJECT_REF("other_details", oBJECT_REF);
            }
        }
        if (element.hasParent_resource()) {
            this.composeAUTHORED_RESOURCE("parent_resource", element.getParent_resource());
        }
        if (element.hasDetails()) {
            for (RESOURCE_DESCRIPTION_ITEM rESOURCE_DESCRIPTION_ITEM : element.getDetailsList()) {
                this.composeRESOURCE_DESCRIPTION_ITEM("details", rESOURCE_DESCRIPTION_ITEM);
            }
        }
    }

    protected void composeREVISION_HISTORY_ITEM(String name, REVISION_HISTORY_ITEM element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeREVISION_HISTORY_ITEMElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeREVISION_HISTORY_ITEMElements(REVISION_HISTORY_ITEM element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasVersion_id()) {
            this.composeOBJECT_VERSION_ID("version_id", element.getVersion_id());
        }
        if (element.hasAudits()) {
            for (AUDIT_DETAILS e : element.getAuditsList()) {
                this.composeAUDIT_DETAILS("audits", e);
            }
        }
    }

    protected void composeREVISION_HISTORY(String name, REVISION_HISTORY element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeREVISION_HISTORYElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeREVISION_HISTORYElements(REVISION_HISTORY element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasMost_recent_versionElement()) {
            this.composeString("most_recent_version", element.getMost_recent_versionElement());
        }
        if (element.hasMost_recent_version_time_committedElement()) {
            this.composeString("most_recent_version_time_committed", element.getMost_recent_version_time_committedElement());
        }
    }

    protected void composeROLE(String name, ROLE element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeROLEElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeROLEElements(ROLE element) throws IOException {
        this.composePARTYElements(element);
        if (element.hasTime_validity()) {
            this.composeDV_INTERVAL("time_validity", element.getTime_validity());
        }
        if (element.hasPerformer()) {
            this.composePARTY_REF("performer", element.getPerformer());
        }
        if (element.hasCapabilities()) {
            for (CAPABILITY e : element.getCapabilitiesList()) {
                this.composeCAPABILITY("capabilities", e);
            }
        }
    }

    protected void composeSECTION(String name, SECTION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeSECTIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeSECTIONElements(SECTION element) throws IOException {
        this.composeCONTENT_ITEMElements(element);
        if (element.hasItems()) {
            for (CONTENT_ITEM e : element.getItemsList()) {
                this.composeCONTENT_ITEM("items", e);
            }
        }
    }

    protected void composeTEMPLATE_ID(String name, TEMPLATE_ID element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeTEMPLATE_IDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTEMPLATE_IDElements(TEMPLATE_ID element) throws IOException {
        this.composeOBJECT_IDElements(element);
    }

    protected void composeTERM_MAPPING(String name, TERM_MAPPING element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeTERM_MAPPINGElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTERM_MAPPINGElements(TERM_MAPPING element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasMatchElement()) {
            this.composeString("match", element.getMatchElement());
        }
        if (element.hasPurpose()) {
            this.composeDV_CODED_TEXT("purpose", element.getPurpose());
        }
        if (element.hasTarget()) {
            this.composeCODE_PHRASE("target", element.getTarget());
        }
    }

    protected void composeTERMINOLOGY_ID(String name, TERMINOLOGY_ID element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeTERMINOLOGY_IDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTERMINOLOGY_IDElements(TERMINOLOGY_ID element) throws IOException {
        this.composeOBJECT_IDElements(element);
    }

    protected void composeTRANSLATION_DETAILS(String name, TRANSLATION_DETAILS element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeTRANSLATION_DETAILSElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTRANSLATION_DETAILSElements(TRANSLATION_DETAILS element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasLanguage()) {
            this.composeCODE_PHRASE("language", element.getLanguage());
        }
        if (element.hasAuthor()) {
            for (StringType e : element.getAuthorList()) {
                this.composeString("author", e);
            }
        }
        if (element.hasAccreditationElement()) {
            this.composeString("accreditation", element.getAccreditationElement());
        }
        if (element.hasOther_details()) {
            for (StringType e : element.getOther_detailsList()) {
                this.composeString("other_details", e);
            }
        }
    }

    protected void composeTranslatedString(String name, TranslatedString element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeTranslatedStringElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTranslatedStringElements(TranslatedString element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasLanguageElement()) {
            this.composeCode("language", element.getLanguageElement());
        }
        if (element.hasValueElement()) {
            this.composeString("value", element.getValueElement());
        }
    }

    protected void composeUUID(String name, UUID element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeUUIDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeUUIDElements(UUID element) throws IOException {
        this.composeUIDElements(element);
    }

    protected void composeVERSION_TREE_ID(String name, VERSION_TREE_ID element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeVERSION_TREE_IDElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeVERSION_TREE_IDElements(VERSION_TREE_ID element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasValueElement()) {
            this.composeString("value", element.getValueElement());
        }
    }

    protected void composeVERSIONED_COMPOSITION(String name, VERSIONED_COMPOSITION element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeVERSIONED_COMPOSITIONElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeVERSIONED_COMPOSITIONElements(VERSIONED_COMPOSITION element) throws IOException {
        this.composeVERSIONED_OBJECTElements(element);
    }

    protected void composeVERSIONED_EHR_ACCESS(String name, VERSIONED_EHR_ACCESS element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeVERSIONED_EHR_ACCESSElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeVERSIONED_EHR_ACCESSElements(VERSIONED_EHR_ACCESS element) throws IOException {
        this.composeVERSIONED_OBJECTElements(element);
    }

    protected void composeVERSIONED_EHR_STATUS(String name, VERSIONED_EHR_STATUS element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeVERSIONED_EHR_STATUSElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeVERSIONED_EHR_STATUSElements(VERSIONED_EHR_STATUS element) throws IOException {
        this.composeVERSIONED_OBJECTElements(element);
    }

    protected void composeVERSIONED_FOLDER(String name, VERSIONED_FOLDER element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeVERSIONED_FOLDERElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeVERSIONED_FOLDERElements(VERSIONED_FOLDER element) throws IOException {
        this.composeVERSIONED_OBJECTElements(element);
    }

    protected void composeVERSIONED_OBJECT(String name, VERSIONED_OBJECT element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeVERSIONED_OBJECTElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeVERSIONED_OBJECTElements(VERSIONED_OBJECT element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasUid()) {
            this.composeHIER_OBJECT_ID("uid", element.getUid());
        }
        if (element.hasOwner_id()) {
            this.composeOBJECT_REF("owner_id", element.getOwner_id());
        }
        if (element.hasTime_created()) {
            this.composeDV_DATE_TIME("time_created", element.getTime_created());
        }
    }

    protected void composeVERSIONED_PARTY(String name, VERSIONED_PARTY element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeVERSIONED_PARTYElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeVERSIONED_PARTYElements(VERSIONED_PARTY element) throws IOException {
        this.composeVERSIONED_OBJECTElements(element);
    }

    protected void composeWebTemplate(String name, WebTemplate element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeWebTemplateElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeWebTemplateElements(WebTemplate element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasTemplateIdElement()) {
            this.composeString("templateId", element.getTemplateIdElement());
        }
        if (element.hasVersionElement()) {
            this.composeString("version", element.getVersionElement());
        }
        if (element.hasSemverElement()) {
            this.composeString("semver", element.getSemverElement());
        }
        if (element.hasDefaultLanguageElement()) {
            this.composeString("defaultLanguage", element.getDefaultLanguageElement());
        }
        if (element.hasLanguages()) {
            for (StringType e : element.getLanguagesList()) {
                this.composeString("languages", e);
            }
        }
        if (element.hasTree()) {
            this.composeWebTemplateItem("tree", element.getTree());
        }
    }

    protected void composeWebTemplateInput(String name, WebTemplateInput element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeWebTemplateInputElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeWebTemplateInputElements(WebTemplateInput element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasSuffixElement()) {
            this.composeString("suffix", element.getSuffixElement());
        }
        if (element.hasTypeElement()) {
            this.composeCode("type", element.getTypeElement());
        }
        if (element.hasDefaultValue()) {
            this.composeNativePrimitive("defaultValue", element.getDefaultValue());
        }
        if (element.hasTerminologyElement()) {
            this.composeCode("terminology", element.getTerminologyElement());
        }
        if (element.hasValidation()) {
            this.composeWebTemplateInputValidation("validation", element.getValidation());
        }
        if (element.hasList()) {
            for (WebTemplateInputListItem e : element.getListList()) {
                this.composeWebTemplateInputListItem("list", e);
            }
        }
        if (element.hasListOpenElement()) {
            this.composeBoolean("listOpen", element.getListOpenElement());
        }
    }

    protected void composeWebTemplateInputListItem(String name, WebTemplateInputListItem element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeWebTemplateInputListItemElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeWebTemplateInputListItemElements(WebTemplateInputListItem element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasValueElement()) {
            this.composeCode("value", element.getValueElement());
        }
        if (element.hasLabelElement()) {
            this.composeString("label", element.getLabelElement());
        }
        if (element.hasOrdinalElement()) {
            this.composeString("ordinal", element.getOrdinalElement());
        }
        if (element.hasLocalizedLabels()) {
            for (TranslatedString translatedString : element.getLocalizedLabelsList()) {
                this.composeTranslatedString("localizedLabels", translatedString);
            }
        }
        if (element.hasLocalizedDescriptions()) {
            for (TranslatedString translatedString : element.getLocalizedDescriptionsList()) {
                this.composeTranslatedString("localizedDescriptions", translatedString);
            }
        }
        if (element.hasCurrentStatesElement()) {
            this.composeString("currentStates", element.getCurrentStatesElement());
        }
        if (element.hasRangeElement()) {
            this.composeString("range", element.getRangeElement());
        }
        if (element.hasPrecisionElement()) {
            this.composeString("precision", element.getPrecisionElement());
        }
        if (element.hasTermBindings()) {
            for (WebTemplateTermBinding webTemplateTermBinding : element.getTermBindingsList()) {
                this.composeWebTemplateTermBinding("termBindings", webTemplateTermBinding);
            }
        }
    }

    protected void composeWebTemplateInputValidation(String name, WebTemplateInputValidation element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeWebTemplateInputValidationElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeWebTemplateInputValidationElements(WebTemplateInputValidation element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasRange()) {
            this.composeWebTemplateInputValidationRange("range", element.getRange());
        }
        if (element.hasPrecision()) {
            this.composeWebTemplateInputValidationRange("precision", element.getPrecision());
        }
    }

    protected void composeWebTemplateInputValidationRange(String name, WebTemplateInputValidationRange element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeWebTemplateInputValidationRangeElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeWebTemplateInputValidationRangeElements(WebTemplateInputValidationRange element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasMinOpElement()) {
            this.composeCode("minOp", element.getMinOpElement());
        }
        if (element.hasMinElement()) {
            this.composeDecimal("min", element.getMinElement());
        }
        if (element.hasMaxOpElement()) {
            this.composeCode("maxOp", element.getMaxOpElement());
        }
        if (element.hasMaxElement()) {
            this.composeDecimal("max", element.getMaxElement());
        }
    }

    protected void composeWebTemplateItem(String name, WebTemplateItem element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeWebTemplateItemElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeWebTemplateItemElements(WebTemplateItem element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasIdElement()) {
            this.composeString("id", element.getIdElement());
        }
        if (element.hasDepthElement()) {
            this.composeInteger("depth", element.getDepthElement());
        }
        if (element.hasNameElement()) {
            this.composeString("name", element.getNameElement());
        }
        if (element.hasLocalizedNameElement()) {
            this.composeString("localizedName", element.getLocalizedNameElement());
        }
        if (element.hasRmTypeElement()) {
            this.composeCode("rmType", element.getRmTypeElement());
        }
        if (element.hasNodeIdElement()) {
            this.composeString("nodeId", element.getNodeIdElement());
        }
        if (element.hasMinElement()) {
            this.composeString("min", element.getMinElement());
        }
        if (element.hasMaxElement()) {
            this.composeString("max", element.getMaxElement());
        }
        if (element.hasDependsOnElement()) {
            this.composeString("dependsOn", element.getDependsOnElement());
        }
        if (element.hasLocalizedNames()) {
            for (TranslatedString translatedString : element.getLocalizedNamesList()) {
                this.composeTranslatedString("localizedNames", translatedString);
            }
        }
        if (element.hasLocalizedDescriptions()) {
            for (TranslatedString translatedString : element.getLocalizedDescriptionsList()) {
                this.composeTranslatedString("localizedDescriptions", translatedString);
            }
        }
        if (element.hasAnnotations()) {
            this.composeAnnotations("annotations", element.getAnnotations());
        }
        if (element.hasArchetype_idElement()) {
            this.composeString("archetype_id", element.getArchetype_idElement());
        }
        if (element.hasAqlPathElement()) {
            this.composeString("aqlPath", element.getAqlPathElement());
        }
        if (element.hasCustodian_namespaceElement()) {
            this.composeString("custodian_namespace", element.getCustodian_namespaceElement());
        }
        if (element.hasCustodian_organisationElement()) {
            this.composeString("custodian_organisation", element.getCustodian_organisationElement());
        }
        if (element.hasLifecycleStateElement()) {
            this.composeCode("lifecycleState", element.getLifecycleStateElement());
        }
        if (element.hasOriginal_namespaceElement()) {
            this.composeString("original_namespace", element.getOriginal_namespaceElement());
        }
        if (element.hasOriginal_publisherElement()) {
            this.composeString("original_publisher", element.getOriginal_publisherElement());
        }
        if (element.hasProportionTypesElement()) {
            this.composeCode("proportionTypes", element.getProportionTypesElement());
        }
        if (element.hasRevisionElement()) {
            this.composeString("revision", element.getRevisionElement());
        }
        if (element.hasInContextElement()) {
            this.composeBoolean("inContext", element.getInContextElement());
        }
        if (element.hasInputs()) {
            for (WebTemplateInput webTemplateInput : element.getInputsList()) {
                this.composeWebTemplateInput("inputs", webTemplateInput);
            }
        }
        if (element.hasTermBindings()) {
            for (WebTemplateTermBinding webTemplateTermBinding : element.getTermBindingsList()) {
                this.composeWebTemplateTermBinding("termBindings", webTemplateTermBinding);
            }
        }
        if (element.hasChildren()) {
            for (WebTemplateItem webTemplateItem : element.getChildrenList()) {
                this.composeWebTemplateItem("children", webTemplateItem);
            }
        }
    }

    protected void composeWebTemplateTermBinding(String name, WebTemplateTermBinding element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeWebTemplateTermBindingElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeWebTemplateTermBindingElements(WebTemplateTermBinding element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasCodeElement()) {
            this.composeCode("code", element.getCodeElement());
        }
        if (element.hasValue()) {
            this.composeWebTemplateTermBindingValue("value", element.getValue());
        }
    }

    protected void composeWebTemplateTermBindingValue(String name, WebTemplateTermBindingValue element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeWebTemplateTermBindingValueElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeWebTemplateTermBindingValueElements(WebTemplateTermBindingValue element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasValueElement()) {
            this.composeString("value", element.getValueElement());
        }
        if (element.hasTerminologyIdElement()) {
            this.composeString("terminologyId", element.getTerminologyIdElement());
        }
    }

    @Override
    protected void composeResource(Resource resource) throws IOException {
        if (resource == null) {
            throw new IOException("resource == null");
        }
        throw new Error("Unhandled resource type " + resource.getClass().getName());
    }

    @Override
    protected void composeResource(String name, Resource resource) throws IOException {
        if (name == null) {
            throw new IOException("name == null");
        }
        if (resource == null) {
            throw new IOException("resource == null");
        }
        throw new Error("Unhandled resource type " + resource.getClass().getName());
    }

    @Override
    protected void composeType(String prefix, DataType type) throws IOException {
        if (prefix == null) {
            throw new IOException("prefix == null");
        }
        if (type == null) {
            throw new IOException("type == null");
        }
        if (type instanceof CodeType) {
            this.composeCode(prefix + "Code", (CodeType)type);
        } else if (type instanceof OidType) {
            this.composeOid(prefix + "Oid", (OidType)type);
        } else if (type instanceof CanonicalType) {
            this.composeCanonical(prefix + "Canonical", (CanonicalType)type);
        } else if (type instanceof UuidType) {
            this.composeUuid(prefix + "Uuid", (UuidType)type);
        } else if (type instanceof UrlType) {
            this.composeUrl(prefix + "Url", (UrlType)type);
        } else if (type instanceof UnsignedIntType) {
            this.composeUnsignedInt(prefix + "UnsignedInt", (UnsignedIntType)type);
        } else if (type instanceof MarkdownType) {
            this.composeMarkdown(prefix + "Markdown", (MarkdownType)type);
        } else if (type instanceof IdType) {
            this.composeId(prefix + "Id", (IdType)type);
        } else if (type instanceof PositiveIntType) {
            this.composePositiveInt(prefix + "PositiveInt", (PositiveIntType)type);
        } else if (type instanceof DateType) {
            this.composeDate(prefix + "Date", (DateType)type);
        } else if (type instanceof DateTimeType) {
            this.composeDateTime(prefix + "DateTime", (DateTimeType)type);
        } else if (type instanceof StringType) {
            this.composeString(prefix + "String", (StringType)type);
        } else if (type instanceof IntegerType) {
            this.composeInteger(prefix + "Integer", (IntegerType)type);
        } else if (type instanceof Integer64Type) {
            this.composeInteger64(prefix + "Integer64", (Integer64Type)type);
        } else if (type instanceof UriType) {
            this.composeUri(prefix + "Uri", (UriType)type);
        } else if (type instanceof InstantType) {
            this.composeInstant(prefix + "Instant", (InstantType)type);
        } else if (type instanceof BooleanType) {
            this.composeBoolean(prefix + "Boolean", (BooleanType)type);
        } else if (type instanceof Base64BinaryType) {
            this.composeBase64Binary(prefix + "Base64Binary", (Base64BinaryType)type);
        } else if (type instanceof TimeType) {
            this.composeTime(prefix + "Time", (TimeType)type);
        } else if (type instanceof DecimalType) {
            this.composeDecimal(prefix + "Decimal", (DecimalType)type);
        } else {
            throw new Error("Unhandled type " + type.fhirType());
        }
    }
}

