/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.DV_INTERVAL;
import org.hl7.fhir.r5.openehr.DV_TEXT;
import org.hl7.fhir.r5.openehr.LOCATABLE;
import org.hl7.fhir.r5.openehr.PARTY_PROXY;

@DatatypeDef(name="PARTICIPATION")
public class PARTICIPATION
extends LOCATABLE
implements ICompositeType {
    @Child(name="function", type={DV_TEXT.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to more detailed demographic or identification information for this party", formalDefinition="Optional reference to more detailed demographic or identification information for this party, in an external system.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-participation_function")
    protected DV_TEXT function;
    @Child(name="mode", type={DV_CODED_TEXT.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to more detailed demographic or identification information for this party", formalDefinition="Optional reference to more detailed demographic or identification information for this party, in an external system.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-participation_mode")
    protected DV_CODED_TEXT mode;
    @Child(name="performer", type={PARTY_PROXY.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to more detailed demographic or identification information for this party", formalDefinition="Optional reference to more detailed demographic or identification information for this party, in an external system.")
    protected PARTY_PROXY performer;
    @Child(name="time", type={DV_INTERVAL.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to more detailed demographic or identification information for this party", formalDefinition="Optional reference to more detailed demographic or identification information for this party, in an external system.")
    protected DV_INTERVAL time;
    private static final long serialVersionUID = -595665945L;

    public PARTICIPATION() {
    }

    public PARTICIPATION(DV_TEXT function, PARTY_PROXY performer) {
        this.setFunction(function);
        this.setPerformer(performer);
    }

    public DV_TEXT getFunction() {
        if (this.function == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PARTICIPATION.function");
            }
            if (Configuration.doAutoCreate()) {
                this.function = new DV_TEXT();
            }
        }
        return this.function;
    }

    public boolean hasFunction() {
        return this.function != null && !this.function.isEmpty();
    }

    public PARTICIPATION setFunction(DV_TEXT value) {
        this.function = value;
        return this;
    }

    public DV_CODED_TEXT getMode() {
        if (this.mode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PARTICIPATION.mode");
            }
            if (Configuration.doAutoCreate()) {
                this.mode = new DV_CODED_TEXT();
            }
        }
        return this.mode;
    }

    public boolean hasMode() {
        return this.mode != null && !this.mode.isEmpty();
    }

    public PARTICIPATION setMode(DV_CODED_TEXT value) {
        this.mode = value;
        return this;
    }

    public PARTY_PROXY getPerformer() {
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public PARTICIPATION setPerformer(PARTY_PROXY value) {
        this.performer = value;
        return this;
    }

    public DV_INTERVAL getTime() {
        if (this.time == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PARTICIPATION.time");
            }
            if (Configuration.doAutoCreate()) {
                this.time = new DV_INTERVAL();
            }
        }
        return this.time;
    }

    public boolean hasTime() {
        return this.time != null && !this.time.isEmpty();
    }

    public PARTICIPATION setTime(DV_INTERVAL value) {
        this.time = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("function", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Optional reference to more detailed demographic or identification information for this party, in an external system.", 0, 1, this.function));
        children.add(new Property("mode", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Optional reference to more detailed demographic or identification information for this party, in an external system.", 0, 1, this.mode));
        children.add(new Property("performer", "http://openehr.org/fhir/StructureDefinition/PARTY-PROXY", "Optional reference to more detailed demographic or identification information for this party, in an external system.", 0, 1, this.performer));
        children.add(new Property("time", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "Optional reference to more detailed demographic or identification information for this party, in an external system.", 0, 1, this.time));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1380938712: {
                return new Property("function", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Optional reference to more detailed demographic or identification information for this party, in an external system.", 0, 1, this.function);
            }
            case 0x3339A3: {
                return new Property("mode", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Optional reference to more detailed demographic or identification information for this party, in an external system.", 0, 1, this.mode);
            }
            case 481140686: {
                return new Property("performer", "http://openehr.org/fhir/StructureDefinition/PARTY-PROXY", "Optional reference to more detailed demographic or identification information for this party, in an external system.", 0, 1, this.performer);
            }
            case 3560141: {
                return new Property("time", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "Optional reference to more detailed demographic or identification information for this party, in an external system.", 0, 1, this.time);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1380938712: {
                Base[] baseArray;
                if (this.function == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.function;
                }
                return baseArray;
            }
            case 0x3339A3: {
                Base[] baseArray;
                if (this.mode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.mode;
                }
                return baseArray;
            }
            case 481140686: {
                Base[] baseArray;
                if (this.performer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.performer;
                }
                return baseArray;
            }
            case 3560141: {
                Base[] baseArray;
                if (this.time == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.time;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1380938712: {
                this.function = (DV_TEXT)value;
                return value;
            }
            case 0x3339A3: {
                this.mode = (DV_CODED_TEXT)value;
                return value;
            }
            case 481140686: {
                this.performer = (PARTY_PROXY)value;
                return value;
            }
            case 3560141: {
                this.time = (DV_INTERVAL)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("function")) {
            this.function = (DV_TEXT)value;
        } else if (name.equals("mode")) {
            this.mode = (DV_CODED_TEXT)value;
        } else if (name.equals("performer")) {
            this.performer = (PARTY_PROXY)value;
        } else if (name.equals("time")) {
            this.time = (DV_INTERVAL)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1380938712: {
                return this.getFunction();
            }
            case 0x3339A3: {
                return this.getMode();
            }
            case 481140686: {
                throw new Error("Unable to make an instance of the abstract property 'performer'");
            }
            case 3560141: {
                return this.getTime();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1380938712: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-TEXT"};
            }
            case 0x3339A3: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case 481140686: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-PROXY"};
            }
            case 3560141: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-INTERVAL"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("function")) {
            this.function = new DV_TEXT();
            return this.function;
        }
        if (name.equals("mode")) {
            this.mode = new DV_CODED_TEXT();
            return this.mode;
        }
        if (name.equals("performer")) {
            throw new FHIRException("Cannot call addChild on an abstract type PARTICIPATION.performer");
        }
        if (name.equals("time")) {
            this.time = new DV_INTERVAL();
            return this.time;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PARTICIPATION";
    }

    @Override
    public PARTICIPATION copy() {
        PARTICIPATION dst = new PARTICIPATION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(PARTICIPATION dst) {
        super.copyValues(dst);
        dst.function = this.function == null ? null : this.function.copy();
        dst.mode = this.mode == null ? null : this.mode.copy();
        dst.performer = this.performer == null ? null : this.performer.copy();
        dst.time = this.time == null ? null : this.time.copy();
    }

    protected PARTICIPATION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PARTICIPATION)) {
            return false;
        }
        PARTICIPATION o = (PARTICIPATION)other_;
        return PARTICIPATION.compareDeep(this.function, o.function, true) && PARTICIPATION.compareDeep(this.mode, o.mode, true) && PARTICIPATION.compareDeep(this.performer, o.performer, true) && PARTICIPATION.compareDeep(this.time, o.time, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PARTICIPATION)) {
            return false;
        }
        PARTICIPATION o = (PARTICIPATION)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.mode, this.performer, this.time});
    }
}

