/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.PARTY_IDENTIFIED;

@DatatypeDef(name="PARTY_RELATED")
public class PARTY_RELATED
extends PARTY_IDENTIFIED
implements ICompositeType {
    @Child(name="relationship", type={DV_CODED_TEXT.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Relationship of subject of this ENTRY to the subject of the record. May be coded", formalDefinition="Relationship of subject of this ENTRY to the subject of the record. May be coded. If it is the patient, coded as self.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-subject_relationship")
    protected DV_CODED_TEXT relationship;
    private static final long serialVersionUID = -391010544L;

    public PARTY_RELATED() {
    }

    public PARTY_RELATED(DV_CODED_TEXT relationship) {
        this.setRelationship(relationship);
    }

    public DV_CODED_TEXT getRelationship() {
        if (this.relationship == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PARTY_RELATED.relationship");
            }
            if (Configuration.doAutoCreate()) {
                this.relationship = new DV_CODED_TEXT();
            }
        }
        return this.relationship;
    }

    public boolean hasRelationship() {
        return this.relationship != null && !this.relationship.isEmpty();
    }

    public PARTY_RELATED setRelationship(DV_CODED_TEXT value) {
        this.relationship = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("relationship", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Relationship of subject of this ENTRY to the subject of the record. May be coded. If it is the patient, coded as self.", 0, 1, this.relationship));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -261851592: {
                return new Property("relationship", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Relationship of subject of this ENTRY to the subject of the record. May be coded. If it is the patient, coded as self.", 0, 1, this.relationship);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -261851592: {
                Base[] baseArray;
                if (this.relationship == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.relationship;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -261851592: {
                this.relationship = (DV_CODED_TEXT)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("relationship")) {
            return super.setProperty(name, value);
        }
        this.relationship = (DV_CODED_TEXT)value;
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -261851592: {
                return this.getRelationship();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -261851592: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("relationship")) {
            this.relationship = new DV_CODED_TEXT();
            return this.relationship;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PARTY_RELATED";
    }

    @Override
    public PARTY_RELATED copy() {
        PARTY_RELATED dst = new PARTY_RELATED();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(PARTY_RELATED dst) {
        super.copyValues(dst);
        dst.relationship = this.relationship == null ? null : this.relationship.copy();
    }

    @Override
    protected PARTY_RELATED typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PARTY_RELATED)) {
            return false;
        }
        PARTY_RELATED o = (PARTY_RELATED)other_;
        return PARTY_RELATED.compareDeep(this.relationship, o.relationship, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PARTY_RELATED)) {
            return false;
        }
        PARTY_RELATED o = (PARTY_RELATED)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.relationship});
    }
}

