/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.ARCHETYPED;
import org.hl7.fhir.r5.openehr.Any;
import org.hl7.fhir.r5.openehr.DV_TEXT;
import org.hl7.fhir.r5.openehr.FEEDER_AUDIT;
import org.hl7.fhir.r5.openehr.LINK;
import org.hl7.fhir.r5.openehr.UID_BASED_ID;

@DatatypeDef(name="PATHABLE")
public abstract class PATHABLE
extends Any
implements ICompositeType {
    @Child(name="name", type={DV_TEXT.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Runtime name of this fragment, used to build runtime paths", formalDefinition="This is the term provided via a clinical application or batch process to name this EHR construct: its retention in the EHR faithfully preserves the original label by which this entry was known to end users.")
    protected DV_TEXT name;
    @Child(name="archetype_node_id", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Design-time archetype identifier of this node taken from its generating archetype", formalDefinition="Design-time archetype identifier of this node taken from its generating archetype; used to build archetype paths. Always in the form of an at-code, e.g. at0005. This value enables a 'standardised' name for this node to be generated, by referring to the generating archetype local terminology.")
    protected StringType archetype_node_id;
    @Child(name="uid", type={UID_BASED_ID.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional globally unique object identifier for root points of archetyped structures", formalDefinition="Optional globally unique object identifier for root points of archetyped structures.")
    protected UID_BASED_ID uid;
    @Child(name="links", type={LINK.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Links to other archetyped structures", formalDefinition="Links to other archetyped structures (data whose root object inherits from ARCHETYPED, such as ENTRY, SECTION and so on). Links may be to structures in other compositions.")
    protected List<LINK> linksList;
    @Child(name="archetype_details", type={ARCHETYPED.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details of archetyping used on this node", formalDefinition="Details of archetyping used on this node.")
    protected ARCHETYPED archetype_details;
    @Child(name="feeder_audit", type={FEEDER_AUDIT.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Audit trail from non-openEHR system of original commit of information forming the content of this node", formalDefinition="Audit trail from non-openEHR system of original commit of information forming the content of this node, or from a conversion gateway which has synthesised this node.")
    protected FEEDER_AUDIT feeder_audit;
    private static final long serialVersionUID = 802051356L;

    public PATHABLE() {
    }

    public PATHABLE(DV_TEXT name, String archetype_node_id) {
        this.setName(name);
        this.setArchetype_node_id(archetype_node_id);
    }

    public DV_TEXT getName() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PATHABLE.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new DV_TEXT();
            }
        }
        return this.name;
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public PATHABLE setName(DV_TEXT value) {
        this.name = value;
        return this;
    }

    public StringType getArchetype_node_idElement() {
        if (this.archetype_node_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PATHABLE.archetype_node_id");
            }
            if (Configuration.doAutoCreate()) {
                this.archetype_node_id = new StringType();
            }
        }
        return this.archetype_node_id;
    }

    public boolean hasArchetype_node_idElement() {
        return this.archetype_node_id != null && !this.archetype_node_id.isEmpty();
    }

    public boolean hasArchetype_node_id() {
        return this.archetype_node_id != null && !this.archetype_node_id.isEmpty();
    }

    public PATHABLE setArchetype_node_idElement(StringType value) {
        this.archetype_node_id = value;
        return this;
    }

    public String getArchetype_node_id() {
        return this.archetype_node_id == null ? null : (String)this.archetype_node_id.getValue();
    }

    public PATHABLE setArchetype_node_id(String value) {
        if (this.archetype_node_id == null) {
            this.archetype_node_id = new StringType();
        }
        this.archetype_node_id.setValue(value);
        return this;
    }

    public UID_BASED_ID getUid() {
        return this.uid;
    }

    public boolean hasUid() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public PATHABLE setUid(UID_BASED_ID value) {
        this.uid = value;
        return this;
    }

    public List<LINK> getLinksList() {
        if (this.linksList == null) {
            this.linksList = new ArrayList<LINK>();
        }
        return this.linksList;
    }

    public PATHABLE setLinksList(List<LINK> theLinks) {
        this.linksList = theLinks;
        return this;
    }

    public boolean hasLinks() {
        if (this.linksList == null) {
            return false;
        }
        for (LINK item : this.linksList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LINK addLinks() {
        LINK t = new LINK();
        if (this.linksList == null) {
            this.linksList = new ArrayList<LINK>();
        }
        this.linksList.add(t);
        return t;
    }

    public PATHABLE addLinks(LINK t) {
        if (t == null) {
            return this;
        }
        if (this.linksList == null) {
            this.linksList = new ArrayList<LINK>();
        }
        this.linksList.add(t);
        return this;
    }

    public LINK getLinksFirstRep() {
        if (this.getLinksList().isEmpty()) {
            this.addLinks();
        }
        return this.getLinksList().get(0);
    }

    public ARCHETYPED getArchetype_details() {
        if (this.archetype_details == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PATHABLE.archetype_details");
            }
            if (Configuration.doAutoCreate()) {
                this.archetype_details = new ARCHETYPED();
            }
        }
        return this.archetype_details;
    }

    public boolean hasArchetype_details() {
        return this.archetype_details != null && !this.archetype_details.isEmpty();
    }

    public PATHABLE setArchetype_details(ARCHETYPED value) {
        this.archetype_details = value;
        return this;
    }

    public FEEDER_AUDIT getFeeder_audit() {
        if (this.feeder_audit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PATHABLE.feeder_audit");
            }
            if (Configuration.doAutoCreate()) {
                this.feeder_audit = new FEEDER_AUDIT();
            }
        }
        return this.feeder_audit;
    }

    public boolean hasFeeder_audit() {
        return this.feeder_audit != null && !this.feeder_audit.isEmpty();
    }

    public PATHABLE setFeeder_audit(FEEDER_AUDIT value) {
        this.feeder_audit = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("name", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "This is the term provided via a clinical application or batch process to name this EHR construct: its retention in the EHR faithfully preserves the original label by which this entry was known to end users.", 0, 1, this.name));
        children.add(new Property("archetype_node_id", "string", "Design-time archetype identifier of this node taken from its generating archetype; used to build archetype paths. Always in the form of an at-code, e.g. at0005. This value enables a 'standardised' name for this node to be generated, by referring to the generating archetype local terminology.", 0, 1, this.archetype_node_id));
        children.add(new Property("uid", "http://openehr.org/fhir/StructureDefinition/UID-BASED-ID", "Optional globally unique object identifier for root points of archetyped structures.", 0, 1, this.uid));
        children.add(new Property("links", "http://openehr.org/fhir/StructureDefinition/LINK", "Links to other archetyped structures (data whose root object inherits from ARCHETYPED, such as ENTRY, SECTION and so on). Links may be to structures in other compositions.", 0, Integer.MAX_VALUE, this.linksList));
        children.add(new Property("archetype_details", "http://openehr.org/fhir/StructureDefinition/ARCHETYPED", "Details of archetyping used on this node.", 0, 1, this.archetype_details));
        children.add(new Property("feeder_audit", "http://openehr.org/fhir/StructureDefinition/FEEDER-AUDIT", "Audit trail from non-openEHR system of original commit of information forming the content of this node, or from a conversion gateway which has synthesised this node.", 0, 1, this.feeder_audit));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3373707: {
                return new Property("name", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "This is the term provided via a clinical application or batch process to name this EHR construct: its retention in the EHR faithfully preserves the original label by which this entry was known to end users.", 0, 1, this.name);
            }
            case -448281406: {
                return new Property("archetype_node_id", "string", "Design-time archetype identifier of this node taken from its generating archetype; used to build archetype paths. Always in the form of an at-code, e.g. at0005. This value enables a 'standardised' name for this node to be generated, by referring to the generating archetype local terminology.", 0, 1, this.archetype_node_id);
            }
            case 115792: {
                return new Property("uid", "http://openehr.org/fhir/StructureDefinition/UID-BASED-ID", "Optional globally unique object identifier for root points of archetyped structures.", 0, 1, this.uid);
            }
            case 102977465: {
                return new Property("links", "http://openehr.org/fhir/StructureDefinition/LINK", "Links to other archetyped structures (data whose root object inherits from ARCHETYPED, such as ENTRY, SECTION and so on). Links may be to structures in other compositions.", 0, Integer.MAX_VALUE, this.linksList);
            }
            case -1005008244: {
                return new Property("archetype_details", "http://openehr.org/fhir/StructureDefinition/ARCHETYPED", "Details of archetyping used on this node.", 0, 1, this.archetype_details);
            }
            case 1287552359: {
                return new Property("feeder_audit", "http://openehr.org/fhir/StructureDefinition/FEEDER-AUDIT", "Audit trail from non-openEHR system of original commit of information forming the content of this node, or from a conversion gateway which has synthesised this node.", 0, 1, this.feeder_audit);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case -448281406: {
                Base[] baseArray;
                if (this.archetype_node_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.archetype_node_id;
                }
                return baseArray;
            }
            case 115792: {
                Base[] baseArray;
                if (this.uid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.uid;
                }
                return baseArray;
            }
            case 102977465: {
                return this.linksList == null ? new Base[]{} : this.linksList.toArray(new Base[this.linksList.size()]);
            }
            case -1005008244: {
                Base[] baseArray;
                if (this.archetype_details == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.archetype_details;
                }
                return baseArray;
            }
            case 1287552359: {
                Base[] baseArray;
                if (this.feeder_audit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.feeder_audit;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3373707: {
                this.name = (DV_TEXT)value;
                return value;
            }
            case -448281406: {
                this.archetype_node_id = TypeConvertor.castToString(value);
                return value;
            }
            case 115792: {
                this.uid = (UID_BASED_ID)value;
                return value;
            }
            case 102977465: {
                this.getLinksList().add((LINK)value);
                return value;
            }
            case -1005008244: {
                this.archetype_details = (ARCHETYPED)value;
                return value;
            }
            case 1287552359: {
                this.feeder_audit = (FEEDER_AUDIT)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("name")) {
            this.name = (DV_TEXT)value;
        } else if (name.equals("archetype_node_id")) {
            this.archetype_node_id = TypeConvertor.castToString(value);
        } else if (name.equals("uid")) {
            this.uid = (UID_BASED_ID)value;
        } else if (name.equals("links")) {
            this.getLinksList().add((LINK)value);
        } else if (name.equals("archetype_details")) {
            this.archetype_details = (ARCHETYPED)value;
        } else if (name.equals("feeder_audit")) {
            this.feeder_audit = (FEEDER_AUDIT)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3373707: {
                return this.getName();
            }
            case -448281406: {
                return this.getArchetype_node_idElement();
            }
            case 115792: {
                throw new Error("Unable to make an instance of the abstract property 'uid'");
            }
            case 102977465: {
                return this.addLinks();
            }
            case -1005008244: {
                return this.getArchetype_details();
            }
            case 1287552359: {
                return this.getFeeder_audit();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3373707: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-TEXT"};
            }
            case -448281406: {
                return new String[]{"string"};
            }
            case 115792: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/UID-BASED-ID"};
            }
            case 102977465: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/LINK"};
            }
            case -1005008244: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ARCHETYPED"};
            }
            case 1287552359: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/FEEDER-AUDIT"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("name")) {
            this.name = new DV_TEXT();
            return this.name;
        }
        if (name.equals("archetype_node_id")) {
            throw new FHIRException("Cannot call addChild on a singleton property PATHABLE.archetype_node_id");
        }
        if (name.equals("uid")) {
            throw new FHIRException("Cannot call addChild on an abstract type PATHABLE.uid");
        }
        if (name.equals("links")) {
            return this.addLinks();
        }
        if (name.equals("archetype_details")) {
            this.archetype_details = new ARCHETYPED();
            return this.archetype_details;
        }
        if (name.equals("feeder_audit")) {
            this.feeder_audit = new FEEDER_AUDIT();
            return this.feeder_audit;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PATHABLE";
    }

    @Override
    public abstract PATHABLE copy();

    public void copyValues(PATHABLE dst) {
        super.copyValues(dst);
        dst.name = this.name == null ? null : this.name.copy();
        dst.archetype_node_id = this.archetype_node_id == null ? null : this.archetype_node_id.copy();
        UID_BASED_ID uID_BASED_ID = dst.uid = this.uid == null ? null : this.uid.copy();
        if (this.linksList != null) {
            dst.linksList = new ArrayList<LINK>();
            for (LINK i : this.linksList) {
                dst.linksList.add(i.copy());
            }
        }
        dst.archetype_details = this.archetype_details == null ? null : this.archetype_details.copy();
        dst.feeder_audit = this.feeder_audit == null ? null : this.feeder_audit.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PATHABLE)) {
            return false;
        }
        PATHABLE o = (PATHABLE)other_;
        return PATHABLE.compareDeep(this.name, o.name, true) && PATHABLE.compareDeep(this.archetype_node_id, o.archetype_node_id, true) && PATHABLE.compareDeep(this.uid, o.uid, true) && PATHABLE.compareDeep(this.linksList, o.linksList, true) && PATHABLE.compareDeep(this.archetype_details, o.archetype_details, true) && PATHABLE.compareDeep(this.feeder_audit, o.feeder_audit, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PATHABLE)) {
            return false;
        }
        PATHABLE o = (PATHABLE)other_;
        return PATHABLE.compareValues(this.archetype_node_id, o.archetype_node_id, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.archetype_node_id, this.uid, this.linksList, this.archetype_details, this.feeder_audit});
    }
}

