/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;

@DatatypeDef(name="TERM_MAPPING")
public class TERM_MAPPING
extends LogicalBase
implements ICompositeType {
    @Child(name="match", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="> | = | < | ?: The relative match of the target term with respect to the mapped text item", formalDefinition="The relative match of the target term with respect to the mapped text item. Result meanings:\n\n* '>': the mapping is to a broader term e.g. orginal text = arbovirus infection , target = viral infection\n* '=': the mapping is to a (supposedly) equivalent to the original item\n* '<': the mapping is to a narrower term. e.g. original text = diabetes , mapping = diabetes mellitus.\n* '?': the kind of mapping is unknown.\n\nThe first three values are taken from the ISO standards 2788 ( Guide to Establishment and development of monolingual thesauri) and 5964 (Guide to Establishment and development of multilingual thesauri).")
    protected StringType match;
    @Child(name="purpose", type={DV_CODED_TEXT.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Purpose of the mapping", formalDefinition="Purpose of the mapping e.g. 'automated data mining', 'billing', 'interoperability'.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-term_mapping_purpose")
    protected DV_CODED_TEXT purpose;
    @Child(name="target", type={CODE_PHRASE.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The target term of the mapping", formalDefinition="The target term of the mapping.")
    protected CODE_PHRASE target;
    private static final long serialVersionUID = -331225696L;

    public TERM_MAPPING() {
    }

    public TERM_MAPPING(String match, CODE_PHRASE target) {
        this.setMatch(match);
        this.setTarget(target);
    }

    public StringType getMatchElement() {
        if (this.match == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TERM_MAPPING.match");
            }
            if (Configuration.doAutoCreate()) {
                this.match = new StringType();
            }
        }
        return this.match;
    }

    public boolean hasMatchElement() {
        return this.match != null && !this.match.isEmpty();
    }

    public boolean hasMatch() {
        return this.match != null && !this.match.isEmpty();
    }

    public TERM_MAPPING setMatchElement(StringType value) {
        this.match = value;
        return this;
    }

    public String getMatch() {
        return this.match == null ? null : (String)this.match.getValue();
    }

    public TERM_MAPPING setMatch(String value) {
        if (this.match == null) {
            this.match = new StringType();
        }
        this.match.setValue(value);
        return this;
    }

    public DV_CODED_TEXT getPurpose() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TERM_MAPPING.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new DV_CODED_TEXT();
            }
        }
        return this.purpose;
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public TERM_MAPPING setPurpose(DV_CODED_TEXT value) {
        this.purpose = value;
        return this;
    }

    public CODE_PHRASE getTarget() {
        if (this.target == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TERM_MAPPING.target");
            }
            if (Configuration.doAutoCreate()) {
                this.target = new CODE_PHRASE();
            }
        }
        return this.target;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public TERM_MAPPING setTarget(CODE_PHRASE value) {
        this.target = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("match", "string", "The relative match of the target term with respect to the mapped text item. Result meanings:\n\n* '>': the mapping is to a broader term e.g. orginal text = arbovirus infection , target = viral infection\n* '=': the mapping is to a (supposedly) equivalent to the original item\n* '<': the mapping is to a narrower term. e.g. original text = diabetes , mapping = diabetes mellitus.\n* '?': the kind of mapping is unknown.\n\nThe first three values are taken from the ISO standards 2788 ( Guide to Establishment and development of monolingual thesauri) and 5964 (Guide to Establishment and development of multilingual thesauri).", 0, 1, this.match));
        children.add(new Property("purpose", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Purpose of the mapping e.g. 'automated data mining', 'billing', 'interoperability'.", 0, 1, this.purpose));
        children.add(new Property("target", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "The target term of the mapping.", 0, 1, this.target));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 103668165: {
                return new Property("match", "string", "The relative match of the target term with respect to the mapped text item. Result meanings:\n\n* '>': the mapping is to a broader term e.g. orginal text = arbovirus infection , target = viral infection\n* '=': the mapping is to a (supposedly) equivalent to the original item\n* '<': the mapping is to a narrower term. e.g. original text = diabetes , mapping = diabetes mellitus.\n* '?': the kind of mapping is unknown.\n\nThe first three values are taken from the ISO standards 2788 ( Guide to Establishment and development of monolingual thesauri) and 5964 (Guide to Establishment and development of multilingual thesauri).", 0, 1, this.match);
            }
            case -220463842: {
                return new Property("purpose", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Purpose of the mapping e.g. 'automated data mining', 'billing', 'interoperability'.", 0, 1, this.purpose);
            }
            case -880905839: {
                return new Property("target", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "The target term of the mapping.", 0, 1, this.target);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 103668165: {
                Base[] baseArray;
                if (this.match == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.match;
                }
                return baseArray;
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.purpose;
                }
                return baseArray;
            }
            case -880905839: {
                Base[] baseArray;
                if (this.target == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.target;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 103668165: {
                this.match = TypeConvertor.castToString(value);
                return value;
            }
            case -220463842: {
                this.purpose = (DV_CODED_TEXT)value;
                return value;
            }
            case -880905839: {
                this.target = (CODE_PHRASE)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("match")) {
            this.match = TypeConvertor.castToString(value);
        } else if (name.equals("purpose")) {
            this.purpose = (DV_CODED_TEXT)value;
        } else if (name.equals("target")) {
            this.target = (CODE_PHRASE)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 103668165: {
                return this.getMatchElement();
            }
            case -220463842: {
                return this.getPurpose();
            }
            case -880905839: {
                return this.getTarget();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 103668165: {
                return new String[]{"string"};
            }
            case -220463842: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case -880905839: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("match")) {
            throw new FHIRException("Cannot call addChild on a singleton property TERM_MAPPING.match");
        }
        if (name.equals("purpose")) {
            this.purpose = new DV_CODED_TEXT();
            return this.purpose;
        }
        if (name.equals("target")) {
            this.target = new CODE_PHRASE();
            return this.target;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "TERM_MAPPING";
    }

    @Override
    public TERM_MAPPING copy() {
        TERM_MAPPING dst = new TERM_MAPPING();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(TERM_MAPPING dst) {
        super.copyValues(dst);
        dst.match = this.match == null ? null : this.match.copy();
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.target = this.target == null ? null : this.target.copy();
    }

    protected TERM_MAPPING typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof TERM_MAPPING)) {
            return false;
        }
        TERM_MAPPING o = (TERM_MAPPING)other_;
        return TERM_MAPPING.compareDeep(this.match, o.match, true) && TERM_MAPPING.compareDeep(this.purpose, o.purpose, true) && TERM_MAPPING.compareDeep(this.target, o.target, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof TERM_MAPPING)) {
            return false;
        }
        TERM_MAPPING o = (TERM_MAPPING)other_;
        return TERM_MAPPING.compareValues(this.match, o.match, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.match, this.purpose, this.target});
    }
}

