/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.AUDIT_DETAILS;
import org.hl7.fhir.r5.openehr.OBJECT_REF;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="VERSION")
public abstract class VERSION
extends LogicalBase
implements ICompositeType {
    @Child(name="contribution", type={OBJECT_REF.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Contribution in which this version was added", formalDefinition="Contribution in which this version was added.")
    protected OBJECT_REF contribution;
    @Child(name="signature", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="OpenPGP digital signature or digest of content committed in this Version", formalDefinition="OpenPGP digital signature or digest of content committed in this Version.")
    protected StringType signature;
    @Child(name="commit_audit", type={AUDIT_DETAILS.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Audit trail corresponding to the committal of this version to the VERSIONED_OBJECT", formalDefinition="Audit trail corresponding to the committal of this version to the VERSIONED_OBJECT.")
    protected AUDIT_DETAILS commit_audit;
    private static final long serialVersionUID = 1394455611L;

    public VERSION() {
    }

    public VERSION(OBJECT_REF contribution, AUDIT_DETAILS commit_audit) {
        this.setContribution(contribution);
        this.setCommit_audit(commit_audit);
    }

    public OBJECT_REF getContribution() {
        if (this.contribution == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VERSION.contribution");
            }
            if (Configuration.doAutoCreate()) {
                this.contribution = new OBJECT_REF();
            }
        }
        return this.contribution;
    }

    public boolean hasContribution() {
        return this.contribution != null && !this.contribution.isEmpty();
    }

    public VERSION setContribution(OBJECT_REF value) {
        this.contribution = value;
        return this;
    }

    public StringType getSignatureElement() {
        if (this.signature == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VERSION.signature");
            }
            if (Configuration.doAutoCreate()) {
                this.signature = new StringType();
            }
        }
        return this.signature;
    }

    public boolean hasSignatureElement() {
        return this.signature != null && !this.signature.isEmpty();
    }

    public boolean hasSignature() {
        return this.signature != null && !this.signature.isEmpty();
    }

    public VERSION setSignatureElement(StringType value) {
        this.signature = value;
        return this;
    }

    public String getSignature() {
        return this.signature == null ? null : (String)this.signature.getValue();
    }

    public VERSION setSignature(String value) {
        if (Utilities.noString((String)value)) {
            this.signature = null;
        } else {
            if (this.signature == null) {
                this.signature = new StringType();
            }
            this.signature.setValue(value);
        }
        return this;
    }

    public AUDIT_DETAILS getCommit_audit() {
        if (this.commit_audit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VERSION.commit_audit");
            }
            if (Configuration.doAutoCreate()) {
                this.commit_audit = new AUDIT_DETAILS();
            }
        }
        return this.commit_audit;
    }

    public boolean hasCommit_audit() {
        return this.commit_audit != null && !this.commit_audit.isEmpty();
    }

    public VERSION setCommit_audit(AUDIT_DETAILS value) {
        this.commit_audit = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("contribution", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Contribution in which this version was added.", 0, 1, this.contribution));
        children.add(new Property("signature", "string", "OpenPGP digital signature or digest of content committed in this Version.", 0, 1, this.signature));
        children.add(new Property("commit_audit", "http://openehr.org/fhir/StructureDefinition/AUDIT-DETAILS", "Audit trail corresponding to the committal of this version to the VERSIONED_OBJECT.", 0, 1, this.commit_audit));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1375970320: {
                return new Property("contribution", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Contribution in which this version was added.", 0, 1, this.contribution);
            }
            case 1073584312: {
                return new Property("signature", "string", "OpenPGP digital signature or digest of content committed in this Version.", 0, 1, this.signature);
            }
            case -392355117: {
                return new Property("commit_audit", "http://openehr.org/fhir/StructureDefinition/AUDIT-DETAILS", "Audit trail corresponding to the committal of this version to the VERSIONED_OBJECT.", 0, 1, this.commit_audit);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1375970320: {
                Base[] baseArray;
                if (this.contribution == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.contribution;
                }
                return baseArray;
            }
            case 1073584312: {
                Base[] baseArray;
                if (this.signature == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.signature;
                }
                return baseArray;
            }
            case -392355117: {
                Base[] baseArray;
                if (this.commit_audit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.commit_audit;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1375970320: {
                this.contribution = (OBJECT_REF)value;
                return value;
            }
            case 1073584312: {
                this.signature = TypeConvertor.castToString(value);
                return value;
            }
            case -392355117: {
                this.commit_audit = (AUDIT_DETAILS)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("contribution")) {
            this.contribution = (OBJECT_REF)value;
        } else if (name.equals("signature")) {
            this.signature = TypeConvertor.castToString(value);
        } else if (name.equals("commit_audit")) {
            this.commit_audit = (AUDIT_DETAILS)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1375970320: {
                return this.getContribution();
            }
            case 1073584312: {
                return this.getSignatureElement();
            }
            case -392355117: {
                return this.getCommit_audit();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1375970320: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
            case 1073584312: {
                return new String[]{"string"};
            }
            case -392355117: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/AUDIT-DETAILS"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("contribution")) {
            this.contribution = new OBJECT_REF();
            return this.contribution;
        }
        if (name.equals("signature")) {
            throw new FHIRException("Cannot call addChild on a singleton property VERSION.signature");
        }
        if (name.equals("commit_audit")) {
            this.commit_audit = new AUDIT_DETAILS();
            return this.commit_audit;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "VERSION";
    }

    @Override
    public abstract VERSION copy();

    public void copyValues(VERSION dst) {
        super.copyValues(dst);
        dst.contribution = this.contribution == null ? null : this.contribution.copy();
        dst.signature = this.signature == null ? null : this.signature.copy();
        dst.commit_audit = this.commit_audit == null ? null : this.commit_audit.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof VERSION)) {
            return false;
        }
        VERSION o = (VERSION)other_;
        return VERSION.compareDeep(this.contribution, o.contribution, true) && VERSION.compareDeep(this.signature, o.signature, true) && VERSION.compareDeep(this.commit_audit, o.commit_audit, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof VERSION)) {
            return false;
        }
        VERSION o = (VERSION)other_;
        return VERSION.compareValues(this.signature, o.signature, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.contribution, this.signature, this.commit_audit});
    }
}

