/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.WebTemplateTermBindingValue;

@DatatypeDef(name="WebTemplateTermBinding")
public class WebTemplateTermBinding
extends LogicalBase
implements ICompositeType {
    @Child(name="code", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Which terminology is bound", formalDefinition="")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-term-binding-type")
    protected CodeType code;
    @Child(name="value", type={WebTemplateTermBindingValue.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The binding", formalDefinition="")
    protected WebTemplateTermBindingValue value;
    private static final long serialVersionUID = -1040833865L;

    public WebTemplateTermBinding() {
    }

    public WebTemplateTermBinding(String code, WebTemplateTermBindingValue value) {
        this.setCode(code);
        this.setValue(value);
    }

    public CodeType getCodeElement() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateTermBinding.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeType();
            }
        }
        return this.code;
    }

    public boolean hasCodeElement() {
        return this.code != null && !this.code.isEmpty();
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public WebTemplateTermBinding setCodeElement(CodeType value) {
        this.code = value;
        return this;
    }

    public String getCode() {
        return this.code == null ? null : (String)this.code.getValue();
    }

    public WebTemplateTermBinding setCode(String value) {
        if (this.code == null) {
            this.code = new CodeType();
        }
        this.code.setValue(value);
        return this;
    }

    public WebTemplateTermBindingValue getValue() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateTermBinding.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new WebTemplateTermBindingValue();
            }
        }
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public WebTemplateTermBinding setValue(WebTemplateTermBindingValue value) {
        this.value = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("code", "code", "", 0, 1, this.code));
        children.add(new Property("value", "http://openehr.org/fhir/StructureDefinition/WebTemplateTermBindingValue", "", 0, 1, this.value));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3059181: {
                return new Property("code", "code", "", 0, 1, this.code);
            }
            case 111972721: {
                return new Property("value", "http://openehr.org/fhir/StructureDefinition/WebTemplateTermBindingValue", "", 0, 1, this.value);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.code;
                }
                return baseArray;
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.value;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3059181: {
                this.code = TypeConvertor.castToCode(value);
                return value;
            }
            case 111972721: {
                this.value = (WebTemplateTermBindingValue)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("code")) {
            this.code = TypeConvertor.castToCode(value);
        } else if (name.equals("value")) {
            this.value = (WebTemplateTermBindingValue)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3059181: {
                return this.getCodeElement();
            }
            case 111972721: {
                return this.getValue();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3059181: {
                return new String[]{"code"};
            }
            case 111972721: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/WebTemplateTermBindingValue"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("code")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateTermBinding.code");
        }
        if (name.equals("value")) {
            this.value = new WebTemplateTermBindingValue();
            return this.value;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "WebTemplateTermBinding";
    }

    @Override
    public WebTemplateTermBinding copy() {
        WebTemplateTermBinding dst = new WebTemplateTermBinding();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(WebTemplateTermBinding dst) {
        super.copyValues(dst);
        dst.code = this.code == null ? null : this.code.copy();
        dst.value = this.value == null ? null : this.value.copy();
    }

    protected WebTemplateTermBinding typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplateTermBinding)) {
            return false;
        }
        WebTemplateTermBinding o = (WebTemplateTermBinding)other_;
        return WebTemplateTermBinding.compareDeep(this.code, o.code, true) && WebTemplateTermBinding.compareDeep(this.value, o.value, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplateTermBinding)) {
            return false;
        }
        WebTemplateTermBinding o = (WebTemplateTermBinding)other_;
        return WebTemplateTermBinding.compareValues(this.code, o.code, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.value});
    }
}

