/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.conformance.profile.SnapshotGenerationPreProcessor;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.DataRenderer;
import org.hl7.fhir.r5.renderers.StructureDefinitionRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ClassDiagramRenderer {
    private static final String SLICE_COLOR = "#62A856";
    private static final double CHAR_RATIO = 4.4;
    private RenderingContext rc;
    private IWorkerContext context;
    private ContextUtilities cutils;
    private ProfileUtilities putils;
    private Map<String, PointSpec> layout;
    private Map<String, LinkInfo> linkLayouts;
    private String sourceFolder;
    private String destFolder;
    private double minx = 0.0;
    private double miny = 0.0;
    private String prefix;
    private String diagramId;
    private Map<String, ClassItem> classes = new HashMap<String, ClassItem>();
    private boolean attributes;
    private boolean innerClasses;
    private boolean constraintMode;
    private int nc = 0;
    private List<Link> links = new ArrayList<Link>();
    private List<String> classNames = new ArrayList<String>();
    String lang;
    private static final double LINE_HEIGHT = 16.0;
    private static final double HEADER_HEIGHT = 20.0;
    private static final double GAP_HEIGHT = 4.0;
    private static final double LEFT_MARGIN = 6.0;
    private static final double SELF_LINK_HEIGHT = 25.0;
    private static final double SELF_LINK_WIDTH = 60.0;
    private static final double DUPLICATE_GAP = 50.0;
    private static final double MARGIN_X = 100.0;
    private static final double MARGIN_Y = 10.0;
    private static final double WRAP_INDENT = 20.0;
    private static final int LINE_MAX = 60;
    public static final int MAX_NEG = -1000000;
    private static final double UML_ROW_HEIGHT = 100.0;

    public ClassDiagramRenderer(String sourceFolder, String destFolder, String diagramId, String prefix, RenderingContext rc, String lang) throws IOException {
        this.sourceFolder = sourceFolder;
        this.destFolder = destFolder;
        this.rc = rc;
        this.context = rc.getContext();
        this.cutils = rc.getContextUtilities();
        this.putils = rc.getProfileUtilities();
        File f = new File(destFolder);
        if (!f.exists()) {
            FileUtilities.createDirectory((String)destFolder);
        }
        this.layout = new HashMap<String, PointSpec>();
        this.linkLayouts = new HashMap<String, LinkInfo>();
        if (diagramId == null) {
            throw new Error("An id is required");
        }
        this.diagramId = diagramId;
        this.prefix = prefix == null ? "" : prefix;
        this.lang = lang;
    }

    public boolean hasSource() {
        try {
            File f = new File(Utilities.path((String[])new String[]{this.sourceFolder, this.diagramId + ".svg"}));
            return f.exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    public String buildClassDiagram(JsonObject control) throws Exception {
        File f = new File(Utilities.path((String[])new String[]{this.sourceFolder, this.diagramId + ".svg"}));
        if (f.exists()) {
            this.parseSvgFile(f, f.getAbsolutePath());
        }
        this.attributes = control.asBoolean("attributes");
        this.innerClasses = !control.asBoolean("no-inner-classes");
        this.classNames = control.forceArray("classes").asStrings();
        XhtmlNode doc = new XhtmlNode(NodeType.Element, "div");
        XhtmlNode svg = doc.svg();
        this.minx = 0.0;
        this.miny = 0.0;
        Point size = this.determineMetrics(this.classNames);
        this.adjustAllForMin(size);
        svg.attribute("id", this.prefix + "n" + ++this.nc);
        svg.attribute("version", "1.1");
        svg.attribute("width", Integer.toString(Utilities.parseInt((String)control.forceObject("size").asString("width"), (int)((int)size.x))));
        svg.attribute("height", Integer.toString(Utilities.parseInt((String)control.forceObject("size").asString("height"), (int)((int)size.y))));
        this.shadowFilter(svg);
        this.drawElement(svg, this.classNames);
        this.countDuplicateLinks();
        XhtmlNode insertionPoint = svg.getChildNodes().get(0);
        for (Link l : this.links) {
            this.drawLink(svg, l, insertionPoint);
        }
        String s = new XhtmlComposer(true, true).compose(doc.getChildNodes());
        this.produceOutput("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + s);
        return s;
    }

    public String buildClassDiagram(StructureDefinition sd) throws FHIRException, IOException {
        File f = new File(Utilities.path((String[])new String[]{this.sourceFolder, this.diagramId + ".svg"}));
        if (f.exists()) {
            this.parseSvgFile(f, f.getAbsolutePath());
        }
        this.attributes = true;
        this.innerClasses = true;
        this.classNames.add(sd.getName());
        XhtmlNode doc = new XhtmlNode(NodeType.Element, "div");
        XhtmlNode svg = doc.svg();
        this.minx = 0.0;
        this.miny = 0.0;
        Point size = this.determineClassMetrics(sd);
        this.adjustAllForMin(size);
        svg.attribute("id", this.prefix + "n" + ++this.nc);
        svg.attribute("version", "1.1");
        svg.attribute("width", Double.toString(size.x));
        svg.attribute("height", Double.toString(size.y));
        this.shadowFilter(svg);
        this.drawClassElement(svg, sd);
        this.countDuplicateLinks();
        XhtmlNode insertionPoint = svg.getChildNodes().get(0);
        for (Link l : this.links) {
            this.drawLink(svg, l, insertionPoint);
        }
        String s = new XhtmlComposer(true, true).compose(doc.getChildNodes());
        this.produceOutput("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + s);
        return s;
    }

    private void produceOutput(String s) throws IOException {
        if ("".equals(this.prefix)) {
            String svg = this.standaloneSVG(s);
            String html = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE HTML>\n<html xml:lang=\"en\" xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\">\n  <head>\n    <meta content=\"text/html;charset=utf-8\" http-equiv=\"Content-Type\"/>\n    <title>" + this.diagramId + " Class Diagram</title>\n    <link href=\"assets/fhir.css\" rel=\"stylesheet\"/>\n  </head>\n  <body>\n  <h2>Embedded SVG</h2>\n" + s + "\r\n  <h2>External SVG</h2>\n    <embed src=\"" + this.diagramId + ".svg\" type=\"image/svg+xml\">\n  </body>\n</html>";
            FileUtilities.stringToFile((String)svg, (String)Utilities.path((String[])new String[]{this.destFolder, this.diagramId + ".svg"}));
            FileUtilities.stringToFile((String)html, (String)Utilities.path((String[])new String[]{this.destFolder, this.diagramId + ".html"}));
        }
    }

    private String standaloneSVG(String s) {
        String css = "<?xml-stylesheet href=\"assets/fhir.css\" type=\"text/css\"?>";
        int i = ((String)s).indexOf(">") + 1;
        s = ((String)s).substring(0, i) + css + ((String)s).substring(i);
        return s;
    }

    private void countDuplicateLinks() {
        for (int i = 0; i < this.links.size(); ++i) {
            Link l = this.links.get(i);
            if (l.count != 0) continue;
            int c = 0;
            for (int j = i + 1; j < this.links.size(); ++j) {
                Link l2 = this.links.get(j);
                if ((l2.source != l.source || l2.target != l.target) && (l2.source != l.target || l2.target != l.source)) continue;
                ++c;
            }
            l.count = c;
            if (c <= 0) continue;
            int k = 0;
            for (int j = i + 1; j < this.links.size(); ++j) {
                Link l2 = this.links.get(j);
                if ((l2.source != l.source || l2.target != l.target) && (l2.source != l.target || l2.target != l.source)) continue;
                l2.count = c;
                l2.index = ++k;
            }
        }
    }

    private void adjustAllForMin(Point size) {
        size.x -= this.minx;
        size.y -= this.miny;
        for (ClassItem t : this.classes.values()) {
            t.left -= this.minx;
            t.top -= this.miny;
        }
    }

    private void shadowFilter(XhtmlNode svg) throws IOException {
        XhtmlNode defs = svg.addTag("defs");
        XhtmlNode filter = defs.addTag("filter").attribute("id", this.prefix + "shadow" + this.diagramId).attribute("x", "0").attribute("y", "0").attribute("width", "200%").attribute("height", "200%");
        XhtmlNode feOffset = filter.addTag("feOffset").attribute("result", "offOut").attribute("in", "SourceGraphic").attribute("dx", "3").attribute("dy", "3");
        XhtmlNode feColorMatrix = filter.addTag("feColorMatrix").attribute("result", "matrixOut").attribute("in", "offOut").attribute("type", "matrix").attribute("values", "0.2 0 0 0 0 0 0.2 0 0 0 0 0 0.2 0 0 0 0 0 1 0");
        XhtmlNode feGaussianBlur = filter.addTag("feGaussianBlur").attribute("result", "blurOut").attribute("in", "matrixOut").attribute("stdDeviation", "2");
        XhtmlNode feBlend = filter.addTag("feBlend").attribute("in", "SourceGraphic").attribute("in2", "blurOut").attribute("mode", "normal");
    }

    private void parseSvgFile(File f, String name) throws FHIRException, IOException {
        Document svg;
        try {
            svg = XMLUtil.parseFileToDom((String)f.getAbsolutePath());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        this.readElement(svg.getDocumentElement(), null);
        this.fixLayout();
    }

    private void fixLayout() {
        double minx = 2.147483647E9;
        double miny = 2.147483647E9;
        for (PointSpec ps : this.layout.values()) {
            if (ps.getX() < minx) {
                minx = ps.getX();
            }
            if (!(ps.getY() < miny)) continue;
            miny = ps.getY();
        }
        for (String n : this.layout.keySet()) {
            PointSpec ps = this.layout.get(n);
            PointSpec nps = new PointSpec(ps.getX() - minx, ps.getY() - miny);
            this.layout.put(n, nps);
        }
    }

    private void readElement(Element e, Element p) {
        String id = e.getAttribute("id");
        if (!Utilities.noString((String)id) && Character.isUpperCase(id.charAt(0))) {
            switch (e.getNodeName()) {
                case "rect": 
                case "text": {
                    String s;
                    double x = Double.valueOf(e.getAttribute("x"));
                    double y = Double.valueOf(e.getAttribute("y"));
                    if (p.hasAttribute("transform") && (s = p.getAttribute("transform")).startsWith("translate(")) {
                        String[] sp = s.substring(10, s.length() - 1).split("\\,");
                        double tx = Double.valueOf(sp[0]);
                        double ty = sp.length > 1 ? Double.valueOf(sp[1]) : 0.0;
                        x += tx;
                        y += ty;
                    }
                    this.layout.put(id, new PointSpec(x, y));
                    break;
                }
                case "path": {
                    String d = e.getAttribute("d");
                    if (d == null) break;
                    this.linkLayout((String)id).pathData = d;
                    this.linkLayout((String)id).use = d.startsWith("m ");
                    break;
                }
                case "polygon": {
                    String v = e.getAttribute("transform");
                    if (v != null) {
                        this.linkLayout((String)id.replace((CharSequence)"-lpolygon", (CharSequence)"")).diamondTransform = v;
                    }
                    if ((v = e.getAttribute("points")) == null) break;
                    this.linkLayout((String)id.replace((CharSequence)"-lpolygon", (CharSequence)"")).diamondPoints = v;
                }
            }
        }
        Element c = XMLUtil.getFirstChild((Element)e);
        while (c != null) {
            this.readElement(c, e);
            c = XMLUtil.getNextSibling((Element)c);
        }
    }

    private LinkInfo linkLayout(String id) {
        if (!this.linkLayouts.containsKey(id)) {
            LinkInfo res = new LinkInfo();
            this.linkLayouts.put(id, res);
        }
        return this.linkLayouts.get(id);
    }

    private Point determineMetrics(List<String> classNames) throws Exception {
        double width = this.textWidth("Element") * 1.8;
        double height = 28.0;
        Point p = new Point(0.0, 0.0, PointKind.unknown);
        ClassItem item = new ClassItem(p.x, p.y, width, height, this.diagramId, null, ClassItemMode.NORMAL);
        this.classes.put(null, item);
        double x = item.right() + 100.0;
        double y = item.bottom() + 10.0;
        if (classNames != null) {
            for (String cn : classNames) {
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, cn);
                if (sd == null) {
                    sd = this.cutils.fetchStructureByName(cn);
                }
                if (sd == null) {
                    throw new FHIRException("Unable to find class '" + cn + "'");
                }
                ElementDefinition ed = sd.getSnapshot().getElementFirstRep();
                StructureDefinition base = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
                p = this.determineMetrics(sd, ed, item, ed.getName(), null, base, ClassItemMode.NORMAL);
                x = Math.max(x, p.x + 100.0);
                y = Math.max(y, p.y + 10.0);
            }
        }
        return new Point(x, y, PointKind.unknown);
    }

    private Point determineClassMetrics(StructureDefinition sd) throws FHIRException, IOException {
        double width = this.textWidth("Element") * 1.8;
        double height = 28.0;
        Point p = new Point(0.0, 0.0, PointKind.unknown);
        ClassItem item = new ClassItem(p.x, p.y, width, height, this.diagramId, null, ClassItemMode.NORMAL);
        this.classes.put(null, item);
        double x = item.right() + 100.0;
        double y = item.bottom() + 10.0;
        ElementDefinition ed = sd.getSnapshot().getElementFirstRep();
        StructureDefinition base = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        p = this.determineMetrics(sd, ed, item, ed.getName(), null, base, ClassItemMode.NORMAL);
        x = Math.max(x, p.x + 100.0);
        y = Math.max(y, p.y + 10.0);
        return new Point(x, y, PointKind.unknown);
    }

    private Point determineMetrics(StructureDefinition sd, ElementDefinition ed, ClassItem source, String path, String name, StructureDefinition base, ClassItemMode mode) throws FHIRException, IOException {
        double height;
        List<ElementDefinition> children = this.putils.getChildList(sd, ed);
        String n = name;
        if (n == null) {
            if (!path.contains(".")) {
                n = sd.getName();
            } else if (!this.constraintMode && !children.isEmpty()) {
                String[] p = path.split("\\.");
                StringBuilder b = new StringBuilder();
                for (String s : p) {
                    b.append(Utilities.capitalize((String)s));
                }
                n = b.toString();
            } else {
                n = this.constraintMode && ed.getType().size() == 1 ? ed.getTypeFirstRep().getWorkingCode() : "DataType";
            }
        }
        Object t = n;
        if (path.contains(".")) {
            if (ed.getType().size() == 1) {
                if (!"Base".equals(ed.getTypeFirstRep().getWorkingCode())) {
                    t = (String)t + " (" + ed.getTypeFirstRep().getWorkingCode() + ")";
                }
            } else {
                t = "";
            }
        } else if (base != null && !this.classNames.contains(base.getName())) {
            t = (String)t + " (" + base.getName() + ")";
        }
        if (sd.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-interface")) {
            t = (String)t + " \u00abInterface\u00bb";
        }
        double width = this.textWidth((String)t) * 1.8;
        if (this.attributes) {
            int i = 0;
            for (ElementDefinition c : children) {
                if (!this.inScope(c) || !this.countsAsAttribute(sd, c)) continue;
                String[] texts = this.textForAttribute(sd, c);
                i += texts.length;
                double w = this.textWidth(texts[0]);
                for (int j = 1; j < texts.length; ++j) {
                    w = Math.max(w, this.textWidth(texts[j]));
                }
                if (!(w > width)) continue;
                width = w;
            }
            height = 28.0 + 16.0 * (double)i + 8.0;
        } else {
            height = 28.0;
        }
        Point p = new Point(this.getSvgLeft(ed), this.getSvgLeft(ed), PointKind.unknown);
        if (p.y == -1000000.0 || p.x == -1000000.0) {
            if ("left".equals(ed.getUserString("UmlDir"))) {
                p.x = source.left - 120.0 - width;
                p.y = source.centerV() - height / 2.0;
                p = this.findEmptyPlace(p, width, height, 0.0, 80.0);
            } else if ("right".equals(ed.getUserString("UmlDir"))) {
                p.x = source.right() + 120.0;
                p.y = source.centerV() - height / 2.0;
                p = this.findEmptyPlace(p, width, height, 0.0, 80.0);
            } else if ("up".equals(ed.getUserString("UmlDir"))) {
                p.x = source.centerH() - width / 2.0;
                p.y = source.top - height - 80.0;
                p = this.findEmptyPlace(p, width, height, 80.0, 0.0);
            } else if ("down".equals(ed.getUserString("UmlDir"))) {
                p.x = source.centerH() - width / 2.0;
                p.y = source.bottom() + 80.0;
                p = this.findEmptyPlace(p, width, height, 80.0, 0.0);
            } else {
                p.y = 0.0;
                p.x = 0.0;
                p = this.findEmptyPlace(p, width, height, 80.0, 0.0);
            }
        }
        this.miny = Math.min(this.miny, p.y);
        this.minx = Math.min(this.minx, p.x);
        ClassItem item = new ClassItem(p.x, p.y, width, height, path, n, mode);
        this.classes.put(path, item);
        double x = item.right() + 100.0;
        double y = item.bottom() + 10.0;
        if (this.innerClasses) {
            for (ElementDefinition c : children) {
                if (!this.inScope(c) || !this.countsAsRelationship(sd, c) || c.hasSliceName()) continue;
                if (c.hasContentReference()) {
                    String cr = c.getContentReference();
                    ClassItem target = this.classes.get(cr.substring(cr.indexOf("#") + 1));
                    if (target != null) continue;
                    throw new Error("what?");
                }
                p = this.determineMetrics(sd, c, item, path + "." + c.getName(), null, null, ClassItemMode.NORMAL);
                x = Math.max(x, p.x + 100.0);
                y = Math.max(y, p.y + 10.0);
                if (!c.hasSlicing()) continue;
                List<ElementDefinition> slices = this.getSlices(children, c);
                for (ElementDefinition s : slices) {
                    p = this.determineMetrics(sd, s, item, path + "." + c.getName() + ":" + s.getSliceName(), s.getSliceName(), null, ClassItemMode.SLICE);
                    x = Math.max(x, p.x + 100.0);
                    y = Math.max(y, p.y + 10.0);
                }
            }
        }
        return new Point(x, y, PointKind.unknown);
    }

    private boolean countsAsRelationship(StructureDefinition sd, ElementDefinition c) {
        return !this.countsAsAttribute(sd, c);
    }

    private boolean countsAsAttribute(StructureDefinition sd, ElementDefinition ed) {
        if (ed.hasContentReference()) {
            return false;
        }
        if (ed.prohibited()) {
            return true;
        }
        if (ed.getType().isEmpty()) {
            return true;
        }
        List<ElementDefinition> children = this.putils.getChildList(sd, ed, false);
        if (ed.getType().size() == 1) {
            StructureDefinition sdt = this.context.fetchTypeDefinition(ed.getTypeFirstRep().getWorkingCode());
            if (sdt == null) {
                return true;
            }
            if (sdt.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
                return true;
            }
            if (sdt.getAbstract()) {
                return children.size() == 0;
            }
            if (sdt.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE && !"Base".equals(sdt.getName())) {
                return !this.constraintMode || !ed.hasSlicing() && !ed.hasSliceName();
            }
            return children.size() == 0;
        }
        return children.size() == 0 || this.constraintMode && ed.hasSlicing();
    }

    private List<ElementDefinition> getSlices(List<ElementDefinition> list, ElementDefinition focus) {
        ArrayList<ElementDefinition> slices = new ArrayList<ElementDefinition>();
        for (int i = list.indexOf(focus) + 1; i < list.size(); ++i) {
            ElementDefinition ed = list.get(i);
            if (!ed.getPath().equals(focus.getPath()) || !ed.hasSliceName()) continue;
            slices.add(ed);
        }
        return slices;
    }

    private boolean inScope(ElementDefinition c) {
        return !this.constraintMode || c.hasUserData("SNAPSHOT_FROM_DIFF");
    }

    private Point findEmptyPlace(Point p, double width, double height, double dx, double dy) {
        while (this.overlaps(p.x, p.y, width, height)) {
            p.x += dx;
            p.y += dy;
            if (!(p.x > 600.0)) continue;
            p.y += 100.0;
            p.x = 0.0;
        }
        return p;
    }

    private boolean overlaps(double x, double y, double w, double h) {
        for (ClassItem c : this.classes.values()) {
            if ((this.inBounds(x, c.left, c.right()) || this.inBounds(x + w, c.left, c.right())) && (this.inBounds(y, c.top, c.bottom()) || this.inBounds(y + h, c.top, c.bottom()))) {
                return true;
            }
            if (!this.inBounds(c.left, x, x + w) && !this.inBounds(c.right(), x, x + w) || !this.inBounds(c.top, y, y + h) && !this.inBounds(c.bottom(), y, y + h)) continue;
            return true;
        }
        return false;
    }

    private boolean inBounds(double x, double x1, double x2) {
        return x1 < x2 ? x >= x1 && x <= x2 : x >= x2 && x <= x1;
    }

    private double getSvgLeft(ElementDefinition ed) {
        Integer i = (Integer)ed.getUserData("SvgLeft");
        return i == null ? -1000000.0 : (double)i.intValue();
    }

    private double getSvgTop(ElementDefinition ed) {
        Integer i = (Integer)ed.getUserData("SvgTop");
        return i == null ? -1000000.0 : (double)i.intValue();
    }

    private int addAttribute(XhtmlNode g, double left, double top, StructureDefinition sd, ElementDefinition e, String path, double height, double width) throws FHIRException, IOException {
        LineStatus ls = new LineStatus();
        return this.addAttribute(g, left, top, sd, e, path, ls, height, width);
    }

    private int addAttribute(XhtmlNode g, double left, double top, StructureDefinition sd, ElementDefinition e, String path, LineStatus ls, double height, double width) throws FHIRException, IOException {
        if (e.getStandardsStatus() != null) {
            XhtmlNode rect = g.svgRect(null);
            rect.attribute("x", Double.toString(left + 1.0));
            rect.attribute("y", Double.toString(top - height + 4.0));
            rect.attribute("id", this.prefix + "n" + ++this.nc);
            rect.attribute("width", Double.toString(width - 2.0));
            rect.attribute("height", Double.toString(height));
            rect.style("fill:" + e.getStandardsStatus().getColorSvg() + ";stroke:black;stroke-width:0");
        }
        XhtmlNode html = g.htmlObject(left + 6.0 + (ls.line == 0 ? 0.0 : 20.0), top + 16.0 * (double)(ls.line - 1), width - 2.0, height);
        XhtmlNode div = html.div().attribute("xmlns", "http://www.w3.org/1999/xhtml");
        div.attribute("class", "diagram-class-detail");
        if (e.prohibited()) {
            div.style("text-decoration: line-through");
        }
        XhtmlNode a = div.ah(this.baseUrl(sd, path) + path + "." + e.getName().replace("[", "_").replace("]", "_")).style("text-decoration: none;");
        a.attributeNN("title", this.getEnhancedDefinition(e));
        a.tx(ls.see(e.getName()));
        div.tx(ls.see(" : "));
        if (e.hasContentReference()) {
            this.encodeType(div, ls, e.getContentReference().substring(e.getContentReference().indexOf("#") + 1));
        } else {
            this.encodeType(div, ls, this.getTypeCodeForElement(e.getType()));
        }
        div.tx(ls.see(" [" + this.describeCardinality(e) + "]"));
        if (!"0".equals(e.getMax())) {
            if (this.constraintMode) {
                HashSet<String> p = new HashSet<String>();
                HashSet<String> tp = new HashSet<String>();
                for (ElementDefinition.TypeRefComponent tr : e.getType()) {
                    for (CanonicalType ct : tr.getProfile()) {
                        p.add(ct.asStringValue());
                    }
                    for (CanonicalType ct : tr.getTargetProfile()) {
                        if (ct.asStringValue().startsWith("http://hl7.org/fhir/StructureDefinition/")) continue;
                        tp.add(ct.asStringValue());
                    }
                }
                this.flag(div, ls, !p.isEmpty(), "DP", "black", "#c787ff", this.rc.formatPhrase("GENERAL_TYPE_PROFILE", new Object[]{CommaSeparatedStringBuilder.join((String)",", (Collection)Utilities.sorted(p))}), null);
                this.flag(div, ls, !tp.isEmpty(), "TP", "black", "#c787ff", this.rc.formatPhrase("GENERAL_TYPE_TARGET_PROFILE", new Object[]{CommaSeparatedStringBuilder.join((String)",", (Collection)Utilities.sorted(tp))}), null);
                this.flag(div, ls, e.getIsModifier(), "?!", "black", "white", this.rc.formatPhrase("STRUC_DEF_MOD", new Object[0]), null);
                if (e.getMustSupport() && e.hasExtension("http://hl7.org/fhir/StructureDefinition/obligation", "http://hl7.org/fhir/tools/StructureDefinition/obligation")) {
                    this.flag(div, ls, e.getMustSupport(), "SO", "white", "red", this.rc.formatPhrase("STRUC_DEF_OBLIG_SUPP", new Object[0]), null);
                } else if (e.hasExtension("http://hl7.org/fhir/StructureDefinition/obligation", "http://hl7.org/fhir/tools/StructureDefinition/obligation")) {
                    this.flag(div, ls, e.getMustSupport(), "O", "white", "red", this.rc.formatPhrase("STRUC_DEF_OBLIG", new Object[0]), null);
                } else {
                    this.flag(div, ls, e.getMustSupport(), "S", "white", "red", this.rc.formatPhrase("STRUC_DEF_ELE_MUST_SUPP", new Object[0]), null);
                }
                this.flag(div, ls, e.getMustHaveValue(), "V", "black", "#f7a3ec", this.rc.formatPhrase("STRUC_DEF_ELE", new Object[0]), null);
                this.flag(div, ls, e.hasValueAlternatives(), "?X", "black", "#f7a3ec", this.rc.formatPhrase("STRUC_DEF_VALUE_ALT", new Object[0]), null);
                this.flag(div, ls, StructureDefinitionRenderer.hasNonBaseConstraints(e.getConstraint()) || StructureDefinitionRenderer.hasNonBaseConditions(e.getCondition()), "C", "black", "#7779e6", this.rc.formatPhrase("STRUC_DEF_ELE_AFFECTED", new Object[0]), null);
                this.flag(div, ls, e.hasFixed(), "F", "black", "#95fc9c", this.rc.formatPhrase("GENERAL_FIXED_VALUE", new Object[]{this.renderDT(e.getFixed())}), null);
                this.flag(div, ls, e.hasPattern(), "P", "black", "#95fc9c", this.rc.formatPhrase("GENERAL_PATTERN_VALUE", new Object[]{this.renderDT(e.getPattern())}), null);
                if (e.hasMinValue() || e.hasMaxValue()) {
                    if (e.hasMinValue() && e.hasMaxValue()) {
                        this.flag(div, ls, true, "L<<H", "black", "green", this.rc.formatPhrase("GENERAL_VALUE_BOUNDED", new Object[]{e.getMaxLength()}), null);
                    } else {
                        this.flag(div, ls, e.hasMaxValue(), "L<", "black", "#95fc9c", this.rc.formatPhrase("GENERAL_VALUE_MIN", new Object[]{this.renderDT(e.getMinValue())}), null);
                        this.flag(div, ls, e.hasMaxValue(), "<H", "black", "#95fc9c", this.rc.formatPhrase("GENERAL_VALUE_MAX", new Object[]{this.renderDT(e.getMaxValue())}), null);
                    }
                }
                this.flag(div, ls, e.hasMaxLength(), "<L", "black", "#95fc9c", this.rc.formatPhrase("GENERAL_MAX_LENGTH", new Object[]{e.getMaxLength()}), null);
                if (e.hasBinding()) {
                    ValueSet vs = this.context.fetchResource(ValueSet.class, path);
                    if (e.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED) {
                        this.flag(div, ls, true, "B!", "black", "#fad570", this.rc.formatPhrase("GENERAL_REQUIRED_BINDING", new Object[]{this.describeVS(e.getBinding().getValueSet(), vs)}), this.vsLink(e.getBinding().getValueSet(), vs));
                    } else if (e.getBinding().getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                        this.flag(div, ls, true, "B?", "black", "#fad570", this.rc.formatPhrase("GENERAL_REQUIRED_BINDING", new Object[]{this.describeVS(e.getBinding().getValueSet(), vs)}), this.vsLink(e.getBinding().getValueSet(), vs));
                    }
                    this.flag(div, ls, e.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/additional-binding"), "B+", "black", "#fad570", this.rc.formatPhrase("GENERAL_ADDITIONAL_BINDING", new Object[0]), null);
                }
            } else {
                boolean hasBinding;
                boolean hasTS = !e.getType().isEmpty() && (e.getType().size() != 1 || this.isReference(e.getType().get(0).getName()));
                boolean bl = hasBinding = e.hasBinding() && e.getBinding().getStrength() != Enumerations.BindingStrength.NULL;
                if (hasTS || hasBinding) {
                    div.tx(ls.see(" \u00ab "));
                    if (hasTS) {
                        if (this.isReference(e.getTypeFirstRep().getWorkingCode()) && e.getType().size() == 1) {
                            boolean first = true;
                            for (CanonicalType p : e.getTypeFirstRep().getTargetProfile()) {
                                if (first) {
                                    first = false;
                                } else {
                                    div.tx(ls.see(" | "));
                                }
                                StructureDefinition sdt = this.context.fetchResource(StructureDefinition.class, p.asStringValue(), sd);
                                String s = sdt == null ? this.tail(p.asStringValue()) : sdt.getName();
                                ls.check(html, div, left, top, s.length(), null);
                                this.encodeType(div, ls, s);
                            }
                        } else {
                            boolean firstOuter = true;
                            for (ElementDefinition.TypeRefComponent t : e.getType()) {
                                if (firstOuter) {
                                    firstOuter = false;
                                } else {
                                    div.tx(ls.see(" | "));
                                }
                                ls.check(html, div, left, top, t.getName().length(), null);
                                this.encodeType(div, ls, t.getWorkingCode());
                            }
                        }
                    }
                    if (hasTS && hasBinding) {
                        div.tx(ls.see("; "));
                    }
                    if (hasBinding) {
                        Object name;
                        ElementDefinition.ElementDefinitionBindingComponent b = e.getBinding();
                        ValueSet vs = this.context.fetchResource(ValueSet.class, b.getValueSet());
                        Object object = name = vs != null ? vs.getName() : this.tail(b.getValueSet());
                        if (((String)name).toLowerCase().endsWith(" codes")) {
                            name = ((String)name).substring(0, ((String)name).length() - 5);
                        }
                        if (((String)name).length() > 30) {
                            name = ((String)name).substring(0, 29) + "...";
                        }
                        String link = vs == null ? null : vs.getWebPath();
                        String suffix = "";
                        suffix = this.getBindingSuffix(b);
                        div.ahOrNot(link, b.getDescription() + " (Strength=" + (b.getStrength() == null ? "null " : b.getStrength().getDisplay()) + ")").tx(ls.see((String)name + suffix));
                    }
                    div.tx(ls.see(" \u00bb"));
                }
            }
        }
        return ls.line;
    }

    private String getBindingSuffix(ElementDefinition.ElementDefinitionBindingComponent b) {
        String suffix;
        if (b.getStrength() == null) {
            return "??";
        }
        switch (b.getStrength()) {
            case EXAMPLE: {
                suffix = "??";
                break;
            }
            case EXTENSIBLE: {
                suffix = "+";
                break;
            }
            case PREFERRED: {
                suffix = "?";
                break;
            }
            case REQUIRED: {
                suffix = "!";
                break;
            }
            default: {
                suffix = "??";
            }
        }
        return suffix;
    }

    private boolean hasNonBaseProfile(List<CanonicalType> list) {
        for (CanonicalType ct : list) {
            if (ct.asStringValue().startsWith("http://hl7.org/fhir/StructureDefinition/")) continue;
            return true;
        }
        return false;
    }

    private String vsLink(String url, ValueSet vs) {
        if (vs != null) {
            return vs.getWebPath();
        }
        return url;
    }

    private String describeVS(String url, ValueSet vs) {
        if (vs != null) {
            return vs.present() + " (" + url + ")";
        }
        return "(" + url + ")";
    }

    private String renderDT(DataType dt) {
        if (dt == null) {
            return "";
        }
        if (dt.isPrimitive()) {
            return dt.primitiveValue();
        }
        switch (dt.fhirType()) {
            case "Quantity": {
                return this.renderQty((Quantity)dt);
            }
            case "Coding": {
                return this.renderCoding((Coding)dt);
            }
            case "CodeableConcept": {
                return this.renderCC((CodeableConcept)dt);
            }
        }
        return new DataRenderer(this.rc).displayDataType(dt);
    }

    private String renderCC(CodeableConcept cc) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Coding c : cc.getCoding()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(this.renderCoding(c));
        }
        if (b.length() > 0 && cc.hasText()) {
            b.append(". ");
        }
        if (cc.hasText()) {
            b.append("text: ");
            b.append(cc.getText());
        }
        return b.toString();
    }

    private String renderCoding(Coding c) {
        StringBuilder b = new StringBuilder();
        if (c.hasSystem()) {
            b.append(new DataRenderer(this.rc).displaySystem(c.getSystem()));
            if (c.hasCode()) {
                b.append("#");
            }
        }
        if (c.hasCode()) {
            b.append(c.getCode());
        }
        if (c.hasDisplay()) {
            b.append("\"");
            b.append(c.getDisplay());
            b.append("\"");
        }
        return b.toString();
    }

    private String renderQty(Quantity qty) {
        StringBuilder b = new StringBuilder();
        if (qty.hasComparator()) {
            b.append(qty.getComparatorElement().asStringValue());
        }
        b.append(qty.getValueElement().asStringValue());
        if (qty.hasUnit()) {
            b.append(qty.getUnit());
        } else if (qty.hasCode()) {
            b.append(qty.getCode());
        }
        return b.toString();
    }

    private void flag(XhtmlNode x, LineStatus ls, Boolean show, String code, String foreColor, String backColor, String title, String url) throws IOException {
        if (show.booleanValue()) {
            x.tx(" ");
            XhtmlNode xx = url == null ? x.span() : x.ah(url).style("text-decoration: none;");
            xx.style("padding-left: 3px; padding-right: 3px; font-weight: bold; font-family: verdana; color: " + foreColor + "; background-color: " + backColor);
            xx.attribute("title", title);
            xx.tx(code);
            ls.see(code + " ");
        }
    }

    private String tail(String url) {
        if (Utilities.noString((String)url)) {
            return "";
        }
        return url.contains("/") ? url.substring(url.lastIndexOf("/") + 1) : url;
    }

    private String describeCardinality(ElementDefinition e) {
        String min = !e.hasMin() ? "" : e.getMinElement().asStringValue();
        String max = !e.hasMax() ? "" : e.getMax();
        return min + ".." + max;
    }

    private int encodeType(XhtmlNode text, LineStatus ls, String tc) throws FHIRException, IOException {
        StructureDefinition sd;
        if (tc == null) {
            return 0;
        }
        if (tc.equals("*")) {
            XhtmlNode a = text.ah(Utilities.pathURL((String[])new String[]{this.rc.getLink(RenderingContext.KnownLinkType.SPEC, true), "datatypes.html#open"})).style("text-decoration: none;");
            a.tx(ls.see(tc));
            return tc.length();
        }
        if (tc.equals("Type")) {
            XhtmlNode a = text.ah(Utilities.pathURL((String[])new String[]{this.rc.getLink(RenderingContext.KnownLinkType.SPEC, true), "formats.html#umlchoice"})).style("text-decoration: none;");
            a.tx(ls.see(tc));
            return tc.length();
        }
        if (tc.startsWith("@")) {
            XhtmlNode a = text.ah("@" + tc.substring(1)).style("text-decoration: none;");
            a.tx(ls.see(tc));
            return tc.length();
        }
        StructureDefinition structureDefinition = sd = Utilities.isAbsoluteUrl((String)tc) ? this.context.fetchTypeDefinition(tc) : null;
        if (sd != null) {
            XhtmlNode a = text.ah(sd.getWebPath()).style("text-decoration: none;");
            a.tx(ls.see(sd.getName()));
            return tc.length();
        }
        XhtmlNode a = text.ah(this.makeLink(tc)).style("text-decoration: none;");
        a.tx(ls.see(tc));
        return tc.length();
    }

    private String makeLink(String tc) {
        StructureDefinition sd = this.context.fetchTypeDefinition(tc);
        return sd == null ? null : sd.getWebPath();
    }

    private String getEnhancedDefinition(ElementDefinition e) {
        String defn = this.pvt(e.getDefinitionElement());
        if (e.getIsModifier() && e.getMustSupport()) {
            return Utilities.removePeriod((String)defn) + " " + this.rc.formatPhrase("SDR_MOD_SUPP", new Object[0]);
        }
        if (e.getIsModifier()) {
            return Utilities.removePeriod((String)defn) + " " + this.rc.formatPhrase("SDR_MOD", new Object[0]);
        }
        if (e.getMustSupport()) {
            return Utilities.removePeriod((String)defn) + " " + this.rc.formatPhrase("SDR_SUPP", new Object[0]);
        }
        return Utilities.removePeriod((String)defn);
    }

    private String pvt(DataType ed) {
        return ed.getTranslation(this.lang);
    }

    private String baseUrl(StructureDefinition sd, String path) throws FHIRException, IOException {
        return sd.getWebPath() + "#";
    }

    private String[] textForAttribute(StructureDefinition sd, ElementDefinition e) throws FHIRException, IOException {
        LineStatus ls = new LineStatus();
        XhtmlNode svg = new XhtmlNode(NodeType.Element, "svg");
        this.addAttribute(svg.svgG(null), 0.0, 0.0, sd, e, "Element.id", ls, 0.0, 0.0);
        ls.close();
        return ls.list.toArray(new String[0]);
    }

    private String getTypeCodeForElement(List<ElementDefinition.TypeRefComponent> tl) {
        if (tl.isEmpty()) {
            return "??";
        }
        if (tl.size() == 1 && !this.isReference(tl.get(0).getName())) {
            return tl.get(0).getName();
        }
        String t = tl.get(0).getName();
        boolean allSame = true;
        for (int i = 1; i < tl.size(); ++i) {
            allSame = t.equals(tl.get(i).getName());
        }
        if (allSame && t.equals("Reference")) {
            return "Reference";
        }
        if (allSame && t.equals("canonical")) {
            return "canonical";
        }
        if (allSame && t.equals("CodeableReference")) {
            return "CodeableReference";
        }
        boolean allPrimitive = true;
        for (ElementDefinition.TypeRefComponent tr : tl) {
            StructureDefinition sd = this.context.fetchTypeDefinition(tr.getWorkingCode());
            if (sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) continue;
            allPrimitive = false;
        }
        if (VersionUtilities.isR4BVer((String)this.context.getVersion())) {
            return "Element";
        }
        if (allPrimitive) {
            return "PrimitiveType";
        }
        return "DataType";
    }

    private boolean isReference(String name) {
        return name != null && (name.equals("Reference") || name.equals("canonical") || name.equals("CodeableReference"));
    }

    private boolean isAttribute(StructureDefinition sd, ElementDefinition c) {
        return this.putils.getChildList(sd, c).isEmpty();
    }

    private double textWidth(String text) {
        return (double)text.length() * 4.4;
    }

    private ClassItem drawElement(XhtmlNode svg, List<String> classNames) throws Exception {
        if (classNames != null) {
            for (String cn : classNames) {
                ClassItem parent;
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, cn);
                if (sd == null) {
                    sd = this.cutils.fetchStructureByName(cn);
                }
                ElementDefinition ed = sd.getSnapshot().getElementFirstRep();
                StructureDefinition base = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
                ClassItem classItem = parent = base == null ? null : this.classes.get(base.getName());
                if (parent == null) {
                    this.drawClass(svg, sd, ed, cn, sd.getStandardsStatus(), base);
                    continue;
                }
                this.links.add(new Link(parent, this.drawClass(svg, sd, ed, cn, sd.getStandardsStatus(), null), LinkType.SPECIALIZATION, null, null, PointKind.unknown, null, null));
            }
        }
        return null;
    }

    private ClassItem drawClassElement(XhtmlNode svg, StructureDefinition sd) throws FHIRException, IOException {
        ClassItem parent;
        ElementDefinition ed = sd.getSnapshot().getElementFirstRep();
        StructureDefinition base = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        ClassItem classItem = parent = base == null ? null : this.classes.get(base.getName());
        if (parent == null) {
            this.drawClass(svg, sd, ed, ed.getName(), sd.getStandardsStatus(), base);
        } else {
            this.links.add(new Link(parent, this.drawClass(svg, sd, ed, sd.getName(), sd.getStandardsStatus(), null), LinkType.SPECIALIZATION, null, null, PointKind.unknown, null, null));
        }
        return null;
    }

    private ClassItem drawClass(XhtmlNode svg, StructureDefinition sd, ElementDefinition ed, String path, StandardsStatus status, StructureDefinition parent) throws FHIRException, IOException {
        XhtmlNode a;
        String borderColor;
        ClassItem item = this.classes.get(path);
        if (item == null) {
            throw new FHIRException("Unable to find a class for " + path + " from " + CommaSeparatedStringBuilder.join((String)",", this.classes.keySet()));
        }
        XhtmlNode g = svg.svgG(null);
        g.attribute("id", this.prefix + "n" + ++this.nc);
        XhtmlNode rect = g.svgRect(null);
        rect.attribute("x", Double.toString(item.left));
        rect.attribute("y", Double.toString(item.top));
        rect.attribute("rx", "4");
        rect.attribute("ry", "4");
        rect.attribute("width", Double.toString(item.width));
        rect.attribute("height", Double.toString(item.height));
        rect.attribute("filter", "url(#shadow" + this.diagramId + ")");
        String string = borderColor = item.getMode() == ClassItemMode.SLICE ? SLICE_COLOR : "black";
        if (status == null) {
            rect.style("fill:" + (status == null ? "#ffffff" : status.getColorSvg()) + ";stroke:" + borderColor + ";stroke-width:1");
        } else {
            rect.style("fill:" + status.getColorSvg() + ";stroke:" + borderColor + ";stroke-width:1");
        }
        rect.attribute("id", this.prefix + item.getId());
        XhtmlNode line = g.svgLine(null);
        line.attribute("x1", Double.toString(item.left));
        line.attribute("y1", Double.toString(item.top + 20.0 + 8.0));
        line.attribute("x2", Double.toString(item.left + item.width));
        line.attribute("y2", Double.toString(item.top + 20.0 + 8.0));
        line.style("stroke:dimgrey;stroke-width:1");
        line.attribute("id", this.prefix + "n" + ++this.nc);
        XhtmlNode text = g.svgText(null);
        text.attribute("x", Double.toString(item.left + item.width / 2.0));
        text.attribute("y", Double.toString(item.top + 20.0));
        text.attribute("fill", "black");
        if (!path.contains(".")) {
            text.attribute("class", "diagram-class-title  diagram-class-resource");
        } else {
            text.attribute("class", "diagram-class-title");
        }
        if (parent == null) {
            text.attribute("id", this.prefix + "n" + ++this.nc);
            if (!path.contains(".") && sd.getAbstract()) {
                text.style("font-style: italic");
            }
            a = text.svgAx(this.makeLink(item.getName()));
            a.attribute("id", this.prefix + "n" + ++this.nc);
            a.tx(item.getName());
        } else if (!path.contains(".")) {
            text.attribute("id", this.prefix + "n" + ++this.nc);
            if (!path.contains(".") && sd.getAbstract()) {
                text.style("font-style: italic");
            }
            a = text.svgAx(sd.getWebPath());
            a.tx(item.getName());
            text.tx(" (");
            a = text.svgAx(parent.getWebPath());
            a.attribute("class", "diagram-class-reference");
            a.attribute("id", this.prefix + "n" + ++this.nc);
            a.style("font-style: italic");
            a.tx(parent.getName());
            text.tx(")");
        } else {
            text.attribute("id", this.prefix + "n" + ++this.nc);
            text.tx(item.getName());
        }
        List<ElementDefinition> children = this.putils.getChildList(sd, ed);
        if (this.attributes) {
            int i = 0;
            for (ElementDefinition c : children) {
                if (!this.inScope(c) || !this.countsAsAttribute(sd, c)) continue;
                this.addAttribute(g, item.left, item.top + 20.0 + 8.0 + 16.0 * (double)(++i), sd, c, path, 16.0, item.width);
                String[] texts = this.textForAttribute(sd, c);
                i = i + texts.length - 1;
            }
        }
        if (this.innerClasses) {
            for (ElementDefinition c : children) {
                if (!this.inScope(c) || !this.countsAsRelationship(sd, c) || c.hasSliceName()) continue;
                if (c.hasContentReference()) {
                    String cr = c.getContentReference();
                    ClassItem target = this.classes.get(cr.substring(cr.indexOf("#") + 1));
                    this.links.add(new Link(item, target, LinkType.COMPOSITION, c.getName(), this.describeCardinality(c), PointKind.unknown, this.baseUrl(sd, path) + path + "." + c.getName(), this.getEnhancedDefinition(c)));
                    continue;
                }
                ClassItem cc = this.drawClass(svg, sd, c, path + "." + c.getName(), status, null);
                this.links.add(new Link(item, cc, LinkType.COMPOSITION, c.getName(), this.describeCardinality(c), PointKind.unknown, this.baseUrl(sd, path) + path + "." + c.getName(), this.getEnhancedDefinition(c)));
                if (!c.hasSlicing()) continue;
                List<ElementDefinition> slices = this.getSlices(children, c);
                for (ElementDefinition s : slices) {
                    ClassItem cc1 = this.drawClass(svg, sd, s, path + "." + c.getName() + ":" + s.getSliceName(), status, null);
                    this.links.add(new Link(cc, cc1, LinkType.SLICE, "", this.describeCardinality(s), PointKind.unknown, this.baseUrl(sd, path) + path + "." + c.getName() + ":" + s.getSliceName(), this.getEnhancedDefinition(c)));
                }
            }
        }
        return item;
    }

    private void drawLink(XhtmlNode svg, Link l, XhtmlNode insertionPoint) throws FHIRException, IOException {
        Point p2;
        Point p1;
        Point end;
        Point start;
        String id = l.source.id + "-" + l.target.id;
        if (l.source == l.target) {
            start = new Point(l.source.right(), l.source.centerV() - 25.0, PointKind.unknown);
            end = new Point(l.source.right(), l.source.centerV() + 25.0, PointKind.right);
            p1 = new Point(l.source.right() + 60.0, l.source.centerV() - 25.0, PointKind.unknown);
            p2 = new Point(l.source.right() + 60.0, l.source.centerV() + 25.0, PointKind.unknown);
            XhtmlNode path = svg.svgPath(insertionPoint);
            path.attribute("id", this.prefix + id);
            path.attribute("d", this.checkForLinkPathData(id, "M" + start.x + " " + start.y + " L" + p1.x + " " + p1.y + " L" + p1.x + " " + p1.y + " L" + p2.x + " " + p2.y + " L" + end.x + " " + end.y));
            path.style("stroke:navy;stroke-width:1;fill:none");
        } else {
            Point c1 = new Point(l.source.centerH(), l.source.centerV(), PointKind.unknown);
            Point c2 = new Point(l.target.centerH(), l.target.centerV(), PointKind.unknown);
            start = this.intersection(c1, c2, l.source);
            end = this.intersection(c1, c2, l.target);
            if (l.count > 0) {
                start.x = this.adjustForDuplicateX(start.x, start.kind, l.index);
                start.y = this.adjustForDuplicateY(start.y, start.kind, l.index);
                end.x = this.adjustForDuplicateX(end.x, end.kind, l.index);
                end.y = this.adjustForDuplicateY(end.y, end.kind, l.index);
            }
            p1 = end;
            p2 = start;
            if (start != null && end != null) {
                XhtmlNode path = svg.svgPath(insertionPoint);
                path.attribute("d", this.checkForLinkPathData(id, "M" + Double.toString(start.x) + " " + Double.toString(start.y) + " L" + Double.toString(end.x) + " " + Double.toString(end.y)));
                if (l.type == LinkType.CONSTRAINT) {
                    path.style("stroke:orange;stroke-width:1;fill:none");
                } else if (l.type == LinkType.SLICE) {
                    path.style("stroke:#62A856;stroke-width:2;fill:none");
                } else {
                    path.style("stroke:navy;stroke-width:1;fill:none");
                }
                path.attribute("id", this.prefix + id);
            }
        }
        if (start != null && end != null) {
            if (l.name == null) {
                Point pd1 = this.calcGenRight(start, p1);
                Point pd2 = this.calcGenLeft(start, p1);
                XhtmlNode polygon = svg.svgPolygon(insertionPoint);
                polygon.attribute("points", start.toPoint() + " " + pd1.toPoint() + " " + pd2.toPoint() + " " + start.toPoint());
                polygon.style("fill:white;stroke:navy;stroke-width:1");
                polygon.attribute("transform", "rotate(" + this.getAngle(start, p1) + " " + Double.toString(start.x) + " " + Double.toString(start.y) + ")");
                polygon.attribute("id", this.prefix + "n" + ++this.nc);
            } else {
                if (l.type != LinkType.SLICE) {
                    Point pd2 = this.calcDiamondEnd(start, p1);
                    Point pd1 = this.calcDiamondRight(start, p1);
                    Point pd3 = this.calcDiamondLeft(start, p1);
                    XhtmlNode polygon = svg.svgPolygon(insertionPoint);
                    polygon.attribute("points", this.checkForLinkPoints(id, start.toPoint() + " " + pd1.toPoint() + " " + pd2.toPoint() + " " + pd3.toPoint() + " " + start.toPoint()));
                    polygon.style("fill:navy;stroke:navy;stroke-width:1");
                    polygon.attribute("transform", this.checkForLinkTransform(id, "rotate(" + this.getAngle(start, p1) + " " + Double.toString(start.x) + " " + Double.toString(start.y) + ")"));
                    polygon.attribute("id", this.prefix + id + "-lpolygon");
                }
                double x = (int)(p1.x + p2.x) / 2;
                double y = (double)((int)(p1.y + p2.y) / 2) + 8.0 + 16.0 * (double)l.index;
                double w = (int)this.textWidth(l.name);
                XhtmlNode g = svg.svgG(insertionPoint);
                XhtmlNode rect = g.svgRect(null);
                rect.attribute("x", this.checkForKnownX(id, id + "-lrect", Double.toString(x - w / 2.0)));
                rect.attribute("y", this.checkForKnownY(id, id + "-lrect", Double.toString(y - 16.0)));
                rect.attribute("width", Double.toString(w));
                rect.attribute("height", Double.toString(20.0));
                rect.style("fill:white;stroke:black;stroke-width:0");
                rect.attribute("id", this.prefix + id + "-lrect");
                XhtmlNode text = g.svgText(null);
                text.attribute("x", this.checkForKnownX(id, id + "-lname", Double.toString(x)));
                text.attribute("y", this.checkForKnownY(id, id + "-lname", Double.toString(y - 4.0)));
                text.attribute("fill", "black");
                text.attribute("class", "diagram-class-linkage");
                text.attribute("id", this.prefix + id + "-lname");
                XhtmlNode a = text.svgAx(l.path);
                a.attribute("id", this.prefix + "n" + ++this.nc);
                a.addTag("title").tx(l.description);
                a.tx(l.name);
                x = end.x;
                y = end.y;
                if (end.kind == PointKind.left) {
                    y -= 4.0;
                    x -= 20.0;
                } else if (end.kind == PointKind.top) {
                    y -= 4.0;
                } else if (end.kind == PointKind.right) {
                    y -= 4.0;
                    x += 15.0;
                } else if (end.kind == PointKind.bottom) {
                    y += 16.0;
                }
                w = 18.0;
                text = svg.svgText(insertionPoint);
                text.attribute("x", this.checkForKnownX(id, id + "-lcard", Double.toString(x)));
                text.attribute("y", this.checkForKnownY(id, id + "-lcard", Double.toString(y)));
                text.attribute("fill", "black");
                text.attribute("class", "diagram-class-linkage");
                text.attribute("id", this.prefix + id + "-lcard");
                text.tx("[" + l.cardinality + "]");
            }
        }
    }

    private String checkForKnownY(String baseId, String id, String defaultValue) {
        if (this.linkLayouts.containsKey(baseId) && this.linkLayouts.get((Object)baseId).use && this.layout.containsKey(id)) {
            return "" + this.layout.get((Object)id).y;
        }
        return defaultValue;
    }

    private String checkForKnownX(String baseId, String id, String defaultValue) {
        if (this.linkLayouts.containsKey(baseId) && this.linkLayouts.get((Object)baseId).use && this.layout.containsKey(id)) {
            return "" + this.layout.get((Object)id).x;
        }
        return defaultValue;
    }

    private String checkForLinkTransform(String id, String defaultValue) {
        if (this.linkLayouts.containsKey(id) && this.linkLayouts.get((Object)id).use && this.linkLayouts.get((Object)id).diamondTransform != null) {
            return this.linkLayouts.get((Object)id).diamondTransform;
        }
        return defaultValue;
    }

    private String checkForLinkPoints(String id, String defaultValue) {
        if (this.linkLayouts.containsKey(id) && this.linkLayouts.get((Object)id).use && this.linkLayouts.get((Object)id).diamondPoints != null) {
            return this.linkLayouts.get((Object)id).diamondPoints;
        }
        return defaultValue;
    }

    private String checkForLinkPathData(String id, String defaultValue) {
        if (this.linkLayouts.containsKey(id) && this.linkLayouts.get((Object)id).use && this.linkLayouts.get((Object)id).pathData != null) {
            return this.linkLayouts.get((Object)id).pathData;
        }
        return defaultValue;
    }

    private String abs(double d) {
        if (d < 0.0) {
            return Double.toString(-d);
        }
        return Double.toString(d);
    }

    private double adjustForDuplicateX(double x, PointKind kind, int index) {
        switch (kind) {
            case bottom: {
                return x + 50.0 * ((double)index - 0.5);
            }
            case top: {
                return x + 50.0 * ((double)index - 0.5);
            }
        }
        return x;
    }

    private double adjustForDuplicateY(double y, PointKind kind, int index) {
        switch (kind) {
            case left: {
                return y - 50.0 * ((double)index - 0.5);
            }
            case right: {
                return y - 50.0 * ((double)index - 0.5);
            }
        }
        return y;
    }

    private String getAngle(Point start, Point end) {
        double inRads = Math.atan2(end.y - start.y, end.x - start.x);
        return Double.toString(Math.toDegrees(inRads));
    }

    private Point calcDiamondEnd(Point start, Point end) {
        return new Point(start.x + 12.0, start.y + 0.0, PointKind.unknown);
    }

    private Point calcDiamondRight(Point start, Point end) {
        return new Point(start.x + 6.0, start.y + 4.0, PointKind.unknown);
    }

    private Point calcDiamondLeft(Point start, Point end) {
        return new Point(start.x + 6.0, start.y - 4.0, PointKind.unknown);
    }

    private Point calcGenRight(Point start, Point end) {
        return new Point(start.x + 8.0, start.y + 6.0, PointKind.unknown);
    }

    private Point calcGenLeft(Point start, Point end) {
        return new Point(start.x + 8.0, start.y - 6.0, PointKind.unknown);
    }

    private Point intersection(Point start, Point end, ClassItem box) {
        Point p = this.calculateIntersect(start.x, start.y, end.x, end.y, box.left, box.top, box.left + box.width, box.top, PointKind.top);
        if (p == null) {
            p = this.calculateIntersect(start.x, start.y, end.x, end.y, box.left, box.top + box.height, box.left + box.width, box.top + box.height, PointKind.bottom);
        }
        if (p == null) {
            p = this.calculateIntersect(start.x, start.y, end.x, end.y, box.left, box.top, box.left, box.top + box.height, PointKind.left);
        }
        if (p == null) {
            p = this.calculateIntersect(start.x, start.y, end.x, end.y, box.left + box.width, box.top, box.left + box.width, box.top + box.height, PointKind.right);
        }
        return p;
    }

    private Point calculateIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, PointKind kind) {
        Segment s1 = new Segment(new Point(x1, y1, PointKind.unknown), new Point(x2, y2, PointKind.unknown));
        Segment s2 = new Segment(new Point(x3, y3, PointKind.unknown), new Point(x4, y4, PointKind.unknown));
        return this.hasIntersection(s1, s2, kind);
    }

    public Point hasIntersection(Segment segment1, Segment segment2, PointKind kind) {
        if (segment1.isVertical) {
            if (segment2.isVertical) {
                return null;
            }
            double fx_at_segment1startx = segment2.slope * segment1.start.x - segment2.intercept;
            if (this.inBounds(fx_at_segment1startx, segment1.start.y, segment1.end.y) && this.inBounds(segment1.start.x, segment2.start.x, segment2.end.x)) {
                return new Point(segment1.start.x, fx_at_segment1startx, kind);
            }
            return null;
        }
        if (segment2.isVertical) {
            return this.hasIntersection(segment2, segment1, kind);
        }
        if (segment1.slope == segment2.slope) {
            return null;
        }
        double x4 = segment2.end.x;
        double y3 = segment2.start.y;
        double y4 = segment2.end.y;
        double x3 = segment2.start.x;
        double x2 = segment1.end.x;
        double y1 = segment1.start.y;
        double y2 = segment1.end.y;
        double x1 = segment1.start.x;
        double x = ((x4 * y3 - y4 * x3) / (x4 - x3) - (x2 * y1 - y2 * x1) / (x2 - x1)) / ((y2 - y1) / (x2 - x1) - (y4 - y3) / (x4 - x3));
        if (this.inBounds(x, x1, x2) && this.inBounds(x, x3, x4)) {
            return new Point(x, segment1.slope * x - segment1.intercept, kind);
        }
        return null;
    }

    public String buildConstraintDiagram(StructureDefinition profile) throws FHIRException, IOException {
        File f = new File(Utilities.path((String[])new String[]{this.sourceFolder, this.diagramId + ".svg"}));
        if (f.exists()) {
            this.parseSvgFile(f, f.getAbsolutePath());
        }
        this.attributes = true;
        this.innerClasses = true;
        this.constraintMode = true;
        this.classNames.add(profile.getName());
        XhtmlNode doc = new XhtmlNode(NodeType.Element, "div");
        XhtmlNode svg = doc.svg();
        this.minx = 0.0;
        this.miny = 0.0;
        StructureDefinition sd = new SnapshotGenerationPreProcessor(this.putils).trimSnapshot(profile);
        Point size = this.determineConstraintMetrics(sd);
        this.adjustAllForMin(size);
        svg.attribute("id", this.prefix + "n" + ++this.nc);
        svg.attribute("version", "1.1");
        svg.attribute("width", Double.toString(size.x));
        svg.attribute("height", Double.toString(size.y));
        this.shadowFilter(svg);
        this.drawConstraintElement(svg, sd);
        this.countDuplicateLinks();
        XhtmlNode insertionPoint = svg.getChildNodes().get(0);
        for (Link l : this.links) {
            this.drawLink(svg, l, insertionPoint);
        }
        String s = new XhtmlComposer(true, true).compose(doc.getChildNodes());
        this.produceOutput("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + s);
        return s;
    }

    private void drawConstraintElement(XhtmlNode svg, StructureDefinition sd) throws FHIRException, IOException {
        ElementDefinition ed = sd.getSnapshot().getElementFirstRep();
        StructureDefinition base = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        this.drawClass(svg, sd, ed, ed.getPath(), sd.getStandardsStatus(), base);
    }

    private Point determineConstraintMetrics(StructureDefinition sd) throws FHIRException, IOException {
        double width = this.textWidth("Element") * 1.8;
        double height = 28.0;
        Point p = new Point(0.0, 0.0, PointKind.unknown);
        ClassItem item = new ClassItem(p.x, p.y, width, height, this.diagramId, null, ClassItemMode.NORMAL);
        this.classes.put(null, item);
        double x = item.right() + 100.0;
        double y = item.bottom() + 10.0;
        ElementDefinition ed = sd.getSnapshot().getElementFirstRep();
        StructureDefinition base = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        p = this.determineMetrics(sd, ed, item, ed.getName(), null, base, ClassItemMode.NORMAL);
        x = Math.max(x, p.x + 100.0);
        y = Math.max(y, p.y + 10.0);
        return new Point(x, y, PointKind.unknown);
    }

    private class Point {
        private PointKind kind;
        private double x;
        private double y;

        public Point(double x, double y, PointKind kind) {
            this.x = x;
            this.y = y;
            this.kind = kind;
        }

        private String toPoint() {
            return Double.toString(this.x) + "," + Double.toString(this.y);
        }
    }

    private class ClassItem {
        private double left;
        private double top;
        private double width;
        private double height;
        private String id;
        private String name;
        private ClassItemMode mode;

        public ClassItem(double left, double top, double width, double height, String id, String name, ClassItemMode mode) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
            this.id = id;
            this.name = name;
            this.mode = mode;
            if (ClassDiagramRenderer.this.layout != null && ClassDiagramRenderer.this.layout.containsKey(id)) {
                this.left = ClassDiagramRenderer.this.layout.get(id).getX();
                this.top = ClassDiagramRenderer.this.layout.get(id).getY();
            }
        }

        public double right() {
            return this.left + this.width;
        }

        public double centerH() {
            return this.left + this.width / 2.0;
        }

        public double centerV() {
            return this.top + this.height / 2.0;
        }

        public double bottom() {
            return this.top + this.height;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public ClassItemMode getMode() {
            return this.mode;
        }
    }

    private class Link {
        private String path;
        private String description;
        private LinkType type;
        private ClassItem source;
        private ClassItem target;
        private String name;
        private String cardinality;
        private PointKind kind;
        private int count;
        private int index;

        public Link(ClassItem source, ClassItem target, LinkType type, String name, String cardinality, PointKind kind, String path, String description) {
            this.source = source;
            this.target = target;
            this.type = type;
            this.name = name;
            this.cardinality = cardinality;
            this.kind = kind;
            this.path = path;
            this.description = description;
        }
    }

    public static class PointSpec {
        private double x;
        private double y;

        public PointSpec(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }

    public class LinkInfo {
        private boolean use;
        private String pathData;
        private String diamondTransform;
        private String diamondPoints;
    }

    private static enum PointKind {
        unknown,
        left,
        right,
        top,
        bottom;

    }

    public static enum ClassItemMode {
        NORMAL,
        SLICE;

    }

    private class LineStatus {
        int line = 0;
        int length = 0;
        String current = "";
        List<String> list = new ArrayList<String>();

        private LineStatus() {
        }

        public String see(String s) {
            this.length += s.length();
            this.current = this.current + s;
            return s;
        }

        public void close() {
            ++this.line;
            this.list.add(this.current);
            this.length = 0;
            this.current = "";
        }

        public void check(XhtmlNode html, XhtmlNode div, double left, double top, int l, String link) throws IOException {
            if (this.length + l > 58) {
                this.close();
                html.attribute("height", Double.toString(top + 16.0 * (double)this.line));
                div.br();
                this.see("      ");
                div.nbsp();
                div.nbsp();
                div.nbsp();
                div.nbsp();
                div.nbsp();
                div.nbsp();
            }
        }
    }

    private static enum LinkType {
        SPECIALIZATION,
        CONSTRAINT,
        COMPOSITION,
        SLICE;

    }

    private class Segment {
        public final Point start;
        public final Point end;
        public final boolean isVertical;
        public final double slope;
        public final double intercept;

        public Segment(Point start, Point end) {
            this.start = start;
            this.end = end;
            this.isVertical = start.x == end.x;
            if (!this.isVertical) {
                this.slope = (this.start.y - this.end.y) / (this.start.x - this.end.x);
                this.intercept = (this.end.x * this.start.y - this.start.x * this.end.y) / (this.start.x - this.end.x);
            } else {
                this.slope = Double.MAX_VALUE;
                this.intercept = -1.7976931348623157E308;
            }
        }
    }
}

