/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class ParametersRenderer
extends ResourceRenderer {
    public ParametersRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        List<ResourceWrapper> params = r.children("parameter");
        if (params.size() < 8) {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (ResourceWrapper p : params) {
                b.append(p.primitiveValue("name"));
            }
            return this.context.formatMessage("PARS_SUMMARY_LIST", new Object[]{b.toString()});
        }
        return this.context.formatMessage("PARS_SUMMARY_SIZE", new Object[]{params.size()});
    }

    @Override
    public ParametersRenderer setMultiLangMode(boolean multiLangMode) {
        this.multiLangMode = multiLangMode;
        return this;
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        this.renderResourceTechDetails(r, x);
        x.h2().tx(this.context.formatPhrase("GENERAL_PARS", new Object[0]));
        XhtmlNode tbl = x.table("grid", false);
        this.params(status, tbl, r.children("parameter"), 0);
    }

    private void params(Renderer.RenderingStatus status, XhtmlNode tbl, List<ResourceWrapper> list, int indent) throws FHIRFormatError, DefinitionException, FHIRException, IOException, EOperationOutcome {
        for (ResourceWrapper p : list) {
            XhtmlNode tr = tbl.tr();
            XhtmlNode td = tr.td();
            for (int i = 0; i < indent; ++i) {
                td.tx(XhtmlNode.NBSP);
            }
            if (p.has("name")) {
                td.tx(p.primitiveValue("name"));
            } else {
                td.tx("???");
            }
            if (p.has("value")) {
                this.renderDataType(status, tr.td(), p.child("value"));
                continue;
            }
            if (p.has("resource")) {
                XhtmlNode x;
                ResourceWrapper m;
                String ver;
                ResourceWrapper rw = p.child("resource");
                td = tr.td();
                XhtmlNode para = td.para();
                para.tx(rw.fhirType() + "/" + rw.getId());
                this.checkAddLink(para, rw.fhirType() + "_" + rw.getId());
                this.checkAddLink(para, rw.fhirType() + "_" + rw.getScopedId());
                this.checkAddLink(para, "hc" + rw.fhirType() + "_" + rw.getId());
                this.checkAddLink(para, "hc" + rw.fhirType() + "_" + rw.getScopedId());
                if (rw.has("meta") && (ver = (m = rw.child("meta")).primitiveValue("version")) != null) {
                    this.checkAddLink(para, "hc" + rw.fhirType() + "_" + rw.getId() + "/" + ver);
                    this.checkAddLink(para, "hc" + rw.fhirType() + "_" + rw.getScopedId() + "/" + ver);
                }
                if ((x = rw.getNarrative()) != null) {
                    td.addChildren(x);
                    continue;
                }
                ResourceRenderer rr = RendererFactory.factory(rw, this.context);
                rr.buildNarrative(status, td, rw);
                continue;
            }
            if (!p.has("part")) continue;
            tr.td();
            this.params(status, tbl, p.children("part"), indent + 1);
        }
    }

    private void checkAddLink(XhtmlNode para, String anchor) {
        if (!this.context.hasAnchor(anchor)) {
            this.context.addAnchor(anchor);
            para.an(this.context.prefixAnchor(anchor)).tx(" ");
        }
    }
}

