/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.ActorDefinitionRenderer;
import org.hl7.fhir.r5.renderers.BundleRenderer;
import org.hl7.fhir.r5.renderers.CapabilityStatementRenderer;
import org.hl7.fhir.r5.renderers.CodeSystemRenderer;
import org.hl7.fhir.r5.renderers.CompartmentDefinitionRenderer;
import org.hl7.fhir.r5.renderers.ConceptMapRenderer;
import org.hl7.fhir.r5.renderers.DiagnosticReportRenderer;
import org.hl7.fhir.r5.renderers.ExampleScenarioRenderer;
import org.hl7.fhir.r5.renderers.FeatureDefinitionRenderer;
import org.hl7.fhir.r5.renderers.ImplementationGuideRenderer;
import org.hl7.fhir.r5.renderers.LibraryRenderer;
import org.hl7.fhir.r5.renderers.LiquidRenderer;
import org.hl7.fhir.r5.renderers.ListRenderer;
import org.hl7.fhir.r5.renderers.NamingSystemRenderer;
import org.hl7.fhir.r5.renderers.OperationDefinitionRenderer;
import org.hl7.fhir.r5.renderers.OperationOutcomeRenderer;
import org.hl7.fhir.r5.renderers.ParametersRenderer;
import org.hl7.fhir.r5.renderers.PatientRenderer;
import org.hl7.fhir.r5.renderers.ProfileDrivenRenderer;
import org.hl7.fhir.r5.renderers.ProvenanceRenderer;
import org.hl7.fhir.r5.renderers.QuestionnaireRenderer;
import org.hl7.fhir.r5.renderers.QuestionnaireResponseRenderer;
import org.hl7.fhir.r5.renderers.RequirementsRenderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.SearchParameterRenderer;
import org.hl7.fhir.r5.renderers.StructureDefinitionRenderer;
import org.hl7.fhir.r5.renderers.StructureMapRenderer;
import org.hl7.fhir.r5.renderers.SubscriptionTopicRenderer;
import org.hl7.fhir.r5.renderers.TestPlanRenderer;
import org.hl7.fhir.r5.renderers.ValueSetRenderer;
import org.hl7.fhir.r5.renderers.ViewDefinitionRenderer;
import org.hl7.fhir.r5.renderers.WebTemplateRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class RendererFactory {
    public static ResourceRenderer factory(String resourceName, RenderingContext context) {
        String liquidTemplate;
        if (context.getTemplateProvider() != null && (liquidTemplate = context.getTemplateProvider().findTemplate(context, resourceName)) != null) {
            return new LiquidRenderer(context, liquidTemplate);
        }
        switch (resourceName) {
            case "ActorDefinition": {
                return new ActorDefinitionRenderer(context);
            }
            case "Bundle": {
                return new BundleRenderer(context);
            }
            case "CapabilityStatement": {
                return new CapabilityStatementRenderer(context);
            }
            case "CodeSystem": {
                return new CodeSystemRenderer(context);
            }
            case "CompartmentDefinition": {
                return new CompartmentDefinitionRenderer(context);
            }
            case "ConceptMap": {
                return new ConceptMapRenderer(context);
            }
            case "DiagnosticReport": {
                return new DiagnosticReportRenderer(context);
            }
            case "ExampleScenario": {
                return new ExampleScenarioRenderer(context);
            }
            case "ImplementationGuide": {
                return new ImplementationGuideRenderer(context);
            }
            case "Library": {
                return new LibraryRenderer(context);
            }
            case "List": {
                return new ListRenderer(context);
            }
            case "NamingSystem": {
                return new NamingSystemRenderer(context);
            }
            case "OperationDefinition": {
                return new OperationDefinitionRenderer(context);
            }
            case "OperationOutcome": {
                return new OperationOutcomeRenderer(context);
            }
            case "Parameters": {
                return new ParametersRenderer(context);
            }
            case "Patient": {
                return new PatientRenderer(context);
            }
            case "Provenance": {
                return new ProvenanceRenderer(context);
            }
            case "Questionnaire": {
                return new QuestionnaireRenderer(context);
            }
            case "QuestionnaireResponse": {
                return new QuestionnaireResponseRenderer(context);
            }
            case "Requirements": {
                return new RequirementsRenderer(context);
            }
            case "SearchParameter": {
                return new SearchParameterRenderer(context);
            }
            case "StructureDefinition": {
                return new StructureDefinitionRenderer(context);
            }
            case "StructureMap": {
                return new StructureMapRenderer(context);
            }
            case "SubscriptionTopic": {
                return new SubscriptionTopicRenderer(context);
            }
            case "TestPlan": {
                return new TestPlanRenderer(context);
            }
            case "ValueSet": {
                return new ValueSetRenderer(context);
            }
            case "ViewDefinition": {
                return new ViewDefinitionRenderer(context);
            }
            case "WebTemplate": {
                return new WebTemplateRenderer(context);
            }
        }
        return new ProfileDrivenRenderer(context);
    }

    public static ResourceRenderer factory(Resource resource, RenderingContext context) {
        String liquidTemplate;
        if (context.getTemplateProvider() != null && resource instanceof DomainResource && (liquidTemplate = context.getTemplateProvider().findTemplate(context, (DomainResource)resource)) != null) {
            return new LiquidRenderer(context, liquidTemplate);
        }
        return RendererFactory.factory(resource.fhirType(), context);
    }

    public static ResourceRenderer factory(ResourceWrapper resource, RenderingContext context) {
        String liquidTemplate;
        if (context.getTemplateProvider() != null && (liquidTemplate = context.getTemplateProvider().findTemplate(context, resource.fhirType())) != null) {
            return new LiquidRenderer(context, liquidTemplate);
        }
        switch (resource.fhirType()) {
            case "DiagnosticReport": {
                return new DiagnosticReportRenderer(context);
            }
            case "Library": {
                return new LibraryRenderer(context);
            }
            case "ViewDefinition": {
                return new ViewDefinitionRenderer(context);
            }
            case "WebTemplate": {
                return new WebTemplateRenderer(context);
            }
            case "FeatureDefinition": {
                return new FeatureDefinitionRenderer(context);
            }
            case "List": {
                return new ListRenderer(context);
            }
            case "Patient": {
                return new PatientRenderer(context);
            }
            case "Provenance": {
                return new ProvenanceRenderer(context);
            }
            case "Parameters": {
                return new ParametersRenderer(context);
            }
            case "Questionnaire": {
                return new QuestionnaireRenderer(context);
            }
            case "QuestionnaireResponse": {
                return new QuestionnaireResponseRenderer(context);
            }
        }
        if (resource.isDirect()) {
            switch (resource.fhirType()) {
                case "ActorDefinition": {
                    return new ActorDefinitionRenderer(context);
                }
                case "Bundle": {
                    return new BundleRenderer(context);
                }
                case "CapabilityStatement": {
                    return new CapabilityStatementRenderer(context);
                }
                case "CodeSystem": {
                    return new CodeSystemRenderer(context);
                }
                case "CompartmentDefinition": {
                    return new CompartmentDefinitionRenderer(context);
                }
                case "ConceptMap": {
                    return new ConceptMapRenderer(context);
                }
                case "ExampleScenario": {
                    return new ExampleScenarioRenderer(context);
                }
                case "ImplementationGuide": {
                    return new ImplementationGuideRenderer(context);
                }
                case "NamingSystem": {
                    return new NamingSystemRenderer(context);
                }
                case "OperationDefinition": {
                    return new OperationDefinitionRenderer(context);
                }
                case "OperationOutcome": {
                    return new OperationOutcomeRenderer(context);
                }
                case "Requirements": {
                    return new RequirementsRenderer(context);
                }
                case "SearchParameter": {
                    return new SearchParameterRenderer(context);
                }
                case "StructureDefinition": {
                    return new StructureDefinitionRenderer(context);
                }
                case "StructureMap": {
                    return new StructureMapRenderer(context);
                }
                case "SubscriptionTopic": {
                    return new SubscriptionTopicRenderer(context);
                }
                case "TestPlan": {
                    return new TestPlanRenderer(context);
                }
                case "ValueSet": {
                    return new ValueSetRenderer(context);
                }
            }
        }
        return new ProfileDrivenRenderer(context);
    }

    public static boolean hasSpecificRenderer(String rt) {
        return Utilities.existsInList((String)rt, (String[])new String[]{"CodeSystem", "ValueSet", "ConceptMap", "CapabilityStatement", "CompartmentDefinition", "ImplementationGuide", "Library", "NamingSystem", "OperationDefinition", "Questionnaire", "SearchParameter", "StructureDefinition", "ActorDefinition", "Requirements", "TestPlan", "ExampleScenario"});
    }

    public static boolean hasIGSpecificRenderer(String rt) {
        return Utilities.existsInList((String)rt, (String[])new String[]{"ValueSet", "CapabilityStatement", "Questionnaire"});
    }
}

