/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class TestPlanRenderer
extends ResourceRenderer {
    public TestPlanRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper tp) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode ul;
        this.renderResourceTechDetails(tp, x);
        this.genSummaryTable(status, x, (CanonicalResource)tp.getResourceNative());
        XhtmlNode p = null;
        if (tp.has("contact")) {
            p = x.para();
            p.b().tx(this.context.formatPhrase("GENERAL_CONTACT", new Object[0]));
            p.tx(" (");
            boolean firsti = true;
            for (ResourceWrapper resourceWrapper : tp.children("contact")) {
                if (firsti) {
                    firsti = false;
                } else {
                    p.tx(", ");
                }
                if (resourceWrapper.has("name")) {
                    p.addText(resourceWrapper.primitiveValue("name") + ": ");
                }
                boolean first = true;
                for (ResourceWrapper c : resourceWrapper.children("telecom")) {
                    if (first) {
                        first = false;
                    } else {
                        p.tx(", ");
                    }
                    this.addTelecom(p, c);
                }
            }
            p.tx(")");
        }
        if (tp.has("category")) {
            p = x.para();
            p.b().tx(this.context.formatPhrase("TEST_PLAN_CATEGORY", new Object[0]) + " ");
            boolean first = true;
            for (ResourceWrapper resourceWrapper : tp.children("category")) {
                if (first) {
                    first = false;
                } else {
                    p.tx(", ");
                }
                this.renderCodeableConcept(status, p, resourceWrapper);
            }
        }
        if (tp.has("scope")) {
            List<ResourceWrapper> scopes = tp.children("scope");
            if (scopes.size() == 1) {
                p = x.para();
                p.b().tx(this.context.formatPhrase("TEST_PLAN_SCOPE", new Object[0]) + " ");
                this.renderReference(status, p, scopes.get(0));
            } else {
                x.para().b().tx(this.context.formatPhrase("TEST_PLAN_SCOPES", new Object[0]));
                ul = x.ul();
                for (ResourceWrapper ref : scopes) {
                    this.renderReference(status, ul.li(), ref);
                }
            }
        }
        if (tp.has("dependency")) {
            List<ResourceWrapper> deps = tp.children("dependency");
            if (deps.size() == 1) {
                ResourceWrapper dep = deps.get(0);
                p = x.para();
                p.b().tx(this.context.formatPhrase("TEST_PLAN_DEP", new Object[0]) + " ");
                XhtmlNode xhtmlNode = x.table("grid", false);
                XhtmlNode tr = xhtmlNode.tr();
                if (!Utilities.noString((String)dep.primitiveValue("description"))) {
                    this.addMarkdown(tr.td(), dep.primitiveValue("description"));
                }
                tr = xhtmlNode.tr();
                this.renderReference(status, tr.td(), dep.child("predecessor"));
            } else {
                x.para().b().tx(this.context.formatPhrase("TEST_PLAN_DEPEN", new Object[0]));
                ul = x.ul();
                Object var7_16 = null;
                for (ResourceWrapper resourceWrapper : deps) {
                    XhtmlNode xhtmlNode = ul.li();
                    if (!Utilities.noString((String)resourceWrapper.primitiveValue("description"))) {
                        this.addMarkdown(xhtmlNode, resourceWrapper.primitiveValue("description"));
                    } else {
                        xhtmlNode.addText(this.context.formatPhrase("TEST_PLAN_DESC", new Object[0]));
                    }
                    if (!resourceWrapper.has("predecessor")) continue;
                    XhtmlNode liul = xhtmlNode.ul();
                    XhtmlNode liulli = liul.li();
                    this.renderReference(status, liulli, resourceWrapper.child("predecessor"));
                }
            }
        }
        if (tp.has("exitCriteria")) {
            this.addMarkdown(x, tp.primitiveValue("exitCriteria"));
        }
        for (ResourceWrapper tc : tp.children("testCase")) {
            x.h2().addText(tc.has("sequence") ? this.formatPhrase("TEST_PLAN_CASE", new Object[0]) : this.formatPhrase("TEST_PLAN_CASE_SEQ", tc.primitiveValue("sequence")));
            if (tc.has("scope")) {
                List<ResourceWrapper> list = tc.children("scope");
                if (list.size() == 1) {
                    p = x.para();
                    p.b().tx(this.context.formatPhrase("TEST_PLAN_SCOPE", new Object[0]) + " ");
                    this.renderReference(status, p, list.get(0));
                } else {
                    x.para().b().tx(this.context.formatPhrase("TEST_PLAN_SCOPES", new Object[0]));
                    XhtmlNode ul2 = x.ul();
                    for (ResourceWrapper ref : list) {
                        this.renderReference(status, ul2.li(), ref);
                    }
                }
            }
            if (tc.has("dependency")) {
                List<ResourceWrapper> list = tc.children("dependency");
                if (list.size() == 1) {
                    ResourceWrapper dep = list.get(0);
                    x.h3().addText(this.context.formatPhrase("TEST_PLAN_DEP", new Object[0]));
                    XhtmlNode xhtmlNode = x.table("grid", false);
                    XhtmlNode tr = xhtmlNode.tr();
                    if (!Utilities.noString((String)dep.primitiveValue("description"))) {
                        this.addMarkdown(tr.td(), dep.primitiveValue("description"));
                    }
                    tr = xhtmlNode.tr();
                    this.renderReference(status, tr.td(), dep.child("predecessor"));
                } else {
                    x.h3().addText(this.context.formatPhrase("TEST_PLAN_DEPEN", new Object[0]));
                    XhtmlNode ul3 = x.ul();
                    Object var9_43 = null;
                    for (ResourceWrapper d : list) {
                        XhtmlNode xhtmlNode = ul3.li();
                        if (!Utilities.noString((String)d.primitiveValue("description"))) {
                            this.addMarkdown(xhtmlNode, d.primitiveValue("description"));
                        } else {
                            xhtmlNode.addText(this.context.formatPhrase("TEST_PLAN_DESC", new Object[0]));
                        }
                        if (!d.has("predecessor")) continue;
                        XhtmlNode liul = xhtmlNode.ul();
                        XhtmlNode liulli = liul.li();
                        this.renderReference(status, liulli, d.child("predecessor"));
                    }
                }
            }
            if (tc.has("testRun")) {
                List<ResourceWrapper> list = tc.children("testRun");
                if (list.size() == 1) {
                    x.h3().addText(this.context.formatPhrase("TEST_PLAN_RUN", new Object[0]));
                    this.renderTestRun(status, x, tp, list.get(0));
                } else {
                    int count = 0;
                    for (ResourceWrapper trun : list) {
                        x.h3().addText(this.context.formatPhrase("TEST_PLAN_TEST_RUN", new Object[]{++count}) + " ");
                        this.renderTestRun(status, x, tp, trun);
                    }
                }
            }
            if (tc.has("testData")) {
                List<ResourceWrapper> list = tc.children("testData");
                if (list.size() == 1) {
                    x.h3().addText(this.context.formatPhrase("TEST_PLAN_DATA", new Object[0]));
                    this.renderTestData(status, x, tp, list.get(0));
                } else {
                    int count = 0;
                    for (ResourceWrapper tdata : list) {
                        x.h3().addText(this.context.formatPhrase("TEST_PLAN_TEST_DATA", new Object[]{++count}) + " ");
                        this.renderTestData(status, x, tp, tdata);
                    }
                }
            }
            if (!tc.has("assertion")) continue;
            List<ResourceWrapper> list = tc.children("assertion");
            if (list.size() == 1) {
                x.h3().addText(this.context.formatPhrase("TEST_PLAN_ASS", new Object[0]));
                this.renderAssertion(status, x, tp, list.get(0));
                continue;
            }
            int count = 0;
            for (ResourceWrapper as : list) {
                x.h3().addText(this.context.formatPhrase("TEST_PLAN_ASSERTION", new Object[]{++count}) + " ");
                this.renderAssertion(status, x, tp, as);
            }
        }
    }

    private void renderTestRun(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper tp, ResourceWrapper trun) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        if (trun.hasNarrative()) {
            this.addMarkdown(x, trun.primitiveValue("narrative"));
        }
        if (trun.has("script")) {
            ResourceWrapper script = trun.child("script");
            XhtmlNode t = x.table("grid", false);
            XhtmlNode tr = t.tr();
            tr.td().b().addText(this.context.formatPhrase("TEST_PLAN_LANG", new Object[0]));
            tr.td().b().addText(this.context.formatPhrase("TEST_PLAN_SOURCE", new Object[0]));
            tr = t.tr();
            if (script.has("language")) {
                this.renderCodeableConcept(status, tr.td(), script.child("language"));
            } else {
                tr.td().addText("??");
            }
            if (script.has("source")) {
                this.renderDataType(status, tr.td(), script.child("source"));
            } else {
                tr.td().addText("??");
            }
        }
    }

    private void renderTestData(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper tp, ResourceWrapper tdata) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode t = x.table("grid", false);
        XhtmlNode tr = t.tr();
        tr.td().b().addText(this.context.formatPhrase("GENERAL_TYPE", new Object[0]));
        tr.td().b().addText(this.context.formatPhrase("GENERAL_CONTENT", new Object[0]));
        tr.td().b().addText(this.context.formatPhrase("TEST_PLAN_SOURCE", new Object[0]));
        tr = t.tr();
        if (tdata.has("type")) {
            this.renderCoding(status, tr.td(), tdata.child("type"));
        } else {
            tr.td().addText("??");
        }
        if (tdata.has("content")) {
            this.renderReference(status, tr.td(), tdata.child("content"));
        } else {
            tr.td().addText("??");
        }
        if (tdata.has("source")) {
            this.renderDataType(status, tr.td(), tdata.child("source"));
        } else {
            tr.td().addText("??");
        }
    }

    private void renderAssertion(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper tp, ResourceWrapper as) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode ul;
        XhtmlNode td;
        XhtmlNode t = x.table("grid", false);
        XhtmlNode tr = t.tr();
        tr.td().b().addText(this.context.formatPhrase("GENERAL_TYPE", new Object[0]));
        tr.td().b().addText(this.context.formatPhrase("GENERAL_CONTENT", new Object[0]));
        tr.td().b().addText(this.context.formatPhrase("TEST_PLAN_RESULT", new Object[0]));
        tr = t.tr();
        if (as.has("type")) {
            td = tr.td();
            ul = td.ul();
            for (ResourceWrapper cc : as.children("type")) {
                this.renderCodeableConcept(status, ul.li(), cc);
            }
        } else {
            tr.td().addText("??");
        }
        if (as.has("object")) {
            td = tr.td();
            ul = td.ul();
            for (ResourceWrapper cr : as.children("object")) {
                this.renderCodeableReference(status, ul.li(), cr);
            }
        } else {
            tr.td().addText("??");
        }
        if (as.has("result")) {
            td = tr.td();
            ul = td.ul();
            for (ResourceWrapper cr : as.children("result")) {
                this.renderCodeableReference(status, ul.li(), cr);
            }
        } else {
            tr.td().addText("??");
        }
    }
}

