/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.mappings;

import java.util.ArrayList;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.StructureDefinitionRenderer;
import org.hl7.fhir.r5.renderers.mappings.ModelMappingProvider;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ConceptMapMappingProvider
extends ModelMappingProvider {
    private ConceptMap map;
    private ConceptMap.ConceptMapGroupComponent grp;
    private Object eqpath;

    public ConceptMapMappingProvider(RenderingContext context, StructureDefinition dest, boolean reverse, ConceptMap map, ConceptMap.ConceptMapGroupComponent grp) {
        super(context, dest, reverse);
        this.map = map;
        this.grp = grp;
        CodeSystem cs = context.getWorker().fetchCodeSystem("http://hl7.org/fhir/concept-map-relationship");
        if (cs == null) {
            cs = context.getWorker().fetchCodeSystem("http://hl7.org/fhir/concept-map-equivalence");
        }
        this.eqpath = cs == null ? null : cs.getWebPath();
    }

    @Override
    public StructureDefinitionRenderer.Column makeColumn(String id) {
        return new StructureDefinitionRenderer.Column(id, this.map.getName(), this.dest.present(), this.map.getWebPath());
    }

    @Override
    public void render(ElementDefinition element, XhtmlNode div) {
        ArrayList<ConceptMap.TargetElementComponent> list = new ArrayList<ConceptMap.TargetElementComponent>();
        for (ConceptMap.SourceElementComponent t : this.grp.getElement()) {
            if (!t.hasCode() || !t.getCode().equals(element.getId())) continue;
            if (t.getNoMap()) {
                list.add(null);
                continue;
            }
            list.addAll(t.getTarget());
        }
        if (!list.isEmpty()) {
            if (list.size() == 1) {
                this.renderMap(div, (ConceptMap.TargetElementComponent)list.get(0));
            } else {
                XhtmlNode ul = div.ul();
                for (ConceptMap.TargetElementComponent s : list) {
                    this.renderMap(ul.li(), s);
                }
            }
        }
    }

    private void renderMap(XhtmlNode x, ConceptMap.TargetElementComponent tgt) {
        if (tgt == null) {
            x.tx("No Equivalent");
        } else {
            x.ahOrNot(this.eqpath == null ? null : String.valueOf(this.eqpath) + "#" + tgt.getRelationship().toCode()).tx(this.rel(tgt.getRelationship()));
        }
        x.tx(" ");
        x.ah(this.ref() + "#" + tgt.getCode()).tx(tgt.getCode());
        if (tgt.hasComment()) {
            XhtmlNode i = x.i();
            i.tx(" (");
            i.tx(tgt.getComment());
            i.tx(")");
        }
    }

    private String rel(Enumerations.ConceptMapRelationship rel) {
        switch (rel) {
            case EQUIVALENT: {
                return "Equivalent To";
            }
            case NOTRELATEDTO: {
                return "Not Related To";
            }
            case RELATEDTO: {
                return "Related To";
            }
            case SOURCEISBROADERTHANTARGET: {
                return "Broader than";
            }
            case SOURCEISNARROWERTHANTARGET: {
                return "Narrower than";
            }
        }
        return "??";
    }
}

