/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapperModel;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapperNative;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public abstract class ResourceWrapper {
    protected ContextUtilities contextUtils;
    protected ResourceWrapper parent;
    protected String name;
    protected int index;
    protected ElementKind kind;
    protected List<ResourceWrapper> children;

    protected ResourceWrapper() {
    }

    public static ResourceWrapper forResource(ContextUtilities contextUtils, Resource resource) {
        ResourceWrapperNative self = new ResourceWrapperNative();
        self.contextUtils = contextUtils;
        self.parent = null;
        self.name = null;
        self.index = -1;
        self.kind = ElementKind.IndependentResource;
        self.element = resource;
        return self;
    }

    public static ResourceWrapper forResource(ContextUtilities contextUtils, Element resource) {
        ResourceWrapperModel self = new ResourceWrapperModel();
        self.contextUtils = contextUtils;
        self.parent = null;
        self.name = null;
        self.index = -1;
        self.kind = ElementKind.IndependentResource;
        self.model = resource;
        return self;
    }

    public static ResourceWrapper forResource(RenderingContext context, Resource resource) {
        return ResourceWrapper.forResource(context.getContextUtilities(), resource);
    }

    public static ResourceWrapper forResource(RenderingContext context, Element resource) {
        return ResourceWrapper.forResource(context.getContextUtilities(), resource);
    }

    public static ResourceWrapper forType(ContextUtilities contextUtils, Element resource) {
        ResourceWrapperModel self = new ResourceWrapperModel();
        self.contextUtils = contextUtils;
        self.parent = null;
        self.name = null;
        self.index = -1;
        self.kind = ElementKind.DataType;
        self.model = resource;
        return self;
    }

    public static ResourceWrapper forType(ContextUtilities contextUtils, DataType type) {
        ResourceWrapperNative self = new ResourceWrapperNative();
        self.contextUtils = contextUtils;
        self.parent = null;
        self.name = null;
        self.index = -1;
        self.kind = null;
        self.element = type;
        return self;
    }

    public static ResourceWrapper forType(ContextUtilities contextUtils, ResourceWrapper parent, DataType type) {
        ResourceWrapperNative self = new ResourceWrapperNative();
        self.contextUtils = contextUtils;
        self.parent = parent;
        self.name = null;
        self.index = -1;
        self.kind = null;
        self.element = type;
        return self;
    }

    public String path() {
        if (this.parent == null) {
            return this.fhirType();
        }
        return this.parent.path() + "." + (String)(this.index == -1 ? this.name : this.name + "[" + this.index + "]");
    }

    protected String basePath() {
        if (this.parent == null || this.isResource()) {
            return this.fhirType();
        }
        return this.parent.basePath() + "." + this.name;
    }

    public ElementKind kind() {
        return this.kind;
    }

    public String name() {
        return this.name;
    }

    public int index() {
        return this.index;
    }

    public boolean isPrimitive(String name) {
        ResourceWrapper child = this.child(name);
        return child != null && child.isPrimitive();
    }

    public boolean hasPrimitiveValue(String name) {
        ResourceWrapper child = this.child(name);
        return child != null && child.hasPrimitiveValue();
    }

    public String primitiveValue(String name) {
        ResourceWrapper child = this.child(name);
        return child == null ? null : child.primitiveValue();
    }

    public String primitiveValueMN(String ... names) {
        ResourceWrapper child = this.childMN(names);
        return child == null ? null : child.primitiveValue();
    }

    public String firstPrimitiveValue(String name) {
        ResourceWrapper child = this.firstChild(name);
        return child == null ? null : child.primitiveValue();
    }

    private void loadChildren() {
        if (this.children == null) {
            this.children = new ArrayList<ResourceWrapper>();
            this.loadTheChildren();
        }
    }

    public List<ResourceWrapper> children() {
        this.loadChildren();
        return this.children;
    }

    public List<NamedResourceWrapperList> childrenInGroups() {
        this.loadChildren();
        ArrayList<NamedResourceWrapperList> list = new ArrayList<NamedResourceWrapperList>();
        for (ResourceWrapper e : this.children) {
            NamedResourceWrapperList nl = null;
            for (NamedResourceWrapperList t : list) {
                if (!t.name.equals(e.name())) continue;
                nl = t;
            }
            if (nl == null) {
                nl = new NamedResourceWrapperList(e.name());
                list.add(nl);
            }
            nl.values.add(e);
        }
        return list;
    }

    public List<ResourceWrapper> children(String name) {
        this.loadChildren();
        ArrayList<ResourceWrapper> list = new ArrayList<ResourceWrapper>();
        for (ResourceWrapper e : this.children) {
            if (!name.equals(e.name())) continue;
            list.add(e);
        }
        return list;
    }

    public List<ResourceWrapper> childrenMN(String ... names) {
        this.loadChildren();
        ArrayList<ResourceWrapper> list = new ArrayList<ResourceWrapper>();
        for (ResourceWrapper e : this.children) {
            for (String name : names) {
                if (!name.equals(e.name())) continue;
                list.add(e);
            }
        }
        return list;
    }

    public ResourceWrapper child(String name) {
        this.loadChildren();
        ResourceWrapper res = null;
        for (ResourceWrapper e : this.children) {
            if (!name.equals(e.name()) && !(name + "[x]").equals(e.name())) continue;
            if (res == null) {
                res = e;
                continue;
            }
            throw new Error("Duplicated element '" + name + "' @ '" + this.path() + "'");
        }
        return res;
    }

    public ResourceWrapper childMN(String ... names) {
        this.loadChildren();
        ResourceWrapper res = null;
        for (ResourceWrapper e : this.children) {
            for (String name : names) {
                if (!name.equals(e.name()) && !(name + "[x]").equals(e.name())) continue;
                if (res == null) {
                    res = e;
                    continue;
                }
                throw new Error("Duplicated element '" + name + "' @ '" + this.path() + "'");
            }
        }
        return res;
    }

    public boolean has(String name) {
        this.loadChildren();
        for (ResourceWrapper e : this.children) {
            if (!name.equals(e.name()) && !(name + "[x]").equals(e.name())) continue;
            return true;
        }
        return false;
    }

    public boolean hasMN(String ... names) {
        this.loadChildren();
        for (ResourceWrapper e : this.children) {
            for (String name : names) {
                if (!name.equals(e.name()) && !(name + "[x]").equals(e.name())) continue;
                return true;
            }
        }
        return false;
    }

    public ResourceWrapper resource() {
        ResourceWrapper e = this.parent;
        while (e != null && !e.isResource()) {
            e = e.parent;
        }
        return e;
    }

    public boolean hasChildren() {
        this.loadChildren();
        return !this.children.isEmpty();
    }

    public boolean hasExtension(String url) {
        this.loadChildren();
        for (ResourceWrapper e : this.children) {
            if (!"Extension".equals(e.fhirType()) || !url.equals(e.primitiveValue("url"))) continue;
            return true;
        }
        return false;
    }

    public ResourceWrapper extension(String url) {
        ResourceWrapper res = null;
        this.loadChildren();
        for (ResourceWrapper e : this.children) {
            if (!"Extension".equals(e.fhirType()) || !url.equals(e.primitiveValue("url"))) continue;
            if (res == null) {
                res = e;
                continue;
            }
            throw new Error("Duplicated extension '" + url + "' @ '" + this.path() + "'");
        }
        return res;
    }

    public ResourceWrapper extensionValue(String url) {
        ResourceWrapper res = null;
        this.loadChildren();
        for (ResourceWrapper e : this.children) {
            if (!"Extension".equals(e.fhirType()) || !url.equals(e.primitiveValue("url"))) continue;
            if (res == null) {
                res = e.child("value");
                continue;
            }
            throw new Error("Duplicated extension '" + url + "' @ '" + this.path() + "'");
        }
        return res;
    }

    public List<ResourceWrapper> extensions(String url) {
        ArrayList<ResourceWrapper> res = new ArrayList<ResourceWrapper>();
        this.loadChildren();
        for (ResourceWrapper e : this.children) {
            if (!"Extension".equals(e.fhirType()) || !url.equals(e.primitiveValue("url"))) continue;
            res.add(e);
        }
        return res;
    }

    public List<ResourceWrapper> extensions() {
        ArrayList<ResourceWrapper> res = new ArrayList<ResourceWrapper>();
        this.loadChildren();
        for (ResourceWrapper e : this.children) {
            if (!"Extension".equals(e.fhirType())) continue;
            res.add(e);
        }
        return res;
    }

    public List<ResourceWrapper> extensionValues(String url) {
        ArrayList<ResourceWrapper> res = new ArrayList<ResourceWrapper>();
        this.loadChildren();
        for (ResourceWrapper e : this.children) {
            if (!"Extension".equals(e.fhirType()) || !url.equals(e.primitiveValue("url")) || !e.has("value")) continue;
            res.add(e.child("value"));
        }
        return res;
    }

    public abstract Resource getResourceNative();

    public abstract boolean canHaveNarrative();

    public abstract XhtmlNode getNarrative();

    public abstract boolean hasNarrative();

    public abstract void setNarrative(XhtmlNode var1, String var2, boolean var3, Locale var4, boolean var5) throws IOException;

    public abstract String getId();

    public abstract boolean hasId();

    public abstract ResourceWrapper setId(String var1);

    public void markLanguage(XhtmlNode x, Locale locale) {
        x.setAttribute("lang", locale.toLanguageTag());
        x.setAttribute("xml:lang", locale.toLanguageTag());
        x.addTag(0, "hr");
        x.addTag(0, "p").b().tx(locale.getDisplayName());
        x.addTag(0, "hr");
    }

    public boolean matches(ResourceWrapper b) {
        if (this.isEmpty() || b.isEmpty()) {
            return this.isEmpty() && b.isEmpty();
        }
        if (!(!this.hasPrimitiveValue() && !b.hasPrimitiveValue() || this.hasPrimitiveValue() && b.hasPrimitiveValue() && this.primitiveValue().equals(b.primitiveValue()))) {
            return false;
        }
        if (this.children().size() != b.children().size()) {
            return false;
        }
        for (int i = 0; i < this.children().size(); ++i) {
            if (this.children().get(i).matches(b.children().get(i))) continue;
            return false;
        }
        return true;
    }

    public String extensionString(String url) {
        ResourceWrapper re = this.extensionValue(url);
        return re == null ? null : re.primitiveValue();
    }

    public boolean isEmpty() {
        if (this.hasChildren()) {
            for (ResourceWrapper c : this.children) {
                if (c.isEmpty()) continue;
                return false;
            }
        }
        return !this.isPrimitive() || !this.hasPrimitiveValue();
    }

    public ResourceWrapper getResourceWrapper() {
        ResourceWrapper focus = this;
        while (focus != null && !focus.isResource()) {
            focus = focus.parent;
        }
        return focus;
    }

    public ResourceWrapper firstChild(String name) {
        List<ResourceWrapper> list = this.children(name);
        return list.size() == 0 ? null : list.get(0);
    }

    public ContextUtilities getContextUtilities() {
        return this.contextUtils;
    }

    public String getScopedId() {
        if (!this.isResource()) {
            return null;
        }
        Object res = this.getId();
        if (this.parent != null) {
            res = this.parent.getResourceWrapper().getScopedId() + "/" + this.getId();
        }
        return res;
    }

    public ResourceWrapper parent() {
        return this.parent;
    }

    public ResourceWrapper getContained(String id) {
        if (this.isResource()) {
            List<ResourceWrapper> contained = this.children("contained");
            for (ResourceWrapper e : contained) {
                if (!id.equals(e.getId())) continue;
                return e;
            }
        }
        return null;
    }

    public abstract String getCodeSystemUri();

    public abstract boolean hasFormatComment();

    public abstract Collection<String> getFormatCommentsPre();

    public abstract XhtmlNode getXhtml();

    public abstract Base getBase();

    public abstract String getWebPath();

    public abstract boolean isDirect();

    protected abstract void loadTheChildren();

    public abstract String fhirVersion();

    public abstract String fhirType();

    public abstract boolean isPrimitive();

    public abstract boolean hasPrimitiveValue();

    public abstract String primitiveValue();

    public abstract boolean isResource();

    public abstract boolean hasUserData(String var1);

    public abstract Object getUserData(String var1);

    public static enum ElementKind {
        PrimitiveType,
        DataType,
        BackboneElement,
        ContainedResource,
        InlineResource,
        BundleEntry,
        IndependentResource;

    }

    public static class NamedResourceWrapperList {
        private String name;
        private String url;
        private List<ResourceWrapper> values = new ArrayList<ResourceWrapper>();

        public NamedResourceWrapperList(String name) {
            this.name = name;
        }

        public NamedResourceWrapperList(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public List<ResourceWrapper> getValues() {
            return this.values;
        }
    }
}

