/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.utilities.CanonicalPair;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class ConceptMapEngine {
    private SimpleWorkerContext context;

    public ConceptMapEngine(SimpleWorkerContext context) {
        this.context = context;
    }

    public Coding translate(Coding source, String url) throws FHIRException {
        ConceptMap cm = this.context.fetchResource(ConceptMap.class, url);
        if (cm == null) {
            throw new FHIRException("Unable to find ConceptMap '" + url + "'");
        }
        if (source.hasSystem()) {
            return this.translateBySystem(cm, source.getSystem(), source.getCode());
        }
        return this.translateByJustCode(cm, source.getCode());
    }

    private Coding translateByJustCode(ConceptMap cm, String code) throws FHIRException {
        ConceptMap.SourceElementComponent ct = null;
        ConceptMap.ConceptMapGroupComponent cg = null;
        for (ConceptMap.ConceptMapGroupComponent conceptMapGroupComponent : cm.getGroup()) {
            for (ConceptMap.SourceElementComponent e : conceptMapGroupComponent.getElement()) {
                if (!code.equals(e.getCode())) continue;
                if (e != null) {
                    throw new FHIRException("Unable to process translate " + code + " because multiple candidate matches were found in concept map " + cm.getUrl());
                }
                ct = e;
                cg = conceptMapGroupComponent;
            }
        }
        if (ct == null) {
            return null;
        }
        ConceptMap.TargetElementComponent tt = null;
        for (ConceptMap.TargetElementComponent t : ct.getTarget()) {
            if (t.hasDependsOn() || t.hasProduct() || !this.isOkRelationship(t.getRelationship())) continue;
            if (tt != null) {
                throw new FHIRException("Unable to process translate " + code + " because multiple targets were found in concept map " + cm.getUrl());
            }
            tt = t;
        }
        if (tt == null) {
            return null;
        }
        CanonicalPair canonicalPair = new CanonicalPair(cg.getTarget());
        return new Coding().setSystem(canonicalPair.getUrl()).setVersion(canonicalPair.getVersion()).setCode(tt.getCode()).setDisplay(tt.getDisplay());
    }

    private boolean isOkRelationship(Enumerations.ConceptMapRelationship relationship) {
        return relationship != null && relationship != Enumerations.ConceptMapRelationship.NOTRELATEDTO;
    }

    private Coding translateBySystem(ConceptMap cm, String system, String code) {
        throw new Error("Not done yet");
    }
}

