/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class TerminologyServerDetails {
    private String name;
    private ServerAuthorizationMethod auth;
    private Map<Enumerations.FHIRVersion, String> endpoints = new HashMap<Enumerations.FHIRVersion, String>();
    private List<String> codeSystems = new ArrayList<String>();

    public boolean handlesSystem(String uri, String version) {
        for (String s : this.codeSystems) {
            if (s.contains("|")) {
                String u = s.substring(0, s.lastIndexOf("|"));
                String v = s.substring(s.lastIndexOf("|") + 1);
                if (!v.equals(version) || !s.equals(uri) && !uri.matches(s)) continue;
                return true;
            }
            if (!s.equals(uri) && !uri.matches(s)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public ServerAuthorizationMethod getAuth() {
        return this.auth;
    }

    public Map<Enumerations.FHIRVersion, String> getEndpoints() {
        return this.endpoints;
    }

    public List<String> getCodeSystems() {
        return this.codeSystems;
    }

    public static enum ServerAuthorizationMethod {
        OPEN,
        TOKEN,
        SMART_ON_FHIR;

    }
}

