/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.expansion;

import java.util.List;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.expansion.ConceptFilter;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class PropertyFilter
extends ConceptFilter {
    private ValueSet.ConceptSetFilterComponent filter;
    private CodeSystem.PropertyComponent property;

    public PropertyFilter(List<String> allErrors, ValueSet.ConceptSetFilterComponent fc, CodeSystem.PropertyComponent propertyDefinition) {
        super(allErrors);
        this.filter = fc;
        this.property = propertyDefinition;
    }

    @Override
    public boolean includeConcept(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) {
        CodeSystem.ConceptPropertyComponent pc = this.getPropertyForConcept(def);
        if (pc != null) {
            String v = pc.getValue().isPrimitive() ? pc.getValue().primitiveValue() : null;
            switch (this.filter.getOp()) {
                case DESCENDENTOF: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case EQUAL: {
                    return this.filter.getValue().equals(v);
                }
                case EXISTS: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case GENERALIZES: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case IN: {
                    return Utilities.existsInListTrimmed((String)v, (String[])this.filter.getValue().split("\\,"));
                }
                case ISA: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case ISNOTA: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case NOTIN: {
                    return !Utilities.existsInListTrimmed((String)v, (String[])this.filter.getValue().split("\\,"));
                }
                case NULL: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case REGEX: {
                    return v != null && v.matches(this.filter.getValue());
                }
            }
            throw this.fail("Shouldn't get here");
        }
        return this.filter.getOp() == Enumerations.FilterOperator.NOTIN;
    }

    private CodeSystem.ConceptPropertyComponent getPropertyForConcept(CodeSystem.ConceptDefinitionComponent def) {
        for (CodeSystem.ConceptPropertyComponent pc : def.getProperty()) {
            if (!pc.hasCode() || !pc.getCode().equals(this.property.getCode())) continue;
            return pc;
        }
        return null;
    }
}

