/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.test.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyCache;
import org.hl7.fhir.r5.test.utils.TestPackageLoader;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.tests.BaseTestingUtilities;
import org.hl7.fhir.utilities.tests.TestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingUtilities
extends BaseTestingUtilities {
    private static final Logger log = LoggerFactory.getLogger(TestingUtilities.class);
    public static Map<String, SimpleWorkerContext> fcontexts;
    public static final String DEFAULT_CONTEXT_VERSION = "5.0.0";
    public static String fixedpath;
    public static String contentpath;

    public static SimpleWorkerContext getSharedWorkerContext() {
        return TestingUtilities.getSharedWorkerContext(DEFAULT_CONTEXT_VERSION);
    }

    public static SimpleWorkerContext getSharedWorkerContext(String version) {
        if (!Utilities.existsInList((String)version, (String[])new String[]{"1.0.2", "3.0.1", "4.0.1", "4.3.0", DEFAULT_CONTEXT_VERSION})) {
            throw new Error("illegal version: " + version);
        }
        String v = VersionUtilities.getMajMin((String)version);
        if (fcontexts == null) {
            fcontexts = new HashMap<String, SimpleWorkerContext>();
        }
        if (!fcontexts.containsKey(v)) {
            SimpleWorkerContext fcontext = TestingUtilities.getWorkerContext(version);
            fcontexts.put(v, fcontext);
        }
        return fcontexts.get(v);
    }

    public static SimpleWorkerContext getWorkerContext(String version) {
        try {
            FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager.Builder().build();
            SimpleWorkerContext fcontext = null;
            fcontext = VersionUtilities.isR5Ver((String)version) ? TestingUtilities.getWorkerContext(TestingUtilities.loadR5CorePackage()) : TestingUtilities.getWorkerContext(pcm.loadPackage(VersionUtilities.packageForVersion((String)version), version));
            fcontext.setUcumService((UcumService)new UcumEssenceService(TestingUtilities.loadTestResourceStream((String[])new String[]{"ucum", "ucum-essence.xml"})));
            fcontext.setExpansionParameters(new Parameters());
            if (!fcontext.hasPackage("hl7.terminology.r5", null)) {
                NpmPackage utg = pcm.loadPackage("hl7.terminology.r5");
                log.info("Loading THO: " + utg.name() + "#" + utg.version());
                fcontext.loadFromPackage(utg, new TestPackageLoader(Utilities.stringSet((String[])new String[]{"CodeSystem", "ValueSet"})));
            }
            if (!fcontext.hasPackage("hl7.fhir.uv.extensions", null)) {
                NpmPackage ext = pcm.loadPackage("hl7.fhir.uv.extensions", "5.2.0");
                log.info("Loading Extensions: " + ext.name() + "#" + ext.version());
                fcontext.loadFromPackage(ext, new TestPackageLoader(Utilities.stringSet((String[])new String[]{"CodeSystem", "ValueSet", "StructureDefinition"})));
            }
            return fcontext;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    public static NpmPackage loadR5CorePackage() throws IOException {
        return NpmPackage.fromPackage((InputStream)TestingUtilities.loadR5CorePackageSource());
    }

    private static InputStream loadR5CorePackageSource() throws IOException {
        return TestingUtilities.loadTestResourceStream((String[])new String[]{"r5", "packages", "hl7.fhir.r5.core.tgz"});
    }

    public static String getTerminologyCacheDirectory() {
        return TestConfig.getInstance().getTxCacheDirectory(new String[]{"org.hl7.fhir.r5"});
    }

    public static SimpleWorkerContext getWorkerContext(NpmPackage npmPackage) throws Exception {
        SimpleWorkerContext swc = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).withUserAgent("fhir/r5-test-cases").withTerminologyCachePath(TestingUtilities.getTerminologyCacheDirectory()).fromPackage(npmPackage);
        TerminologyCache.setCacheErrors(true);
        return swc;
    }

    public static SimpleWorkerContext getWorkerContext(NpmPackage npmPackage, IContextResourceLoader loader) throws Exception {
        SimpleWorkerContext swc = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).withUserAgent("fhir/r5-test-cases").withTerminologyCachePath(TestingUtilities.getTerminologyCacheDirectory()).fromPackage(npmPackage, loader, true);
        TerminologyCache.setCacheErrors(true);
        return swc;
    }

    public static String home() throws IOException {
        if (fixedpath != null) {
            return fixedpath;
        }
        String s = System.getenv("FHIR_HOME");
        if (!Utilities.noString((String)s)) {
            return s;
        }
        s = "C:\\work\\org.hl7.fhir\\build";
        s = "/Users/jamesagnew/git/fhir";
        if (ManagedFileAccess.file((String)s).exists()) {
            return s;
        }
        throw new Error("FHIR Home directory not configured");
    }

    public static String content() throws IOException {
        if (contentpath != null) {
            return contentpath;
        }
        String s = "R:\\fhir\\publish";
        if (ManagedFileAccess.file((String)s).exists()) {
            return s;
        }
        return Utilities.path((String[])new String[]{TestingUtilities.home(), "publish"});
    }

    public static String us() throws IOException {
        if (fixedpath != null) {
            return fixedpath;
        }
        String s = System.getenv("FHIR_HOME");
        if (!Utilities.noString((String)s)) {
            return s;
        }
        s = "C:\\work\\org.hl7.fhir.us";
        if (ManagedFileAccess.file((String)s).exists()) {
            return s;
        }
        throw new Error("FHIR US directory not configured");
    }

    public static void injectCorePackageLoader() {
        FilesystemPackageCacheManager.setPackageProvider((FilesystemPackageCacheManager.IPackageProvider)new PackageProvider());
    }

    public static boolean runningAsSurefire() {
        return "true".equals(System.getProperty("runningAsSurefire") != null ? System.getProperty("runningAsSurefire").toLowerCase(Locale.ENGLISH) : "");
    }

    public static class PackageProvider
    implements FilesystemPackageCacheManager.IPackageProvider {
        public boolean handlesPackage(String id, String version) {
            return id.equals("hl7.fhir.r5.core");
        }

        public BasePackageCacheManager.InputStreamWithSrc provide(String id, String version) throws IOException {
            return new BasePackageCacheManager.InputStreamWithSrc(TestingUtilities.loadR5CorePackageSource(), "Test Case Repository", TestingUtilities.DEFAULT_CONTEXT_VERSION);
        }
    }
}

