/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.testfactory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.liquid.BaseTableWrapper;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.profilemodel.PEDefinition;
import org.hl7.fhir.r5.profilemodel.PEType;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.testfactory.TestDataFactory;
import org.hl7.fhir.r5.testfactory.dataprovider.BaseDataTableProvider;
import org.hl7.fhir.r5.testfactory.dataprovider.TableDataProvider;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;

@MarkedToMoveToAdjunctPackage
public class ProfileBasedFactory {
    private BaseDataTableProvider baseData;
    private TableDataProvider data;
    private JsonArray mappings;
    private Map<String, TestDataFactory.DataTable> tables;
    private FHIRPathEngine fpe;
    private PrintStream log;
    private boolean testing;
    private boolean markProfile;
    private List<LogSet> logEntries = new ArrayList<LogSet>();

    public ProfileBasedFactory(FHIRPathEngine fpe, String baseDataSource) throws JsonException, IOException, SQLException {
        this.fpe = fpe;
        this.baseData = new BaseDataTableProvider(baseDataSource);
    }

    public ProfileBasedFactory(FHIRPathEngine fpe, String baseDataSource, TableDataProvider data, Map<String, TestDataFactory.DataTable> tables, JsonArray mappings) throws JsonException, IOException, SQLException {
        this.fpe = fpe;
        this.baseData = new BaseDataTableProvider(baseDataSource);
        this.data = data;
        this.tables = tables;
        this.mappings = mappings;
    }

    public byte[] generateFormat(StructureDefinition profile, Manager.FhirFormat format) throws FHIRException, IOException, SQLException {
        PEBuilder builder = new PEBuilder(this.fpe.getWorker(), PEBuilder.PEElementPropertiesPolicy.NONE, true);
        PEDefinition definition = builder.buildPEDefinition(profile);
        Element element = Manager.build(this.fpe.getWorker(), profile);
        this.log("--------------------------------");
        this.log("Build Row " + this.data.cell("counter") + " for " + profile.getVersionedUrl());
        if (this.data != null) {
            this.log("Row Data: " + CommaSeparatedStringBuilder.join((String)",", this.data.cells()));
        }
        this.populateByProfile(element, definition, 0, null, null);
        for (LogSet ls : this.logEntries) {
            this.log(ls.line.toString());
            for (String s : ls.others) {
                this.log("  " + s);
            }
        }
        this.log("--------------------------------");
        this.logEntries.clear();
        if (this.markProfile) {
            Element meta = element.forceElement("meta");
            Element prof = meta.forceElement("profile");
            prof.setValue(profile.getVersionedUrl());
        }
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        Manager.compose(this.fpe.getWorker(), element, ba, format, IParser.OutputStyle.PRETTY, null);
        return ba.toByteArray();
    }

    public Element generate(StructureDefinition profile) throws FHIRException, IOException, SQLException {
        PEBuilder builder = new PEBuilder(this.fpe.getWorker(), PEBuilder.PEElementPropertiesPolicy.NONE, true);
        PEDefinition definition = builder.buildPEDefinition(profile);
        Element element = Manager.build(this.fpe.getWorker(), profile);
        this.log("--------------------------------");
        this.log("Build Row " + this.data.cell("counter") + " for " + profile.getVersionedUrl());
        if (this.data != null) {
            this.log("Row Data: " + CommaSeparatedStringBuilder.join((String)",", this.data.cells()));
        }
        this.populateByProfile(element, definition, 0, null, null);
        for (LogSet ls : this.logEntries) {
            this.log(ls.line.toString());
            for (String s : ls.others) {
                this.log("  " + s);
            }
        }
        this.log("--------------------------------");
        this.logEntries.clear();
        return element;
    }

    protected void populateByProfile(Element element, PEDefinition definition, int level, String path, Map<String, String> values) throws SQLException, IOException {
        if (definition.types().size() == 1) {
            for (PEDefinition pe : definition.directChildren(true)) {
                if (pe.max() <= 0 || this.isIgnoredElement(pe.definition().getBase().getPath()) && !pe.hasFixedValue()) continue;
                this.populateElement(element, pe, level, path, values);
            }
        }
    }

    private boolean isIgnoredElement(String path) {
        return Utilities.existsInList((String)path, (String[])new String[]{"Identifier.assigner", "Resource.meta", "DomainResource.text", "Resource.implicitRules"});
    }

    public void populateElement(Element element, PEDefinition pe, int level, String path, Map<String, String> values) throws SQLException, IOException {
        LogSet ls = new LogSet(pe.path() + " : ");
        this.logEntries.add(ls);
        if (!pe.isExtension() && "Extension".equals(pe.typeSummary())) {
            ls.line.append("ignore unprofiled extension");
        } else if (pe.isSlicer()) {
            ls.line.append("ignore (slicer)");
        } else if (this.isNonAbstractType(pe) || pe.hasFixedValue() || pe.definition().getBase().getPath().equals("Resource.id")) {
            if (pe.hasFixedValue()) {
                DataType fv;
                Element focus = element.addElement(pe.schemaName());
                DataType dataType = fv = pe.definition().hasPattern() ? pe.definition().getPattern() : pe.definition().getFixed();
                if (fv.isPrimitive()) {
                    ls.line.append("fixed value = " + fv.primitiveValue());
                    focus.setValue(fv.primitiveValue());
                } else {
                    ls.line.append("fixed value = " + new JsonParser().setOutputStyle(IParser.OutputStyle.NORMAL).composeString(fv, "data"));
                    this.populateElementFromDataType(focus, fv, null);
                }
            } else {
                if (pe.isSlice() && values != null) {
                    values = null;
                    ls.others.add("slice, so ignore values from parent");
                }
                this.makeChildElement(element, pe, level, path, values, ls);
            }
        } else {
            ls.line.append("ignore (type = " + pe.typeSummary() + ")");
        }
    }

    private boolean isNonAbstractType(PEDefinition pe) {
        for (PEType t : pe.types()) {
            if (pe.getBuilder().getContextUtilities().isAbstractType(t.getType()) && !Utilities.existsInList((String)t.getType(), (String[])new String[]{"BackboneElement", "BackboneType"})) continue;
            return true;
        }
        return false;
    }

    public void makeChildElement(Element element, PEDefinition pe, int level, String path, Map<String, String> values, LogSet ls) throws SQLException, IOException {
        Element b = null;
        if (pe.schemaName().endsWith("[x]")) {
            if (pe.types().size() == 1) {
                b = element.makeElement(pe.schemaName().replace("[x]", Utilities.capitalize((String)pe.types().get(0).getType())));
            } else {
                String t = this.getValueType(ls, new String[]{path, pe.path(), pe.definition().getId(), pe.definition().getPath()});
                if (t == null) {
                    t = pe.types().get(this.testing ? 0 : ThreadLocalRandom.current().nextInt(0, pe.types().size())).getType();
                }
                if (t == null) {
                    ls.line.append("ignored because polymorphic and no type");
                } else {
                    b = element.makeElement(pe.schemaName().replace("[x]", Utilities.capitalize((String)t)));
                }
            }
        } else {
            b = element.makeElement(pe.schemaName());
        }
        if (b != null) {
            if (b.isPrimitive()) {
                String val = null;
                if (values != null) {
                    val = values.get(b.getName());
                    if (!(!pe.path().endsWith(".display") || this.valuesMatch(values.get("system"), b.getNamedChildValue("system")) && this.valuesMatch(values.get("code"), b.getNamedChildValue("code")))) {
                        val = "";
                    }
                }
                if (values == null || val != null || pe.min() > 0) {
                    Object cc;
                    if (val == null && this.data != null) {
                        val = this.getPrimitiveValue(ls, b.fhirType(), new String[]{path, pe.path(), pe.definition().getId(), pe.definition().getPath()});
                    }
                    if (val == null && pe.valueSet() != null && (cc = this.doExpansion(ls, pe.valueSet())) != null) {
                        val = ((ValueSet.ValueSetExpansionContainsComponent)cc).getCode();
                    }
                    if (val == null) {
                        val = this.getBasePrimitiveValue(ls, pe, (String)path, b);
                    }
                    if (val != null) {
                        if (Utilities.noString((String)val)) {
                            ls.line.append(" value suppressed");
                            element.removeChild(b);
                        } else {
                            ls.line.append("from value " + val);
                            b.setValue(val);
                        }
                    } else {
                        ls.line.append(" fake value");
                        switch (b.fhirType()) {
                            case "id": {
                                b.setValue(this.makeUUID());
                                break;
                            }
                            case "string": {
                                b.setValue("Some String value");
                                break;
                            }
                            case "base64Binary": {
                                b.setValue(Base64.getMimeEncoder().encodeToString("Some Binary Value".getBytes(StandardCharsets.UTF_8)));
                                break;
                            }
                            case "boolean": {
                                b.setValue(this.testing ? "true" : (ThreadLocalRandom.current().nextInt(0, 2) == 1 ? "true" : "false"));
                                break;
                            }
                            case "date": {
                                b.setValue(new DateType(new Date()).asStringValue());
                                break;
                            }
                            case "dateTime": {
                                b.setValue(new DateTimeType(new Date()).asStringValue());
                                break;
                            }
                            case "positiveInt": {
                                b.setValue(Integer.toString(this.testing ? 1 : ThreadLocalRandom.current().nextInt(1, 1000)));
                                break;
                            }
                            case "usignedInt": {
                                b.setValue(Integer.toString(this.testing ? 2 : ThreadLocalRandom.current().nextInt(0, 1000)));
                                break;
                            }
                            case "url": {
                                b.setValue("http://some.url/path");
                                break;
                            }
                            default: {
                                ls.others.add("Unhandled type: " + b.fhirType());
                                break;
                            }
                        }
                    }
                } else {
                    ls.line.append(" omitted - not in values");
                }
            } else {
                boolean build = true;
                if (values != null && (values = this.filterValues(values, b.getName())) == null && pe.min() == 0) {
                    build = false;
                }
                if (build) {
                    ValueSet.ValueSetExpansionContainsComponent cc;
                    if (pe.isExtension()) {
                        path = Utilities.isAbsoluteUrl((String)pe.getExtensionUrl()) || path == null ? pe.getExtensionUrl() : (String)path + "." + pe.getExtensionUrl();
                    }
                    if (values == null && this.data != null) {
                        values = this.getComplexValue(ls, b.fhirType(), new String[]{path, pe.path(), pe.definition().getId(), pe.definition().getPath()});
                    }
                    if (values == null && pe.valueSet() != null && (cc = this.doExpansion(ls, pe.valueSet())) != null) {
                        values = this.makeValuesForCodedValue(ls, b.fhirType(), cc);
                    }
                    if (values == null) {
                        if ("Reference".equals(b.fhirType()) && values == null) {
                            ArrayList<CanonicalType> targets = new ArrayList<CanonicalType>();
                            for (ElementDefinition.TypeRefComponent typeRefComponent : pe.definition().getType()) {
                                if (!typeRefComponent.getWorkingCode().equals("Reference")) continue;
                                targets.addAll(typeRefComponent.getTargetProfile());
                            }
                            ArrayList<String> choices = new ArrayList<String>();
                            for (CanonicalType ct : targets) {
                                StructureDefinition sd = this.fpe.getWorker().fetchResource(StructureDefinition.class, ct.primitiveValue());
                                if (Utilities.existsInList((String)sd.getType(), (String[])new String[]{"Resource", "DomainResource"})) continue;
                                choices.add(sd.getType());
                            }
                            if (choices.isEmpty()) {
                                choices.addAll(this.fpe.getWorker().getResourceNames());
                            }
                            String string = (String)choices.get(this.testing ? 0 : ThreadLocalRandom.current().nextInt(0, choices.size()));
                            values = new HashMap<String, String>();
                            values.put("reference", string + "/" + this.makeUUID());
                            ls.others.add("construct reference to " + string + " from choices: " + CommaSeparatedStringBuilder.join((String)"|", choices));
                        } else {
                            values = this.getBaseComplexValue(ls, pe, (String)path, b);
                        }
                    }
                    if (values == null) {
                        ls.line.append(" populate children");
                    } else if (values.isEmpty()) {
                        ls.line.append(" don't populate - no children");
                    } else {
                        ls.line.append(" populate children from " + values.toString());
                    }
                    if (values == null || !values.isEmpty()) {
                        this.populateByProfile(b, pe, level + 1, (String)path, values);
                        if (!b.hasChildren() && !b.hasValue()) {
                            element.removeChild(b);
                        }
                    } else {
                        element.removeChild(b);
                    }
                } else {
                    ls.line.append(" omitted - values have no value");
                    element.removeChild(b);
                }
            }
        }
    }

    public String makeUUID() {
        return this.testing ? "6e4d3a43-6642-4a0b-9b67-48c29af581a9" : UUID.randomUUID().toString().toLowerCase();
    }

    private boolean valuesMatch(String v1, String v2) {
        if (v1 == null) {
            return v2 == null;
        }
        return v1.equals(v2);
    }

    private boolean hasFixedChildren(PEDefinition definition) {
        if (definition.types().size() != 1) {
            return false;
        }
        for (PEDefinition pe : definition.directChildren(true)) {
            if (!pe.hasFixedValue()) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> makeValuesForCodedValue(LogSet ls, String fhirType, ValueSet.ValueSetExpansionContainsComponent cc) {
        HashMap<String, String> res = new HashMap<String, String>();
        switch (fhirType) {
            case "Coding": {
                res.put("system", cc.getSystem());
                if (cc.hasVersion()) {
                    res.put("version", cc.getVersion());
                }
                res.put("code", cc.getCode());
                if (!cc.hasDisplay()) break;
                res.put("display", cc.getDisplay());
                break;
            }
            case "CodeableConcept": {
                res.put("coding.system", cc.getSystem());
                if (cc.hasVersion()) {
                    res.put("coding.version", cc.getVersion());
                }
                res.put("coding.code", cc.getCode());
                if (!cc.hasDisplay()) break;
                res.put("coding.display", cc.getDisplay());
                break;
            }
            case "CodedReference": {
                res.put("concept.coding.system", cc.getSystem());
                if (cc.hasVersion()) {
                    res.put("concept.coding.version", cc.getVersion());
                }
                res.put("concept.coding.code", cc.getCode());
                if (!cc.hasDisplay()) break;
                res.put("concept.coding.display", cc.getDisplay());
                break;
            }
            case "Quantity": {
                res.put("system", cc.getSystem());
                res.put("code", cc.getCode());
                if (!cc.hasDisplay()) break;
                res.put("unit", cc.getDisplay());
                break;
            }
            default: {
                ls.others.add("Unknown type handling coded value: " + fhirType);
                return null;
            }
        }
        return res;
    }

    private ValueSet.ValueSetExpansionContainsComponent doExpansion(LogSet ls, ValueSet vs) {
        ValueSetExpansionOutcome vse = this.fpe.getWorker().expandVS(vs, true, false, 100);
        if (vse.isOk()) {
            ls.others.add("ValueSet " + vs.getVersionedUrl() + " " + ValueSetUtilities.countExpansion(vse.getValueset().getExpansion().getContains()) + " concepts");
            if (this.testing) {
                for (ValueSet.ValueSetExpansionContainsComponent cc : vse.getValueset().getExpansion().getContains()) {
                    ls.others.add(cc.getSystem() + "#" + cc.getCode() + " : \"" + cc.getDisplay() + "\" (" + cc.hasContains() + ")");
                }
            }
            return this.pickRandomConcept(vse.getValueset().getExpansion().getContains());
        }
        ls.others.add("ValueSet " + vs.getVersionedUrl() + ": error = " + vse.getError());
        return null;
    }

    public Map<String, String> getBaseComplexValue(LogSet ls, PEDefinition pe, String path, Element b) throws SQLException {
        Map<String, String> result = this.baseData.getComplexValue(path != null ? path : pe.definition().getId(), b.fhirType());
        if (result == null) {
            ls.others.add("No base data for " + path + ":" + b.fhirType());
        } else {
            ls.others.add("Base data for " + path + ":" + b.fhirType() + " = " + result.toString());
        }
        return result;
    }

    public String getBasePrimitiveValue(LogSet ls, PEDefinition pe, String path, Element b) throws SQLException {
        String result = this.baseData.getPrimitiveValue(path != null ? path : pe.definition().getId(), b.fhirType());
        if (result == null) {
            ls.others.add("No base data for " + path + ":" + b.fhirType());
        } else {
            ls.others.add("Base data for " + path + ":" + b.fhirType() + " = " + result);
        }
        return result;
    }

    private Map<String, String> filterValues(Map<String, String> values, String name) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : values.keySet()) {
            if (!s.startsWith(name + ".")) continue;
            result.put(s.substring(name.length() + 1), values.get(s));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private ValueSet.ValueSetExpansionContainsComponent pickRandomConcept(List<ValueSet.ValueSetExpansionContainsComponent> list) {
        ValueSet.ValueSetExpansionContainsComponent res = null;
        int i = 0;
        while (res == null && list.size() > 0) {
            int r;
            int n = r = this.testing ? i : ThreadLocalRandom.current().nextInt(0, list.size());
            if (list.get(r).getAbstract()) {
                if (list.get(r).hasContains()) {
                    res = this.pickRandomConcept(list.get(0).getContains());
                }
            } else {
                res = list.get(r);
            }
            ++i;
        }
        return res;
    }

    private void populateElementFromDataType(Element element, Base source, PEDefinition defn) {
        for (Property prop : source.children()) {
            for (Base b : prop.getValues()) {
                Element child = element.makeElement(prop.getName());
                if (b.isPrimitive()) {
                    child.setValue(b.primitiveValue());
                    continue;
                }
                this.populateElementFromDataType(child, b, null);
            }
        }
    }

    private String getValueType(LogSet ls, String ... ids) {
        JsonObject entry = this.findMatchingEntry(ls, ids);
        if (entry != null) {
            JsonElement fhirType = entry.get("fhirType");
            if (fhirType == null || !fhirType.isJsonPrimitive() || Utilities.noString((String)fhirType.asString())) {
                return "";
            }
            String ft = fhirType.asString();
            StructureDefinition sd = this.fpe.getWorker().fetchTypeDefinition(ft);
            if (sd != null) {
                return ft;
            }
            return this.evaluateExpression(ls.others, fhirType, null);
        }
        return null;
    }

    private String getPrimitiveValue(LogSet ls, String fhirType, String ... ids) {
        JsonObject entry = this.findMatchingEntry(ls, ids);
        if (entry != null) {
            JsonElement expression = entry.get("expression");
            if (expression == null || !expression.isJsonPrimitive() || Utilities.noString((String)expression.asString())) {
                ls.others.add("Found an entry for " + entry.asString("path") + " but it had no expression");
                return "";
            }
            return this.evaluateExpression(ls.others, expression, null);
        }
        return null;
    }

    public String evaluateExpression(List<String> log, JsonElement expression, String name) {
        ExpressionNode expr = (ExpressionNode)expression.getUserData("compiled");
        if (expr == null) {
            expr = this.fpe.parse(expression.asString());
            expression.setUserData("compiled", (Object)expr);
        }
        BaseTableWrapper csv = BaseTableWrapper.forRow(this.data.columns(), this.data.cells()).setTables(this.tables);
        String val = null;
        try {
            val = this.fpe.evaluateToString(null, null, null, csv, expr);
            log.add(name + " ==> '" + val + "' (from " + expr.toString() + ")");
        }
        catch (Exception e) {
            log.add(name + " ==> null because " + e.getMessage() + " (from " + expr.toString() + ")");
        }
        return val;
    }

    private JsonObject findMatchingEntry(LogSet ls, String[] ids) {
        for (JsonObject entry : this.mappings.asJsonObjects()) {
            if (!Utilities.existsInList((String)entry.asString("path"), (String[])ids)) continue;
            boolean use = true;
            if (entry.has("if")) {
                use = Utilities.existsInList((String)this.evaluateExpression(ls.others, entry.get("if"), "if"), (String[])new String[]{"1", "true"});
            }
            if (!use) continue;
            ls.others.add("mapping entry for " + entry.asString("path") + " from ids " + CommaSeparatedStringBuilder.join((String)";", (String[])ids));
            return entry;
        }
        ls.others.add("mapping entry not found for ids " + CommaSeparatedStringBuilder.join((String)";", (String[])ids));
        return null;
    }

    private Map<String, String> getComplexValue(LogSet ls, String fhirType, String ... ids) {
        HashMap<String, String> result = new HashMap<String, String>();
        JsonObject entry = this.findMatchingEntry(ls, ids);
        if (entry != null) {
            JsonArray a = entry.forceArray("parts");
            if (a.size() == 0) {
                return result;
            }
            for (JsonObject src : a.asJsonObjects()) {
                if (!src.has("name")) {
                    throw new FHIRException("Found an entry for " + entry.asString("path") + " but it had no proeprty name");
                }
                result.put(src.asString("name"), this.evaluateExpression(ls.others, src.get("expression"), src.asString("name")));
            }
        }
        return result.isEmpty() ? null : result;
    }

    private void log(String msg) throws IOException {
        if (this.log != null) {
            this.log.append(msg + "\r\n");
        }
    }

    public PrintStream getLog() {
        return this.log;
    }

    public void setLog(PrintStream log) {
        this.log = log;
    }

    public boolean isTesting() {
        return this.testing;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
        this.baseData.setTesting(testing);
    }

    public boolean isMarkProfile() {
        return this.markProfile;
    }

    public void setMarkProfile(boolean markProfile) {
        this.markProfile = markProfile;
    }

    private static class LogSet {
        private StringBuilder line = new StringBuilder();
        private List<String> others = new ArrayList<String>();

        public LogSet(String msg) {
            this.line.append(msg);
        }
    }
}

