/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.tools;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.NamedElementExtension;
import org.hl7.fhir.r5.model.Property;

@DatatypeDef(name="CDSHooksExtensions")
public class CDSHooksExtensions
extends LogicalBase
implements ICompositeType {
    @Child(name="extension", type={Base.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An extension of any type", formalDefinition="An extension where the name is defined by the extension definition, and the extension definition is of any type (including primitives, though the 'id' element cannot be represented for primitives)")
    protected List<NamedElementExtension> extensionList;
    private static final long serialVersionUID = 163508525L;

    public List<NamedElementExtension> getExtensionList() {
        if (this.extensionList == null) {
            this.extensionList = new ArrayList<NamedElementExtension>();
        }
        return this.extensionList;
    }

    public CDSHooksExtensions setExtensionList(List<NamedElementExtension> theExtension) {
        this.extensionList = theExtension;
        return this;
    }

    public boolean hasExtension() {
        if (this.extensionList == null) {
            return false;
        }
        for (NamedElementExtension item : this.extensionList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CDSHooksExtensions addExtension(NamedElementExtension t) {
        if (t == null) {
            return this;
        }
        if (this.extensionList == null) {
            this.extensionList = new ArrayList<NamedElementExtension>();
        }
        this.extensionList.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("extension", "Base", "An extension where the name is defined by the extension definition, and the extension definition is of any type (including primitives, though the 'id' element cannot be represented for primitives)", 0, Integer.MAX_VALUE, this.extensionList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -612557761: {
                return new Property("extension", "Base", "An extension where the name is defined by the extension definition, and the extension definition is of any type (including primitives, though the 'id' element cannot be represented for primitives)", 0, Integer.MAX_VALUE, this.extensionList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -612557761: {
                return this.extensionList == null ? new Base[]{} : this.extensionList.toArray(new Base[this.extensionList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -612557761: {
                this.getExtensionList().add((NamedElementExtension)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("extension")) {
            return super.setProperty(name, value);
        }
        this.getExtensionList().add((NamedElementExtension)value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -612557761: {
                throw new Error("Unable to make an instance of the abstract property 'extension'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -612557761: {
                return new String[]{"Base"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("extension")) {
            throw new FHIRException("Cannot call addChild on an abstract type CDSHooksExtensions.extension");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CDSHooksExtensions";
    }

    @Override
    public CDSHooksExtensions copy() {
        CDSHooksExtensions dst = new CDSHooksExtensions();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CDSHooksExtensions dst) {
        super.copyValues(dst);
        if (this.extensionList != null) {
            dst.extensionList = new ArrayList<NamedElementExtension>();
            for (NamedElementExtension i : this.extensionList) {
                dst.extensionList.add(i.copy());
            }
        }
    }

    protected CDSHooksExtensions typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CDSHooksExtensions)) {
            return false;
        }
        CDSHooksExtensions o = (CDSHooksExtensions)other_;
        return CDSHooksExtensions.compareDeep(this.extensionList, o.extensionList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CDSHooksExtensions)) {
            return false;
        }
        CDSHooksExtensions o = (CDSHooksExtensions)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.extensionList);
    }
}

