/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.tools;

import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.tools.CDSHookContext;
import org.hl7.fhir.r5.tools.CDSHookOrderSelectContext;
import org.hl7.fhir.r5.tools.CDSHookOrderSignContext;
import org.hl7.fhir.r5.tools.CDSHookPatientViewContext;
import org.hl7.fhir.r5.tools.CDSHooksElement;
import org.hl7.fhir.r5.tools.CDSHooksExtensions;
import org.hl7.fhir.r5.tools.CDSHooksRequest;
import org.hl7.fhir.r5.tools.CDSHooksResponse;
import org.hl7.fhir.r5.tools.CDSHooksServices;
import org.hl7.fhir.r5.tools.TestCases;
import org.hl7.fhir.utilities.xml.IXMLWriter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ToolsXmlParser
extends XmlParser {
    public ToolsXmlParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    public ToolsXmlParser(IXMLWriter xml) {
        this.xml = xml;
    }

    protected boolean parseCDSHookContextContent(int eventType, XmlPullParser xpp, CDSHookContext res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseBaseContent(eventType, xpp, res);
    }

    protected boolean parseCDSHooksElementContent(int eventType, XmlPullParser xpp, CDSHooksElement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("extension")) {
            res.setExtension(this.parseCDSHooksExtensions(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHookOrderSelectContext parseCDSHookOrderSelectContext(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHookOrderSelectContext res = new CDSHookOrderSelectContext();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHookOrderSelectContextContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHookOrderSelectContextContent(int eventType, XmlPullParser xpp, CDSHookOrderSelectContext res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("userId")) {
            res.setUserIdElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientId")) {
            res.setPatientIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounterId")) {
            res.setEncounterIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("selections")) {
            res.getSelectionsList().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("draftOrders")) {
            res.setDraftOrders(this.parseBundle(xpp));
        } else if (!this.parseCDSHookContextContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHookOrderSignContext parseCDSHookOrderSignContext(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHookOrderSignContext res = new CDSHookOrderSignContext();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHookOrderSignContextContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHookOrderSignContextContent(int eventType, XmlPullParser xpp, CDSHookOrderSignContext res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("userId")) {
            res.setUserIdElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientId")) {
            res.setPatientIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounterId")) {
            res.setEncounterIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("draftOrders")) {
            res.setDraftOrders(this.parseBundle(xpp));
        } else if (!this.parseCDSHookContextContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHookPatientViewContext parseCDSHookPatientViewContext(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHookPatientViewContext res = new CDSHookPatientViewContext();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHookPatientViewContextContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHookPatientViewContextContent(int eventType, XmlPullParser xpp, CDSHookPatientViewContext res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("userId")) {
            res.setUserIdElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientId")) {
            res.setPatientIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounterId")) {
            res.setEncounterIdElement(this.parseId(xpp));
        } else if (!this.parseCDSHookContextContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHooksExtensions parseCDSHooksExtensions(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksExtensions res = new CDSHooksExtensions();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksExtensionsContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksExtensionsContent(int eventType, XmlPullParser xpp, CDSHooksExtensions res) throws XmlPullParserException, IOException, FHIRFormatError {
        return eventType == 2 && xpp.getName().equals("extension") || this.parseBaseContent(eventType, xpp, res);
    }

    protected CDSHooksRequest parseCDSHooksRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksRequest res = new CDSHooksRequest();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksRequestContent(int eventType, XmlPullParser xpp, CDSHooksRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("hook")) {
            res.setHookElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hookInstance")) {
            res.setHookInstanceElement(this.parseUuid(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fhirServer")) {
            res.setFhirServerElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fhirAuthorization")) {
            res.setFhirAuthorization(this.parseCDSHooksRequestFhirAuthorizationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseCDSHookContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prefetch")) {
            res.getPrefetchList().add(this.parseCDSHooksRequestPrefetchComponent(xpp));
        } else if (!this.parseCDSHooksElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHookContext parseCDSHookContext(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        String xsiType = xpp.getAttributeValue("xsi", "type");
        if ("CDSHookPatientViewContext".equals(xsiType)) {
            return this.parseCDSHookPatientViewContext(xpp);
        }
        if ("CDSHookOrderSignContext".equals(xsiType)) {
            return this.parseCDSHookOrderSignContext(xpp);
        }
        if ("CDSHookOrderSelectContext".equals(xsiType)) {
            return this.parseCDSHookOrderSelectContext(xpp);
        }
        throw new FHIRFormatError("Unable to parse CDSHookContext: xsi:type '" + xsiType + "' not known");
    }

    protected CDSHooksRequest.CDSHooksRequestFhirAuthorizationComponent parseCDSHooksRequestFhirAuthorizationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksRequest.CDSHooksRequestFhirAuthorizationComponent res = new CDSHooksRequest.CDSHooksRequestFhirAuthorizationComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksRequestFhirAuthorizationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksRequestFhirAuthorizationComponentContent(int eventType, XmlPullParser xpp, CDSHooksRequest.CDSHooksRequestFhirAuthorizationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("accessToken")) {
            res.setAccessTokenElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tokenType")) {
            res.setTokenTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expiresIn")) {
            res.setExpiresInElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scope")) {
            res.setScopeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubjectElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatientElement(this.parseId(xpp));
        } else if (!this.parseCDSHooksElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHooksRequest.CDSHooksRequestPrefetchComponent parseCDSHooksRequestPrefetchComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksRequest.CDSHooksRequestPrefetchComponent res = new CDSHooksRequest.CDSHooksRequestPrefetchComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksRequestPrefetchComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksRequestPrefetchComponentContent(int eventType, XmlPullParser xpp, CDSHooksRequest.CDSHooksRequestPrefetchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("key")) {
            res.setKeyElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseResourceContained(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHooksResponse parseCDSHooksResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksResponse res = new CDSHooksResponse();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksResponseContent(int eventType, XmlPullParser xpp, CDSHooksResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("cards")) {
            res.getCardsList().add(this.parseCDSHooksResponseCardsComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("systemActions")) {
            res.getSystemActionsList().add(this.parseCDSHooksResponseCardsSuggestionsActionsComponent(xpp));
        } else if (!this.parseCDSHooksElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHooksResponse.CDSHooksResponseCardsComponent parseCDSHooksResponseCardsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksResponse.CDSHooksResponseCardsComponent res = new CDSHooksResponse.CDSHooksResponseCardsComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksResponseCardsComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksResponseCardsComponentContent(int eventType, XmlPullParser xpp, CDSHooksResponse.CDSHooksResponseCardsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uuid")) {
            res.setUuidElement(this.parseUuid(xpp));
        } else if (eventType == 2 && xpp.getName().equals("summary")) {
            res.setSummaryElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.setDetailElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("indicator")) {
            res.setIndicatorElement(this.parseEnumeration(xpp, CDSHooksResponse.CDSIndicatorCodesVS.NULL, new CDSHooksResponse.CDSIndicatorCodesVSEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseCDSHooksResponseCardsSourceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("suggestions")) {
            res.getSuggestionsList().add(this.parseCDSHooksResponseCardsSuggestionsComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("selectionBehavior")) {
            res.setSelectionBehaviorElement(this.parseEnumeration(xpp, CDSHooksResponse.CDSSelectionBehaviorCodesVS.NULL, new CDSHooksResponse.CDSSelectionBehaviorCodesVSEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("overrideReasons")) {
            res.getOverrideReasonsList().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("links")) {
            res.getLinksList().add(this.parseCDSHooksResponseCardsLinksComponent(xpp));
        } else if (!this.parseCDSHooksElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHooksResponse.CDSHooksResponseCardsSourceComponent parseCDSHooksResponseCardsSourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksResponse.CDSHooksResponseCardsSourceComponent res = new CDSHooksResponse.CDSHooksResponseCardsSourceComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksResponseCardsSourceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksResponseCardsSourceComponentContent(int eventType, XmlPullParser xpp, CDSHooksResponse.CDSHooksResponseCardsSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("icon")) {
            res.setIconElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.setTopic(this.parseCoding(xpp));
        } else if (!this.parseCDSHooksElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent parseCDSHooksResponseCardsSuggestionsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent res = new CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksResponseCardsSuggestionsComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksResponseCardsSuggestionsComponentContent(int eventType, XmlPullParser xpp, CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uuid")) {
            res.setUuidElement(this.parseUuid(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isRecommended")) {
            res.setIsRecommendedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actions")) {
            res.getActionsList().add(this.parseCDSHooksResponseCardsSuggestionsActionsComponent(xpp));
        } else if (!this.parseCDSHooksElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent parseCDSHooksResponseCardsSuggestionsActionsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent res = new CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksResponseCardsSuggestionsActionsComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksResponseCardsSuggestionsActionsComponentContent(int eventType, XmlPullParser xpp, CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, CDSHooksResponse.CDSActionTypeCodesVS.NULL, new CDSHooksResponse.CDSActionTypeCodesVSEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseResourceContained(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resourceId")) {
            res.setResourceIdElement(this.parseUrl(xpp));
        } else if (!this.parseCDSHooksElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHooksResponse.CDSHooksResponseCardsLinksComponent parseCDSHooksResponseCardsLinksComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksResponse.CDSHooksResponseCardsLinksComponent res = new CDSHooksResponse.CDSHooksResponseCardsLinksComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksResponseCardsLinksComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksResponseCardsLinksComponentContent(int eventType, XmlPullParser xpp, CDSHooksResponse.CDSHooksResponseCardsLinksComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, CDSHooksResponse.CDSLinkTypeCodesVS.NULL, new CDSHooksResponse.CDSLinkTypeCodesVSEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("appContext")) {
            res.setAppContextElement(this.parseString(xpp));
        } else if (!this.parseCDSHooksElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHooksServices parseCDSHooksServices(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksServices res = new CDSHooksServices();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksServicesContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksServicesContent(int eventType, XmlPullParser xpp, CDSHooksServices res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("services")) {
            res.getServicesList().add(this.parseCDSHooksServicesServicesComponent(xpp));
        } else if (!this.parseCDSHooksElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHooksServices.CDSHooksServicesServicesComponent parseCDSHooksServicesServicesComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksServices.CDSHooksServicesServicesComponent res = new CDSHooksServices.CDSHooksServicesServicesComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksServicesServicesComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksServicesServicesComponentContent(int eventType, XmlPullParser xpp, CDSHooksServices.CDSHooksServicesServicesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("hook")) {
            res.setHookElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("id")) {
            res.setIdElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usageRequirements")) {
            res.setUsageRequirementsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prefetch")) {
            res.getPrefetchList().add(this.parseCDSHooksServicesServicesPrefetchComponent(xpp));
        } else if (!this.parseCDSHooksElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CDSHooksServices.CDSHooksServicesServicesPrefetchComponent parseCDSHooksServicesServicesPrefetchComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CDSHooksServices.CDSHooksServicesServicesPrefetchComponent res = new CDSHooksServices.CDSHooksServicesServicesPrefetchComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCDSHooksServicesServicesPrefetchComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCDSHooksServicesServicesPrefetchComponentContent(int eventType, XmlPullParser xpp, CDSHooksServices.CDSHooksServicesServicesPrefetchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("key")) {
            res.setKeyElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestCases parseTestCases(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TestCases res = new TestCases();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestCasesContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestCasesContent(int eventType, XmlPullParser xpp, TestCases res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("runner")) {
            res.setRunnerElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.getModeList().add(this.parseTestCasesModeComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("suite")) {
            res.getSuiteList().add(this.parseTestCasesSuiteComponent(xpp));
        } else if (!this.parseResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestCases.TestCasesModeComponent parseTestCasesModeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TestCases.TestCasesModeComponent res = new TestCases.TestCasesModeComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestCasesModeComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestCasesModeComponentContent(int eventType, XmlPullParser xpp, TestCases.TestCasesModeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestCases.TestCasesSuiteComponent parseTestCasesSuiteComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TestCases.TestCasesSuiteComponent res = new TestCases.TestCasesSuiteComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestCasesSuiteComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestCasesSuiteComponentContent(int eventType, XmlPullParser xpp, TestCases.TestCasesSuiteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResourceList().add(this.parseTestCasesSuiteResourceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameterList().add(this.parseTestCasesSuiteParameterComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("test")) {
            res.getTestList().add(this.parseTestCasesSuiteTestComponent(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestCases.TestCasesSuiteResourceComponent parseTestCasesSuiteResourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TestCases.TestCasesSuiteResourceComponent res = new TestCases.TestCasesSuiteResourceComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestCasesSuiteResourceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestCasesSuiteResourceComponentContent(int eventType, XmlPullParser xpp, TestCases.TestCasesSuiteResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("file")) {
            res.setFileElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseResourceContained(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseCode(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestCases.TestCasesSuiteParameterComponent parseTestCasesSuiteParameterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TestCases.TestCasesSuiteParameterComponent res = new TestCases.TestCasesSuiteParameterComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestCasesSuiteParameterComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestCasesSuiteParameterComponentContent(int eventType, XmlPullParser xpp, TestCases.TestCasesSuiteParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseCode(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TestCases.TestCasesSuiteTestComponent parseTestCasesSuiteTestComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TestCases.TestCasesSuiteTestComponent res = new TestCases.TestCasesSuiteTestComponent();
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTestCasesSuiteTestComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTestCasesSuiteTestComponentContent(int eventType, XmlPullParser xpp, TestCases.TestCasesSuiteTestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operation")) {
            res.setOperationElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameterList().add(this.parseTestCasesSuiteParameterComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("input")) {
            res.getInputList().add(this.parseTestCasesSuiteResourceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("output")) {
            res.getOutputList().add(this.parseTestCasesSuiteResourceComponent(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    @Override
    protected Resource parseResource(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        if (xpp == null) {
            throw new IOException("xpp == null!");
        }
        if (xpp.getName().equals("TestCases")) {
            return this.parseTestCases(xpp);
        }
        throw new FHIRFormatError("Unknown resource type " + xpp.getName());
    }

    @Override
    protected DataType parseType(String prefix, XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        if (prefix == null) {
            throw new IOException("prefix == null!");
        }
        if (xpp == null) {
            throw new IOException("xpp == null!");
        }
        if (xpp.getName().equals(prefix + "Date")) {
            return this.parseDate(xpp);
        }
        if (xpp.getName().equals(prefix + "DateTime")) {
            return this.parseDateTime(xpp);
        }
        if (xpp.getName().equals(prefix + "Code")) {
            return this.parseCode(xpp);
        }
        if (xpp.getName().equals(prefix + "String")) {
            return this.parseString(xpp);
        }
        if (xpp.getName().equals(prefix + "Integer")) {
            return this.parseInteger(xpp);
        }
        if (xpp.getName().equals(prefix + "Integer64")) {
            return this.parseInteger64(xpp);
        }
        if (xpp.getName().equals(prefix + "Oid")) {
            return this.parseOid(xpp);
        }
        if (xpp.getName().equals(prefix + "Canonical")) {
            return this.parseCanonical(xpp);
        }
        if (xpp.getName().equals(prefix + "Uri")) {
            return this.parseUri(xpp);
        }
        if (xpp.getName().equals(prefix + "Uuid")) {
            return this.parseUuid(xpp);
        }
        if (xpp.getName().equals(prefix + "Url")) {
            return this.parseUrl(xpp);
        }
        if (xpp.getName().equals(prefix + "Instant")) {
            return this.parseInstant(xpp);
        }
        if (xpp.getName().equals(prefix + "Boolean")) {
            return this.parseBoolean(xpp);
        }
        if (xpp.getName().equals(prefix + "Base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (xpp.getName().equals(prefix + "UnsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (xpp.getName().equals(prefix + "Markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (xpp.getName().equals(prefix + "Time")) {
            return this.parseTime(xpp);
        }
        if (xpp.getName().equals(prefix + "Id")) {
            return this.parseId(xpp);
        }
        if (xpp.getName().equals(prefix + "PositiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (xpp.getName().equals(prefix + "Decimal")) {
            return this.parseDecimal(xpp);
        }
        throw new FHIRFormatError("Unknown type " + xpp.getName());
    }

    @Override
    protected DataType parseType(XmlPullParser xpp, String type) throws XmlPullParserException, IOException, FHIRFormatError {
        if (type == null) {
            throw new IOException("type == null!");
        }
        if (xpp == null) {
            throw new IOException("xpp == null!");
        }
        if (type.equals("date")) {
            return this.parseDate(xpp);
        }
        if (type.equals("dateTime")) {
            return this.parseDateTime(xpp);
        }
        if (type.equals("code")) {
            return this.parseCode(xpp);
        }
        if (type.equals("string")) {
            return this.parseString(xpp);
        }
        if (type.equals("integer")) {
            return this.parseInteger(xpp);
        }
        if (type.equals("integer64")) {
            return this.parseInteger64(xpp);
        }
        if (type.equals("oid")) {
            return this.parseOid(xpp);
        }
        if (type.equals("canonical")) {
            return this.parseCanonical(xpp);
        }
        if (type.equals("uri")) {
            return this.parseUri(xpp);
        }
        if (type.equals("uuid")) {
            return this.parseUuid(xpp);
        }
        if (type.equals("url")) {
            return this.parseUrl(xpp);
        }
        if (type.equals("instant")) {
            return this.parseInstant(xpp);
        }
        if (type.equals("boolean")) {
            return this.parseBoolean(xpp);
        }
        if (type.equals("base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (type.equals("unsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (type.equals("markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (type.equals("time")) {
            return this.parseTime(xpp);
        }
        if (type.equals("id")) {
            return this.parseId(xpp);
        }
        if (type.equals("positiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (type.equals("decimal")) {
            return this.parseDecimal(xpp);
        }
        throw new FHIRFormatError("Unknown type " + type);
    }

    @Override
    public Base parseFragment(XmlPullParser xpp, String type) throws XmlPullParserException, IOException, FHIRFormatError {
        if (type == null) {
            throw new IOException("type == null!");
        }
        if (xpp == null) {
            throw new IOException("xpp == null!");
        }
        if (type.equals("CDSHookOrderSelectContext")) {
            return this.parseCDSHookOrderSelectContext(xpp);
        }
        if (type.equals("CDSHookOrderSignContext")) {
            return this.parseCDSHookOrderSignContext(xpp);
        }
        if (type.equals("CDSHookPatientViewContext")) {
            return this.parseCDSHookPatientViewContext(xpp);
        }
        if (type.equals("CDSHooksExtensions")) {
            return this.parseCDSHooksExtensions(xpp);
        }
        if (type.equals("CDSHooksRequest")) {
            return this.parseCDSHooksRequest(xpp);
        }
        if (type.equals("CDSHooksResponse")) {
            return this.parseCDSHooksResponse(xpp);
        }
        if (type.equals("CDSHooksServices")) {
            return this.parseCDSHooksServices(xpp);
        }
        if (type.equals("TestCases")) {
            return this.parseTestCases(xpp);
        }
        if (type.equals("date")) {
            return this.parseDate(xpp);
        }
        if (type.equals("dateTime")) {
            return this.parseDateTime(xpp);
        }
        if (type.equals("code")) {
            return this.parseCode(xpp);
        }
        if (type.equals("string")) {
            return this.parseString(xpp);
        }
        if (type.equals("integer")) {
            return this.parseInteger(xpp);
        }
        if (type.equals("integer64")) {
            return this.parseInteger64(xpp);
        }
        if (type.equals("oid")) {
            return this.parseOid(xpp);
        }
        if (type.equals("canonical")) {
            return this.parseCanonical(xpp);
        }
        if (type.equals("uri")) {
            return this.parseUri(xpp);
        }
        if (type.equals("uuid")) {
            return this.parseUuid(xpp);
        }
        if (type.equals("url")) {
            return this.parseUrl(xpp);
        }
        if (type.equals("instant")) {
            return this.parseInstant(xpp);
        }
        if (type.equals("boolean")) {
            return this.parseBoolean(xpp);
        }
        if (type.equals("base64Binary")) {
            return this.parseBase64Binary(xpp);
        }
        if (type.equals("unsignedInt")) {
            return this.parseUnsignedInt(xpp);
        }
        if (type.equals("markdown")) {
            return this.parseMarkdown(xpp);
        }
        if (type.equals("time")) {
            return this.parseTime(xpp);
        }
        if (type.equals("id")) {
            return this.parseId(xpp);
        }
        if (type.equals("positiveInt")) {
            return this.parsePositiveInt(xpp);
        }
        if (type.equals("decimal")) {
            return this.parseDecimal(xpp);
        }
        throw new FHIRFormatError("Unknown type " + type);
    }

    private boolean nameIsTypeName(XmlPullParser xpp, String prefix) throws IOException {
        if (prefix == null) {
            throw new IOException("prefix == null!");
        }
        if (xpp == null) {
            throw new IOException("xpp == null!");
        }
        if (xpp.getName().equals(prefix + "CDSHookOrderSelectContext")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CDSHookOrderSignContext")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CDSHookPatientViewContext")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CDSHooksExtensions")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CDSHooksRequest")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CDSHooksResponse")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "CDSHooksServices")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "TestCases")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Date")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "DateTime")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Code")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "String")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Integer")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Integer64")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Oid")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Canonical")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Uri")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Uuid")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Url")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Instant")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Boolean")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Base64Binary")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "UnsignedInt")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Markdown")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Time")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "Id")) {
            return true;
        }
        if (xpp.getName().equals(prefix + "PositiveInt")) {
            return true;
        }
        return xpp.getName().equals(prefix + "Decimal");
    }

    @Override
    protected DataType parseAnyType(XmlPullParser xpp, String type) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseType(xpp, type);
    }

    protected void composeCDSHookContextElements(CDSHookContext element) throws IOException {
        this.composeBaseElements(element);
    }

    protected void composeCDSHooksElementElements(CDSHooksElement element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasExtension()) {
            this.composeCDSHooksExtensions("extension", element.getExtension());
        }
    }

    protected void composeCDSHookOrderSelectContext(String name, CDSHookOrderSelectContext element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHookOrderSelectContextElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHookOrderSelectContextElements(CDSHookOrderSelectContext element) throws IOException {
        this.composeCDSHookContextElements(element);
        if (element.hasUserIdElement()) {
            this.composeUrl("userId", element.getUserIdElement());
        }
        if (element.hasPatientIdElement()) {
            this.composeId("patientId", element.getPatientIdElement());
        }
        if (element.hasEncounterIdElement()) {
            this.composeId("encounterId", element.getEncounterIdElement());
        }
        if (element.hasSelections()) {
            for (UriType e : element.getSelectionsList()) {
                this.composeUri("selections", e);
            }
        }
        if (element.hasDraftOrders()) {
            this.composeBundle("draftOrders", element.getDraftOrders());
        }
    }

    protected void composeCDSHookOrderSignContext(String name, CDSHookOrderSignContext element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHookOrderSignContextElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHookOrderSignContextElements(CDSHookOrderSignContext element) throws IOException {
        this.composeCDSHookContextElements(element);
        if (element.hasUserIdElement()) {
            this.composeUrl("userId", element.getUserIdElement());
        }
        if (element.hasPatientIdElement()) {
            this.composeId("patientId", element.getPatientIdElement());
        }
        if (element.hasEncounterIdElement()) {
            this.composeId("encounterId", element.getEncounterIdElement());
        }
        if (element.hasDraftOrders()) {
            this.composeBundle("draftOrders", element.getDraftOrders());
        }
    }

    protected void composeCDSHookPatientViewContext(String name, CDSHookPatientViewContext element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHookPatientViewContextElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHookPatientViewContextElements(CDSHookPatientViewContext element) throws IOException {
        this.composeCDSHookContextElements(element);
        if (element.hasUserIdElement()) {
            this.composeUrl("userId", element.getUserIdElement());
        }
        if (element.hasPatientIdElement()) {
            this.composeId("patientId", element.getPatientIdElement());
        }
        if (element.hasEncounterIdElement()) {
            this.composeId("encounterId", element.getEncounterIdElement());
        }
    }

    protected void composeCDSHooksExtensions(String name, CDSHooksExtensions element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksExtensionsElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksExtensionsElements(CDSHooksExtensions element) throws IOException {
        this.composeBaseElements(element);
    }

    protected void composeCDSHooksRequest(String name, CDSHooksRequest element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksRequestElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksRequestElements(CDSHooksRequest element) throws IOException {
        this.composeCDSHooksElementElements(element);
        if (element.hasHookElement()) {
            this.composeCode("hook", element.getHookElement());
        }
        if (element.hasHookInstanceElement()) {
            this.composeUuid("hookInstance", element.getHookInstanceElement());
        }
        if (element.hasFhirServerElement()) {
            this.composeUrl("fhirServer", element.getFhirServerElement());
        }
        if (element.hasFhirAuthorization()) {
            this.composeCDSHooksRequestFhirAuthorizationComponent("fhirAuthorization", element.getFhirAuthorization());
        }
        if (element.hasContext()) {
            this.composeCDSHookContext("context", element.getContext());
        }
        if (element.hasPrefetch()) {
            for (CDSHooksRequest.CDSHooksRequestPrefetchComponent e : element.getPrefetchList()) {
                this.composeCDSHooksRequestPrefetchComponent("prefetch", e);
            }
        }
    }

    protected void composeCDSHookContext(String name, CDSHookContext element) throws IOException {
        if (element instanceof CDSHookPatientViewContext) {
            this.composeCDSHookPatientViewContext(name, (CDSHookPatientViewContext)element);
        } else if (element instanceof CDSHookOrderSignContext) {
            this.composeCDSHookOrderSignContext(name, (CDSHookOrderSignContext)element);
        } else if (element instanceof CDSHookOrderSelectContext) {
            this.composeCDSHookOrderSelectContext(name, (CDSHookOrderSelectContext)element);
        } else {
            throw new FHIRFormatError("Unable to compose CDSHookContext: Unexpected type " + element.getClass().getName());
        }
    }

    protected void composeCDSHooksRequestFhirAuthorizationComponent(String name, CDSHooksRequest.CDSHooksRequestFhirAuthorizationComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksRequestFhirAuthorizationComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksRequestFhirAuthorizationComponentElements(CDSHooksRequest.CDSHooksRequestFhirAuthorizationComponent element) throws IOException {
        if (element.hasAccessTokenElement()) {
            this.composeString("accessToken", element.getAccessTokenElement());
        }
        if (element.hasTokenTypeElement()) {
            this.composeCode("tokenType", element.getTokenTypeElement());
        }
        if (element.hasExpiresInElement()) {
            this.composeInteger("expiresIn", element.getExpiresInElement());
        }
        if (element.hasScopeElement()) {
            this.composeString("scope", element.getScopeElement());
        }
        if (element.hasSubjectElement()) {
            this.composeString("subject", element.getSubjectElement());
        }
        if (element.hasPatientElement()) {
            this.composeId("patient", element.getPatientElement());
        }
    }

    protected void composeCDSHooksRequestPrefetchComponent(String name, CDSHooksRequest.CDSHooksRequestPrefetchComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksRequestPrefetchComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksRequestPrefetchComponentElements(CDSHooksRequest.CDSHooksRequestPrefetchComponent element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasKeyElement()) {
            this.composeCode("key", element.getKeyElement());
        }
        if (element.hasValue()) {
            this.xml.enter("http://hl7.org/fhir", "value");
            this.composeResource(element.getValue());
            this.xml.exit("http://hl7.org/fhir", "value");
        }
    }

    protected void composeCDSHooksResponse(String name, CDSHooksResponse element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksResponseElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksResponseElements(CDSHooksResponse element) throws IOException {
        this.composeCDSHooksElementElements(element);
        if (element.hasCards()) {
            for (CDSHooksResponse.CDSHooksResponseCardsComponent cDSHooksResponseCardsComponent : element.getCardsList()) {
                this.composeCDSHooksResponseCardsComponent("cards", cDSHooksResponseCardsComponent);
            }
        }
        if (element.hasSystemActions()) {
            for (CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent cDSHooksResponseCardsSuggestionsActionsComponent : element.getSystemActionsList()) {
                this.composeCDSHooksResponseCardsSuggestionsActionsComponent("systemActions", cDSHooksResponseCardsSuggestionsActionsComponent);
            }
        }
    }

    protected void composeCDSHooksResponseCardsComponent(String name, CDSHooksResponse.CDSHooksResponseCardsComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksResponseCardsComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksResponseCardsComponentElements(CDSHooksResponse.CDSHooksResponseCardsComponent element) throws IOException {
        if (element.hasUuidElement()) {
            this.composeUuid("uuid", element.getUuidElement());
        }
        if (element.hasSummaryElement()) {
            this.composeString("summary", element.getSummaryElement());
        }
        if (element.hasDetailElement()) {
            this.composeMarkdown("detail", element.getDetailElement());
        }
        if (element.hasIndicatorElement()) {
            this.composeEnumeration("indicator", element.getIndicatorElement(), new CDSHooksResponse.CDSIndicatorCodesVSEnumFactory());
        }
        if (element.hasSource()) {
            this.composeCDSHooksResponseCardsSourceComponent("source", element.getSource());
        }
        if (element.hasSuggestions()) {
            for (CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent cDSHooksResponseCardsSuggestionsComponent : element.getSuggestionsList()) {
                this.composeCDSHooksResponseCardsSuggestionsComponent("suggestions", cDSHooksResponseCardsSuggestionsComponent);
            }
        }
        if (element.hasSelectionBehaviorElement()) {
            this.composeEnumeration("selectionBehavior", element.getSelectionBehaviorElement(), new CDSHooksResponse.CDSSelectionBehaviorCodesVSEnumFactory());
        }
        if (element.hasOverrideReasons()) {
            for (Coding coding : element.getOverrideReasonsList()) {
                this.composeCoding("overrideReasons", coding);
            }
        }
        if (element.hasLinks()) {
            for (CDSHooksResponse.CDSHooksResponseCardsLinksComponent cDSHooksResponseCardsLinksComponent : element.getLinksList()) {
                this.composeCDSHooksResponseCardsLinksComponent("links", cDSHooksResponseCardsLinksComponent);
            }
        }
    }

    protected void composeCDSHooksResponseCardsSourceComponent(String name, CDSHooksResponse.CDSHooksResponseCardsSourceComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksResponseCardsSourceComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksResponseCardsSourceComponentElements(CDSHooksResponse.CDSHooksResponseCardsSourceComponent element) throws IOException {
        if (element.hasLabelElement()) {
            this.composeString("label", element.getLabelElement());
        }
        if (element.hasUrlElement()) {
            this.composeUrl("url", element.getUrlElement());
        }
        if (element.hasIconElement()) {
            this.composeUrl("icon", element.getIconElement());
        }
        if (element.hasTopic()) {
            this.composeCoding("topic", element.getTopic());
        }
    }

    protected void composeCDSHooksResponseCardsSuggestionsComponent(String name, CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksResponseCardsSuggestionsComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksResponseCardsSuggestionsComponentElements(CDSHooksResponse.CDSHooksResponseCardsSuggestionsComponent element) throws IOException {
        if (element.hasLabelElement()) {
            this.composeString("label", element.getLabelElement());
        }
        if (element.hasUuidElement()) {
            this.composeUuid("uuid", element.getUuidElement());
        }
        if (element.hasIsRecommendedElement()) {
            this.composeBoolean("isRecommended", element.getIsRecommendedElement());
        }
        if (element.hasActions()) {
            for (CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent e : element.getActionsList()) {
                this.composeCDSHooksResponseCardsSuggestionsActionsComponent("actions", e);
            }
        }
    }

    protected void composeCDSHooksResponseCardsSuggestionsActionsComponent(String name, CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksResponseCardsSuggestionsActionsComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksResponseCardsSuggestionsActionsComponentElements(CDSHooksResponse.CDSHooksResponseCardsSuggestionsActionsComponent element) throws IOException {
        if (element.hasTypeElement()) {
            this.composeEnumeration("type", element.getTypeElement(), new CDSHooksResponse.CDSActionTypeCodesVSEnumFactory());
        }
        if (element.hasDescriptionElement()) {
            this.composeString("description", element.getDescriptionElement());
        }
        if (element.hasResource()) {
            this.xml.enter("http://hl7.org/fhir", "resource");
            this.composeResource(element.getResource());
            this.xml.exit("http://hl7.org/fhir", "resource");
        }
        if (element.hasResourceIdElement()) {
            this.composeUrl("resourceId", element.getResourceIdElement());
        }
    }

    protected void composeCDSHooksResponseCardsLinksComponent(String name, CDSHooksResponse.CDSHooksResponseCardsLinksComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksResponseCardsLinksComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksResponseCardsLinksComponentElements(CDSHooksResponse.CDSHooksResponseCardsLinksComponent element) throws IOException {
        if (element.hasLabelElement()) {
            this.composeString("label", element.getLabelElement());
        }
        if (element.hasUrlElement()) {
            this.composeUrl("url", element.getUrlElement());
        }
        if (element.hasTypeElement()) {
            this.composeEnumeration("type", element.getTypeElement(), new CDSHooksResponse.CDSLinkTypeCodesVSEnumFactory());
        }
        if (element.hasAppContextElement()) {
            this.composeString("appContext", element.getAppContextElement());
        }
    }

    protected void composeCDSHooksServices(String name, CDSHooksServices element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksServicesElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksServicesElements(CDSHooksServices element) throws IOException {
        this.composeCDSHooksElementElements(element);
        if (element.hasServices()) {
            for (CDSHooksServices.CDSHooksServicesServicesComponent e : element.getServicesList()) {
                this.composeCDSHooksServicesServicesComponent("services", e);
            }
        }
    }

    protected void composeCDSHooksServicesServicesComponent(String name, CDSHooksServices.CDSHooksServicesServicesComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksServicesServicesComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksServicesServicesComponentElements(CDSHooksServices.CDSHooksServicesServicesComponent element) throws IOException {
        if (element.hasHookElement()) {
            this.composeString("hook", element.getHookElement());
        }
        if (element.hasTitleElement()) {
            this.composeString("title", element.getTitleElement());
        }
        if (element.hasIdElement()) {
            this.composeCode("id", element.getIdElement());
        }
        if (element.hasDescriptionElement()) {
            this.composeString("description", element.getDescriptionElement());
        }
        if (element.hasUsageRequirementsElement()) {
            this.composeString("usageRequirements", element.getUsageRequirementsElement());
        }
        if (element.hasPrefetch()) {
            for (CDSHooksServices.CDSHooksServicesServicesPrefetchComponent e : element.getPrefetchList()) {
                this.composeCDSHooksServicesServicesPrefetchComponent("prefetch", e);
            }
        }
    }

    protected void composeCDSHooksServicesServicesPrefetchComponent(String name, CDSHooksServices.CDSHooksServicesServicesPrefetchComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeCDSHooksServicesServicesPrefetchComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeCDSHooksServicesServicesPrefetchComponentElements(CDSHooksServices.CDSHooksServicesServicesPrefetchComponent element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasKeyElement()) {
            this.composeCode("key", element.getKeyElement());
        }
        if (element.hasValueElement()) {
            this.composeString("value", element.getValueElement());
        }
    }

    protected void composeTestCases(String name, TestCases element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeTestCasesElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTestCasesElements(TestCases element) throws IOException {
        this.composeResourceElements(element);
        if (element.hasUrlElement()) {
            this.composeUri("url", element.getUrlElement());
        }
        if (element.hasVersionElement()) {
            this.composeString("version", element.getVersionElement());
        }
        if (element.hasNameElement()) {
            this.composeString("name", element.getNameElement());
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown("description", element.getDescriptionElement());
        }
        if (element.hasRunnerElement()) {
            this.composeUrl("runner", element.getRunnerElement());
        }
        if (element.hasMode()) {
            for (TestCases.TestCasesModeComponent testCasesModeComponent : element.getModeList()) {
                this.composeTestCasesModeComponent("mode", testCasesModeComponent);
            }
        }
        if (element.hasSuite()) {
            for (TestCases.TestCasesSuiteComponent testCasesSuiteComponent : element.getSuiteList()) {
                this.composeTestCasesSuiteComponent("suite", testCasesSuiteComponent);
            }
        }
    }

    protected void composeTestCasesModeComponent(String name, TestCases.TestCasesModeComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeTestCasesModeComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTestCasesModeComponentElements(TestCases.TestCasesModeComponent element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasCodeElement()) {
            this.composeString("code", element.getCodeElement());
        }
        if (element.hasDescriptionElement()) {
            this.composeString("description", element.getDescriptionElement());
        }
    }

    protected void composeTestCasesSuiteComponent(String name, TestCases.TestCasesSuiteComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeTestCasesSuiteComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTestCasesSuiteComponentElements(TestCases.TestCasesSuiteComponent element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasNameElement()) {
            this.composeString("name", element.getNameElement());
        }
        if (element.hasDescriptionElement()) {
            this.composeString("description", element.getDescriptionElement());
        }
        if (element.hasModeElement()) {
            this.composeCode("mode", element.getModeElement());
        }
        if (element.hasResource()) {
            for (TestCases.TestCasesSuiteResourceComponent testCasesSuiteResourceComponent : element.getResourceList()) {
                this.composeTestCasesSuiteResourceComponent("resource", testCasesSuiteResourceComponent);
            }
        }
        if (element.hasParameter()) {
            for (TestCases.TestCasesSuiteParameterComponent testCasesSuiteParameterComponent : element.getParameterList()) {
                this.composeTestCasesSuiteParameterComponent("parameter", testCasesSuiteParameterComponent);
            }
        }
        if (element.hasTest()) {
            for (TestCases.TestCasesSuiteTestComponent testCasesSuiteTestComponent : element.getTestList()) {
                this.composeTestCasesSuiteTestComponent("test", testCasesSuiteTestComponent);
            }
        }
    }

    protected void composeTestCasesSuiteResourceComponent(String name, TestCases.TestCasesSuiteResourceComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeTestCasesSuiteResourceComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTestCasesSuiteResourceComponentElements(TestCases.TestCasesSuiteResourceComponent element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasNameElement()) {
            this.composeString("name", element.getNameElement());
        }
        if (element.hasFileElement()) {
            this.composeString("file", element.getFileElement());
        }
        if (element.hasResource()) {
            this.xml.enter("http://hl7.org/fhir", "resource");
            this.composeResource(element.getResource());
            this.xml.exit("http://hl7.org/fhir", "resource");
        }
        if (element.hasModeElement()) {
            this.composeCode("mode", element.getModeElement());
        }
    }

    protected void composeTestCasesSuiteParameterComponent(String name, TestCases.TestCasesSuiteParameterComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeTestCasesSuiteParameterComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTestCasesSuiteParameterComponentElements(TestCases.TestCasesSuiteParameterComponent element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasNameElement()) {
            this.composeString("name", element.getNameElement());
        }
        if (element.hasValue()) {
            this.composeType("value", element.getValue());
        }
        if (element.hasModeElement()) {
            this.composeCode("mode", element.getModeElement());
        }
    }

    protected void composeTestCasesSuiteTestComponent(String name, TestCases.TestCasesSuiteTestComponent element) throws IOException {
        if (element != null) {
            this.xml.enter("http://hl7.org/fhir", name);
            this.composeTestCasesSuiteTestComponentElements(element);
            this.composeElementClose(element);
            this.xml.exit("http://hl7.org/fhir", name);
        }
    }

    protected void composeTestCasesSuiteTestComponentElements(TestCases.TestCasesSuiteTestComponent element) throws IOException {
        this.composeBaseElements(element);
        if (element.hasNameElement()) {
            this.composeString("name", element.getNameElement());
        }
        if (element.hasDescriptionElement()) {
            this.composeString("description", element.getDescriptionElement());
        }
        if (element.hasOperationElement()) {
            this.composeCode("operation", element.getOperationElement());
        }
        if (element.hasModeElement()) {
            this.composeString("mode", element.getModeElement());
        }
        if (element.hasParameter()) {
            for (TestCases.TestCasesSuiteParameterComponent testCasesSuiteParameterComponent : element.getParameterList()) {
                this.composeTestCasesSuiteParameterComponent("parameter", testCasesSuiteParameterComponent);
            }
        }
        if (element.hasInput()) {
            for (TestCases.TestCasesSuiteResourceComponent testCasesSuiteResourceComponent : element.getInputList()) {
                this.composeTestCasesSuiteResourceComponent("input", testCasesSuiteResourceComponent);
            }
        }
        if (element.hasOutput()) {
            for (TestCases.TestCasesSuiteResourceComponent testCasesSuiteResourceComponent : element.getOutputList()) {
                this.composeTestCasesSuiteResourceComponent("output", testCasesSuiteResourceComponent);
            }
        }
    }

    @Override
    protected void composeResource(Resource resource) throws IOException {
        if (resource == null) {
            throw new IOException("resource == null");
        }
        if (!(resource instanceof TestCases)) {
            throw new Error("Unhandled resource type " + resource.getClass().getName());
        }
        this.composeTestCases("TestCases", (TestCases)resource);
    }

    @Override
    protected void composeResource(String name, Resource resource) throws IOException {
        if (name == null) {
            throw new IOException("name == null");
        }
        if (resource == null) {
            throw new IOException("resource == null");
        }
        if (!(resource instanceof TestCases)) {
            throw new Error("Unhandled resource type " + resource.getClass().getName());
        }
        this.composeTestCases(name, (TestCases)resource);
    }

    @Override
    protected void composeType(String prefix, DataType type) throws IOException {
        if (prefix == null) {
            throw new IOException("prefix == null");
        }
        if (type == null) {
            throw new IOException("type == null");
        }
        if (type instanceof CodeType) {
            this.composeCode(prefix + "Code", (CodeType)type);
        } else if (type instanceof OidType) {
            this.composeOid(prefix + "Oid", (OidType)type);
        } else if (type instanceof CanonicalType) {
            this.composeCanonical(prefix + "Canonical", (CanonicalType)type);
        } else if (type instanceof UuidType) {
            this.composeUuid(prefix + "Uuid", (UuidType)type);
        } else if (type instanceof UrlType) {
            this.composeUrl(prefix + "Url", (UrlType)type);
        } else if (type instanceof UnsignedIntType) {
            this.composeUnsignedInt(prefix + "UnsignedInt", (UnsignedIntType)type);
        } else if (type instanceof MarkdownType) {
            this.composeMarkdown(prefix + "Markdown", (MarkdownType)type);
        } else if (type instanceof IdType) {
            this.composeId(prefix + "Id", (IdType)type);
        } else if (type instanceof PositiveIntType) {
            this.composePositiveInt(prefix + "PositiveInt", (PositiveIntType)type);
        } else if (type instanceof DateType) {
            this.composeDate(prefix + "Date", (DateType)type);
        } else if (type instanceof DateTimeType) {
            this.composeDateTime(prefix + "DateTime", (DateTimeType)type);
        } else if (type instanceof StringType) {
            this.composeString(prefix + "String", (StringType)type);
        } else if (type instanceof IntegerType) {
            this.composeInteger(prefix + "Integer", (IntegerType)type);
        } else if (type instanceof Integer64Type) {
            this.composeInteger64(prefix + "Integer64", (Integer64Type)type);
        } else if (type instanceof UriType) {
            this.composeUri(prefix + "Uri", (UriType)type);
        } else if (type instanceof InstantType) {
            this.composeInstant(prefix + "Instant", (InstantType)type);
        } else if (type instanceof BooleanType) {
            this.composeBoolean(prefix + "Boolean", (BooleanType)type);
        } else if (type instanceof Base64BinaryType) {
            this.composeBase64Binary(prefix + "Base64Binary", (Base64BinaryType)type);
        } else if (type instanceof TimeType) {
            this.composeTime(prefix + "Time", (TimeType)type);
        } else if (type instanceof DecimalType) {
            this.composeDecimal(prefix + "Decimal", (DecimalType)type);
        } else {
            throw new Error("Unhandled type " + type.fhirType());
        }
    }
}

