/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class ElementVisitor {
    private IElementVisitor visitor;

    public ElementVisitor(IElementVisitor visitor) {
        this.visitor = visitor;
    }

    private void visitBase(Object context, Base base) {
        for (Property p : base.children()) {
            if (!p.hasValues()) continue;
            for (Base b : p.getValues()) {
                if (b instanceof Resource) {
                    this.visit(context, (Resource)b);
                    continue;
                }
                this.visit(context, (Element)b);
            }
        }
    }

    public void visit(Object context, Resource res) {
        ElementVisitorInstruction c = this.visitor.visit(context, res);
        if (c == ElementVisitorInstruction.VISIT_CHILDREN) {
            this.visitBase(context, res);
        }
    }

    public void visit(Object context, Element e) {
        ElementVisitorInstruction c = this.visitor.visit(context, e);
        if (c == ElementVisitorInstruction.VISIT_CHILDREN) {
            this.visitBase(context, e);
        }
    }

    public static interface IElementVisitor {
        public ElementVisitorInstruction visit(Object var1, Resource var2);

        public ElementVisitorInstruction visit(Object var1, Element var2);
    }

    public static enum ElementVisitorInstruction {
        VISIT_CHILDREN,
        NO_VISIT_CHILDREN;

    }
}

