/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class ResourceMinifier {
    private static final List<String> VALIDATION_EXTENSIONS = Arrays.asList("http://hl7.org/fhir/tools/StructureDefinition/inherit-obligations", "http://hl7.org/fhir/tools/StructureDefinition/obligation-profile");

    public boolean isMinified(String resName) {
        return Utilities.existsInList((String)resName, (String[])new String[]{"StructureDefinition", "CodeSystem", "ValueSet", "CapabilityStatement", "ConceptMap", "NamingSystem", "OperationDefinition", "SearchParameter", "Questionnaire"});
    }

    public boolean minify(Resource res) {
        if (res instanceof StructureDefinition) {
            return this.minifySD((StructureDefinition)res);
        }
        if (res instanceof ValueSet) {
            this.minifyVS((ValueSet)res);
        } else if (res instanceof CodeSystem) {
            this.minifyCS((CodeSystem)res);
        } else if (res instanceof CapabilityStatement) {
            this.minifyCS((CapabilityStatement)res);
        } else if (res instanceof ConceptMap) {
            this.minifyCM((ConceptMap)res);
        } else if (res instanceof NamingSystem) {
            this.minifyNS((NamingSystem)res);
        } else if (res instanceof OperationDefinition) {
            this.minifyOD((OperationDefinition)res);
        } else if (res instanceof Questionnaire) {
            this.minifyQ((Questionnaire)res);
        } else if (res instanceof SearchParameter) {
            this.minifySP((SearchParameter)res);
        }
        return true;
    }

    private void minifySP(SearchParameter sp) {
        this.minCR(sp);
    }

    private void minifyQ(Questionnaire q) {
        this.minCR(q);
        q.setApprovalDate(null);
        q.setLastReviewDate(null);
        q.setEffectivePeriod(null);
        q.setCode(null);
        for (Questionnaire.QuestionnaireItemComponent item : q.getItem()) {
            this.minifyQItem(item);
        }
    }

    private void minifyQItem(Questionnaire.QuestionnaireItemComponent item) {
        item.setCode(null);
        item.setPrefix(null);
        item.setText(null);
        for (Questionnaire.QuestionnaireItemComponent child : item.getItem()) {
            this.minifyQItem(child);
        }
    }

    private void minifyOD(OperationDefinition od) {
        this.minCR(od);
        od.setComment(null);
        for (OperationDefinition.OperationDefinitionParameterComponent p : od.getParameter()) {
            this.minifyODP(p);
        }
        for (OperationDefinition.OperationDefinitionOverloadComponent ol : od.getOverload()) {
            ol.setComment(null);
        }
    }

    private void minifyODP(OperationDefinition.OperationDefinitionParameterComponent p) {
        p.setDocumentation(null);
        for (OperationDefinition.OperationDefinitionParameterComponent pp : p.getPart()) {
            this.minifyODP(pp);
        }
    }

    private void minifyNS(NamingSystem ns) {
        this.minCR(ns);
        ns.setApprovalDate(null);
        ns.setLastReviewDate(null);
        ns.setEffectivePeriod(null);
        ns.setTopic((List)null);
        ns.setAuthor((List)null);
        ns.setEditor((List)null);
        ns.setReviewer((List)null);
        ns.setEndorser((List)null);
        ns.setRelatedArtifact((List)null);
        ns.setUsage(null);
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            id.setComment(null);
        }
    }

    private void minifyCM(ConceptMap cm) {
        this.minCR(cm);
        cm.setApprovalDate(null);
        cm.setLastReviewDate(null);
        cm.setEffectivePeriod(null);
        cm.setTopic((List)null);
        cm.setAuthor((List)null);
        cm.setEditor((List)null);
        cm.setReviewer((List)null);
        cm.setEndorser((List)null);
        cm.setRelatedArtifact((List)null);
        for (ConceptMap.PropertyComponent prop : cm.getProperty()) {
            prop.setDescription(null);
        }
        for (ConceptMap.AdditionalAttributeComponent attr : cm.getAdditionalAttribute()) {
            attr.setDescription(null);
        }
        for (ConceptMap.ConceptMapGroupComponent group : cm.getGroup()) {
            for (ConceptMap.SourceElementComponent elem : group.getElement()) {
                for (ConceptMap.TargetElementComponent tgt : elem.getTarget()) {
                    tgt.setComment(null);
                }
            }
        }
    }

    private void minifyCS(CapabilityStatement cs) {
        this.minCR(cs);
        cs.setSoftware(null);
        cs.setImplementation(null);
        for (CapabilityStatement.CapabilityStatementRestComponent rest : cs.getRest()) {
            rest.setDocumentation(null);
            rest.setSecurity(null);
            for (CapabilityStatement.CapabilityStatementRestResourceComponent res : rest.getResource()) {
                res.setDocumentation(null);
                for (CapabilityStatement.ResourceInteractionComponent intr : res.getInteraction()) {
                    intr.setDocumentation(null);
                }
                for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent srch : res.getSearchParam()) {
                    srch.setDocumentation(null);
                }
                for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent op : res.getOperation()) {
                    op.setDocumentation(null);
                }
            }
            for (CapabilityStatement.SystemInteractionComponent intr : rest.getInteraction()) {
                intr.setDocumentation(null);
            }
            for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent srch : rest.getSearchParam()) {
                srch.setDocumentation(null);
            }
            for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent op : rest.getOperation()) {
                op.setDocumentation(null);
            }
        }
        cs.setMessaging(null);
        cs.setDocument(null);
    }

    private void minifyCS(CodeSystem cs) {
        this.minCR(cs);
        cs.setApprovalDate(null);
        cs.setLastReviewDate(null);
        cs.setEffectivePeriod(null);
        cs.setTopic((List)null);
        cs.setAuthor((List)null);
        cs.setEditor((List)null);
        cs.setReviewer((List)null);
        cs.setEndorser((List)null);
        cs.setRelatedArtifact((List)null);
        for (CodeSystem.CodeSystemFilterComponent filter : cs.getFilter()) {
            filter.setDescription(null);
        }
        for (CodeSystem.PropertyComponent prop : cs.getProperty()) {
            prop.setDescription(null);
        }
        for (CodeSystem.ConceptDefinitionComponent cc : cs.getConcept()) {
            this.minify(cc);
        }
    }

    private void minify(CodeSystem.ConceptDefinitionComponent cc) {
        cc.setDefinition(null);
        for (CodeSystem.ConceptDefinitionComponent ccc : cc.getConcept()) {
            this.minify(ccc);
        }
    }

    private void minifyVS(ValueSet vs) {
        this.minCR(vs);
        vs.setApprovalDate(null);
        vs.setLastReviewDate(null);
        vs.setEffectivePeriod(null);
        vs.setTopic((List)null);
        vs.setAuthor((List)null);
        vs.setEditor((List)null);
        vs.setReviewer((List)null);
        vs.setEndorser((List)null);
        vs.setRelatedArtifact((List)null);
    }

    private boolean minifySD(StructureDefinition sd) {
        if (sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) {
            return false;
        }
        this.minCR(sd);
        sd.setKeyword(null);
        sd.setMapping(null);
        if (sd.hasDifferential()) {
            sd.setSnapshot(null);
        }
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            this.minifyED(ed);
        }
        return true;
    }

    private void minifyED(ElementDefinition ed) {
        ed.setLabel(null);
        ed.setCode(null);
        ed.getSlicing().setDescription(null);
        ed.setShort(null);
        ed.setDefinition(null);
        ed.setComment(null);
        ed.setRequirements(null);
        ed.setAlias(null);
        ed.setDefaultValue(null);
        ed.setOrderMeaning(null);
        ed.setMeaningWhenMissing(null);
        ed.setExample(null);
        ed.setIsModifierReason(null);
        ed.getBinding().setDescription(null);
        for (ElementDefinition.ElementDefinitionBindingAdditionalComponent abn : ed.getBinding().getAdditional()) {
            abn.setDocumentation(null);
            abn.setShortDoco(null);
        }
        ed.setMapping(null);
        ed.setMustSupportElement(null);
    }

    private void minCR(CanonicalResource cr) {
        this.minDR(cr);
        cr.setIdentifier(null);
        cr.setPublisher(null);
        cr.setContact(null);
        cr.setDescription(null);
        cr.setPurpose(null);
        cr.setCopyright(null);
        cr.setCopyrightLabel(null);
    }

    private void minDR(DomainResource dr) {
        this.minRes(dr);
        dr.setText(null);
        ArrayList<Resource> del = new ArrayList<Resource>();
        for (Resource res : dr.getContained()) {
            if (this.isMinified(res.fhirType())) {
                this.minify(res);
                continue;
            }
            del.add(res);
        }
        dr.getContained().removeAll(del);
        dr.getExtension().removeIf(ext -> !Utilities.existsInList((String)ext.getUrl(), VALIDATION_EXTENSIONS));
    }

    private void minRes(Resource res) {
        res.setMeta(null);
        res.setImplicitRules(null);
    }
}

